#include <stdlib.h>
#include <unistd.h>
#include "libopgp.h"

/* replace this if you have better */
char *(*PGP_gpph) (const char *) = getpass;
/*------------------------------------*/
/* string to key and initialize conventional encryption */
int PGP_gts2k(UCHAR ** bp, UCHAR * passph, void **ccfb)
{
  unsigned int i = 0, j, k = 0, ca, ha, sa, tag;
  UCHAR hbuf[256], hkobuf[256];

  tag = *(*bp)++;               /* application */
  if (tag == 0)
    return 0;
  if (!passph || !passph[0])
    passph = (*PGP_gpph) ("Passphrase:");

  if (tag < 4)
    ca = tag, ha = 1, sa = 0;
  else
    ca = *(*bp)++, sa = *(*bp)++, ha = *(*bp)++;  /* crypto, salt, hash type */

  if (sa & 1) {
    memcpy(hbuf, *bp, 8);       /* salt */
    memcpy(&hbuf[8], passph, strlen(passph));
    *bp += 8;
    k = 8 + strlen(passph);
    i = k;
  }
  switch (sa) {
  case 3:
    j = *(*bp)++;               /* postfix - hash size */
    i = (16 + (j & 15)) << ((j >> 4) + 6);
    break;
  case 0:
    memcpy(hbuf, passph, strlen(passph));
    i = strlen(passph);
    k = i;
    break;
  case 1:
    break;
  default:
    return -1;
  }

  if ((sa == 3) && i < strlen(passph) + 8)
    i = strlen(passph) + 8;

  PGP_khash(ha, i, k, PGP_cksz(ca), hbuf, hkobuf);

  if (tag == 0xff || tag < 4) {
    memcpy(hbuf, *bp, 8);
    *bp += 8;
  } else
    memset(hbuf, 0, 8);

  *ccfb = PGP_cini(hkobuf, hbuf, ca, 0);
  return tag;
}
