#include <rand.h>
#include "libopgp.h"

int PGP_s2kha = 2, PGP_s2ksa = 3, PGP_s2kca = 3;
int PGP_s2kic = 0x60;           /* itcnt: 0xPQ becomes (1024 + Q*64 ) * 2**P */

/*------------------------------------*/
/* for secret keys only - inverse of getcfbkey */
int PGP_wrs2k(UCHAR * obuf, const UCHAR * passph, UCHAR tag, void **ccfb)
{
  unsigned int i = 0, k, len;
  UCHAR ivbuf[8], hbuf[256], hkobuf[256];

  if (!passph) {
    *obuf++ = 0;
    *ccfb = NULL;
    return 1;
  }
  if (tag < 4)
    PGP_s2kca = tag, PGP_s2kha = 1, PGP_s2ksa = 0, len = 1, *obuf++ = 1;
  else
    *obuf++ = tag, len = 4,
      *obuf++ = PGP_s2kca, *obuf++ = PGP_s2ksa, *obuf++ = PGP_s2kha;

  k = strlen(passph);

  if (PGP_s2ksa && PGP_s2ksa != 2) {
    RAND_bytes(hbuf, 8);        /* salt */
    memcpy(obuf, hbuf, 8);
    memcpy(&hbuf[8], passph, strlen(passph));
    obuf += 8, k += 8, len += 8;
  } else
    memcpy(hbuf, passph, strlen(passph));

  switch (PGP_s2ksa) {
  case 3:
    *obuf++ = PGP_s2kic;
    len++;
    i = (16 + (PGP_s2kic & 15)) << ((PGP_s2kic >> 4) + 6);
    break;
  case 2:
    exit(-1);
  case 1:
  case 0:
    i = k;
    break;
  }
  if ((PGP_s2ksa == 3) && i < strlen(passph) + 8)
    i = strlen(passph) + 8;

  PGP_khash(PGP_s2kha, i, k, PGP_cksz(PGP_s2kca), hbuf, hkobuf);

  if (tag == 0xff || tag < 4) {
    RAND_bytes(ivbuf, 8);
    memcpy(obuf, ivbuf, 8);
    len += 8;
  } else
    memset(ivbuf, 0, 8);

  *ccfb = PGP_cini(hkobuf, ivbuf, PGP_s2kca, 1);
  memset(hkobuf, 0, 256);
  return len;                   /* LEN - currently fixed */
}
