#include <stdio.h>
#include <zlib.h>
#include <string.h>

#define NTPKTP 12
#define NTPSIZ (1<<NTPKTP)

#define OBSIZ (8128+NTPSIZ*2)
#define IBSIZ 10240
int PGP_zip(FILE * inf, FILE * outf, int v2flg)
{
  z_stream pgpz;
  int readgot, isav;
  unsigned char ibuf[IBSIZ], obuf[OBSIZ];

  memset(&pgpz, 0, sizeof(pgpz));
  fputc(v2flg ? 0xa3 : 0xc8, outf);
  obuf[0] = 1;
  pgpz.next_out = obuf + 1, pgpz.avail_out = OBSIZ - 1;

  deflateInit2(&pgpz, Z_DEFAULT_COMPRESSION, Z_DEFLATED,
               v2flg ? -13 : -15, 8, 0);

  readgot = IBSIZ;
  while (!feof(inf) && readgot == IBSIZ) {
    if (0 >= (readgot = fread(ibuf, 1, IBSIZ, inf)))
      break;
    pgpz.next_in = ibuf;
    pgpz.avail_in = readgot;
    while (pgpz.avail_in || readgot != IBSIZ) {
      isav = deflate(&pgpz, readgot == IBSIZ ? 0 : Z_FINISH);
      while (OBSIZ - pgpz.avail_out >= 8128 + NTPSIZ * (readgot == IBSIZ)) {
        if (!v2flg)
          fputc(0xe0 + NTPKTP, outf);
        fwrite(obuf, 1, NTPSIZ, outf);
        memmove(obuf, &obuf[NTPSIZ], OBSIZ - pgpz.avail_out - NTPSIZ);
        pgpz.avail_out += NTPSIZ;
        pgpz.next_out -= NTPSIZ;
      }
      if (isav != Z_OK)
        break;
    }
  }
  if (!v2flg) {
    if (OBSIZ - pgpz.avail_out > 192) {
      fputc(0xc0 | ((OBSIZ - pgpz.avail_out - 192) >> 8), outf);
      fputc(OBSIZ - pgpz.avail_out - 192, outf);
    } else
      fputc(OBSIZ - pgpz.avail_out, outf);
  }
  fwrite(obuf, 1, OBSIZ - pgpz.avail_out, outf);
  return 0;
}
