// PGPBase64OutputStream.java

import java.io.*;

public class PGPBase64OutputStream extends Base64OutputStream {
static final String sVersion = "2.6";
DataOutputStream dataos;
String type;

public PGPBase64OutputStream(OutputStream os, String type)
    throws IOException
{
    super(os, true);
    this.type = type;
    dataos = (os instanceof DataOutputStream)?(DataOutputStream)os:
    		new DataOutputStream(os);
    dataos.writeBytes("-----BEGIN PGP "+type+"-----\nVersion: "+
		      sVersion+"\n\n");
}


public void close() throws IOException
{
    super.close();
    dataos.writeBytes("-----END PGP "+type+"-----\n");
}

}
