/*
 ***********************************************************************
 ** md5.c -- the source code for MD5 routines                         **
 ** RSA Data Security, Inc. MD5 Message-Digest Algorithm              **
 ** Created: 2/17/90 RLR                                              **
 ** Revised: 1/91 SRD,AJ,BSK,JT Reference C Version                   **
 ***********************************************************************
 */

/*
 ***********************************************************************
 ** Copyright (C) 1990, RSA Data Security, Inc. All rights reserved.  **
 **                                                                   **
 ** License to copy and use this software is granted provided that    **
 ** it is identified as the "RSA Data Security, Inc. MD5 Message-     **
 ** Digest Algorithm" in all material mentioning or referencing this  **
 ** software or this function.                                        **
 **                                                                   **
 ** License is also granted to make and use derivative works          **
 ** provided that such works are identified as "derived from the RSA  **
 ** Data Security, Inc. MD5 Message-Digest Algorithm" in all          **
 ** material mentioning or referencing the derived work.              **
 **                                                                   **
 ** RSA Data Security, Inc. makes no representations concerning       **
 ** either the merchantability of this software or the suitability    **
 ** of this software for any particular purpose.  It is provided "as  **
 ** is" without express or implied warranty of any kind.              **
 **                                                                   **
 ** These notices must be retained in any copies of any part of this  **
 ** documentation and/or software.                                    **
 ***********************************************************************
 * This code implements the MD5 message-digest algorithm.
 * The algorithm is due to Ron Rivest.  This code was
 * written by Colin Plumb in 1993, no copyright is claimed.
 * This code is in the public domain; do with it what you wish.
 *
 * Equivalent code is available from RSA Data Security, Inc.
 * This code has been tested against that, and is equivalent,
 * except that you don't need to include two pages of legalese
 * with every copy.
 *
 * To compute the message digest of a chunk of bytes, declare an
 * MD5Context structure, pass it to MD5Init, call MD5Update as
 * needed on buffers full of bytes, and then call MD5Final, which
 * will fill a supplied 16-byte array with the digest.
 */

#include <string.h>             /* for memcpy() */
#include "md5.h"

#ifndef HIGHFIRST
#define byteReverse(buf, len)   /* Nothing */
#else
void byteReverse(unsigned char *buf, unsigned longs);

#ifndef ASM_MD5
/*
 * Note: this code is harmless on little-endian machines.
 */
void byteReverse(unsigned char *buf, unsigned longs)
{
    uint32 t;
    do {
        t = (uint32) ((unsigned) buf[3] << 8 | buf[2]) << 16 |
            ((unsigned) buf[1] << 8 | buf[0]);
        *(uint32 *) buf = t;
        buf += 4;
    } while (--longs);
}
#endif
#endif

/* F, G, H and I are basic MD5 functions */
#if 0
/* #define F1(x, y, z) (x & y | ~x & z) */
/* #define F(x, y, z) (((x) & (y)) | ((~x) & (z))) */
#define F(x, y, z) ((z) ^ ((x) & ((y) ^ (z))))
#define G(x, y, z) F(z, x, y)
#define H(x, y, z) ((x) ^ (y) ^ (z))
#define I(x, y, z) ((y) ^ ((x) | (~z)))
#else
#pragma inline
#define F(x, y, z) asm {mov eax, z; xor eax, y; \
                        and eax, x; xor eax, z}
#define G(x, y, z) F(z, x, y)
#define H(x, y, z) asm {mov eax, x; xor eax, y; xor eax, z}
#define I(x, y, z) asm {mov eax, z; not eax; or eax, x; xor eax, y}
#endif

/* ROTATE_LEFT rotates x left n bits */
#if 0
#define ROTATE_LEFT(x, n) (((x) << (n)) | ((x) >> (32-(n))))
#else
#define ROTATE_LEFT(x, n) asm {rol x, n}
#endif

/* FF, GG, HH, and II transformations for rounds 1, 2, 3, and 4 */
/* Rotation is separate from addition to prevent recomputation */
#if 0
#define FF(a, b, c, d, x, s, ac) \
  {(a) += F ((b), (c), (d)) + (x) + (uint32)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }
#define GG(a, b, c, d, x, s, ac) \
  {(a) += G ((b), (c), (d)) + (x) + (uint32)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }
#define HH(a, b, c, d, x, s, ac) \
  {(a) += H ((b), (c), (d)) + (x) + (uint32)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }
#define II(a, b, c, d, x, s, ac) \
  {(a) += I ((b), (c), (d)) + (x) + (uint32)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }
#else

#if sizeof(char *) == 4
 #define FFGGHHII(a, b, xp, xi, s, ac) \
        asm { /* les bx, xp; */ /* will NOT work in small data models ! */  \
                add eax, es:[bx+xi*4]; add eax, /*(uint32)*/ (ac); add a, eax}  \
   asm {rol a, s; add a, b}
#else
 #define FFGGHHII(a, b, xp, xi, s, ac) \
        asm { /* mov bx, xp; */ /* will work ONLY in small data models ! */  \
                add eax, ds:[bx+xi*4]; add eax, /*(uint32)*/ (ac); add a, eax}  \
   asm {rol a, s; add a, b}
#endif

#define FF(a, b, c, d, xp, xi, s, ac) \
  { F ((b), (c), (d)); FFGGHHII(a, b, xp, xi, s, ac) }
#define GG(a, b, c, d, xp, xi, s, ac) \
  { G ((b), (c), (d)); FFGGHHII(a, b, xp, xi, s, ac) }
#define HH(a, b, c, d, xp, xi, s, ac) \
  { H ((b), (c), (d)); FFGGHHII(a, b, xp, xi, s, ac) }
#define II(a, b, c, d, xp, xi, s, ac) \
  { I ((b), (c), (d)); FFGGHHII(a, b, xp, xi, s, ac) }
#endif
/* The routine MD5Init initializes the message-digest context
   mdContext. All fields are set to zero.
 */
void MD5Init ( struct MD5Context *ctx)
{
  /* Load magic initialization constants.
   */
  ctx->buf[0] = (uint32)0x67452301L;
  ctx->buf[1] = (uint32)0xefcdab89L;
  ctx->buf[2] = (uint32)0x98badcfeL;
  ctx->buf[3] = (uint32)0x10325476L;

  ctx->bits[0] = 0;
  ctx->bits[1] = 0;
}


/*
 * Update context to reflect the concatenation of another buffer full
 * of bytes.
 */
void MD5Update(struct MD5Context *ctx, unsigned char const *buf, unsigned len)
{
    uint32 t;

    /* Update bitcount */

    t = ctx->bits[0];
    if ((ctx->bits[0] = t + ((uint32) len << 3)) < t)
        ctx->bits[1]++;         /* Carry from low to high */
    ctx->bits[1] += len >> 29;

    t = (t >> 3) & 0x3f;        /* Bytes already in shsInfo->data */

    /* Handle any leading odd-sized chunks */

    if (t) {
        unsigned char *p = (unsigned char *) ctx->in + t;

        t = 64 - t;
        if (len < t) {
            memcpy(p, buf, len);
            return;
        }
        memcpy(p, buf, t);
        byteReverse(ctx->in, 16);
        MD5Transform(ctx->buf, (uint32 *) ctx->in);
        buf += t;
        len -= t;
    }
    /* Process data in 64-byte chunks */

    while (len >= 64) {
        memcpy(ctx->in, buf, 64);
        byteReverse(ctx->in, 16);
        MD5Transform(ctx->buf, (uint32 *) ctx->in);
        buf += 64;
        len -= 64;
    }

    /* Handle any remaining bytes of data. */

    memcpy(ctx->in, buf, len);
}

/*
 * Final wrapup - pad to 64-byte boundary with the bit pattern
 * 1 0* (64-bit count of bits processed, MSB-first)
 */
void MD5Final(unsigned char digest[16], struct MD5Context *ctx)
{
    unsigned count;
    unsigned char *p;

    /* Compute number of bytes mod 64 */
    count = (ctx->bits[0] >> 3) & 0x3F;

    /* Set the first char of padding to 0x80.  This is safe since there is
       always at least one byte free */
    p = ctx->in + count;
    *p++ = 0x80;

    /* Bytes of padding needed to make 64 bytes */
    count = 64 - 1 - count;

    /* Pad out to 56 mod 64 */
    if (count < 8) {
        /* Two lots of padding:  Pad the first block to 64 bytes */
        memset(p, 0, count);
        byteReverse(ctx->in, 16);
        MD5Transform(ctx->buf, (uint32 *) ctx->in);

        /* Now fill the next block with 56 bytes */
        memset(ctx->in, 0, 56);
    } else {
        /* Pad block to 56 bytes */
        memset(p, 0, count - 8);
    }
    byteReverse(ctx->in, 14);

    /* Append length in bits and transform */
    ((uint32 *) ctx->in)[14] = ctx->bits[0];
    ((uint32 *) ctx->in)[15] = ctx->bits[1];

    MD5Transform(ctx->buf, (uint32 *) ctx->in);
    byteReverse((unsigned char *) ctx->buf, 4);
    memcpy(digest, ctx->buf, 16);
    memset(ctx, 0, sizeof(ctx));        /* In case it's sensitive */
}


/*
 * The core of the MD5 algorithm, this alters an existing MD5 hash to
 * reflect the addition of 16 longwords of new data.  MD5Update blocks
 * the data and converts bytes into longwords for this routine.
 * Note that if the Mysterious Constants are arranged backwards
 * in little-endian order and decrypted with the DES they produce
 * OCCULT MESSAGES!
 */
void MD5Transform(uint32 buf[4], uint32 const in_[16])
{
//  register uint32 a = buf[0], b = buf[1], c = buf[2], d = buf[3];
#define a esi
#define b edi
#define c ecx
#define d edx

   asm .386


        _SI = 0;
        _DI = 0; /* convince BCC to save and (later) restore di and si */

#if sizeof buf == 4
        asm {
                les   bx, buf
                mov     a, es:[bx+0*4];
                mov     b, es:[bx+1*4];
                mov     c, es:[bx+2*4];
                mov     d, es:[bx+3*4];
                les   bx, in_
        }
#else
        asm {
                mov   bx, buf
                mov     a, ds:[bx+0*4];
                mov     b, ds:[bx+1*4];
                mov     c, ds:[bx+2*4];
                mov     d, ds:[bx+3*4];
                mov   bx, in_
        }
#endif

  /* Round 1 */
#define S11 7
#define S12 12
#define S13 17
#define S14 22
  FF ( a, b, c, d, in_, 0 /* in[ 0] */, S11, 0xD76AA478); /* 1 */
  FF ( d, a, b, c, in_, 1 /* in[ 1] */, S12, 0xE8C7B756); /* 2 */
  FF ( c, d, a, b, in_, 2 /* in[ 2] */, S13, 0x242070DB); /* 3 */
  FF ( b, c, d, a, in_, 3 /* in[ 3] */, S14, 0xC1BDCEEE); /* 4 */
  FF ( a, b, c, d, in_, 4 /* in[ 4] */, S11, 0xF57C0FAF); /* 5 */
  FF ( d, a, b, c, in_, 5 /* in[ 5] */, S12, 0x4787C62A); /* 6 */
  FF ( c, d, a, b, in_, 6 /* in[ 6] */, S13, 0xA8304613); /* 7 */
  FF ( b, c, d, a, in_, 7 /* in[ 7] */, S14, 0xFD469501); /* 8 */
  FF ( a, b, c, d, in_, 8 /* in[ 8] */, S11, 0x698098D8); /* 9 */
  FF ( d, a, b, c, in_, 9 /* in[ 9] */, S12, 0x8B44F7AF); /* 10 */
  FF ( c, d, a, b, in_,10 /* in[10] */, S13, 0xFFFF5BB1); /* 11 */
  FF ( b, c, d, a, in_,11 /* in[11] */, S14, 0x895CD7BE); /* 12 */
  FF ( a, b, c, d, in_,12 /* in[12] */, S11, 0x6B901122); /* 13 */
  FF ( d, a, b, c, in_,13 /* in[13] */, S12, 0xFD987193); /* 14 */
  FF ( c, d, a, b, in_,14 /* in[14] */, S13, 0xA679438E); /* 15 */
  FF ( b, c, d, a, in_,15 /* in[15] */, S14, 0x49B40821); /* 16 */

  /* Round 2 */
#define S21 5
#define S22 9
#define S23 14
#define S24 20
  GG ( a, b, c, d, in_, 1 /* in[ 1] */, S21, 0xF61E2562); /* 17 */
  GG ( d, a, b, c, in_, 6 /* in[ 6] */, S22, 0xC040B340); /* 18 */
  GG ( c, d, a, b, in_,11 /* in[11] */, S23, 0x265E5A51); /* 19 */
  GG ( b, c, d, a, in_, 0 /* in[ 0] */, S24, 0xE9B6C7AA); /* 20 */
  GG ( a, b, c, d, in_, 5 /* in[ 5] */, S21, 0xD62F105D); /* 21 */
  GG ( d, a, b, c, in_,10 /* in[10] */, S22, 0x02441453); /* 22 */
  GG ( c, d, a, b, in_,15 /* in[15] */, S23, 0xD8A1E681); /* 23 */
  GG ( b, c, d, a, in_, 4 /* in[ 4] */, S24, 0xE7D3FBC8); /* 24 */
  GG ( a, b, c, d, in_, 9 /* in[ 9] */, S21, 0x21E1CDE6); /* 25 */
  GG ( d, a, b, c, in_,14 /* in[14] */, S22, 0xC33707D6); /* 26 */
  GG ( c, d, a, b, in_, 3 /* in[ 3] */, S23, 0xF4D50D87); /* 27 */
  GG ( b, c, d, a, in_, 8 /* in[ 8] */, S24, 0x455A14ED); /* 28 */
  GG ( a, b, c, d, in_,13 /* in[13] */, S21, 0xA9E3E905); /* 29 */
  GG ( d, a, b, c, in_, 2 /* in[ 2] */, S22, 0xFCEFA3F8); /* 30 */
  GG ( c, d, a, b, in_, 7 /* in[ 7] */, S23, 0x676F02D9); /* 31 */
  GG ( b, c, d, a, in_,12 /* in[12] */, S24, 0x8D2A4C8A); /* 32 */

  /* Round 3 */
#define S31 4
#define S32 11
#define S33 16
#define S34 23
  HH ( a, b, c, d, in_, 5 /* in[ 5] */, S31, 0xFFFA3942); /* 33 */
  HH ( d, a, b, c, in_, 8 /* in[ 8] */, S32, 0x8771F681); /* 34 */
  HH ( c, d, a, b, in_,11 /* in[11] */, S33, 0x6D9D6122); /* 35 */
  HH ( b, c, d, a, in_,14 /* in[14] */, S34, 0xFDE5380C); /* 36 */
  HH ( a, b, c, d, in_, 1 /* in[ 1] */, S31, 0xA4BEEA44); /* 37 */
  HH ( d, a, b, c, in_, 4 /* in[ 4] */, S32, 0x4BDECFA9); /* 38 */
  HH ( c, d, a, b, in_, 7 /* in[ 7] */, S33, 0xF6BB4B60); /* 39 */
  HH ( b, c, d, a, in_,10 /* in[10] */, S34, 0xBEBFBC70); /* 40 */
  HH ( a, b, c, d, in_,13 /* in[13] */, S31, 0x289B7EC6); /* 41 */
  HH ( d, a, b, c, in_, 0 /* in[ 0] */, S32, 0xEAA127FA); /* 42 */
  HH ( c, d, a, b, in_, 3 /* in[ 3] */, S33, 0xD4EF3085); /* 43 */
  HH ( b, c, d, a, in_, 6 /* in[ 6] */, S34, 0x04881D05); /* 44 */
  HH ( a, b, c, d, in_, 9 /* in[ 9] */, S31, 0xD9D4D039); /* 45 */
  HH ( d, a, b, c, in_,12 /* in[12] */, S32, 0xE6DB99E5); /* 46 */
  HH ( c, d, a, b, in_,15 /* in[15] */, S33, 0x1FA27CF8); /* 47 */
  HH ( b, c, d, a, in_, 2 /* in[ 2] */, S34, 0xC4AC5665); /* 48 */

  /* Round 4 */
#define S41 6
#define S42 10
#define S43 15
#define S44 21
  II ( a, b, c, d, in_, 0 /* in[ 0] */, S41, 0xF4292244); /* 49 */
  II ( d, a, b, c, in_, 7 /* in[ 7] */, S42, 0x432AFF97); /* 50 */
  II ( c, d, a, b, in_,14 /* in[14] */, S43, 0xAB9423A7); /* 51 */
  II ( b, c, d, a, in_, 5 /* in[ 5] */, S44, 0xFC93A039); /* 52 */
  II ( a, b, c, d, in_,12 /* in[12] */, S41, 0x655B59C3); /* 53 */
  II ( d, a, b, c, in_, 3 /* in[ 3] */, S42, 0x8F0CCC92); /* 54 */
  II ( c, d, a, b, in_,10 /* in[10] */, S43, 0xFFEFF47D); /* 55 */
  II ( b, c, d, a, in_, 1 /* in[ 1] */, S44, 0x85845DD1); /* 56 */
  II ( a, b, c, d, in_, 8 /* in[ 8] */, S41, 0x6FA87E4F); /* 57 */
  II ( d, a, b, c, in_,15 /* in[15] */, S42, 0xFE2CE6E0); /* 58 */
  II ( c, d, a, b, in_, 6 /* in[ 6] */, S43, 0xA3014314); /* 59 */
  II ( b, c, d, a, in_,13 /* in[13] */, S44, 0x4E0811A1); /* 60 */
  II ( a, b, c, d, in_, 4 /* in[ 4] */, S41, 0xF7537E82); /* 61 */
  II ( d, a, b, c, in_,11 /* in[11] */, S42, 0xBD3AF235); /* 62 */
  II ( c, d, a, b, in_, 2 /* in[ 2] */, S43, 0x2AD7D2BB); /* 63 */
  II ( b, c, d, a, in_, 9 /* in[ 9] */, S44, 0xEB86D391); /* 64 */

#if sizeof buf == 4
  asm les bx, buf
  asm add es:[bx+0*4], a        // buf[0] += a;
  asm add es:[bx+1*4], b        // buf[1] += b;
  asm add es:[bx+2*4], c        // buf[2] += c;
  asm add es:[bx+3*4], d        // buf[3] += d;
#else
  asm mov bx, buf
  asm add ds:[bx+0*4], a        // buf[0] += a;
  asm add ds:[bx+1*4], b        // buf[1] += b;
  asm add ds:[bx+2*4], c        // buf[2] += c;
  asm add ds:[bx+3*4], d        // buf[3] += d;
#endif

  asm .8086
#undef a
#undef b
#undef c
#undef d
}

