/*
 *	Transparent Cryptographic File System (TCFS) for NetBSD 
 *	Author and mantainer: 	Luigi Catuogno [luicat@tcfs.unisa.it]
 *	
 *	references:		http://tcfs.dia.unisa.it
 *				tcfs-bsd@tcfs.unisa.it
 */

/*
 *	Base utility set v0.1
 *
 *	  $Source: /home/luicat/text/source/include/RCS/tcfs.h,v $
 *	   $State: Exp $
 *	$Revision: 1.1 $
 *	  $Author: luicat $
 *	    $Date: 1999/10/28 11:31:23 $
 *
 */

/* RCS_HEADER_ENDS_HERE */



#ifndef _DES_H_
#include <kdes.h>
#endif

struct tcfs_args {
	char		*target;	/* Target of loopback   */
	char 		*des_key;	/* chiave 		*/
	int		cmd;		/* direttiva		*/
	uid_t		user;		/* utente		*/
	pid_t		proc;		/* processo		*/
	gid_t		group;		/* gruppo		*/
	int		treshold;	/* soglia grpkey	*/
};


/*	tcfs commands		*/	

#define TCFS_PUT_UIDKEY		1
#define TCFS_RM_UIDKEY		2
#define TCFS_PUT_PIDKEY		3
#define	TCFS_RM_PIDKEY		4
#define	TCFS_PUT_GIDKEY		5
#define TCFS_RM_GIDKEY		6

/*	Gestione informazioni sui files cifrati
*/

typedef union {
		unsigned long flag;
		struct {
			unsigned reserved:4;
			unsigned mb:1;
			unsigned spure:3;
			unsigned gshar:1;
			unsigned unused:7;
			unsigned reserved2:4;
			unsigned unused2:12;
		       } bf;
		} tcfs_flags;

#define	FI_CFLAG(x)	((x)->bf.mb)
#define FI_SPURE(x)	((x)->bf.spure)
#define	FI_GSHAR(x)	((x)->bf.gshar)
#define	FI_SET_CF(x,y)	(((x)->bf.mb)=(y))
#define FI_SET_SP(x,y)	(((x)->bf.spure)=(y))
#define	FI_SET_GS(x,y)	(((x)->bf.gshar)=(y))

#define TCFS_EFLGS	-1

