/* ./src/af/str_ed.c */

static char *rcsid = "$Id: str_ed.c,v 1.4 1995/03/01 13:21:10 surkau Exp $";

/* 
 *
 * $Id: str_ed.c,v 1.4 1995/03/01 13:21:10 surkau Exp $
 *
 * $Log: str_ed.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include "sec_config.h"

#ifdef X500
#ifdef STRONG

#ifdef ICR1
#include "ul/psap.h"
#else
#include "psap.h"
#endif
#include "secude-stub.h"



/***************************************************************
 *
 * Procedure e_TokenTBS
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *e_TokenTBS(
	TokenTBS	 *token_tbs
)

#else

OctetString *e_TokenTBS(
	token_tbs
)
TokenTBS	 *token_tbs;

#endif

{
	PE             P_TBSToken, P_TBSToken_DER;
	OctetString  * ret;

	if(! token_tbs)
		return(NULLOCTETSTRING);

	if(build_STR_TokenTBS(&P_TBSToken, 1, 0, CNULL, token_tbs) == NOTOK)
		return(NULLOCTETSTRING);

	P_TBSToken_DER = aux_DER_SETOF(P_TBSToken);
	ret = aux_PE2OctetString(P_TBSToken_DER);

	pe_free(P_TBSToken);
	pe_free(P_TBSToken_DER);

	return(ret);
}


/***************************************************************
 *
 * Procedure e_AddArgumentTBS
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *e_AddArgumentTBS(
	AddArgumentTBS	 *addarg_tbs
)

#else

OctetString *e_AddArgumentTBS(
	addarg_tbs
)
AddArgumentTBS	 *addarg_tbs;

#endif

{
	PE             P_TBSAddArgument, P_TBSAddArgument_DER;
	OctetString  * ret;

	if(! addarg_tbs)
		return(NULLOCTETSTRING);

	if(build_STR_AddArgumentTBS(&P_TBSAddArgument, 1, 0, CNULL, addarg_tbs) == NOTOK)
		return(NULLOCTETSTRING);

	P_TBSAddArgument_DER = aux_DER_SETOF(P_TBSAddArgument);
	ret = aux_PE2OctetString(P_TBSAddArgument_DER);

	pe_free(P_TBSAddArgument);
	pe_free(P_TBSAddArgument_DER);

	return(ret);
}


/***************************************************************
 *
 * Procedure e_CompareArgumentTBS
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *e_CompareArgumentTBS(
	CompareArgumentTBS	 *cmparg_tbs
)

#else

OctetString *e_CompareArgumentTBS(
	cmparg_tbs
)
CompareArgumentTBS	 *cmparg_tbs;

#endif

{
	PE             P_TBSCompareArgument, P_TBSCompareArgument_DER;
	OctetString  * ret;

	if(! cmparg_tbs)
		return(NULLOCTETSTRING);

	if(build_STR_CompareArgumentTBS(&P_TBSCompareArgument, 1, 0, CNULL, cmparg_tbs) == NOTOK)
		return(NULLOCTETSTRING);

	P_TBSCompareArgument_DER = aux_DER_SETOF(P_TBSCompareArgument);
	ret = aux_PE2OctetString(P_TBSCompareArgument_DER);

	pe_free(P_TBSCompareArgument);
	pe_free(P_TBSCompareArgument_DER);

	return(ret);
}


/***************************************************************
 *
 * Procedure e_CompareResultTBS
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *e_CompareResultTBS(
	CompareResultTBS	 *cmpres_tbs
)

#else

OctetString *e_CompareResultTBS(
	cmpres_tbs
)
CompareResultTBS	 *cmpres_tbs;

#endif

{
	PE             P_TBSCompareResult, P_TBSCompareResult_DER;
	OctetString  * ret;

	if(! cmpres_tbs)
		return(NULLOCTETSTRING);

	if(build_STR_CompareResultTBS(&P_TBSCompareResult, 1, 0, CNULL, cmpres_tbs) == NOTOK)
		return(NULLOCTETSTRING);

	P_TBSCompareResult_DER = aux_DER_SETOF(P_TBSCompareResult);
	ret = aux_PE2OctetString(P_TBSCompareResult_DER);

	pe_free(P_TBSCompareResult);
	pe_free(P_TBSCompareResult_DER);

	return(ret);
}


/***************************************************************
 *
 * Procedure e_ListArgumentTBS
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *e_ListArgumentTBS(
	ListArgumentTBS	 *listarg_tbs
)

#else

OctetString *e_ListArgumentTBS(
	listarg_tbs
)
ListArgumentTBS	 *listarg_tbs;

#endif

{
	PE             P_TBSListArgument, P_TBSListArgument_DER;
	OctetString  * ret;

	if(! listarg_tbs)
		return(NULLOCTETSTRING);

	if(build_STR_ListArgumentTBS(&P_TBSListArgument, 1, 0, CNULL, listarg_tbs) == NOTOK)
		return(NULLOCTETSTRING);

	P_TBSListArgument_DER = aux_DER_SETOF(P_TBSListArgument);
	ret = aux_PE2OctetString(P_TBSListArgument_DER);

	pe_free(P_TBSListArgument);
	pe_free(P_TBSListArgument_DER);

	return(ret);
}


/***************************************************************
 *
 * Procedure e_ListResultTBS
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *e_ListResultTBS(
	ListResultTBS	 *listres_tbs
)

#else

OctetString *e_ListResultTBS(
	listres_tbs
)
ListResultTBS	 *listres_tbs;

#endif

{
	PE             P_TBSListResult, P_TBSListResult_DER;
	OctetString  * ret;

	if(! listres_tbs)
		return(NULLOCTETSTRING);

	if(build_STR_ListResultTBS(&P_TBSListResult, 1, 0, CNULL, listres_tbs) == NOTOK)
		return(NULLOCTETSTRING);

	P_TBSListResult_DER = aux_DER_SETOF(P_TBSListResult);
	ret = aux_PE2OctetString(P_TBSListResult_DER);

	pe_free(P_TBSListResult);
	pe_free(P_TBSListResult_DER);

	return(ret);
}


/***************************************************************
 *
 * Procedure e_ListResult
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *e_ListResult(
	ListResult	 *listres
)

#else

OctetString *e_ListResult(
	listres
)
ListResult	 *listres;

#endif

{
	PE             P_ListResult, P_ListResult_DER;
	OctetString  * ret;

	if(! listres)
		return(NULLOCTETSTRING);

	if(build_STR_ListResult(&P_ListResult, 1, 0, CNULL, listres) == NOTOK)
		return(NULLOCTETSTRING);

	P_ListResult_DER = aux_DER_SETOF(P_ListResult);
	ret = aux_PE2OctetString(P_ListResult_DER);

	pe_free(P_ListResult);
	pe_free(P_ListResult_DER);

	return(ret);
}


/***************************************************************
 *
 * Procedure e_ModifyEntryArgumentTBS
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *e_ModifyEntryArgumentTBS(
	ModifyEntryArgumentTBS	 *modarg_tbs
)

#else

OctetString *e_ModifyEntryArgumentTBS(
	modarg_tbs
)
ModifyEntryArgumentTBS	 *modarg_tbs;

#endif

{
	PE             P_TBSModifyEntryArgument, P_TBSModifyEntryArgument_DER;
	OctetString  * ret;

	if(! modarg_tbs)
		return(NULLOCTETSTRING);

	if(build_STR_ModifyEntryArgumentTBS(&P_TBSModifyEntryArgument, 1, 0, CNULL, modarg_tbs) == NOTOK)
		return(NULLOCTETSTRING);

	P_TBSModifyEntryArgument_DER = aux_DER_SETOF(P_TBSModifyEntryArgument);
	ret = aux_PE2OctetString(P_TBSModifyEntryArgument_DER);

	pe_free(P_TBSModifyEntryArgument);
	pe_free(P_TBSModifyEntryArgument_DER);

	return(ret);
}


/***************************************************************
 *
 * Procedure e_ModifyRDNArgumentTBS
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *e_ModifyRDNArgumentTBS(
	ModifyRDNArgumentTBS	 *modrdnarg_tbs
)

#else

OctetString *e_ModifyRDNArgumentTBS(
	modrdnarg_tbs
)
ModifyRDNArgumentTBS	 *modrdnarg_tbs;

#endif

{
	PE             P_TBSModifyRDNArgument, P_TBSModifyRDNArgument_DER;
	OctetString  * ret;

	if(! modrdnarg_tbs)
		return(NULLOCTETSTRING);

	if(build_STR_ModifyRDNArgumentTBS(&P_TBSModifyRDNArgument, 1, 0, CNULL, modrdnarg_tbs) == NOTOK)
		return(NULLOCTETSTRING);

	P_TBSModifyRDNArgument_DER = aux_DER_SETOF(P_TBSModifyRDNArgument);
	ret = aux_PE2OctetString(P_TBSModifyRDNArgument_DER);

	pe_free(P_TBSModifyRDNArgument);
	pe_free(P_TBSModifyRDNArgument_DER);

	return(ret);
}


/***************************************************************
 *
 * Procedure e_ReadArgumentTBS
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *e_ReadArgumentTBS(
	ReadArgumentTBS	 *readarg_tbs
)

#else

OctetString *e_ReadArgumentTBS(
	readarg_tbs
)
ReadArgumentTBS	 *readarg_tbs;

#endif

{
	PE             P_TBSReadArgument, P_TBSReadArgument_DER;
	OctetString  * ret;

	if(! readarg_tbs)
		return(NULLOCTETSTRING);

	if(build_STR_ReadArgumentTBS(&P_TBSReadArgument, 1, 0, CNULL, readarg_tbs) == NOTOK)
		return(NULLOCTETSTRING);

	P_TBSReadArgument_DER = aux_DER_SETOF(P_TBSReadArgument);
	ret = aux_PE2OctetString(P_TBSReadArgument_DER);

	pe_free(P_TBSReadArgument);
	pe_free(P_TBSReadArgument_DER);

	return(ret);
}


/***************************************************************
 *
 * Procedure e_ReadResultTBS
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *e_ReadResultTBS(
	ReadResultTBS	 *readres_tbs
)

#else

OctetString *e_ReadResultTBS(
	readres_tbs
)
ReadResultTBS	 *readres_tbs;

#endif

{
	PE             P_TBSReadResult, P_TBSReadResult_DER;
	OctetString  * ret;

	if(! readres_tbs)
		return(NULLOCTETSTRING);

	if(build_STR_ReadResultTBS(&P_TBSReadResult, 1, 0, CNULL, readres_tbs) == NOTOK)
		return(NULLOCTETSTRING);

	P_TBSReadResult_DER = aux_DER_SETOF(P_TBSReadResult);
	ret = aux_PE2OctetString(P_TBSReadResult_DER);

	pe_free(P_TBSReadResult);
	pe_free(P_TBSReadResult_DER);

	return(ret);
}


/***************************************************************
 *
 * Procedure e_RemoveArgumentTBS
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *e_RemoveArgumentTBS(
	RemoveArgumentTBS	 *remarg_tbs
)

#else

OctetString *e_RemoveArgumentTBS(
	remarg_tbs
)
RemoveArgumentTBS	 *remarg_tbs;

#endif

{
	PE             P_TBSRemoveArgument, P_TBSRemoveArgument_DER;
	OctetString  * ret;

	if(! remarg_tbs)
		return(NULLOCTETSTRING);

	if(build_STR_RemoveArgumentTBS(&P_TBSRemoveArgument, 1, 0, CNULL, remarg_tbs) == NOTOK)
		return(NULLOCTETSTRING);

	P_TBSRemoveArgument_DER = aux_DER_SETOF(P_TBSRemoveArgument);
	ret = aux_PE2OctetString(P_TBSRemoveArgument_DER);

	pe_free(P_TBSRemoveArgument);
	pe_free(P_TBSRemoveArgument_DER);

	return(ret);
}


/***************************************************************
 *
 * Procedure e_SearchArgumentTBS
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *e_SearchArgumentTBS(
	SearchArgumentTBS	 *searcharg_tbs
)

#else

OctetString *e_SearchArgumentTBS(
	searcharg_tbs
)
SearchArgumentTBS	 *searcharg_tbs;

#endif

{
	PE             P_TBSSearchArgument, P_TBSSearchArgument_DER;
	OctetString  * ret;

	if(! searcharg_tbs)
		return(NULLOCTETSTRING);

	if(build_STR_SearchArgumentTBS(&P_TBSSearchArgument, 1, 0, CNULL, searcharg_tbs) == NOTOK)
		return(NULLOCTETSTRING);

	P_TBSSearchArgument_DER = aux_DER_SETOF(P_TBSSearchArgument);
	ret = aux_PE2OctetString(P_TBSSearchArgument_DER);

	pe_free(P_TBSSearchArgument);
	pe_free(P_TBSSearchArgument_DER);

	return(ret);
}


/***************************************************************
 *
 * Procedure e_SearchResultTBS
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *e_SearchResultTBS(
	SearchResultTBS	 *searchres_tbs
)

#else

OctetString *e_SearchResultTBS(
	searchres_tbs
)
SearchResultTBS	 *searchres_tbs;

#endif

{
	PE             P_TBSSearchResult, P_TBSSearchResult_DER;
	OctetString  * ret;

	if(! searchres_tbs)
		return(NULLOCTETSTRING);

	if(build_STR_SearchResultTBS(&P_TBSSearchResult, 1, 0, CNULL, searchres_tbs) == NOTOK)
		return(NULLOCTETSTRING);

	P_TBSSearchResult_DER = aux_DER_SETOF(P_TBSSearchResult);
	ret = aux_PE2OctetString(P_TBSSearchResult_DER);

	pe_free(P_TBSSearchResult);
	pe_free(P_TBSSearchResult_DER);

	return(ret);
}


/***************************************************************
 *
 * Procedure e_SearchResult
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *e_SearchResult(
	SearchResult	 *searchres
)

#else

OctetString *e_SearchResult(
	searchres
)
SearchResult	 *searchres;

#endif

{
	PE             P_SearchResult, P_SearchResult_DER;
	OctetString  * ret;

	if(! searchres)
		return(NULLOCTETSTRING);

	if(build_STR_SearchResult(&P_SearchResult, 1, 0, CNULL, searchres) == NOTOK)
		return(NULLOCTETSTRING);

	P_SearchResult_DER = aux_DER_SETOF(P_SearchResult);
	ret = aux_PE2OctetString(P_SearchResult_DER);

	pe_free(P_SearchResult);
	pe_free(P_SearchResult_DER);

	return(ret);
}


/***************************************************************
 *
 * Procedure PSAPaddr_dec
 *
 ***************************************************************/
#ifdef __STDC__

typeDSE_PSAPaddr *PSAPaddr_dec(
	PE	  pe
)

#else

typeDSE_PSAPaddr *PSAPaddr_dec(
	pe
)
PE	  pe;

#endif

{
	typeDSE_PSAPaddr * ret;
	int	           result;
	char	         * proc = "PSAPaddr_dec";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( pe == NULLPE )
		return( (typeDSE_PSAPaddr * )0 );

	/*NOTE: Space for PSAPaddr is allocated by parse_STR_PSAPaddr,*/
	/*parameter is of type typeDSE_PSAPaddr ** (not *!) */

	result = parse_STR_PSAPaddr (pe, 1, NULLIP, NULLVP, &ret);

	return (result ? (typeDSE_PSAPaddr * )0 : ret);
}




#else

/* dummy */
strong_ed_dummy() 
{
	return(0);
}

#endif


#else
/* dummy */
strong_ed_dummy() 
{
	return(0);
}

#endif

