/* ./src/aux/aux_PKCS.c */

static char *rcsid = "$Id: aux_PKCS.c,v 1.3 1994/11/02 10:44:39 surkau Exp $";

/* 
 *
 * $Id: aux_PKCS.c,v 1.3 1994/11/02 10:44:39 surkau Exp $
 *
 * $Log: aux_PKCS.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include "secure.h"

/***************************************************************
 *
 * Procedure aux_create_PKCSBlock
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_create_PKCSBlock(
	char		  BT,
	OctetString	 *D
)

#else

OctetString *aux_create_PKCSBlock(
	BT,
	D
)
char		  BT;
OctetString	 *D;

#endif

{

/*
 *  aux_create_PKCSBlock returns a newly created OctetString
 *  of length blocksize = (keysize - 1) / 8 (e.g blocksize 63
 *  in case of RSA keysize 512 bits) which consists of a concatenation
 *  of BT || PS || 0x00 || D. This is the encryption block formatting
 *  of PKCS#1 without the leading 0x00.
 *  PS is a padding string dependant on blocktype BT. It consists of
 *  0x00 in case of BT = 0x00, 
 *  0xff in case of BT = 0x01,
 *  non-zero pseudo random numbers in case of BT = 0x02.
 */

	OctetString	*PKCSBlock, *ps;
	int		ps_length, CT_length;
	char            *dd, *bb, *ct;
	int		blocksize, i, n;
	char		*proc = "aux_create_PKCSBlock";

	if(BT < 0 || BT > PKCS_BT_TD) {
		aux_add_error(EINVALID, "Wrong BT for PKCS block", CNULL, 0, proc);
		return ((OctetString * )0);
	}

	if(!D || !D->noctets || !D->octets) {
		aux_add_error(EINVALID, "Wrong D for PKCS block", CNULL, 0, proc);
		return ((OctetString * )0);
	}

	blocksize = (public_modulus_length - 1) / 8;

	ps_length = blocksize - 2 - D->noctets;

	if(ps_length < 0) {
		aux_add_error(EINVALID, "D too long for PKCS block", CNULL, 0, proc);
		return ((OctetString *)0);
	}

	if(!(PKCSBlock = aux_new_OctetString(blocksize))) {
		aux_add_error(EMALLOC, "PKCSBlock", CNULL, 0, proc);
		return ((OctetString * )0);
	}

	/* First BT */

	PKCSBlock->octets[0] = BT;

	switch(BT) {
		case PKCS_BT_01:
			dd = PKCSBlock->octets + 1;
			while(ps_length--) *dd++ = 0xff;
			break;
		case PKCS_BT_02:
			if(!(ps = sec_random_ostr(ps_length))) {
				aux_add_error(EMALLOC, "ps", CNULL, 0, proc);
				return ((OctetString *)0);
			}
			for(n = ps->noctets-1; n >= 0; n--) if(!ps->octets[n]) ps->octets[n] = 1; /* ps-elements must not be zero */

			bb = ps->octets;
			dd = PKCSBlock->octets + 1;
			while(ps_length--) {
				if(!(*bb)) *bb = 0xff;
				*dd++ = *bb++;
			}
			aux_free_OctetString(&ps);
			break;
		case PKCS_BT_TD:
			ct = (char *)aux_current_UTCTime();
			CT_length = strlen(ct);
			ps_length = ps_length - CT_length;
			if(ps_length < 0) {
				aux_add_error(EINVALID, "D too long for PKCS block (PKCS_BT_TD)", CNULL, 0, proc);
				return ((OctetString *)0);
			}
			dd = PKCSBlock->octets + 1;
			while(CT_length--) *dd++ = *ct++;
			while(ps_length--) *dd++ = 0xff;
			break;
			
	}

	bb = D->octets;
	dd = PKCSBlock->octets + blocksize - (int)D->noctets;
	i = D->noctets;
	while(i--) *dd++ = *bb++;
	return(PKCSBlock);
}

/***************************************************************
 *
 * Procedure aux_create_PKCS_MIC_D
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_create_PKCS_MIC_D(
	OctetString	 *hash_result,
	AlgId		 *signatureAlgorithm
)

#else

OctetString *aux_create_PKCS_MIC_D(
	hash_result,
	signatureAlgorithm
)
OctetString	 *hash_result;
AlgId		 *signatureAlgorithm;

#endif

{
	DigestInfo      digestinfo;
	AlgId 		*digestAlgorithm;
	AlgSpecial	algspecial;
	AlgHash		alghash;
	OctetString	*encodedDigest;
	char		*proc = "aux_create_PKCS_MIC_D";

	algspecial = aux_ObjId2AlgSpecial(signatureAlgorithm->objid);
	if(algspecial != PKCS_BT_01 && algspecial != PKCS_BT_TD) {
		aux_add_error(EINVALID, "algspecial is not PKCS_BT_01", CNULL, 0, proc);
		return((OctetString *)0);
	}
	alghash = aux_ObjId2AlgHash(signatureAlgorithm->objid);
	switch(alghash) {
		case MD2:
			digestAlgorithm = md2;
			break;
		case MD4:
			digestAlgorithm = md4;
			break;
		case MD5:
			digestAlgorithm = md5;
			break;
		default:
			aux_add_error(EINVALID, "alghash is not MD2, MD4, MD5", CNULL, 0, proc);
			return((OctetString *)0);
	}	

	digestinfo.digestAI = digestAlgorithm;
	digestinfo.digest.noctets = hash_result->noctets;
	digestinfo.digest.octets = hash_result->octets;
	encodedDigest = e_DigestInfo(&digestinfo);

	return(encodedDigest);
}

