/* ./src/aux/aux_can.c */

static char *rcsid = "$Id: aux_can.c,v 1.3 1994/11/02 10:44:39 surkau Exp $";

/* 
 *
 * $Id: aux_can.c,v 1.3 1994/11/02 10:44:39 surkau Exp $
 *
 * $Log: aux_can.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/
#include "secure.h"
#ifdef MAC
#include <stdlib.h>
#endif /* MAC */


/***************************************************************
 *
 * Procedure aux_canon
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_canon(
	OctetString	 *text
)

#else

OctetString *aux_canon(
	text
)
OctetString	 *text;

#endif

{
	OctetString * canform; /*returncode*/
	int	x, i;
	char	c, d, CR, LF;
	char	*proc = "aux_canon";

	if ( !(canform = (OctetString * )malloc(sizeof(OctetString))) ) {
		aux_add_error(EMALLOC, "canform", CNULL, 0, proc);
		return( (OctetString * )0 );
	}
	canform->noctets = 2 * text->noctets; /*worst case: only CR's*/
	if ( !(canform->octets = malloc(canform->noctets)) ) {
		aux_add_error(EMALLOC, "canform->octets", CNULL, 0, proc);
		free(canform);
		return( (OctetString * )0 );
	}

	i = x = 0;
	CR = 0x0d; /*test with CR='D'*/
	LF = 0x0a; /*test with LF='A'*/

	while (i < text->noctets) {
		c = *(text->octets + i++);
		if ( c == LF || c == CR ) {
			if ( i < text->noctets ) {
				d = *(text->octets + i);
				if ( c == LF )
					if ( d == CR ) {
						*(canform->octets + x++) = d;
						*(canform->octets + x++) = c;
						i++;
					}
					else {
						*(canform->octets + x++) = CR;
						*(canform->octets + x++) = c;
					}
				else if /*c==CR*/
				( d == LF ) {
					*(canform->octets + x++) = c;
					*(canform->octets + x++) = d;
					i++;
				} else {
					*(canform->octets + x++) = c;
					*(canform->octets + x++) = LF;
				}
			} else {
				*(canform->octets + x++) = CR;
				*(canform->octets + x++) = LF;
			}
		} else {
			*(canform->octets + x++) = c;
		}
	} /*while*/

	canform->noctets = x;
	canform->octets = (char *)realloc(canform->octets, canform->noctets);
	return(canform);
}  /* end aux_canon() */



/***************************************************************
 *
 * Procedure aux_decanon
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_decanon(
	OctetString	 *canform
)

#else

OctetString *aux_decanon(
	canform
)
OctetString	 *canform;

#endif

{
	OctetString * text; /*returned*/
	int	x, i;
	char	c, d, CR, LF, NL;
	char	*proc = "aux_decanon";

	if ( !(text = (OctetString * )malloc(sizeof(OctetString))) ) {
		aux_add_error(EMALLOC, "text", CNULL, 0, proc);
		return( (OctetString * )0 );
	}
#ifdef MS_DOS
	text->noctets = 2 * canform->noctets; /*worst case: can't be longer*/
#else
	text->noctets = canform->noctets; /*worst case: can't be longer*/
#endif
	if ( !(text->octets = malloc(text->noctets)) ) {
		aux_add_error(EMALLOC, "text->octets", CNULL, 0, proc);
		free(text);
		return( (OctetString * )0 );
	}

	i = x = 0;
	CR = 0x0d; /*test with CR='D'*/
	LF = 0x0a; /*test with LF='A'*/
	NL = '\n'; /*test with NL='N'*/

	while (i < canform->noctets) {
		c = *(canform->octets + i++);
		if ( c == LF || c == CR ) {
#ifdef MS_DOS
			*(text->octets + x++) = CR;
			*(text->octets + x++) = LF;
#else
			*(text->octets + x++) = NL;
#endif
			if ( i < canform->noctets ) {
				d = *(canform->octets + i);
				if ( ((c == LF) && (d == CR)) || ((c == CR) && (d == LF)) )
					i++;
			}
		} else
			*(text->octets + x++) = c;
	} /*while*/

	text->noctets = x;
	while ( *(text->octets + text->noctets - 1) == -1 )
		text->noctets--;
	text->octets = (char *)realloc(text->octets, text->noctets);
	return( text );
}  /* end aux_decanon() */



/***************************************************************
 *
 * Procedure aux_64
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_64(
	OctetString	 *text,
	OctetString	 *indent
)

#else

OctetString *aux_64(
	text,
	indent
)
OctetString	 *text;
OctetString	 *indent;

#endif

{
	OctetString * form64; /*return*/
	int	lind;
	int	index = 0;
	int	i = 0;
	char	NL = '\n';
	char	*proc = "aux_64";

	if ( !(form64 = (OctetString * )malloc(sizeof(OctetString))) ) {
		aux_add_error(EMALLOC, "form64", CNULL, 0, proc);
		return( (OctetString * )0 );
	}
	form64->noctets = text->noctets + (text->noctets / 64 + 1) * (indent->noctets + 1);
	/*every 64 char`s: indent + one CR*/
	if ( !(form64->octets = malloc(form64->noctets)) ) {
		aux_add_error(EMALLOC, "form64->octets", CNULL, 0, proc);
		free(form64);
		return( (OctetString * )0 );
	}

	while ( i < text->noctets ) {
		for (lind = 0; lind < indent->noctets; lind++)
			*(form64->octets + index++) = *(indent->octets + lind);
		for (lind = 0; (lind < 64) && (i < text->noctets); lind++)
			*(form64->octets + index++) = *(text->octets + i++);
		*(form64->octets + index++) = NL;
	}    /* while */
	form64->noctets = index;
	form64->octets = (char *)realloc(form64->octets, form64->noctets);
	return( form64 );
}  /* end aux_64() */



/***************************************************************
 *
 * Procedure aux_de64
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_de64(
	OctetString	 *form64,
	int		  indentlen
)

#else

OctetString *aux_de64(
	form64,
	indentlen
)
OctetString	 *form64;
int		  indentlen;

#endif

{
	OctetString * text; /*return*/
	int	lind;
	int	index = 0;
	int	i;
	char	*proc = "aux_de64";

	if ( !(text = (OctetString * )malloc(sizeof(OctetString))) ) {
		aux_add_error(EMALLOC, "text", CNULL, 0, proc);
		return( (OctetString * )0 );
	}
	text->noctets = form64->noctets; /*worst case: can't be longer*/
	if ( !(text->octets = malloc(text->noctets)) ) {
		aux_add_error(EMALLOC, "text->octets", CNULL, 0, proc);
		free(text);
		return( (OctetString * )0 );
	}
	i = 0;
	while(i<indentlen && form64->octets[i] == ' ') i++;

	while(i < form64->noctets) {
		if(form64->octets[i] == '\r' || form64->octets[i] == '\n' ) {
			i++;
			if(form64->octets[i] == '\r' || form64->octets[i] == '\n' ) i++;
			i += indentlen;
		}
		else *(text->octets + index++) = *(form64->octets + i++);
	}
	text->octets = (char *)realloc(text->octets, index);
	text->noctets = index;
	return( text );
}     /* end aux_de64() */


