/* ./src/aux/aux_dname.c */

static char *rcsid = "$Id: aux_dname.c,v 1.8 1995/03/10 07:28:11 surkau Exp $";

/* 
 *
 * $Id: aux_dname.c,v 1.8 1995/03/10 07:28:11 surkau Exp $
 *
 * $Log: aux_dname.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/
#ifdef MAC
#include <stdlib.h>
#include <string.h>
#endif 


#include <ctype.h>

#include "af.h"
#ifdef ICR1
#include "ul/psap.h"
#else
#include "psap.h"
#endif

/* length of char string error message: */
#define  ERR_LEN 160

/* #define  OK           0  */
#define  BAD_ADDRESS -1
#define T61_MARK '$'
#define aux_prtparse(z)	(aux_check_print_string(z) ? aux_cpy_String(z) : NULLCP)

static char	* Equal_string = "=" ;
static char	* strong_Delimiter_string = ", " ;
static char	* weak_Delimiter_string = "+ " ;

static unsigned char escapes[16][17] = {
	'A','C','E','I','N','O','U','Y', 
	'a','c','e','i','n','o','u','y', ' ',

/* Grave upper case */
	0xc0, '?', 0xc8, 0xcc, '?', 0xd2, 0xd9, '?',  
/* Grave lower case */
	0xe0, '?', 0xe8, 0xec, '?', 0xf2, 0xf9, '?', '`', 

/* Acute upper case */
	0xc1, '?', 0xc9, 0xcd, '?', 0xd3, 0xda, 0xdd,
/* Acute lower case */
	0xe1, '?', 0xe9, 0xed, '?', 0xf3, 0xfa, 0xfd, '\'',

/* Circumflex upper case */
	0xc2, '?', 0xca, 0xce, '?', 0xd4, 0xdb, '?', 
/* Circumflex lower case */
	0xe2, '?', 0xea, 0xee, '?', 0xf4, 0xfb, '?', '?',

/* Tilde upper case */
	0xc3, '?', 0xcb, 0xcf, 0xd1, 0xd5, 0xdc, '?', 
/* Tilde lower case */
	0xe3, '?', 0xeb, 0xef, 0xf1, 0xf5, 0xfc, '?', '?',

/* Macron upper case */
	'?', '?', '?', '?', '?', '?', '?', '?',   
/* Macron lower case */
	'?', '?', '?', '?', '?', '?', '?', '?',  '?', 

/* ? upper case */
	'?', '?', '?', '?', '?', '?', '?', '?', 
/* ? lower case */
	'?', '?', '?', '?', '?', '?', '?', '?',  '?',

/* Dot upper case */
	0xc5, '?', '?', '?', '?', '?', '?', '?',
/* Dot lower case */
	0xe5, '?', '?', '?', '?', '?', '?', '?', '?', 

/* Diaresis upper case */
        0xc4, '?', 0xcb, 0xcf, '?', 0xd6, 0xdc, 0x82,
/* Diaresis lower case */
        0xe4, '?', 0xeb, 0xef, '?', 0xf6, 0xfc, 0xff, '"',

/* Umlaut upper case */
        0xc4, '?', 0xcb, 0xcf, '?', 0xd6, 0xdc, 0x82,
/* Umlaut lower case */
        0xe4, '?', 0xeb, 0xef, '?', 0xf6, 0xfc, 0xff, '"',

/* Ring upper case */
	0xc5, '?', '?', '?', '?', '?', '?', '?', 
/* Ring lower case */
	0xe5, '?', '?', '?', '?', '?', '?', '?', '?',

/* Cedilla upper case */
	'?', 0xc7, '?', '?', '?', '?', '?', '?',
/* Cedilla lower case */
	'?', 0xe7, '?', '?', '?', '?', '?', '?',  '?', 

/* Underline upper case */
	'?', '?', '?', '?', '?', '?', '?', '?',
/* Underline lower case */
	'?', '?', '?', '?', '?', '?', '?', '?',  '_', 

/* Umlaut upper case */
        0xc4, '?', 0xcb, 0xcf, '?', 0xd6, 0xdc, 0x82,
/* Umlaut lower case */
        0xe4, '?', 0xeb, 0xef, '?', 0xf6, 0xfc, 0xff, '"',

/* Cedilla? upper case */
	'?', 0xc7, '?', '?', '?', '?', '?', '?',
/* Cedilla? lower case */
	'?', 0xe7, '?', '?', '?', '?', '?', '?',  '?', 

/* ? upper case */
	'?', '?', '?', '?', '?', '?', '?', '?',
/* ? lower case */
	'?', '?', '?', '?', '?', '?', '?', '?', '?'
};

static unsigned char trans[32] = {
	'?', 0xc6, 0xd0, '?', '?', '?', '?', 'L', 
	'L', 0xd8, '?', '?', 0xde, 'T', 'N', 'n',
	'K', 0xe6, 'd', 0xf0, 'h', 'i', '?', 'l',
	'l', 0xf8, '?', 0xdf, 0xfe, 't', 'N', '?'};


#ifdef __STDC__
	static void	Bld_ava	(char *key, char *attr, AttrValueAssertion **Ava, int *rc);
	static RDName * aux_str2RDName(char *str);
	static char   * aux_local_t61(char *a);
	static char   * aux_unquotechar(register char * a, register char * b);
	static char   * aux_octparse(register char * str);
	static char   * aux_t61parse(char * str);
	static unsigned char * aux_iso8859convert(char * sstr);
	static char   * aux_TidyString2(register char * a);
	static char   * aux_prtsdec(PE pe);
	static char   * aux_t61dec(PE pe);
#else
	static void	Bld_ava	();
	static RDName * aux_str2RDName();
	static char   * aux_local_t61();
	static char   * aux_unquotechar();
	static char   * aux_octparse();
	static char   * aux_t61parse();
	static unsigned char * aux_iso8859convert();
	static char   * aux_TidyString2();
	static char   * aux_prtsdec();
	static char   * aux_t61dec();
#endif


/************* local functions: ******************************/

/***************************************************************
 *
 * Procedure Bld_ava
 *
 ***************************************************************/
#ifdef __STDC__

static void Bld_ava(
	char					 *key,
	char					 *attr,
	AttrValueAssertion	**Ava,
	int					 *rc
)

#else

static void Bld_ava(
	key,
	attr,
	Ava,
	rc
)
char					 *key;
char					 *attr;
AttrValueAssertion	**Ava;
int					 *rc;

#endif

{
	ObjId * at;                   	/* AttributeType */
	PE av = NULLPE;       		/* storage for printable string AttributeValue */
	int	avlen = strlen(attr); 	/* length of   printable string AttributeValue */
	char  * proc = "Bld_ava";

	/* *rc=OK set by calling routine aux_str2RDName() */

	if (  (at = aux_keyword2oid(key)) == (ObjId * )0 ) {
		*rc = BAD_ADDRESS;
	} 
	else {		/* legal keyword */
		if (*attr){ 		 /* keyword value not empty */
			if(*attr == T61_MARK)
				av = t61s2prim(attr + 1, avlen - 1);
			else
				av = prts2prim(attr, avlen);
		}
		else
			*rc = BAD_ADDRESS;

		if ( *rc == OK ) {
			(*Ava) = (AttrValueAssertion *)malloc(
			    sizeof(AttrValueAssertion ) );
			if (!(*Ava)) {
				aux_add_error(EMALLOC, "(*Ava)", CNULL, 0, proc);
				*rc = -1;
				return;
			}
			(*Ava)->element_IF_0 = (OIDentifier * )at;
			(*Ava)->element_IF_1 = av;
		}
	}   /*end else "legal keyword"*/
}


/***************************************************************
 *
 * Procedure aux_str2RDName
 *
 ***************************************************************/
#ifdef __STDC__

static RDName *aux_str2RDName(
	char	 *name
)

#else

static RDName *aux_str2RDName(
	name
)
char	 *name;

#endif

{
	char	*ptr, *str, *save;
	char	*key, *value, * tmp_value;
	char	*pbuff;
	RDName * rdn;
	AttrValueAssertion *Ava;
	int	rc;
	ObjId * syntax_oid;
	char	*proc = "aux_str2RDName";

	Ava = (AttrValueAssertion * ) 0;

	/* look for "type = value" */

	if (name == NULLCP) {
		aux_add_error(EINVALID, "NULL rdn component", CNULL, 0, proc);
		return (NULLRDNAME);
	}

	if(!(save = str = aux_cpy_String(name))) {
		aux_add_error(EMALLOC, "str", CNULL, 0, proc);
		return (NULLRDNAME);
	}

	rc = OK;

	if ((ptr = strchr(str, *Equal_string)) == CNULL) {
		aux_add_error(EINVALID, "Equals missing in RDN", str, char_n, proc);
		return (NULLRDNAME);
	}


	*ptr = '\0';
	ptr++;

	while (*str == ' ' || *str == '\t')
		str++;
	key = str;

	if (*ptr == 0) {
		aux_add_error(EINVALID, "Attribute Value missing in RDN", str, char_n, proc);
		free(save);
		return (NULLRDNAME);
	}

	key = str_up(key);
	value = ptr;

	/* 'key = value' parsed */


	/* check up syntax of value */

	syntax_oid = aux_keyword2syntaxoid(key);
	if (!aux_cmp_ObjId(syntax_oid, CountryString)) {
/*
		if (!aux_check_3166(value)) {
			aux_add_error(EINVALID, "Invalid country code", value, char_n, proc);
			free(save);
			return (NULLRDNAME);
		}
*/
		if (strlen (value) != 2) {
			aux_add_error(EINVALID, "Country code size wrong", value, char_n, proc);
			free(save);
			return (NULLRDNAME);
		}
		if (islower ((u_char) value[0]))
			value[0] = toupper (value[0]);
		if (islower ((u_char) value[1]))
			value[1] = toupper (value[1]);
	}
	else{

/*
		if (!aux_cmp_ObjId(syntax_oid, PrintableString) || !aux_cmp_ObjId(syntax_oid, CaseIgnoreString)) {
			if (!aux_check_print_string(value)) {
				aux_add_error(EINVALID, "No printable string", CNULL, 0, proc);
				free(save);
				return (NULLRDNAME);
			}
		}
*/

		tmp_value = aux_t61parse (value);
		if(tmp_value != value){
			if(value) free(value);
			value = tmp_value;
		}
	}

	Bld_ava (key, value, &Ava, &rc);

	free(save);

	if (rc == OK) {    /* build RDN consisting of one Ava */

		rdn = (RDName *)malloc(
		    sizeof(RDName ) );
		if (!rdn) {
			aux_add_error(EMALLOC, "rdn", CNULL, 0, proc);
			return(NULLRDNAME);
		}
		rdn->next = NULLRDNAME;
		rdn->member_IF_0 = Ava;
	} 
	else {
		aux_add_error(EINVALID, "Bld_ava failed", CNULL, 0, proc);
		return (NULLRDNAME);
	}

	return (rdn);
}


/***************************************************************
 *
 * Procedure aux_local_t61
 *
 ***************************************************************/

#ifdef __STDC__

static char * aux_local_t61(
	char	 * a
)

#else

static char * aux_local_t61(
	a
)
char	 * a;

#endif

{
	char    * b;
	char	* proc = "aux_local_t61";

	if (a == NULLCP)
		return (NULLCP);

	b = smalloc (strlen(a) +2);
	*b++ = T61_MARK;
	(void) strcpy (b,a);
	(void) free (a);
	return (--b);
}


/***************************************************************
 *
 * Procedure aux_unquotechar
 *
 ***************************************************************/

#ifdef __STDC__

static char * aux_unquotechar(
	register char	* a,
	register char 	* b
)

#else

static char * aux_unquotechar(
	a,
	b
)
register char	 * a;
register char	 * b;

#endif

{
	int    val;
	char * proc = "aux_unquotechar";

#ifdef NICER_ESCAPES

        switch (*a) {
        case '\\':
                *b = '\\';
                break;
        case 'n':
            *b = '\n';
            break;

        case 't':
            *b = '\t';

        case 'r':
            *b = '\r';
            break;

#ifndef	TIDY_STRING
       case ' '
           *b = ' ';
	   break;
#endif

        default:
		if (isxdigit((*a) & 0xff) && sscanf (a,"%2x", &val) == 1) {
                	*b = val & 0xff;
                	a++;
            	} 
	    	else
			aux_add_error(EINVALID, "Bad Quoted character", CNULL, 0, proc);
	    	break;

        }
#else
	if (*a == '\\') 
		*b = '\\';
	else {
		if (sscanf (a,"%2x", &val) == 1) {
			*b = val & 0xff;
			a++;
		} 
		else
			aux_add_error(EINVALID, "Bad Quoted character", CNULL, 0, proc);
	}
#endif
	return (a);
}


/***************************************************************
 *
 * Procedure aux_octparse
 *
 ***************************************************************/

#ifdef __STDC__

static char * aux_octparse(
	register char	 * str
)

#else

static char * aux_octparse(
	str
)
register char	 * str;

#endif

{
	char 	          buffer [BUFSIZ];
	register char   * ptr=buffer;
	register int 	  i;
	char 		* proc = "aux_octparse";


        for (i=0; *str != 0; str++,i++) {
                if (*str != '\\')
                        *ptr++ = *str;
                else {
			str++, i++;
                        str = aux_unquotechar (str,ptr);
			ptr++;
		}
		if ( i >= BUFSIZ ) {
			aux_add_error(EINVALID, "String too long", CNULL, 0, proc);	
			return NULLCP;
		}
	}
	*ptr = 0;
	return (aux_cpy_String(buffer));
}


/***************************************************************
 *
 * Procedure aux_t61parse
 *
 ***************************************************************/

#ifdef __STDC__

static char * aux_t61parse(
	char	 * str
)

#else

static char * aux_t61parse(
	str
)
char	 * str;

#endif

{
	char * res, * tmp_str;
	char * proc = "aux_t61parse";


	if(! str){
		aux_add_error(EINVALID, "No parameter provided", CNULL, 0, proc);
		return(CNULL);
	}

	if (strstr(str, "{T.61}") != CNULL )
		return (aux_local_t61(aux_octparse(str)));
	
	return(str);
}


/***************************************************************
 *
 * Procedure aux_iso8859convert
 *
 ***************************************************************/

#ifdef __STDC__

static unsigned char * aux_iso8859convert(
	char	* sstr
)

#else

static unsigned char * aux_iso8859convert(
	sstr
)
char 	* sstr;

#endif

{
	unsigned char 		* str;
	int 			  n;
	static unsigned char    * buff = (unsigned char *)0;
	unsigned char 		* optr, * ret;
	char	 	        * proc = "aux_iso8859convert";


  	if (buff == (unsigned char *)0){
		buff = (unsigned char *) smalloc (BUFSIZ);
		if(! buff){
			aux_add_error(EMALLOC, "buff", CNULL, 0, proc);
			return((unsigned char *) 0);
		}
	}

  	optr = buff;

  	str = (unsigned char *) sstr;

  	while (*str != '\0'){
		if ((*str > 0x1f) && (*str < 0x80)) {
		    	*optr++ = *str++;
		}
	      	else if ((*str>0xa0) && (*str < 0xc0)) { 
		    	*optr++ = *str++;
	    	}
	      	else if (*str > 0xdf) {
		    	*optr++ = trans[((int)(*str++)) - 0xe0];
	    	}
	      	else if ((*str > 0xbf) && (*str < 0xd0)) {
		    	n = (int) (*str - (unsigned char) 0xc0);
		    	str++;
		    	if (*str == '\0')
			    	return((unsigned char *) 0);
		    	switch (*str) {
		       	case 'A':
			    	*optr++ = escapes[n][0];
			    	break;
		       	case 'C':
			    	*optr++ = escapes[n][1];
			    	break;
		       	case 'E':
			    	*optr++ = escapes[n][2];
			    	break;
		       	case 'I':
			    	*optr++ = escapes[n][3];
			    	break;
		       	case 'N':
			    	*optr++ = escapes[n][4];
			    	break;
		       	case 'O':
			    	*optr++ = escapes[n][5];
			    	break;
		       	case 'U':
			    	*optr++ = escapes[n][6];
			    	break;
		       	case 'Y':
			    	*optr++ = escapes[n][7];
			    	break;
		       	case 'a':
			    	*optr++ = escapes[n][8];
			    	break;
		       	case 'c':
			    	*optr++ = escapes[n][9];
			    	break;
		       	case 'e':
			    	*optr++ = escapes[n][10];
			    	break;
		       	case 'i':
			    	*optr++ = escapes[n][11];
			    	break;
		       	case 'n':
			    	*optr++ = escapes[n][12];
			    	break;
		       	case 'o':
			    	*optr++ = escapes[n][13];
			    	break;
		       	case 'u':
			    	*optr++ = escapes[n][14];
			    	break;
		       	case 'y':
			    	*optr++ = escapes[n][15];
			    	break;
		       	case ' ':
			    	*optr++ = escapes[n][16];
			    	break;
		       	default:
			    	*optr++ = '?';
		     	}; /* switch */

		    	str++;
		}
		else str++;
  	};
  	*optr++ = '\0';

	ret = (unsigned char *)malloc(strlen((char *)buff) + 1);
	if(! ret){
		aux_add_error(EMALLOC, "ret", CNULL, 0, proc);
		return((unsigned char *) 0);
	}
	(void) strcpy((char *)ret, (char *)buff);

  	return(ret);
}



/***************************************************************
 *
 * Procedure aux_TidyString2
 *
 ***************************************************************/

#ifdef __STDC__

static char * aux_TidyString2(
	register char * a
)

#else

static char * aux_TidyString2(
	a
)
register char * a;

#endif

{
	register char 	* b;
	char     	* c;
	register   	  int i = 0;
	char	 	* proc = "aux_TidyString2";


	/* removing multiple and trailing spaces */
	c = a, b = a;
	while (*a) {
		if (isascii(*a) && isspace (*a)) {
			*b = ' ';       /* make sure not a tab etc */
			a++;
			while (isascii(*a) && isspace (*a)) {
				a++;
				i = 1;
			}

			if (*a)
				b++;
			else
				break;
		}
		if (i)
			*b = *a;

		a++, b++;
	}

	*b = 0;

	if (*--b == '\n')
		*b-- = 0;

	if (*b == ' ')
		*b = 0;

	return (c);
}


/***************************************************************
 *
 * Procedure aux_prtsdec
 *
 ***************************************************************/

#ifdef __STDC__

static char * aux_prtsdec(
	PE	pe
)

#else

static char * aux_prtsdec(
	pe
)
PE	pe;

#endif

{
	int       z;
	char    * p, *ptr, val;
	char	* proc = "aux_prtsdec";


	if (PE_ID(pe->pe_class, pe->pe_id) == PE_ID(PE_CLASS_UNIV,PE_DEFN_PRTS)) {
		ptr = prim2str(pe,&z);
		val = *ptr;
		if (((p = aux_TidyString2(ptr)) == NULLCP) || (*p == 0))
			if (val == ' ') {
				free (p);	
			    	return aux_cpy_String (" ");
		    	} 
			else
			    	return NULLCP;

		if (aux_check_print_string(p))
			return (p);
		free (p);
	}
	return (NULLCP);
}


/***************************************************************
 *
 * Procedure aux_t61dec
 *
 ***************************************************************/

#ifdef __STDC__

static char * aux_t61dec(
	PE pe
)

#else

static char * aux_t61dec(
	pe
)
PE	pe;

#endif

{
	int       z;
	char    * ptr, *p2, val;
	int	  avlen = 0;      /* length of printable string AttributeValue */
	char	* proc = "aux_t61dec";


	if (pe->pe_form != PE_FORM_PRIM) {
		aux_add_error(EINVALID, "Primative string expected", CNULL, 0, proc);
		return NULLCP;
	}

	if ( PE_ID (pe -> pe_class, pe -> pe_id) == PE_ID (PE_CLASS_UNIV,PE_DEFN_T61S) ) {
		ptr = prim2str(pe,&z);
		val = *ptr;
		if (((p2 = aux_TidyString2(ptr)) == NULLCP) || (*p2 == 0))
			if (val == ' ') {
			    	free (p2);	
			    	p2 = aux_cpy_String ("  ");
			    	*p2 = T61_MARK;
			    	return p2;
			} 
			else
			    return NULLCP;
		return (aux_local_t61 (p2));
	} 
	else if (PE_ID(pe->pe_class, pe->pe_id) == PE_ID(PE_CLASS_UNIV,PE_DEFN_PRTS))
		return(prim2str(pe, &avlen));

	else 
		return (CNULL);
}


/************* external functions: ***************************/

/************* char string subfunctions imported**************/
/************* from EAN Version 1 str.h/str.c   **************/

int catstr( /* char **ptr_str, int *ptr_len, char *new */);

char*
str_up( /* char *str */ );


/****************************************************************/





/***************************************************************
 *
 * Procedure aux_append_RDName
 *
 ***************************************************************/
#ifdef __STDC__

void aux_append_RDName(
	RDName	 *a,
	RDName	 *b
)

#else

void aux_append_RDName(
	a,
	b
)
RDName	 *a;
RDName	 *b;

#endif

{
	register RDName *ptr;
	register RDName *eptr;
	char	*pbuff;
	char	*proc = "aux_append_RDName";

	if (a == NULLRDNAME) {
		aux_add_error(EINVALID, "appending to null rdn", CNULL, 0, proc);
		return;
	} 

	for (eptr = a; eptr != NULLRDNAME; eptr = eptr->next)
		ptr = eptr;
	ptr->next = b;

	return;
}


/****************************************************************/


/***************************************************************
 *
 * Procedure str2RDName
 *
 ***************************************************************/
#ifdef __STDC__

RDName *str2RDName(
	char	 *name
)

#else

RDName *str2RDName(
	name
)
char	 *name;

#endif

{
	register char	* ptr, *str, *save;
	RDName          * rdn = NULLRDNAME, * newrdn;
	char	        * proc = "str2RDName";

	/* look for "rdn % rdn % rdn" */

	if (name == NULLCP)
		return (NULLRDNAME);

	if(!(save = str = aux_cpy_String(name))) {
		aux_add_error(EMALLOC, "str", CNULL, 0, proc);
		return (NULLRDNAME);
	}

	while ( (ptr = strchr (str, *weak_Delimiter_string)) != CNULL) {
		*ptr = '\0';
		ptr++;

		if ((newrdn = aux_str2RDName (str)) == NULLRDNAME) {
			if(rdn) free (rdn);
			free(save);
			AUX_ADD_ERROR;
			return (NULLRDNAME);
		}

		if ( rdn == NULLRDNAME )
			rdn = newrdn;
		else
			aux_append_RDName(rdn, newrdn);

		str = ptr;
	}

	if ((newrdn = aux_str2RDName (str)) == NULLRDNAME) {
		if(rdn) free (rdn);
		free(save);
		AUX_ADD_ERROR;
		return (NULLRDNAME);
	}

	free(save);

	if ( rdn == NULLRDNAME )
		rdn = newrdn;
	else
		aux_append_RDName(rdn, newrdn);

	return (rdn);
}


/****************************************************************/


/***************************************************************
 *
 * Procedure aux_Name2DName
 *
 ***************************************************************/
#ifdef __STDC__

DName *aux_Name2DName(
	register char	 *name
)

#else

DName *aux_Name2DName(
	name
)
register char	 *name;

#endif

{
	register char	*ptr, *str, *save;
	DName   * dn = NULLDNAME;
	RDName  * rdn;
	char    * invalid_str;
	char	* proc = "aux_Name2DName";

	if (name == NULLCP)
		return (NULLDNAME);

	if(!(save = str = aux_cpy_String(name))) {
		aux_add_error(EMALLOC, "str", CNULL, 0, proc);
		return (NULLDNAME);
	}

	if (*str == *strong_Delimiter_string)
		str++;		/* Skip leading ';' signs */

	while ( (ptr = strchr (str, *strong_Delimiter_string)) != CNULL) {
		*ptr = '\0';
		ptr++;

		if ((rdn = str2RDName (str)) == NULLRDNAME) {
			invalid_str = aux_cpy_String(str);
			aux_free_DName (&dn);
			free(save);
			aux_add_error(EINVALID, "Cannot transform string into Relative Distinguished Name", invalid_str, char_n, proc);
			return (NULLDNAME);
		}
		if (dn == NULLDNAME)
			dn = DName_comp_new (rdn);
		else
			aux_append_DName (dn, DName_comp_new (rdn));

		str = ptr;
	}
	if ((rdn = str2RDName (str)) == NULLRDNAME) {
		aux_free_DName (&dn);
		aux_add_error(EINVALID, "Cannot transform string into Relative Distinguished Name", str, char_n, proc);
		return (NULLDNAME);
	}

	free(save);

	if (dn == NULLDNAME)
		dn = DName_comp_new (rdn);
	else
		aux_append_DName (dn, DName_comp_new (rdn));

	return (dn);
}


/****************************************************************/


/***************************************************************
 *
 * Procedure aux_append_DName
 *
 ***************************************************************/
#ifdef __STDC__

void aux_append_DName(
	DName	 *a,
	DName	 *b
)

#else

void aux_append_DName(
	a,
	b
)
DName	 *a;
DName	 *b;

#endif

{
	register DName *ptr;
	register DName *eptr;
	char	*pbuff;
	char	*proc = "aux_append_DName";

	if (a == NULLDNAME) {
		aux_add_error(EINVALID, "appending to null dn", CNULL, 0, proc);
		return;
	} 

	if (b == NULLDNAME) 
		return;
	for (eptr = a; eptr != NULLDNAME; eptr = eptr->next)
		ptr = eptr;
	ptr->next = b;

	return;
}


/****************************************************************/


/***************************************************************
 *
 * Procedure DName_comp_new
 *
 ***************************************************************/
#ifdef __STDC__

DName *DName_comp_new(
	RDName	 *rdn
)

#else

DName *DName_comp_new(
	rdn
)
RDName	 *rdn;

#endif

{
	DName   * ptr;
	char	* proc = "DName_comp_new";

	if (!rdn) 
		return(NULLDNAME);
	ptr = (DName *)malloc( sizeof(DName ) );
	if (!ptr) {
		aux_add_error(EMALLOC, "ptr", CNULL, 0, proc);
		return(NULLDNAME);
	}
	ptr->element_IF_2 = rdn;
	ptr->next = NULLDNAME;
	return (ptr);
}


/****************************************************************/


/***************************************************************
 *
 * Procedure aux_DName2Name
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_DName2Name(
	DName	 *name_ae
)

#else

char *aux_DName2Name(
	name_ae
)
DName	 *name_ae;

#endif

{
	char		* name,  * tmp,  * keyword, zwb[16];
	unsigned char   * iso8859_string;
	int		  len, i;
	int		  flag;
	AttrValueAssertion *ava;
	RDName   	* rdn;
	DName    	* name_cur;
	PE 		  av = NULLPE;    /* storage for printable string AttributeValue */
	char		* proc = "aux_DName2Name";

	name = aux_cpy_String ("");
	len  = strlen(name) + 1;

	if ( !name_ae ) 
		return (name) ;

	for ( name_cur = name_ae; name_cur; name_cur = name_cur->next ) {
		flag = 0;
		for ( rdn = name_cur->element_IF_2; rdn; rdn = rdn->next ) {
			if (( ava = rdn->member_IF_0 )) {
				keyword = aux_oid2keyword(ava->element_IF_0);
				if (flag) 
					catstr(&name, &len, weak_Delimiter_string);
				if (!flag ) 
					flag = 1;
				if (keyword) {
					catstr (&name, &len, keyword );
					catstr (&name, &len, Equal_string);
				} else {
					catstr (&name, &len, "{ ");
					for ( i = 0; i < ava->element_IF_0->oid_nelem; i++) {
						sprintf(zwb, "%d ", ava->element_IF_0->oid_elements[i]);
						catstr (&name, &len, zwb);
					}
					catstr (&name, &len, "}");		
/*					catstr (&name, &len, "??"); */
					catstr (&name, &len, Equal_string);
				}

				tmp = aux_t61dec(ava->element_IF_1);
				if (tmp && *tmp == T61_MARK) {
					if (strstr(tmp, "{T.61}") != CNULL )
						iso8859_string = aux_iso8859convert(tmp + 7);
					else
						iso8859_string = aux_iso8859convert(tmp + 1);
					if(tmp) free(tmp);
					tmp = (char * ) calloc (1, strlen((char *)iso8859_string) + 1);
					(void) strcpy(tmp, (char *)iso8859_string);
					if(iso8859_string) free(iso8859_string);
				}
				if(tmp) catstr (&name, &len, tmp) ;
				else catstr (&name, &len, "Unknown Syntax");
				if(tmp) free(tmp);

			}  /*if ava exists*/
		}  /*for all AVAs in one RDN*/
		if ( name_cur->next )
			catstr(&name, &len, strong_Delimiter_string);
	}  /*for all RDNs in one Name*/

	return( name );
}

/****************************************************************/


/***************************************************************
 *
 * Procedure aux_DName2Attr
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_DName2Attr(
	DName	 *name_ae,
	char	 *attr_key
)

#else

char *aux_DName2Attr(
	name_ae,
	attr_key
)
DName	 *name_ae;
char	 *attr_key;

#endif

{
	char	*keyword;
	int	len;
	AttrValueAssertion *ava;
	RDName   * rdn;
	DName    * name_cur;
	PE av     = NULLPE;       /* storage for printable string AttributeValue */
	int	avlen = 0;            /* length of   printable string AttributeValue */
	char	* proc = "aux_DName2Attr";

	if ( !name_ae || !attr_key)	
		return (CNULL);

	for ( name_cur = name_ae; name_cur; name_cur = name_cur->next ) {
		for ( rdn = name_cur->element_IF_2; rdn; rdn = rdn->next ) {
			if (( ava = rdn->member_IF_0 )) {
				keyword = aux_oid2keyword(ava->element_IF_0);
        			if (keyword) if(!strcmp(keyword, attr_key)) return(prim2str(ava->element_IF_1, &avlen));
			}  /*if ava exists*/
		}  /*for all AVAs in one RDN*/
	}  /*for all RDNs in one Name*/

	return (CNULL);
}


/****************************************************************/


/***************************************************************
 *
 * Procedure aux_ORName2DName
 *
 ***************************************************************/
#ifdef __STDC__

DName *aux_ORName2DName(
	register char	 *name
)

#else

DName *aux_ORName2DName(
	name
)
register char	 *name;

#endif

{
	register char	*ptr, *str, *save;
	DName * dn = NULLDNAME;
	RDName * rdn;
	char	* proc = "aux_ORName2DName";
	
	if (name == NULLCP)
		return (NULLDNAME);

	if(!(save = str = aux_cpy_String(name))) {
		aux_add_error(EMALLOC, "str", CNULL, 0, proc);
		return (NULLDNAME);
	}
	if (*str == *strong_Delimiter_string)
		str++;		/* Skip leading ';' signs */

	while ( (ptr = strchr (str, *strong_Delimiter_string)) != CNULL) {
		*ptr = '\0';
		ptr++;

		rdn = str2RDName (str);

		if (dn == NULLDNAME)
			dn = DName_comp_new (rdn);
		else
			aux_append_DName (dn, DName_comp_new (rdn));

		str = ptr;
	}

	rdn = str2RDName (str);

	free(save);

	if (dn == NULLDNAME)
		dn = DName_comp_new (rdn);
	else
		aux_append_DName (dn, DName_comp_new (rdn));

	return (dn);
}



/****************************************************************/

/***************************************************************
 *
 * Procedure aux_DName2CAPITALName
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_DName2CAPITALName(
	DName	 *name_ae
)

#else

char *aux_DName2CAPITALName(
	name_ae
)
DName	 *name_ae;

#endif

{
	return(aux_DName2CAPITALString(name_ae, strong_Delimiter_string));
}

/***************************************************************
 *
 * Procedure aux_DName2CAPITALString
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_DName2CAPITALString(
	DName	 *name_ae,
	char     *separator
)

#else

char *aux_DName2CAPITALString(
	name_ae,
	separator
)
DName	 *name_ae;
char     *separator;

#endif

{
	char	* name,  * tmp, * keyword;
	int	  len;
	int	  flag;
	AttrValueAssertion * ava;
	RDName  * rdn;
	DName   * name_cur;
	PE        av = NULLPE;       /* storage for printable string AttributeValue */
	int	  avlen = 0;            /* length of   printable string AttributeValue */
	char	* proc = "aux_DName2CAPITALString";

	name = aux_cpy_String ("");
	len  = strlen(name) + 1;

	if ( !name_ae ) 
		return (name) ;

	for ( name_cur = name_ae; name_cur; name_cur = name_cur->next ) {
		flag = 0;
		for ( rdn = name_cur->element_IF_2; rdn; rdn = rdn->next ) {
			if (( ava = rdn->member_IF_0 )) {
				keyword = aux_oid2keyword(ava->element_IF_0);
				if (flag) 
					catstr(&name, &len, weak_Delimiter_string);
				if (!flag ) 
					flag = 1;
				if (keyword) {
					catstr (&name, &len, keyword );
					catstr (&name, &len, Equal_string);
				} else {
					catstr (&name, &len, "??");
					catstr (&name, &len, Equal_string);
				}

				tmp = prim2str( ava->element_IF_1, &avlen );
				tmp = str_up(tmp);
				catstr (&name, &len, tmp) ;
				if(tmp) free(tmp);

			}  /*if ava exists*/
		}  /*for all AVAs in one RDN*/
		if ( name_cur->next )
			catstr(&name, &len, separator);
	}  /*for all RDNs in one Name*/

	return( name );
}

/***************************************************************
 *
 * Procedure append_RDNameoralias
 *
 ***************************************************************/
#ifdef __STDC__

char *append_RDNameoralias(
	char	 *dir,
	char	 *rdname,
	Boolean	  create
)

#else

char *append_RDNameoralias(
	dir,
	rdname,
	create
)
char	 *dir;
char	 *rdname;
Boolean	  create;

#endif

{
	static char	 ret[512];
	char		 filename[512];
	char		 alias[512];
	char		 name[512];
	OctetString	*rdntable;	
	int		 n, m, line = 0, rdn_start;
	FILE 		*fp;

	strcpy(ret, dir);
	strcat(ret, PATH_SEPARATION_STRING);
	strcat(ret, rdname);

	/*
	 *    directory dir/rdname exists ?
	 */
	if(aux_file_type(ret) == F_DIRECTORY) return(ret);
	

	strcpy(filename, dir);
	strcat(filename, PATH_SEPARATION_STRING);
	strcat(filename, AFDB_RDN_ALIAS_FILE);

	/*
	 *    read rdntable for aliases
	 */
	if((rdntable = aux_file2OctetString(filename))) {
		while(line < rdntable->noctets) {
			/*
			 *    check one line
			 */
			/*
			 *    search for : or line end
			 */
			for(n = line; n < rdntable->noctets && 
					rdntable->octets[n] != ':' &&
					rdntable->octets[n] != '\n' &&
					rdntable->octets[n] != 0x0d; n++);
	
			if(n == rdntable->noctets || n - line > 500) break;
			if(rdntable->octets[n] == '\n') {
				line = n+1;
				continue;
			}
			if(rdntable->octets[n] == 0x0d) {
				line = n+2;
				continue;
			}
			/*
			 *    found alias
			 */
			strncpy(alias, rdntable->octets + line, n - line);
			alias[n - line] = '\0';
	
			/*
			 *    search for line end
			 */
			rdn_start = n + 1;
			for(n = rdn_start; n < rdntable->noctets && 
					rdntable->octets[n] != '\n' &&
					rdntable->octets[n] != 0x0d; n++);
	
			if(n - rdn_start > 500) break;
	
			/*
			 *    found rdname
			 */
	
			strncpy(name, rdntable->octets + rdn_start, n - rdn_start);
			name[n - rdn_start] = '\0';
	
			if(n == rdntable->noctets) {
				line = n;
			}
			else if(rdntable->octets[n] == '\n') {
				line = n+1;
			}
			else if(rdntable->octets[n] != 0x0d) {
				line = n+2;
			}
			if(!strcasecmp(rdname, name)) {
				/*
				 *    compare RDNames
				 */
				strcpy(ret, dir);
				strcat(ret, PATH_SEPARATION_STRING);
				strcat(ret, alias);
	
				/*
				 *    check if alias directory exists
				 */
				if(aux_file_type(ret) == F_DIRECTORY) return(ret);
				break;
			}
		}
	}
	aux_free_error();

	if(!rdntable) {
		strcpy(ret, dir);
		strcat(ret, PATH_SEPARATION_STRING);
		strcat(ret, rdname);

		if(mkdir(ret, 0775) >= 0) {
			return(ret);
		}
		else aux_add_error(ESYSTEM, "Can't create directory", ret, char_n, proc);
	}
	fp = fopen(filename, "a+");
	if(fp) {
		for(n = 0; rdname[n] != '=' && rdname[n] != '\0'; n++);
		if(rdname[n] != '=') n = 0;
		for(m = 0; rdname[n] != '\0' && m < 8; n++)
			if(	(rdname[n] >= '0' && rdname[n] <= '9') ||
				(rdname[n] >= 'a' && rdname[n] <= 'z') ||
				(rdname[n] >= 'A' && rdname[n] <= 'Z') ||
				(rdname[n] == '_' || rdname[n] == '-')   ) alias[m++] = rdname[n];

		alias[m++] = '\0';
		
		strcpy(ret, dir);
		strcat(ret, PATH_SEPARATION_STRING);
		strcat(ret, alias);

		if(mkdir(ret, 0775) >= 0) {
			fprintf(fp, "%s:%s\n", alias, rdname);
			fclose(fp);
			aux_free_error();
			return(ret);
		}
		aux_add_error(ESYSTEM, "Can't create directory", ret, char_n, proc);
		fclose(fp);
	}
	else aux_add_error(ESYSTEM, "Can't append to file", filename, char_n, proc);

	aux_free_OctetString(&rdntable);
	return(CNULL);

}
/***************************************************************
 *
 * Procedure aux_DName2afdbname
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_DName2afdbname(
	DName	 *dname,
	Boolean	  create
)

#else

char *aux_DName2afdbname(
	dname,
	create
)
DName	 *dname;
Boolean	  create;

#endif

{
	char *afdbname, *zwname, *zwname_malloc, zwname_part[512];
	int len, zwname_pos;
	char *next_dir, *err;
	char *proc = "aux_DName2afdbname";

	zwname = zwname_malloc = aux_DName2CAPITALString(dname, PATH_SEPARATION_STRING);
	if(!zwname) {
		aux_add_error(EINVALID, "Can't build AF-DB name from dname", CNULL, 0, proc);
		return((char *)0);
	}
	if(!(afdbname = malloc(1024))) {
		aux_add_error(EMALLOC, "Can't malloc afdbname", CNULL, 0, proc);
		return((char *)0);
	}
	strcpy(afdbname, AFDBFILE); 

	if(afdbname[strlen(afdbname) - 1] == PATH_SEPARATION_CHAR)
		afdbname[strlen(afdbname) - 1] = '\0';

	if(*zwname == PATH_SEPARATION_CHAR) zwname++;
	while(*zwname != '\0') {

		zwname_pos = 0;
		while(zwname[zwname_pos] != '\0' &&
		      zwname[zwname_pos] != PATH_SEPARATION_CHAR) 
			zwname_pos++;

		strncpy(zwname_part, zwname, zwname_pos);
		zwname_part[zwname_pos] = '\0';

		if(!zwname_pos) {
			return(CNULL);
		}
		if(!(next_dir = append_RDNameoralias(afdbname, zwname_part, create))) {
			if(create) err = CATSPRINTF(CNULL, "No AF-DB entry for <%s> could be create in path <%s>.", zwname_part, afdbname);
			else       err = CATSPRINTF(CNULL, "No AF-DB entry for <%s> found in path <%s>.", zwname_part, afdbname);
			aux_add_error(EINVALID, err, CNULL, 0, proc);
			free(err);
			return(CNULL);
		}
		strcpy(afdbname, next_dir);
		zwname += zwname_pos;
		if(*zwname == PATH_SEPARATION_CHAR) zwname++;
	}

	free(zwname_malloc);

	/* afdbname = .../.af-db/'zwname' */

	strcat(afdbname, PATH_SEPARATION_STRING);

	return(afdbname);
}

