/* ./src/aux/aux_fprint.c */

static char *rcsid = "$Id: aux_fprint.c,v 1.8 1995/03/01 11:18:04 surkau Exp surkau $";

/* 
 *
 * $Id: aux_fprint.c,v 1.8 1995/03/01 11:18:04 surkau Exp surkau $
 *
 * $Log: aux_fprint.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*-----------------------string = aux_sprint.c----------------------*/
/*------------------------------------------------------------------*/
/* GMD Darmstadt Institut fuer Telekooperationstechnik (I2)         */
/* Rheinstr. 75 / Dolivostr. 15                                     */
/* 6100 Darmstadt                                                   */
/* Grimm/Luehe/Nausester/Schneider/Viebeg et alii                   */
/*------------------------------------------------------------------*/
/*                                                                  */
/* DESCRIPTION                                                      */
/*   This modul presents functions to print SecuDe                  */
/*   relevant C-structures to a char pointer.                       */
/*                                                                  */
/* EXPORT                                                           */
/*                                                                  */
/*   *print means either print, fprint, or sprint                   */
/*                                                                  */
/*                           aux_*print_AliasList()                 */
/*                           aux_*print_NameOrAlias()               */
/*                           aux_*print_DNameOrAlias()              */
/*                           aux_*print_PKRoot()                    */
/*                           aux_*print_PSESel()                    */
/*                           aux_*print_Version()                   */
/*                           aux_*print_version()                   */
/*                           aux_*print_PSEToc()                    */
/*                           aux_*print_Serialnumber()              */
/*                           aux_*print_ToBeSigned()                */
/*                           aux_*print_AuthorisationAttributes()   */
/*                           aux_*print_RootInfo()                  */
/*                           aux_*print_CRLEntry()                  */
/*                           aux_*print_CRL()                       */
/*                           aux_*print_CRLTBS()                    */
/*                           aux_*print_OCList()                    */
/*                           aux_*print_CertificatePairSet()        */
/*                           aux_*print_Crl()                       */
/*                           aux_*print_CrlSet()                    */
/*                           aux_*print_IssuedCertificate()         */
/*                           aux_*print_SET_OF_IssuedCertificate()  */
/*                           aux_*print_SET_OF_Name()               */
/*                           aux_*print_CRLWithCertificates()       */
/*                           aux_*print_SET_OF_CRLWithCertificates()*/
/*                           aux_*print_VerificationResult()        */
/*                           aux_*print_TrustPath()                 */
/*                           aux_*print_PKList()                    */
/*                           aux_*print_PSEToc()                    */
/*                           aux_*print_Certificate()               */
/*                           aux_*print_FCPath()                    */
/*                           aux_*print_Certificates()              */
/*                           aux_*print_CertificateSet()            */
/*                           aux_*print_error()                     */
/*------------------------------------------------------------------*/
#include <stdio.h>
#include "pem.h"
#include "cadb.h"
#include "arithmetic.h"

#define BUFLEN 4096
#define ALGIDLEN 80
#define TIMLEN   40


#ifdef COSINE

#define NORMAL "Normal"
#define PRIVILEGED "Privileged"

static char	*AUTHATTR      = "    AuthorisationAttributes: ";
static char	*COID          = "      CountryID:  ";
static char	*GID           = "      GroupID:    ";
static char	*CLID          = "      ClassID:    ";
static char	*ECOID         = "CountryId missing";
static char	*EGID          = "GroupId missing";
static char	*ECLID         = "wrong ClassId";
#endif



static char	*VSN           = "Version:      ";
static char	*SER           = "SerialNumber: ";
static char	*ISS           = "IssuerName:   ";
static char	*FPR           = "Fingerprint:  ";
static char	*SPK           = "SubjectKey:   ";
static char	*SEK           = "SecretKeyAid: ";
static char	*IAI           = "IssuerAid:    ";
static char	*SIGN          = "Signature:    ";
static char	*SAI           = "SignatureAid: ";
static char	*VALNB         = "Validity:     NotBefore: ";
static char	*VALNA         = "              NotAfter:  ";
static char	*SUB           = "SubjectName:  ";
static char	*ROO           = "RootCaName:   ";
static char	*PKEY          = "PublicKey:    ";
static char	*HSHRESULT     = "Hash value of DER code of ToBeSigned: ";
static char	*DERCODE       = "DER code of ";
static char	*EPKROOT       = "PKRoot is NULL pointer";
static char	*EKEYBITS      = "KeyBits is NULL pointer";
static char	*ESERNUMS      = "SerialNumbers is NULL pointer";
static char	*EEKEYINFO     = "KeyInfo is NULL pointer";
static char	*EAID          = "AlgId is NULL pointer";
static char	*ECERT         = "Certificate is NULL pointer";
static char	*ECERTS        = "Certificates is NULL pointer";
static char	*ETBS          = "ToBeSigned is NULL pointer";
static char	*EVALID        = "Validity is NULL pointer";
static char	*EPSETOC       = "PSEToc is NULL pointer";
static char	*LASTUP        = "Last Update:  ";
static char	*NEXTUP        = "Next Update:  ";
static char	*AIRCA         = "Aid of Revoking CA:          ";
static char	*SIGNRCA       = "Signature of Revoking CA: ";
static char	*SAIRCA        = "SignatureAid of Revoking CA: ";
static char	*RCA           = "RevokingCAName:              ";
static char	*RSER          = "SerialNo:                    ";
static char	*REVDATE       = "Revocation Date:             ";
static char	*OLDSER	       = "Table's SerialNo: ";
static char	*ECRL          = "Revocation list is NULL pointer";
static char	*ECRLTBS       = "CRLTBS is NULL pointer";
static char	*ECRLENTRY     = "Revoked Certificate is NULL pointer";
static char	*EOCLIST       = "List of OldCertificates is NULL pointer";
static char	*ECERTSET      = "SET_OF_Certificate is NULL pointer";
static char	*ECERTPAIR     = "Certificate Pair is NULL pointer";
static char	*ECRLSETPSE    = "CrlSet is NULL pointer";
static char	*ECRLPSE       = "Crl is NULL pointer";
static char	*EISSCERT      = "IssuedCertificate is NULL pointer";
static char	*EISSCERTSET   = "SET_OF_IssuedCertificate is NULL pointer";
static char     *ECRLWITHCERTSSET = "SET_OF_CRLWithCertificates is NULL pointer";
static char     *ECRLWITHCERTS = "CRLWithCertificates is NULL pointer";
static char	*ISSUEDATE     = "    Date of Issue:  ";
static char	*ENAMESET      = "SET_OF_Name is NULL pointer";
static char	*VERRES        = "VerificationResult is NULL pointer";




/***************************************************************
 *
 * Procedure aux_sprint_KeyInfo
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_KeyInfo(
	char	 *string,
	KeyInfo	 *pki
)

#else

char *aux_sprint_KeyInfo(
	string,
	pki
)
char	 *string;
KeyInfo	 *pki;

#endif

{
	BitString  * bis;
        KeyBits *keybits;
        OctetString *keyoctets;
	int	n;

	if ( !pki ) {
		string = CATSPRINTF(string, "%s\n", EEKEYINFO);
		return(string);
	}

	if (print_keyinfo_flag & ALGID) 
		string = aux_sprint_AlgId(string, pki->subjectAI); 
	if (print_keyinfo_flag & ALGINFO) 
		string = aux_sprint_algorithm(string, pki->subjectAI->objid, CNULL); 
	if(!pki->subjectAI || !pki->subjectAI->objid) return(string);
	if (aux_ObjId2AlgEnc(pki->subjectAI->objid) == RSA || aux_ObjId2AlgEnc(pki->subjectAI->objid) == DSA) {
		print_indent += 10;
		bis = &(pki->subjectkey);
		n = bis->nbits / 8;
		if ( bis->nbits % 8 ) n++;
		if (print_keyinfo_flag & BSTR) {
			string = CATSPRINTF(string, "    DER code of Key BitString (no. of octets = %d):\n", n);
			string = aux_sxdump2(string, bis->bits, n, 0);
		}
		if (print_keyinfo_flag & KEYBITS) {
			if (aux_ObjId2AlgEnc(pki->subjectAI->objid) == RSA) {
				keybits = d_KeyBits(&(pki->subjectkey));
				if(keybits) {
					string = aux_sprint_KeyBits(string, keybits);
					aux_free_KeyBits(&keybits);
				}
			}
			else {
				keybits = (KeyBits *) calloc(1, sizeof(KeyBits));
				keyoctets = d_integer(&(pki->subjectkey));
				if(keybits && keyoctets) {
					keybits->part1.noctets = keyoctets->noctets;
					keybits->part1.octets = keyoctets->octets;
					keybits->part2.noctets = 0;
					keybits->part2.octets = CNULL;
					keybits->part3.noctets = 0;
					keybits->part3.octets = CNULL;
					keybits->part4.noctets = 0;
					keybits->part4.octets = CNULL;
					string = aux_sprint_KeyBits(string, keybits);
					aux_free_KeyBits(&keybits);
					free(keyoctets);
				}
			}
		}
		print_indent -= 10;
	} 
	else {
		if (print_keyinfo_flag & (BSTR | KEYBITS)) {
			print_indent += 10;
			n = pki->subjectkey.nbits;
			string = CATSPRINTF(string, "    Key (no. of bits = %d):\n", n);
			string = aux_sxdump2(string, pki->subjectkey.bits, n / 8, 0);
			print_indent -= 10;
		}
	}
	return(string);
}



/***************************************************************
 *
 * Procedure aux_sprint_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_AliasList(
	char		 *string,
	AliasList	 *aliaslist
)

#else

char *aux_sprint_AliasList(
	string,
	aliaslist
)
char		 *string;
AliasList	 *aliaslist;

#endif

{
	char	           	*proc = "aux_sprint_AliasList";
	register Aliases   	*aliasmember, * am;
	register AliasList 	*aa;


	if (!aliaslist) 
		return(CNULL); 

	aa = aliaslist;
	while (aa) {
		aliasmember = aa->a;
		while (aliasmember) {
                        string = CATSPRINTF(string, "%s --> <%s>\n", aliasmember->aname, aa->dname);
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}

	return(string);
}







/***************************************************************
 *
 * Procedure aux_sprint_DNameOrAlias
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_DNameOrAlias(
	char	 *string,
	DName	 *dname
)

#else

char *aux_sprint_DNameOrAlias(
	string,
	dname
)
char	 *string;
DName	 *dname;

#endif

{
	Name *name, *alias;

	name = aux_DName2Name(dname);
	if(!name) return(string);
	alias = aux_Name2alias(name, LOCALNAME);
	if(alias) {
		free(name);
		name = alias;
	}
	string = CATSPRINTF(string, "%s", name);
	free(name);
	return(string);
}
	
/***************************************************************
 *
 * Procedure aux_sprint_NameOrAlias
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_NameOrAlias(
	char	 *string,
	Name	 *name
)

#else

char *aux_sprint_NameOrAlias(
	string,
	name
)
char	 *string;
Name	 *name;

#endif

{
	Name *alias;

	if(!name) return(string);
	alias = aux_Name2alias(name, LOCALNAME);
	if(alias) {
		string = CATSPRINTF(string, "%s", alias);
		free(alias);
	}
	else string = CATSPRINTF(string, "%s", name);
	return(string);
}

/***************************************************************
 *
 * Procedure aux_sprint_GRAPHICString
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_GRAPHICString(
	char		 *string,
	char		 *graphic
)

#else

char *aux_sprint_GRAPHICString(
	string,
	graphic
)
char		 *string;
char		 *graphic;

#endif

{
	if(!graphic) return(string);
	string = CATSPRINTF(string, "Graphic String: %s\n", graphic);
	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_PSESel
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_PSESel(
	char	 *string,
	PSESel	 *pse
)

#else

char *aux_sprint_PSESel(
	string,
	pse
)
char	 *string;
PSESel	 *pse;

#endif

{
	if (pse->app_name)
		string = CATSPRINTF(string, "app_name    = %s\n", pse->app_name);
	if (pse->pin)
		string = CATSPRINTF(string, "pin         = %s\n", pse->pin);
	if (pse->object.name)
		string = CATSPRINTF(string, "object.name = %s\n", pse->object.name);
	if (pse->object.pin)
		string = CATSPRINTF(string, "object.pin  = %s\n", pse->object.pin);
	string = CATSPRINTF(string, "app_id      = %d\n", pse->app_id);
	return(string);
}

/***************************************************************
 *
 * Procedure aux_sprint_Version
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_Version(
	char	 *string
)

#else

char *aux_sprint_Version(
	string
)
char	 *string;

#endif

{
	char buf[256];
	Boolean flag = FALSE;


	buf[0] = '\0';

	sprintf(&buf[strlen(buf)], "%s\n", secudeversion);
	if(af_x500) {

		if(!flag) sprintf(&buf[strlen(buf)], "with ");
	    	sprintf(&buf[strlen(buf)], "X.500");

		if(af_strong) sprintf(&buf[strlen(buf)], ", Strong Authentication");
		flag = TRUE;
	}
	if(sec_sca) {

		if(flag) sprintf(&buf[strlen(buf)], ", ");
		else sprintf(&buf[strlen(buf)], "with ");

		sprintf(&buf[strlen(buf)], "Smartcard Support");
		flag = TRUE;
	}
	if(af_COSINE) {

		if(flag) sprintf(&buf[strlen(buf)], ", ");
		else sprintf(&buf[strlen(buf)], "with ");

		sprintf(&buf[strlen(buf)], "COSINE extensions");
		flag = TRUE;
	}
	string = CATSPRINTF(string, "%-75s (c)1993 GMD Darmstadt\n", buf);
	return(string);
}

/***************************************************************
 *
 * Procedure aux_sprint_version
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_version(
	char	 *string
)

#else

char *aux_sprint_version(
	string
)
char	 *string;

#endif

{
	string = aux_sprint_Version(string);
	string = CATSPRINTF(string, "\n");
	return(string);
}

/***************************************************************
 *
 * Procedure aux_sprint_PSEToc
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_PSEToc(
	char	 *string,
	PSEToc	 *toc1,
	PSEToc	 *toc2
)

#else

char *aux_sprint_PSEToc(
	string,
	toc1,
	toc2
)
char	 *string;
PSEToc	 *toc1;
PSEToc	 *toc2;

#endif

{
	struct PSE_Objects *obj;
	PSEToc *toc;
	char *scflag, *update, *create;
	int	i = 1;

	if ( !toc1 ) {
		string = CATSPRINTF(string, "%s\n", EPSETOC);
		return(string);
	}

	toc = toc1;

	if(toc2) scflag = " SC";
	else scflag = "\0";

	string = CATSPRINTF(string, "Owner: %-10s ", toc->owner);
	create = aux_readable_UTCTime(toc->create);
	update = aux_readable_UTCTime(toc->update);
	string = CATSPRINTF(string, "C: %s / U: %s%s", create + 4, update + 4, scflag);
	if(create) free(create);
	if(update) free(update);
	if(toc->status & ONEKEYPAIRONLY) string = CATSPRINTF(string, " / ONE keypair \n");
	else string = CATSPRINTF(string, " / TWO keypairs \n");
	string = CATSPRINTF(string, "Objects:\n");
	obj = toc->obj;
	while (obj) {
		create = aux_readable_UTCTime(obj->create);
		update = aux_readable_UTCTime(obj->update);
		string = CATSPRINTF(string, "%2d. %-13s C: %s / U: %s / %6d Octets %s\n", i++, obj->name, create + 4, update + 4, obj->noOctets, scflag);
		if(create) free(create);
		if(update) free(update);
		obj = obj->next;
	}
	if(!toc2 || toc1 == toc2) return(string);
	obj = toc2->obj;
	while (obj) {
		create = aux_readable_UTCTime(obj->create);
		update = aux_readable_UTCTime(obj->update);
		string = CATSPRINTF(string, "%2d. %-13s C: %s / U: %s / %6d Octets \n", i++, obj->name, create + 4, update + 4, obj->noOctets);
		if(create) free(create);
		if(update) free(update);
		obj = obj->next;
	}
	return(string);
}

/***************************************************************
 *
 * Procedure aux_sprint_Certificate
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_Certificate(
	char		 *string,
	Certificate	 *cert
)

#else

char *aux_sprint_Certificate(
	string,
	cert
)
char		 *string;
Certificate	 *cert;

#endif

{
	BitString   * bis;
	OctetString hash_result, *ostr;
	Name * printrepr;
 	AlgHash alghash;
	int	i;

	char	* proc = "aux_sprint_Certificate";


	if ( !cert ) {
		string = CATSPRINTF(string, "%s\n", ECERT);
		return(string);
	}

	if (print_cert_flag & DER) {
		if (print_cert_flag & TBS) {
			string = CATSPRINTF(string, "%s", DERCODE);
			string = CATSPRINTF(string, "of ToBeSigned:\n");
			if(cert->tbs_DERcode) string = aux_sxdump(string, cert->tbs_DERcode->octets, cert->tbs_DERcode->noctets, 0);
			else string = CATSPRINTF(string, " NULL\n");
		} else {
			if (print_cert_flag & ISSUER) {
				string = CATSPRINTF(string, "%s", DERCODE);
				string = CATSPRINTF(string, "of Issuer DName:\n");
				if(cert->tbs) {
					ostr = e_DName(cert->tbs->issuer);
					if (ostr) {
						string = aux_sxdump2(string, ostr->octets, ostr->noctets, 0);
						aux_free_OctetString(&ostr);
					}
				} else string = CATSPRINTF(string, " NULL\n");
			}
			if (print_cert_flag & SUBJECT) {
				string = CATSPRINTF(string, "%s", DERCODE);
				string = CATSPRINTF(string, "of Subject DName:\n");
				if(cert->tbs) {
					ostr = e_DName(cert->tbs->subject);
					if (ostr) {
						string = aux_sxdump2(string, ostr->octets, ostr->noctets, 0);
						aux_free_OctetString(&ostr);
					}
				} else string = CATSPRINTF(string, " NULL\n");
			}
			if (print_cert_flag & KEYINFO) {
				string = CATSPRINTF(string, "%s", DERCODE);
				string = CATSPRINTF(string, "of SubjectPK:\n");
				if(cert->tbs) {
					ostr = e_KeyInfo(cert->tbs->subjectPK);
					if (ostr) {
						string = aux_sxdump2(string, ostr->octets, ostr->noctets, 0);
						aux_free_OctetString(&ostr);
					}
				} else string = CATSPRINTF(string, " NULL\n");
			}
		}
		if (print_cert_flag & ALG) {
			string = CATSPRINTF(string, "%s", DERCODE);
			string = CATSPRINTF(string, "of AlgorithmIdentifier:\n");
			if(cert->sig) {
				ostr = e_AlgId(cert->sig->signAI);
				if (ostr) {
					string = aux_sxdump2(string, ostr->octets, ostr->noctets, 0);
					aux_free_OctetString(&ostr);
				}
			} else string = CATSPRINTF(string, " NULL\n");
		}
	} else string = aux_sprint_ToBeSigned(string, cert->tbs);

	if ((print_cert_flag & HSH) && cert->sig) {
 		alghash = aux_ObjId2AlgHash(cert->sig->signAI->objid);
 		string = CATSPRINTF(string, "%s digest of DER code of ToBeSigned:\n", alghash_name[alghash]);
		sec_hash(cert->tbs_DERcode, &hash_result, SEC_END, cert->sig->signAI, NULL);
 		print_indent += 10;
  		string = aux_sxdump2(string, hash_result.octets, hash_result.noctets, 0);
 		print_indent -= 10;
		free(hash_result.octets);
	}

        if ((print_cert_flag & (ALG | SIGNAT)) && cert->sig) {
		string = CATSPRINTF(string, "%s", SIGN);
		print_indent += 10;
		string = aux_sprint_AlgId(string, cert->sig->signAI);
		print_indent -= 10;
	}
	if ((print_cert_flag & SIGNAT) && cert->sig) {
		print_indent += 10;
		bis = &(cert->sig->signature);
		i = bis->nbits / 8;
		if ( bis->nbits % 8 ) i++;
		string = aux_sxdump2(string, bis->bits, i, 0);
		print_indent -= 10;
	}
	return(string);
}



/***************************************************************
 *
 * Procedure aux_sprint_Serialnumber
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_Serialnumber(
	char		 *string,
	OctetString	 *serial
)

#else

char *aux_sprint_Serialnumber(
	string,
	serial
)
char		 *string;
OctetString	 *serial;

#endif

{
	int	  int_repr;
	char	* proc = "aux_sprint_Serialnumber";


	if(serial) {

		if(serial->noctets <= WBYTES) {
			int_repr = aux_OctetString2int(serial);
			string = CATSPRINTF(string, "%d (decimal)\n", int_repr);
		}
		else{
			string = CATSPRINTF(string, "\n");
			string = aux_sxdump2(string, serial->octets, serial->noctets, 0);
			string = CATSPRINTF(string, "         (hex)\n");
		}
	}

	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_ToBeSigned
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_ToBeSigned(
	char		 *string,
	ToBeSigned	 *tbs
)

#else

char *aux_sprint_ToBeSigned(
	string,
	tbs
)
char		 *string;
ToBeSigned	 *tbs;

#endif

{
	Name    * printrepr;
	char    * dd, *fp;
        char    * issueralias = CNULL, *subjectalias = CNULL;
	char    * version1 = "88";
	char    * version2 = "92";
	char	* proc = "aux_sprint_ToBeSigned";


	if ( !tbs ) {
		string = CATSPRINTF(string, "%s\n", ETBS);
		return(string);
	}

/*
	string = CATSPRINTF(string, "%s", SAI);
	string = aux_sprint_AlgId(string, tbs->signatureAI);
*/

	issueralias = aux_DName2alias(tbs->issuer, LOCALNAME);

	if(print_cert_flag & TBS || print_cert_flag & SUBJECT) {
		subjectalias = aux_DName2alias(tbs->subject, LOCALNAME);
		if(subjectalias) string = CATSPRINTF(string, "%s%s (", SUB, subjectalias);
		else string = CATSPRINTF(string, "%s", SUB);
 
		if((printrepr = aux_PemDNameSubordination(tbs->issuer, tbs->subject))) {
			if(issueralias) {
				string = CATSPRINTF(string, "<%s>, %s", issueralias, printrepr);
			}
			else string = CATSPRINTF(string, "%s%s", "<Issuer>, ", printrepr);
		}
		else {		
			printrepr = aux_DName2Name(tbs->subject);
			string = CATSPRINTF(string, "%s", printrepr);
		}
			
		if(subjectalias) {
			string = CATSPRINTF(string, ")\n");
			free(subjectalias);
		}
		else string = CATSPRINTF(string, "\n"); 
		if(printrepr) free(printrepr);
	}

	if(print_cert_flag & TBS || print_cert_flag & ISSUER) {
		printrepr = aux_DName2Name(tbs->issuer);
		if(issueralias) {
			string = CATSPRINTF(string, "%s%s", ISS, issueralias);
			string = CATSPRINTF(string, " (%s)\n", printrepr);
		}
		else string = CATSPRINTF(string, "%s%s\n", ISS, printrepr);
		free(printrepr);

		if(tbs->serialnumber){
			string = CATSPRINTF(string, "%s", SER);
			string = aux_sprint_Serialnumber(string, tbs->serialnumber);
		}
	}

	if(issueralias)	free(issueralias);

	if(print_cert_flag & TBS || print_cert_flag & VAL)
		string = aux_sprint_Validity(string, tbs->valid);

	if(print_cert_flag & TBS || print_cert_flag & KEYINFO) {
		fp = sec_fingerprint(tbs->subjectPK, 4);
		if(fp) {
			string = CATSPRINTF(string, "%s%s\n", FPR, fp);
			free(fp);
		}
		string = CATSPRINTF(string, "%s", SPK);
		string = aux_sprint_KeyInfo(string, tbs->subjectPK);
	}

	if(print_cert_flag & VER) {
		if(tbs->version) dd = version2;
			else dd = version1;
		string = CATSPRINTF(string, "%s%d (X.509-19%s)\n", VSN, tbs->version, dd);
	}

#ifdef COSINE
	if (tbs->authatts)
		string = aux_sprint_AuthorisationAttributes(string, tbs->authatts);
#endif

	return(string);
}


#ifdef COSINE
/***************************************************************
 *
 * Procedure aux_sprint_AuthorisationAttributes
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_AuthorisationAttributes(
	char			 *string,
	AuthorisationAttributes	 *authatts
)

#else

char *aux_sprint_AuthorisationAttributes(
	string,
	authatts
)
char			 *string;
AuthorisationAttributes	 *authatts;

#endif

{

	if ( !authatts )
		return (string);

	string = CATSPRINTF(string, "%s\n", AUTHATTR);

	if ( !authatts->country ) {
		string = CATSPRINTF(string, "%s\n", ECOID);
		return(string);
	}
	string = CATSPRINTF(string, "%s%s\n", COID, authatts->country);

	if ( !authatts->group ) {
		string = CATSPRINTF(string, "%s\n", EGID);
		return(string);
	}
	string = CATSPRINTF(string, "%s%s\n", GID, authatts->group);

	switch (authatts->class) {
	case Normal:
		string = CATSPRINTF(string, "%s%s\n", CLID, NORMAL);
		break;
	case Privileged:
		string = CATSPRINTF(string, "%s%s\n", CLID, PRIVILEGED);
		break;
	default:
		string = CATSPRINTF(string, "%s\n", ECLID);
		return(string);
	}
	
	return(string);
}
#endif

/***************************************************************
 *
 * Procedure aux_sprint_FCPath
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_FCPath(
	char	 *string,
	FCPath	 *fcpath
)

#else

char *aux_sprint_FCPath(
	string,
	fcpath
)
char	 *string;
FCPath	 *fcpath;

#endif

{
	CrossCertificates * ccerts;
	Certificate       * cert;

	while (fcpath) {
		string = CATSPRINTF(string, "\n === next certificate in path: ===\n");
		ccerts = fcpath->liste;
		while (ccerts) {
			cert = ccerts->element;
			print_indent += 4;
			string = aux_sprint_Certificate(string, cert); /*print out elements of cert: */
			print_indent -= 4;
			if (( ccerts = ccerts->next )) {
				string = CATSPRINTF(string, "\n === next crosscertificate: ===\n");
			}
		}
		fcpath = fcpath->next_forwardpath;
	}
	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_Certificates
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_Certificates(
	char		 *string,
	Certificates	 *certs
)

#else

char *aux_sprint_Certificates(
	string,
	certs
)
char		 *string;
Certificates	 *certs;

#endif

{
	int n;

	if ((!certs)) {
		string = CATSPRINTF(string, "%s\n", ECERTS);
		return(string);
	}
	string = CATSPRINTF(string, "\n === user certificate: ===\n");
	print_indent += 4;
	string = aux_sprint_Certificate(string, certs->usercertificate);
	print_indent -= 4;

	string = aux_sprint_FCPath(string, certs->forwardpath);
	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_Validity
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_Validity(
	char	 *string,
	Validity *valid
)

#else

char *aux_sprint_Validity(
	string,
	valid
)
char	 *string;
Validity *valid;

#endif

{
	char   * notbefore, * notafter;

	if ( !valid ) {
		string = CATSPRINTF(string, "%s\n", EVALID);
		return(string);
	}

	if(valid->notbefore){
		notbefore = aux_readable_UTCTime(valid->notbefore);
 		string = CATSPRINTF(	string,
 					"%s%s (%s)\n",
 					VALNB,
 					notbefore ? notbefore : "<invalid>",
 					valid->notbefore);
  		free(notbefore);
  	}
  	if(valid->notafter){
  		notafter = aux_readable_UTCTime(valid->notafter);
 		string = CATSPRINTF(	string,
 					"%s%s (%s)\n",
 					VALNA,
 					notafter ? notafter : "<invalid>",
 					valid->notafter);
  	}
	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_RootInfo
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_RootInfo(
	char	 *string,
	Serial	 *rootinfo,
	Boolean	  new_
)

#else

char *aux_sprint_RootInfo(
	string,
	rootinfo,
	new_
)
char	 *string;
Serial	 *rootinfo;
Boolean	  new_;

#endif

{
	BitString   	* bis;
	char            * fp;
	int		  i;


	if(rootinfo->serial){
		string = CATSPRINTF(string, "%s", SER);
		string = aux_sprint_Serialnumber(string, rootinfo->serial);
	}

	if(rootinfo->version > 0)
		string = CATSPRINTF(string, "%s%d\n", VSN, rootinfo->version);

	string = aux_sprint_Validity(string, rootinfo->valid);

	fp = sec_fingerprint(rootinfo->key, 4);
	string = CATSPRINTF(string, "%s%s\n", FPR, fp);
	free(fp);
	string = CATSPRINTF(string, "%s", PKEY);
	string = aux_sprint_KeyInfo(string, rootinfo->key);

	if (rootinfo->sig) {
		string = CATSPRINTF(string, "%s", SIGN);
		print_indent += 10;
		string = aux_sprint_AlgId(string, rootinfo->sig->signAI);
		print_indent -= 10;
	}
	if ((print_cert_flag & SIGNAT) && rootinfo->sig) {
		print_indent += 10;
		bis = &(rootinfo->sig->signature);
		i = bis->nbits / 8;
		if ( bis->nbits % 8 ) i++;
		string = aux_sxdump2(string, bis->bits, i, 0);
		print_indent -= 10;
	}

	return(string);
}

/***************************************************************
 *
 * Procedure aux_sprint_PKRoot
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_PKRoot(
	char	 *string,
	PKRoot	 *pkroot
)

#else

char *aux_sprint_PKRoot(
	string,
	pkroot
)
char	 *string;
PKRoot	 *pkroot;

#endif

{
	Name    * printrepr;
	char    * rootalias;
	char	* proc = "aux_sprint_PKRoot";


	if ( !pkroot ) {
		string = CATSPRINTF(string, "%s\n", EPKROOT);
		return(string);
	}

	printrepr = aux_DName2Name(pkroot->ca);
	rootalias = aux_Name2alias(printrepr, LOCALNAME);
	if(rootalias) {
		string = CATSPRINTF(string, "%s%s", ROO, rootalias);
		string = CATSPRINTF(string, " (%s)\n", printrepr);
		free(rootalias);
	}
	else string = CATSPRINTF(string, "%s%s\n", ROO, printrepr);
	free(printrepr);

	if(pkroot->oldkey)
		string = CATSPRINTF(string, "\n-------------------- Root Key (NEW) --------------------\n\n");

	string = aux_sprint_RootInfo(string, pkroot->newkey, TRUE);
	if (! pkroot->oldkey)
		return(string);

	string = CATSPRINTF(string, "\n-------------------- Root Key (OLD) --------------------\n\n");
	string = aux_sprint_RootInfo(string, pkroot->oldkey, FALSE);

	return(string);
}



/***************************************************************
 *
 * Procedure aux_sprint_PKList
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_PKList(
	char	 *string,
	PKList	 *pklist
)

#else

char *aux_sprint_PKList(
	string,
	pklist
)
char	 *string;
PKList	 *pklist;

#endif

{
	PKList * actlist;
	int	i = 1;

	actlist = pklist;
	while ( actlist ) {
		string = CATSPRINTF(string, "%2d. -------------------------------------------------------------\n", i++);
		print_indent += 4;
		string = aux_sprint_ToBeSigned(string, actlist->element);
		print_indent -= 4;
		actlist = actlist->next;
	}
	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_CRLEntry
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_CRLEntry(
	char		 *string,
	CRLEntry	 *crlentry
)

#else

char *aux_sprint_CRLEntry(
	string,
	crlentry
)
char		 *string;
CRLEntry	 *crlentry;

#endif

{
	char    * time;

	if ((!crlentry)) {
		string = CATSPRINTF(string, "%s\n", ECRLENTRY);
		return(string);
	}

	if(crlentry->serialnumber){
		string = CATSPRINTF(string, "%s", RSER);
		string = aux_sprint_Serialnumber(string, crlentry->serialnumber);
	}

	time = aux_readable_UTCTime(crlentry->revocationDate);
	string = CATSPRINTF(string, "%s%s (%s)\n", REVDATE, time, crlentry->revocationDate);
	if(time) free(time);

	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_CRL
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_CRL(
	char	 *string,
	CRL	 *crl
)

#else

char *aux_sprint_CRL(
	string,
	crl
)
char	 *string;
CRL	 *crl;

#endif

{
	BitString * bis;
	int	i;

	if ( !crl ) {
		string = CATSPRINTF(string, "%s\n", ECRL);
		return(string);
	}

	string = CATSPRINTF(string, " ---------------- Revocation List ------------------\n");

	string = aux_sprint_CRLTBS(string, crl->tbs);

	string = CATSPRINTF(string, "%s", IAI);
	string = aux_sprint_AlgId(string, crl->sig->signAI);

	string = CATSPRINTF(string, "%s\n", SIGN);
	bis = &(crl->sig->signature);
	i = bis->nbits / 8;
	if ( bis->nbits % 8 ) 
		i++;
	aux_xdump2(bis->bits, i, 0);

	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_CRLTBS
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_CRLTBS(
	char		 *string,
	CRLTBS	 *tbs
)

#else

char *aux_sprint_CRLTBS(
	string,
	tbs
)
char		 *string;
CRLTBS	 *tbs;

#endif

{
	SEQUENCE_OF_CRLEntry   * seq;
	CRLEntry		 * crlentry;
	Name 			 * printrepr;
	char                     * last, * next;
	char		         * proc = "aux_sprint_CRLTBS";


	if ( !tbs ) {
		string = CATSPRINTF(string, "%s\n", ECRLTBS);
		return(string);
	}

	string = CATSPRINTF(string, "%s", SAI);
	string = aux_sprint_AlgId(string, tbs->signatureAI);
	printrepr = aux_DName2Name(tbs->issuer);
	string = CATSPRINTF(string, "%s%s\n", ISS, printrepr);
	free(printrepr);
	last = aux_readable_UTCTime(tbs->lastUpdate);
	next = aux_readable_UTCTime(tbs->nextUpdate);
	string = CATSPRINTF(string, "%s%s (%s)\n", LASTUP, last, tbs->lastUpdate);
	string = CATSPRINTF(string, "%s%s (%s)\n", NEXTUP, next, tbs->nextUpdate);
	if(last) free(last);
	if(next) free(next);
	string = CATSPRINTF(string, "\n --- Sequence of Revoked Certificates: ---\n");
	seq = tbs->revokedCertificates;
	while (seq) {
		crlentry = seq->element;
		string = aux_sprint_CRLEntry(string, crlentry);  /*print out elements of crlentry: */

		if (( seq = seq->next )) {
			string = CATSPRINTF(string, "\n --- next revoked certificate: ---\n");
		}
	}
	string = CATSPRINTF(string, "\n\n");

	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_OCList
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_OCList(
	char	 *string,
	OCList	 *oclist
)

#else

char *aux_sprint_OCList(
	string,
	oclist
)
char	 *string;
OCList	 *oclist;

#endif

{

	if ((!oclist )) {
		string = CATSPRINTF(string, "%s\n", EOCLIST);
		return(string);
	}

	string = CATSPRINTF(string, "\n --- Old Certificates: ---\n");
	while (oclist) {
		if(oclist->serialnumber){
			string = CATSPRINTF(string, "%s", OLDSER);
			string = aux_sprint_Serialnumber(string, oclist->serialnumber);
		}
		string = CATSPRINTF(string, "\n");
		string = aux_sprint_Certificate(string, oclist->ccert);
		if (( oclist = oclist->next )) {
			string = CATSPRINTF(string, "\n --- next entry in list: ---\n");
		}
	}
	return(string);
}

/***************************************************************
 *
 * Procedure aux_sprint_CertificateSet
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_CertificateSet(
	char			 *string,
	SET_OF_Certificate	 *certset
)

#else

char *aux_sprint_CertificateSet(
	string,
	certset
)
char			 *string;
SET_OF_Certificate	 *certset;

#endif

{

	if ((!certset )) {
		string = CATSPRINTF(string, "%s\n", ECERTSET);
		return(string);
	}

	string = CATSPRINTF(string, "\n --------------- Set of Certificates: ---------------\n");

	while (certset) {
		if (!certset->element) 
			break;
		string = aux_sprint_Certificate(string, certset->element);
		string = CATSPRINTF(string, "------------------------------------------------------\n");
		certset = certset->next;
	}
	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_CertificatePairSet
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_CertificatePairSet(
	char			 *string,
	SET_OF_CertificatePair	 *cpair
)

#else

char *aux_sprint_CertificatePairSet(
	string,
	cpair
)
char			 *string;
SET_OF_CertificatePair	 *cpair;

#endif

{

	if ( !cpair ) {
		string = CATSPRINTF(string, "%s\n", ECERTPAIR);
		return(string);
	}

	string = CATSPRINTF(string, "\n --------------- crossCertificatePair ---------------\n\n\n");
	while (cpair) {
		string = CATSPRINTF(string, "  --- ForwardCertificate ---\n\n");
		string = aux_sprint_Certificate(string, cpair->element->forward);
		string = CATSPRINTF(string, "\n\n  --- ReverseCertificate ---\n\n");
		string = aux_sprint_Certificate(string, cpair->element->reverse);
		string = CATSPRINTF(string, "\n------------------------------------------------------\n\n\n");
		cpair = cpair->next;
	}
	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_Crl
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_Crl(
	char	 *string,
	Crl	 *crlpse
)

#else

char *aux_sprint_Crl(
	string,
	crlpse
)
char	 *string;
Crl	 *crlpse;

#endif

{
	Name       		* printrepr;
	SEQUENCE_OF_CRLEntry  * seq;
	CRLEntry		* crlentry;
	char       		* update, *issueralias;
	char       		* proc = "aux_sprint_Crl";


	if ( !crlpse ) {
		string = CATSPRINTF(string, "%s\n", ECRLPSE);
		return(string);
	}

	string = CATSPRINTF(string, "\n ------------- Revocation List on PSE: -------------\n");

	printrepr = aux_DName2Name(crlpse->issuer);
	issueralias = aux_Name2alias(printrepr, LOCALNAME);
	if(issueralias) {
		string = CATSPRINTF(string, "%s%s", ISS, issueralias);
		string = CATSPRINTF(string, " (%s)\n", printrepr);
		free(issueralias);
	}
	else string = CATSPRINTF(string, "%s%s\n", ISS, printrepr);
	free(printrepr);

	update = aux_readable_UTCTime(crlpse->nextUpdate);
	string = CATSPRINTF(string, "%s%s (%s)\n", NEXTUP, update, crlpse->nextUpdate);
	if(update) free(update);

	string = CATSPRINTF(string, "\n --- Sequence of Revoked Certificates: ---\n");
	seq = crlpse->revcerts;
	while (seq) {
		crlentry = seq->element;
		string = aux_sprint_CRLEntry(string, crlentry);  /*print out elements of crlentry: */
		if ((seq = seq->next)) string = CATSPRINTF(string, "\n --- next revoked certificate: ---\n");
	}

	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_CrlSet
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_CrlSet(
	char	 *string,
	CrlSet	 *crlset
)

#else

char *aux_sprint_CrlSet(
	string,
	crlset
)
char	 *string;
CrlSet	 *crlset;

#endif

{

	if (( !crlset )) {
		string = CATSPRINTF(string, "%s\n", ECRLSETPSE);
		return(string);
	}

	string = CATSPRINTF(string, "\n--------------- Set of Revocation Lists: ---------------\n");

	while (crlset) {
		if (!crlset->element) 
			break;
		string = aux_sprint_Crl(string, crlset->element);
		string = CATSPRINTF(string, " ------------------------------------------------------\n");
		crlset = crlset->next;
	}
	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_IssuedCertificate
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_IssuedCertificate(
	char			 *string,
	IssuedCertificate	 *isscert
)

#else

char *aux_sprint_IssuedCertificate(
	string,
	isscert
)
char			 *string;
IssuedCertificate	 *isscert;

#endif

{
	char *date_of_issue;

	if ( !isscert ) {
		string = CATSPRINTF(string, "%s\n", EISSCERT);
		return(string);
	}

	date_of_issue = aux_readable_UTCTime(isscert->date_of_issue);
	string = CATSPRINTF(string, " Date of Issue: %s\n", date_of_issue);
	if(date_of_issue) free(date_of_issue);

	if(isscert->serial){
		string = CATSPRINTF(string, "%s", SER);
		string = aux_sprint_Serialnumber(string, isscert->serial);
	}

	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_SET_OF_IssuedCertificate
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_SET_OF_IssuedCertificate(
	char				 *string,
	SET_OF_IssuedCertificate	 *isscertset
)

#else

char *aux_sprint_SET_OF_IssuedCertificate(
	string,
	isscertset
)
char				 *string;
SET_OF_IssuedCertificate	 *isscertset;

#endif

{

        int i = 0;
	if ( !isscertset ) {
		string = CATSPRINTF(string, "%s\n", EISSCERTSET);
		return(string);
	}

	while (isscertset) {
		if (!isscertset->element) break;
                string = CATSPRINTF(string, "%d. ", ++i);
		string = aux_sprint_IssuedCertificate(string, isscertset->element);
		isscertset = isscertset->next;
	}
	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_SET_OF_Name
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_SET_OF_Name(
	char		 *string,
	SET_OF_Name	 *nameset
)

#else

char *aux_sprint_SET_OF_Name(
	string,
	nameset
)
char		 *string;
SET_OF_Name	 *nameset;

#endif

{

        int i = 0;
	if ( !nameset ) {
		string = CATSPRINTF(string, "%s\n", ENAMESET);
		return(string);
	}

	while (nameset) {
		if (!nameset->element) break;
		string = CATSPRINTF(string, "%d. %s\n", ++i, nameset->element);
		nameset = nameset->next;
	}
	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_CRLWithCertificates
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_CRLWithCertificates(
	char		 *string,
	CRLWithCertificates	 *arg
)

#else

char *aux_sprint_CRLWithCertificates(
	string,
	arg
)
char		 *string;
CRLWithCertificates	 *arg;

#endif

{
	if (! arg) {
		string = CATSPRINTF(string, "%s\n", ECRLWITHCERTS);
		return(string);
	}

	string = aux_sprint_CRL(string, arg->crl);
	if(arg->certificates) string = aux_sprint_Certificates(string, arg->certificates);

	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_SET_OF_CRLWithCertificates
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_SET_OF_CRLWithCertificates(
	char			 *string,
	SET_OF_CRLWithCertificates	 *set
)

#else

char *aux_sprint_SET_OF_CRLWithCertificates(
	string,
	set
)
char			 *string;
SET_OF_CRLWithCertificates	 *set;

#endif

{
	if (! set) {
		string = CATSPRINTF(string, "%s\n", ECRLWITHCERTSSET);
		return(string);
	}

	while (set) {
		if (! set->element) 
			break;
		string = aux_sprint_CRLWithCertificates(string, set->element);
		string = CATSPRINTF(string, "------------------------------------------------------\n");
		set = set->next;
	}
	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_VerificationResult
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_VerificationResult(
	char			 *string,
	VerificationResult	 *verres
)

#else

char *aux_sprint_VerificationResult(
	string,
	verres
)
char			 *string;
VerificationResult	 *verres;

#endif

{
	int       index = 0;
	Name    * subject = CNULL, * issuer = CNULL;
	Boolean   dn_subordination_violation = FALSE;
	int       crlcheck = 0;
	char    * time = CNULL, *nameORalias;

	if (! verres ) {
		string = CATSPRINTF(string, "%s\n", VERRES);
		return(string);
	}

	string = CATSPRINTF(string, "\n");

	if (verres->verifstep) {
		index = 0;
		while(verres->verifstep[index]){
			if(verres->verifstep[index]->dn_subordination_violation == TRUE){
				dn_subordination_violation = TRUE;
				break;
			}
			index++;
		}
		index = 0;
		while(verres->verifstep[index]){
			if(verres->verifstep[index]->crlcheck == CRL_NOT_AVAILABLE){
				crlcheck == CRL_NOT_AVAILABLE;
				break;
			}
			index++;
		} /* while */
	} /* if */

	index = 0;

	if(verres->textverified == TRUE) {
		/* call of af_verify() and af_verify_Certificates() */
		if (verres->success == TRUE && dn_subordination_violation == FALSE && crlcheck == 0) {
			if(! verres->verifstep || ! verres->verifstep[0]){
				string = CATSPRINTF(string, "Text signature of <");
				string = aux_sprint_NameOrAlias(string, verres->originator);
				string = CATSPRINTF(string, ">\n\n");
			}
			else {
				string = CATSPRINTF(string, "Text signature of <");
				string = aux_sprint_DNameOrAlias(string, verres->verifstep[0]->cert->tbs->subject);
				string = CATSPRINTF(string, ">\n\n");
			}
		}
		else {
			if(! verres->verifstep || ! verres->verifstep[0]){
				string = CATSPRINTF(string, "Text signature of (purported) <");
				string = aux_sprint_NameOrAlias(string, verres->top_name);
				string = CATSPRINTF(string, ">\n\n");			}
			else {
				string = CATSPRINTF(string, "Text signature of (purported) <");
				string = aux_sprint_DNameOrAlias(string, verres->verifstep[0]->cert->tbs->subject);
				string = CATSPRINTF(string, ">\n\n");
			}
		}
	}
	else {
		/* call of af_verify_Certificates() only */
		if(!verres->verifstep || !verres->verifstep[0] || !verres->verifstep[0]->cert){
			if(verres->trustedKey == - 2){
				string = CATSPRINTF(string, "Certificate (containing Public Root Key)\n\n");
				string = CATSPRINTF(string, "    - issued by <");
				string = aux_sprint_NameOrAlias(string, verres->top_name);
				string = CATSPRINTF(string, ">\n");
				if(verres->top_serial){
					string = CATSPRINTF(string, "    - serial number: ");
					string = aux_sprint_Serialnumber(string, verres->top_serial);
				}
				string = aux_sprint_validity_timeframe(string, verres->valid);
				return(string);
			}
			else {
				string = CATSPRINTF(string, "VerificationResult structure could not be filled due to an unexpected return "); 
				string = CATSPRINTF(string, "from the af_verify() or af_verify_Certificates() routine.\n\n");
				string = CATSPRINTF(string, "Print error stack for any further information.\n\n");
				return(string);
			}
		}
		if (verres->success == TRUE && dn_subordination_violation == FALSE && crlcheck == 0) {
			string = CATSPRINTF(string, "Certificate of owner <");
			string = aux_sprint_DNameOrAlias(string, verres->verifstep[0]->cert->tbs->subject);
			string = CATSPRINTF(string, ">\n");
		}
		else {
			string = CATSPRINTF(string, "Certificate of (purported) owner <");
			string = aux_sprint_DNameOrAlias(string, verres->verifstep[0]->cert->tbs->subject);
			string = CATSPRINTF(string, ">\n");
		}

		if(af_verbose) {
			print_indent += 4;
			string = aux_sprint_Certificate(string, verres->verifstep[0]->cert);
			print_indent -= 4;
			string = CATSPRINTF(string, "\n");
		}

		string = CATSPRINTF(string, "    - issued by <");
		string = aux_sprint_DNameOrAlias(string, verres->verifstep[0]->cert->tbs->issuer);
		string = CATSPRINTF(string, ">\n");
		string = CATSPRINTF(string, "    - serial number: "); 
		string = aux_sprint_Serialnumber(string, verres->verifstep[0]->cert->tbs->serialnumber);
		if(verres->verifstep[0]->supplied == 0)
			string = CATSPRINTF(string, "    - supplied within received 'Certificates'\n");
		else if(verres->verifstep[0]->supplied == 1)
			string = CATSPRINTF(string, "    - retrieved from Directory\n");
		else string = CATSPRINTF(string, "    - retrieved from PSE-object CrossCSet\n");

		switch(verres->verifstep[0]->crlcheck) {
		case REVOKED:
			time = aux_readable_UTCTime(verres->verifstep[0]->date);
			string = CATSPRINTF(string, "    - R E V O K E D (revocation date: %s (%s))\n\n", time, verres->verifstep[0]->date);
			if (time) free (time);
			if (! verres->verifstep[1])
				return(string);
			break;
		case NOT_REVOKED:
			string = CATSPRINTF(string, "    - not revoked\n\n");
			break;
		case CRL_NOT_AVAILABLE:
			string = CATSPRINTF(string, "    - CRL not available\n\n");
			break;
		case CRL_OUT_OF_DATE:
			time = aux_readable_UTCTime(verres->verifstep[0]->date);
			string = CATSPRINTF(string, "    - CRL is out-of-date (next update: %s (%s))\n\n", time, verres->verifstep[0]->date);
			if (time) free (time);
			break;
		case NOT_REQUESTED:
			string = CATSPRINTF(string, "    - Checking against CRL was not requested\n\n");
			break;
		case 0:
			string = CATSPRINTF(string, "\n\n");
			break;
		default:
			string = CATSPRINTF(string, "undefined value\n");
			break;
		}  /* switch */

		if (verres->success == FALSE && ! verres->verifstep[1] && verres->verifstep[0]->valid) {
			/* usercertificate itself has expired */
			if (verres->trustedKey == - 2) {
				string = aux_sprint_validity_timeframe(string, verres->verifstep[0]->valid);
				return(string);
			}
		}

		index++;
	}

	while (verres->verifstep &&
	       ((verres->success == TRUE && verres->verifstep[index]) ||
	       (verres->success == FALSE && (verres->trustedKey == - 1 || verres->trustedKey == - 2) && verres->verifstep[index + 1]) ||
	       (verres->success == FALSE && verres->trustedKey != - 1 && verres->trustedKey != - 2 && verres->verifstep[index]))) {

		if(verres->verifstep[index]->dn_subordination_violation == TRUE || verres->verifstep[index]->crlcheck == CRL_NOT_AVAILABLE)
			string = CATSPRINTF(string, "... (cryptographically) verified with certificate\n\n");
		else 
			string = CATSPRINTF(string, "... validated with certificate\n\n");

		if(af_verbose) {
			print_indent += 4;
			string = aux_sprint_Certificate(string, verres->verifstep[index]->cert);
			print_indent -= 4;
			string = CATSPRINTF(string, "\n");
		}

		issuer = aux_DName2Name(verres->verifstep[index]->cert->tbs->issuer);
		subject = aux_DName2Name(verres->verifstep[index]->cert->tbs->subject);
		if((verres->verifstep[index+1] && verres->verifstep[index+1]->policy_CA) || verres->trustedKey == 6) {
			string = CATSPRINTF(string, "    - issued by POLICY CA <");
			string = aux_sprint_DNameOrAlias(string, verres->verifstep[index]->cert->tbs->issuer);
			string = CATSPRINTF(string, ">\n");
		} 
		else {
			string = CATSPRINTF(string, "    - issued by <");
			string = aux_sprint_DNameOrAlias(string, verres->verifstep[index]->cert->tbs->issuer);
			string = CATSPRINTF(string, ">\n");
		} 
		if(verres->verifstep[index]->cert->tbs->serialnumber){
			string = CATSPRINTF(string, "    - serial number: "); 
			string = aux_sprint_Serialnumber(string, verres->verifstep[index]->cert->tbs->serialnumber);
		}
/*
		if(verres->verifstep[index]->policy_CA){
			string = CATSPRINTF(string, "    - owned by POLICY CA <%s>\n", subject);
		}
*/
		if(verres->verifstep[index]->dn_subordination_violation == TRUE){
			string = CATSPRINTF(string, "    - PEM 1422 naming subordination rule  V I O L A T E D, i.e.\n");
			string = CATSPRINTF(string, "      	<%s>\n", subject);
			string = CATSPRINTF(string, "      is  N O T  S U B O R D I N A T E D  to\n");
			string = CATSPRINTF(string, "      	<%s>\n", issuer);
		}
		if (issuer) free (issuer);
		if (subject) free (subject);
		if(verres->verifstep[index]->supplied == 0)
			string = CATSPRINTF(string, "    - supplied within received 'Certificates'\n");
		else if(verres->verifstep[index]->supplied == 1)
			string = CATSPRINTF(string, "    - retrieved from Directory\n");
		else string = CATSPRINTF(string, "    - retrieved from PSE-object CrossCSet\n");

		switch(verres->verifstep[index]->crlcheck) {
		case REVOKED:
			time = aux_readable_UTCTime(verres->verifstep[index]->date);
			string = CATSPRINTF(string, "    - R E V O K E D (revocation date: %s (%s))\n\n", time, verres->verifstep[index]->date);
			if (time) free (time);
			break;
		case NOT_REVOKED:
			string = CATSPRINTF(string, "    - not revoked\n\n");
			break;
		case CRL_NOT_AVAILABLE:
			string = CATSPRINTF(string, "    - CRL not available\n\n");
			break;
		case CRL_OUT_OF_DATE:
			time = aux_readable_UTCTime(verres->verifstep[index]->date);
			string = CATSPRINTF(string, "    - CRL is out-of-date (next update: %s (%s))\n\n", time, verres->verifstep[index]->date);
			if (time) free (time);
			break;
		case NOT_REQUESTED:
			string = CATSPRINTF(string, "    - Checking against CRL was not requested\n\n");
			break;
		case 0:
			string = CATSPRINTF(string, "\n\n");
			break;
		default:
			string = CATSPRINTF(string, "undefined value\n");
			break;
		}  /* switch */

		index++;

	}   /* while */

	if (verres->success == TRUE) {
		if(verres->trustedKey == 5){
			string = CATSPRINTF(string, "which is your own certificate\n");
			string = CATSPRINTF(string, "\n");
			return(string);
		}
/* Ende-Behandlung */
		string = CATSPRINTF(string, "... validated with certificate\n\n");

		nameORalias = aux_Name2NameOrAlias(verres->top_name);
		string = CATSPRINTF(string, "    - issued by <%s>\n", nameORalias);
		free(nameORalias);
		if(verres->top_serial){
			string = CATSPRINTF(string, "    - serial number: ");
			string = aux_sprint_Serialnumber(string, verres->top_serial);
		}

		string = CATSPRINTF(string, "\n");

	
		switch(verres->trustedKey) {
		case 0:
			string = CATSPRINTF(string, "which was trusted and found in PKRoot(new)\n");
			break;
		case 1:
			string = CATSPRINTF(string, "which was trusted and found in PKRoot(old)\n");
			break;
		case 2:
			string = CATSPRINTF(string, "which was provided as RootKey-information\n");
			break;
		case 3:
			string = CATSPRINTF(string, "which was trusted and found in PKList\n");
			break;
		case 4:
			string = CATSPRINTF(string, "which was trusted and found in FCPath\n");
			break;
		case 6:
			string = CATSPRINTF(string, "which was trusted and found in PCAList\n");
			break;		}  /* switch */
	}

	if (verres->success == FALSE) {
		if (verres->verifstep && verres->verifstep[index]) {
			string = CATSPRINTF(string, "... n o t  validated with certificate\n\n");

			if(af_verbose) {
				print_indent += 4;
				string = aux_sprint_Certificate(string, verres->verifstep[index]->cert);
				print_indent -= 4;
				string = CATSPRINTF(string, "\n");
			}

			issuer = aux_DName2Name(verres->verifstep[index]->cert->tbs->issuer);
			string = CATSPRINTF(string, "    - issued by <%s>\n", issuer);
			if(verres->verifstep[index]->cert->tbs->serialnumber){
				string = CATSPRINTF(string, "    - serial number: ");
				string = aux_sprint_Serialnumber(string, verres->verifstep[index]->cert->tbs->serialnumber);
			}

			if(verres->verifstep[index]->dn_subordination_violation == TRUE){
				subject = aux_DName2Name(verres->verifstep[index]->cert->tbs->subject);
				string = CATSPRINTF(string, "    - PEM 1422 naming subordination rule  V I O L A T E D, i.e.\n");
				string = CATSPRINTF(string, "      	<%s>\n", subject);
				string = CATSPRINTF(string, "      is  N O T  S U B O R D I N A T E D  to\n");
				string = CATSPRINTF(string, "      	<%s>\n", issuer);
				if (subject) free (subject);
			}
			if (issuer) free (issuer);

			if(verres->verifstep[index]->supplied == 0)
				string = CATSPRINTF(string, "    - supplied within received 'Certificates'\n");
			else if(verres->verifstep[index]->supplied == 1)
				string = CATSPRINTF(string, "    - retrieved from Directory\n");
			else string = CATSPRINTF(string, "    - retrieved from PSE-object CrossCSet\n");
	
			switch(verres->verifstep[index]->crlcheck) {
			case REVOKED:
				time = aux_readable_UTCTime(verres->verifstep[index]->date);
				string = CATSPRINTF(string, "    - R E V O K E D (revocation date: %s (%s))\n", time, verres->verifstep[index]->date);
				if (time) free (time);
				break;
			case NOT_REVOKED:
				string = CATSPRINTF(string, "    - not revoked\n");
				break;
			case CRL_NOT_AVAILABLE:
				string = CATSPRINTF(string, "    - CRL not available\n");
				break;
			case CRL_OUT_OF_DATE:
				time = aux_readable_UTCTime(verres->verifstep[index]->date);
				string = CATSPRINTF(string, "    - CRL is out-of-date (next update: %s (%s))\n", time, verres->verifstep[index]->date);
				if (time) free (time);
				break;
			case NOT_REQUESTED:
				string = CATSPRINTF(string, "    - Checking against CRL was not requested\n");
				break;
			case 0:
				if (verres->trustedKey == - 1)
					string = CATSPRINTF(string, "    - verification  F A I L E D\n\n");
				if (verres->trustedKey == - 2)
					string = aux_sprint_validity_timeframe(string, verres->verifstep[index]->valid);
				break;
			default:
				string = CATSPRINTF(string, "undefined value\n");
				break;
			}  /* switch */
		}

		else if (verres->trustedKey == - 3)
			string = CATSPRINTF(string, "... n o t  validated (no certificate available)\n\n");
		else if (verres->trustedKey == - 4)
			string = CATSPRINTF(string, "... n o t  validated (wrong root key)\n\n");

		else {
			string = CATSPRINTF(string, "... n o t  validated with certificate\n\n");

 			if(verres->top_name){
 				string = CATSPRINTF(string, "    - issued by <%s>\n", verres->top_name);
 			}
			if(verres->top_serial){
				string = CATSPRINTF(string, "    - serial number: ");
				string = aux_sprint_Serialnumber(string, verres->top_serial);
			}

			switch(verres->trustedKey) {
			case 0:
				if(! verres->valid)
					string = CATSPRINTF(string, "    - verification  F A I L E D\n\n");
				else
					string = aux_sprint_validity_timeframe(string, verres->valid);
				string = CATSPRINTF(string, "which was found in PKRoot(new)\n");
				break;
			case 1:
				if(! verres->valid)
					string = CATSPRINTF(string, "    - verification  F A I L E D\n\n");
				else
					string = aux_sprint_validity_timeframe(string, verres->valid);
				string = CATSPRINTF(string, "which was found in PKRoot(old)\n");
				break;
			case 2:
				if(! verres->valid)
					string = CATSPRINTF(string, "    - verification  F A I L E D\n\n");
				else
					string = aux_sprint_validity_timeframe(string, verres->valid);
				string = CATSPRINTF(string, "which was provided as RootKey-information\n");
				break;
			case 3:
				string = CATSPRINTF(string, "    - verification  F A I L E D\n\n");
				string = CATSPRINTF(string, "which was found in PKList\n");
				break;
			case 4:
				string = CATSPRINTF(string, "    - verification  F A I L E D\n\n");
				string = CATSPRINTF(string, "which was found in FCPath\n");
				break;
			case 6:
				string = CATSPRINTF(string, "    - verification  F A I L E D\n\n");
				string = CATSPRINTF(string, "which was found in PCAList\n");
				break;			case - 1:
				break;
			case - 2:
				string = aux_sprint_validity_timeframe(string, verres->valid);
				break;
			default:
				string = CATSPRINTF(string, "undefined value\n");
				break;
			}  /* switch */
		}
	}

	string = CATSPRINTF(string, "\n");

	if (verres->success == TRUE){
		if(dn_subordination_violation == TRUE){
			string = CATSPRINTF(string, "Verification  F A I L E D , as ");
			string = CATSPRINTF(string, "PEM 1422 naming subordination rule  V I O L A T E D.\n\n");
		}
		if(crlcheck == CRL_NOT_AVAILABLE){
			string = CATSPRINTF(string, "Verification  F A I L E D , as at least one ");
			string = CATSPRINTF(string, "CRL was  N O T  A V A I L A B L E.\n\n");
		}
	}

	string = CATSPRINTF(string, "\n");

	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_TrustPath
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_TrustPath(
	char			 *string,
	VerificationResult	 *verres
)

#else

char *aux_sprint_TrustPath(
	string,
	verres
)
char			 *string;
VerificationResult	 *verres;

#endif

{
	int     index = 0;
	Name  * subject, *alias, * issuer, *pca, *root;
	char  * time = CNULL;

	if (! verres ) {
		string = CATSPRINTF(string, "%s\n", VERRES);
		return(string);
	}

	if(verres->trustedKey < 0 || verres->success == FALSE) return(string);

	if(!(subject = aux_DName2Name(verres->verifstep[0]->cert->tbs->subject))) return(string);

	if(aux_cmp_DName(verres->verifstep[0]->cert->tbs->subject, verres->verifstep[index]->cert->tbs->issuer) == 0) {
		string = CATSPRINTF(string, "Prototype PSE of <%s>\n", subject);
		free(subject);
		return(string);
	}

	alias = aux_Name2alias(subject, LOCALNAME);
	if(alias) {
		free(subject);
		subject = alias;
	}
	root = aux_cpy_Name(verres->top_name);
	alias = aux_Name2alias(root, LOCALNAME);
	if(alias) {
		free(root);
		root = alias;
	}
	pca = aux_PCA(verres);


	string = CATSPRINTF(string, "Owner:     <%s>\n", subject);
	if(pca) string = CATSPRINTF(string, "Policy-CA: <%s>\n", pca);
	string = CATSPRINTF(string, "Root-CA:   <%s>\n", root);
	free(subject);
	free(root);
	if(pca) free(pca);

	while (verres->verifstep && verres->verifstep[index]) {
		issuer = aux_DName2Name(verres->verifstep[index]->cert->tbs->issuer);
		alias = aux_Name2alias(issuer, LOCALNAME);
		if(alias) {
			free(issuer);
			issuer = alias;
		}
		if(verres->verifstep[index+1]) string = CATSPRINTF(string, "%d. Issuer <%s>\n          serial number ", index+1, issuer);
		else string = CATSPRINTF(string, "%d. Issuer <%s> (Root-CA)\n          serial number ", index+1, issuer);
		if(issuer) free(issuer); 
		if(verres->verifstep[index]->cert->tbs->serialnumber){
			string = aux_sprint_Serialnumber(string, verres->verifstep[index]->cert->tbs->serialnumber);
		}

		index++;

	}

	string = CATSPRINTF(string, "The Root-CA's public key has the serial number "); 
	if(verres->top_serial){
		string = aux_sprint_Serialnumber(string, verres->top_serial);
	}
	return(string);
}



/***************************************************************
 *
 * Procedure aux_sprint_error
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_error(
	char	 *string,
	int	  verbose
)

#else

char *aux_sprint_error(
	string,
	verbose
)
char	 *string;
int	  verbose;

#endif

{
	struct ErrStack *err = err_stack;
	int	n;
	Boolean save_af_use_alias = af_use_alias;

	af_use_alias = FALSE;

	if (!err_stack) goto reset_af_use_alias;
	if (verbose == 0) {
 	       string = CATSPRINTF(string, "%s", err->e_text);
               if (err->e_addrtype == PSESel_n) {
			if(((PSESel *)err->e_addr)->object.name)
		                string = CATSPRINTF(string, " %s\n", ((PSESel *)err->e_addr)->object.name);
			else
		                string = CATSPRINTF(string, " %s\n", ((PSESel *)err->e_addr)->app_name);
		}
		else if (err->e_addrtype == char_n && err->e_addr) string = CATSPRINTF(string, " :  %s\n", (char *)err->e_addr);
		else string = CATSPRINTF(string, "\n");
		goto reset_af_use_alias;
	}

	for (err = err_stack ; err != 0 ; err = err->next ) {
		for (n = 0; err_list[n].id != 0; n++) if (err_list[n].id == err->e_number) break;
		string = CATSPRINTF(string, "%s in %s: (%d) %s ", err->e_is_error ? "ERROR" : "WARNING", err->e_proc, err->e_number, err->e_text);
		if (verbose > 1 && err->e_addr) {
		
 			if (err->e_addrtype != int_n && err->e_addrtype != char_n) string = CATSPRINTF(string, "\n");
 			
 			switch (err->e_addrtype) {

			case char_n:
				string = CATSPRINTF(string, ": \"%s\"\n", err->e_addr);
				break;
			case int_n:
				string = CATSPRINTF(string, "%d\n", err->e_addr);
				break;
                        case DName_n:
                                string = CATSPRINTF(string, "%s\n", aux_DName2Name((DName *)err->e_addr));
                                break;
			case Certificate_n:
				string = aux_sprint_Certificate(string, (Certificate *)err->e_addr);
				break;
			case CertificatePair_n:
				string = aux_sprint_Certificate(string, ((CertificatePair * )err->e_addr)->forward);
				string = aux_sprint_Certificate(string, ((CertificatePair * )err->e_addr)->reverse);
				break;
			case Certificates_n:
				string = aux_sprint_Certificates(string, (Certificates *)err->e_addr);
				break;
			case PKList_n:
				string = aux_sprint_PKList(string, (PKList *)err->e_addr);
				break;
			case OctetString_n:
				string = aux_sxdump2(string, ((OctetString * )err->e_addr)->octets, ((OctetString * )err->e_addr)->noctets , 0);
				break;
			case BitString_n:
				string = aux_sxdump2(string, ((OctetString * )err->e_addr)->octets, (((OctetString * )err->e_addr)->noctets + 7) / 8 , 0);
				break;
			case SET_OF_Certificate_n:
				string = aux_sprint_CertificateSet(string, (SET_OF_Certificate *)err->e_addr);
				break;
			case SET_OF_CertificatePair_n:
				string = aux_sprint_CertificatePairSet(string, (SET_OF_CertificatePair *)err->e_addr);
				break;
			case AlgId_n:
				string = aux_sprint_AlgId(string, (AlgId *)err->e_addr);
				break;
			case OCList_n:
				string = aux_sprint_OCList(string, (OCList *)err->e_addr);
				break;
			case CRLTBS_n:
				string = aux_sprint_CRLTBS(string, (CRLTBS *)err->e_addr);
				break;
			case CRL_n:
				string = aux_sprint_CRL(string, (CRL *)err->e_addr);
				break;
			case CRLEntry_n:
				string = aux_sprint_CRLEntry(string, (CRLEntry *)err->e_addr);
				break;
			case CrlSet_n:
				string = aux_sprint_CrlSet(string, (CrlSet *)err->e_addr);
				break;
			case Crl_n:
				string = aux_sprint_Crl(string, (Crl *)err->e_addr);
				break;
			case KeyInfo_n:
				string = aux_sprint_KeyInfo(string, (KeyInfo *)err->e_addr);
				break;
			case FCPath_n:
				string = aux_sprint_FCPath(string, (FCPath *)err->e_addr);
				break;
			case PKRoot_n:
				string = aux_sprint_PKRoot(string, (PKRoot *)err->e_addr);
				break;
			case IssuedCertificate_n:
				string = aux_sprint_IssuedCertificate(string, (IssuedCertificate *)err->e_addr);
				break;
			case SET_OF_IssuedCertificate_n:
				string = aux_sprint_SET_OF_IssuedCertificate(string, (SET_OF_IssuedCertificate *)err->e_addr);
				break;
			case SET_OF_Name_n:
				string = aux_sprint_SET_OF_Name(string, (SET_OF_Name *)err->e_addr);
				break;
			case ToBeSigned_n:
				string = aux_sprint_ToBeSigned(string, (ToBeSigned *)err->e_addr);
				break;
			case ObjId_n:
				string = aux_sprint_ObjId(string, (ObjId *)err->e_addr);
				break;
			case KeyBits_n:
				string = aux_sprint_KeyBits(string, (KeyBits *)err->e_addr);
				break;
			case PSEToc_n:
				string = aux_sprint_PSEToc(string, (PSEToc *)err->e_addr, (PSEToc *) 0 );
				break;
			case PSESel_n:
				string = aux_sprint_PSESel(string, (PSESel *)err->e_addr);
				break;
			case CRLWithCertificates_n:
				string = aux_sprint_CRLWithCertificates(string, (CRLWithCertificates *)err->e_addr);
				break;
			case SET_OF_CRLWithCertificates_n:
				string = aux_sprint_SET_OF_CRLWithCertificates(string, (SET_OF_CRLWithCertificates *)err->e_addr);
				break;
			}
		}
 		else string = CATSPRINTF(string, "\n");

	}
reset_af_use_alias:
	af_use_alias = save_af_use_alias;
	return(string);
}



/***************************************************************
 *
 * Procedure aux_sprint_validity_timeframe
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_validity_timeframe(
	char	  *string,
	Validity  *valid
)

#else

char *aux_sprint_validity_timeframe(
	string,
	valid
)
char	 *string;
Validity *valid;

#endif

{
	char   * notbefore, * notafter;
	char   * proc = "aux_sprint_validity_timeframe";


	notbefore = aux_readable_UTCTime(valid->notbefore);
	notafter = aux_readable_UTCTime(valid->notafter);

	string = CATSPRINTF(string, "    - Verification date (default: current time) not within validity time frame\n");
	string = CATSPRINTF(string, "      (notbefore: %s -- notafter: %s)\n\n", notbefore, notafter);

	if(notbefore) free(notbefore);
	if(notafter) free(notafter);
	
	return(string);
}

/***************************************************************
 *
 * Procedure aux_sprint_PemMessageLocal
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_PemMessageLocal(
	char		 *string,
	PemMessageLocal	 *local
)

#else

char *aux_sprint_PemMessageLocal(
	string,
	local
)
char		 *string;
PemMessageLocal	 *local;

#endif

{
	if(local) {
		string = aux_sprint_PemHeaderLocal(string, local->header);
		string = aux_sprint_OctetString(string, local->body);
		if(local->comment) string = CATSPRINTF(string, local->comment);
		string = aux_sprint_VerificationResult(string, local->validation_result);
		if(local->error) string = CATSPRINTF(string, local->error);
	}
	return(string);
}
/***************************************************************
 *
 * Procedure aux_sprint_PemDekLocal
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_PemDekLocal(
	char		 *string,
	PemDekLocal	 *dek
)

#else

char *aux_sprint_PemDekLocal(
	string,
	dek
)
char		 *string;
PemDekLocal	 *dek;

#endif

{
	SET_OF_PemRecLocal *setof_rec;
	if(dek) {
		string = CATSPRINTF(string, "DEK algorithm : ");
		string = aux_sprint_AlgId(string, dek->dekinfo_enc_alg);

		string = CATSPRINTF(string, "Originator KeyInfo algorithm : ");
		string = aux_sprint_AlgId(string, dek->keyinfo_enc_alg);

		string = CATSPRINTF(string, "Originator KeyInfo           : ");
		string = aux_sprint_BitString(string, dek->keyinfo_dek);

		for(setof_rec = dek->recipients;setof_rec; setof_rec = setof_rec->next) 
			string = aux_sprint_PemRecLocal(string, setof_rec->element);
	}
	return(string);
}
/***************************************************************
 *
 * Procedure aux_sprint_PemRecLocal
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_PemRecLocal(
	char		 *string,
	PemRecLocal	 *rec
)

#else

char *aux_sprint_PemRecLocal(
	string,
	rec
)
char		 *string;
PemRecLocal	 *rec;

#endif

{
	if(rec) {
		string = CATSPRINTF(string, "Recipient  ID Asymmetric     : ");
		string = aux_sprint_DNameOrAlias(string, rec->certificate->tbs->issuer);
		string = CATSPRINTF(string, ",");
		string = aux_sprint_Serialnumber(string, rec->certificate->tbs->serialnumber);

		string = CATSPRINTF(string, "Recipients KeyInfo algorithm : ");
		string = aux_sprint_AlgId(string, rec->enc_alg);

		string = CATSPRINTF(string, "Recipients KeyInfo           : ");
		string = aux_sprint_BitString(string, rec->dek);
	}
	return(string);
}
/***************************************************************
 *
 * Procedure aux_sprint_PemMicLocal
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_PemMicLocal(
	char		 *string,
	PemMicLocal	 *mic
)

#else

char *aux_sprint_PemMicLocal(
	string,
	mic
)
char		 *string;
PemMicLocal	 *mic;

#endif

{
	if(mic) {
		string = aux_sprint_AlgId(string, mic->signAI);
		string = aux_sprint_BitString(string, mic->mic);
		if(mic->PEM_conformant) string = CATSPRINTF(string, "PEM conformant\n");
		else string = CATSPRINTF(string, "NOT PEM conformant\n");
	}
	return(string);
}
/***************************************************************
 *
 * Procedure aux_sprint_PemHeaderLocal
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_PemHeaderLocal(
	char		 *string,
	PemHeaderLocal	 *hd
)

#else

char *aux_sprint_PemHeaderLocal(
	string,
	hd
)
char		 *string;
PemHeaderLocal	 *hd;

#endif

{
	SET_OF_DName *setof_dname;

	if(hd) {
		string = CATSPRINTF(string, "RFC-Version    : %d\n", hd->rfc_version); 
		string = CATSPRINTF(string, "Proc-Type      : %s\n", proc_type_t[hd->proctype].name); 
		string = CATSPRINTF(string, "Content-Domain : %s\n", content_domain[hd->content_domain].name); 
		string = aux_sprint_PemDekLocal(string, hd->dek_fields);
		string = aux_sprint_Certificates(string, hd->certificates);
		string = aux_sprint_PemMicLocal(string, hd->mic_fields);
		string = aux_sprint_SET_OF_CRLWithCertificates(string, hd->crl_fields);

		for(setof_dname = hd->crl_rr_fields;setof_dname; setof_dname = setof_dname->next) {
			string = aux_sprint_DNameOrAlias(string, setof_dname->element);
		}

	}
	return(string);
}








/***************************************************************
 *
 * Procedure aux_fprint_KeyInfo
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_KeyInfo(
	FILE	*ff,
	KeyInfo	 *pki
)

#else

RC aux_fprint_KeyInfo(
	ff,
	pki
)
FILE	*ff;
KeyInfo	 *pki;

#endif

{
	char *string = aux_sprint_KeyInfo(CNULL, pki);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}

/***************************************************************
 *
 * Procedure aux_fprint_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_AliasList(
	FILE		 *ff,
	AliasList	 *aliaslist
)

#else

RC aux_fprint_AliasList(
	ff,
	aliaslist
)
FILE		 *ff;
AliasList	 *aliaslist;

#endif

{
	char		*proc = "aux_fprint_AliasList";
	char 		*string = aux_sprint_AliasList(CNULL, aliaslist);


	if (string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}












/***************************************************************
 *
 * Procedure aux_fprint_DNameOrAlias
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_DNameOrAlias(
	FILE	*ff,
	DName	 *dname
)

#else

RC aux_fprint_DNameOrAlias(
	ff,
	dname
)
FILE	*ff;
DName	 *dname;

#endif

{
	char *string = aux_sprint_DNameOrAlias(CNULL, dname);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}
	
/***************************************************************
 *
 * Procedure aux_fprint_NameOrAlias
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_NameOrAlias(
	FILE	*ff,
	Name	 *name
)

#else

RC aux_fprint_NameOrAlias(
	ff,
	name
)
FILE	*ff;
Name	 *name;

#endif

{
	char *string = aux_sprint_NameOrAlias(CNULL, name);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/************************************************************************/
/*                                                                      */
/*    aux_fprint_OctetString, aux_fprint_BitString                      */
/*                                                                      */
/*    prints given OctetString/BitString in a dump format to stderr     */
/*                                                                      */
/*                                                                      */
/************************************************************************/

/***************************************************************
 *
 * Procedure aux_fprint_GRAPHICString
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_GRAPHICString(
	FILE	*ff,
	char	*graphic
)

#else

RC aux_fprint_GRAPHICString(
	ff,
	graphic
)
FILE	*ff;
char	*graphic;

#endif

{
	char *string = aux_sprint_GRAPHICString(CNULL, graphic);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}



/***************************************************************
 *
 * Procedure aux_fprint_PSESel
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_PSESel(
	FILE	*ff,
	PSESel	 *pse
)

#else

RC aux_fprint_PSESel(
	ff,
	pse
)
FILE	*ff;
PSESel	 *pse;

#endif

{
	char *string = aux_sprint_PSESel(CNULL, pse);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}

/***************************************************************
 *
 * Procedure aux_fprint_Version
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_Version(
	FILE	*ff
)

#else

RC aux_fprint_Version(
	ff
)
FILE	*ff;

#endif

{
	char *string = aux_sprint_Version(CNULL);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}

/***************************************************************
 *
 * Procedure aux_fprint_version
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_version(
	FILE	*ff
)

#else

RC aux_fprint_version(
	ff
)
FILE	*ff;

#endif

{
	char *string = aux_sprint_version(CNULL);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}

/***************************************************************
 *
 * Procedure aux_fprint_PSEToc
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_PSEToc(
	FILE	*ff,
	PSEToc	 *toc1,
	PSEToc	 *toc2
)

#else

RC aux_fprint_PSEToc(
	ff,
	toc1,
	toc2
)
FILE	*ff;
PSEToc	 *toc1;
PSEToc	 *toc2;

#endif

{
	char *string = aux_sprint_PSEToc(CNULL, toc1, toc2);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}



/***************************************************************
 *
 * Procedure aux_fprint_Certificate
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_Certificate(
	FILE	*ff,
	Certificate	 *cert
)

#else

RC aux_fprint_Certificate(
	ff,
	cert
)
FILE	*ff;
Certificate	 *cert;

#endif

{
	char *string = aux_sprint_Certificate(CNULL, cert);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}



/***************************************************************
 *
 * Procedure aux_fprint_Serialnumber
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_Serialnumber(
	FILE	*ff,
	OctetString	 *serial
)

#else

RC aux_fprint_Serialnumber(
	ff,
	serial
)
FILE	*ff;
OctetString	 *serial;

#endif

{
	char *string = aux_sprint_Serialnumber(CNULL, serial);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_ToBeSigned
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_ToBeSigned(
	FILE	*ff,
	ToBeSigned	 *tbs
)

#else

RC aux_fprint_ToBeSigned(
	ff,
	tbs
)
FILE	*ff;
ToBeSigned	 *tbs;

#endif

{
	char *string = aux_sprint_ToBeSigned(CNULL, tbs);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


#ifdef COSINE
/***************************************************************
 *
 * Procedure aux_fprint_AuthorisationAttributes
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_AuthorisationAttributes(
	FILE	*ff,
	AuthorisationAttributes	 *authatts
)

#else

RC aux_fprint_AuthorisationAttributes(
	ff,
	authatts
)
FILE	*ff;
AuthorisationAttributes	 *authatts;

#endif

{
	char *string = aux_sprint_AuthorisationAttributes(CNULL, authatts);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);

}
#endif

/***************************************************************
 *
 * Procedure aux_fprint_FCPath
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_FCPath(
	FILE	*ff,
	FCPath	 *fcpath
)

#else

RC aux_fprint_FCPath(
	ff,
	fcpath
)
FILE	*ff;
FCPath	 *fcpath;

#endif

{
	char *string = aux_sprint_FCPath(CNULL, fcpath);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_Certificates
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_Certificates(
	FILE	*ff,
	Certificates	 *certs
)

#else

RC aux_fprint_Certificates(
	ff,
	certs
)
FILE	*ff;
Certificates	 *certs;

#endif

{
	char *string = aux_sprint_Certificates(CNULL, certs);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_Validity
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_Validity(
	FILE	*ff,
	Validity *valid
)

#else

RC aux_fprint_Validity(
	ff,
	valid
)
FILE	*ff;
Validity *valid;

#endif

{
	char *string = aux_sprint_Validity(CNULL, valid);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_RootInfo
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_RootInfo(
	FILE	*ff,
	Serial	 *rootinfo,
	Boolean	  new_
)

#else

RC aux_fprint_RootInfo(
	ff,
	rootinfo,
	new_
)
FILE	*ff;
Serial	 *rootinfo;
Boolean	  new_;

#endif

{
	char *string = aux_sprint_RootInfo(CNULL, rootinfo, new_);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}

/***************************************************************
 *
 * Procedure aux_fprint_PKRoot
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_PKRoot(
	FILE	*ff,
	PKRoot	 *pkroot
)

#else

RC aux_fprint_PKRoot(
	ff,
	pkroot
)
FILE	*ff;
PKRoot	 *pkroot;

#endif

{
	char *string = aux_sprint_PKRoot(CNULL, pkroot);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}



/***************************************************************
 *
 * Procedure aux_fprint_PKList
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_PKList(
	FILE	*ff,
	PKList	 *pklist
)

#else

RC aux_fprint_PKList(
	ff,
	pklist
)
FILE	*ff;
PKList	 *pklist;

#endif

{
	char *string = aux_sprint_PKList(CNULL, pklist);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_CRLEntry
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_CRLEntry(
	FILE	*ff,
	CRLEntry	 *crlentry
)

#else

RC aux_fprint_CRLEntry(
	ff,
	crlentry
)
FILE	*ff;
CRLEntry	 *crlentry;

#endif

{
	char *string = aux_sprint_CRLEntry(CNULL, crlentry);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_CRL
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_CRL(
	FILE	*ff,
	CRL	 *crl
)

#else

RC aux_fprint_CRL(
	ff,
	crl
)
FILE	*ff;
CRL	 *crl;

#endif

{
	char *string = aux_sprint_CRL(CNULL, crl);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_CRLTBS
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_CRLTBS(
	FILE	*ff,
	CRLTBS	 *tbs
)

#else

RC aux_fprint_CRLTBS(
	ff,
	tbs
)
FILE	*ff;
CRLTBS	 *tbs;

#endif

{
	char *string = aux_sprint_CRLTBS(CNULL, tbs);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_OCList
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_OCList(
	FILE	*ff,
	OCList	 *oclist
)

#else

RC aux_fprint_OCList(
	ff,
	oclist
)
FILE	*ff;
OCList	 *oclist;

#endif

{
	char *string = aux_sprint_OCList(CNULL, oclist);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);

}

/***************************************************************
 *
 * Procedure aux_fprint_CertificateSet
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_CertificateSet(
	FILE	*ff,
	SET_OF_Certificate	 *certset
)

#else

RC aux_fprint_CertificateSet(
	ff,
	certset
)
FILE	*ff;
SET_OF_Certificate	 *certset;

#endif

{
	char *string = aux_sprint_CertificateSet(CNULL, certset);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);

}


/***************************************************************
 *
 * Procedure aux_fprint_CertificatePairSet
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_CertificatePairSet(
	FILE	*ff,
	SET_OF_CertificatePair	 *cpair
)

#else

RC aux_fprint_CertificatePairSet(
	ff,
	cpair
)
FILE	*ff;
SET_OF_CertificatePair	 *cpair;

#endif

{

	char *string = aux_sprint_CertificatePairSet(CNULL, cpair);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_Crl
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_Crl(
	FILE	*ff,
	Crl	 *crlpse
)

#else

RC aux_fprint_Crl(
	ff,
	crlpse
)
FILE	*ff;
Crl	 *crlpse;

#endif

{
	char *string = aux_sprint_Crl(CNULL, crlpse);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_CrlSet
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_CrlSet(
	FILE	*ff,
	CrlSet	 *crlset
)

#else

RC aux_fprint_CrlSet(
	ff,
	crlset
)
FILE	*ff;
CrlSet	 *crlset;

#endif

{
	char *string = aux_sprint_CrlSet(CNULL, crlset);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);

}


/***************************************************************
 *
 * Procedure aux_fprint_IssuedCertificate
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_IssuedCertificate(
	FILE	*ff,
	IssuedCertificate	 *isscert
)

#else

RC aux_fprint_IssuedCertificate(
	ff,
	isscert
)
FILE	*ff;
IssuedCertificate	 *isscert;

#endif

{
	char *string = aux_sprint_IssuedCertificate(CNULL, isscert);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_SET_OF_IssuedCertificate
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_SET_OF_IssuedCertificate(
	FILE	*ff,
	SET_OF_IssuedCertificate	 *isscertset
)

#else

RC aux_fprint_SET_OF_IssuedCertificate(
	ff,
	isscertset
)
FILE	*ff;
SET_OF_IssuedCertificate	 *isscertset;

#endif

{
	char *string = aux_sprint_SET_OF_IssuedCertificate(CNULL, isscertset);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);

}


/***************************************************************
 *
 * Procedure aux_fprint_SET_OF_Name
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_SET_OF_Name(
	FILE	*ff,
	SET_OF_Name	 *nameset
)

#else

RC aux_fprint_SET_OF_Name(
	ff,
	nameset
)
FILE	*ff;
SET_OF_Name	 *nameset;

#endif

{
	char *string = aux_sprint_SET_OF_Name(CNULL, nameset);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_CRLWithCertificates
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_CRLWithCertificates(
	FILE	*ff,
	CRLWithCertificates	 *arg
)

#else

RC aux_fprint_CRLWithCertificates(
	ff,
	arg
)
FILE	*ff;
CRLWithCertificates	 *arg;

#endif

{
	char *string = aux_sprint_CRLWithCertificates(CNULL, arg);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_SET_OF_CRLWithCertificates
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_SET_OF_CRLWithCertificates(
	FILE	*ff,
	SET_OF_CRLWithCertificates	 *set
)

#else

RC aux_fprint_SET_OF_CRLWithCertificates(
	ff,
	set
)
FILE	*ff;
SET_OF_CRLWithCertificates	 *set;

#endif

{
	char *string = aux_sprint_SET_OF_CRLWithCertificates(CNULL, set);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_VerificationResult
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_VerificationResult(
	FILE	*ff,
	VerificationResult	 *verres
)

#else

RC aux_fprint_VerificationResult(
	ff,
	verres
)
FILE	*ff;
VerificationResult	 *verres;

#endif

{
	char *string = aux_sprint_VerificationResult(CNULL, verres);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_TrustPath
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_TrustPath(
	FILE	*ff,
	VerificationResult	 *verres
)

#else

RC aux_fprint_TrustPath(
	ff,
	verres
)
FILE	*ff;
VerificationResult	 *verres;

#endif

{
	char *string = aux_sprint_TrustPath(CNULL, verres);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}



/***************************************************************
 *
 * Procedure aux_fprint_error
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_error(
	FILE	*ff,
	int	  verbose
)

#else

RC aux_fprint_error(
	ff,
	verbose
)
FILE	*ff;
int	  verbose;

#endif

{
	char *string = aux_sprint_error(CNULL, verbose);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}



/***************************************************************
 *
 * Procedure aux_fprint_validity_timeframe
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_validity_timeframe(
	FILE	*ff,
	Validity  *valid
)

#else

RC aux_fprint_validity_timeframe(
	ff,
	valid
)
FILE	*ff;
Validity *valid;

#endif

{
	char *string = aux_sprint_validity_timeframe(CNULL, valid);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}



/***************************************************************
 *
 * Procedure aux_fprint_PemMessageLocal
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_PemMessageLocal(
	FILE		 *ff,
	PemMessageLocal	 *local
)

#else

RC aux_fprint_PemMessageLocal(
	ff,
	local
)
FILE		 *ff;
PemMessageLocal	 *local;

#endif

{
	char *string = aux_sprint_PemMessageLocal(CNULL, local);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}
/***************************************************************
 *
 * Procedure aux_fprint_PemDekLocal
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_PemDekLocal(
	FILE		 *ff,
	PemDekLocal	 *dek
)

#else

RC aux_fprint_PemDekLocal(
	ff,
	dek
)
FILE		 *ff;
PemDekLocal	 *dek;

#endif

{
	char *string = aux_sprint_PemDekLocal(CNULL, dek);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}
/***************************************************************
 *
 * Procedure aux_fprint_PemRecLocal
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_PemRecLocal(
	FILE		 *ff,
	PemRecLocal	 *rec
)

#else

RC aux_fprint_PemRecLocal(
	ff,
	rec
)
FILE		 *ff;
PemRecLocal	 *rec;

#endif

{
	char *string = aux_sprint_PemRecLocal(CNULL, rec);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}
/***************************************************************
 *
 * Procedure aux_fprint_PemMicLocal
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_PemMicLocal(
	FILE		 *ff,
	PemMicLocal	 *mic
)

#else

RC aux_fprint_PemMicLocal(
	ff,
	mic
)
FILE		 *ff;
PemMicLocal	 *mic;

#endif

{
	char *string = aux_sprint_PemMicLocal(CNULL, mic);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}
/***************************************************************
 *
 * Procedure aux_fprint_PemHeaderLocal
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_PemHeaderLocal(
	FILE		 *ff,
	PemHeaderLocal	 *hd
)

#else

RC aux_fprint_PemHeaderLocal(
	ff,
	hd
)
FILE		 *ff;
PemHeaderLocal	 *hd;

#endif

{
	char *string = aux_sprint_PemHeaderLocal(CNULL, hd);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}



/***************************************************************
 *
 * Procedure aux_print_KeyInfo
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_KeyInfo(
	KeyInfo	 *pki
)

#else

RC aux_print_KeyInfo(
	pki
)
KeyInfo	 *pki;

#endif

{
	return(aux_fprint_KeyInfo(stderr, pki));
}
/***************************************************************
 *
 * Procedure aux_print_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_AliasList(
	AliasList	 *aliaslist
)

#else

RC aux_print_AliasList(
	aliaslist
)
AliasList	 *aliaslist;

#endif

{
	char	           *proc = "aux_print_AliasList";


	return(aux_fprint_AliasList(stderr, aliaslist));
}











/***************************************************************
 *
 * Procedure aux_print_DNameOrAlias
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_DNameOrAlias(
	DName	 *dname
)

#else

RC aux_print_DNameOrAlias(
	dname
)
DName	 *dname;

#endif

{
	return(aux_fprint_DNameOrAlias(stderr, dname));
}
	
/***************************************************************
 *
 * Procedure aux_print_NameOrAlias
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_NameOrAlias(
	Name	 *name
)

#else

RC aux_print_NameOrAlias(
	name
)
Name	 *name;

#endif

{
	return(aux_fprint_NameOrAlias(stderr, name));
}


/***************************************************************
 *
 * Procedure aux_print_GRAPHICString
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_GRAPHICString(
	char	 *graphic
)

#else

RC aux_print_GRAPHICString(
	graphic
)
char	 *graphic;

#endif

{
	return(aux_fprint_GRAPHICString(stderr, graphic));
}


/***************************************************************
 *
 * Procedure aux_print_PSESel
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_PSESel(
	PSESel	 *pse
)

#else

RC aux_print_PSESel(
	pse
)
PSESel	 *pse;

#endif

{
	return(aux_fprint_PSESel(stderr, pse));
}

/***************************************************************
 *
 * Procedure aux_print_Version
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_Version(
)

#else

RC aux_print_Version(
)

#endif

{
	return(aux_fprint_Version(stderr));
}

/***************************************************************
 *
 * Procedure aux_print_version
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_version(
)

#else

RC aux_print_version(
)

#endif

{
	return(aux_fprint_version(stderr));
}

/***************************************************************
 *
 * Procedure aux_print_PSEToc
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_PSEToc(
	PSEToc	 *toc1,
	PSEToc	 *toc2
)

#else

RC aux_print_PSEToc(
	toc1,
	toc2
)
PSEToc	 *toc1;
PSEToc	 *toc2;

#endif

{
	return(aux_fprint_PSEToc(stderr, toc1, toc2));
}

/***************************************************************
 *
 * Procedure aux_print_Certificate
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_Certificate(
	Certificate	 *cert
)

#else

RC aux_print_Certificate(
	cert
)
Certificate	 *cert;

#endif

{
	return(aux_fprint_Certificate(stderr, cert));
}



/***************************************************************
 *
 * Procedure aux_print_Serialnumber
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_Serialnumber(
	OctetString	 *serial
)

#else

RC aux_print_Serialnumber(
	serial
)
OctetString	 *serial;

#endif

{
	return(aux_fprint_Serialnumber(stderr, serial));
}


/***************************************************************
 *
 * Procedure aux_print_ToBeSigned
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_ToBeSigned(
	ToBeSigned	 *tbs
)

#else

RC aux_print_ToBeSigned(
	tbs
)
ToBeSigned	 *tbs;

#endif

{
	return(aux_fprint_ToBeSigned(stderr, tbs));
}


#ifdef COSINE
/***************************************************************
 *
 * Procedure aux_print_AuthorisationAttributes
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_AuthorisationAttributes(
	AuthorisationAttributes	 *authatts
)

#else

RC aux_print_AuthorisationAttributes(
	authatts
)
AuthorisationAttributes	 *authatts;

#endif

{
	return(aux_fprint_AuthorisationAttributes(stderr, authatts));

}
#endif

/***************************************************************
 *
 * Procedure aux_print_FCPath
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_FCPath(
	FCPath	 *fcpath
)

#else

RC aux_print_FCPath(
	fcpath
)
FCPath	 *fcpath;

#endif

{
	return(aux_fprint_FCPath(stderr, fcpath));
}


/***************************************************************
 *
 * Procedure aux_print_Certificates
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_Certificates(
	Certificates	 *certs
)

#else

RC aux_print_Certificates(
	certs
)
Certificates	 *certs;

#endif

{
	return(aux_fprint_Certificates(stderr, certs));
}


/***************************************************************
 *
 * Procedure aux_print_Validity
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_Validity(
	Validity *valid
)

#else

RC aux_print_Validity(
	valid
)
Validity *valid;

#endif

{
	return(aux_fprint_Validity(stderr, valid));
}


/***************************************************************
 *
 * Procedure aux_print_RootInfo
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_RootInfo(
	Serial	 *rootinfo,
	Boolean	  new_
)

#else

RC aux_print_RootInfo(
	rootinfo,
	new_
)
Serial	 *rootinfo;
Boolean	  new_;

#endif

{
	return(aux_fprint_RootInfo(stderr, rootinfo, new_));
}

/***************************************************************
 *
 * Procedure aux_print_PKRoot
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_PKRoot(
	PKRoot	 *pkroot
)

#else

RC aux_print_PKRoot(
	pkroot
)
PKRoot	 *pkroot;

#endif

{
	return(aux_fprint_PKRoot(stderr, pkroot));
}



/***************************************************************
 *
 * Procedure aux_print_PKList
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_PKList(
	PKList	 *pklist
)

#else

RC aux_print_PKList(
	pklist
)
PKList	 *pklist;

#endif

{
	return(aux_fprint_PKList(stderr, pklist));
}


/***************************************************************
 *
 * Procedure aux_print_CRLEntry
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_CRLEntry(
	CRLEntry	 *crlentry
)

#else

RC aux_print_CRLEntry(
	crlentry
)
CRLEntry	 *crlentry;

#endif

{
	return(aux_fprint_CRLEntry(stderr, crlentry));
}


/***************************************************************
 *
 * Procedure aux_print_CRL
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_CRL(
	CRL	 *crl
)

#else

RC aux_print_CRL(
	crl
)
CRL	 *crl;

#endif

{
	return(aux_fprint_CRL(stderr, crl));
}


/***************************************************************
 *
 * Procedure aux_print_CRLTBS
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_CRLTBS(
	CRLTBS	 *tbs
)

#else

RC aux_print_CRLTBS(
	tbs
)
CRLTBS	 *tbs;

#endif

{
	return(aux_fprint_CRLTBS(stderr, tbs));
}


/***************************************************************
 *
 * Procedure aux_print_OCList
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_OCList(
	OCList	 *oclist
)

#else

RC aux_print_OCList(
	oclist
)
OCList	 *oclist;

#endif

{
	return(aux_fprint_OCList(stderr, oclist));

}

/***************************************************************
 *
 * Procedure aux_print_CertificateSet
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_CertificateSet(
	SET_OF_Certificate	 *certset
)

#else

RC aux_print_CertificateSet(
	certset
)
SET_OF_Certificate	 *certset;

#endif

{
	return(aux_fprint_CertificateSet(stderr, certset));

}


/***************************************************************
 *
 * Procedure aux_print_CertificatePairSet
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_CertificatePairSet(
	SET_OF_CertificatePair	 *cpair
)

#else

RC aux_print_CertificatePairSet(
	cpair
)
SET_OF_CertificatePair	 *cpair;

#endif

{

	return(aux_fprint_CertificatePairSet(stderr, cpair));
}


/***************************************************************
 *
 * Procedure aux_print_Crl
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_Crl(
	Crl	 *crlpse
)

#else

RC aux_print_Crl(
	crlpse
)
Crl	 *crlpse;

#endif

{
	return(aux_fprint_Crl(stderr, crlpse));
}


/***************************************************************
 *
 * Procedure aux_print_CrlSet
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_CrlSet(
	CrlSet	 *crlset
)

#else

RC aux_print_CrlSet(
	crlset
)
CrlSet	 *crlset;

#endif

{
	return(aux_fprint_CrlSet(stderr, crlset));

}


/***************************************************************
 *
 * Procedure aux_print_IssuedCertificate
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_IssuedCertificate(
	IssuedCertificate	 *isscert
)

#else

RC aux_print_IssuedCertificate(
	isscert
)
IssuedCertificate	 *isscert;

#endif

{
	return(aux_fprint_IssuedCertificate(stderr, isscert));
}


/***************************************************************
 *
 * Procedure aux_print_SET_OF_IssuedCertificate
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_SET_OF_IssuedCertificate(
	SET_OF_IssuedCertificate	 *isscertset
)

#else

RC aux_print_SET_OF_IssuedCertificate(
	isscertset
)
SET_OF_IssuedCertificate	 *isscertset;

#endif

{
	return(aux_fprint_SET_OF_IssuedCertificate(stderr, isscertset));

}


/***************************************************************
 *
 * Procedure aux_print_SET_OF_Name
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_SET_OF_Name(
	SET_OF_Name	 *nameset
)

#else

RC aux_print_SET_OF_Name(
	nameset
)
SET_OF_Name	 *nameset;

#endif

{
	return(aux_fprint_SET_OF_Name(stderr, nameset));
}


/***************************************************************
 *
 * Procedure aux_print_CRLWithCertificates
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_CRLWithCertificates(
	CRLWithCertificates	 *arg
)

#else

RC aux_print_CRLWithCertificates(
	arg
)
CRLWithCertificates	 *arg;

#endif

{
	return(aux_fprint_CRLWithCertificates(stderr, arg));
}


/***************************************************************
 *
 * Procedure aux_print_SET_OF_CRLWithCertificates
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_SET_OF_CRLWithCertificates(
	SET_OF_CRLWithCertificates	 *set
)

#else

RC aux_print_SET_OF_CRLWithCertificates(
	set
)
SET_OF_CRLWithCertificates	 *set;

#endif

{
	return(aux_fprint_SET_OF_CRLWithCertificates(stderr, set));
}


/***************************************************************
 *
 * Procedure aux_print_VerificationResult
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_VerificationResult(
	VerificationResult	 *verres
)

#else

RC aux_print_VerificationResult(
	verres
)
VerificationResult	 *verres;

#endif

{
	return(aux_fprint_VerificationResult(stderr, verres));
}


/***************************************************************
 *
 * Procedure aux_print_TrustPath
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_TrustPath(
	VerificationResult	 *verres
)

#else

RC aux_print_TrustPath(
	verres
)
VerificationResult	 *verres;

#endif

{
	return(aux_fprint_TrustPath(stderr, verres));
}



/***************************************************************
 *
 * Procedure aux_print_error
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_error(
	int	  verbose
)

#else

RC aux_print_error(
	verbose
)
int	  verbose;

#endif

{
	return(aux_fprint_error(stderr, verbose));
}



/***************************************************************
 *
 * Procedure aux_print_validity_timeframe
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_validity_timeframe(
	Validity  *valid
)

#else

RC aux_print_validity_timeframe(
	valid
)
Validity *valid;

#endif

{
	return(aux_fprint_validity_timeframe(stderr, valid));
}




/***************************************************************
 *
 * Procedure aux_print_PemMessageLocal
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_PemMessageLocal(
	PemMessageLocal	 *local
)

#else

RC aux_print_PemMessageLocal(
	local
)
PemMessageLocal	 *local;

#endif

{
	return(aux_fprint_PemMessageLocal(stderr, local));
}
/***************************************************************
 *
 * Procedure aux_print_PemDekLocal
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_PemDekLocal(
	PemDekLocal	 *dek
)

#else

RC aux_print_PemDekLocal(
	dek
)
PemDekLocal	 *dek;

#endif

{
	return(aux_fprint_PemDekLocal(stderr, dek));
}
/***************************************************************
 *
 * Procedure aux_print_PemRecLocal
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_PemRecLocal(
	PemRecLocal	 *rec
)

#else

RC aux_print_PemRecLocal(
	rec
)
PemRecLocal	 *rec;

#endif

{
	return(aux_fprint_PemRecLocal(stderr, rec));
}
/***************************************************************
 *
 * Procedure aux_print_PemMicLocal
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_PemMicLocal(
	PemMicLocal	 *mic
)

#else

RC aux_print_PemMicLocal(
	mic
)
PemMicLocal	 *mic;

#endif

{
	return(aux_fprint_PemMicLocal(stderr, mic));
}
/***************************************************************
 *
 * Procedure aux_print_PemHeaderLocal
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_PemHeaderLocal(
	PemHeaderLocal	 *hd
)

#else

RC aux_print_PemHeaderLocal(
	hd
)
PemHeaderLocal	 *hd;

#endif

{
	return(aux_fprint_PemHeaderLocal(stderr, hd));
}





