/* ./src/aux/aux_time.c */

static char *rcsid = "$Id: aux_time.c,v 1.6 1994/12/21 15:41:13 surkau Exp $";

/* 
 *
 * $Id: aux_time.c,v 1.6 1994/12/21 15:41:13 surkau Exp $
 *
 * $Log: aux_time.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*
 *           int	aux_get_timezone();
 *           RC		aux_check_UTCTime	(UTCTime *utc);
 *           time_t 	aux_UTCTime2time_t	(UTCTime *utc);
 *           UTCTime 	*aux_time_t2UTCTime	(time_t seconds);
 *           UTCTime	*aux_current_UTCTime	();
 *           char	*aux_readable_UTCTime	(UTCTime *tx);
 *           UTCTime	*aux_delta_UTCTime	(UTCTime *time, time_t delta);
 *           int	aux_interval_UTCTime	(UTCTime *time, UTCTime *notbefore, UTCTime *notafter);
 *           int	aux_interval2_UTCTime	(UTCTime *time, UTCTime *notbefore, UTCTime *notafter);
 *           int	aux_cmp_UTCTime	(UTCTime *time1, UTCTime *time2);
 *           UTCTime	*aux_delta_UTCTime_T_REC	(UTCTime *time, T_REC *delta);
 *           UTCTime	*aux_T_REC2UTCTime	(T_REC *time);
 */


#include <time.h> 

#include "aux_time.h"






static int mdays365[] = {0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
static int mdays366[] = {0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};


/***************************************************************
 *
 * Procedure aux_get_timezone
 *
 ***************************************************************/

int aux_get_timezone()
{
	struct tm      *time;
	int 		hourlocal, hourgmt;
	int 		daylocal, daygmt;
	time_t 		time0 = 0;
	static int	timezone = 1000;

	if(timezone != 1000) return(timezone);

	time = localtime(&time0);
	hourlocal = time->tm_hour;
	daylocal = time->tm_yday;

	time = gmtime(&time0);
	hourgmt = time->tm_hour;
	daygmt = time->tm_yday;

	if(daylocal == daygmt) return(hourlocal - hourgmt);
	else if(daylocal > daygmt && daylocal) return(24 + hourlocal - hourgmt);
	else  return(hourlocal - (hourgmt + 24));
}
/***************************************************************
 *
 * Procedure aux_check_UTCTime
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_check_UTCTime(UTCTime *utc)

#else

RC aux_check_UTCTime(utc)
UTCTime *utc;

#endif
{
	time_t  seconds;
	char	c;
	int	zh;
	int	zm;
	int	days;
	int	year, mon, day, hour, minu, sec, zone;

	if(!utc) return(-1);

	if ( sscanf(utc, "%02d%02d%02d%02d%02d",
	    &year,
	    &mon ,
	    &day ,
	    &hour,
	    &minu ) != 5 )
		return (-1);
	utc += 10;

	if ( (*utc == '+') || (*utc == '-') ) sec = 0;
	else {
		if ( sscanf(utc, "%02d", &sec) < 1 ) sec = 0;
		else utc += 2;
	}

	c = *utc++;
	if ( c == 'Z' ) zone = 0;
	else if ( c == '+' || c == '-' ) {
		if ( sscanf(utc, "%02d%02d", &zh, &zm) < 2 ) 
			return (-1);
		utc += 4;

		zone = zh * 60 + zm;

		if ( c == '-' ) zone = -zone;
	} 
	else return (-1);

	if(sec >= 60) return(-1);
	if(sec < 0) return(-1);
	if(minu >= 60) return(-1);
	if(minu < 0) return(-1);
	if(hour >= 24) return(-1);
	if(hour < 0) return(-1);
	if(mon >= 13) return(-1);
	if(mon <= 0) return(-1);

	if(day <= 0) return(-1);

	if((((year % 4 == 0) && (year % 100)) || (year % 400 == 0))) {
		if(day > mdays366[mon] - mdays366[mon-1]) return(-1);
	}
	else {
		if(day > mdays365[mon] - mdays365[mon-1]) return(-1);
	}


	return(0);

}
/***************************************************************
 *
 * Procedure aux_UTCTime2time_t
 *
 ***************************************************************/
#ifdef __STDC__

time_t aux_UTCTime2time_t(UTCTime *utc)

#else

time_t aux_UTCTime2time_t(utc)
UTCTime *utc;

#endif
{
	time_t  seconds;
	char	c;
	int	zh;
	int	zm;
	int	days;
	int	year, mon, day, hour, minu, sec, zone;
	char   *proc = "aux_UTCTime2time_t";

	if(!utc) return(time(0));

	if(aux_check_UTCTime(utc) < 0) {
		aux_add_error(EINVALID, "Wrong UTCTime", utc, char_n, proc);
		return(0);
	}

	if ( sscanf(utc, "%02d%02d%02d%02d%02d",
	    &year,
	    &mon ,
	    &day ,
	    &hour,
	    &minu ) != 5 )
		return (  0);
	utc += 10;

	if ( (*utc == '+') || (*utc == '-') ) sec = 0;
	else {
		if ( sscanf(utc, "%02d", &sec) < 1 ) sec = 0;
		else utc += 2;
	}

	c = *utc++;
	if ( c == 'Z' ) zone = 0;
	else if ( c == '+' || c == '-' ) {
		if ( sscanf(utc, "%02d%02d", &zh, &zm) < 2 ) 
			return (  0);
		utc += 4;

		zone = zh * 60 + zm;

		if ( c == '-' ) zone = -zone;
	} 
	else return (  0);


	year--;

	if(year < 79) year += 2000;
	else year += 1900;

	days = 365 * year;

	days += year / 4;

	days -= (year-1600) / 100;

	days += (year-1600) / 400;

	year ++;

	if((((year % 4 == 0) && (year % 100)) || (year % 400 == 0))) days += mdays366[mon-1];
	else days += mdays365[mon-1];

	days += day - 1;



	days -= 1969*365 + 1969/4 - (1969-1600) / 100 + (1969-1600) / 400;


	seconds = ((days*24 + hour)*60 + minu + zone)*60 + sec;

	return(seconds);

}
/***************************************************************
 *
 * Procedure aux_time_t2UTCTime
 *
 ***************************************************************/
#ifdef __STDC__

UTCTime *aux_time_t2UTCTime(time_t seconds)

#else

UTCTime *aux_time_t2UTCTime(seconds)
time_t  seconds;

#endif
{
	int	days;
	int	year, mon, day, hour, minu, sec, zone;
	char   *utc, *proc = "aux_time_t2UTCTime";

	utc = (UTCTime * ) malloc(TX_MAXLEN + 1);
	if ( !utc )   {
		aux_add_error(EMALLOC, "utc", CNULL, 0, proc);
		return (CNULL);
	}

	sec = seconds % 60;
	seconds /= 60;

	minu = seconds % 60;
	seconds /= 60;

	hour = seconds % 24;
	days = seconds / 24;


	if(days >= 10957) {
		days -= 10957;
		year = 2000;
		year += 400 * (days / 146097);
		days %= 146097;
		year += 100 * (days / 36524);
		days %= 36524;
		year += 4 * (days / 1461);
		days %= 1461;
		if(days >= 366) {
			days -= 366;
			year++;
			if(days >= 365) {
				days -= 365;
				year++;
				if(days >= 365) {
					days -= 365;
					year++;
				}
			}
		}

	}
	else {
		year = 1970 + 4 * (days / 1461);
		days %= 1461;
		if(days >= 365) {
			days -= 365;
			year++;
			if(days >= 365) {
				days -= 365;
				year++;
				if(days >= 366) {
					days -= 366;
					year++;
				}
			}
		}
	}
	
	mon = 1;
	if((((year % 4 == 0) && (year % 100)) || (year % 400 == 0))) {

		while(mdays366[mon] <= days) mon++;
		day = 1 + days - mdays366[mon-1];
	}
	else {

		while(mdays365[mon] <= days) mon++;
		day = 1 + days - mdays365[mon-1];
	}


	sprintf(utc, "%02d%02d%02d%02d%02d%02dZ",
	    year % 100,
	    mon,
	    day,
	    hour,
	    minu,
	    sec );

	return(utc);

}





/***************************************************************
 *
 * Procedure aux_current_UTCTime
 *
 ***************************************************************/
UTCTime *aux_current_UTCTime(
)
{

	return(aux_time_t2UTCTime(time(0)));
}


/***************************************************************
 *
 * Procedure aux_readable_UTCTime
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_readable_UTCTime(
	UTCTime	 *utc
)

#else

char *aux_readable_UTCTime(
	utc
)
UTCTime	 *utc;

#endif

{
        struct tm   * tm;
        time_t        gmt;
	char	    * text;
	char	    * proc = "aux_readable_UTCTime";

	if (!(text = (char * ) malloc(64)))  {
		aux_add_error(EMALLOC, "text", CNULL, 0, proc);
		return (CNULL);
	}


        gmt = aux_UTCTime2time_t(utc);
	if(!gmt) return(CNULL);

        tm = localtime(&gmt);

        sprintf(text, "%s", asctime(tm));
	text[strlen(text) - 1] = '\0';  /* eliminate trailing \n */

	return(text);

}


/***************************************************************
 *
 * Procedure aux_delta_UTCTime
 *
 ***************************************************************/
#ifdef __STDC__

UTCTime *aux_delta_UTCTime(
	UTCTime	 *time,
	time_t    delta

)

#else

UTCTime *aux_delta_UTCTime(
	time,
	delta
)
UTCTime	 *time;
time_t    delta;
#endif

{
	char	* utc;
	int	  gmt;
	char	* proc = "aux_delta_UTCTime";



	if(delta) {
		gmt = aux_UTCTime2time_t(time) + delta;
		if(!(utc = aux_time_t2UTCTime(gmt)))   {
			AUX_ADD_ERROR;
			return (CNULL);
		}

	}
	else {
		if(!(utc = aux_cpy_String(time)))   {
			AUX_ADD_ERROR;
			return (CNULL);
		}


		utc[1]++;
		if(utc[1] > '9') {
			utc[1] = '0';
			utc[0]++;
			if(utc[0] > '9') utc[0] = '0';
		}
		if(!strncmp(utc+2, "0229", 4)) utc[5] = '8';
	}

	return utc;
}
/***************************************************************
 *
 * Procedure aux_delta_UTCTime_T_REC
 *
 ***************************************************************/
#ifdef __STDC__

UTCTime *aux_delta_UTCTime_T_REC(
	UTCTime	 *time,
	T_REC    *delta

)

#else

UTCTime *aux_delta_UTCTime_T_REC(
	time,
	delta
)
UTCTime	 *time;
T_REC    *delta;
#endif

{
	return(aux_delta_UTCTime(time, delta->year * T_1YEAR + delta->mon * T_1MONTH + delta->day * T_1DAY +
				delta->hour * T_1HOUR + delta->minu * T_1MIN + delta->sec * T_1SEC ));
}

/***************************************************************
 *
 * Procedure aux_T_REC2UTCTime
 *
 ***************************************************************/
#ifdef __STDC__

UTCTime *aux_T_REC2UTCTime(
	T_REC    *tr

)

#else

UTCTime *aux_T_REC2UTCTime(
	tr
)
T_REC    *tr;
#endif

{
	UTCTime *utc;
	char    *zone_fmt;
	int	 zone;

	utc = (UTCTime * ) malloc(TX_MAXLEN + 1);
	if ( !utc )   {
		aux_add_error(EMALLOC, "utc", CNULL, 0, proc);
		return (CNULL);
	}

	sprintf(utc, "%02d%02d%02d%02d%02d%02d",
	    tr->year % 100,
	    tr->mon,
	    tr->day,
	    tr->hour,
	    tr->minu,
	    tr->sec );

	if ( (zone = tr->zone) == 0 ) zone_fmt = "Z";

	else if ( zone > 0 ) zone_fmt = "+%02d%02d";

	else zone_fmt = "-%02d%02d", zone = -zone;

	sprintf(utc + 12, zone_fmt, zone / 60, zone % 60 );

	if(aux_check_UTCTime(utc) < 0) {
		aux_add_error(EINVALID, "T_REC converted to wrong UTCTime", utc, char_n, proc);
		free(utc);
		return(CNULL);
	}
	return( utc );
}

/***************************************************************
 *
 * Procedure aux_interval_UTCTime
 *
 ***************************************************************/
#ifdef __STDC__

int aux_interval_UTCTime(
	UTCTime	 *time,
	UTCTime	 *notbefore,
	UTCTime	 *notafter
)

#else

int aux_interval_UTCTime(
	time,
	notbefore,
	notafter
)
UTCTime	 *time;
UTCTime	 *notbefore;
UTCTime	 *notafter;

#endif

{
	time_t	ibefore, iafter, inow;

	inow = aux_UTCTime2time_t(time);
	if (!inow) return - 1;

	
	if (!notbefore) return - 1;
	ibefore = aux_UTCTime2time_t(notbefore);
	if (!ibefore) return - 1;

	if (!notafter) return - 1;
	iafter = aux_UTCTime2time_t(notafter);
	if (!iafter) return - 1;

	if(inow < ibefore) return(1);
	if(inow > iafter) return(2);
	return(0);
}

/***************************************************************
 *
 * Procedure aux_interval2_UTCTime
 * 19/9/94	sabisch
 * like aux_interval2_UTCTime with additional check notbefore < notafter
 *
 ***************************************************************/
#ifdef __STDC__

int aux_interval2_UTCTime(
	UTCTime	 *time,
	UTCTime	 *notbefore,
	UTCTime	 *notafter
)

#else

int aux_interval2_UTCTime(
	time,
	notbefore,
	notafter
)
UTCTime	 *time;
UTCTime	 *notbefore;
UTCTime	 *notafter;

#endif

{
	time_t	ibefore, iafter, inow;

	inow = aux_UTCTime2time_t(time);
	if (!inow) return - 1;

	
	if (!notbefore) return - 1;
	ibefore = aux_UTCTime2time_t(notbefore);
	if (!ibefore) return - 1;

	if (!notafter) return - 1;
	iafter = aux_UTCTime2time_t(notafter);
	if (!iafter) return - 1;

	if(iafter < ibefore) return(3);
	if(inow < ibefore) return(1);
	if(inow > iafter) return(2);
	return(0);
}


/***************************************************************
 *
 * Procedure aux_cmp_UTCTime
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_UTCTime(
	UTCTime	 *time1,
	UTCTime	 *time2
)

#else

int aux_cmp_UTCTime(
	time1,
	time2
)
UTCTime	 *time1;
UTCTime	 *time2;

#endif

{
	time_t	inext, inow;

	inow = aux_UTCTime2time_t(time1);
	if (!inow) return - 1;

	if (!time2) return - 1;
	inext = aux_UTCTime2time_t(time2);
	if (!inext) return - 1;


	if(inow > inext) return(1);
	if(inow < inext) return(2);
        return(0);
}


