/* ./src/aux/aux_util.c */

static char *rcsid = "$Id: aux_util.c,v 1.10 1995/01/11 15:04:26 surkau Exp $";

/* 
 *
 * $Id: aux_util.c,v 1.10 1995/01/11 15:04:26 surkau Exp $
 *
 * $Log: aux_util.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#ifdef MAC
#include <stdio.h>
#include <stdlib.h>        /* wg. malloc() */
#include <ctype.h>         /* wg. isalnum() */
#include <string.h>        /* wg. strlen()... */
#include "Mac.h"
#include "pem.h"
#else
#include <stdio.h>
#include "pem.h"
#include "cadb.h"
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include "aux_time.h"

#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif



#ifdef __STDC__
	static char	*error_addr_cpy	(char *addr, Struct_No addrtype);
	static int	aux_tlexequ	(register char *a, register char *b);
#else
	static char	*error_addr_cpy	();
	static int	aux_tlexequ	();
#endif



/***************************************************************
 *
 * Procedure aux_oid2syntaxoid
 *
 ***************************************************************/
#ifdef __STDC__

ObjId *aux_oid2syntaxoid(
	ObjId	 *given_objid
)

#else

ObjId *aux_oid2syntaxoid(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AttrList *a = &attrlist[0];
	char	*proc = "aux_oid2syntaxoid";

	if (!given_objid)
		return((ObjId * )0);
	while (a->abbrev) {
		if (!aux_cmp_ObjId(given_objid, a->objid))
			return(aux_cpy_ObjId(a->syntax_oid));
		a++;
	}
	return((ObjId * )0);
}




/***************************************************************
 *
 * Procedure PSEobj
 *
 ***************************************************************/
#ifdef __STDC__

Key *PSEobj(
	char		 *name
)

#else

Key *PSEobj(
	name
)
char		 *name;

#endif

{
	static Key key;
	static PSESel psesel;

	psesel.app_name = AF_pse.app_name;
	psesel.pin = AF_pse.pin;
	psesel.object.name = name;
	key.key = (KeyInfo *)0;
	key.keyref = 0;
	key.pse_sel = &psesel;
	key.alg = (AlgId *)0;;
	return(&key);
}


/***************************************************************
 *
 * Procedure error_addr_cpy
 *
 ***************************************************************/
#ifdef __STDC__

static char *error_addr_cpy(
	char		 *addr,
	Struct_No	  addrtype
)

#else

static char *error_addr_cpy(
	addr,
	addrtype
)
char		 *addr;
Struct_No	  addrtype;

#endif

{

	PSESel *dd;

	if (!addr) return((char *)0);

	switch (addrtype) {
	case char_n:
		return((char *)aux_cpy_Name(addr));
	case int_n:
		return(addr);
	case DName_n:
		return((char *)aux_cpy_DName((DName *)addr));
	case Certificate_n:
		return((char *)aux_cpy_Certificate((Certificate *)addr));
	case CertificatePair_n:
		return((char *)aux_cpy_CertificatePair((CertificatePair *)addr));
	case Certificates_n:
		return((char *)aux_cpy_Certificates((Certificates *)addr));
	case PKList_n:
		return((char *)aux_cpy_PKList((PKList *)addr));
	case OctetString_n:
		return((char *)aux_cpy_OctetString((OctetString *)addr));
	case BitString_n:
		return((char *)aux_cpy_BitString((BitString *)addr));
	case SET_OF_Certificate_n:
		return((char *)aux_cpy_SET_OF_Certificate((SET_OF_Certificate *)addr));
	case SET_OF_CertificatePair_n:
		return((char *)aux_cpy_SET_OF_CertificatePair((SET_OF_CertificatePair *)addr));
	case AlgId_n:
		return((char *)aux_cpy_AlgId((AlgId *)addr));
	case OCList_n:
		return((char *)aux_cpy_OCList((OCList *)addr));
	case CRLTBS_n:
		return((char *)aux_cpy_CRLTBS((CRLTBS *)addr));
	case CRL_n:
		return((char *)aux_cpy_CRL((CRL *)addr));
	case CRLEntry_n:
		return((char *)aux_cpy_CRLEntry((CRLEntry *)addr));
	case CrlSet_n:
		return((char *)aux_cpy_CrlSet((CrlSet *)addr));
	case Crl_n:
		return((char *)aux_cpy_Crl ((Crl *)addr));
	case KeyInfo_n:
		return((char *)aux_cpy_KeyInfo((KeyInfo *)addr));
	case FCPath_n:
		return((char *)aux_cpy_FCPath((FCPath *)addr));
	case PKRoot_n:
		return((char *)aux_cpy_PKRoot((PKRoot *)addr));
	case IssuedCertificate_n:
		return((char *)aux_cpy_IssuedCertificate((IssuedCertificate *)addr));
	case SET_OF_IssuedCertificate_n:
		return((char *)aux_cpy_SET_OF_IssuedCertificate((SET_OF_IssuedCertificate *)addr));
	case SET_OF_Name_n:
		return((char *)aux_cpy_SET_OF_Name((SET_OF_Name *)addr));
	case ToBeSigned_n:
		return((char *)aux_cpy_ToBeSigned((ToBeSigned *)addr));
	case ObjId_n:
		return((char *)aux_cpy_ObjId((ObjId *)addr));
	case KeyBits_n:
		return((char *)aux_cpy_KeyBits((KeyBits *)addr));
	case PSEToc_n:
		return((char *)aux_cpy_PSEToc((PSEToc *)addr));
	case PSESel_n:
		dd = aux_cpy_PSESel((PSESel *)addr);
		if(dd->pin) strzfree(&(dd->pin));
		if(dd->object.pin) strzfree(&(dd->object.pin));
		return((char *)dd);
	}
	return((char *)0);

}

/***************************************************************
 *
 * Procedure aux_set_extension
 *
 ***************************************************************/
#ifdef __STDC__

int	 aux_set_extension(
	char	 *name,
	char	 *extension
)

#else

int	 aux_set_extension(
	name,
	extension
)
char	 *name;
char	 *extension;

#endif

{
#ifdef MS_DOS
	int n;
	for(n = 0; n < 8 && n < strlen(name) && name[n] != '.'; n++) ;
	strcpy(name + n, extension);
	if(strlen(extension) > 4) name[n+4] = '\0';
#else
	strcat(name, extension);
#endif
}
/***************************************************************
 *
 * Procedure aux_cat_paths
 *
 ***************************************************************/
#ifdef __STDC__

char	 *aux_cat_paths(
	char	 *first,
	char	 *second
)

#else

char	 *aux_cat_paths(
	first,
	second
)
char	 *first;
char	 *second;

#endif

{
	char disc[3];
	int l1, l2;
	char *ret;

	if(!second || !(l2 = strlen(second))) return(aux_cpy_String(first));
	if(!first || !(l1 = strlen(first))) return(aux_cpy_String(second));



#ifdef MS_DOS
	disc[0] = '\0';
	disc[1] = ':';
	disc[2] = '\0';

	if(second[1] == ':') {
		*disc = *second;
		second += 2;
		l2 -= 2;
	}
	else if(first[1] == ':') {
		*disc = *first;
		first += 2;
		l1 -= 2;
	}
	if(*second == PATH_SEPARATION_CHAR) {

		if(!(ret = malloc(strlen(second) + 3))) {
			aux_add_error(EMALLOC, "ret", CNULL, 0, proc);
			return(CNULL);
		}
		strcpy(ret, disc);
		strcat(ret, second);
		return(ret);
	}
	if(first[l1-1] == PATH_SEPARATION_CHAR)  {

		if(!(ret = malloc(strlen(second) + strlen(first) + 3))) {
			aux_add_error(EMALLOC, "ret", CNULL, 0, proc);
			return(CNULL);
		}
		strcpy(ret, disc);
		strcat(ret, first);
		strcat(ret, second);
		return(ret);
	}
	else  {

		if(!(ret = malloc(strlen(second) + strlen(first) + 4))) {
			aux_add_error(EMALLOC, "ret", CNULL, 0, proc);
			return(CNULL);
		}
		strcpy(ret, disc);
		strcat(ret, first);
		strcat(ret, PATH_SEPARATION_STRING);
		strcat(ret, second);
		return(ret);
	}
#else
	if(*second == PATH_SEPARATION_CHAR) {

		if(!(ret = malloc(strlen(second) + 1))) {
			aux_add_error(EMALLOC, "ret", CNULL, 0, proc);
			return(CNULL);
		}
		strcpy(ret, second);
		return(ret);
	}

	if(first[l1-1] == PATH_SEPARATION_CHAR)  {

		if(!(ret = malloc(strlen(second) + strlen(first) + 1))) {
			aux_add_error(EMALLOC, "ret", CNULL, 0, proc);
			return(CNULL);
		}
		strcpy(ret, first);
		strcat(ret, second);
		return(ret);
	}
	else  {

		if(!(ret = malloc(strlen(second) + strlen(first) + 2))) {
			aux_add_error(EMALLOC, "ret", CNULL, 0, proc);
			return(CNULL);
		}
		strcpy(ret, first);
		strcat(ret, PATH_SEPARATION_STRING);
		strcat(ret, second);
		return(ret);
	}
#endif

}
/***************************************************************
 *
 * Procedure aux_set_pse
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_set_pse(
	char	 *psename,
	char	 *cadir
)

#else

RC aux_set_pse(
	psename,
	cadir
)
char	 *psename;
char	 *cadir;

#endif

{
	char *psepath, *pin;

	if (!psename) {
		if(cadir) {
			psename = getenv("CAPSE");
			if(!psename) psename = DEF_CAPSE;
		}
		else {
			psename = getenv("PSE");
			if(!psename) psename = DEF_PSE;
		}
	}

	if (cadir) {
		if(!(psepath = aux_cat_paths(cadir, psename))) {
			AUX_ADD_ERROR;
			return(-1);
		}
	} else {
		if(!(psepath = aux_cpy_String(psename))) {
			AUX_ADD_ERROR;
			return(-1);
		}
	}

	if (cadir)
		pin = getenv("CAPIN");
        else
		pin = getenv("USERPIN");

	if (aux_create_AFPSESel(psepath, pin) < 0) return(-1);
	free(psepath);
	return(0);
}


/***************************************************************
 *
 * Procedure aux_create_AFPSESel
 *
 ***************************************************************/
#ifdef __STDC__

int aux_create_AFPSESel(
	char	 *appname,
	char	 *pin
)

#else

int aux_create_AFPSESel(
	appname,
	pin
)
char	 *appname;
char	 *pin;

#endif

{
	int 	   i, pinlen;
	char	 * proc = "aux_create_AFPSESel";


	if (!appname) return - 1;

	AF_pse.app_name = aux_cpy_String(appname);

	if (!pin) {
		AF_pse.pin = CNULL;
		for (i = 0; i < PSE_MAXOBJ; i++) AF_pse.object[i].pin = CNULL;
		return 0;
	}

	AF_pse.pin = aux_cpy_String(pin);

/*	for (i = 0; i < PSE_MAXOBJ; i++) AF_pse.object[i].pin = aux_cpy_String(pin); */
	for (i = 0; i < PSE_MAXOBJ; i++) AF_pse.object[i].pin = CNULL;

	return 0;
}


/***************************************************************
 *
 * Procedure aux_fgets
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_fgets(
	char 		 *prompt,
	char 		 *answ,
	int		  answ_len,
	FILE		 *out,
	FILE		 *in
)

#else

char *aux_fgets(
	prompt,
	answ,
	answ_len,
	out,
	in
)
char		 *prompt;
char		 *answ;
int		  answ_len;
FILE		 *out;
FILE		 *in;
#endif
{
	if(answ_len < 2) return((char *)0);
	if(prompt) fprintf(out, prompt);
	if(prompt) fflush(out);
	if(!answ ) answ = malloc(answ_len);
	if(fgets(answ, answ_len, in)) {
		if(answ[strlen(answ) - 1] == '\n') answ[strlen(answ) - 1] = '\0';
		return(answ);
	}
	else return((char *)0);
} 

/***************************************************************
 *
 * Procedure aux_add_error
 *
 ***************************************************************/
#ifdef __STDC__

void aux_add_error(
	int		  number,
	char		 *text,
	char		 *addr,
	Struct_No	  addrtype,
	char		 *proc
)

#else

void aux_add_error(
	number,
	text,
	addr,
	addrtype,
	proc
)
int		  number;
char		 *text;
char		 *addr;
Struct_No	  addrtype;
char		 *proc;

#endif

{
	struct ErrStack  * err;
	char		 * local_proc = "aux_add_error";


        if(err_stack == &err_malloc) return; /* malloc failed already, can't do much */

	err = (struct ErrStack *) malloc(sizeof(struct ErrStack ));

	if (err && number != EMALLOC) {
		err->e_is_error = TRUE;
		err->e_number   = number;
		err->e_text     = aux_cpy_String(text);
		err->e_addr     = error_addr_cpy(addr, addrtype);
		err->e_addrtype = addrtype;
		err->e_proc     = proc;
		err->next       = err_stack;
		err_stack = err;
	} 
	else {
		err_malloc.e_is_error = TRUE;
		err_malloc.e_number   = number;
		err_malloc.e_text     = text;
		err_malloc.e_addr     = CNULL;
		err_malloc.e_addrtype = addrtype;
		err_malloc.e_proc     = proc;
		err_malloc.next       = err_stack;
		err_stack = &err_malloc;
	}
        return;
}
/***************************************************************
 *
 * Procedure aux_add_warning
 *
 ***************************************************************/
#ifdef __STDC__

void aux_add_warning(
	int		  number,
	char		 *text,
	char		 *addr,
	Struct_No	  addrtype,
	char		 *proc
)

#else

void aux_add_warning(
	number,
	text,
	addr,
	addrtype,
	proc
)
int		  number;
char		 *text;
char		 *addr;
Struct_No	  addrtype;
char		 *proc;

#endif

{
	struct ErrStack  * err;
	char		 * local_proc = "aux_add_warning";


        if(err_stack == &err_malloc) return; /* malloc failed already, can't do much */

	err = (struct ErrStack *) malloc(sizeof(struct ErrStack ));

	if (err && number != EMALLOC) {
		err->e_number   = number;
		err->e_text     = text;
		err->e_addr     = error_addr_cpy(addr, addrtype);
		err->e_addrtype = addrtype;
		err->e_proc     = proc;
		err->next       = err_stack;
		err_stack = err;
	} else {
		err_malloc.e_number   = number;
		err_malloc.e_text     = text;
		err_malloc.e_addr     = CNULL;
		err_malloc.e_addrtype = addrtype;
		err_malloc.e_proc     = proc;
		err_malloc.next       = err_stack;
		err_stack = &err_malloc;
	}

	for(err = err_stack; err; err = err->next) err->e_is_error = FALSE;

        return;
}

/***************************************************************
 *
 * Procedure aux_last_error
 *
 ***************************************************************/
#ifdef __STDC__

int aux_last_error(
)

#else

int aux_last_error(
)

#endif
{

	if(err_stack) return(err_stack->e_number);
	else return(0);
}


/***************************************************************
 *
 * Procedure aux_cpy_PSESel
 *
 ***************************************************************/
#ifdef __STDC__

PSESel *aux_cpy_PSESel(
	PSESel	 *psesel
)

#else

PSESel *aux_cpy_PSESel(
	psesel
)
PSESel	 *psesel;

#endif

{
	PSESel  * dup_psesel;
	char	* proc = "aux_cpy_PSESel";

	if(!psesel) return((PSESel *)0);

	if ( (dup_psesel = (PSESel * )calloc(1, sizeof(PSESel))) == (PSESel * )0 ) {
		aux_add_error(EMALLOC, "dup_PSESel", CNULL, 0, proc);
		return( (PSESel * )0 );
	}

	dup_psesel->app_name = aux_cpy_String(psesel->app_name);
	dup_psesel->pin = aux_cpy_String(psesel->pin);
	dup_psesel->object.name = aux_cpy_String(psesel->object.name);
	dup_psesel->object.pin = aux_cpy_String(psesel->object.pin);
	dup_psesel->app_id = psesel->app_id;
	return(dup_psesel);
}



/***************************************************************
 *
 * Procedure aux_cpy2_DigestInfo
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_DigestInfo(
	DigestInfo	 *dup_dig,
	DigestInfo	 *dig
)

#else

int aux_cpy2_DigestInfo(
	dup_dig,
	dig
)
DigestInfo	 *dup_dig;
DigestInfo	 *dig;

#endif

{
	char	* proc = "aux_cpy2_DigestInfo";


	if ( (dig == (DigestInfo * )0) || (dup_dig == (DigestInfo * )0) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_dig->digestAI = aux_cpy_AlgId(dig->digestAI);
	if (!dup_dig->digestAI) {
		aux_add_error(LASTERROR, "aux_cpy_AlgId failed", CNULL, 0, proc);
		return(-1);
	}
	if (aux_cpy2_OctetString(&dup_dig->digest, &dig->digest)) {
		aux_add_error(LASTERROR, "aux_cpy2_OctetString failed", CNULL, 0, proc);
		return( -1 );
	}
	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cpy_DigestInfo
 *
 ***************************************************************/
#ifdef __STDC__

DigestInfo *aux_cpy_DigestInfo(
	DigestInfo	 *dig
)

#else

DigestInfo *aux_cpy_DigestInfo(
	dig
)
DigestInfo	 *dig;

#endif

{
	DigestInfo  * dup_dig;
	char	   * proc = "aux_cpy_DigestInfo";


	if ((dig == (DigestInfo * )0))
		return( (DigestInfo * )0);
	if ((dup_dig = (DigestInfo * )malloc(sizeof(DigestInfo))) == (DigestInfo * )0 ) {
		aux_add_error(EMALLOC, "dup_dig", CNULL, 0, proc);
		return((DigestInfo * )0);
	}
	if (aux_cpy2_DigestInfo (dup_dig, dig)) {
		aux_add_error(LASTERROR, "aux_cpy2_DigestInfo failed", CNULL, 0, proc);
		return( (DigestInfo * )0 );
	}
	return(dup_dig);
}


/***************************************************************
 *
 * Procedure aux_cpy2_EncryptedKey
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_EncryptedKey(
	EncryptedKey	 *dup_enki,
	EncryptedKey	 *enki
)

#else

int aux_cpy2_EncryptedKey(
	dup_enki,
	enki
)
EncryptedKey	 *dup_enki;
EncryptedKey	 *enki;

#endif

{
	char	* proc = "aux_cpy2_EncryptedKey";


	if ( (enki == (EncryptedKey * )0) || (dup_enki == (EncryptedKey * )0) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_enki->encryptionAI = aux_cpy_AlgId(enki->encryptionAI);
	if (!dup_enki->encryptionAI) {
		aux_add_error(LASTERROR, "aux_cpy_AlgId failed", CNULL, 0, proc);
		return(-1);
	}

	dup_enki->subjectAI = aux_cpy_AlgId(enki->subjectAI);
	if (!dup_enki->subjectAI) {
		aux_add_error(LASTERROR, "aux_cpy_AlgId failed", CNULL, 0, proc);
		return(-1);
	}

	if (aux_cpy2_BitString(&dup_enki->subjectkey, &enki->subjectkey)) {
		aux_add_error(LASTERROR, "aux_cpy2_BitString failed", CNULL, 0, proc);
		return( -1 );
	}
	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cpy_EncryptedKey
 *
 ***************************************************************/
#ifdef __STDC__

EncryptedKey *aux_cpy_EncryptedKey(
	EncryptedKey	 *enki
)

#else

EncryptedKey *aux_cpy_EncryptedKey(
	enki
)
EncryptedKey	 *enki;

#endif

{
	EncryptedKey  * dup_enki;
	char	      * proc = "aux_cpy_EncryptedKey";


	if ((enki == (EncryptedKey * )0))
		return( (EncryptedKey * )0);
	if ((dup_enki = (EncryptedKey * )malloc(sizeof(EncryptedKey))) == (EncryptedKey * )0 ) {
		aux_add_error(EMALLOC, "dup_enki", CNULL, 0, proc);
		return((EncryptedKey * )0);
	}
	if (aux_cpy2_EncryptedKey (dup_enki, enki)) {
		aux_add_error(LASTERROR, "aux_cpy2_EncryptedKey failed", CNULL, 0, proc);
		return( (EncryptedKey * )0 );
	}
	return(dup_enki);
}


/***************************************************************
 *
 * Procedure aux_cpy_Validity
 *
 ***************************************************************/
#ifdef __STDC__

Validity *aux_cpy_Validity(
	Validity	 *valid
)

#else

Validity *aux_cpy_Validity(
	valid
)
Validity	 *valid;

#endif

{
	Validity   * dup_valid;
	char	   * proc = "aux_cpy_Validity";


	if (! valid)
		return ( (Validity * )0 );

	if ( !(dup_valid = (Validity * )malloc(sizeof(Validity))) ) {
		aux_add_error(EMALLOC, "dup_valid", CNULL, 0, proc);
		return ( (Validity * )0 );
	}

	dup_valid->notbefore = aux_cpy_String(valid->notbefore);
	dup_valid->notafter = aux_cpy_String(valid->notafter);

	return (dup_valid);
}





/***************************************************************
 *
 * Procedure aux_cmp_KeyInfo
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_KeyInfo(
	KeyInfo	 *keyinfo1,
	KeyInfo	 *keyinfo2
)

#else

int aux_cmp_KeyInfo(
	keyinfo1,
	keyinfo2
)
KeyInfo	 *keyinfo1;
KeyInfo	 *keyinfo2;

#endif

{
	char	* proc = "aux_cmp_KeyInfo";

	if ( !keyinfo1 && !keyinfo2 )
		return( 0) ;
	if ( !keyinfo1 || !keyinfo2 )
		return( 1) ;

	if ( !aux_cmp_AlgId(keyinfo1->subjectAI, keyinfo2->subjectAI) ) {
		return( aux_cmp_BitString(&keyinfo1->subjectkey, &keyinfo2->subjectkey) );
	} else
		return( 1 );
}




/***************************************************************
 *
 * Procedure aux_cmp_Signature
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_Signature(
	Signature	 *sig1,
	Signature	 *sig2
)

#else

int aux_cmp_Signature(
	sig1,
	sig2
)
Signature	 *sig1;
Signature	 *sig2;

#endif

{
	char	* proc = "aux_cmp_Signature";

	if ( !sig1 && !sig2 )
		return( 0) ;
	if ( !sig1 || !sig2 )
		return( 1) ;

	if ( !aux_cmp_AlgId(sig1->signAI, sig2->signAI) ) {
		return( aux_cmp_BitString(&sig1->signature, &sig2->signature) );
	} else
		return( 1 );
}


/***************************************************************
 *
 * Procedure aux_ObjId2PSEObjectName
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_ObjId2PSEObjectName(
	ObjId	 *given_objid
)

#else

char *aux_ObjId2PSEObjectName(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register int   i;
	char	     * proc = "aux_ObjId2PSEObjectName";

	if (!given_objid) return((char *)0);

	for(i = 0; i < PSE_MAXOBJ; i++) {
		if (!aux_cmp_ObjId(given_objid, AF_pse.object[i].oid))
			return(aux_cpy_Name(AF_pse.object[i].name));
	}
	return((char *)0);
}

/***************************************************************
 *
 * Procedure aux_PSEObjectName2ObjId
 *
 ***************************************************************/
#ifdef __STDC__

ObjId *aux_PSEObjectName2ObjId(
	char	 *name
)

#else

ObjId *aux_PSEObjectName2ObjId(
	name
)
char	 *name;

#endif

{
	register int   i;
	char	     * proc = "aux_PSEObjectName2ObjId";

	if (!name) return((ObjId * )0);
	for(i = 0; i < PSE_MAXOBJ; i++) {
		if (!strcmp(name, AF_pse.object[i].name))
			return(aux_cpy_ObjId(AF_pse.object[i].oid));
	}
	return((ObjId * )0);
}


/***************************************************************
 *
 * Procedure aux_cpy_Name
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_cpy_Name(
	char	 *namefrom
)

#else

Name *aux_cpy_Name(
	namefrom
)
char	 *namefrom;

#endif

{
	char	* nameto;
	char	* proc = "aux_cpy_Name";


	if ( ! namefrom )
		return ( (Name *) 0);

	nameto = (char *)malloc(strlen(namefrom) + 1);
	if (!nameto)  {
		aux_add_error(EMALLOC, "nameto", CNULL, 0, proc);
		return(nameto);
	}
	strcpy(nameto, namefrom);
	return(nameto);
}

/***************************************************************
 *
 * Procedure aux_cpy_ReducedString
 *
 ***************************************************************/

/*
 *	cut off blanks at begin and end of string a
 *	return pointer to successfully reduced and allocated string, else NULL
 *	return NULL if string a consists of blanks only
 */

#ifdef __STDC__

char *aux_cpy_ReducedString(
	char	 *a
)

#else

char *aux_cpy_ReducedString(
	a
)
char	 *a;

#endif

{
	register char *aa, *afirst, *alast;

	if (!a || !strcmp(a, "") || !(aa = aux_cpy_String(a)) ) return(CNULL);
	afirst = aa;
	while (afirst)  {
		if (*afirst != ' ') break;
		afirst++;
	}
	if (!*afirst)  {
		if (aa) free(aa);
		return(CNULL);
	}
	alast = aa + strlen(aa);
	while (--alast) if (*alast != ' ') break;
	if (alast < aa) return(aa);
	*(++alast) = '\0';
	strcpy(aa, afirst);
	return(aa);
}
		


/***************************************************************
 *
 * Procedure aux_pstrcmp
 *
 ***************************************************************/
#ifdef __STDC__

int aux_pstrcmp(
	register char	 *a,
	register char	 *b
)

#else

int aux_pstrcmp(
	a,
	b
)
register char	 *a;
register char	 *b;

#endif

{
	while (*a == *b) {
		if (*a++ == 0)
			return (0);
		b++;
	}

	if (*a > *b)
		return (1);
	else
		return (-1);

}


/***************************************************************
 *
 * Procedure aux_tlexequ
 *
 ***************************************************************/
#ifdef __STDC__

static int aux_tlexequ(
	register char	 *a,
	register char	 *b
)

#else

static int aux_tlexequ(
	a,
	b
)
register char	 *a;
register char	 *b;

#endif

{

	while (chrcnv[*a] == chrcnv[*b]) {
		if (*a++ == 0)
			return (0);
		b++;
	}

	if (chrcnv[*a] > chrcnv[*b])
		return (1);
	else
		return (-1);
}


/***************************************************************
 *
 * Procedure aux_lexequ
 *
 ***************************************************************/
#ifdef __STDC__

int aux_lexequ(
	register char	 *str1,
	register char	 *str2
)

#else

int aux_lexequ(
	str1,
	str2
)
register char	 *str1;
register char	 *str2;

#endif

{
	if (!str1)
		if (!str2)
			return (0);
		else
			return (-1);

	if (!str2)
		return (1);

	while (chrcnv[*str1] == chrcnv[*str2]) {
		if (*str1++ == 0)
			return (0);
		str2++;
	}

	if (chrcnv[*str1] > chrcnv[*str2])
		return (1);
	else
		return (-1);
}


/***************************************************************
 *
 * Procedure aux_cmp_Name
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_Name(
	char	 *name1,
	char	 *name2
)

#else

int aux_cmp_Name(
	name1,
	name2
)
char	 *name1;
char	 *name2;

#endif

{
	DName  * dname1, *dname2;
	int	 ret;
	char   * proc = "aux_cmp_Name";


	if ( !name1 && !name2 )
		return( 0) ;
	if ( !name1 || !name2 )
		return( 1) ;

	dname1 = aux_Name2DName(name1);
	dname2 = aux_Name2DName(name2);
	if (!dname1 || !dname2) {
		aux_add_error(LASTERROR, "aux_Name2DName failed", CNULL, 0, proc);
		return(-1);
	}
	ret = aux_cmp_DName(dname1, dname2);
	aux_free2_DName(dname1);
	aux_free2_DName(dname2);

	return(ret);
}


/***************************************************************
 *
 * Procedure RDName_comp_cmp
 *
 ***************************************************************/
#ifdef __STDC__

int RDName_comp_cmp(
	RDName	 *a,
	RDName	 *b
)

#else

int RDName_comp_cmp(
	a,
	b
)
RDName	 *a;
RDName	 *b;

#endif

{
	int	  avlen, ret;
	char	* a_value, * b_value;
	ObjId   * syntax_oid;
	char	* proc = "RDName_comp_cmp";

	if(!aux_cmp_ObjId(a->member_IF_0->element_IF_0, b->member_IF_0->element_IF_0) ) {
		syntax_oid = aux_oid2syntaxoid(a->member_IF_0->element_IF_0);
		a_value = prim2str(a->member_IF_0->element_IF_1, &avlen );
		b_value = prim2str(b->member_IF_0->element_IF_1, &avlen );
		if(!aux_cmp_ObjId(syntax_oid, CountryString)) ret = aux_lexequ(a_value, b_value);
		else if(!aux_cmp_ObjId(syntax_oid, CaseIgnoreString)) ret = aux_tlexequ(a_value, b_value);
		else if(!aux_cmp_ObjId(syntax_oid, PrintableString)) ret = aux_pstrcmp(a_value, b_value);
		else ret = 1;  /*unknown syntax_oid*/
		aux_free_ObjId(&syntax_oid);
		free(a_value);
		free(b_value);
		return(ret);
	} 
	else return(1);
}


/***************************************************************
 *
 * Procedure aux_cmp_RDName
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_RDName(
	register RDName	 *a,
	register RDName	 *b
)

#else

int aux_cmp_RDName(
	a,
	b
)
register RDName	 *a;
register RDName	 *b;

#endif

{
	char	*proc = "aux_cmp_RDName";

	for (; (a != NULLRDNAME) && (b != NULLRDNAME) ; a = a->next, b = b->next) {
		if ( RDName_comp_cmp(a, b) ) return( 1 );
	}

	if ( (a == NULLRDNAME) && (b == NULLRDNAME) )  {
		return( 0 );
	} 
	else return( 1 );
}


/***************************************************************
 *
 * Procedure aux_cmp_DName
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_DName(
	register DName	 *a,
	register DName	 *b
)

#else

int aux_cmp_DName(
	a,
	b
)
register DName	 *a;
register DName	 *b;

#endif

{
	char	*proc = "aux_cmp_DName";

	for (; (a != NULLDNAME) && (b != NULLDNAME) ; a = a->next, b = b->next) {
		if ( aux_cmp_RDName(a->element_IF_2, b->element_IF_2) )
			return( 1 );
	}

	if (( a == NULLDNAME) && (b == NULLDNAME)) {
		return( 0 );
	} else
		return( 1 );
}


/***************************************************************
 *
 * Procedure aux_checkPemDNameSubordination
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_checkPemDNameSubordination(
	DName	 *sup,
	DName	 *sub
)

#else

RC aux_checkPemDNameSubordination(
	sup,
	sub
)
DName	 *sup;
DName	 *sub;

#endif

{
	/* Return Value:
	       -1       error
		0	"sub" is NOT subordinate to "sup"
		1	"sub" is subordinate to "sup"
	*/

	char	*proc = "aux_checkPemDNameSubordination";

	if (! sup || ! sub) {
		aux_add_error(EINVALID, "required parameters NOT provided", CNULL, 0, proc);
		return (- 1);
	}

	for (; (sup != NULLDNAME) && (sub != NULLDNAME) ; sup = sup->next, sub = sub->next) {
		if ( aux_cmp_RDName(sup->element_IF_2, sub->element_IF_2) )
			return (FALSE);
	}

	if ( (sup == NULLDNAME && sub == NULLDNAME) || (sup != NULLDNAME && sub == NULLDNAME) )
		return (FALSE);

	/* sup == NULLDNAME && sub != NULLDNAME */
	return (TRUE);

}

/***************************************************************
 *
 * Procedure aux_PemDNameSubordination
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_PemDNameSubordination(
	DName	 *sup,
	DName	 *sub
)

#else

Name *aux_PemDNameSubordination(
	sup,
	sub
)
DName	 *sup;
DName	 *sub;

#endif

{
	/* Return Value:
	       *Name    subordinated part of sub
		NULL	"sub" is NOT subordinate to "sup"
	*/

	char	*proc = "aux_PemDNameSubordination";

	if (! sup || ! sub) {
		aux_add_error(EINVALID, "required parameters NOT provided", CNULL, 0, proc);
		return ((Name *)0);
	}

	for (; (sup != NULLDNAME) && (sub != NULLDNAME) ; sup = sup->next, sub = sub->next) {
		if ( aux_cmp_RDName(sup->element_IF_2, sub->element_IF_2) )
			return ((Name *)0);
	}

	if ( (sup == NULLDNAME && sub == NULLDNAME) || (sup != NULLDNAME && sub == NULLDNAME) )
		return ((Name *)0);

	/* sup == NULLDNAME && sub != NULLDNAME */
	return (aux_DName2Name(sub));

}
/***************************************************************
 *
 * Procedure aux_PCA
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_PCA(
	VerificationResult	 *vr
)

#else

Name *aux_PCA(
	vr
)
VerificationResult	 *vr;

#endif

{
	int index;
	Name *pca, *pcaalias;

	index = 0;
	while (vr->verifstep &&
	       vr->success == TRUE && vr->verifstep[index]) {
	
		if(vr->verifstep[index+1] && vr->verifstep[index+1]->policy_CA) {
			pca = aux_DName2Name(vr->verifstep[index]->cert->tbs->issuer);
			pcaalias = aux_DName2alias(vr->verifstep[index]->cert->tbs->issuer, LOCALNAME);
			if(pcaalias) {
				free(pca);
				pca = pcaalias;
			}
			return(pca);
		} 
		index++;
	
	}
	return((Name *)0);
}

/***************************************************************
 *
 * Procedure aux_cpy_RDName_comp
 *
 ***************************************************************/
#ifdef __STDC__

RDName *aux_cpy_RDName_comp(
	RDName	 *rdn
)

#else

RDName *aux_cpy_RDName_comp(
	rdn
)
RDName	 *rdn;

#endif

{
	register RDName * ptr;
	char		* proc = "aux_cpy_RDName_comp";


	if (rdn == NULLRDNAME) {
		return (NULLRDNAME);
	}

	ptr = (RDName *)malloc(
	    sizeof(RDName ) );
	if (!ptr) {
		aux_add_error(EMALLOC, "ptr", CNULL, 0, proc);
		return (NULLRDNAME);
	}
	ptr->member_IF_0 = (AttrValueAssertion *)malloc(
	    sizeof(AttrValueAssertion ) );
	if (!ptr->member_IF_0) {
		aux_add_error(EMALLOC, "ptr->member_IF_0", CNULL, 0, proc);
		return (NULLRDNAME);
	}
	ptr->member_IF_0->element_IF_0 = (OIDentifier * )aux_cpy_ObjId(rdn->member_IF_0->element_IF_0);
	if (!ptr->member_IF_0->element_IF_0) {
		aux_add_error(LASTERROR, "aux_cpy_ObjId failed", CNULL, 0, proc);
		return (NULLRDNAME);
	}
	ptr->member_IF_0->element_IF_1 = pe_cpy(rdn->member_IF_0->element_IF_1);
	ptr->next = NULLRDNAME;

	return (ptr);
}


/***************************************************************
 *
 * Procedure aux_cpy_RDName
 *
 ***************************************************************/
#ifdef __STDC__

RDName *aux_cpy_RDName(
	RDName	 *rdn
)

#else

RDName *aux_cpy_RDName(
	rdn
)
RDName	 *rdn;

#endif

{
	RDName * start;
	register RDName *eptr;
	register RDName *ptr, *ptr2;
	char	*proc = "aux_cpy_RDName";

	if (rdn == NULLRDNAME) {
		return (NULLRDNAME);
	}
	start = aux_cpy_RDName_comp (rdn);
	if (!start) {
		aux_add_error(LASTERROR, "aux_cpy_RDName_comp failed", CNULL, 0, proc);
		return (NULLRDNAME);
	}
	ptr2 = start;

	for (eptr = rdn->next; eptr != NULLRDNAME; eptr = eptr->next) {
		ptr = aux_cpy_RDName_comp (eptr);
		if (!ptr) {
			aux_add_error(LASTERROR, "aux_cpy_RDName_comp failed", CNULL, 0, proc);
			return (NULLRDNAME);
		}
		ptr2->next = ptr;
		ptr2 = ptr;
	}
	return (start);
}


/***************************************************************
 *
 * Procedure aux_cpy_DName_comp
 *
 ***************************************************************/
#ifdef __STDC__

DName *aux_cpy_DName_comp(
	register DName	 *dn
)

#else

DName *aux_cpy_DName_comp(
	dn
)
register DName	 *dn;

#endif

{
	register DName  * ptr;
	char		* proc = "aux_cpy_DName_comp";


	if (dn == NULLDNAME) {
		return (NULLDNAME);
	}
	ptr = (DName *)malloc(sizeof(DName ) );
	if (!ptr) {
		aux_add_error(EMALLOC, "", CNULL, 0, proc);
		return (NULLDNAME);
	}
	ptr->element_IF_2 = aux_cpy_RDName (dn->element_IF_2);
	if (!ptr->element_IF_2) {
		aux_add_error(LASTERROR, "aux_cpy_RDName failed", CNULL, 0, proc);
		return (NULLDNAME);
	}
	ptr->next = NULLDNAME;
	return (ptr);
}


/***************************************************************
 *
 * Procedure aux_cpy_DName
 *
 ***************************************************************/
#ifdef __STDC__

DName *aux_cpy_DName(
	register DName	 *dn
)

#else

DName *aux_cpy_DName(
	dn
)
register DName	 *dn;

#endif

{
	DName 	        * start;
	register DName  * eptr, * ptr, * ptr2;
	char		* proc = "aux_cpy_DName";


	if (dn == NULLDNAME) {
		return (NULLDNAME);
	}
	start = aux_cpy_DName_comp (dn);
	if (!start) {
		aux_add_error(LASTERROR, "aux_cpy_DName_comp failed", CNULL, 0, proc);
		return (NULLDNAME);
	}
	ptr2 = start;
	for (eptr = dn->next; eptr != NULLDNAME; eptr = eptr->next) {
		ptr = aux_cpy_DName_comp (eptr);
		if (!ptr) {
			aux_add_error(LASTERROR, "aux_cpy_DName_comp failed", CNULL, 0, proc);
			return (NULLDNAME);
		}
		ptr2->next = ptr;
		ptr2 = ptr;
	}
	return (start);
}


/***************************************************************
 *
 * Procedure aux_cpy2_DName_comp
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_DName_comp(
	DName	 *dup_dname,
	DName	 *dname
)

#else

int aux_cpy2_DName_comp(
	dup_dname,
	dname
)
DName	 *dup_dname;
DName	 *dname;

#endif

{
	char	* proc = "aux_cpy2_DName_comp";


	if ( (dname == (DName * )0) || (dup_dname == (DName * )0)  ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_dname->element_IF_2 = aux_cpy_RDName (dname->element_IF_2);
	if (!dup_dname->element_IF_2) {
		aux_add_error(LASTERROR, "aux_cpy_RDName failed", CNULL, 0, proc);
		return(-1);
	}
	dup_dname->next = NULLDNAME;
	return (0);
}


/***************************************************************
 *
 * Procedure aux_cpy2_DName
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_DName(
	DName	 *dup_dname,
	DName	 *dname
)

#else

int aux_cpy2_DName(
	dup_dname,
	dname
)
DName	 *dup_dname;
DName	 *dname;

#endif

{
	register DName * eptr, * ptr, * ptr2;
	int              rcode;
	char	       * proc = "aux_cpy2_DName";


	if ( (dname == (DName * )0) || (dup_dname == (DName * )0)  ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	rcode = aux_cpy2_DName_comp (dup_dname, dname);
	if (rcode < 0) {
		aux_add_error(LASTERROR, "aux_cpy2_DName_comp failed", CNULL, 0, proc);
		return(-1);
	}
	ptr2 = dup_dname;
	for (eptr = dname->next; eptr != NULLDNAME; eptr = eptr->next) {
		ptr = aux_cpy_DName_comp (eptr);
		if (!ptr) {
			aux_add_error(LASTERROR, "aux_cpy_DName_comp failed", CNULL, 0, proc);
			return(-1);
		}
		ptr2->next = ptr;
		ptr2 = ptr;
	}

	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_keyword2oid
 *
 ***************************************************************/
#ifdef __STDC__

ObjId *aux_keyword2oid(
	char	 *keyword
)

#else

ObjId *aux_keyword2oid(
	keyword
)
char	 *keyword;

#endif

{
	register AttrList *a = &attrlist[0];
	char	*proc = "aux_keyword2oid";
	int n, no = 0, le, val;
	ObjId *ret;

	if (!keyword)
		return((ObjId * )0);
	while (a->abbrev) {
		if (strcmp(keyword, a->abbrev) == 0)
			return(aux_cpy_ObjId(a->objid));
		if (strcmp(keyword, a->keyword) == 0)
			return(aux_cpy_ObjId(a->objid));
		a++;
	}
	le = strlen(keyword);

	if(keyword[0] == '{' && keyword[le-1] == '}' ) {
		for(n = 1; ;) {
			while(keyword[n] == ' ') n++;
			if(keyword[n] <= '9' && keyword[n] >= '0') {
				while(keyword[n] <= '9' && keyword[n] >= '0') n++;
				no++;
			}
			else if(keyword[n] == '}') break;
			else return((ObjId * )0);
		}
		if(!no) return((ObjId * )0);
		if ( (ret = (ObjId * )malloc(sizeof(ObjId))) == (ObjId * )0 ) {
			aux_add_error(EMALLOC, "ret", CNULL, 0, proc);
			return( (ObjId * )0 );
		}
		if ( (ret->oid_elements = (unsigned int * )calloc(no, sizeof(unsigned int))) == (unsigned int *)0 ) {
			aux_add_error(EMALLOC, "ret->oid_elements", CNULL, 0, proc);
			return( (ObjId * )0 );
		}
		no = 0;
		for(n = 1; keyword[n] != '}' ;) {
			while(keyword[n] == ' ') n++;
			if(keyword[n] <= '9' && keyword[n] >= '0') {
				val = 0;
				while(keyword[n] <= '9' && keyword[n] >= '0') {
					val = val * 10 + keyword[n] - '0';
					n++;
				}
				ret->oid_elements[no++] = val;
			}
		}
		ret->oid_nelem = no;
		
		return(ret);
	}
	return((ObjId * )0);
}


/***************************************************************
 *
 * Procedure aux_keyword2syntaxoid
 *
 ***************************************************************/
#ifdef __STDC__

ObjId *aux_keyword2syntaxoid(
	char	 *keyword
)

#else

ObjId *aux_keyword2syntaxoid(
	keyword
)
char	 *keyword;

#endif

{
	register AttrList *a = &attrlist[0];
	char	*proc = "aux_keyword2syntaxoid";
	int n, no = 0, le, val;
	ObjId *ret;

	if (!keyword)
		return((ObjId * )0);
	while (a->abbrev) {
		if (strcmp(keyword, a->abbrev) == 0)
			return(a->syntax_oid);
		if (strcmp(keyword, a->keyword) == 0)
			return(a->syntax_oid);
		a++;
	}
	le = strlen(keyword);

	if(keyword[0] == '{' && keyword[le-1] == '}' ) {
		for(n = 1; ;) {
			while(keyword[n] == ' ') n++;
			if(keyword[n] <= '9' && keyword[n] >= '0') {
				while(keyword[n] <= '9' && keyword[n] >= '0') n++;
				no++;
			}
			else if(keyword[n] == '}') break;
			else return((ObjId * )0);
		}
		if(!no) return((ObjId * )0);
		if ( (ret = (ObjId * )malloc(sizeof(ObjId))) == (ObjId * )0 ) {
			aux_add_error(EMALLOC, "ret", CNULL, 0, proc);
			return( (ObjId * )0 );
		}
		if ( (ret->oid_elements = (unsigned int * )calloc(no, sizeof(unsigned int))) == (unsigned int *)0 ) {
			aux_add_error(EMALLOC, "ret->oid_elements", CNULL, 0, proc);
			return( (ObjId * )0 );
		}
		no = 0;
		for(n = 1; keyword[n] != '}' ;) {
			while(keyword[n] == ' ') n++;
			if(keyword[n] <= '9' && keyword[n] >= '0') {
				val = 0;
				while(keyword[n] <= '9' && keyword[n] >= '0') {
					val = val * 10 + keyword[n] - '0';
					n++;
				}
				ret->oid_elements[no++] = val;
			}
		}
		ret->oid_nelem = no;
		
		return(ret);
	}
	return((ObjId * )0);
}


/***************************************************************
 *
 * Procedure aux_oid2keyword
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_oid2keyword(
	ObjId	 *given_objid
)

#else

char *aux_oid2keyword(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AttrList *a = &attrlist[0];
	char	*proc = "aux_oid2keyword";
	char	*ret;
	int i;

	if (!given_objid)
		return((char *)0);
	while (a->abbrev) {
		if (!aux_cmp_ObjId(given_objid, a->objid))
			return(a->abbrev);
		a++;
	}
	if ( (ret = (char * )malloc(given_objid->oid_nelem*5+10)) == (char * )0 ) {
		aux_add_error(EMALLOC, "ret", CNULL, 0, proc);
		return( (char * )0 );
	}
	strcpy (ret, "{ ");
	for ( i = 0; i < given_objid->oid_nelem; i++) {
		sprintf(ret+strlen(ret), "%d ", given_objid->oid_elements[i]);
	}
	strcat (ret, "}");

	return(ret);
}



/***************************************************************
 *
 * Procedure aux_cpy_Certificate
 *
 ***************************************************************/
#ifdef __STDC__

Certificate *aux_cpy_Certificate(
	Certificate	 *cert
)

#else

Certificate *aux_cpy_Certificate(
	cert
)
Certificate	 *cert;

#endif

{
	int	      i, nob, lim;
	Certificate * dup_cert;
	char	    * proc = "aux_cpy_Certificate";


	if ( (cert == (Certificate * )0) )
		return( (Certificate * )0 );
	if ( (dup_cert = (Certificate * )malloc(sizeof(Certificate))) == (Certificate * )0 ) {
		aux_add_error(EMALLOC, "dup_cert", CNULL, 0, proc);
		return( (Certificate * )0 );
	}

	if (aux_cpy2_Certificate (dup_cert, cert)) {
		aux_add_error(LASTERROR, "aux_cpy2_Certificate failed", CNULL, 0, proc);
		return( (Certificate * )0 );
	}

	return( dup_cert );
}


/***************************************************************
 *
 * Procedure aux_cpy2_Signature
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_Signature(
	Signature	 *dup_sig,
	Signature	 *sig
)

#else

int aux_cpy2_Signature(
	dup_sig,
	sig
)
Signature	 *dup_sig;
Signature	 *sig;

#endif

{
	char	* proc = "aux_cpy2_Signature";


	if ( (sig == (Signature * )0) || (dup_sig == (Signature * )0) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_sig->signAI = aux_cpy_AlgId(sig->signAI);
	if (!dup_sig->signAI) {
		aux_add_error(LASTERROR, "aux_cpy_AlgId failed", CNULL, 0, proc);
		return(-1);
	}
	if (aux_cpy2_BitString(&dup_sig->signature, &sig->signature)) {
		aux_add_error(LASTERROR, "aux_cpy2_BitString failed", CNULL, 0, proc);
		return( -1 );
	}
	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cpy_Signature
 *
 ***************************************************************/
#ifdef __STDC__

Signature *aux_cpy_Signature(
	Signature	 *sig
)

#else

Signature *aux_cpy_Signature(
	sig
)
Signature	 *sig;

#endif

{
	Signature  * dup_sig;
	char	   * proc = "aux_cpy_Signature";


	if ((sig == (Signature * )0))
		return( (Signature * )0);
	if ((dup_sig = (Signature * )malloc(sizeof(Signature))) == (Signature * )0 ) {
		aux_add_error(EMALLOC, "dup_sig", CNULL, 0, proc);
		return((Signature * )0);
	}
	if (aux_cpy2_Signature (dup_sig, sig)) {
		aux_add_error(LASTERROR, "aux_cpy2_Signature failed", CNULL, 0, proc);
		return( (Signature * )0 );
	}
	return(dup_sig);
}


/***************************************************************
 *
 * Procedure aux_cpy2_Certificate
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_Certificate(
	Certificate	 *dup_cert,
	Certificate	 *cert
)

#else

int aux_cpy2_Certificate(
	dup_cert,
	cert
)
Certificate	 *dup_cert;
Certificate	 *cert;

#endif

{
	char	* proc = "aux_cpy2_Certificate";


	if ( (cert == (Certificate * )0) || (dup_cert == (Certificate * )0)  ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_cert->tbs_DERcode = aux_cpy_OctetString(cert->tbs_DERcode);
	dup_cert->tbs = aux_cpy_ToBeSigned(cert->tbs);
	dup_cert->sig = aux_cpy_Signature(cert->sig);

	return( 0 );
}

/***************************************************************
 *
 * Procedure aux_cpy_PKList
 *
 ***************************************************************/
#ifdef __STDC__

PKList *aux_cpy_PKList(
	PKList	 *list
)

#else

PKList *aux_cpy_PKList(
	list
)
PKList	 *list;

#endif

{
	PKList  * dup_list;
	char	* proc = "aux_cpy_PKList";


	if (!list)
		return ( (PKList * ) 0);
	if ( !(dup_list = (PKList * )malloc(sizeof(PKList))) ) {
		aux_add_error(EMALLOC, "dup_list", CNULL, 0, proc);
		return ( (PKList * ) 0);
	}
	dup_list->element = aux_cpy_ToBeSigned(list->element);
	dup_list->next = aux_cpy_PKList(list->next);

	return(dup_list);
}


/***************************************************************
 *
 * Procedure aux_cpy_Certificates
 *
 ***************************************************************/
#ifdef __STDC__

Certificates *aux_cpy_Certificates(
	Certificates	 *certs
)

#else

Certificates *aux_cpy_Certificates(
	certs
)
Certificates	 *certs;

#endif

{
	Certificates * dup_certs;
	char	     * proc = "aux_cpy_Certificates";


	if (!certs)
		return ( (Certificates * ) 0);

	if ( !(dup_certs = (Certificates * )malloc(sizeof(Certificates))) ) {
		aux_add_error(EMALLOC, "dup_certs", CNULL, 0, proc);
		return ( (Certificates * ) 0);
	}
	dup_certs->usercertificate = aux_cpy_Certificate(certs->usercertificate);
	dup_certs->forwardpath = aux_cpy_FCPath(certs->forwardpath);

	return (dup_certs);
}


/***************************************************************
 *
 * Procedure aux_cpy_CertificatePair
 *
 ***************************************************************/
#ifdef __STDC__

CertificatePair *aux_cpy_CertificatePair(
	CertificatePair	 *certs
)

#else

CertificatePair *aux_cpy_CertificatePair(
	certs
)
CertificatePair	 *certs;

#endif

{
	CertificatePair * dup_certs;
	char	        * proc = "aux_cpy_CertificatePair";


	if (!certs)
		return ( (CertificatePair * ) 0);

	if ( !(dup_certs = (CertificatePair * )malloc(sizeof(CertificatePair))) ) {
		aux_add_error(EMALLOC, "dup_certs", CNULL, 0, proc);
		return ( (CertificatePair * ) 0);
	}
	dup_certs->forward = aux_cpy_Certificate(certs->forward);
	dup_certs->reverse = aux_cpy_Certificate(certs->reverse);

	return(dup_certs);
}


/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_Certificate
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_Certificate *aux_cpy_SET_OF_Certificate(
	SET_OF_Certificate	 *certs
)

#else

SET_OF_Certificate *aux_cpy_SET_OF_Certificate(
	certs
)
SET_OF_Certificate	 *certs;

#endif

{
	SET_OF_Certificate * dup_certs;
	char		   * proc = "aux_cpy_SET_OF_Certificate";


	if (!certs)
		return ( (SET_OF_Certificate * ) 0);

	if ( !(dup_certs = (SET_OF_Certificate * )malloc(sizeof(SET_OF_Certificate))) ) {
		aux_add_error(EMALLOC, "dup_certs", CNULL, 0, proc);
		return ( (SET_OF_Certificate * ) 0);
	}
	dup_certs->element = aux_cpy_Certificate(certs->element);
	dup_certs->next = aux_cpy_SET_OF_Certificate(certs->next);

	return(dup_certs);
}


/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_Name
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_Name *aux_cpy_SET_OF_Name(
	SET_OF_Name	 *nameset
)

#else

SET_OF_Name *aux_cpy_SET_OF_Name(
	nameset
)
SET_OF_Name	 *nameset;

#endif

{
	SET_OF_Name * dup_nameset;
	char	    * proc = "aux_cpy_SET_OF_Name";


	if (!nameset)
		return ( (SET_OF_Name * ) 0);

	if ( !(dup_nameset = (SET_OF_Name * )malloc(sizeof(SET_OF_Name))) ) {
		aux_add_error(EMALLOC, "dup_nameset", CNULL, 0, proc);
		return ( (SET_OF_Name * ) 0);
	}
	dup_nameset->element = aux_cpy_Name(nameset->element);
	dup_nameset->next = aux_cpy_SET_OF_Name(nameset->next);

	return(dup_nameset);
}


/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_CertificatePair
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_CertificatePair *aux_cpy_SET_OF_CertificatePair(
	SET_OF_CertificatePair	 *certs
)

#else

SET_OF_CertificatePair *aux_cpy_SET_OF_CertificatePair(
	certs
)
SET_OF_CertificatePair	 *certs;

#endif

{
	SET_OF_CertificatePair * dup_certs;
	char		       * proc = "aux_cpy_SET_OF_CertificatePair";


	if (!certs)
		return ( (SET_OF_CertificatePair * ) 0);

	if ( !(dup_certs = (SET_OF_CertificatePair * )malloc(sizeof(SET_OF_CertificatePair))) ) {
		aux_add_error(EMALLOC, "dup_certs", CNULL, 0, proc);
		return ( (SET_OF_CertificatePair * ) 0);
	}
	dup_certs->element = aux_cpy_CertificatePair(certs->element);
	dup_certs->next = aux_cpy_SET_OF_CertificatePair(certs->next);

	return(dup_certs);
}


/***************************************************************
 *
 * Procedure aux_cpy_FCPath
 *
 ***************************************************************/
#ifdef __STDC__

FCPath *aux_cpy_FCPath(
	FCPath	 *fcpath
)

#else

FCPath *aux_cpy_FCPath(
	fcpath
)
FCPath	 *fcpath;

#endif

{
	FCPath  * dup_fcpath;
	char	* proc = "aux_cpy_FCPath";


	if (!fcpath)
		return ( (FCPath * ) 0);

	if ( !(dup_fcpath = (FCPath * )malloc(sizeof(FCPath))) ) {
		aux_add_error(EMALLOC, "dup_fcpath", CNULL, 0, proc);
		return ( (FCPath * ) 0);
	}
	dup_fcpath->liste = aux_cpy_SET_OF_Certificate(fcpath->liste);
	dup_fcpath->next_forwardpath = aux_cpy_FCPath(fcpath->next_forwardpath);

	return(dup_fcpath);
}


/***************************************************************
 *
 * Procedure aux_cpy_ToBeSigned
 *
 ***************************************************************/
#ifdef __STDC__

ToBeSigned *aux_cpy_ToBeSigned(
	ToBeSigned	 *tbs
)

#else

ToBeSigned *aux_cpy_ToBeSigned(
	tbs
)
ToBeSigned	 *tbs;

#endif

{
	ToBeSigned * dup_tbs;
	char	   * proc = "aux_cpy_ToBeSigned";


	if (!tbs)
		return ( (ToBeSigned * ) 0);

	if ( !(dup_tbs = (ToBeSigned * )malloc(sizeof(ToBeSigned))) ) {
		aux_add_error(EMALLOC, "dup_tbs", CNULL, 0, proc);
		return ( (ToBeSigned * ) 0);
	}
	dup_tbs->version = tbs->version;
	dup_tbs->serialnumber = aux_cpy_OctetString(tbs->serialnumber);
	dup_tbs->signatureAI = aux_cpy_AlgId(tbs->signatureAI);
	dup_tbs->issuer = aux_cpy_DName(tbs->issuer);
	dup_tbs->valid = aux_cpy_Validity(tbs->valid);
	dup_tbs->subject = aux_cpy_DName(tbs->subject);
	dup_tbs->subjectPK = aux_cpy_KeyInfo(tbs->subjectPK);

#ifdef COSINE
	if (tbs->authatts) {
		if ( !(dup_tbs->authatts = (AuthorisationAttributes * )
					 malloc(sizeof(AuthorisationAttributes))) ) {
			aux_add_error(EMALLOC, "dup_tbs->authatts", CNULL, 0, proc);
			return ( (ToBeSigned * ) 0);
		}
		dup_tbs->authatts->country = aux_cpy_Name(tbs->authatts->country);
		dup_tbs->authatts->group = aux_cpy_Name(tbs->authatts->group);
		dup_tbs->authatts->class = tbs->authatts->class;
	}
	else
		dup_tbs->authatts = (AuthorisationAttributes * ) 0;
#endif

	return(dup_tbs);
}




/***************************************************************
 *
 * Procedure aux_cpy_Key
 *
 ***************************************************************/
#ifdef __STDC__

Key *aux_cpy_Key(
	Key	 *key
)

#else

Key *aux_cpy_Key(
	key
)
Key	 *key;

#endif

{
	Key     * dup_key;
	char	* proc = "aux_cpy_Key";


	if (!key)
		return ( (Key * ) 0);

	if ( !(dup_key = (Key * )malloc(sizeof(Key))) ) {
		aux_add_error(EMALLOC, "dup_key", CNULL, 0, proc);
		return ( (Key * ) 0);
	}
	dup_key->key = aux_cpy_KeyInfo(key->key);
	dup_key->keyref = key->keyref;
	dup_key->pse_sel = aux_cpy_PSESel(key->pse_sel);
	dup_key->alg = aux_cpy_AlgId(key->alg);

	return(dup_key);
}


/***************************************************************
 *
 * Procedure aux_cpy_PSEToc
 *
 ***************************************************************/
#ifdef __STDC__

PSEToc *aux_cpy_PSEToc(
	PSEToc	 *pse
)

#else

PSEToc *aux_cpy_PSEToc(
	pse
)
PSEToc	 *pse;

#endif

{
	PSEToc  * dup_pse;
	char	* proc = "aux_cpy_PSEToc";


	if (!pse)
		return ( (PSEToc * ) 0);

	if ( !(dup_pse = (PSEToc * )malloc(sizeof(PSEToc))) ) {
		aux_add_error(EMALLOC, "dup_pse", CNULL, 0, proc);
		return ( (PSEToc * ) 0);
	}
	dup_pse->owner = aux_cpy_Name(pse->owner);
	dup_pse->create = aux_cpy_Name(pse->create);
	dup_pse->update = aux_cpy_Name(pse->update);
	dup_pse->obj = aux_cpy_PSEObjects(pse->obj);

	return(dup_pse);
}


/***************************************************************
 *
 * Procedure aux_cpy_PSEObjects
 *
 ***************************************************************/
#ifdef __STDC__

struct PSE_Objects *aux_cpy_PSEObjects(
	struct PSE_Objects	 *pse
)

#else

struct PSE_Objects *aux_cpy_PSEObjects(
	pse
)
struct PSE_Objects	 *pse;

#endif

{
	struct PSE_Objects * dup_pse;
	char		   * proc = "aux_cpy_PSEObjects";


	if (!pse)
		return ( (struct PSE_Objects * ) 0);

	if ( !(dup_pse = (struct PSE_Objects *)malloc(sizeof(struct PSE_Objects ))) ) {
		aux_add_error(EMALLOC, "dup_pse", CNULL, 0, proc);
		return ( (struct PSE_Objects * ) 0);
	}
	dup_pse->name = aux_cpy_Name(pse->name);
	dup_pse->create = aux_cpy_Name(pse->create);
	dup_pse->update = aux_cpy_Name(pse->update);
	dup_pse->noOctets = pse->noOctets;
	dup_pse->status = pse->status;
	dup_pse->next = aux_cpy_PSEObjects(pse->next);

	return(dup_pse);
}


/***************************************************************
 *
 * Procedure aux_cpy_PSEObject
 *
 ***************************************************************/
#ifdef __STDC__

PSEObject *aux_cpy_PSEObject(
	PSEObject	 *pse
)

#else

PSEObject *aux_cpy_PSEObject(
	pse
)
PSEObject	 *pse;

#endif

{
	PSEObject * dup_pse;
	char	  * proc = "aux_cpy_PSEObject";


	if (!pse)
		return ( (PSEObject * ) 0);

	if ( !(dup_pse = (PSEObject * )malloc(sizeof(PSEObject))) ) {
		aux_add_error(EMALLOC, "dup_pse", CNULL, 0, proc);
		return ( (PSEObject * ) 0);
	}
	dup_pse->objectType = aux_cpy_ObjId(pse->objectType);
	dup_pse->objectValue = aux_cpy_OctetString(pse->objectValue);

	return(dup_pse);
}


/***************************************************************
 *
 * Procedure aux_cpy_PKRoot
 *
 ***************************************************************/
#ifdef __STDC__

PKRoot *aux_cpy_PKRoot(
	PKRoot	 *pkr
)

#else

PKRoot *aux_cpy_PKRoot(
	pkr
)
PKRoot	 *pkr;

#endif

{
	PKRoot  * dup_pkr;
	char	* proc = "aux_cpy_PKRoot";


	if (!pkr)
		return ( (PKRoot * ) 0);

	if ( !(dup_pkr = (PKRoot * )malloc(sizeof(PKRoot))) ) {
		aux_add_error(EMALLOC, "dup_pkr", CNULL, 0, proc);
		return ( (PKRoot * ) 0);
	}
	dup_pkr->ca = aux_cpy_DName(pkr->ca);
	dup_pkr->newkey = aux_cpy_Serial(pkr->newkey);
	dup_pkr->oldkey = aux_cpy_Serial(pkr->oldkey);

	return(dup_pkr);
}


/***************************************************************
 *
 * Procedure aux_cpy_IssuedCertificate
 *
 ***************************************************************/
#ifdef __STDC__

IssuedCertificate *aux_cpy_IssuedCertificate(
	IssuedCertificate	 *isscert
)

#else

IssuedCertificate *aux_cpy_IssuedCertificate(
	isscert
)
IssuedCertificate	 *isscert;

#endif

{
	IssuedCertificate * dup_isscert;
	char	          * proc = "aux_cpy_IssuedCertificate";


	if ( (isscert == (IssuedCertificate * )0) )
		return ( (IssuedCertificate * )0 );
	if ( (dup_isscert = (IssuedCertificate * )malloc(sizeof(IssuedCertificate))) == (IssuedCertificate * )0 ) {
		aux_add_error(EMALLOC, "dup_isscert", CNULL, 0, proc);
		return ( (IssuedCertificate * )0 );
	}

	dup_isscert->serial = aux_cpy_OctetString(isscert->serial);
	dup_isscert->date_of_issue = aux_cpy_Name(isscert->date_of_issue);

	return( dup_isscert );
}


/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_IssuedCertificate
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_IssuedCertificate *aux_cpy_SET_OF_IssuedCertificate(
	SET_OF_IssuedCertificate	 *isscertset
)

#else

SET_OF_IssuedCertificate *aux_cpy_SET_OF_IssuedCertificate(
	isscertset
)
SET_OF_IssuedCertificate	 *isscertset;

#endif

{
	SET_OF_IssuedCertificate * dup_isscertset;
	char			 * proc = "aux_cpy_SET_OF_IssuedCertificate";


	if (!isscertset)
		return ( (SET_OF_IssuedCertificate * ) 0);

	if ( !(dup_isscertset = (SET_OF_IssuedCertificate * )malloc(sizeof(SET_OF_IssuedCertificate))) ) {
		aux_add_error(EMALLOC, "dup_isscertset", CNULL, 0, proc);
		return  ( (SET_OF_IssuedCertificate * ) 0);
	}
	dup_isscertset->element = aux_cpy_IssuedCertificate(isscertset->element);
	dup_isscertset->next = aux_cpy_SET_OF_IssuedCertificate(isscertset->next);

	return(dup_isscertset);
}


/***************************************************************
 *
 * Procedure aux_cpy_Crl
 *
 ***************************************************************/
#ifdef __STDC__

Crl *aux_cpy_Crl(
	Crl	 *crlpse
)

#else

Crl *aux_cpy_Crl(
	crlpse
)
Crl	 *crlpse;

#endif

{
	Crl * dup_crlpse;
	char   * proc = "aux_cpy_Crl";


	if ( (crlpse == (Crl * )0) )
		return ( (Crl * )0 );
	if ( (dup_crlpse = (Crl * )malloc(sizeof(Crl))) == (Crl * )0 ) {
		aux_add_error(EMALLOC, "dup_crlpse", CNULL, 0, proc);
		return ( (Crl * )0 );
	}

	dup_crlpse->issuer = aux_cpy_DName(crlpse->issuer);
	dup_crlpse->nextUpdate = aux_cpy_Name(crlpse->nextUpdate);
	dup_crlpse->revcerts = aux_cpy_SEQUENCE_OF_CRLEntry(crlpse->revcerts);

	return ( dup_crlpse );
}


/***************************************************************
 *
 * Procedure aux_cpy_CrlSet
 *
 ***************************************************************/
#ifdef __STDC__

CrlSet *aux_cpy_CrlSet(
	CrlSet	 *crlset
)

#else

CrlSet *aux_cpy_CrlSet(
	crlset
)
CrlSet	 *crlset;

#endif

{
	CrlSet * dup_crlset;
	char	   * proc = "aux_cpy_CrlSet";


	if (!crlset)
		return ( (CrlSet * ) 0);

	if ( !(dup_crlset = (CrlSet * )malloc(sizeof(CrlSet))) ) {
		aux_add_error(EMALLOC, "dup_crlset", CNULL, 0, proc);
		return ( (CrlSet * ) 0);
	}
	dup_crlset->element = aux_cpy_Crl(crlset->element);
	dup_crlset->next = aux_cpy_CrlSet(crlset->next);

	return(dup_crlset);
}


/***************************************************************
 *
 * Procedure aux_cpy_Serial
 *
 ***************************************************************/
#ifdef __STDC__

struct Serial *aux_cpy_Serial(
	struct Serial	 *serial
)

#else

struct Serial *aux_cpy_Serial(
	serial
)
struct Serial	 *serial;

#endif

{
	struct Serial   * dup_serial;
	char		* proc = "aux_cpy_Serial";


	if (!serial)
		return ( (struct Serial * ) 0);

	if ( !(dup_serial = (struct Serial *)malloc(sizeof(struct Serial ))) ) {
		aux_add_error(EMALLOC, "dup_serial", CNULL, 0, proc);
		return ( (struct Serial * ) 0);
	}

	dup_serial->serial = aux_cpy_OctetString(serial->serial);
	dup_serial->key = aux_cpy_KeyInfo(serial->key);
	dup_serial->valid = aux_cpy_Validity(serial->valid);
	dup_serial->sig = aux_cpy_Signature(serial->sig);

	return (dup_serial);
} 


/***************************************************************
 *
 * Procedure aux_cpy_Aliases
 *
 ***************************************************************/
#ifdef __STDC__

Aliases *aux_cpy_Aliases(
	Aliases	 *aliases
)

#else

Aliases *aux_cpy_Aliases(
	aliases
)
Aliases	 *aliases;

#endif

{
	Aliases   * dup_aliases;
	char	  * proc = "aux_cpy_Aliases";


	if (! aliases)
		return ( (Aliases * )0 );

	if ( !(dup_aliases = (Aliases * )malloc(sizeof(Aliases))) ) {
		aux_add_error(EMALLOC, "dup_aliases", CNULL, 0, proc);
		return ( (Aliases * )0 );
	}

	dup_aliases->aname = aux_cpy_String(aliases->aname);
	dup_aliases->aliasfile = aliases->aliasfile;
	dup_aliases->next = aux_cpy_Aliases(aliases->next);

	return (dup_aliases);
}


/***************************************************************
 *
 * Procedure aux_cpy_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

AliasList *aux_cpy_AliasList(
	AliasList	 *aliaslist
)

#else

AliasList *aux_cpy_AliasList(
	aliaslist
)
AliasList	 *aliaslist;

#endif

{
	AliasList   * dup_aliaslist;
	char	    * proc = "aux_cpy_AliasList";


	if (! aliaslist)
		return ( (AliasList * )0 );

	if ( !(dup_aliaslist = (AliasList * )malloc(sizeof(AliasList))) ) {
		aux_add_error(EMALLOC, "dup_aliaslist", CNULL, 0, proc);
		return ( (AliasList * )0 );
	}

	dup_aliaslist->a = aux_cpy_Aliases(aliaslist->a);
	dup_aliaslist->dname = aux_cpy_Name(aliaslist->dname);
	dup_aliaslist->next = aux_cpy_AliasList(aliaslist->next);

	return (dup_aliaslist);
}


/***************************************************************
 *
 * Procedure aux_determine_Signer
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_determine_Signer(
	VerificationResult	 * verres,
	Boolean			 * authentication
)

#else

Name *aux_determine_Signer(
	verres,
	authentication
)
VerificationResult    * verres;
Boolean		      * authentication;

#endif

{
	Name            * signer;
	Boolean   	  dn_subordination_violation = FALSE;
	int       	  crlcheck = 0, index;

	char		* proc = "aux_determine_Signer";


	if (! verres || ! authentication) {
		aux_add_error(EINVALID, "Parameters not present", CNULL, 0, proc);
		return(CNULL);
	}

	if (verres->verifstep) {
		index = 0;
		while(verres->verifstep[index]){
			if(verres->verifstep[index]->dn_subordination_violation == TRUE){
				dn_subordination_violation = TRUE;
				break;
			}
			index++;
		}
		index = 0;
		while(verres->verifstep[index]){
			if(verres->verifstep[index]->crlcheck == CRL_NOT_AVAILABLE){
				crlcheck = CRL_NOT_AVAILABLE;
				break;
			}
			index++;
		} /* while */
	} /* if */

	if(! verres->verifstep || ! verres->verifstep[0])
		signer = aux_cpy_Name(verres->top_name);
	else
		signer = aux_DName2Name(verres->verifstep[0]->cert->tbs->subject);
	if(! signer){
		AUX_ADD_ERROR;
		return(CNULL);
	}

	if (verres->success == TRUE && dn_subordination_violation == FALSE && crlcheck == 0)
		* authentication = TRUE;
	else
		* authentication = FALSE;


	return(signer);
}



/* #include "iso3166.h" */
#ifndef MAC
#include <ctype.h>
#endif /* MAC */

/***************************************************************
 *
 * Procedure aux_check_3166
 *
 ***************************************************************/
#ifdef __STDC__

int aux_check_3166(
	char	 *a
)

#else

int aux_check_3166(
	a
)
char	 *a;

#endif

{
	int	bitno;

	if (strlen (a) != 2)
		return 0;

	if (islower ((u_char) a[0]))
		a[0] = toupper (a[0]);
	if (islower ((u_char) a[1]))
		a[1] = toupper (a[1]);

	/*return (isupper ((u_char) a[0]) && isupper((u_char) a[1]) && is3166 (a));*/
	return (isupper ((u_char) a[0]) && isupper((u_char) a[1]));
}


/***************************************************************
 *
 * Procedure aux_check_print_string
 *
 ***************************************************************/
#ifdef __STDC__

int aux_check_print_string(
	register char	 *str
)

#else

int aux_check_print_string(
	str
)
register char	 *str;

#endif

{

	for (; *str != 0; str++) {
		if ((isascii((*str) & 0xff)) && (isalnum ((*str) & 0xff)))
			continue;      /*isascii() and isalnum() from /usr/include/ctype.h */

		switch (*str) {
		case 047:  /* ' */
		case '(':
		case ')':
		case '+':
		case '-':
		case '.':
		case ',':
		case '/':
		case ':':
		case '=':
		case '?':
		case ' ':
			continue;
		default:
			return (0);
		}
	}
	return (1);
}


/****************************************************************************/

/***************************************************************
 *
 * Procedure aux_create_Certificates
 *
 ***************************************************************/
#ifdef __STDC__

Certificates *aux_create_Certificates(
	Certificate	 *cert,
	FCPath		 *fcpath
)

#else

Certificates *aux_create_Certificates(
	cert,
	fcpath
)
Certificate	 *cert;
FCPath		 *fcpath;

#endif

{
	Certificates * certs;
	char	     * proc = "aux_create_Certificates";


	if (!cert) {
		aux_add_error(EINVALID, "cert empty", CNULL, 0, proc);
		return ( (Certificates * )0);
	}

	if (!(certs = (Certificates * )calloc(1, sizeof(Certificates))))  {
		aux_add_error(EMALLOC, "certs", CNULL, 0, proc);
		return ( (Certificates * )0);
	}

	if (!(certs->usercertificate = aux_cpy_Certificate(cert))) {
		aux_add_error(LASTERROR, "aux_cpy_Certificate failed", CNULL, 0, proc);
		return ( (Certificates * )0);
	}

	if(fcpath) {
                if (!(certs->forwardpath = aux_cpy_FCPath(fcpath))) {
        		aux_add_error(LASTERROR, "aux_cpy_FCPath failed", CNULL, 0, proc);
        		return ( (Certificates * )0);
        	}
        }

	return(certs);

}


/***************************************************************
 *
 * Procedure aux_create_FCPath
 *
 ***************************************************************/
#ifdef __STDC__

FCPath *aux_create_FCPath(
	Certificate	 *cert
)

#else

FCPath *aux_create_FCPath(
	cert
)
Certificate	 *cert;

#endif

{
	FCPath       * fcpath;
	char	     * proc = "aux_create_FCPath";


	if (! cert) {
		aux_add_error(EINVALID, "cert empty", CNULL, 0, proc);
		return ( (FCPath * )0);
	}

	if (!(fcpath = (FCPath * )calloc(1, sizeof(FCPath))))  {
		aux_add_error(EMALLOC, "fcpath", CNULL, 0, proc);
		return ( (FCPath * )0);
	}

	if (!(fcpath->liste = (SET_OF_Certificate * )calloc(1, sizeof(SET_OF_Certificate))))  {
		aux_add_error(EMALLOC, "fcpath->liste", CNULL, 0, proc);
		return ( (FCPath * )0);
	}
	
	if (!(fcpath->liste->element = aux_cpy_Certificate(cert))) {
		aux_add_error(LASTERROR, "aux_cpy_Certificate failed", CNULL, 0, proc);
		return ( (FCPath * )0);
	}

	fcpath->liste->next = (SET_OF_Certificate *) 0;
	fcpath->next_forwardpath = (FCPath *) 0;

	return(fcpath);

}


/****************************************************************************/

/***************************************************************
 *
 * Procedure aux_create_PKRoot
 *
 ***************************************************************/
#ifdef __STDC__

PKRoot *aux_create_PKRoot(
	Certificate	 *cert1,
	Certificate	 *cert2
)

#else

PKRoot *aux_create_PKRoot(
	cert1,
	cert2
)
Certificate	 *cert1;
Certificate	 *cert2;

#endif

{
	PKRoot * pkroot;
	struct Serial *newkey, *oldkey;
	char	     * proc = "aux_create_PKRoot";


	if (!cert1) {
		aux_add_error(EINVALID, "cert1 empty", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}

	if (!(pkroot = (PKRoot * )calloc(1, sizeof(PKRoot))))  {
		aux_add_error(EMALLOC, "pkroot", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}

	if (!(pkroot->ca = aux_cpy_DName(cert1->tbs->subject))) {
		aux_add_error(LASTERROR, "aux_cpy_DName failed", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}

	if (!(newkey = (struct Serial * )malloc(sizeof(struct Serial))))  {
		aux_add_error(EMALLOC, "newkey", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}
	pkroot->newkey = newkey;
	newkey->serial = aux_cpy_OctetString(cert1->tbs->serialnumber);
	newkey->version = cert1->tbs->version;
	if(!(newkey->key = aux_cpy_KeyInfo(cert1->tbs->subjectPK))) {
		aux_add_error(EMALLOC, "newkey->key", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}
	if(!(newkey->valid = aux_cpy_Validity(cert1->tbs->valid))) {
		aux_add_error(EMALLOC, "newkey->valid", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}
	if(!(newkey->sig = aux_cpy_Signature(cert1->sig))) {
		aux_add_error(EMALLOC, "newkey->sig", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}
	if(cert2) {
		if (!(oldkey = (struct Serial * )malloc(sizeof(struct Serial))))  {
			aux_add_error(EMALLOC, "oldkey", CNULL, 0, proc);
			return ( (PKRoot * )0);
		}
		pkroot->oldkey = oldkey;
		oldkey->serial = aux_cpy_OctetString(cert2->tbs->serialnumber);
		oldkey->version = cert2->tbs->version;
		if(!(oldkey->key = aux_cpy_KeyInfo(cert2->tbs->subjectPK))) {
			aux_add_error(EMALLOC, "oldkey->key", CNULL, 0, proc);
			return ( (PKRoot * )0);
		}
		if(!(oldkey->valid = aux_cpy_Validity(cert2->tbs->valid))) {
			aux_add_error(EMALLOC, "oldkey->valid", CNULL, 0, proc);
			return ( (PKRoot * )0);
		}
		if(!(oldkey->sig = aux_cpy_Signature(cert2->sig))) {
			aux_add_error(EMALLOC, "oldkey->sig", CNULL, 0, proc);
			return ( (PKRoot * )0);
		}
	}
		

	return(pkroot);

}

/****************************************************************************/

/***************************************************************
 *
 * Procedure aux_create_Certificate
 *
 ***************************************************************/
#ifdef __STDC__

Certificate *aux_create_Certificate(
	ToBeSigned	 *tbs
)

#else

Certificate *aux_create_Certificate(
	tbs
)
ToBeSigned	 *tbs;

#endif

{
	Certificate * cert;
	char	    * proc = "aux_create_Certificate";


	if (!tbs) {
		aux_add_error(EINVALID, "tbs empty", CNULL, 0, proc);
		return ( (Certificate * )0);
	}

	if (!(cert = (Certificate * )malloc(sizeof(Certificate))))  {
		aux_add_error(EMALLOC, "cert", CNULL, 0, proc);
		return ( (Certificate * )0);
	}

	cert->tbs = aux_cpy_ToBeSigned(tbs);

	cert->sig = (Signature *)0;
	cert->tbs_DERcode = (OctetString *)0;

	return(cert);

}


/****************************************************************************/


/***************************************************************
 *
 * Procedure aux_cmp_Certificate
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_Certificate(
	Certificate	 *a,
	Certificate	 *b
)

#else

int aux_cmp_Certificate(
	a,
	b
)
Certificate	 *a;
Certificate	 *b;

#endif

{
	int	rc;

	if ( !a && !b )
		return( 0) ;
	if ( !a || !b )
		return( 1) ;


	if (a->tbs->version != b->tbs->version) return(1);
	if (aux_cmp_OctetString(a->tbs->serialnumber, b->tbs->serialnumber))
		return(1);

	if (aux_cmp_DName(a->tbs->issuer, b->tbs->issuer)) return(1);
	if (aux_cmp_DName(a->tbs->subject, b->tbs->subject)) return(1);
	if (aux_cmp_KeyInfo(a->tbs->subjectPK, b->tbs->subjectPK)) return(1);
	if (aux_cmp_Signature(a->sig, b->sig)) return(1);
	return(0);
}



/****************************************************************************/

/***************************************************************
 *
 * Procedure aux_cmp_CertificatePair
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_CertificatePair(
	CertificatePair	 *a,
	CertificatePair	 *b
)

#else

int aux_cmp_CertificatePair(
	a,
	b
)
CertificatePair	 *a;
CertificatePair	 *b;

#endif

{
	int	rc;

	if ( !a && !b )
		return( 0) ;
	if ( !a || !b )
		return( 1) ;

	if (a->forward == (Certificate * ) 0) {
		if (b->forward == (Certificate * ) 0)
			rc = 0;
		else
			rc = 1;
	} else {
		if (b->forward == (Certificate * ) 0)
			rc = 1;
		else
			rc = aux_cmp_Certificate(a->forward, b->forward);
	}

	if (rc != 0)
		return (rc);

	if (a->reverse == (Certificate * ) 0) {
		if (b->reverse == (Certificate * ) 0)
			rc = 0;
		else
			rc = 1;
	} else {
		if (b->reverse == (Certificate * ) 0)
			rc = 1;
		else
			rc = aux_cmp_Certificate(a->reverse, b->reverse);
	}

	return (rc);
}



/*******************************************************************************
 *
 *      aux-routines for certificate revocation according to PEM
 *
 *******************************************************************************/

/***************************************************************
 *
 * Procedure aux_cpy_CRLEntry
 *
 ***************************************************************/
#ifdef __STDC__

CRLEntry *aux_cpy_CRLEntry(
	CRLEntry	 *crlentry
)

#else

CRLEntry *aux_cpy_CRLEntry(
	crlentry
)
CRLEntry	 *crlentry;

#endif

{
	CRLEntry * dup_crlentry;
	char	   * proc = "aux_cpy_CRLEntry";


	if ( crlentry == (CRLEntry * )0 )
		return ( (CRLEntry * )0 );

	if ( !(dup_crlentry = (CRLEntry * )malloc(sizeof(CRLEntry))) ) {
		aux_add_error(EMALLOC, "dup_crlentry", CNULL, 0, proc);
		return ( (CRLEntry * )0 );
	}

	dup_crlentry->serialnumber = aux_cpy_OctetString(crlentry->serialnumber);
	dup_crlentry->revocationDate = aux_cpy_Name( crlentry->revocationDate);

	return (dup_crlentry);
}


/***************************************************************
 *
 * Procedure aux_cpy_SEQUENCE_OF_CRLEntry
 *
 ***************************************************************/
#ifdef __STDC__

SEQUENCE_OF_CRLEntry *aux_cpy_SEQUENCE_OF_CRLEntry(
	SEQUENCE_OF_CRLEntry	 *seq
)

#else

SEQUENCE_OF_CRLEntry *aux_cpy_SEQUENCE_OF_CRLEntry(
	seq
)
SEQUENCE_OF_CRLEntry	 *seq;

#endif

{
	SEQUENCE_OF_CRLEntry * dup_seq;
	char		       * proc = "aux_cpy_SEQUENCE_OF_CRLEntry";


	if ( (seq == (SEQUENCE_OF_CRLEntry * )0) )
		return ( (SEQUENCE_OF_CRLEntry * )0 );

	if ( !(dup_seq = (SEQUENCE_OF_CRLEntry * )malloc(sizeof(SEQUENCE_OF_CRLEntry))) ) {
		aux_add_error(EMALLOC, "dup_seq", CNULL, 0, proc);
		return ( (SEQUENCE_OF_CRLEntry * )0 );
	}
	/*copy first revoked certificate within the sequence:*/
	dup_seq->element = aux_cpy_CRLEntry(seq->element);
	dup_seq->next = aux_cpy_SEQUENCE_OF_CRLEntry(seq->next);

	return (dup_seq);
}


/***************************************************************
 *
 * Procedure aux_cpy_CRL
 *
 ***************************************************************/
#ifdef __STDC__

CRL *aux_cpy_CRL(
	CRL	 *crl
)

#else

CRL *aux_cpy_CRL(
	crl
)
CRL	 *crl;

#endif

{
	int	     i, nob, lim;
	CRL * dup_crl;
	char	   * proc = "aux_cpy_CRL";


	if ( crl == (CRL * )0 )
		return ( (CRL * )0 );

	if ( !(dup_crl = (CRL * )malloc(sizeof(CRL))) ) {
		aux_add_error(EMALLOC, "dup_crl", CNULL, 0, proc);
		return ( (CRL * )0 );
	}

	/*  Folgende Abfrage ist UNBEDINGT NOTWENDIG, da innerhalb von  ds_modifyentry()  
	 *  die Funktion entry_cpy()  aufgerufen wird, die die einzelnen Attribute 
	 *  innerhalb des betreffenden Eintrages kopiert (und nicht nur das zu modifizierende 
	 *  Attribut!):    
	 *		entryptr = entry_cpy (real_entry);
	 */

	dup_crl->tbs_DERcode = aux_cpy_OctetString(crl->tbs_DERcode);
	dup_crl->tbs = aux_cpy_CRLTBS(crl->tbs);
	dup_crl->sig = aux_cpy_Signature(crl->sig);

	return (dup_crl);
}


/***************************************************************
 *
 * Procedure aux_cpy_CRLTBS
 *
 ***************************************************************/
#ifdef __STDC__

CRLTBS *aux_cpy_CRLTBS(
	CRLTBS	 *tbs
)

#else

CRLTBS *aux_cpy_CRLTBS(
	tbs
)
CRLTBS	 *tbs;

#endif

{
	CRLTBS   * dup_tbs;
	char		* proc = "aux_cpy_CRLTBS";


	if ( tbs == (CRLTBS * )0 )
		return ( (CRLTBS * )0 );

	if ( !(dup_tbs = (CRLTBS * )malloc(sizeof(CRLTBS))) ) {
		aux_add_error(EMALLOC, "dup_tbs ", CNULL, 0, proc);
		return ( (CRLTBS * )0 );
	}

	dup_tbs->signatureAI = aux_cpy_AlgId(tbs->signatureAI);
	dup_tbs->issuer = aux_cpy_DName(tbs->issuer);
	dup_tbs->revokedCertificates = aux_cpy_SEQUENCE_OF_CRLEntry(tbs->revokedCertificates);
	dup_tbs->lastUpdate = aux_cpy_Name(tbs->lastUpdate);
	dup_tbs->nextUpdate = aux_cpy_Name(tbs->nextUpdate);

	return (dup_tbs);
}


/***************************************************************
 *
 * Procedure aux_cpy_OCList
 *
 ***************************************************************/
#ifdef __STDC__

OCList *aux_cpy_OCList(
	OCList	 *ocl
)

#else

OCList *aux_cpy_OCList(
	ocl
)
OCList	 *ocl;

#endif

{
	OCList  * dup_ocl;
	char	* proc = "aux_cpy_OCList";


	if ( ocl == (OCList * )0 )
		return ( (OCList * )0 );

	if ( !(dup_ocl = (OCList * )malloc(sizeof(OCList))) ) {
		aux_add_error(EMALLOC, "dup_ocl ", CNULL, 0, proc);
		return ( (OCList * )0 );
	}

	dup_ocl->serialnumber = aux_cpy_OctetString(ocl->serialnumber);
	dup_ocl->ccert = aux_cpy_Certificate(ocl->ccert);
	dup_ocl->next = aux_cpy_OCList(ocl->next);

	return (dup_ocl);
}


/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_PemMessageLocal
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_PemMessageLocal *aux_cpy_SET_OF_PemMessageLocal(
	SET_OF_PemMessageLocal	 *old
)

#else

SET_OF_PemMessageLocal *aux_cpy_SET_OF_PemMessageLocal(
	old
)
SET_OF_PemMessageLocal	 *old;

#endif

{
	SET_OF_PemMessageLocal *new_ = (SET_OF_PemMessageLocal *)0, *new_2;

	while(old) {
		if(new_) {
			if(!(new_2->next = ( SET_OF_PemMessageLocal *)calloc(1, sizeof( SET_OF_PemMessageLocal)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_SET_OF_PemMessageLocal(&new_);
				return( (SET_OF_PemMessageLocal *) 0);
			}
			new_2 = new_2->next;
		}
		else {
			if(!(new_2 = ( SET_OF_PemMessageLocal *)calloc(1, sizeof( SET_OF_PemMessageLocal)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_SET_OF_PemMessageLocal(&new_);
				return( (SET_OF_PemMessageLocal *) 0);
			}
			new_ = new_2;
		}
		new_2->next = (SET_OF_PemMessageLocal *)0;
		new_2->element = aux_cpy_PemMessageLocal(old->element);
		if(old->element && !new_2->element) {
			AUX_ADD_ERROR;
			 aux_free_SET_OF_PemMessageLocal(&new_);
			return((SET_OF_PemMessageLocal *) 0);
		}
		old = old->next;
	}

	return(new_);
}

/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_DName
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_DName *aux_cpy_SET_OF_DName(
	SET_OF_DName	 *old
)

#else

SET_OF_DName *aux_cpy_SET_OF_DName(
	old
)
SET_OF_DName	 *old;

#endif

{
	SET_OF_DName *new_ = (SET_OF_DName *)0, *new_2;

	while(old) {
		if(new_) {
			if(!(new_2->next = ( SET_OF_DName *)calloc(1, sizeof( SET_OF_DName)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_SET_OF_DName(&new_);
				return( (SET_OF_DName *) 0);
			}
			new_2 = new_2->next;
		}
		else {
			if(!(new_2 = ( SET_OF_DName *)calloc(1, sizeof( SET_OF_DName)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_SET_OF_DName(&new_);
				return( (SET_OF_DName *) 0);
			}
			new_ = new_2;
		}
		new_2->next = (SET_OF_DName *)0;
		new_2->element = aux_cpy_DName(old->element);
		if(old->element && !new_2->element) {
			AUX_ADD_ERROR;
			aux_free_SET_OF_DName(&new_);
			return((SET_OF_DName *) 0);
		}
		old = old->next;
	}

	return(new_);
}

/***************************************************************
 *
 * Procedure aux_cpy_VerificationStep
 *
 ***************************************************************/
#ifdef __STDC__

VerificationStep *aux_cpy_VerificationStep(
	VerificationStep	 *old
)

#else

VerificationStep *aux_cpy_VerificationStep(
	old
)
VerificationStep	 *old;

#endif

{
	VerificationStep *new_ = (VerificationStep *)0;

	if(old) {
		if(!(new_ = ( VerificationStep *)calloc(1, sizeof( VerificationStep)))) {
			aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
			 aux_free_VerificationStep(&new_);
			return( (VerificationStep *) 0);
		}



		new_->crlcheck = old->crlcheck;
		new_->supplied = old->supplied;
		new_->policy_CA = old->policy_CA;
		new_->dn_subordination_violation = old->dn_subordination_violation;


		new_->cert = aux_cpy_Certificate(old->cert);

		if(old->cert && !new_->cert) {
			AUX_ADD_ERROR;
			 aux_free_VerificationStep(&new_);
			return((VerificationStep *) 0);
		}

		new_->date = aux_cpy_String(old->date);

		if(old->date && !new_->date) {
			AUX_ADD_ERROR;
			 aux_free_VerificationStep(&new_);
			return((VerificationStep *) 0);
		}

		new_->valid = aux_cpy_Validity(old->valid);

		if(old->valid && !new_->valid) {
			AUX_ADD_ERROR;
			 aux_free_VerificationStep(&new_);
			return((VerificationStep *) 0);
		}

	}

	return(new_);
}
/***************************************************************
 *
 * Procedure aux_cpy_VerificationResult
 *
 ***************************************************************/
#ifdef __STDC__

VerificationResult *aux_cpy_VerificationResult(
	VerificationResult	 *old
)

#else

VerificationResult *aux_cpy_VerificationResult(
	old
)
VerificationResult	 *old;

#endif

{
	VerificationResult *new_ = (VerificationResult *)0;
	int		    n;

	if(old) {
		if(!(new_ = ( VerificationResult *)calloc(1, sizeof( VerificationResult)))) {
			aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
			 aux_free_VerificationResult(&new_);
			return( (VerificationResult *) 0);
		}


		if(old->verifstep) {
			for(n = 0; old->verifstep[n]; n++) ;

			new_->verifstep = (VerificationStep **)calloc(n+1, sizeof(VerificationStep * ));
			for( ; n >= 0; n--) {
				new_->verifstep[n] = aux_cpy_VerificationStep(old->verifstep[n]);

				if(old->verifstep[n] && !new_->verifstep[n]) {
					AUX_ADD_ERROR;
					 aux_free_VerificationResult(&new_);
					return((VerificationResult *) 0);
				}
			}
		}
		else new_->verifstep = (VerificationStep **)0;

		new_->trustedKey = old->trustedKey;
		new_->success = old->success;
		new_->textverified = old->textverified;


		new_->top_name = aux_cpy_Name(old->top_name);

		if(old->top_name && !new_->top_name) {
			AUX_ADD_ERROR;
			 aux_free_VerificationResult(&new_);
			return((VerificationResult *) 0);
		}

		new_->valid = aux_cpy_Validity(old->valid);

		if(old->valid && !new_->valid) {
			AUX_ADD_ERROR;
			 aux_free_VerificationResult(&new_);
			return((VerificationResult *) 0);
		}

		new_->top_serial = aux_cpy_OctetString(old->top_serial);

		if(old->top_serial && !new_->top_serial) {
			AUX_ADD_ERROR;
			 aux_free_VerificationResult(&new_);
			return((VerificationResult *) 0);
		}
	}

	return(new_);
}
/***************************************************************
 *
 * Procedure aux_cpy_PemMessageLocal
 *
 ***************************************************************/
#ifdef __STDC__

PemMessageLocal *aux_cpy_PemMessageLocal(
	PemMessageLocal	 *old
)

#else

PemMessageLocal *aux_cpy_PemMessageLocal(
	old
)
PemMessageLocal	 *old;

#endif

{
	PemMessageLocal *new_ = (PemMessageLocal *)0;

	if(old) {
		if(!(new_ = ( PemMessageLocal *)calloc(1, sizeof( PemMessageLocal)))) {
			aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
			 aux_free_PemMessageLocal(&new_);
			return( (PemMessageLocal *) 0);
		}

		new_->header = aux_cpy_PemHeaderLocal(old->header);

		if(old->header && !new_->header) {
			AUX_ADD_ERROR;
			aux_free_PemMessageLocal(&new_);
			return((PemMessageLocal *) 0);
		}

		new_->body = aux_cpy_OctetString(old->body);

		if(old->body && !new_->body) {
			AUX_ADD_ERROR;
			aux_free_PemMessageLocal(&new_);
			return((PemMessageLocal *) 0);
		}

		new_->error = aux_cpy_String(old->error);

		if(old->error && !new_->error) {
			AUX_ADD_ERROR;
			aux_free_PemMessageLocal(&new_);
			return((PemMessageLocal *) 0);
		}

		new_->comment = aux_cpy_String(old->comment);

		if(old->comment && !new_->comment) {
			AUX_ADD_ERROR;
			aux_free_PemMessageLocal(&new_);
			return((PemMessageLocal *) 0);
		}

		new_->validation_result = aux_cpy_VerificationResult(old->validation_result);

		if(old->validation_result && !new_->validation_result) {
			AUX_ADD_ERROR;
			aux_free_PemMessageLocal(&new_);
			return((PemMessageLocal *) 0);
		}
	}

	return(new_);
}
/***************************************************************
 *
 * Procedure aux_cpy_PemHeaderLocal
 *
 ***************************************************************/
#ifdef __STDC__

PemHeaderLocal *aux_cpy_PemHeaderLocal(
	PemHeaderLocal	 *old
)

#else

PemHeaderLocal *aux_cpy_PemHeaderLocal(
	old
)
PemHeaderLocal	 *old;

#endif

{
	PemHeaderLocal *new_ = (PemHeaderLocal *)0;

	if(old) {
		if(!(new_ = ( PemHeaderLocal *)calloc(1, sizeof( PemHeaderLocal)))) {
			aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
			 aux_free_PemHeaderLocal(&new_);
			return( (PemHeaderLocal *) 0);
		}

		new_->rfc_version = old->rfc_version;
		new_->proctype = old->proctype;
		new_->content_domain = old->content_domain;

		new_->dek_fields = aux_cpy_PemDekLocal(old->dek_fields);

		if(old->dek_fields && !new_->dek_fields) {
			AUX_ADD_ERROR;
			 aux_free_PemHeaderLocal(&new_);
			return((PemHeaderLocal *) 0);
		}

		new_->certificates = aux_cpy_Certificates(old->certificates);

		if(old->certificates && !new_->certificates) {
			AUX_ADD_ERROR;
			 aux_free_PemHeaderLocal(&new_);
			return((PemHeaderLocal *) 0);
		}

		new_->root_certificate = aux_cpy_Certificate(old->root_certificate);

		if(old->root_certificate && !new_->root_certificate) {
			AUX_ADD_ERROR;
			 aux_free_PemHeaderLocal(&new_);
			return((PemHeaderLocal *) 0);
		}

		new_->mic_fields = aux_cpy_PemMicLocal(old->mic_fields);

		if(old->mic_fields && !new_->mic_fields) {
			AUX_ADD_ERROR;
			 aux_free_PemHeaderLocal(&new_);
			return((PemHeaderLocal *) 0);
		}

		new_->crl_fields = aux_cpy_SET_OF_CRLWithCertificates(old->crl_fields);

		if(old->crl_fields && !new_->crl_fields) {
			AUX_ADD_ERROR;
			 aux_free_PemHeaderLocal(&new_);
			return((PemHeaderLocal *) 0);
		}

		new_->crl_rr_fields = aux_cpy_SET_OF_DName(old->crl_rr_fields);

		if(old->crl_rr_fields && !new_->crl_rr_fields) {
			AUX_ADD_ERROR;
			 aux_free_PemHeaderLocal(&new_);
			return((PemHeaderLocal *) 0);
		}

	}

	return(new_);
}
/***************************************************************
 *
 * Procedure aux_cpy_PemDekLocal
 *
 ***************************************************************/
#ifdef __STDC__

PemDekLocal *aux_cpy_PemDekLocal(
	PemDekLocal	 *old
)

#else

PemDekLocal *aux_cpy_PemDekLocal(
	old
)
PemDekLocal	 *old;

#endif

{
	PemDekLocal *new_ = (PemDekLocal *)0;

	if(old) {
		if(!(new_ = ( PemDekLocal *)calloc(1, sizeof( PemDekLocal)))) {
			aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
			return( (PemDekLocal *) 0);
		}

		new_->dekinfo_enc_alg = aux_cpy_AlgId(old->dekinfo_enc_alg);

		if(old->dekinfo_enc_alg && !new_->dekinfo_enc_alg) {
			AUX_ADD_ERROR;
			 aux_free_PemDekLocal(&new_);
			return((PemDekLocal *) 0);
		}

		new_->keyinfo_enc_alg = aux_cpy_AlgId(old->keyinfo_enc_alg);

		if(old->keyinfo_enc_alg && !new_->keyinfo_enc_alg) {
			AUX_ADD_ERROR;
			 aux_free_PemDekLocal(&new_);
			return((PemDekLocal *) 0);
		}

		new_->keyinfo_dek = aux_cpy_BitString(old->keyinfo_dek);

		if(old->keyinfo_dek && !new_->keyinfo_dek) {
			AUX_ADD_ERROR;
			 aux_free_PemDekLocal(&new_);
			return((PemDekLocal *) 0);
		}

		new_->recipients = aux_cpy_SET_OF_PemRecLocal(old->recipients);

		if(old->recipients && !new_->recipients) {
			AUX_ADD_ERROR;
			 aux_free_PemDekLocal(&new_);
			return((PemDekLocal *) 0);
		}

	}

	return(new_);
}
/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_PemRecLocal
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_PemRecLocal *aux_cpy_SET_OF_PemRecLocal(
	SET_OF_PemRecLocal	 *old
)

#else

SET_OF_PemRecLocal *aux_cpy_SET_OF_PemRecLocal(
	old
)
SET_OF_PemRecLocal	 *old;

#endif

{
	SET_OF_PemRecLocal *new_ = (SET_OF_PemRecLocal *)0, *new_2;

	while(old) {
		if(new_) {
			if(!(new_2->next = ( SET_OF_PemRecLocal *)calloc(1, sizeof( SET_OF_PemRecLocal)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_SET_OF_PemRecLocal(&new_);
				return( (SET_OF_PemRecLocal *) 0);
			}
			new_2 = new_2->next;
		}
		else {
			if(!(new_2 = ( SET_OF_PemRecLocal *)calloc(1, sizeof( SET_OF_PemRecLocal)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_SET_OF_PemRecLocal(&new_);
				return( (SET_OF_PemRecLocal *) 0);
			}
			new_ = new_2;
		}
		new_2->next = (SET_OF_PemRecLocal *)0;
		new_2->element = aux_cpy_PemRecLocal(old->element);
		if(old->element && !new_2->element) {
			AUX_ADD_ERROR;
			 aux_free_SET_OF_PemRecLocal(&new_);
			return((SET_OF_PemRecLocal *) 0);
		}
		old = old->next;
	}

	return(new_);
}
/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_CRLWithCertificates
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_CRLWithCertificates *aux_cpy_SET_OF_CRLWithCertificates(
	SET_OF_CRLWithCertificates	 *old
)

#else

SET_OF_CRLWithCertificates *aux_cpy_SET_OF_CRLWithCertificates(
	old
)
SET_OF_CRLWithCertificates	 *old;

#endif

{
	SET_OF_CRLWithCertificates *new_ = (SET_OF_CRLWithCertificates *)0, *new_2;

	while(old) {
		if(new_) {
			if(!(new_2->next = ( SET_OF_CRLWithCertificates *)calloc(1, sizeof( SET_OF_CRLWithCertificates)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_SET_OF_CRLWithCertificates(&new_);
				return( (SET_OF_CRLWithCertificates *) 0);
			}
			new_2 = new_2->next;
		}
		else {
			if(!(new_2 = ( SET_OF_CRLWithCertificates *)calloc(1, sizeof( SET_OF_CRLWithCertificates)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_SET_OF_CRLWithCertificates(&new_);
				return( (SET_OF_CRLWithCertificates *) 0);
			}
			new_ = new_2;
		}
		new_2->next = (SET_OF_CRLWithCertificates *)0;
		new_2->element = aux_cpy_CRLWithCertificates(old->element);
		if(old->element && !new_2->element) {
			AUX_ADD_ERROR;
			 aux_free_SET_OF_CRLWithCertificates(&new_);
			return((SET_OF_CRLWithCertificates *) 0);
		}
		old = old->next;
	}

	return(new_);
}
/***************************************************************
 *
 * Procedure aux_cpy_CRLWithCertificates
 *
 ***************************************************************/
#ifdef __STDC__

CRLWithCertificates *aux_cpy_CRLWithCertificates(
	CRLWithCertificates	 *old
)

#else

CRLWithCertificates *aux_cpy_CRLWithCertificates(
	old
)
CRLWithCertificates	 *old;

#endif

{
	CRLWithCertificates *new_ = (CRLWithCertificates *)0;

	if(old) {
		if(!(new_ = ( CRLWithCertificates *)calloc(1, sizeof( CRLWithCertificates)))) {
			aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
			return( (CRLWithCertificates *) 0);
		}

		new_->crl = aux_cpy_CRL(old->crl);

		if(old->crl && !new_->crl) {
			AUX_ADD_ERROR;
			 aux_free_CRLWithCertificates(&new_);
			return((CRLWithCertificates *) 0);
		}


		new_->certificates = aux_cpy_Certificates(old->certificates);

		if(old->certificates && !new_->certificates) {
			AUX_ADD_ERROR;
			 aux_free_CRLWithCertificates(&new_);
			return((CRLWithCertificates *) 0);
		}


	}

	return(new_);
}
/***************************************************************
 *
 * Procedure aux_cpy_PemRecLocal
 *
 ***************************************************************/
#ifdef __STDC__

PemRecLocal *aux_cpy_PemRecLocal(
	PemRecLocal	 *old
)

#else

PemRecLocal *aux_cpy_PemRecLocal(
	old
)
PemRecLocal	 *old;

#endif

{
	PemRecLocal *new_ = (PemRecLocal *)0;

	if(old) {
		if(!(new_ = ( PemRecLocal *)calloc(1, sizeof( PemRecLocal)))) {
			aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
			return( (PemRecLocal *) 0);
		}

		new_->enc_alg = aux_cpy_AlgId(old->enc_alg);

		if(old->enc_alg && !new_->enc_alg) {
			AUX_ADD_ERROR;
			 aux_free_PemRecLocal(&new_);
			return((PemRecLocal *) 0);
		}

		new_->dek = aux_cpy_BitString(old->dek);

		if(old->dek && !new_->dek) {
			AUX_ADD_ERROR;
			 aux_free_PemRecLocal(&new_);
			return((PemRecLocal *) 0);
		}

		new_->certificate = aux_cpy_Certificate(old->certificate);

		if(old->certificate && !new_->certificate) {
			AUX_ADD_ERROR;
			 aux_free_PemRecLocal(&new_);
			return((PemRecLocal *) 0);
		}


	}

	return(new_);
}
/***************************************************************
 *
 * Procedure aux_cpy_PemMicLocal
 *
 ***************************************************************/
#ifdef __STDC__

PemMicLocal *aux_cpy_PemMicLocal(
	PemMicLocal	 *old
)

#else

PemMicLocal *aux_cpy_PemMicLocal(
	old
)
PemMicLocal	 *old;

#endif

{
	PemMicLocal *new_ = (PemMicLocal *)0;

	if(old) {
		if(!(new_ = ( PemMicLocal *)calloc(1, sizeof( PemMicLocal)))) {
			aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
			return( (PemMicLocal *) 0);
		}

		new_->PEM_conformant = old->PEM_conformant;

		new_->signAI = aux_cpy_AlgId(old->signAI);

		if(old->signAI && !new_->signAI) {
			AUX_ADD_ERROR;
			 aux_free_PemMicLocal(&new_);
			return((PemMicLocal *) 0);
		}

		new_->mic = aux_cpy_BitString(old->mic);

		if(old->mic && !new_->mic) {
			AUX_ADD_ERROR;
			 aux_free_PemMicLocal(&new_);
			return((PemMicLocal *) 0);
		}
	}

	return(new_);
}






/***************************************************************
 *
 * Procedure aux_get_abs_path
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_get_abs_path(
	char	 *path,
	char	 *file
)

#else

char *aux_get_abs_path(
	path,
	file
)
char	 *path;
char	 *file;

#endif

{
	char 	*abs_path,
		*abs_filepath,
		*proc = "aux_get_abs_path";


	if(!(abs_path = aux_cat_paths(getenv("HOME"), path))) {
		AUX_ADD_ERROR;
		return(CNULL);
	}
	if(!(abs_filepath = aux_cat_paths(abs_path, file))) {
		AUX_ADD_ERROR;
		return(CNULL);
	}
	free(abs_path);

	return(abs_filepath);

}



#ifdef SINIX

/*  This extension includes routines for SECUDE, which are not available
 *  on a MX300i.
 *
 *  Author: M. Munzert, SIEMENS AG, ZFE ST SN 5
 *  Date:   20.4.93
 */


#include <unistd.h>          /* setruid */


/* set (real) uid */

int setruid(uid_t uid)
{
  /* this routine may cause errors !!! */
  return (setuid(uid));
}

/* string compare, not case sensitive */

/***************************************************************
 *
 * Procedure strcasecmp
 *
 ***************************************************************/
/*
#ifdef __STDC__

int strcasecmp(
	char	 *s1,
	char	 *s2
)

#else

int strcasecmp(
	s1,
	s2
)
char	 *s1;
char	 *s2;

#endif

{
   not yet implemented: defined in C-Library for SunOS or HP-UX
  printf("\n strcasecmp !!!\n");
  return (strcmp(s1,s2));
}
*/

#endif


	
/***************************************************************
 *
 * Procedure aux_sappend_char
 *
 ***************************************************************/

#ifdef __STDC__

RC aux_sappend_char(
	OctetString	  *string,
	char      *format,
	...
)

#else 

RC aux_sappend_char(
	string,
	format,
	va_alist
)
OctetString	 *string;
char     *format;
va_dcl

#endif

{
	va_list args;
	int i;
	char tmp[1000];
	char *proc = "aux_sappend_char";

#ifdef __STDC__
	va_start(args, format);
#else 
	va_start(args);
#endif
	vsprintf(tmp, format, args);
	va_end(args);

	if(!string) {
		aux_add_error(EINVALID, "No OctetString given", CNULL, 0, proc);
		return(-1);
	}
	if(aux_append_char(string, tmp) < 0)  {
		AUX_ADD_ERROR;
		return(-1);
	}


	return(0);
}


/***************************************************************
 *
 * Procedure aux_get_nextUpdate
 *
 ***************************************************************/
#ifdef __STDC__

UTCTime *aux_get_nextUpdate(
	UTCTime	 *lastUpdate
)

#else

UTCTime *aux_get_nextUpdate(
	lastUpdate
)
UTCTime	 *lastUpdate;

#endif

{
	T_REC   * delta_rec;
	char    * timetype;
	char    * time, *readable_time;
	UTCTime * nextUpdate;
	char    * proc = "aux_get_nextUpdate";

	if (!lastUpdate) {
		aux_add_error(EINVALID, "lastUpdate missing", CNULL, 0, proc);
		return (CNULL);
	}

nextupdate:
	fprintf(stderr, "\nSpecify the next scheduled date of issue for your revocation list:\n");
	fprintf(stderr, "Date of issue: \n");
	fprintf(stderr, "   ABSOLUTE or\n");
        readable_time = aux_readable_UTCTime(lastUpdate);
	fprintf(stderr, "   RELATIVE to %s ?\n", readable_time);
	if(readable_time) free(readable_time);
	fprintf(stderr, "(A/R) (CR for R):  "); 
	timetype = gets((char *)malloc(2));
	if(strlen(timetype) == 0) {
		free(timetype);
		timetype = "R";
	}
	if ((*timetype != 'A') && (*timetype != 'R')) {
		fprintf(stderr, "Type must me either 'A' or 'R'\n");
		free(timetype);
		goto nextupdate;
	}
	if (*timetype == 'R') {
		if ( !(delta_rec = (T_REC *)malloc(sizeof(T_REC))) ) {
			aux_add_error(EMALLOC, "delta_rec", CNULL, 0, proc);
			return (CNULL);
		}
		fprintf(stderr, "\nThe revocation list should be valid (from %s)\n", aux_readable_UTCTime(lastUpdate));

		fprintf(stderr, "\n Number of years? (CR for 0)   ");
                time = gets((char *)malloc(3));
		if(strlen(time) == 0) delta_rec->year = 0;
		else delta_rec->year = atoi(time);
		free(time);

		fprintf(stderr, " Number of months (1 month = 30 days)? (CR for 0)   ");
                time = gets((char *)malloc(3));
		if(strlen(time) == 0) delta_rec->mon = 0;
		else delta_rec->mon = atoi(time);
		free(time);

		fprintf(stderr, " Number of days? (CR for 0)   ");
                time = gets((char *)malloc(3));
		if(strlen(time) == 0) delta_rec->day = 0;
		else delta_rec->day = atoi(time);
		free(time);

		fprintf(stderr, " Number of hours? (CR for 0)   ");
                time = gets((char *)malloc(3));
		if(strlen(time) == 0) delta_rec->hour = 0;
		else delta_rec->hour = atoi(time);
		free(time);

		fprintf(stderr, " Number of minutes? (CR for 0)   ");
                time = gets((char *)malloc(3));
		if(strlen(time) == 0) delta_rec->minu = 0;
		else delta_rec->minu = atoi(time);
		free(time);

		fprintf(stderr, " Number of seconds? (CR for 0)   ");
                time = gets((char *)malloc(3));
		if(strlen(time) == 0) delta_rec->sec = 0;
		else delta_rec->sec = atoi(time);
		free(time);

		fprintf(stderr, "\n");
		if ((delta_rec->year == 0) && (delta_rec->mon == 0) && (delta_rec->day == 0)
		    && (delta_rec->hour == 0) && (delta_rec->minu == 0) && (delta_rec->sec == 0)) {
			fprintf(stderr, "\nNo nextUpdate specified!\n");
			goto nextupdate;
		}
		nextUpdate = aux_delta_UTCTime_T_REC(lastUpdate, delta_rec);	
	}
	else {
		fprintf(stderr, "\nnextUpdate? (e.g. 8902232100+0100) ");
		nextUpdate = (UTCTime *)malloc(40);
		if (!nextUpdate) {
			aux_add_error(EMALLOC, "nextUpdate", CNULL, 0, proc);
			fprintf(stderr, "Can't allocate memory");
			return (CNULL);
		}
		if ( !gets(nextUpdate) || !nextUpdate[0] ) {
			fprintf(stderr, "\nNo nextUpdate specified!\n");
			free (nextUpdate);
			return (CNULL);
		}
		if (aux_cmp_UTCTime(lastUpdate, nextUpdate)) {
			fprintf(stderr, "\n\nERROR: nextUpdate earlier than lastUpdate!\n");
			free (nextUpdate);
			free(timetype);
			goto nextupdate;
		}
	}
	return (nextUpdate);
}

/***************************************************************
 *
 * Procedure get_date_of_expiry
 *
 * for isode
 *
 ***************************************************************/
#ifdef __STDC__

UTCTime *get_date_of_expiry(
)

#else

UTCTime *get_date_of_expiry(
)

#endif

{
	return(aux_delta_UTCTime((UTCTime )0, 600)); /* 10 Minuten */

}
/***************************************************************
 *
 * Procedure aux_file_type
 *
 * for isode
 *
 ***************************************************************/
#ifdef __STDC__

FILE_Type aux_file_type(
	char *path
)

#else

FILE_Type aux_file_type(
	path
)
char *path;

#endif

{
	static struct stat buf;

	if(path) {
		if(!stat(path, &buf)) {
			if((buf.st_mode & S_IFMT) == S_IFDIR) return(F_DIRECTORY);
			if((buf.st_mode & S_IFMT) == S_IFREG) return(F_FILE);
			return(F_OTHER);
		}
		else {
			if(errno == ENOENT) return(F_NOT_EXISTING);
			else return(F_ERROR);
		}
	}
	else return(F_ERROR);

}
#ifdef __STDC__

char *aux_getpass(
	char *output
)

#else

char *aux_getpass(
	output
)
char *output;


#endif



{


	return(aux_cpy_String(getpass(output)));

}
