#!/bin/sh

# $Id: find_top_level.sh,v 1.13 1995/03/01 10:54:21 koletzki Exp $

# $Log: find_top_level.sh,v $
 
#
#  
#


package=$1
cm=$2
verbose=$3

case $package in
	ISODE)
		types="LIB INCLUDE"
		search=dish
		select=X500
		echo "include/config.h src/h/config.h include/isode/config.h" > config/TESTFILES.INCLUDE
		echo "lib/libisode.a" > config/TESTFILES.LIB
		;;
	MOTIF)
		types="LIB INCLUDE"
		search=uil
		select=XMST
		echo "include/Xm" > config/TESTFILES.INCLUDE
		echo "lib/libXm.so" > config/TESTFILES.LIB
#		echo "bin/uil bin/X11/uil" > config/TESTFILES.BIN
		;;
esac

echo "You selected $select which requires a $package installation."
for type in $types
do
	if [ ! -f config/$package-$type.save ]
	then
		echo "Try to find the pathname of your $package $type directory ..."
	
	
		if [ "$pathname" = "" ]; then
			for type2 in $types
			do
				if [ -f config/$package-$type2.save ]; then
					pathname=`cat config/$package-$type2.save`
				fi
			done
		fi
		if [ "$pathname" = "" ]; then
			answ=`type $search`
			case $answ in
				$search\ not\ found)
					;;
				$search\ is\ *)
					pathname=`echo $answ | (read w1 w2 w3;echo $w3)`
					;;
			esac
		fi
		testfiles=`cat config/TESTFILES.$type`
		if [ "$pathname" != "" ]; then
			pathname=`config/find_path.sh $pathname $testfiles`
			if [ "$pathname" != "" ]; then
				pathname=`dirname $pathname`
			fi
		fi
#					if [ "$pathname" != "" ]; then
#						echo "... found $pathname"
#					fi
					echo "$pathname" > config/$package-$type.save
		found=no
	
		ret=2
		while [ $ret = "2" ]
		do
			if [ "$pathname" != "" -a \( -d "$pathname" \) ];
			then
				config/found.sh $package $verbose $pathname $type
			else 
				config/not_found.sh $package $verbose $found $type
			fi
			ret=$?
			if [ $ret = "1" ] 
			then
				rm -f config/$package-$type.save
				exit 1
			fi
			pathname=`cat config/$package-$type.save`
	
			found=yes
		done
		echo "$package$type = $pathname" >> $cm
		echo "... $package $type directory is $pathname (saved in config/$package-$type.save)"
	
	else
		pathname=`cat config/$package-$type.save`
		echo "$package$type = $pathname" >> $cm
		echo "$package $type directory is $pathname (from config/$package-$type.save)"
	fi
done
rm -f config/TESTFILES.*
