/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include "asm_ctl.h"

#define parm_a %i0
#define parm_b %i1
#define cont_a %l0
#define cont_b %l1

#define parm_s %i2
#define cont_s %l2
#define sum %l3
#define cnt %l4
#define res %l5
#define carry %l6






/*      _add()     translated version of _add() in add.c

	sparc-assembler

	Thomas Surkau 24.5.91           */





	ENTRY(_add)    ! C function definition
	PROLOGUE(0)     ! save regs, no additional stack





/* if lngofln(ax)... */
	ld [parm_a], cont_a
	ld [parm_b], cont_b
	cmp cont_a, cont_b
	bge   L$I_swap
	nop 
	mov parm_a, sum
	mov parm_b, parm_a
	mov sum, parm_b
	L$I_swap :
	L$B_swap :


/* cnt=...*/
	ld [parm_b], cnt
	ld [parm_a], cont_a
	sub cont_a, cnt, res
	mov parm_s, sum
	st cont_a, [parm_s]

	clr carry

/* loop cnt>0...*/


	tst cnt
	be L$B_loop1
	nop
	L$C_loop1 :

/* ++ */
	inc 4, parm_a
	inc 4, parm_b
	inc 4, sum

/* *Ap */
	ld [parm_a], cont_a
	ld [parm_b], cont_b

/* get CF  */
	cmp %g0, carry

/* cadd  */
	addxcc cont_a, cont_b, cont_s
	st cont_s, [sum]

/* save CF */
	addx %g0, %g0, carry
	deccc cnt
	bne  L$C_loop1
	nop
	L$B_loop1 :



/* loop carry &&... */
	tst carry
	be L$B_loop2
	nop
	tst res
	be L$B_loop2
	nop
	L$C_loop2 :

/* ++ */
	inc 4, parm_a
	inc 4, sum

/* *Ap  */
	ld [parm_a], cont_a

/* cadd  */
	addcc cont_a, carry, cont_s
	st cont_s, [sum]

/* save CF  */
	addx %g0,%g0,carry

	
/* overflow ? */
	bcc L$B_loop2
	nop
	deccc res
	bne  L$C_loop2
	nop
	L$B_loop2 :



/* if Sp != Ap */
	cmp parm_a, sum
	be   L$I_equallength
	nop 

	tst res
	be L$B_loop3
	nop
	L$C_loop3 :

/* ++ */
	inc 4, parm_a
	inc 4, sum

/* copy */
	ld [parm_a], cont_a
	st cont_a, [sum]
	deccc res
	bne  L$C_loop3
	nop
	L$B_loop3 :

	L$I_equallength :
	L$B_equallength :


/* sum longer than a */
	tst carry
	be   L$I_longer
	nop 
	inc 4, sum
	st carry, [sum]
	ld [parm_s], cont_s
	inc cont_s
	st cont_s, [parm_s]
	L$I_longer :
	L$B_longer :

	EPILOGUE








#define parm_d %i2
#define cont_d %l2
#define dp %l3
#define opa %l7



/*      _sub()     translated version of _sub() in add.c

	sparc-assembler

	Thomas Surkau 24.5.91           */






	ENTRY(_sub)    ! C function definition
	PROLOGUE(0)     ! save regs, no additional stack

	mov parm_a, opa
	mov parm_d, dp
	clr carry


	ld [parm_a], cont_a
	ld [parm_b], cont_b







	ld [parm_b], cnt
	ld [parm_a], cont_a
	sub cont_a, cnt, res

	tst cnt
	be L$B_loops1
	nop
	L$C_loops1 :

/* ++ */
	inc 4, parm_a
	inc 4, parm_b
	inc 4, parm_d

/*  *Ap  */
	ld [parm_a], cont_a
	ld [parm_b], cont_b

/* get CF  */
	cmp %g0, carry
/* cadd  */

	subxcc cont_a, cont_b, cont_d
	st cont_d, [parm_d]

/* save CF  */
	addx %g0,%g0,carry
	deccc cnt
	bne  L$C_loops1
	nop
	L$B_loops1 :

	tst carry
	be L$B_loops2
	nop
	tst res
	be L$B_loops2
	nop
	L$C_loops2 :
	inc 4, parm_a
	inc 4, parm_d
	ld [parm_a], cont_a

/* cadd  */
	subcc cont_a, carry, cont_d
	st cont_d, [parm_d]

/* save CF */
	addx %g0,%g0,carry

	
/* overflow ? */
	bcc L$B_loops2
	nop
	deccc res
	bne  L$C_loops2
	nop
	L$B_loops2 :






/* if Sp != Ap */
	cmp parm_a, parm_d
	be   L$I_equallengths
	nop 

	tst res
	be L$B_loops3
	nop
	L$C_loops3 :

/* ++ */
	inc 4, parm_a
	inc 4, parm_d

/* copy */
	ld [parm_a], cont_a
	st cont_a, [parm_d]
	deccc res
	bne  L$C_loops3
	nop
	L$B_loops3 :

	L$I_equallengths :
	L$B_equallengths :









	ld [opa], cnt
	sll cnt, 2, opa
	add dp, opa, parm_d


	L$C_loops4 :
	cmp parm_d, dp
	ble L$B_loops4
	nop
	ld [parm_d], cont_d
	tst cont_d
	bne L$B_loops4
	nop
	dec cnt
	dec 4, parm_d
	
	ba  L$C_loops4
	nop
	L$B_loops4 :

	st cnt, [dp]

	EPILOGUE








