/* ./src/crypt/arithmetic/std/dmult.c */

static char *rcsid = "$Header: /home/secude/new_release/secude/src/crypt/arithmetic/std/RCS/dmult.c,v 1.4 1994/11/10 16:38:21 schneiw Exp $";

/* 
 *
 * $Header: /home/secude/new_release/secude/src/crypt/arithmetic/std/RCS/dmult.c,v 1.4 1994/11/10 16:38:21 schneiw Exp $
 *
 * $Log: dmult.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include "arithmetic.h"

char * dmult_string = "dmult: %x * %x = %x (HIGH), %x (LOW) \n";

/***************************************************************
 *
 * Procedure _dmult
 *
 ***************************************************************/
#ifdef __STDC__

void _dmult(
	L_NUMBER	  a,
	L_NUMBER	  b,
	L_NUMBER	 *high,
	L_NUMBER	 *low
)

#else

void _dmult(
	a,
	b,
	high,
	low
)
L_NUMBER	  a;
L_NUMBER	  b;
L_NUMBER	 *high;
L_NUMBER	 *low;

#endif

{
	register L_NUMBER al, ah, bl, bh;
	L_NUMBER m1, m2, m, ml, mh, carry = 0;

	al = a & LSHALF;
	ah = a >> (SIZEOFINT / 2);
	bl = b & LSHALF;
	bh = b >> (SIZEOFINT / 2);

	*low = al*bl;
	*high = ah*bh;

	m1 = al*bh;
	m2 = ah*bl;
	m = m1 + m2;
	if(m < m1) carry = 1 << (SIZEOFINT / 2);

	ml = (m & LSHALF) << (SIZEOFINT / 2);
	mh = m >> (SIZEOFINT / 2);

	*low += ml;
	if(*low < ml) carry++;

	*high += carry + mh;
#ifdef ARITHMETIC_TEST
				if(arithmetic_trace_counter) {
 					arithmetic_trace_counter--;
					fprintf(arithmetic_trace, dmult_string, a, b, *high, *low);
				}
#endif
	return;
}
