/* ./src/crypt/des/getpass.c */

static char *rcsid = "$Id: getpass.c,v 1.3 1994/11/02 10:44:39 surkau Exp $";

/* 
 *
 * $Id: getpass.c,v 1.3 1994/11/02 10:44:39 surkau Exp $
 *
 * $Log: getpass.c,v $
 *
 */
 
#include <stdio.h>
#include <signal.h>
#include <sgtty.h>

#define	TTY	"/dev/tty"	/* Change to "con" for MS-DOS */

/* Issue prompt and read reply with echo turned off */
/***************************************************************
 *
 * Procedure getpass
 *
 ***************************************************************/
#ifdef __STDC__

char *getpass(
	char	 *prompt
)

#else

char *getpass(
	prompt
)
char	 *prompt;

#endif

{
	struct sgttyb ttyb,ttysav;
	register char *cp;
	int c;
	FILE *tty;
	static char pbuf[128];
	int (*signal())(),(*sig)();

	if ((tty = fdopen(open(TTY, 2), "r")) == NULL)
		tty = stdin;
	else
		setbuf(tty, (char *)NULL);
	sig = signal(SIGINT, SIG_IGN);
	ioctl(fileno(tty), TIOCGETP, &ttyb);
	ioctl(fileno(tty), TIOCGETP, &ttysav);
	ttyb.sg_flags |= RAW;
	ttyb.sg_flags &= ~ECHO;
	ioctl(fileno(tty), TIOCSETP, &ttyb);
	fprintf(stderr, "%s", prompt);
	fflush(stderr);
	cp = pbuf;
	for (;;) {
		c = getc(tty);
		if(c == '\r' || c == '\n' || c == EOF)
			break;
		if (cp < &pbuf[127])
			*cp++ = c;
	}
	*cp = '\0';
	fprintf(stderr,"\r\n");
	fflush(stderr);
	ioctl(fileno(tty), TIOCSETP, &ttysav);
	signal(SIGINT, sig);
	if (tty != stdin)
		fclose(tty);
	return(pbuf);
}
