/* ./src/crypt/dh/dh.c */

static char *rcsid = "$Id: dh.c,v 1.11 1995/03/07 12:07:18 surkau Exp $";

/* 
 *
 * $Id: dh.c,v 1.11 1995/03/07 12:07:18 surkau Exp $
 *
 * $Log: dh.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include <stdio.h>
#include "arithmetic.h"

extern int primes[];    /* Die ersten 1000 Primzahlen          */


#ifdef TRACE_ALL
#define TRACE_DH
#endif

#define InitDH { if(sec_verbose || sec_gen_verbose) {fprintf(stderr,"DH Agreement Parameter generation"); fflush(stderr);} }
#define PrintRabinstest { if(sec_verbose || sec_gen_verbose)	\
				{if(cnt % 16 == 0) fprintf(stderr,"*"); if(cnt % 640 == 639) fprintf(stderr,"\n"); fflush(stderr);cnt++;} }
#define EndGeneration { if(sec_verbose || sec_gen_verbose) {fprintf(stderr,"\n"); fflush(stderr);} }
#define Sorry { if(sec_verbose || sec_gen_verbose) {fprintf(stderr,"\nSorry: again."); fflush(stderr);} }
#define StartGeneration(s) { if(sec_verbose || sec_gen_verbose) {cnt=0;fprintf(stderr,"\nGenerating "); fprintf(stderr,s); fflush(stderr);} }


/***************************************************************
 *
 * Procedure parm2ln
 *
 * extract sequence of 2 integers from parm of algid
 *
 ***************************************************************/
#ifdef __STDC__

static RC parm2ln(
	AlgId		 *algid,
	L_NUMBER	 *p,
	L_NUMBER	 *g,
	int		 *l
)

#else

static RC parm2ln(
	algid,
	p,
	g,
	l
)
AlgId		 *algid;
L_NUMBER	 *p;
L_NUMBER	 *g;
int	 	 *l;

#endif

{
	char 	       *proc = "parm2ln";
	unsigned char  *octs;
	int		n;

	if(!g || !p || !l) {
		global_add_error(EINVALID, "NULL parameter given", CNULL, 0, proc);
		return(-1);
	}
	if(!algid) {
		global_add_error(EINVALID, "No Algorithm found", CNULL, 0, proc);
		return(-1);
	}
	if(aux_cmp_ObjId(algid->objid, dhKeyAgreement->objid) ) {
		global_add_error(EALGID, "Algorithm is not dhKeyAgreement", (char *)algid, AlgId_n, proc);
		return(-1);
	}
	if(!algid->param
		|| !((KeyBits *)algid->param)->part1.noctets
		|| !((KeyBits *)algid->param)->part2.noctets
		|| ((KeyBits *)algid->param)->part3.noctets > 4) {
		global_add_error(EALGID, "parameter of dhKeyAgreement algorithm is wrong", CNULL, 0, proc);
		return(-1);
	}


	INTEGERtoln(&((KeyBits *)algid->param)->part1, p);
	INTEGERtoln(&((KeyBits *)algid->param)->part2, g);

	*l = 0;
	if(((KeyBits *)algid->param)->part3.noctets) *l = aux_OctetString2int(&(((KeyBits *)algid->param)->part3));
	return(0);

}
/***************************************************************
 *
 * Procedure ln2parm
 *
 * store sequence of 3 integers into parm of algid
 *
 ***************************************************************/
#ifdef __STDC__

static KeyBits *ln2parm(
	L_NUMBER	 *p,
	L_NUMBER	 *g,
	int		  privateValueLength
)

#else

static KeyBits *ln2parm(
	p,
	g,
	privateValueLength
)
L_NUMBER	 *p;
L_NUMBER	 *g;
int		  privateValueLength;

#endif

{
	char 		*proc = "ln2parm";
	BitString 	*bits;
	KeyBits         *param;
	L_NUMBER	 l[2];

	l[0] = 1;
	l[1] = privateValueLength;

	if(!(param = (KeyBits *) calloc(1, sizeof(KeyBits)))) {
		global_add_error(EMALLOC, "param", CNULL, 0, proc);
		return((KeyBits *)0);
	}


	if(!(param->part1.octets =  malloc(p[0] * WBYTES))) {
		global_add_error(EMALLOC, "param->part1.octets", CNULL, 0, proc);
		free(param);
		return((KeyBits *)0);
	}
	lntoINTEGER(p, &(param->part1));


	if(!(param->part2.octets =  malloc(g[0] * WBYTES))) {
		global_add_error(EMALLOC, "param->part2.octets", CNULL, 0, proc);
		free(param);
		free(param->part1.octets);
		return((KeyBits *)0);
	}
	lntoINTEGER(g, &(param->part2));


	if(privateValueLength) {
		if(!(param->part3.octets =  malloc(l[0] * WBYTES))) {
			global_add_error(EMALLOC, "param->part3.octets", CNULL, 0, proc);
			free(param);
			free(param->part1.octets);
			free(param->part2.octets);
			return((KeyBits *)0);
		}
		lntoINTEGER(l, &(param->part3));
	}
	else {
		param->part3.octets = CNULL;
		param->part3.noctets = 0;
	}


	param->part4.octets = CNULL;
	param->part4.noctets = 0;

	return(param);

}

/***************************************************************
 *
 * Procedure test35711
 *
 * tests if a number is dividable by the first 19 primes,
 * is used to avoid a slower prime test in most cases
 *
 ***************************************************************/
#ifdef __STDC__

static int test35711(
	L_NUMBER	  p[]
)

#else

static int test35711(
	p
)
L_NUMBER	  p[];

#endif

{
	unsigned int 	n,
			m3 = 0,
			m5 = 0;
	L_NUMBER 	d[2];
	L_NUMBER 	r[2];
	L_NUMBER 	t[MAXGENL];

	if(p[0] == 1 && p[1] <= 71 && ( p[1] ==  3 || p[1] ==  5 || p[1] ==  7 || p[1] == 11 ||
					p[1] == 13 || p[1] == 17 || p[1] == 19 || p[1] == 23 ||
					p[1] == 29 || p[1] == 31 || p[1] == 37 || p[1] == 41 ||
					p[1] == 43 || p[1] == 47 || p[1] == 53 || p[1] == 59 ||
					p[1] == 61 || p[1] == 67 || p[1] == 71)) return(2);

	for(n = 1; n<=p[0]; n++) m3 += p[n] % 3;
	
	if(!(m3 % 3)) return(0);

	for(n = 1; n<=p[0]; n++) m5 += p[n] % 5;

	if(!(m5 % 5)) return(0);


	d[0] = 1;

#if SIZEOFINT == 32
	d[1] = 7*11*13*17*19*23*29;
	div(p,d,t,r);

	for(n=2;n<9; n++) 
		if(!(r[1] % primes[n])) return(0);
	

	d[1] = 31*37*41*43*47;
	div(p,d,t,r);

	for(n=9;n<14; n++) 
		if(!(r[1] % primes[n])) return(0);
	

	d[1] = 53*59*61*67*71;
	div(p,d,t,r);

	for(n=14;n<19; n++) 
		if(!(r[1] % primes[n])) return(0);
	
#else
	d[1] = 7*11*13*17;
	div(p,d,t,r);

	for(n=2;n<6; n++) 
		if(!(r[1] % primes[n])) return(0);
	

	d[1] = 19*23*29;
	div(p,d,t,r);

	for(n=6;n<9; n++) 
		if(!(r[1] % primes[n])) return(0);
	
	d[1] = 31*37*41;
	div(p,d,t,r);

	for(n=9;n<12; n++) 
		if(!(r[1] % primes[n])) return(0);
	

#endif

	return(1);
}

/***************************************************************
 *
 * Procedure create_p_g
 *
 * creates number p, g where
 *
 * p is a prime of DH_SIZE_p bits
 * p-1 is dividable by a prim q of DH_SIZE_q bits
 * g has order >= q (mod p)
 * 
 *
 ***************************************************************/
#ifdef __STDC__

static RC create_p_g(
	L_NUMBER	  p[],
	L_NUMBER	  g[],
	int	  	  size_of_p
)

#else

static RC create_p_g(
	p,
	g,
	size_of_p
)
L_NUMBER	  p[];
L_NUMBER	  g[];
int	  	  size_of_p;

#endif

{
	L_NUMBER	q[MAXGENL],
			test[MAXGENL],
			n[MAXGENL];

	int 		cnt, size_q;

	if(size_of_p <= 23) size_of_p = 24;

	size_q = size_of_p - 16;

	InitDH;

	p[0] = 0;

	do {

		if(p[0]) Sorry;

	/* generate random q */
	
		StartGeneration("q:     ");PrintRabinstest;
	
		sec_random_LN(q, size_q-1);
		q[1] |= 1;
	
	
	/* increment q by 2 until q is prime */
	
		while (!test35711(q) || rabinstest(q)<0) {
			PrintRabinstest;
			add(q, lz_zwei, q);
		}
	
	/* generate random n such that p = q*n+1 hat the right size */
	
		StartGeneration("p:     ");PrintRabinstest;
	
		/* 
		 * rndm(size_of_p - size_q, n);
		 * add(n, lz_eins, n);
		 */
		shift(lz_eins, size_of_p - size_q, n);	
	
		mult(q, n, p);
		add(p, lz_eins, p);
	
	/* increment p by 2q and n by 2 until p = q*n+1 is prime */
	
		while ((!test35711(p) || rabinstest(p)<0) && lngtouse(p)<size_of_p) {
			PrintRabinstest;
			add(p, q, p);
			add(p, q, p);
			add(n, lz_zwei, n);
		}
	
	} while(lngtouse(p) >= size_of_p);

/* generate random g */

	StartGeneration("g:     "); PrintRabinstest;

	sec_random_LN(g, size_of_p - 1);


	mexp(g, n, test, p);

/* increment g until g has order >= q   (mod p)*/

	while(!comp(test, lz_eins)) {
		PrintRabinstest;
		add(g, lz_eins, g);
		mexp(g, n, test, p);
	}
	div(g, p, g, g);
	EndGeneration;

	return(0);
}

/***************************************************************
 *
 * Procedure dh_init
 *
 * Generates the prime modulus p and the base g for DH key
 * agreement.
 *
 * Returns a AlgId with OID dhWithCommonModulus and KeyBits
 * parameter which comprises the three components p, g and 
 * private_value_length.
 *
 ***************************************************************/
#ifdef __STDC__

AlgId	*dh_init(
	int	  size_of_p,
	int	  private_value_length
)

#else

AlgId	*dh_init(
	size_of_p,
	private_value_length
)
int	  size_of_p;
int	  private_value_length;

#endif

{
	char 	 	*proc = "dh_init";

	L_NUMBER 	 p[MAXGENL];
	L_NUMBER 	 g[MAXGENL];
	AlgId		*dhparam;


	/* Generate p and g */

	create_p_g(p, g, size_of_p);

	if(!(dhparam = (AlgId *) calloc(1, sizeof(AlgId)))) {
		global_add_error(EMALLOC, "dhparam", CNULL, 0, proc);
		return((AlgId *)0);
	}
	dhparam->objid = aux_cpy_ObjId(dhKeyAgreement->objid);
	if(!(dhparam->param = (char *)ln2parm(p, g, private_value_length))) {
		global_add_error(LASTERROR, LASTTEXT, LASTADDR, proc);
		aux_free_AlgId(&dhparam);
		return((AlgId *) 0);
	}

	return(dhparam);
}


/***************************************************************
 *
 * Procedure dh_phase1
 * 
 * Generates a random private key X from the given (p,g)
 * and stores it according to key_x.
 *
 * Calculates Y from g, X and p.
 * 
 * Returns keyinfo with Y in keyinfo->subjectkey and
 * keyinfo->subjectAI = dhWithCommonModulus, if with_pg is FALSE, 
 * or
 * keyinfo->subjectAI = dhKeyAgreement, if with_pg is TRUE. 
 *
 ***************************************************************/
#ifdef __STDC__

KeyInfo *dh_phase1(
	AlgId	 *dhparam,
	KeyInfo	 **keyinfo_x,
	Boolean	  with_pg
)

#else

KeyInfo *dh_phase1(
	dhparam,
	keyinfo_x,
	with_pg
)
AlgId	 *dhparam;
KeyInfo	 **keyinfo_x;
Boolean	  with_pg;

#endif

{
	char 	 	*proc = "dh_phase1";

	L_NUMBER 	 p[MAXGENL];
	L_NUMBER 	 g[MAXGENL];
	L_NUMBER 	 X[MAXGENL];
	L_NUMBER 	 Y[MAXGENL];
	KeyInfo  	*keyinfo_y;
	int		 private_value_length, length_of_p, no_of_octets;

/* get (p,g) from dhparam */
	if(parm2ln(dhparam, p, g, &private_value_length) < 0) {
		global_add_error(LASTERROR, LASTTEXT, LASTADDR, proc);
		return((KeyInfo *)0);
	}
	length_of_p = lngtouse(p) + 1;
	no_of_octets = length_of_p / BYTEL + 1;


/* generate random X */
	rndm((private_value_length ? private_value_length - 1 : length_of_p - 1), X);

/* calculate Y */

	mexp(g, X, Y, p);


/* put X into a keyinfo */
	if(!(*keyinfo_x = (KeyInfo *)calloc(1, sizeof(KeyInfo)))) {
		global_add_error(EMALLOC, "calloc KeyInfo", CNULL, 0, proc);
		return((KeyInfo *)0);
	}

/* give it an AlgId according to with_pg */
	if(with_pg) (*keyinfo_x)->subjectAI = aux_cpy_AlgId(dhparam);
	else (*keyinfo_x)->subjectAI = aux_cpy_AlgId(dhWithCommonModulus);

/* convert X into a BitString */
	(*keyinfo_x)->subjectkey.nbits = 0;
	if(!((*keyinfo_x)->subjectkey.bits = malloc(no_of_octets))) {
		global_add_error(EMALLOC, "malloc BitString", CNULL, 0, proc);
		aux_free_KeyInfo(keyinfo_x);
		return((KeyInfo *)0);
	}


	if(aux_LN2BitString2(&(*keyinfo_x)->subjectkey, X, 0) < 0) {
		global_add_error(LASTERROR, LASTTEXT, LASTADDR, proc);
		return((KeyInfo *)0);
	}

	bzero(X,MAXGENL*WBYTES);



/* put Y into a keyinfo */
	if(!(keyinfo_y = (KeyInfo *)calloc(1, sizeof(KeyInfo)))) {
		global_add_error(EMALLOC, "calloc KeyInfo", CNULL, 0, proc);
		return((KeyInfo *)0);
	}

/* give it an AlgId according to with_pg */
	if(with_pg) keyinfo_y->subjectAI = aux_cpy_AlgId(dhparam);
	else keyinfo_y->subjectAI = aux_cpy_AlgId(dhWithCommonModulus);


/* convert Y into a BitString */
	if(aux_LN2BitString2(&keyinfo_y->subjectkey, Y, 0) < 0) {
		global_add_error(LASTERROR, LASTTEXT, LASTADDR, proc);
		return((KeyInfo *)0);
	}

	return(keyinfo_y);
}



/***************************************************************
 *
 * Procedure dh_phase2
 *
 * calculates the session key from (p,g), the own X and the peer Y,
 * and returns it in a BitString
 *
 ***************************************************************/
#ifdef __STDC__

BitString *dh_phase2(
	AlgId    *dhparam,
	KeyInfo	 *own_x,
	KeyInfo	 *peer_y
)

#else

BitString *dh_phase2(
	dhparam,
	own_x,
	peer_y
)
AlgId    *dhparam;
KeyInfo	 *own_x;
KeyInfo	 *peer_y;

#endif

{
	char 	 	*proc = "dh_phase2";

	L_NUMBER 	 p[MAXGENL];
	L_NUMBER 	 g[MAXGENL];
	L_NUMBER 	 X[MAXGENL];
	L_NUMBER 	 Y[MAXGENL];
	L_NUMBER   	 K[MAXGENL];

	BitString 	*agreed;
	AlgId           *dhparam_in_use;
	int		 private_value_length, length_of_p, no_of_octets;


/* determine DH parameters to be used for phase 2 */

	if(aux_cmp_ObjId(peer_y->subjectAI->objid, dhWithCommonModulus->objid) == 0) {

		/* peer_y has no DH parameter. 
                   use either DH parameter from own_x, if present, or from dhparam */

		if(aux_cmp_ObjId(own_x->subjectAI->objid, dhWithCommonModulus->objid) == 0) dhparam_in_use = dhparam;
		else if(aux_cmp_ObjId(own_x->subjectAI->objid, dhKeyAgreement->objid) == 0) dhparam_in_use = own_x->subjectAI;
		else {
			global_add_error(EALGID, "own_x has wrong algid", (char *)own_x->subjectAI, AlgId_n, proc);
			aux_free_KeyInfo(&own_x);
			return((BitString *)0);
		}
	}
	else if(aux_cmp_ObjId(peer_y->subjectAI->objid, dhKeyAgreement->objid) == 0) {

		/* peer_y has DH parameter. Check whether it fits to own_x */

		if(aux_cmp_ObjId(own_x->subjectAI->objid, dhKeyAgreement->objid) == 0) {

			/* own_x has DH parameter. Compare with DH parameter of peer_y */

			if(aux_cmp_AlgId(peer_y->subjectAI, own_x->subjectAI)) {

				/* doesn't fit */

				global_add_error(EINVALID, "DH parameter from peer_y doesn't fit to own_x", CNULL, 0, proc);
				aux_free_KeyInfo(&own_x);
				return((BitString *)0);
			}
		}
		else if(aux_cmp_ObjId(own_x->subjectAI->objid, dhWithCommonModulus->objid) == 0) {
			if(aux_cmp_AlgId(peer_y->subjectAI, dhparam)) {

				/* doesn't fit */

				global_add_error(EINVALID, "DH parameter from peer_y doesn't fit to default parameter", CNULL, 0, proc);
				aux_free_KeyInfo(&own_x);
				return((BitString *)0);
			}
		}
		else {
			global_add_error(EALGID, "own_x has wrong algid", CNULL, 0, proc);
			aux_free_KeyInfo(&own_x);
			return((BitString *)0);
		}
		dhparam_in_use = peer_y->subjectAI;
	}
	else {
		global_add_error(EALGID, "peer_y has wrong algid", CNULL, 0, proc);
		aux_free_KeyInfo(&own_x);
		return((BitString *)0);
	}

/* get X from KeyInfo *own_x */

	if(aux_BitString2LN2(X, &own_x->subjectkey) < 0) {
		global_add_error(LASTERROR, LASTTEXT, LASTADDR, proc);
		return((BitString *)0);
	}

	bzero(own_x->subjectkey.bits, (own_x->subjectkey.nbits + 7) / 8 );

/* get Y from KeyInfo *peer_y */

	if(aux_BitString2LN2(Y, &peer_y->subjectkey) < 0) {
		global_add_error(LASTERROR, LASTTEXT, LASTADDR, proc);
		return((BitString *)0);
	}

/* get p, g and l from dhparam_in_use */

	if(parm2ln(dhparam_in_use, p, g, &private_value_length) < 0) {
		global_add_error(LASTERROR, LASTTEXT, LASTADDR, proc);
		aux_free_KeyInfo(&own_x);
		return((BitString *)0);
	}
	aux_free_KeyInfo(&own_x);

	length_of_p = lngtouse(p) + 1;
	no_of_octets = length_of_p / BYTEL + 1;


/* calculate agreed key */

	mexp(Y, X, K, p);

	bzero(X, MAXGENL*WBYTES);

/* store agreed key in a Bitstring */


	if(!(agreed = aux_LN2BitString(K, length_of_p))) {
		global_add_error(LASTERROR, LASTTEXT, LASTADDR, proc);
		return((BitString *)0);
	}

	bzero(K, MAXGENL*WBYTES);

	return(agreed);
}

enum { DH_ENC_ALG_IDEA = 0, DH_ENC_ALG_DES_CBC, DH_ENC_ALG_DES_CBC3, DH_ENC_ALG_MASK = 7, DH_HASH = 8 };

char default_p[] = {-0x7, -0x7a, 0xf, 0x2f, 0x2c, 0x68, -0x2, 0x2, 0x69, -0x7a, 0x58, 0x5c, 0x0, 0x1b, 0x71, 0x34, 0x27, -0x3d, -0x54, -0x36, 0x4e, 0x59, -0x22, -0x40, -0x28, -0x5e, -0x5c, -0x63, -0x5e, -0x25, 0x4c, 0x78, -0x59, 0x7, 0x6b, -0x5f, 0x8, -0x20, -0x15, -0x42, -0x1a, -0x30, 0x36, -0x45, -0x46, 0x5d, 0x20, 0x2e, 0x25, -0x29, 0x43, 0x19, 0x71, 0x9, -0x3f, -0x4f, 0x23, 0x3, 0x70, 0x48, -0x5e, -0x7d, -0x4e, 0x21};

char default_g[] = {0x5, 0x23, -0x5d, 0x74, 0xf, 0x7b, 0x8, 0x44, 0x6, -0x59, -0x5, -0x16, 0x10, -0x6d, -0x46, 0x5f, -0x44, 0x1b, 0x30, -0x6e, -0x52, 0x5a, 0x42, 0x60, 0x11, -0x22, 0x36, 0x0, 0x6b, 0x4d, 0x24, -0x60, 0x5c, 0x78, 0x10, -0x60, 0x75, 0x5d, 0x20, 0x47, 0x32, 0x62, -0xf, -0x78, -0x7, -0x45, 0x0, 0x11, 0x10, -0x16, 0x7b, 0x6b, 0x5e, 0x65, -0x6f, -0x57, -0x18, -0x1b, 0x7b, 0x53, 0x65, 0x72, -0x4c, -0x5c};

struct DH_CONTEXT {
	L_NUMBER 	 p[MAXGENL];
	L_NUMBER 	 g[MAXGENL];
	L_NUMBER 	 X[MAXGENL];
	L_NUMBER 	 Y[MAXGENL];
	int	  	 private_value_length;
	int	  	 enc_mode;
	KeyInfo		 keyinfo;
	OctetString	 octetstring;
	BitString	 bitstring;
	char		*buf;
	int	  	 bufsize;
};
/***************************************************************
 *
 * Procedure dh_start
 *
 * Generates the prime modulus p and the base g for DH key
 * agreement.
 *
 *
 ***************************************************************/
#ifdef __STDC__

RC	dh_start(
	struct DH_CONTEXT **dh_ctx,
	int	  size_of_p,
	int	  private_value_length,
	int	  dh_parm_mode,
	int	  enc_mode
)

#else

RC	dh_start(
	dh_ctx,
	size_of_p,
	private_value_length,
	dh_parm_mode,
	enc_mode
)
struct DH_CONTEXT **dh_ctx;
int	  size_of_p;
int	  private_value_length;
int	  dh_parm_mode;
int       enc_mode;

#endif

{
	struct DH_CONTEXT *dh;
	OctetString        ostr;

	if(*dh_ctx) {
		global_add_error(EINVALID, "need an empty context", CNULL, 0, proc);
		return(-1);
	}

	if(!(dh = *dh_ctx = (struct DH_CONTEXT *)calloc(1, sizeof(struct DH_CONTEXT)))) {
		global_add_error(EMALLOC, "calloc DH_CONTEXT", CNULL, 0, proc);
		return(-1);
	}
	if(!(dh->buf = (char *)malloc(1000))) {
		global_add_error(EMALLOC, "calloc DH_CONTEXT", CNULL, 0, proc);
		return(-1);
	}
	if(!(dh->keyinfo.subjectkey.bits = (char *)malloc(17))) {
		global_add_error(EMALLOC, "calloc DH_CONTEXT", CNULL, 0, proc);
		return(-1);
	}
	dh->enc_mode = enc_mode;

	if(dh_parm_mode) create_p_g(dh->p, dh->g, size_of_p);
	else {
		/* 
		 * int n;
		 * OctetString *t_ostr;
		 * create_p_g(dh->p, dh->g, size_of_p);
		 * 
		 * t_ostr = aux_LN2OctetString(dh->p, 0);
		 * for(n=0; n<t_ostr->noctets;n++)
		 * if(t_ostr->octets[n]>=0) printf("0x%x, ",t_ostr->octets[n]);
		 * else printf("-0x%x, ",-t_ostr->octets[n]);
		 * printf("\n");
		 * t_ostr = aux_LN2OctetString(dh->g, 0);
		 * for(n=0; n<t_ostr->noctets;n++)
		 * if(t_ostr->octets[n]>=0) printf("0x%x, ",t_ostr->octets[n]);
		 * else printf("-0x%x, ",-t_ostr->octets[n]);
		 */

		ostr.octets = default_p;
		ostr.noctets = sizeof(default_p);
		INTEGERtoln(&ostr, dh->p);

		ostr.octets = default_g;
		ostr.noctets = sizeof(default_g);
		INTEGERtoln(&ostr, dh->g);
	}

	/* 
	 * if(dh_parm_mode == DH_PARM_COMMON_PREDEFINED) dh->transfer_param = FALSE;
	 * else dh->transfer_param = TRUE;
	 */

	dh->private_value_length = private_value_length;

	sec_random_LN(dh->X, private_value_length ? private_value_length : dh->p[0]*WLNG);

	mexp(dh->g, dh->X, dh->Y, dh->p);

#ifdef TRACE_DH
	{
		OctetString *t_ostr;
		fprintf(secude_trace_file, "--> dh_start\n");

		fprintf(secude_trace_file, "CTX:\n");

		fprintf(secude_trace_file, "p:\n");
		t_ostr = aux_LN2OctetString(dh->p, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "g:\n");
		t_ostr = aux_LN2OctetString(dh->g, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "X:\n");
		t_ostr = aux_LN2OctetString(dh->X, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "Y:\n");
		t_ostr = aux_LN2OctetString(dh->Y, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);
		fprintf(secude_trace_file, "pvl:\n");
		fprintf(secude_trace_file, "%d\n", dh->private_value_length);
		fprintf(secude_trace_file, "enc_mode:\n");
		fprintf(secude_trace_file, "%d\n", dh->enc_mode);

		fprintf(secude_trace_file, "<-- dh_start\n");
	}
#endif
	return(0);
}

/***************************************************************
 *
 * Procedure dh_connect
 *
 * Generates the prime modulus p and the base g for DH key
 * agreement.
 *
 *
 ***************************************************************/
#ifdef __STDC__

OctetString	*dh_connect(
	struct DH_CONTEXT **dh_ctx
)

#else

OctetString	*dh_connect(
	dh_ctx
)
struct DH_CONTEXT **dh_ctx;

#endif

{
	struct DH_CONTEXT *dh = *dh_ctx;
	OctetString        ostr;
	int 		   length = 0, pos;

	if(!dh) {
		if(dh_start(dh_ctx, 512, 64, FALSE, 0) < 0) {
			global_add_error(EINVALID, "Error creating a context", CNULL, 0, proc);
			return((OctetString *)0);
		}
		dh = *dh_ctx;
	}
	
	dh->buf[length++] = 0x1;

	ostr.octets = dh->buf+length+1;
	lntoctets((*dh_ctx)->p, &ostr, 0);
	dh->buf[length++] = ostr.noctets;
	length += ostr.noctets;


	ostr.octets = dh->buf+length+1;
	lntoctets((*dh_ctx)->g, &ostr, 0);
	dh->buf[length++] = ostr.noctets;
	length += ostr.noctets;

	dh->buf[length++] = 2;
	dh->buf[length++] = dh->private_value_length >> 8;
	dh->buf[length++] = dh->private_value_length & 0xff;


	ostr.octets = dh->buf+length+1;
	lntoctets((*dh_ctx)->Y, &ostr, 0);
	dh->buf[length++] = ostr.noctets;
	length += ostr.noctets;

	dh->buf[length++] = dh->enc_mode;

	dh->octetstring.octets = dh->buf;
	dh->octetstring.noctets = length;


#ifdef TRACE_DH
	{
		OctetString *t_ostr;
		fprintf(secude_trace_file, "--> dh_connect\n");

		fprintf(secude_trace_file, "out:\n");
		aux_fprint_OctetString(secude_trace_file, &dh->octetstring);

		fprintf(secude_trace_file, "CTX:\n");

		fprintf(secude_trace_file, "p:\n");
		t_ostr = aux_LN2OctetString(dh->p, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "g:\n");
		t_ostr = aux_LN2OctetString(dh->g, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "X:\n");
		t_ostr = aux_LN2OctetString(dh->X, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "Y:\n");
		t_ostr = aux_LN2OctetString(dh->Y, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);
		fprintf(secude_trace_file, "pvl:\n");
		fprintf(secude_trace_file, "%d\n", dh->private_value_length);
		fprintf(secude_trace_file, "enc_mode:\n");
		fprintf(secude_trace_file, "%d\n", dh->enc_mode);

		fprintf(secude_trace_file, "<-- dh_connect\n");
	}
#endif
	return(&dh->octetstring);
}

/***************************************************************
 *
 * Procedure dh_reply
 *
 * Generates the prime modulus p and the base g for DH key
 * agreement.
 *
 *
 ***************************************************************/
#ifdef __STDC__

OctetString	  *dh_reply(
	struct DH_CONTEXT **dh_ctx,
	OctetString	  *in_buf
)

#else

OctetString	  *dh_reply(
	dh_ctx,
	in_buf
)
struct DH_CONTEXT **dh_ctx;
OctetString	  *in_buf;

#endif

{
	struct DH_CONTEXT *dh;
	OctetString        ostr;
	L_NUMBER 	 p[MAXGENL];
	L_NUMBER 	 g[MAXGENL];
	L_NUMBER 	 le[2];
	L_NUMBER 	 peerY[MAXGENL];
	L_NUMBER 	 K[MAXGENL];
	int		 pos = 0, length = 0, private_value_length;

	if(!*dh_ctx) {
		if(!(*dh_ctx = (struct DH_CONTEXT *)calloc(1, sizeof(struct DH_CONTEXT)))) {
			global_add_error(EMALLOC, "calloc DH_CONTEXT", CNULL, 0, proc);
			return((OctetString *)0);
		}
		if(!((*dh_ctx)->buf = (char *)malloc(1000))) {
			global_add_error(EMALLOC, "calloc DH_CONTEXT", CNULL, 0, proc);
			return((OctetString *)0);
		}
		(*dh_ctx)->bufsize = 1000;
		if(!((*dh_ctx)->keyinfo.subjectkey.bits = (char *)malloc(17))) {
			global_add_error(EMALLOC, "calloc DH_CONTEXT", CNULL, 0, proc);
			return((OctetString *)0);
		}
		(*dh_ctx)->p[0] = 0;
		(*dh_ctx)->g[0] = 0;
	}
	dh = *dh_ctx;

	if(in_buf->octets[pos++] != 1) {
		global_add_error(EINVALID, "Invalid DH Protokoll version", CNULL, 0, proc);
		return((OctetString *)0);
	}

	ostr.octets = in_buf->octets+pos+1;
	ostr.noctets = in_buf->octets[pos];
	pos += 1+ostr.noctets;
	INTEGERtoln(&ostr, p);


	ostr.octets = in_buf->octets+pos+1;
	ostr.noctets = in_buf->octets[pos];
	pos += 1+ostr.noctets;
	INTEGERtoln(&ostr, g);


	ostr.octets = in_buf->octets+pos+1;
	ostr.noctets = in_buf->octets[pos];
	pos += 1+ostr.noctets;
	INTEGERtoln(&ostr, le);
	private_value_length = le[1];


	ostr.octets = in_buf->octets+pos+1;
	ostr.noctets = in_buf->octets[pos];
	pos += 1+ostr.noctets;
	INTEGERtoln(&ostr, peerY);

	dh->enc_mode = in_buf->octets[pos++];

	if(_comp(p, dh->p) || _comp(g, dh->g) || dh->private_value_length != private_value_length) {
		trans(p, dh->p);
		trans(g, dh->g);
		dh->private_value_length = private_value_length;
		dh->Y[0] = 0;
		dh->X[0] = 0;

	}

	if(!dh->X[0]) sec_random_LN(dh->X, 64);
	if(!dh->Y[0]) mexp(dh->g, dh->X, dh->Y, dh->p);


	mexp(peerY, dh->X, K, dh->p);



	dh->keyinfo.subjectkey.nbits = 0;
	switch(dh->enc_mode & DH_ENC_ALG_MASK) {
		case DH_ENC_ALG_DES_CBC3:
			dh->keyinfo.subjectAI = desCBC3;
			lntobits(K, &dh->keyinfo.subjectkey, 128);
			break;
		case DH_ENC_ALG_DES_CBC:
			dh->keyinfo.subjectAI = desCBC;
			lntobits(K, &dh->keyinfo.subjectkey, 64);
			break;
		case DH_ENC_ALG_IDEA:
			dh->keyinfo.subjectAI = idea;
			lntobits(K, &dh->keyinfo.subjectkey, 128);
			break;
		default: 
			global_add_error(EINVALID, "invalid encrypt mode", CNULL, 0, proc);
			return((OctetString *)0);
	}

	dh->buf[length++] = 2;
	ostr.octets = dh->buf+length+1;
	lntoctets(dh->Y, &ostr, 0);

	dh->buf[length++] = ostr.noctets;
	length += ostr.noctets;

	dh->octetstring.octets = dh->buf;
	dh->octetstring.noctets = length;

#ifdef TRACE_DH
	{
		OctetString *t_ostr;
		fprintf(secude_trace_file, "--> dh_reply\n");

		fprintf(secude_trace_file, "in:\n");
		aux_fprint_OctetString(secude_trace_file, in_buf);
		fprintf(secude_trace_file, "out:\n");
		aux_fprint_OctetString(secude_trace_file, &dh->octetstring);

		fprintf(secude_trace_file, "CTX:\n");

		fprintf(secude_trace_file, "p:\n");
		t_ostr = aux_LN2OctetString(dh->p, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "g:\n");
		t_ostr = aux_LN2OctetString(dh->g, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "X:\n");
		t_ostr = aux_LN2OctetString(dh->X, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "Y:\n");
		t_ostr = aux_LN2OctetString(dh->Y, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);
		fprintf(secude_trace_file, "K:\n");
		t_ostr = aux_LN2OctetString(K, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);
		fprintf(secude_trace_file, "pvl:\n");
		fprintf(secude_trace_file, "%d\n", dh->private_value_length);
		fprintf(secude_trace_file, "enc_mode:\n");
		fprintf(secude_trace_file, "%d\n", dh->enc_mode);

		fprintf(secude_trace_file, "<-- dh_reply\n");
	}
#endif
	return(&dh->octetstring);
}
/***************************************************************
 *
 * Procedure dh_accept
 *
 * Generates the prime modulus p and the base g for DH key
 * agreement.
 *
 *
 ***************************************************************/
#ifdef __STDC__

RC	dh_accept(
	struct DH_CONTEXT **dh_ctx,
	OctetString	  *buf
)

#else

RC	dh_accept(
	dh_ctx,
	buf
)
struct DH_CONTEXT **dh_ctx;
OctetString	  *buf;

#endif

{
	struct DH_CONTEXT *dh = *dh_ctx;
	OctetString        ostr;
	L_NUMBER 	 le[2];
	L_NUMBER 	 K[MAXGENL];
	L_NUMBER 	 peerY[MAXGENL];
	int		 pos = 0, length = 0, private_value_length;

	if(!*dh_ctx) {
		global_add_error(EINVALID, "need a DH_CONTEXT", CNULL, 0, proc);
		return(-1);
	}

	if(buf->octets[pos++] != 2) {
		global_add_error(EINVALID, "Invalid DH Protokoll version", CNULL, 0, proc);
		return(-1);
	}


	ostr.octets = buf->octets+pos+1;
	ostr.noctets = buf->octets[pos];
	pos += 1+ostr.noctets;
	INTEGERtoln(&ostr, peerY);

	mexp(peerY, dh->X, K, dh->p);

	dh->keyinfo.subjectkey.nbits = 0;
	switch(dh->enc_mode & DH_ENC_ALG_MASK) {
		case DH_ENC_ALG_DES_CBC3:
			dh->keyinfo.subjectAI = desCBC3;
			lntobits(K, &dh->keyinfo.subjectkey, 128);
			break;
		case DH_ENC_ALG_DES_CBC:
			dh->keyinfo.subjectAI = desCBC;
			lntobits(K, &dh->keyinfo.subjectkey, 64);
			break;
		case DH_ENC_ALG_IDEA:
			dh->keyinfo.subjectAI = idea;
			lntobits(K, &dh->keyinfo.subjectkey, 128);
			break;
	}

#ifdef TRACE_DH
	{
		OctetString *t_ostr;
		fprintf(secude_trace_file, "--> dh_accept\n");

		fprintf(secude_trace_file, "out:\n");
		aux_fprint_OctetString(secude_trace_file, &dh->octetstring);

		fprintf(secude_trace_file, "CTX:\n");

		fprintf(secude_trace_file, "p:\n");
		t_ostr = aux_LN2OctetString(dh->p, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "g:\n");
		t_ostr = aux_LN2OctetString(dh->g, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "X:\n");
		t_ostr = aux_LN2OctetString(dh->X, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "Y:\n");
		t_ostr = aux_LN2OctetString(dh->Y, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);
		fprintf(secude_trace_file, "K:\n");
		t_ostr = aux_LN2OctetString(K, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);
		fprintf(secude_trace_file, "pvl:\n");
		fprintf(secude_trace_file, "%d\n", dh->private_value_length);
		fprintf(secude_trace_file, "enc_mode:\n");
		fprintf(secude_trace_file, "%d\n", dh->enc_mode);

		fprintf(secude_trace_file, "<-- dh_accept\n");
	}
#endif

	return(0);
}
#ifdef __STDC__

OctetString	*dh_encrypt(
	struct DH_CONTEXT **dh_ctx,
	OctetString	  *in_buf
)

#else

OctetString	*dh_encrypt(
	dh_ctx,
	in_buf
)
struct DH_CONTEXT **dh_ctx;
OctetString	  *in_buf;

#endif

{
	struct DH_CONTEXT 	*dh = *dh_ctx;
	OctetString 		hash;
	char 			hash_buf[17];

	if(!*dh_ctx) {
		global_add_error(EINVALID, "need a DH_CONTEXT", CNULL, 0, proc);
		return((OctetString *)0);
	}
	if(in_buf->noctets+25 > dh->bufsize) {
		dh->buf = realloc(dh->buf, in_buf->noctets+25);
		dh->bufsize = in_buf->noctets+25;
	}

	dh->bitstring.bits = dh->buf;
	dh->bitstring.nbits = 0;

	if(dh->enc_mode & DH_HASH) {
		hash.octets = hash_buf;
		if(md2_hash(in_buf, &hash, SEC_END) < 0) {
			global_add_error(EINVALID, "hashing failed", CNULL, 0, proc);
			return((OctetString *)0);
		}

	}
	switch(dh->enc_mode & DH_ENC_ALG_MASK) {
		case DH_ENC_ALG_DES_CBC3:
		case DH_ENC_ALG_DES_CBC:	
			if(dh->enc_mode & DH_HASH) 
			if(des_encrypt(&hash, &dh->bitstring, SEC_MORE, &dh->keyinfo) < 0) {
				global_add_error(EINVALID, "encryption failed", CNULL, 0, proc);
				return((OctetString *)0);
			}
			if(des_encrypt(in_buf, &dh->bitstring, SEC_END, &dh->keyinfo) < 0) {
				global_add_error(EINVALID, "encryption failed", CNULL, 0, proc);
				return((OctetString *)0);
			}

			break;
		case DH_ENC_ALG_IDEA:	
			if(dh->enc_mode & DH_HASH) 
			if(idea_encrypt(&hash, &dh->bitstring, SEC_MORE, &dh->keyinfo) < 0) {
				global_add_error(EINVALID, "encryption failed", CNULL, 0, proc);
				return((OctetString *)0);
			}
			if(idea_encrypt(in_buf, &dh->bitstring, SEC_END, &dh->keyinfo) < 0) {
				global_add_error(EINVALID, "encryption failed", CNULL, 0, proc);
				return((OctetString *)0);
			}

			break;
	}
	dh->octetstring.noctets = dh->bitstring.nbits / 8;
	dh->octetstring.octets = dh->bitstring.bits;

#ifdef TRACE_DH
	{
		OctetString *t_ostr;
		fprintf(secude_trace_file, "--> dh_encrypt\n");

		fprintf(secude_trace_file, "in:\n");
		aux_fprint_OctetString(secude_trace_file, in_buf);
		fprintf(secude_trace_file, "out:\n");
		aux_fprint_OctetString(secude_trace_file, &dh->octetstring);

		fprintf(secude_trace_file, "CTX:\n");

		fprintf(secude_trace_file, "p:\n");
		t_ostr = aux_LN2OctetString(dh->p, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "g:\n");
		t_ostr = aux_LN2OctetString(dh->g, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "X:\n");
		t_ostr = aux_LN2OctetString(dh->X, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "Y:\n");
		t_ostr = aux_LN2OctetString(dh->Y, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);
		fprintf(secude_trace_file, "Key:\n");
		aux_fprint_BitString(secude_trace_file, &dh->keyinfo.subjectkey);
		fprintf(secude_trace_file, "pvl:\n");
		fprintf(secude_trace_file, "%d\n", dh->private_value_length);
		fprintf(secude_trace_file, "enc_mode:\n");
		fprintf(secude_trace_file, "%d\n", dh->enc_mode);

		fprintf(secude_trace_file, "<-- dh_encrypt\n");
	}
#endif
	return(&dh->octetstring);
}


#ifdef __STDC__

OctetString	*dh_decrypt(
	struct DH_CONTEXT **dh_ctx,
	OctetString	  *in_buf
)

#else

OctetString	*dh_decrypt(
	dh_ctx,
	in_buf
)
struct DH_CONTEXT **dh_ctx;
OctetString	  *in_buf;

#endif

{
	struct DH_CONTEXT *dh = *dh_ctx;
	OctetString 		hash;
	char 			hash_buf[17];
	
	if(!*dh_ctx) {
		global_add_error(EINVALID, "need a DH_CONTEXT", CNULL, 0, proc);
		return((OctetString *)0);
	}
	if(in_buf->noctets+9 > dh->bufsize) {
		dh->buf = realloc(dh->buf, in_buf->noctets+9);
		dh->bufsize = in_buf->noctets+9;
	}
	dh->octetstring.noctets = 0;
	dh->octetstring.octets = dh->buf;

	dh->bitstring.bits = in_buf->octets;
	dh->bitstring.nbits = in_buf->noctets * 8;

	switch(dh->enc_mode & DH_ENC_ALG_MASK) {
		case DH_ENC_ALG_DES_CBC3:
		case DH_ENC_ALG_DES_CBC:	
			if(des_decrypt(&dh->bitstring, &dh->octetstring, SEC_END, &dh->keyinfo) < 0) {
				global_add_error(EINVALID, "decryption failed", CNULL, 0, proc);
				return((OctetString *)0);
			}

			break;
		case DH_ENC_ALG_IDEA:	
			if(idea_decrypt(&dh->bitstring, &dh->octetstring, SEC_END, &dh->keyinfo) < 0) {
				global_add_error(EINVALID, "decryption failed", CNULL, 0, proc);
				return((OctetString *)0);
			}
			break;
		default: 
			global_add_error(EINVALID, "invalid encrypt mode", CNULL, 0, proc);
			return((OctetString *)0);
	}
	if(dh->enc_mode & DH_HASH) {
		int n;
		dh->octetstring.noctets -= 16;
		dh->octetstring.octets += 16;
		hash.octets = hash_buf;
		if(md2_hash(&dh->octetstring, &hash, SEC_END) < 0) {
			global_add_error(EINVALID, "hashing failed", CNULL, 0, proc);
			return((OctetString *)0);
		}

		for(n = 0; n < 16; n++) 
			if(hash_buf[n] != dh->buf[n]) {
				global_add_error(EINVALID, "verification failed", CNULL, 0, proc);
				return((OctetString *)0);
			}
	}

#ifdef TRACE_DH
	{
		OctetString *t_ostr;
		fprintf(secude_trace_file, "--> dh_decrypt\n");

		fprintf(secude_trace_file, "in:\n");
		aux_fprint_OctetString(secude_trace_file, in_buf);
		fprintf(secude_trace_file, "out:\n");
		aux_fprint_OctetString(secude_trace_file, &dh->octetstring);

		fprintf(secude_trace_file, "CTX:\n");

		fprintf(secude_trace_file, "p:\n");
		t_ostr = aux_LN2OctetString(dh->p, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "g:\n");
		t_ostr = aux_LN2OctetString(dh->g, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "X:\n");
		t_ostr = aux_LN2OctetString(dh->X, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "Y:\n");
		t_ostr = aux_LN2OctetString(dh->Y, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);
		fprintf(secude_trace_file, "Key:\n");
		aux_fprint_BitString(secude_trace_file, &dh->keyinfo.subjectkey);
		fprintf(secude_trace_file, "pvl:\n");
		fprintf(secude_trace_file, "%d\n", dh->private_value_length);
		fprintf(secude_trace_file, "enc_mode:\n");
		fprintf(secude_trace_file, "%d\n", dh->enc_mode);

		fprintf(secude_trace_file, "<-- dh_decrypt\n");
	}
#endif
	return(&dh->octetstring);
}

#ifdef __STDC__

RC	dh_end(
	struct DH_CONTEXT **dh_ctx
)

#else

RC	dh_end(
	dh_ctx
)
struct DH_CONTEXT **dh_ctx;

#endif

{
	struct DH_CONTEXT *dh = *dh_ctx;
	
	if(!*dh_ctx) {
		global_add_error(EINVALID, "need a DH_CONTEXT", CNULL, 0, proc);
		return(-1);
	}
	free((*dh_ctx)->buf);
	free((*dh_ctx)->keyinfo.subjectkey.bits);
	free(*dh_ctx);
	*dh_ctx = (struct DH_CONTEXT *)0;
	return(0);
}
