/* ./src/crypt/dsa/dsa.h */

/* 
 *
 * $Id: dsa.h,v 1.5 1995/01/10 13:32:42 surkau Exp $
 *
 * $Log: dsa.h,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1991, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/


	   /*-------------------------------------------------*/
	   /* Definition der maximalen Feld - groessen	      */
	   /*-------------------------------------------------*/
#define MAXMODULUSL	1024	/*	maximum length of prim p 	*/
#define MINMODULUSL	512	/*	minimum length of prim p	*/
#define MODULUSSTEPS	64	/*	length of p must be dividable by 64	*/
#define HASHOCTETS	20	/*	length of sha hash bitstring	*/
#define HASHWORDS	(HASHOCTETS/WBYTES)	/*	length of sha hash bitstring	*/
#define HASHBITS	(BYTEL*HASHOCTETS)	/*	length of sha hash bitstring	*/
#define SEEDOCTETS	20	/*	length of random number	*/
#define SEEDWORDS	(SEEDOCTETS/WBYTES)	/*	length of random number	*/
#define SEEDBITS	(BYTEL*SEEDOCTETS)	/*	length of random number	*/

	
/*------------------------------------------------------------*/
/* Typ - Definitionen					      */
/*------------------------------------------------------------*/
	   /*-------------------------------------------------*/
	   /* Teile des RSA-Schluessels als 'lange Zahlen'    */
	   /*-------------------------------------------------*/
typedef	struct	{
	L_NUMBER        x[MAXLGTH];
	L_NUMBER        p[MAXLGTH];
	L_NUMBER        q[MAXLGTH];
	L_NUMBER        g[MAXLGTH];
	}       DSA_Skeys;

typedef	struct	{
	L_NUMBER        y[MAXLGTH];
	L_NUMBER        p[MAXLGTH];
	L_NUMBER        q[MAXLGTH];
	L_NUMBER        g[MAXLGTH];
	}       DSA_Pkeys;

typedef union {
	DSA_Skeys   sk;
	DSA_Pkeys   pk;
	}       DSA_keys;

typedef struct {
	L_NUMBER   r[MAXLGTH];
	L_NUMBER   s[MAXLGTH];
	}       DSA_sig;

typedef	struct	{
	L_NUMBER        p[MAXLGTH];
	L_NUMBER        q[MAXLGTH];
	L_NUMBER        g[MAXLGTH];
	}       DSA_public_part;


#ifdef __STDC__
       void	ln_ggt	(L_NUMBER ln1[], L_NUMBER ln2[], L_NUMBER ggt[]);
       void	ln_inv	(L_NUMBER ln[], L_NUMBER modul[], L_NUMBER res[]);
       void	dsa_signblock	(register L_NUMBER in[], DSA_sig *sig, DSA_Skeys *key);
       int	dsa_verifyblock	(register L_NUMBER in[], DSA_sig *sig, DSA_Pkeys *key);
#else
       void	ln_ggt	();
       void	ln_inv	();
       void	dsa_signblock	();
       int	dsa_verifyblock	();


#endif
