/* ./src/crypt/global/free.c */

static char *rcsid = "$Id: free.c,v 1.3 1994/11/02 10:44:39 surkau Exp $";

/* 
 *
 * $Id: free.c,v 1.3 1994/11/02 10:44:39 surkau Exp $
 *
 * $Log: free.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include "sec_global.h"

/***************************************************************
 *
 * Procedure aux_free_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_OctetString(
	OctetString	**ostr
)

#else

void aux_free_OctetString(
	ostr
)
OctetString	**ostr;

#endif

{
	char	 * proc = "aux_free_OctetString";

	if (ostr && *ostr) {
		if((*ostr)->octets && (*ostr)->noctets) free((*ostr)->octets);
		(*ostr)->octets = (char *)0;
		(*ostr)->noctets = 0;
		free(*ostr);
		*ostr = NULLOCTETSTRING;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_OctetString(
	OctetString	 *ostr
)

#else

void aux_free2_OctetString(
	ostr
)
OctetString	 *ostr;

#endif

{
	char	 * proc = "aux_free2_OctetString";

	if (ostr) {
		if(ostr->noctets && ostr->octets) free(ostr->octets);
		ostr->octets = (char *)0;
		ostr->noctets = 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_BitString
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_BitString(
	BitString	**bstr
)

#else

void aux_free_BitString(
	bstr
)
BitString	**bstr;

#endif

{
	char	 * proc = "aux_free_BitString";

	if (bstr && *bstr) {
		if((*bstr)->nbits && (*bstr)->bits) free((*bstr)->bits);
		(*bstr)->bits = (char *)0;
		(*bstr)->nbits = 0;
		free(*bstr);
		*bstr = NULLBITSTRING;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_BitString
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_BitString(
	BitString	 *bstr
)

#else

void aux_free2_BitString(
	bstr
)
BitString	 *bstr;

#endif

{
	char	 * proc = "aux_free2_BitString";

	if (bstr) {
		if(bstr->nbits && bstr->bits) free(bstr->bits);
		bstr->bits = (char *)0;
		bstr->nbits = 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_ObjId
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_ObjId(
	ObjId	**oid
)

#else

void aux_free_ObjId(
	oid
)
ObjId	**oid;

#endif

{
	char	 * proc = "aux_free_ObjId";

	if (oid && *oid) {
		if ((*oid)->oid_elements)
			free((*oid)->oid_elements);
		free(*oid), *oid = NULLOBJID;
	}
	return;
}

/***************************************************************
 *
 * Procedure aux_free2_ObjId
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_ObjId(
	ObjId	 *oid
)

#else

void aux_free2_ObjId(
	oid
)
ObjId	 *oid;

#endif

{
	char	 * proc = "aux_free2_ObjId";

	if (oid) {
		if (oid->oid_elements)
			free(oid->oid_elements);
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_KeyInfo
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_KeyInfo(
	register KeyInfo	 *p
)

#else

void aux_free2_KeyInfo(
	p
)
register KeyInfo	 *p;

#endif

{
	char	 * proc = "aux_free2_KeyInfo";

	if (p) {
		if (p->subjectAI)
			aux_free_AlgId(&(p->subjectAI));
		if (p->subjectkey.nbits && p->subjectkey.bits) {
			bzero(p->subjectkey.bits, p->subjectkey.nbits / 8);
			free(p->subjectkey.bits);
			p->subjectkey.bits = (char *)0;
		}
	}
	return;
}



/***************************************************************
 *
 * Procedure aux_free_KeyInfo
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_KeyInfo(
	KeyInfo	**keyinfo
)

#else

void aux_free_KeyInfo(
	keyinfo
)
KeyInfo	**keyinfo;

#endif

{
	char	 * proc = "aux_free_KeyInfo";

	if (keyinfo && *keyinfo) {
		aux_free2_KeyInfo(*keyinfo);
		free(*keyinfo);
		*keyinfo = (KeyInfo * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_KeyBits
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_KeyBits(
	KeyBits	**keybits
)

#else

void aux_free_KeyBits(
	keybits
)
KeyBits	**keybits;

#endif

{
	register KeyBits * p;
	char	         * proc = "aux_free_KeyBits";

	if (keybits && (p = *keybits)) {
		aux_free2_OctetString(&(p->part1));
		aux_free2_OctetString(&(p->part2));
		aux_free2_OctetString(&(p->part3));
		aux_free2_OctetString(&(p->part4));
		free(p);
		*keybits = (KeyBits * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_KeyBits
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_KeyBits(
	register KeyBits	 *p
)

#else

void aux_free2_KeyBits(
	p
)
register KeyBits	 *p;

#endif

{
	char	 * proc = "aux_free2_KeyBits";

	if (p) {
		aux_free2_OctetString(&(p->part1));
		aux_free2_OctetString(&(p->part2));
		aux_free2_OctetString(&(p->part3));
		aux_free2_OctetString(&(p->part4));
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_AlgId
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_AlgId(
	AlgId	**algid
)

#else

void aux_free_AlgId(
	algid
)
AlgId	**algid;

#endif

{
	KeyBits     * kbits;
	OctetString * ostr;
	char	    * proc = "aux_free_AlgId";

	if (algid && *algid) {
		if ((*algid)->param) {
			switch (aux_ObjId2ParmType((*algid)->objid)) {
				case PARM_OctetString:
					ostr = (OctetString * )(*algid)->param;
					aux_free_OctetString(&ostr);
					break;
				case PARM_KeyBits:
					kbits = (KeyBits * )(*algid)->param;
					aux_free_KeyBits(&kbits);
					break;
			}
			(*algid)->param = CNULL;
		}
		if ((*algid)->objid) aux_free_ObjId(&((*algid)->objid));
		free(*algid);
		*algid = NULLALGID;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_AlgId
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_AlgId(
	register AlgId	 *algid
)

#else

void aux_free2_AlgId(
	algid
)
register AlgId	 *algid;

#endif

{
	char	 * proc = "aux_free2_AlgId";

	if (algid) {
		if (algid->objid)
			aux_free_ObjId(&(algid->objid));
		if (algid->param)
			free(algid->param);
	}
	return;
}


/***************************************************************
 *
 * Procedure global_free_error
 *
 ***************************************************************/
#ifdef __STDC__

void global_free_error(
)

#else

void global_free_error(
)

#endif

{
	register struct ErrStack * err;
	char		         * proc = "global_free_error";

	while (err_stack) {
		err = err_stack;
		if(err->e_addr) switch (err->e_addrtype) {

			case    char_n:
					free(err->e_addr);
					break;
			case 	OctetString_n:
					aux_free_OctetString((OctetString **) &err->e_addr);
					break;
			case 	BitString_n:
					aux_free_BitString((BitString **) &err->e_addr);
					break;
			case 	AlgId_n:
					aux_free_AlgId((AlgId **) &err->e_addr);
					break;
			case    KeyInfo_n:
					aux_free_KeyInfo((KeyInfo **) &err->e_addr);
					break;
			case 	ObjId_n:
					aux_free_ObjId((ObjId **) &err->e_addr);
					break;
			case 	KeyBits_n:
					aux_free_KeyBits((KeyBits **) &err->e_addr);
					break;
		}
		if(err->e_text) free(err->e_text);
		err_stack = err->next;
		free(err);
	}
	err_malloc.e_number = 0;
	err_malloc.e_text = CNULL;
	err_malloc.e_addr = CNULL;
	err_malloc.e_proc = CNULL;
	err_malloc.next = (struct ErrStack * ) 0;
	return;
}

