/* ./src/crypt/global/rand.c */

static char *rcsid = "$Id: rand.c,v 1.5 1995/02/15 12:27:57 surkau Exp $";

/* 
 *
 * $Id: rand.c,v 1.5 1995/02/15 12:27:57 surkau Exp $
 *
 * $Log: rand.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*-----------------------------------------------------------------------*/
/* sec_random.c: Funktionen sec_random_*()                               */
/*-----------------------------------------------------------------------*/

#include "arithmetic.h"
#include <time.h>



/* Parameters of random number generator *
 *
 * random_seed = random_seed * random_mult + random_add ( mod 2 ^ (32*RANDOM_SIZE) )
 *
 * RANDOM_SIZE: Number of integers ( 2..8 )
 * random_seed: Actual random seed number of length RANDOM_SIZE ( Must have memory for 2*RANDOM_SIZE integers)
 * random_mult: A number of length RANDOM_SIZE which must be 1 ( mod 4) 
 * random_add:  A number of length RANDOM_SIZE which must be 1 ( mod 2)
 */

#define RANDOM_SIZE 5

static L_NUMBER random_seed[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static L_NUMBER random_mult[] = { RANDOM_SIZE, 0x12345675, 0x89abcdef, 0x47110815, 0x1f2e3d4c, 0x256345fc, 0xfdbc2454, 0x2345fbac, 0xfd6a87fb};
static L_NUMBER random_add[] =  { RANDOM_SIZE, 0x23571113, 0x17192123, 0x29313741, 0x43475359, 0x456fbcae, 0x456fbd67, 0x245fbcdd, 0x43563567};





/***************************************************************
 *
 * Procedure rndout
 *
 ***************************************************************/
#ifdef __STDC__

static int rndout(
)

#else

static int rndout(
)

#endif

{
	int n;
	for(n=0; n<=random_seed[0]; n++) printf("%x ",  random_seed[n]);
	printf("\n");
	for(n=0; n<=random_mult[0]; n++) printf("%x ",  random_mult[n]);
	printf("\n");
	for(n=0; n<=random_add[0]; n++) printf("%x ",  random_add[n]);
	printf("\n");

	return(0);
}


/***************************************************************
 *
 * Procedure sec_init_random_seed_with_string
 *
 ***************************************************************/
#ifdef __STDC__

RC sec_init_random_seed_with_string(
	char *input
)

#else

RC sec_init_random_seed_with_string(
	input
)
char * input;
#endif

{
	char	    * proc = "sec_init_random_seed_with_string";
	int len, pos = 0, n = 1, bit = 0;

	if(!input || !strlen(input)) input = proc;

	len = strlen(input);

	while (n<=RANDOM_SIZE) {
		random_seed[n] ^= input[pos++] << bit;
		bit += 4;
		if(bit == 32 ) {
			n++;
			bit = 0;
		}
		if (pos == len) pos = 0;
	}
	random_seed[0] = RANDOM_SIZE;


	
	return(0);
}

/***************************************************************
 *
 * Procedure init_random_seed
 *
 ***************************************************************/
#ifdef __STDC__

static RC init_random_seed(
)

#else

static RC init_random_seed(
)

#endif

{
	time_t 	 ti;
	int 	 n,  pid;
	char	*mem, *proc = "init_random_seed";
	int	*ibuf;


	time(&ti);
	pid = (int) getpid();

	ibuf = (int *) malloc(2048);
	if(!ibuf) {
		return(-1);
	}

	for(n = 0; n<20; n++) {
		ibuf[n] += (int) ti;
	}
	for(n = 20; n<40; n++) {
		ibuf[n] +=  pid;
	}
	for(n = 40; n<60; n++) {
		ibuf[n] += (int) &ti;
	}
	for(n = 60; n<80; n++) {
		ibuf[n] += (int) random_seed;
	}
	for(n = 0; n<256; n++) {
		random_seed[1 + n % (RANDOM_SIZE-1)] += ibuf[n];
	}
	free(ibuf);

	random_seed[0] = RANDOM_SIZE;
	random_seed[RANDOM_SIZE] |= 1;

	return(0);
}


/***************************************************************
 *
 * Procedure sec_init_random
 *
 ***************************************************************/
#ifdef __STDC__

RC sec_init_random(
	L_NUMBER	  seed[]
)

#else

RC sec_init_random(
	seed
)
L_NUMBER	  seed[];

#endif

{
	char	    * proc = "sec_init_random";

	if(seed) {
		if(seed[0]>RANDOM_SIZE || seed[0]<1) {
			global_add_error(EINVALID, "Invalid seed length", CNULL, 0, proc);
			return (-1);
		}
		
		trans(seed, random_seed);
		return(0);
	}

    	if(random_seed[0]) return(0);

	
	if(!random_seed[0]) 
	    if(init_random_seed() < 0) {
		global_add_error(EINVALID, "Can't init random number", CNULL, 0, proc);
		return (-1);
	    }

	return(0);
}

/***************************************************************
 *
 * Procedure sec_get_random_seed
 *
 ***************************************************************/
#ifdef __STDC__

RC sec_get_random_seed(
	L_NUMBER	  seed[]
)

#else

RC sec_get_random_seed(
	seed
)
L_NUMBER	  seed[];

#endif

{
	char	    * proc = "sec_get_random_seed";

	trans(random_seed, seed);
	return(0);
}


/***************************************************************
 *
 * Procedure sec_random_destroy_seed
 *
 ***************************************************************/
#ifdef __STDC__

void sec_random_destroy_seed(
)

#else

void sec_random_destroy_seed(
)

#endif

{
	int n;

	for(n = 0; n<=RANDOM_SIZE; n++) random_seed[n] = 0;
	

}







/***************************************************************
 *
 * Procedure next_random
 *
 ***************************************************************/
#ifdef __STDC__

static RC next_random(
)

#else

static RC next_random(
)

#endif

{
	char	    * proc = "next_random";
	
	if(sec_init_random((L_NUMBER *)0) < 0) {
		global_add_error(EINVALID, "Can't init random number", CNULL, 0, proc);
		return (-1);
	}

	mult(random_seed, random_mult, random_seed);
	add(random_seed, random_add, random_seed);
	if(random_seed[0]>RANDOM_SIZE) random_seed[0] = RANDOM_SIZE;
	normalize(random_seed);

	return(0);
}


/***************************************************************
 *
 * Procedure sec_random_ostr
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *sec_random_ostr(
	unsigned int	  noctets
)

#else

OctetString *sec_random_ostr(
	noctets
)
unsigned int	  noctets;

#endif

{
	OctetString    *p;
	char           *proc = "sec_random_ostr";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);
#endif

	if (noctets <= 0)
		return (NULLOCTETSTRING);
	if (!(p = (OctetString *) malloc(sizeof(OctetString)))) {
		global_add_error(EMALLOC, "p", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}
	if (!(p->octets = malloc(noctets))) {
		global_add_error(EMALLOC, "p->octets", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}
	p->noctets = noctets;
	{
		int             i, j;
		char           *cp, *rnd;

		for(j = 0; j<noctets; j += 16) {
			if(next_random() < 0) {
				global_add_error(EINVALID, "Can't get random number", CNULL, 0, proc);
				return (NULLOCTETSTRING);
			}
			rnd = (char *) &random_seed[2];
			for (i = j; i < noctets && i-j<16; i++) p->octets[i] = rnd[i-j];
		}
	}


	return p;
}

/***************************************************************
 *
 * Procedure sec_random_LN
 *
 ***************************************************************/
#ifdef __STDC__

RC sec_random_LN(
	L_NUMBER         *ln,
	unsigned int	  bits
)

#else

RC sec_random_LN(
	ln,
	bits
)
L_NUMBER         *ln;
unsigned int	  bits;

#endif

{
	OctetString    *p;
	char           *proc = "sec_random_LN";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);
#endif

	if (bits < 0)
		return (-1);

	if(next_random() < 0) {
		global_add_error(EINVALID, "Can't get random number", CNULL, 0, proc);
		return (-1);
	}
	
	ln[0] = 0;

	while( ln[0]*WLNG < bits) {
		ln[0]++;
		ln[ln[0]] = random_seed[(ln[0]-1) % RANDOM_SIZE + 1];
	}
	if(bits % WLNG) ln[ln[0]] = (ln[ln[0]] & ( (1 << (bits % WLNG)) - 1)) | (1 << ((bits % WLNG) - 1));
	else ln[ln[0]] = ln[ln[0]] | HSBIT;

	return(0);
}


/***************************************************************
 *
 * Procedure sec_random_bstr
 *
 ***************************************************************/
#ifdef __STDC__

BitString *sec_random_bstr(
	unsigned int	  nbits
)

#else

BitString *sec_random_bstr(
	nbits
)
unsigned int	  nbits;

#endif

{
	OctetString    *p;
	char           *proc = "sec_random_ostr";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);
#endif

	if (nbits <= 0)
		return (NULLBITSTRING);
	if (NULLOCTETSTRING == (p = sec_random_ostr((nbits + 7) / 8)))
		return (NULLBITSTRING);
	if (nbits & 7)
		p->octets[p->noctets - 1] &= 0xFF00 >> (nbits & 7);
	p->noctets = nbits;
	return (BitString *) p;
}



/***************************************************************
 *
 * Procedure sec_random_str
 *
 ***************************************************************/
#ifdef __STDC__

char *sec_random_str(
	int	  nchars,
	char	 *chars
)

#else

char *sec_random_str(
	nchars,
	chars
)
int	  nchars;
char	 *chars;

#endif

{
	char           *p;
	char           *proc = "sec_random_ostr";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);
#endif

	if (nchars <= 0)
		return (CNULL);
	if (!(p = malloc(nchars))) {
		global_add_error(EMALLOC, "p", CNULL, 0, proc);
		return (CNULL);
	} {
		int             i, s = 0;
		char           *cp;

		if (chars)
			s = strlen(chars);

		for (i = nchars, cp = p; i > 0; i--, cp++) {
			if(next_random() < 0) {
				global_add_error(EINVALID, "Can't get random number", CNULL, 0, proc);
				return (CNULL);
			}
			*cp = (s ? chars[random_seed[2] % s] : random_seed[2] % (0x7E - ' ') + ' ' + 1);
		}
	}
	return p;
}


/***************************************************************
 *
 * Procedure sec_random_int
 *
 ***************************************************************/
#ifdef __STDC__

RC sec_random_int(
	int	  r1,
	int	  r2,
	int	  *ret
)

#else

RC sec_random_int(
	r1,
	r2,
	ret
)
int	  r1;
int	  r2;
int	  *ret;

#endif

{
	char           *proc = "sec_random_int";

	if (r1 >= r2)
		return (-1);

	if(next_random() < 0) {
		global_add_error(EINVALID, "Can't get random number", CNULL, 0, proc);
		return (-1);
	}

	*ret = random_seed[2] % (r2 - r1 + 1) + r1;
	return (0);

}


/***************************************************************
 *
 * Procedure sec_random_long
 *
 ***************************************************************/
#ifdef __STDC__

RC sec_random_long(
	long	  r1,
	long	  r2,
	long	  *ret
)

#else

RC sec_random_long(
	r1,
	r2,
	ret
)
long	  r1;
long	  r2;
long	  *ret;

#endif

{
	char           *proc = "sec_random_long";

	if (r1 >= r2)
		return (-1);

	if(next_random() < 0) {
		global_add_error(EINVALID, "Can't get random number", CNULL, 0, proc);
		return (-1);
	}

	*ret = random_seed[2] % (r2 - r1) + r1;
	return (0);

}

/***************************************************************
 *
 * Procedure sec_random_unsigned
 *
 ***************************************************************/
#ifdef __STDC__

RC sec_random_unsigned(
	unsigned int	  *ret
)

#else

RC sec_random_unsigned(
	ret
)
unsigned int	  *ret;

#endif

{
	char           *proc = "sec_random_unsigned";

	if(next_random() < 0) {
		global_add_error(EINVALID, "Can't get random number", CNULL, 0, proc);
		return (-1);
	}

	*ret = random_seed[2];
	return (0);

}


