/* ./src/crypt/md/md2_if.c */

static char *rcsid = "$Id: md2_if.c,v 1.3 1994/11/02 10:44:39 surkau Exp $";

/* 
 *
 * $Id: md2_if.c,v 1.3 1994/11/02 10:44:39 surkau Exp $
 *
 * $Log: md2_if.c,v $
 *
 */
 
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*
 *  MD2 interface module between sec_hash, sec_sign, sec_verify and 
 *  the "RSA Data Security, Inc. MD2 Message Digest Algorithm"
 *  Reference C version
 *
 *  WS 27.2.91
 *
 *  Last change: 28.2.91
 *
 *  Imports from RSADSI:
 *
 *  MD2Init(mdContext)
 *  MD2Update(mdContext, inBuf, inLen)
 *  MD2Final(mdContext)
 *
 *  Exports to libdes.a or libSECUDE.a:
 *
 *  md2_hash(in_octets, hash_result, more)
 *
 */

#include "md_global.h"
#include "md2.h"
#include "sec_global.h"


/***************************************************************
 *
 * Procedure md2_hash
 *
 ***************************************************************/
#ifdef __STDC__

RC md2_hash(
	OctetString	 *in_octets,
	OctetString	 *hash_result,
	More		  more
)

#else

RC md2_hash(
	in_octets,
	hash_result,
	more
)
OctetString	 *in_octets;
OctetString	 *hash_result;
More		  more;

#endif

{
        static char first = TRUE;
        static MD2_CTX mdContext;
	unsigned char digest[16];

        if(first) {
                MD2Init(&mdContext);
                first = FALSE;
        }
        MD2Update(&mdContext, in_octets->octets, in_octets->noctets);

        if(more == SEC_END) {
                first = TRUE;
                MD2Final(digest, &mdContext);
                /* memory of hash_result->octets provided by calling program */
                bcopy(&digest[0], hash_result->octets, 16);
                hash_result->noctets = 16;
        }
        return(0);
}
