/* ./src/crypt/md/md5_if.c */

static char *rcsid = "$Id: md5_if.c,v 1.3 1994/11/02 10:44:39 surkau Exp $";

/* 
 *
 * $Id: md5_if.c,v 1.3 1994/11/02 10:44:39 surkau Exp $
 *
 * $Log: md5_if.c,v $
 *
 */
 
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*
 *  MD5 interface module between sec_hash, sec_sign, sec_verify and
 *  the "RSA Data Security, Inc. MD5 Message Digest Algorithm"
 *  Reference C version
 *
 *  WS 11.7.91
 *
 *  Last change: 11.7.91
 *
 *  Imports from RSADSI:
 *
 *  MD5Init(mdContext)
 *  MD5Update(mdContext, inBuf, inLen)
 *  MD5Final(mdContext)
 *
 *  Exports to libdes.a or libSECUDE.a:
 *
 *  md5_hash(in_octets, hash_result, more)
 *
 */

#include "md_global.h"
#include "md5.h"
#include "sec_global.h"


/***************************************************************
 *
 * Procedure md5_hash
 *
 ***************************************************************/
#ifdef __STDC__

RC md5_hash(
	OctetString	 *in_octets,
	OctetString	 *hash_result,
	More		  more
)

#else

RC md5_hash(
	in_octets,
	hash_result,
	more
)
OctetString	 *in_octets;
OctetString	 *hash_result;
More		  more;

#endif

{
        static char first = TRUE;
        static MD5_CTX mdContext;
	unsigned char digest[16];

        if(first) {
                MD5Init(&mdContext);
                first = FALSE;
        }
        MD5Update(&mdContext, in_octets->octets, in_octets->noctets);

        if(more == SEC_END) {
                first = TRUE;
                MD5Final(digest, &mdContext);
                /* memory of hash_result->octets provided by calling program */
                bcopy(&digest[0], hash_result->octets, 16);
                hash_result->noctets = 16;
        }
        return(0);
}
