/* ./src/crypt/rsa/rsagen.c */

static char *rcsid = "$Id: rsagen.c,v 1.4 1994/11/10 14:44:05 surkau Exp $";

/* 
 *
 * $Id: rsagen.c,v 1.4 1994/11/10 14:44:05 surkau Exp $
 *
 * $Log: rsagen.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*
 * RSA - module for RSA key generation
 * 
 * rsa_gen_key()
 */

#include "arithmetic.h"
#include "rsa.h"
#include "rsa_debug.h"

/*----------------------------------------------rsa_gen_key---*/
#define MINKEYSIZE      64
#define MAXKEYSIZE      (MAXLGTH<<SWBITS)

/***************************************************************
 *
 * Procedure rsa_gen_key
 *
 ***************************************************************/
#ifdef __STDC__

RC rsa_gen_key(
	int		  keysize,
	KeyBits		**skey,
	KeyBits		**pkey
)

#else

RC rsa_gen_key(
	keysize,
	skey,
	pkey
)
int		  keysize;
KeyBits		**skey;
KeyBits		**pkey;

#endif

{
	char		*proc = "rsa_gen_key";
	int		rsaminmax;
	Skeys   	rsaparm;
	rndmstart 	zufall;
	L_NUMBER        a[MAXGENL];
	L_NUMBER        b[MAXGENL/2];
	int     	repeat;
	L_NUMBER modul[MAXGENL];
extern  L_NUMBER lz_fermat5[];  /* 5. Fermatzahl F4 */


	if (keysize < MINKEYSIZE) {
		rsaminmax = MINKEYSIZE;
		global_add_error(EINVALID, "Wrong RSA keysize: must be >= ", (char *)rsaminmax, int_n, proc);
		return(-1);
	};
	if (keysize > MAXKEYSIZE) {
		rsaminmax = MAXKEYSIZE;
		global_add_error(EINVALID, "Wrong RSA keysize: must be <= ", (char *)rsaminmax, int_n, proc);
		return(-1);
	};

	PrintSTART("RSA genkey Prolog ... ",6);

	primzahl(zufall.p,a,(keysize+11)/2);
	primzahl(zufall.q,b,(keysize+11)/2);
	mult (zufall.p,zufall.q,zufall.modul);

	mult(a,b,a);
	rndm_start (zufall.p,a,zufall.modul);
	rndm_start (zufall.q,a,zufall.modul);

	repeat = 1;
	for( ; repeat; ){
		repeat = genrsa (&rsaparm,keysize,&zufall);
		/* weitersetzen der Zufallswerte */
		mmult (zufall.p,zufall.p,zufall.p,zufall.modul);
		mmult (zufall.q,zufall.q,zufall.q,zufall.modul);
	}



	if(!(*skey = (KeyBits *) calloc(1, sizeof(KeyBits)))) {
		global_add_error(EMALLOC, "skey", CNULL, 0, proc);
		return(-1);
	}

	if(aux_LN2OctetString2(&(*skey)->part1, rsaparm.p, 0) < 0) {
		global_add_error(LASTERROR, LASTTEXT, LASTADDR, proc);
		return(-1);
	}

	if(aux_LN2OctetString2(&(*skey)->part2, rsaparm.q, 0) < 0) {
		global_add_error(LASTERROR, LASTTEXT, LASTADDR, proc);
		return(-1);
	}

	(*skey)->part3.noctets = 0;
	(*skey)->part4.noctets = 0;

	mult (rsaparm.p,rsaparm.q,modul);

	/* ERASE SECRET KEY */
	bzero(&rsaparm,sizeof(rsaparm));


	if(!(*pkey = (KeyBits *) calloc(1, sizeof(KeyBits)))) {
		global_add_error(EMALLOC, "pkey", CNULL, 0, proc);
		return(-1);
	}

	if(aux_LN2OctetString2(&(*pkey)->part1, modul, 0) < 0) {
		global_add_error(LASTERROR, LASTTEXT, LASTADDR, proc);
		return(-1);
	}

	if(aux_LN2OctetString2(&(*pkey)->part2, lz_fermat5, 0) < 0) {
		global_add_error(LASTERROR, LASTTEXT, LASTADDR, proc);
		return(-1);
	}

	(*pkey)->part3.noctets = 0;
	(*pkey)->part4.noctets = 0;

	return 0;
}
