/* ./src/include/cadb.h */

/* 
 *
 * $Header: /libra/secude/src/include/RCS/cadb.h,v 1.4 1994/11/02 15:29:44 schneiw Exp $
 *
 * $Log: cadb.h,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include "af.h"

/*----------------------------------------------------------------------------*/
/*     C A  s                                                                 */
/*----------------------------------------------------------------------------*/
   
#define DEF_ISSUER_ALGID        md2WithRsaEncryption    /* default CA signature algid   */
#define DEF_SUBJECT_SIGNALGID   rsa           /* default CA encryption algid  */
#define DEF_SUBJECT_ENCRALGID   rsa           /* default CA encryption algid  */


#define CALOG		"calog"
#define	LOGFLAGS	"a+"

#define	LOGINIT		fprintf(logfile,"%s : INIT\n", logtime());
#define	LOGERR(msg)	fprintf(logfile,"%s : ERROR\t%s\n", logtime(), msg);
#define	LOGAFERR	fprintf(logfile,"%s : ERROR\t%s\n", logtime(), err_stack->e_text);
#define	LOGSECERR	fprintf(logfile,"%s : ERROR\t%s\n", logtime(), err_stack->e_text);
#define LOGUSER(N)	fprintf(logfile,"%s : NEW USER REGISTERED    <%s>\n", logtime(), N);
#define LOGCERT(C)	{char *name, *timebefore, *timeafter; \
			fprintf(logfile,"%s : CERTIFICATE ISSUED FOR <%s>\n                    Validity %s - %s\n",\
			logtime(), name=aux_DName2Name((C)->tbs->subject), \
                        timebefore=aux_readable_UTCTime((C)->tbs->valid->notbefore), \
			timeafter=aux_readable_UTCTime((C)->tbs->valid->notafter));\
			fprintf(logfile,"                    SerialNo: ");\
			aux_fprint_Serialnumber(logfile, (C)->tbs->serialnumber);\
			free(name); free(timebefore); free(timeafter);}

#define LOGCERTSIGN(C)	{char *name, *timebefore, *timeafter; \
			fprintf(logfile,"%s : SIGN CERTIFICATE ISSUED FOR <%s>\n                    Validity %s - %s\n",\
			logtime(), name=aux_DName2Name((C)->tbs->subject), \
                        timebefore=aux_readable_UTCTime((C)->tbs->valid->notbefore), \
			timeafter=aux_readable_UTCTime((C)->tbs->valid->notafter));\
			fprintf(logfile,"                    SerialNo: ");\
			aux_fprint_Serialnumber(logfile, (C)->tbs->serialnumber);\
			free(name); free(timebefore); free(timeafter);}

#define LOGCERTENCR(C)	{char *name, *timebefore, *timeafter; \
			fprintf(logfile,"%s : ENCR CERTIFICATE ISSUED FOR <%s>\n                    Validity %s - %s\n",\
			logtime(), name=aux_DName2Name((C)->tbs->subject), \
                        timebefore=aux_readable_UTCTime((C)->tbs->valid->notbefore), \
			timeafter=aux_readable_UTCTime((C)->tbs->valid->notafter));\
			fprintf(logfile,"                    SerialNo: ");\
			aux_fprint_Serialnumber(logfile, (C)->tbs->serialnumber);\
			free(name); free(timebefore); free(timeafter);}

#define LOGPEMCRL(C)    {char *name, *timenext; \
			fprintf(logfile,"%s : CRL ISSUED BY <%s>\n                    next update: %s\n",\
			logtime(), name=aux_DName2Name((C)->crl->tbs->issuer), \
			timenext=aux_readable_UTCTime((C)->crl->tbs->nextUpdate));\
			free(name); free(timenext);}

char	*logtime();

# ifndef FILE
# include <stdio.h>
# endif
extern FILE    *logfile;

#define USERDB	 "user"
#define CERTDB	 "cert"
#define CRLDB    "crlwithcerts"
