/* general.h - general compatibility */

/*
 * $Header: /ic/dev/isode/integration/isode/src/h/compat/RCS/general.h,v 10.12 1994/09/20 17:37:49 jmf Rel $
 *
 *
 * $Log: general.h,v $
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


#ifndef	_GENERAL_
#define	_GENERAL_

#ifndef P_
#ifdef __STDC__
#define P_(p) p
#else
#define P_(p) ()
#endif
#endif

#include "config.h"		/* system-specific configuration */
#include "manifest.h"
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* target-dependent defines:

	BSDFORK -	target has BSD vfork
	BSDLIBC -	target has real BSD libc
	SWABLIB -	target has byteorder(3n) routines
 */

#ifdef	SOCKETS
#define	SWABLIB
#endif

#ifdef	WINTLI
#define	SWABLIB
#endif

#ifdef	EXOS
#define	SWABLIB
#endif


#ifdef	BSD42
#define	BSDFORK
#define	BSDLIBC
#endif

#ifdef  SVR4_UCB
#ifndef SVR4
#define SVR4
#endif
#endif

#ifdef  SVR4
#ifndef SVR3
#define SVR3
#endif
#endif

#ifdef	ROS
#undef	BSDFORK
#undef	BSDLIBC
#ifndef	BSD42
#define	BSD42
#endif
#undef	SWABLIB
#endif

#ifdef	SYS5
#undef	BSDFORK
#undef	BSDLIBC
#endif

#ifdef	sgi
#undef	BSDFORK
#undef	BSDLIBC
#endif

#ifdef	HPUX
#define	BSDFORK
#undef	BSDLIBC
#undef	SWABLIB
#endif

#ifdef	pyr
#undef	SWABLIB
#endif

#ifdef	XOS
#undef	SWABLIB
#endif

#ifdef	XOS_2
#undef	SWABLIB
#endif

#ifdef  apollo
#undef  SWABLIB
#endif

#ifdef	AUX
#undef	BSDFORK
#undef SWABLIB
#define BSDLIBC
#endif

#ifndef	BSDFORK
#define	vfork	fork
#endif

/*    STRINGS */
#include <stdio.h>
#include <stdlib.h>

#ifdef NEED_MKTEMP_DECL
extern char *mktemp P_((
    char *
));
#endif

#ifndef __STDC__
# if defined(BSD44) || defined(_AIX) || defined(ultrix)
   void   *calloc (), *malloc (), *realloc ();
   void free();
# else
#  ifndef SVR4
#   ifdef HPUX
#    include <malloc.h>
#   else
     char   *calloc (), *malloc (), *realloc ();
     int free();
#   endif
#  endif
# endif /* defined BSD44 */
#endif

#include <string.h>

#if	(defined(SYS5) && !defined(_AIX) && !defined(XOS) && !defined(XOS_2) && !defined(HPUX)) || defined(__STDC__)
#   ifndef __STDC__
#       include <memory.h>
#   endif

#define	bcopy(b1,b2,length)	(void) memcpy ((b2), (b1), (length))
#define	bcmp(b1,b2,length)	memcmp ((b1), (b2), (length))
#define	bzero(b,length)		(void) memset ((b), 0, (length))
#endif
/*    HEXIFY */

extern int explode P_((
    register char *a,
    register unsigned char *b,
    register int n
));
extern int implode P_((
    register unsigned char *a,
    register char *b,
    register int n
));

/*    SPRINTB */

extern char *sprintb P_((
    register int v,
    register char *bits
));

/*    STR2VEC */

#define	NVEC	100
#define	NSLACK	10


#define	str2vec(s,v)	str2vecX ((s), (v), 0, NULLIP, '\0', 1)

extern int str2vecX P_((
    register char *s,
    register char **vec,
    int nmask,
    int *mask,
    register char brk,
    int docomma
));

/*    STR2ELEM */

#define	NELEM	100

extern int str2elem P_((
    char *s,
    unsigned int *elements
));

/*    STR2SEL */

extern int str2sel P_((
    char *s,
    int quoted,
    char *sel,
    int n
));
extern char *sel2str P_((
    char *sel,
    int len,
    int quoted
));

/*    GETPASS */

extern char *getpassword P_((
    char *prompt
));

/*    BADUSER */

extern int baduser P_((
    char *file,
    char *user
));

/*   UTILITIES */

extern char chrcnv[], nochrcnv[];


extern int lexequ P_((
    register char *str1,
    register char *str2
));
extern int lexnequ P_((
    register char *str1,
    register char *str2,
    int len
));

extern int sstr2arg P_((
    register char *srcptr,
    int maxpf,
    char **argv,
    char *dlmstr
));

extern VFP set_smalloc_handler P_((
    VFP fn
));
extern char *smalloc P_((
    int size
));

#ifdef NEED_STRDUP_DECL
extern char *strdup P_((
    register const char *str
));
#endif

/*    MISC */

extern char *sys_errname P_((
    int i
));

#ifdef	lint
#define	insque(e,p)	INSQUE ((char *) (e), (char *) (p))
#define	remque(e)	REMQUE ((char *) (e))
#endif

extern void asprintf P_((
    register char *bp,
    va_list ap
));
extern void _asprintf P_((
    register char *bp,
    char *what,
    va_list ap
));
extern void _vasprintf P_((
    register char *bp,
    char *what,
    char *fmt,
    va_list ap
));

extern void isodetailor P_((
    char *myname,
    int wantuser
));		/* also in tailor.h */

extern int selsocket P_((
    int nfds,
    fd_set *rfds,
    fd_set *wfds,
    fd_set *efds,
    int secs
));
extern int xselect P_((
    int nfds,
    fd_set *rfds,
    fd_set *wfds,
    fd_set *efds,
    int secs
));

/*  time */

#ifndef makedev
#include <sys/types.h>
#endif
#ifndef	OSX
#ifndef	BSD42
#ifdef _AIX
#include <sys/time.h>		/* Why is AIX always different ! */
#endif
#include <time.h>
#else  /* BSD42 */
#ifndef	timerisset
#include <sys/time.h>
#endif /* timerisset */
#endif /* BSD42 */
#endif /* OSX */

#ifndef __STDC__
extern time_t time ();
#endif


/*  ntohs etc */

#ifdef	NEED_BYTEORDER_DECL
#ifndef	ntohs
extern unsigned short ntohs P_((
    unsigned int
));
#endif
#ifndef	htons
extern unsigned short htons P_((
    unsigned int
));
#endif
#ifndef	ntohl
extern unsigned long ntohl P_((
    long unsigned int
));
#endif
#ifndef	htonl
extern unsigned long htonl P_((
    long unsigned int
));
#endif
#endif /* NEED_BYTEORDER_DECL */

extern int char2bcd P_((
    register char *s,
    int n,
    register u_char *d
));
extern int bcd2char P_((
    register u_char *s,
    register char *d,
    int len
));

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _GENERAL_ */
