/* logger.h - logging routines */

/* 
 * $Header: /ic/dev/isode/integration/isode/src/h/compat/RCS/logger.h,v 10.2 1994/09/20 17:38:05 jmf Rel $
 *
 *
 * $Log: logger.h,v $
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


#ifndef	_LOGGER_
#define	_LOGGER_

#ifndef P_
#ifdef __STDC__
#define P_(p) p
#else
#define P_(p) ()
#endif
#endif

#include "manifest.h"
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*  */

typedef struct  ll_struct {
    char   *ll_file;		/* path name to logging file */

    char   *ll_hdr;		/* text to put in opening line */
    char   *ll_dhdr;		/* dynamic header - changes */

    int	    ll_events;		/* interesting events */
#define	LLOG_NONE	0
#define	LLOG_FATAL	0x01	/*   fatal errors */
#define	LLOG_EXCEPTIONS	0x02	/*   exceptional events */
#define	LLOG_NOTICE	0x04	/*   informational notices */
#define	LLOG_PDUS	0x08	/*   PDU printing */
#define	LLOG_TRACE	0x10	/*   program tracing */
#define	LLOG_DEBUG	0x20	/*   full debugging */
#define	LLOG_ALL	0xff
#define	LLOG_MASK \
    "\020\01FATAL\02EXCEPTIONS\03NOTICE\04PDUS\05TRACE\06DEBUG"

    int	    ll_syslog;		/* interesting events to send to syslog */
				/*   takes same values as ll_events */

    int     ll_msize;		/* max size for log, in Kbytes */

    int     ll_stat;		/* assorted switches */
#define	LLOGNIL		0x00
#define	LLOGCLS		0x01	/*   keep log closed, except when writing */
#define	LLOGCRT		0x02	/*   create log if necessary */
#define	LLOGZER		0x04	/*   truncate log when limits reached */
#define	LLOGERR		0x08    /*   log closed due to (soft) error */
#define	LLOGTTY		0x10	/*   also log to stderr */
#define	LLOGHDR		0x20    /*   static header allocated */
#define	LLOGDHR		0x40    /*   dynamic header allocated */

    int     ll_fd;		/* file descriptor */
} LLog;

/*  */

#define	SLOG(lp,event,what,args) \
if (lp -> ll_events & (event)) { \
    (void) ll_log (lp, event, what, "%s", ll_preset args); \
} \
else

#ifndef	LLOG
#define	LLOG(lp,event,args)	SLOG (lp, event, NULLCP, args)
#endif

#ifdef	DEBUG
#define	DLOG(lp,event,args)	SLOG (lp, event, NULLCP, args)
#else
#define	DLOG(lp,event,args)
#endif


#ifdef	DEBUG

#ifdef PEPSY_VERSION

#ifdef __STDC__

#define	PLOGP(lp,args,pe,text,rw) \
    if ((lp) -> ll_events & LLOG_PDUS) { \
	pvpdu (lp, print_##args##_P, pe, text, rw); \
    } \
    else

#define	PLOG(lp,fnx,pe,text,rw)	\
    if ((lp) -> ll_events & LLOG_PDUS) { \
	pvpdu (lp, fnx##_P, pe, text, rw); \
    } \
    else

#else

#define	PLOGP(lp,args,pe,text,rw) \
    if ((lp) -> ll_events & LLOG_PDUS) { \
	pvpdu (lp, print_/**/args/**/_P, pe, text, rw); \
    } \
    else

#define	PLOG(lp,fnx,pe,text,rw)	\
    if ((lp) -> ll_events & LLOG_PDUS) { \
	pvpdu (lp, fnx/**/_P, pe, text, rw); \
    } \
    else

#endif

#else	/* !PEPSY_VERSION */

#define	PLOG(lp,fnx,pe,text,rw)	\
    if ((lp) -> ll_events & LLOG_PDUS) { \
	vpdu (lp, fnx, pe, text, rw); \
    } \
    else

#endif	/* !PEPSY_VERSION */

#ifdef	lint
#undef	PLOGP
#define	pvpdu(lp,cookie,pe,text,rw) \
	_pvpdu(lp, pe, text, rw)
#define	PLOGP(lp,args,pe,text,rw) \
	_pvpdu (lp, pe, text, rw);
#endif

#ifndef PLOGP
#define	PLOGP(lp,args,pe,text,rw) \
    if ((lp) -> ll_events & LLOG_PDUS) { \
	pvpdu (lp, 0, (struct modtype *) 0, pe, text, rw); \
    } \
    else
#endif

#else	/* !DEBUG */
#define	PLOG(lp,fnx,pe,text,rw)
#define	PLOGP(lp,args,pe,text,rw)
#endif


extern int ll_open P_((
    register LLog *lp
));
extern int _ll_log P_((
    register LLog *lp,
    int event,
    va_list ap
));
extern int ll_log P_((
    LLog   *lp,
    int event,
    char *what,
    char *fmt,
    ...
));
extern int ll_printf P_((
    LLog *lp,
    char *fmt,
    ...
));
extern int ll_close P_((
    register LLog *lp
));
extern int _ll_vlog P_((
    register LLog *lp,
    int event,
    char *what,
    char *fmt,
    va_list ap
));

extern void ll_hdinit P_((
    register LLog *lp,
    char *prefix
));
extern void ll_dbinit P_((
    register LLog *lp,
    char *prefix
));

extern int ll_sync P_((
    register LLog *lp
));

extern char *ll_preset P_((
    char *fmt,
    ...
));

extern int ll_check P_((
    register LLog *lp
));

extern int ll_defmhdr P_((
    char *bufferp,
    char *headerp,
    char *dheaderp
));
extern IFP ll_setmhdr P_((
    IFP make_header_routine
));
extern int log_tai P_((
    LLog *lgptr,
    char **av,
    int ac
));

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _LOGGER_ */

/******************************/
/* should be removed finally: */
/******************************/

#ifdef ULTRIX_X25_DEMSA
/* for Trace Information of module names */
#include <stdio.h>
char our_global_buffer[BUFSIZ];
#endif
