/* internet.h - TCP/IP abstractions */

/* 
 * $Header: /ic/dev/isode/integration/isode/src/h/ll/RCS/internet.h,v 10.4 1994/08/10 13:12:48 awy Rel $
 *
 *
 * $Log: internet.h,v $
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


#ifndef	_INTERNET_
#define	_INTERNET_

#ifndef P_
#ifdef __STDC__
#define P_(p) p
#else
#define P_(p) ()
#endif
#endif

#include "compat/manifest.h"

/*    SOCKETS */

#include "sys/socket.h"

#ifndef	SOMAXCONN
#define	SOMAXCONN	5
#endif

#if	defined(WIN) || defined(WINTLI)
#include "sys/in.h"
#else

#ifdef SVR4	/* Has a different defn for NULLVP */
#ifdef NULLVP 
#undef NULLVP
#endif
#endif /* SVR4 */
#include "netinet/in.h"
#ifdef SVR4	/* Put back the ISODE defn */
#ifdef NULLVP
#undef NULLVP
#endif
#define NULLVP ((char **) 0)
#endif /* SVR4 */

#endif /* defined(WIN) || defined(WINTLI) */

int	start_tcp_client (struct sockaddr_in *sock, int priv);
int	start_tcp_server (struct sockaddr_in *sock, int backlog, int opt1, int opt2);

#if defined(SOCKETS) && !(defined(TLI_TCP) || defined (XTI_TCP))
int	join_tcp_client (int fd, struct sockaddr_in *sock);
int	join_tcp_server (int fd, struct sockaddr_in *sock);
#define	read_tcp_socket		read
#define	write_tcp_socket	write
#define	select_tcp_socket	selsocket
#endif

#if defined(TLI_TCP) || defined (XTI_TCP)
int	join_tcp_client (int fd, struct sockaddr_in *sock);
int	join_tlitcp_client (int fd, struct sockaddr_in *sock, void *hook);
int	join_tcp_server (int fd, struct sockaddr_in *sock);
int	read_tcp_socket (int fd, char *buffer, int len);
int	write_tcp_socket (int fd, char *buffer, int len);
int	close_tcp_socket (int fd);
#define	select_tcp_socket	selsocket
#endif

#ifdef	WINTLI
int	join_tcp_client ();
int	join_tcp_server ();

#define	select_tcp_socket	selsocket
#endif

#ifdef	EXOS

#ifdef	SYS5
#define	join_tcp_client(s,f) \
	(accept ((s), (struct sockaddr *) (f)) != NOTOK ? (s) : NOTOK)
#define	join_tcp_server(s,t)	connect ((s), (struct sockaddr *) (t))

#define	read_tcp_socket		read
#define	write_tcp_socket	write
#define	close_tcp_socket	close
#define	select_tcp_socket	selsocket
#endif
#endif

int	read_tcp_socket ();
int	write_tcp_socket ();
int	close_tcp_socket (int fd);

int	select_tcp_socket ();

/*    UDP */

#ifdef	SOCKETS
#ifndef	_DGRAM_
#include "dgram.h"
#endif

int	start_udp_server (struct sockaddr_in *sock, int backlog, int opt1, int opt2);
#define	start_udp_client	start_udp_server

#define	join_udp_server(fd,sock) \
		join_dgram_aux ((fd), (struct sockaddr *) (sock), 0)
#define	join_udp_client(fd,sock) \
		join_dgram_aux ((fd), (struct sockaddr *) (sock), 1)

#define	read_udp_socket		read_dgram_socket
#define	write_udp_socket	write_dgram_socket
#define	close_udp_socket	close_dgram_socket

#define	select_udp_socket	select_dgram_socket
#define	check_udp_socket	check_dgram_socket
#endif

/*    NETDB */

#if	defined(SOCKETS) || defined (WINTLI) || defined (WIN)
#if     defined(_AIX) && defined(n_name)	/* different def in nlist.h clashes with netdb.h */
#undef n_name
#endif
#include <netdb.h>
#if   defined(_AIX) && defined(SYS5)
#define n_name          _n._n_name
#endif
#endif


#if	defined(BIND) && !defined(h_addr)
#define	h_addr	h_addr_list[0]
#endif

#define	inaddr_copy(hp,sin) \
    bcopy ((hp) -> h_addr, (char *) &((sin) -> sin_addr), (hp) -> h_length)


#ifdef	EXOS
struct hostent {
    char   *h_name;		/* official name */
    char  **h_aliases;		/* alias list */
    int     h_addrtype;		/* address type: AF_INET */
    int     h_length;		/* address length: sizeof (u_long) == 4 */
    char   *h_addr;		/* address value: (struct in_addr *) */
};

struct servent {
    char   *s_name;		/* official name */
    char  **s_aliases;		/* alias list */
    int     s_port;		/* port number */
    char   *s_proto;		/* protocol beneath service */
};


struct hostent *gethostbyaddr (), *gethostbyname ();
struct servent *getservbyname ();
#endif

#ifdef SVR4
#include <netdb.h>
#endif

struct hostent *gethostbystring (char *s);

/*    INET */

/* under BSD42, we could simply include <arpa/inet.h> instead.  However,
   the definition of inet_addr contained therein causes problems with some
   compilers. */

char   *inet_ntoa P_((/* ??? */));
#ifndef	DG
u_long	inet_addr P_((/* ??? */));
#ifndef	HPUX
u_long	inet_network P_((/* ??? */));
#else
int	inet_network ();
#endif
#else
struct in_addr inet_addr (), inet_network ();
#endif
#endif
