/* ./src/include/secsc_config.h */

/* 
 *
 * $Id: secsc_config.h,v 1.3 1994/11/02 10:44:39 surkau Exp $
 *
 * $Log: secsc_config.h,v $
 *
 */
 
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*-----------------------------------------------------------------------*/
/* INCLUDE FILE  secsc_config.h                                          */
/* Default values for the configuration file.				 */
/* The configuration file contains the PSE objects stored on the SC.     */
/*-----------------------------------------------------------------------*/
/*
 *
 *   filename.h defines:
 *           Names of PSE Objects (File-Names in the PSE)
 *
 *   secsc.h defines:
 *           SCObjEntry		(typedef struct SCObjEntry)
 *           SCPseEntry		(typedef struct SCPseEntry)
 *
 */

#ifndef _SCCONFIG_
#define _SCCONFIG_


#include "filename.h"
#include "secsc.h"


/*
 *  Initialization of the smartcard PSE list with default values
 */

  char		*default_sc_pse_list[] =
  {
    "polikom",
    "password",
    0
  };


  SCObjEntry	default_sc_obj_list[] =

/* keys: */
/*
  Name,		 Type,         key-   not     sm_SCT,       sm_SC_read         sm_SC_write   
                               no,    used,               command,  response,  cdo.,   resp., 
*/
  {
  AUTH_name,     SC_KEY_TYPE,  27,      0,    SCT_NORM,   SC_NORM,  SC_NORM,  SC_NORM,  SC_NORM,
  SM_AUTH_name,  SC_KEY_TYPE,  28,      0,    SCT_NORM,   SC_NORM,  SC_NORM,  SC_NORM,  SC_NORM,
  SM_CONC_name,  SC_KEY_TYPE,  29,      0,    SCT_NORM,   SC_NORM,  SC_NORM,  SC_NORM,  SC_NORM,
  SC_PIN_name,   SC_KEY_TYPE,  30,      0,    SCT_NORM,   SC_NORM,  SC_NORM,  SC_CONC,  SC_NORM,
  SC_PUK_name,   SC_KEY_TYPE,  31,      0,    SCT_NORM,   SC_NORM,  SC_NORM,  SC_CONC,  SC_NORM,

/* files: */
/*
  Name,		 Type,        short-  file-   sm_SCT,       sm_SC_read         sm_SC_write   
                              index,  size,               command,  response,  cdo.,  resp., 
*/
  PSE_PIN_name,  SC_FILE_TYPE, 15,      8,    SCT_CONC,   SC_NORM,  SC_CONC,  SC_NORM,  SC_NORM,

  0
  };






/*
 *  List of the mandatory objects belonging to one PSE on the SC:
 */
   
  char	*man_sc_obj_list[MAX_SCOBJ] =
  {
    SCToc_name,
    0
  };




/*
 *  List of the predefined objects belonging to one PSE on the SC:
 *
 *    These objects and their default values are added automatically
 *    to the object list belonging to one PSE,
 *    These objects should not be mentioned within the file ".starcosrc"
 */
   
  char	*predef_sc_obj_list[MAX_SCOBJ] =
  {
    AUTH_name,
    SM_CONC_name,
    SM_AUTH_name,
    PSE_PIN_name,
    SC_PUK_name,
    SC_PIN_name,
    0
  };



/*
 *  List of the mandatory objects belonging to an SC-PSE with one key pair:
 */
   
  char	*onekeypair_sc_obj_list[MAX_SCOBJ] =
  {
    SKnew_name,
    SKold_name,
    Cert_name,
    PKRoot_name,
    0
  };


/*
 *  List of the mandatory objects belonging to an SC-PSE with two key pairs:
 */
   
  char	*twokeypairs_sc_obj_list[MAX_SCOBJ] =
  {
    SignSK_name,
    DecSKnew_name,
    DecSKold_name,
    SignCert_name,
    EncCert_name,
    PKRoot_name,
   0
  };



#endif
