/* ./src/include/secsc_prototypes.h */

/* 
 *
 * $Id: secsc_prototypes.h,v 1.5 1995/03/01 15:06:36 viebeg Exp $
 *
 * $Log: secsc_prototypes.h,v $
 *
 */
 
#include <stdio.h>

#ifdef __STDC__
/***************************************************************
 *
 * Headers from file secure/starcos_man.c
 *
 ***************************************************************/ 
       int      inst_pse        (int sct_id, OctetString *appl_id, int n_des, int n_rsa, char *pin, char *puk, char *pse_pin);
       int      inst_MF 	(int sct_id, Boolean close);
       int      del_MF  	(int sct_id);
       int      close_MF	(int sct_id);
       int      del_pse 	(int sct_id, Boolean select, OctetString *appl_id);



/***************************************************************
 *
 * Headers from file secure/readconf.c
 *
 ***************************************************************/ 
       RC	read_SC_configuration		(WhichSCConfig which_SCconfig);
       RC	display_SC_configuration	(char *psename);
       RC	get_default_configuration	();
       RC	check_SCPSE_configuration	(char *pse_name, Boolean *onekeypair);
/***************************************************************
 *
 * Headers from file secure/secsc.c
 *
 ***************************************************************/ 
       RC 	secsc_replace_SCPSE	(char *old_pse_name, char *new_pse_name);
       RC 	secsc_install_SCPSE	(char *pse_name, char *pse_pin);
       RC	secsc_is_SCPSE_inst	(char *pse_name);
       RC	delete_SC		();
       RC	secsc_create	(PSESel *pse_sel);
       RC	secsc_open	(PSESel *pse_sel);
       RC	secsc_close	(PSESel *pse_sel);
       RC	secsc_delete	(PSESel *pse_sel);
       RC	secsc_write	(PSESel *pse_sel, OctetString *content);
       RC	secsc_read	(PSESel *pse_sel, OctetString *content);
       RC	secsc_chpin	(PSESel *pse_sel);
       RC	secsc_gen_key	(Key *key, Boolean replace);
       RC	secsc_sign	(OctetString *in_octets, Signature *signature, More more, Key *key, HashInput *hash_input);
       RC	secsc_verify	(OctetString *in_octets, Signature *signature, More more, Key *key, HashInput *hash_input);
       RC	secsc_encrypt	(OctetString *in_octets, BitString *out_bits, More more, Key *key);
       RC	secsc_decrypt	(BitString *in_bits, OctetString *out_octets, More more, Key *key);
       RC	secsc_get_EncryptedKey	(EncryptedKey *encrypted_key, Key *plain_key, Key *encryption_key);
       RC	secsc_put_EncryptedKey	(EncryptedKey *encrypted_key, Key *plain_key, Key *decryption_key, Boolean replace);
       RC	secsc_del_key		(KeyRef keyref);
       RC	secsc_unblock_SCpin	(PSESel *pse_sel);
#ifdef _SECSC_
       RC	secsc_sc_eject		(SCTSel sct_sel);
       SCObjEntry	*aux_PseObjData2SCObj	(char *pse_name, SCObjType type, unsigned int	 sc_id);
#endif
       char	*get_pse_pin_from_SC	(char *pse_name);
       SCObjEntry	*aux_PseObjName2SCObj	(char *pse_name, char *obj_name);
       SCPseEntry	*aux_PseName2SCPse	(char *pse_name);
       int	SC_configuration	();

       int	SCT_configuration	();
       int 	handle_SC_pse		(char *pse_name);
#ifdef _SCA_
       int 	delete_devkeyset	(OctetString *app_id, KeyDevSel *key_dev_info[], unsigned int no_of_devkeys, KeyDevStatus keyset_status);
       int 	gen_devkeyset		(OctetString *app_id, KeyDevSel *key_dev_info[], unsigned int no_of_devkeys);
       int 	load_devkeyset		(OctetString *app_id, KeyDevSel *key_dev_info[], unsigned int no_of_devkeys, KeyDevStatus keyset_status);
       int	pre_devkeyset		(char *pse_name, OctetString **app_id, KeyDevSel *key_dev_info[], unsigned int *no_of_devkeys);
       int 	write_on_keycards	(OctetString *app_id, KeyDevSel *key_dev_info[], unsigned int no_of_devkeys, char *keycard_pin);
#endif
       int	re_devkeyset		(char *pse_name);
       int 	release_SCT		(int sct_id);
       int	request_keycard		(Boolean new_keycard);
       int 	reset_SCT		(int sct_id);


#else
/***************************************************************
 *
 * Headers from file secure/starcos_man.c
 *
 ***************************************************************/ 
       int      inst_pse        ();
       int      inst_MF		();
       int      del_MF		();
       int      close_MF	();
       int      del_pse		();


/***************************************************************
 *
 * Headers from file secure/readconf.c
 *
 ***************************************************************/ 
       RC	read_SC_configuration		();
       RC	display_SC_configuration	();
       RC	get_default_configuration	();
       RC	check_SCPSE_configuration	();

/***************************************************************
 *
 * Headers from file secure/secsc.c
 *
 ***************************************************************/ 
       RC 	secsc_replace_SCPSE	();
       RC 	secsc_install_SCPSE	();
       RC	secsc_is_SCPSE_inst	();
       RC	delete_SC		();
       RC	secsc_create		();
       RC	secsc_open		();
       RC	secsc_close		();
       RC	secsc_delete		();
       RC	secsc_write		();
       RC	secsc_read		();
       RC	secsc_chpin		();
       RC	secsc_gen_key		();
       RC	secsc_sign		();
       RC	secsc_verify		();
       RC	secsc_encrypt		();
       RC	secsc_decrypt		();
       RC	secsc_get_EncryptedKey	();
       RC	secsc_put_EncryptedKey	();
       RC	secsc_del_key		();
       RC	secsc_unblock_SCpin	();
       RC	secsc_sc_eject		();
       char	*get_pse_pin_from_SC	();
       SCObjEntry	*aux_PseObjName2SCObj	();
       SCObjEntry	*aux_PseObjData2SCObj	();
       SCPseEntry	*aux_PseName2SCPse	();
       int	SC_configuration	();
       int	SCT_configuration	();
       int 	handle_SC_pse		();
       int 	delete_devkeyset	();
       int 	gen_devkeyset		();
       int 	load_devkeyset		();
       int	pre_devkeyset		();
       int	re_devkeyset		();
       int 	release_SCT		();
       int	request_keycard		();
       int 	reset_SCT		();
       int 	write_on_keycards	();


#endif
