/* ./src/include/secure.h */

/* 
 *
 * $Id: secure.h,v 1.8 1995/02/21 14:50:53 surkau Exp $
 *
 * $Log: secure.h,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*-----------------------------------------------------------------------*/
/* INCLUDE FILE  secure.h                                                */
/* Definition of structures and types for the basic security functions   */
/*-----------------------------------------------------------------------*/

#ifndef _SECURE_
#define _SECURE_

#include "sec_config.h"

#include <string.h>

extern char *getenv();

/* Declaration of build- and parse-routines */
#ifndef testt
#include "SEC-types.h"
#endif

#ifdef MS_DOS
#define chmod(a,b)
#endif /*MS_DOS*/

#include <sys/time.h>


#include "sec_global.h"


extern char *secude_version;


typedef SET_OF(OctetString)     SET_OF_OctetString;

typedef SET_OF(ObjId)           SET_OF_ObjId;
typedef SET_OF(AlgId)           SET_OF_AlgId;
typedef struct Key              Key;
typedef int                     KeyRef;
typedef struct PSE_Sel          PSESel;
typedef struct PSE_Toc          PSEToc;
typedef struct PSE_Object       PSEObject;

/*-----------------------------------------------------------------------*/
/*    P S E                                                              */
/*-----------------------------------------------------------------------*/

#include "filename.h"
 
struct PSE_Sel {
        char    *app_name;       /* Appl name or PSE name           */
        char    *pin;            /* PSE-PIN or password             */
        struct {
           char *name;
           char *pin;
        }        object;         /* object name and PIN             */
        int      app_id;         /* application id, 0 if default    */
};


/*
 *      Table of Contents of PSE
 */

struct PSE_Toc {
        char                    *owner;
        UTCTime                 *create;
        UTCTime                 *update;
        unsigned int            status;
        struct PSE_Objects      *obj;
};

struct PSE_Objects {
        char                    *name;
        UTCTime                 *create;
        UTCTime                 *update;
        int                     noOctets;
        unsigned int            status;
        struct PSE_Objects      *next;
};

struct PSE_Object {
        ObjId         *objectType;
        OctetString   *objectValue;
        PE             asn;
};





typedef enum {
        ERR_in_pseconfig = -1,
        NOT_ON_SC, 
        PSE_ON_SC, 
        FILE_ON_SC, 
        KEY_ON_SC
} PSEConfig;

PSEConfig sec_pseconfig();


typedef enum {
        ERR_in_psetest = -1,
        SWpse = 0, 
        SCpse = 1 
} PSELocation;


typedef enum {
        ERR_in_scttest = -1,
        SCTDev_not_avail = 0, 
        SCTDev_avail = 1,
        SCTDev_lock = 2,
        SCTDev_not_config = 3
} SCTDevice;




/*-----------------------------------------------------------------------*/
/*    K e y ' s   and   S i g n a t u r e                                */
/*-----------------------------------------------------------------------*/



struct Key {
        KeyInfo  *key;
        KeyRef    keyref;
        PSESel   *pse_sel;
        AlgId    *alg;
};



                 

/*-----------------------------------------------------------------------*/
/*  The key reference (integer) of the SEC-IF can be used to address     */
/*      - a key stored on the SC (DF-level) or                           */
/*      - a key stored in the SCT or                                     */
/*      - a key stored in the key pool (SW-PSE).                         */
/*  The following masks are used to indicate the address of the key.     */
/*-----------------------------------------------------------------------*/

#define        SC_KEY      0xFF010000  /* Address a key on the SC on DF-level   */
#define        SCT_KEY     0xFF020000  /* Address a key in the SCT              */
#define        KeyPool_KEY 0x00000000  /* Address a key in the keypool (SW-PSE) */


typedef enum {
        F_NOT_EXISTING = 15,
        F_DIRECTORY, 
        F_FILE, 
        F_OTHER,
        F_ERROR
} FILE_Type;


#include "sec_prototypes.h"
/*
 *  sec_asn1_length_encoding controls the ASN.1 length encoding of the 
 *  e_*() functions. DEFINITE or INDEFINITE encoding can be chosen.
 *  For the sake of distinguished ASN.1 encoding either of the two 
 *  methods must be agreed and fixed between all participants of the
 *  security infrastructure. X.509 says DEFINITE shall be used for
 *  DER encoding. sec_asn1_length_encoding is defined in sec_init.c
 *  and set to DEFINITE by default.
 *
 *  Don't change this parameter unless you are sure what you are doing, 
 *  otherwise the verification of certificates could yield some surprises.
 */ 

extern int sec_asn1_length_encoding;
#define INDEFINITE 1
#define DEFINITE   2

extern Boolean aux_localtime;   /* if TRUE, UTCTime is generated as local time
                                   else UTCTime is generated as GMT time  */

extern Boolean sec_time, sec_onekeypair;
#define SHORT_HELP 0
#define LONG_HELP 1

#define ONEKEYPAIRONLY   1
#define FINGERPRINT_ALG  md5
#define MSBITINBYTE 0x80

#ifdef SCA
#include "secsc.h"
#endif
extern Boolean sec_sca;



extern char *input_device; /* device to read inputs from */

extern Boolean random_from_pse;         /* if TRUE, read random number from PSE */



#endif
