/* ./src/include/starcos_man.h */

/* 
 *
 * $Id: starcos_man.h,v 1.3 1994/11/02 10:44:39 surkau Exp $
 *
 * $Log: starcos_man.h,v $
 *
 */
 
/*------------------------------------------------------------------*/
/*                                                                  */
/*  Dateiname  : INCLUDE FILE  install.h                            */
/*                                                                  */
/*------------------------------------------------------------------*/
/*                                                                  */
/*  GMD Darmstadt                                                   */
/*  Projekt    : STAPAC                                             */
/*  Datum      : Januar 1992                                        */
/*  Autorin    : Helga Parslow                                      */
/*                                                                  */
/*               Definitionen von Strukturen und Typen fr die      */
/*               STARMAC-interne Schnittstelle zwischen             */
/*               Definition und Installation von Anwendungen        */
/*                                                                  */
/*                                                                  */
/*                                                                  */
/*------------------------------------------------------------------*/

/*
 *   secure.h definiert:
 *
 *         AlgId,
 *         Bitstring,
 *         HashInput,
 *         KeyInfo,
 *         More,
 *         OctetString,
 *         Signature,

 *         #include "secure.h"
 */

#ifndef _SCA_
#include "sca.h"
#endif


#define USER    1
#define CA      2

#define LNGUNION	143

#define ACV	AccessControlValue

typedef enum {SEC_NORMAL,AUTHENTIC,CONCEALED,COMBINED}
SecMessMode;

typedef struct	Sec_Mess {
		SecMessMode command;
                SecMessMode response;
               	} SecMess;

/*-------------------------------------------------------------------------*/
/* Struktur fr String berlagerung der Kommandos mit einem String         */
/*-------------------------------------------------------------------------*/

/*      definiert am Ende der Datei
typedef union
	{
	s_Create        sCreate;
	s_Write         sWrite;
	s_Read          sRead;
	s_Device        sDevice;
	s_InstPin       sInstPin;
	s_GenUserKey    sGenUserKey;
	s_GenDevKey     sGenDevKey;
	s_InstDevKey    sInstDevKey;
	s_RdKeyCard     sRdKeyCard;
	s_WrKeyCard     sWrKeyCard;
	s_Auth          sAuth;
	s_Close         sClose;

	i_PrintForm     iPrint_Form;
	i_GenPin        iGenPin;
	char            data [];

	}u_Cmd;                                                            */


/*-------------------------------------------------------------------------*/
/* Struktur fr sca_create-Kommando                                        */
/*-------------------------------------------------------------------------*/

typedef struct
        {
        int             sct_id;
        FileCat         file_cat;
        FileType        file_type;
        FileSel         file_sel;
        DataStruc       data_struc;
        FileControlInfo FCI;
        FileId		file_id;
        SecMess      	sec_mess;
	OctetString	fn_os;
	OctetString	add_os;
	char            addinfo [5];
	char            filename [13];
        }s_Create;

/*-------------------------------------------------------------------------*/
/*  Struktur fr sca_close-Kommando                                        */
/*-------------------------------------------------------------------------*/

typedef struct
        {
        int             sct_id;
        FileCat         file_cat;
        FileSel         file_sel;
        FileCloseContext file_close_context;
        SecMess      	sec_mess;
        FileId		file_id;
	OctetString	fn_os;
	unsigned int    units;
	char            filename [13];

	}s_Close;

/*-------------------------------------------------------------------------*/
/* Struktur fr sca_write-Kommando                                         */
/*-------------------------------------------------------------------------*/

typedef struct
        {
        int             sct_id;
        FileId          file_id;
	DataStruc       data_struc;
	int		offset;
	SecMess      	sec_mess;
	char            source_name [13];
	OctetString	fn_os;

        }s_Write;

/*-------------------------------------------------------------------------*/
/* Struktur fr sca_register-Kommando                                      */
/*-------------------------------------------------------------------------*/

typedef struct
        {
        int             sct_id;
	int             memory_units;
	KeyId           auth_key_id;
        ACV		sec_status;
        SecMess     	sec_mess;
	OctetString	df_name;
	char            file_name [13];

        }s_Register;

/*-------------------------------------------------------------------------*/
/* Struktur fr sca_read-Kommando                                          */
/*-------------------------------------------------------------------------*/

typedef struct
        {
        int             sct_id;
        FileId          file_id;
        OctetString     data_sel;
        int             data_length;
	OctetString     *out_data;
        SecMess      	sec_mess;
	char            data [1];

	}s_Read;

/*-------------------------------------------------------------------------*/
/* Struktur fr sca_select_device-Kommando                                 */
/*-------------------------------------------------------------------------*/

typedef struct
	{
	int             sct_id;

	}s_Device;

/*-------------------------------------------------------------------------*/
/* Struktur fr sca_init_sc-Kommando                                       */
/*-------------------------------------------------------------------------*/

typedef struct
	{
	int             sct_id;
	char            *text;
	int             time_out;

	}s_InitSc;

/*-------------------------------------------------------------------------*/
/* Struktur fr sca_inst_Pin-Kommando                                      */
/*-------------------------------------------------------------------------*/

typedef struct
	{
	int             sct_id;
	KeyId           key_id;
	VerifyDataStruc pin;
	KeyAttrList     key_al;
	KeyId           pin_key_id;
	OctetString	info_os;
	int             l_pin;
	int             l_clr;
	int             l_Min;

	}s_InstPin;

/*-------------------------------------------------------------------------*/
/* Struktur fr sca_gen_user_key-Kommando                                  */
/*-------------------------------------------------------------------------*/

typedef struct
	{
	int             sct_id;
	KeySel          key_sel;
	AlgId           key_algid;
	KeyAttrList     key_al;

	KeyId           key_id;
	KeyBits         key_bits;
	unsigned int    alg_id;
	unsigned int    parm;
	char            pkey_name [13];

	}s_GenUserKey;

/*-------------------------------------------------------------------------*/
/* Struktur fr sca_gen_dev_key-Kommando            und                    */
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/* Struktur fr sca_inst_dev_key-Kommando                                  */
/*-------------------------------------------------------------------------*/

typedef struct
	{
	int             sct_id;
	AlgId           *key_algid;
	KeyId           key_id;
	KeyDevSel   	key_dev_sel;
	KeyAttrList     key_al;

	unsigned int    alg_id;
	unsigned int    parm;

	OctetString     appl_id;
	char            appl_name [8];

	}s_DevKey;

/*-------------------------------------------------------------------------*/
/* Struktur fr sca_read_keycard-Kommando                                  */
/*-------------------------------------------------------------------------*/

typedef struct
	{
	int             sct_id;
	int             auth_key_id;

	}s_RdKeyCard;

/*-------------------------------------------------------------------------*/
/* Struktur fr sca_write_keycard-Kommando                                 */
/*-------------------------------------------------------------------------*/

typedef struct
	{
	int             sct_id;
	int             auth_key_id;

	}s_WrKeyCard;

/*-------------------------------------------------------------------------*/
/* Struktur fr sca_auth-Kommando                                          */
/*-------------------------------------------------------------------------*/

typedef struct
	{
	int             sct_id;
	AuthProcId      auth_proc_id;           /* des_auth = 4            */
	AuthObjectId    auth_object_id;         /* was wird authentiziert  */

	}s_Auth;

/*-------------------------------------------------------------------------*/
/*                                                                         */
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
/* Struktur fr i_Print_Form-Kommando                                      */
/*-------------------------------------------------------------------------*/

typedef struct
	{
	char    text [32];

	}i_PrintForm;

/*-------------------------------------------------------------------------*/
/* Struktur fr i_Gen_Pin-Kommando                                         */
/*-------------------------------------------------------------------------*/

typedef struct
	{
	int     lng;

	}i_GenPin;


/*-------------------------------------------------------------------------*/
/* Struktur fr String-berlagerung der Kommandos mit einem String         */
/*-------------------------------------------------------------------------*/


typedef union
	{
	s_Create        sCreate;
	s_Write         sWrite;
	s_Read          sRead;
	s_Device        sDevice;
	s_InitSc        sInitSc;
	s_InstPin       sInstPin;
	s_GenUserKey    sGenUserKey;
	s_DevKey     	sGenDevKey;
	s_DevKey    	sInstDevKey;
	s_RdKeyCard     sRdKeyCard;
	s_WrKeyCard     sWrKeyCard;
	s_Auth          sAuth;
	s_Close         sClose;
	s_Register      sRegister;

	i_PrintForm     iPrint_Form;
	i_GenPin        iGenPin;
	char            data [LNGUNION];

	}u_Cmd;


/*-------------------------------------------------------------------------*/
/* Struktur fr verkettete Liste von Kommandos                             */
/*-------------------------------------------------------------------------*/

typedef	struct	pCmd {
		char	action;
		u_Cmd	*cmd;
		struct	pCmd	*next;

		}p_Cmd;


typedef	struct	iCmd {
		int	index;
		p_Cmd	*wef;
		struct	iCmd	*next;

		}i_Cmd;


typedef	struct	sCmd {
		int	units;
		p_Cmd	*mdf;
		p_Cmd	*acf;
		p_Cmd	*isf;
		p_Cmd	*rsa;
		p_Cmd	*pef;
		i_Cmd	*wef;
		p_Cmd	*clo;

		struct	sCmd	*next;

		}s_Cmd;
