/* str2vec.c - string to vector */

#ifndef	lint
static char *rcsid = "$Header: /ic/dev/isode/integration/isode/src/lib/compat/RCS/str2vec.c,v 10.2 1994/09/08 07:41:06 awy Rel $";
#endif

/* 
 * $Header: /ic/dev/isode/integration/isode/src/lib/compat/RCS/str2vec.c,v 10.2 1994/09/08 07:41:06 awy Rel $
 *
 *
 * $Log: str2vec.c,v $
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


/* LINTLIBRARY */

#include <ctype.h>
#include <stdio.h>
#include "compat/general.h"
#include "compat/manifest.h"


#define	QUOTE	'\\'

/*  */

int	str2vecX (register char *s, register char **vec, int nmask, int *mask, register char brk, int docomma)
{
    register int    i;
    char    comma = docomma ? ',' : ' ';

    if (mask)
	*mask = 0;

    for (i = 0; i <= NVEC;) {
	vec[i] = NULL;
	if (brk > 0) {
	    if (i > 0 && *s == brk)
		*s++ = 0;
	}
	else
	    while (isspace ((u_char) *s) || *s == comma)
		*s++ = 0;
	if (*s == 0)
	    break;

	if (*s == '"') {
	    if (i < nmask)
		*mask |= 1 << i;
	    for (vec[i++] = ++s; *s != 0 && *s != '"'; s++)
		if (*s == QUOTE) {
		    if (*++s == '"')
			(void) strcpy (s - 1, s);
		    s--;
		}
	    if (*s == '"')
		*s++ = 0;
	    continue;
	}
	if (*s == QUOTE && *++s != '"')
	    s--;
	vec[i++] = s;

	if (brk > 0) {
	    if (*s != brk)
		for (s++; *s != 0 && *s != brk; s++)
		    continue;
	}
	else
	    for (s++; *s != 0 && !isspace ((u_char) *s) && *s != comma; s++)
		continue;
    }
    vec[i] = NULL;

    return i;
}
