/* strb2bitstr.c - string of bits to bit string */

#ifndef	lint
static char *rcsid = "$Header: /ic/dev/isode/integration/isode/src/lib/asn1/ber/RCS/strb2bitstr.c,v 10.3 1994/02/17 17:18:13 awy Rel $";
#endif

/* 
 * $Header: /ic/dev/isode/integration/isode/src/lib/asn1/ber/RCS/strb2bitstr.c,v 10.3 1994/02/17 17:18:13 awy Rel $
 *
 *
 * $Log: strb2bitstr.c,v $
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


/* LINTLIBRARY */

#include <stdio.h>
#include "asn1/asn1.h"

/*  */

PE	strb2bitstr (register char *cp, register int len, PElementClass class, PElementID id)
{
    register int    i,
		    j,
                    bit,
		    mask;
    register PE	    p;

    if ((p = pe_alloc (class, PE_FORM_PRIM, id)) == NULLPE)
	return NULLPE;

    p = prim2bit (p);
    if (len > 0 && bit_off (p, len - 1) == NOTOK) {
no_mem: ;
        pe_free (p);
        return NULLPE;
    }

    for (bit = (*cp & 0xff), i = 0, mask = 1 << (j = 7); i < len; /* i++ */) {
	if ((bit & mask) && bit_on (p, i) == NOTOK)
	    goto no_mem;
	if ((++i < len) && (j-- == 0))
	    bit = *++cp & 0xff, mask = 1 << (j = 7);
	else
	    mask >>= 1;
    }

    return p;
}
