/* ./src/pem/pem_cnvt.c */

static char *rcsid = "$Id: pem_cnvt.c,v 1.7 1995/02/28 11:56:55 surkau Exp $";

/* 
 *
 * $Id: pem_cnvt.c,v 1.7 1995/02/28 11:56:55 surkau Exp $
 *
 * $Log: pem_cnvt.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*-----------------------pem_cnvt.c---------------------------------*/
/*------------------------------------------------------------------*/
/* GMD Darmstadt Institut fuer TeleKooperationsTechnik (I2)         */
/* Rheinstr. 75 / Dolivostr. 15                                     */
/* 6100 Darmstadt                                                   */
/* Project ``Secure DFN'' 1990 / "SecuDe" 1991,92,93                */
/* 	Grimm/Nausester/Schneider/Viebeg/Vollmer/                   */
/* 	Surkau/Reichelt/Kolletzki                     et alii       */
/*------------------------------------------------------------------*/
/*                                                                  */
/* PACKAGE   pem             VERSION   3.0                          */
/*                              DATE   01.04.1994                   */
/*                                BY   Surkau                       */
/*                                                                  */
/*                            REVIEW                                */
/*                              DATE                                */
/*                                BY                                */
/* DESCRIPTION                                                      */
/*   This modul presents functions to convert                       */
/*   PEM message parameters between                   	            */
/*   canonical and local forms                                      */
/*                                                                  */
/* EXPORT                                                           */
/*                                                                  */
/*  pem_Local2Canon()                                               */
/*  pem_Canon2Local()                                               */
/*  pem_Local2CanonSet()                                            */
/*  pem_Canon2LocalSet()                                            */
/*  pem_proctypes()                                                 */
/*                                                                  */
/* CALLS TO                                                         */
/*                                                                  */
/*  aux_ functions                                                  */
/*  e_ functions                                                    */
/*  d_ functions                                                    */
/*                                                                  */
/*------------------------------------------------------------------*/
#include "pem.h"



/*------------------------------------------------------------------
  pem_proctypes() counts the number of Proc-Type's in a local
  message set. The result is returned in an integer array.
  As index the enumeration PEM_Proc_Types is used.
  ...[PEM_MCC] is the number of MIC-Clear messages,
  ...[NO_PEM] the number of non PEM messages.
  If ...[0] == -1, no PEM mcc, mco or encr message is found.
------------------------------------------------------------------*/
/***************************************************************
 *
 * Procedure pem_proctypes
 *
 ***************************************************************/
#ifdef __STDC__

int *pem_proctypes(
	SET_OF_PemMessageLocal	 *local
)

#else

int *pem_proctypes(
	local
)
SET_OF_PemMessageLocal	 *local;

#endif

{
	char	*proc = "pem_proctypes";
	int 	*numbers = (int *)calloc(NO_PEM + 1, sizeof(int)),
		 pem = 0;

	if(!numbers){
		aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
		return((int *)0);
	}

	for(;local; local = local->next) 
		if(local->element)
			if(local->element->header) {
				if(local->element->header->proctype < 0 || local->element->header->proctype >= NO_PEM) {
					aux_add_error(EINVALID, "Invalid Proc-Type number", CNULL, 0, proc);
					free(numbers);
					return((int *)0);
				}
				if(local->element->header->proctype == PEM_ENC ||
				   local->element->header->proctype == PEM_MCC ||
				   local->element->header->proctype == PEM_MCO) pem++;
				numbers[local->element->header->proctype]++;
			}
			else numbers[NO_PEM]++;

	if(!pem) numbers[0] = -1;

	return(numbers);

}

/*------------------------------------------------------------------
  rfc64toOctetString() strips ind chars at the beginning of
  each line, concats the lines and decodes it to an OctetString
------------------------------------------------------------------*/
/***************************************************************
 *
 * Procedure rfc64toOctetString
 *
 ***************************************************************/
#ifdef __STDC__

static OctetString *rfc64toOctetString(
	char	 *string,
	int	  ind
)

#else

static OctetString *rfc64toOctetString(
	string,
	ind
)
char	 *string;
int	  ind;

#endif

{
	char		*proc = "rfc64toOctetString";
	OctetString 	 tmp_ostr1,
			*tmp_ostr2,
			*res_ostr;
		
	tmp_ostr1.noctets = strlen(string);
	tmp_ostr1.octets = string;

	if(!(tmp_ostr2 = aux_de64(&tmp_ostr1, ind))){
		AUX_ADD_ERROR;
		return((OctetString *) 0);
	}
	if(!(res_ostr = aux_decrfc(tmp_ostr2))){
		AUX_ADD_ERROR;
		 aux_free_OctetString(&tmp_ostr2);
		return((OctetString *) 0);
	}
	aux_free_OctetString(&tmp_ostr2);

	return(res_ostr);


}

/*------------------------------------------------------------------
  rfc64toBitString() strips ind chars at the beginning of
  each line, concats the lines and decodes it to a BitString
------------------------------------------------------------------*/
/***************************************************************
 *
 * Procedure rfc64toBitString
 *
 ***************************************************************/
#ifdef __STDC__

static BitString *rfc64toBitString(
	char	 *string,
	int	  ind
)

#else

static BitString *rfc64toBitString(
	string,
	ind
)
char	 *string;
int	  ind;

#endif

{
	char		*proc = "rfc64toBitString";
	OctetString 	*tmp_ostr = rfc64toOctetString(string, ind);
	BitString 	*res_bstr;
		
	if(!tmp_ostr){
		AUX_ADD_ERROR;
		return((BitString *)0);
	}

	res_bstr = (BitString *)tmp_ostr;

	res_bstr->nbits *= 8;

	return(res_bstr);


}
/*------------------------------------------------------------------
  OctetStringtorfc64() encodes the OctetString and splits into
  64 character lines with a leading space character
------------------------------------------------------------------*/
/***************************************************************
 *
 * Procedure OctetStringtorfc64
 *
 ***************************************************************/
#ifdef __STDC__

static char *OctetStringtorfc64(
	OctetString	 *ostr,
	int		  ind
)

#else

static char *OctetStringtorfc64(
	ostr,
	ind
)
OctetString	 *ostr;
int		  ind;

#endif

{
	static OctetString 	 blank_ostr = { 1, " " },
				 empty_ostr = { 0, "" };
	OctetString 		*tmp_ostr2,
				*res_ostr;
	char 			*string,
				*proc = "OctetStringtorfc64";


	if(!(tmp_ostr2 = aux_encrfc(ostr))){
		AUX_ADD_ERROR;
		return(CNULL);
	}
	if(!(res_ostr = aux_64(tmp_ostr2, ind ? &blank_ostr : &empty_ostr))){
		AUX_ADD_ERROR;
		 aux_free_OctetString(&tmp_ostr2);
		return(CNULL);
	}
	aux_free_OctetString(&tmp_ostr2);
	if(!(string = CATNSTR(CNULL, res_ostr->octets, res_ostr->noctets))){
		AUX_ADD_ERROR;
		 aux_free_OctetString(&res_ostr);
		return(CNULL);
	}
	aux_free_OctetString(&res_ostr);

	return(string);


}
/*------------------------------------------------------------------
  BitStringtorfc64() encodes the BitString and splits into
  64 character lines with a leading space character
------------------------------------------------------------------*/
/***************************************************************
 *
 * Procedure BitStringtorfc64
 *
 ***************************************************************/
#ifdef __STDC__

static char *BitStringtorfc64(
	BitString	 *bstr,
	int		  ind
)

#else

static char *BitStringtorfc64(
	bstr,
	ind
)
BitString	 *bstr;
int		  ind;

#endif

{
	OctetString 	 ostr;
	char 		*string,
			*proc = "BitStringtorfc64";

	ostr.noctets = (bstr->nbits + 7 ) / 8;
	if(!(ostr.octets = (char *)malloc( ostr.noctets + 1))) {
		aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
		return( CNULL);
	}

	bcopy(bstr->bits, ostr.octets, ostr.noctets);

	if(bstr->nbits%8) ostr.octets[ostr.noctets-1] &= (1 << (bstr->nbits%8)) - 1; 

	if(!(string = OctetStringtorfc64(&ostr, ind))){
		AUX_ADD_ERROR;
		 free(ostr.octets);
		return(CNULL);
	}
	free(ostr.octets);



	return(string);

}

/*------------------------------------------------------------------
  pem_Local2Canon() converts a message from a local to
  a canonical structure. It uses ASN.1 and RFC 8 to 6 bit
  encoding and transforms enumerations or AlgId's to the
  representing names.
------------------------------------------------------------------*/
/***************************************************************
 *
 * Procedure pem_Local2Canon
 *
 ***************************************************************/
#ifdef __STDC__

PemMessageCanon *pem_Local2Canon(
	PemMessageLocal	 *local
)

#else

PemMessageCanon *pem_Local2Canon(
	local
)
PemMessageLocal	 *local;

#endif

{
	
	PemMessageCanon 		*canon;
	OctetString 			 tmp_ostr1,
					*tmp_ostr2,
					*tmp_ostr3,
					*tmp_body;
	PemHeaderCanon 			*chd;
	PemHeaderLocal 			*lhd;
	SET_OF_PemRecLocal		*lrecips;
	SET_OF_PemRecCanon		*crecips;
	SET_OF_Certificate		*lcerts,
					*cross;
	SET_OF_Name			*ccerts,
					*issuer_certs,
					*crl_issuer_certs,
					*ccrlrrs;
	SET_OF_CRLWithCertificates	*lcrls;
	SET_OF_PemCrlCanon		*ccrls;
	SET_OF_DName			*lcrlrrs;
	FCPath 				*path;
	char				*proc = "pem_Local2Canon";

	if(!local) return((PemMessageCanon *) 0);

	if(!(canon = ( PemMessageCanon *)calloc(1, sizeof( PemMessageCanon)))) {
		aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
		return( (PemMessageCanon *) 0);
	}

	lhd = local->header;
	if(lhd) {

		if(!(canon->header = ( PemHeaderCanon *)calloc(1, sizeof( PemHeaderCanon)))) {
			aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
			 aux_free_PemMessageCanon(&canon);
			return( (PemMessageCanon *) 0);
		}

		chd = canon->header;



		if(lhd->rfc_version) if(!(chd->rfc_version = CATSPRINTF(CNULL, "%d",lhd->rfc_version))){
			aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
			aux_free_PemMessageCanon(&canon);
			return((PemMessageCanon *) 0);
		}

		if(lhd->proctype >= PEM_ENC && lhd->proctype <=PEM_MCC)
			if(!(chd->proctype = aux_cpy_String(proc_type_t[lhd->proctype].name))){
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				aux_free_PemMessageCanon(&canon);
				return((PemMessageCanon *) 0);
			}

		if(lhd->content_domain == PEM_RFC822 || lhd->content_domain == PEM_MIME)
			if(!(chd->content_domain = aux_cpy_String(content_domain[lhd->content_domain].name))){
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				aux_free_PemMessageCanon(&canon);
				return((PemMessageCanon *) 0);
			}

		if(lhd->dek_fields) {
			if(!(chd->dek_fields = ( PemDekCanon *)calloc(1, sizeof( PemDekCanon)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_PemMessageCanon(&canon);
				return( (PemMessageCanon *) 0);
			}

			if(lhd->dek_fields->dekinfo_enc_alg) {

				if(!(chd->dek_fields->dekinfo_enc_alg = aux_ObjId2Name(lhd->dek_fields->dekinfo_enc_alg->objid))){
					AUX_ADD_ERROR;
					 aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}
				if(!lhd->dek_fields->dekinfo_enc_alg->param) chd->dek_fields->dekinfo_param = CNULL;
				else {
					if(!(tmp_ostr2 = aux_enchex((OctetString *)lhd->dek_fields->dekinfo_enc_alg->param))){
						AUX_ADD_ERROR;
						 aux_free_PemMessageCanon(&canon);
						return((PemMessageCanon *) 0);
					}
	
					if(!(chd->dek_fields->dekinfo_param = CATNSTR(CNULL, tmp_ostr2->octets, tmp_ostr2->noctets))){
						AUX_ADD_ERROR;
						aux_free_OctetString(&tmp_ostr2); aux_free_PemMessageCanon(&canon);
						return((PemMessageCanon *) 0);
					}
	
					aux_free_OctetString(&tmp_ostr2);
				}
			}
			if(lhd->dek_fields->keyinfo_enc_alg)
				if(!(chd->dek_fields->keyinfo_enc_alg = aux_ObjId2Name(lhd->dek_fields->keyinfo_enc_alg->objid))){
					AUX_ADD_ERROR;
					 aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}

			if(lhd->dek_fields->keyinfo_dek)
				if(!(chd->dek_fields->keyinfo_dek = BitStringtorfc64(lhd->dek_fields->keyinfo_dek, 1))){
					AUX_ADD_ERROR;
					 aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}

			for(lrecips = lhd->dek_fields->recipients; lrecips; lrecips = lrecips->next ) {
				if(chd->dek_fields->recipients) {
					if(!(crecips->next = ( SET_OF_PemRecCanon *)calloc(1, sizeof( SET_OF_PemRecCanon)))) {
						aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
						 aux_free_PemMessageCanon(&canon);
						return( (PemMessageCanon *) 0);
					}
					crecips = crecips->next;
				}
				else {
					if(!(crecips = ( SET_OF_PemRecCanon *)calloc(1, sizeof( SET_OF_PemRecCanon)))) {
						aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
						 aux_free_PemMessageCanon(&canon);
						return( (PemMessageCanon *) 0);
					}
					chd->dek_fields->recipients = crecips;
				}
				crecips->next = (SET_OF_PemRecCanon *)0;

				if(lrecips->element) {
					if(!(crecips->element = ( PemRecCanon *)calloc(1, sizeof( PemRecCanon)))) {
						aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
						 aux_free_PemMessageCanon(&canon);
						return( (PemMessageCanon *) 0);
					}

					if(lrecips->element->enc_alg)
						if(!(crecips->element->enc_alg = aux_ObjId2Name(lrecips->element->enc_alg->objid))){
							AUX_ADD_ERROR;
							aux_free_PemMessageCanon(&canon);
							return((PemMessageCanon *) 0);
						}
					if(lrecips->element->dek)
						if(!(crecips->element->dek = BitStringtorfc64(lrecips->element->dek, 1))){
							AUX_ADD_ERROR;
							aux_free_PemMessageCanon(&canon);
							return((PemMessageCanon *) 0);
						}
					if(lrecips->element->certificate && lrecips->element->certificate->tbs) {

						if(!(tmp_ostr2 = e_DName(lrecips->element->certificate->tbs->issuer))){
							AUX_ADD_ERROR;
							aux_free_PemMessageCanon(&canon);
							return((PemMessageCanon *) 0);
						}
						if(!(crecips->element->issuer = OctetStringtorfc64(tmp_ostr2, 1))){
							AUX_ADD_ERROR;
							aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageCanon(&canon);
							return((PemMessageCanon *) 0);
						}
						aux_free_OctetString(&tmp_ostr2);

						if(!(tmp_ostr2 = aux_enchex(lrecips->element->certificate->tbs->serialnumber))){
							AUX_ADD_ERROR;
							aux_free_PemMessageCanon(&canon);
							return((PemMessageCanon *) 0);
						}
						if(!(crecips->element->serialnumber = CATNSTR(CNULL, tmp_ostr2->octets, tmp_ostr2->noctets))){
							AUX_ADD_ERROR;
							aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageCanon(&canon);
							return((PemMessageCanon *) 0);
						}
						aux_free_OctetString(&tmp_ostr2);
					}
				}

			}




		}
		if(lhd->certificates) {
			if(lhd->certificates->usercertificate && lhd->certificates->usercertificate->tbs) {
				if(!(chd->orig_fields = ( PemOriginatorCanon *)calloc(1, sizeof( PemOriginatorCanon)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					 aux_free_PemMessageCanon(&canon);
					return( (PemMessageCanon *) 0);
				}

				if(lhd->certificates->usercertificate->tbs->subject) {
					if(!(tmp_ostr2 = e_Certificate(lhd->certificates->usercertificate))){
						AUX_ADD_ERROR;
						aux_free_PemMessageCanon(&canon);
						return((PemMessageCanon *) 0);
					}
					if(!(chd->orig_fields->certificate = OctetStringtorfc64(tmp_ostr2, 1))){
						AUX_ADD_ERROR;
						aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageCanon(&canon);
						return((PemMessageCanon *) 0);
					}
					aux_free_OctetString(&tmp_ostr2);
				}
				else {
					if(!(tmp_ostr2 = e_DName(lhd->certificates->usercertificate->tbs->issuer))){
						AUX_ADD_ERROR;
						aux_free_PemMessageCanon(&canon);
						return((PemMessageCanon *) 0);
					}
					if(!(chd->orig_fields->issuer = OctetStringtorfc64(tmp_ostr2, 1))){
						AUX_ADD_ERROR;
						aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageCanon(&canon);
						return((PemMessageCanon *) 0);
					}
					aux_free_OctetString(&tmp_ostr2);

					if(!(tmp_ostr2 = aux_enchex(lhd->certificates->usercertificate->tbs->serialnumber))){
						AUX_ADD_ERROR;
						aux_free_PemMessageCanon(&canon);
						return((PemMessageCanon *) 0);
					}
					if(!(chd->orig_fields->serialnumber = CATNSTR(CNULL, tmp_ostr2->octets, tmp_ostr2->noctets))){
						AUX_ADD_ERROR;
						aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageCanon(&canon);
						return((PemMessageCanon *) 0);
					}
					aux_free_OctetString(&tmp_ostr2);
				}
			}



				
			for(path = lhd->certificates->forwardpath; path; path = path->next_forwardpath)
				for(cross = path->liste; cross; cross = cross->next) 
					if(cross->element) {
						if(chd->issuer_fields) {
							if(!(issuer_certs->next = ( SET_OF_Name *)calloc(1, sizeof( SET_OF_Name)))) {
								aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
								 aux_free_PemMessageCanon(&canon);
								return( (PemMessageCanon *) 0);
							}
							issuer_certs = issuer_certs->next;
						}
						else {
							if(!(issuer_certs = ( SET_OF_Name *)calloc(1, sizeof( SET_OF_Name)))) {
								aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
								 aux_free_PemMessageCanon(&canon);
								return( (PemMessageCanon *) 0);
							}

							chd->issuer_fields = issuer_certs;
						}
						issuer_certs->next = (SET_OF_Name *)0;

						if(!(tmp_ostr2 = e_Certificate(cross->element))){
							AUX_ADD_ERROR;
							aux_free_PemMessageCanon(&canon);
							return((PemMessageCanon *) 0);
						}
						if(!(issuer_certs->element = OctetStringtorfc64(tmp_ostr2, 1))){
							AUX_ADD_ERROR;
							aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageCanon(&canon);
							return((PemMessageCanon *) 0);
						}
						aux_free_OctetString(&tmp_ostr2);
					}
			if(lhd->root_certificate) {
				if(chd->issuer_fields) {
					if(!(issuer_certs->next = ( SET_OF_Name *)calloc(1, sizeof( SET_OF_Name)))) {
						aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
						 aux_free_PemMessageCanon(&canon);
						return( (PemMessageCanon *) 0);
					}
					issuer_certs = issuer_certs->next;
				}
				else {
					if(!(issuer_certs = ( SET_OF_Name *)calloc(1, sizeof( SET_OF_Name)))) {
						aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
						 aux_free_PemMessageCanon(&canon);
						return( (PemMessageCanon *) 0);
					}
	
					chd->issuer_fields = issuer_certs;
				}
				issuer_certs->next = (SET_OF_Name *)0;
	
				if(!(tmp_ostr2 = e_Certificate(lhd->root_certificate))){
					AUX_ADD_ERROR;
					aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}
				if(!(issuer_certs->element = OctetStringtorfc64(tmp_ostr2, 1))){
					AUX_ADD_ERROR;
					aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}
				aux_free_OctetString(&tmp_ostr2);
			}

		}
		if(lhd->mic_fields) {
			if(!(chd->mic_fields = ( PemMicCanon *)calloc(1, sizeof( PemMicCanon)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_PemMessageCanon(&canon);
				return( (PemMessageCanon *) 0);
			}


			if(!aux_cmp_AlgId(lhd->mic_fields->signAI, md2WithRsaEncryption)) {
				if(!(chd->mic_fields->mic_alg = aux_cpy_String("RSA-MD2"))){
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}
				if(!(chd->mic_fields->micenc_alg = aux_cpy_String("RSA"))){
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}
			}
			else if(!aux_cmp_AlgId(lhd->mic_fields->signAI, md4WithRsaEncryption)) {
				if(!(chd->mic_fields->mic_alg = aux_cpy_String("RSA-MD4"))){
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}
				if(!(chd->mic_fields->micenc_alg = aux_cpy_String("RSA"))){
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}
			}
			else if(!aux_cmp_AlgId(lhd->mic_fields->signAI, md5WithRsaEncryption)) {
				if(!(chd->mic_fields->mic_alg = aux_cpy_String("RSA-MD5"))){
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}
				if(!(chd->mic_fields->micenc_alg = aux_cpy_String("RSA"))){
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}
			}
			else if(!aux_cmp_ObjId(lhd->mic_fields->signAI->objid, dsaWithSHA->objid)) {
				if(!(chd->mic_fields->mic_alg = aux_cpy_String("NIST-SHA"))){
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}
				if(!(chd->mic_fields->micenc_alg = aux_cpy_String("NIST-DSA"))){
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}
			}
			else {
				aux_add_error(EINVALID, "Invalid MIC algorithm", CNULL, 0, proc);
				aux_free_PemMessageCanon(&canon);
				return((PemMessageCanon *) 0);
			}
			if(lhd->mic_fields->mic) 
				if(!(chd->mic_fields->mic = BitStringtorfc64(lhd->mic_fields->mic, 1))){
					AUX_ADD_ERROR;
					aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}
		}
		for(lcrls = lhd->crl_fields; lcrls; lcrls = lcrls->next ) {
			if(chd->crl_fields) {
				if(!(ccrls->next = ( SET_OF_PemCrlCanon *)calloc(1, sizeof( SET_OF_PemCrlCanon)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					 aux_free_PemMessageCanon(&canon);
					return( (PemMessageCanon *) 0);
				}
				ccrls = ccrls->next;
			}
			else {
				if(!(ccrls = ( SET_OF_PemCrlCanon *)calloc(1, sizeof( SET_OF_PemCrlCanon)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					 aux_free_PemMessageCanon(&canon);
					return( (PemMessageCanon *) 0);
				}
				chd->crl_fields = ccrls;
			}
			ccrls->next = (SET_OF_PemCrlCanon *)0;

			if(lcrls->element) {
				if(!(ccrls->element = ( PemCrlCanon *)calloc(1, sizeof( PemCrlCanon)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					 aux_free_PemMessageCanon(&canon);
					return( (PemMessageCanon *) 0);
				}

				if(lcrls->element->crl) {
						if(!(tmp_ostr2 = e_CRL(lcrls->element->crl))){
							AUX_ADD_ERROR;
							aux_free_PemMessageCanon(&canon);
							return((PemMessageCanon *) 0);
						}
						if(!(ccrls->element->crl = OctetStringtorfc64(tmp_ostr2, 1))){
							AUX_ADD_ERROR;
							aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageCanon(&canon);
							return((PemMessageCanon *) 0);
						}
						aux_free_OctetString(&tmp_ostr2);
				}
				if(lcrls->element->certificates) {
					if(lcrls->element->certificates->usercertificate) {
						if(!(tmp_ostr2 = e_Certificate(lcrls->element->certificates->usercertificate))){
							AUX_ADD_ERROR;
							aux_free_PemMessageCanon(&canon);
							return((PemMessageCanon *) 0);
						}
						if(!(ccrls->element->certificate = OctetStringtorfc64(tmp_ostr2, 1))){
							AUX_ADD_ERROR;
							aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageCanon(&canon);
							return((PemMessageCanon *) 0);
						}
						aux_free_OctetString(&tmp_ostr2);

					}
					for(path = lcrls->element->certificates->forwardpath; path; path = path->next_forwardpath)
						for(cross = path->liste; cross; cross = cross->next) 
							if(cross->element) {
								if(ccrls->element->issuer_certificate) {
									if(!(crl_issuer_certs->next = ( SET_OF_Name *)calloc(1, sizeof( SET_OF_Name)))) {
										aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
										 aux_free_PemMessageCanon(&canon);
										return( (PemMessageCanon *) 0);
									}
									crl_issuer_certs = crl_issuer_certs->next;
								}
								else {
									if(!(crl_issuer_certs = ( SET_OF_Name *)calloc(1, sizeof( SET_OF_Name)))) {
										aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
										 aux_free_PemMessageCanon(&canon);
										return( (PemMessageCanon *) 0);
									}
		
									ccrls->element->issuer_certificate = crl_issuer_certs;
								}
								crl_issuer_certs->next = (SET_OF_Name *)0;
		
								if(!(tmp_ostr2 = e_Certificate(cross->element))){
									AUX_ADD_ERROR;
									aux_free_PemMessageCanon(&canon);
									return((PemMessageCanon *) 0);
								}
								if(!(crl_issuer_certs->element = OctetStringtorfc64(tmp_ostr2, 1))){
									AUX_ADD_ERROR;
									aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageCanon(&canon);
									return((PemMessageCanon *) 0);
								}
								aux_free_OctetString(&tmp_ostr2);
							}
				}
			}

		}
		for(lcrlrrs = lhd->crl_rr_fields; lcrlrrs; lcrlrrs = lcrlrrs->next ) {
			if(chd->crl_fields) {
				if(!(ccrlrrs->next = ( SET_OF_Name *)calloc(1, sizeof( SET_OF_Name)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					 aux_free_PemMessageCanon(&canon);
					return( (PemMessageCanon *) 0);
				}
				ccrlrrs = ccrlrrs->next;
			}
			else {
				if(!(ccrlrrs = ( SET_OF_Name *)calloc(1, sizeof( SET_OF_Name)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					aux_free_PemMessageCanon(&canon);
					return( (PemMessageCanon *) 0);
				}
				chd->crl_rr_fields = ccrlrrs;
			}
			ccrlrrs->next = (SET_OF_Name *)0;

			if(lcrlrrs->element) {
				if(!(tmp_ostr2 = e_DName(lcrlrrs->element))){
					AUX_ADD_ERROR;
					aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}
				if(!(ccrlrrs->element = OctetStringtorfc64(tmp_ostr2, 1))){
					AUX_ADD_ERROR;
					aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}
				aux_free_OctetString(&tmp_ostr2);
			}

		}



	}

	if(local->body) {
		if(lhd && (lhd->proctype == PEM_MCO || lhd->proctype == PEM_ENC)) {
			if(!(canon->body = OctetStringtorfc64(local->body, 0))){
				AUX_ADD_ERROR;
				 aux_free_PemMessageCanon(&canon);
				return((PemMessageCanon *) 0);
			}
		}
		else {
			if(lhd && lhd->proctype == PEM_MCC) {
				if(!(tmp_body = aux_cpy_OctetString(local->body))){
					AUX_ADD_ERROR;
					 aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *)0);
				}

				if(aux_prepend_dash_(tmp_body, 1)){
					AUX_ADD_ERROR;
					 aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *)0);
				}

				if(!(canon->body = CATNSTR(CNULL, tmp_body->octets, tmp_body->noctets))){
					AUX_ADD_ERROR;
					 aux_free_PemMessageCanon(&canon);
					return((PemMessageCanon *) 0);
				}

				aux_free_OctetString(&tmp_body);

			}
			else if(!(canon->body = CATNSTR(CNULL, local->body->octets, local->body->noctets))){
				AUX_ADD_ERROR;
				 aux_free_PemMessageCanon(&canon);
				return((PemMessageCanon *) 0);
			}
		}
	}
	return(canon);



}
/*------------------------------------------------------------------
  pem_Canon2Local() converts a message from a canonical to
  a local structure. It uses ASN.1 and RFC 8 to 6 bit
  decoding and transforms names to the
  representing AlgId's or elements of enumerations.
------------------------------------------------------------------*/
/***************************************************************
 *
 * Procedure pem_Canon2Local
 *
 ***************************************************************/
#ifdef __STDC__

PemMessageLocal *pem_Canon2Local(
	PemMessageCanon	 *canon
)

#else

PemMessageLocal *pem_Canon2Local(
	canon
)
PemMessageCanon	 *canon;

#endif

{
	PemMessageLocal 		*local;
	OctetString 			 tmp_ostr1,
					*tmp_ostr2,
					*tmp_ostr3;
	PemHeaderLocal 			*lhd;
	PemHeaderCanon 			*chd;
	SET_OF_PemRecLocal		*lrecips;
	SET_OF_PemRecCanon		*crecips;
	SET_OF_Certificate		*lcerts,
					*cross;
	SET_OF_Name			*ccerts,
					*issuer_certs,
					*crl_issuer_certs,
					*ccrlrrs;
	SET_OF_DName			*lcrlrrs;
	SET_OF_CRLWithCertificates	*lcrls;
	SET_OF_PemCrlCanon		*ccrls;
	DName 				*tmp_dname,
					*subj = (DName *)0;
	FCPath 				*path;
	Certificate 			*cert;
	int 				 tmp_int1, n;
	Boolean 			 wrong_hash;
	char				*proc = "pem_Canon2Local";
	
	if(!canon) return((PemMessageLocal *) 0);

	if(!(local = ( PemMessageLocal *)calloc(1, sizeof( PemMessageLocal)))) {
		aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
		return( (PemMessageLocal *) 0);
	}

	chd = canon->header;
	if(chd) {
		if(pem_verbose_1) 
		if(!(local->comment = CATSPRINTF(local->comment, "PEM message found\n"))){
			AUX_ADD_ERROR;
			 aux_free_PemMessageLocal(&local);
			return((PemMessageLocal *)0);
		}

		if(!(local->header = ( PemHeaderLocal *)calloc(1, sizeof( PemHeaderLocal)))) {
			aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
			 aux_free_PemMessageLocal(&local);
			return( (PemMessageLocal *) 0);
		}

		lhd = local->header;



		if(chd->rfc_version) lhd->rfc_version = atoi(chd->rfc_version);

		if(chd->proctype) {
			if(pem_verbose_1) 
			if(!(local->comment = CATSPRINTF(local->comment, "PROC-Type: %s\n", chd->proctype))){
				AUX_ADD_ERROR;
				 aux_free_PemMessageLocal(&local);
				return((PemMessageLocal *)0);
			}

			for(tmp_int1 = 0; proc_type_t[tmp_int1].name; tmp_int1++)
				if(!strcmp(proc_type_t[tmp_int1].name, chd->proctype)) break;
			if(!proc_type_t[tmp_int1].name) {
				aux_add_error(EINVALID, "No valid Proc-Type", chd->proctype, char_n, proc);
				aux_free_PemMessageLocal(&local);
				return((PemMessageLocal *) 0);
			}
			lhd->proctype = proc_type_t[tmp_int1].value;
		}

		if(chd->content_domain) {
			if(pem_verbose_1) 
			if(!(local->comment = CATSPRINTF(local->comment, "Content-Domain: %s\n", chd->content_domain))){
				AUX_ADD_ERROR;
				 aux_free_PemMessageLocal(&local);
				return((PemMessageLocal *)0);
			}

			for(tmp_int1 = 0; content_domain[tmp_int1].name; tmp_int1++)
				if(!strcmp(content_domain[tmp_int1].name, chd->content_domain)) break;
			if(!content_domain[tmp_int1].name) {
				aux_add_error(EINVALID, "No valid Content-Domain", chd->content_domain, char_n, proc);
				aux_free_PemMessageLocal(&local);
				return((PemMessageLocal *) 0);
			}
			lhd->content_domain = content_domain[tmp_int1].value;
		}



		if(chd->dek_fields) {
			if(pem_verbose_1) 
			if(!(local->comment = CATSPRINTF(local->comment, "DEK-Info found\n"))){
				AUX_ADD_ERROR;
				 aux_free_PemMessageLocal(&local);
				return((PemMessageLocal *)0);
			}

			if(!(lhd->dek_fields = ( PemDekLocal *)calloc(1, sizeof( PemDekLocal)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_PemMessageLocal(&local);
				return( (PemMessageLocal *) 0);
			}

			if(chd->dek_fields->dekinfo_enc_alg) {


				if(!(lhd->dek_fields->dekinfo_enc_alg = ( AlgId *)calloc(1, sizeof( AlgId)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					 aux_free_PemMessageLocal(&local);
					return( (PemMessageLocal *) 0);
				}

				if(!(lhd->dek_fields->dekinfo_enc_alg->objid = aux_Name2ObjId(chd->dek_fields->dekinfo_enc_alg))){
					AUX_ADD_ERROR;
					aux_free_PemMessageLocal(&local);
					return((PemMessageLocal *) 0);
				}
				if(chd->dek_fields->dekinfo_param) {
	
					tmp_ostr1.octets = chd->dek_fields->dekinfo_param;
					tmp_ostr1.noctets = strlen(tmp_ostr1.octets);
	
					if(!(lhd->dek_fields->dekinfo_enc_alg->param = (char *)aux_dechex(&tmp_ostr1))){
						AUX_ADD_ERROR;
						aux_free_PemMessageLocal(&local);
						return((PemMessageLocal *) 0);
					}
				}
			}
			if(chd->dek_fields->keyinfo_enc_alg)
				if(!(lhd->dek_fields->keyinfo_enc_alg = aux_Name2AlgId(chd->dek_fields->keyinfo_enc_alg))){
					AUX_ADD_ERROR;
					aux_free_PemMessageLocal(&local);
					return((PemMessageLocal *) 0);
				}
			if(chd->dek_fields->keyinfo_dek)
				if(!(lhd->dek_fields->keyinfo_dek = rfc64toBitString(chd->dek_fields->keyinfo_dek, 1))){
					AUX_ADD_ERROR;
					aux_free_PemMessageLocal(&local);
					return((PemMessageLocal *) 0);
				}

			if(pem_verbose_1) 
			if(!(local->comment = CATSPRINTF(local->comment, "Originator-Key-Info found\n"))){
				AUX_ADD_ERROR;
				 aux_free_PemMessageLocal(&local);
				return((PemMessageLocal *)0);
			}

			for(crecips = chd->dek_fields->recipients, n = 0; crecips; crecips = crecips->next, n++ ) {
				if(lhd->dek_fields->recipients) {
					if(!(lrecips->next = ( SET_OF_PemRecLocal *)calloc(1, sizeof( SET_OF_PemRecLocal)))) {
						aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
						 aux_free_PemMessageLocal(&local);
						return( (PemMessageLocal *) 0);
					}
					lrecips = lrecips->next;
				}
				else {
					if(!(lrecips = ( SET_OF_PemRecLocal *)calloc(1, sizeof( SET_OF_PemRecLocal)))) {
						aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
						 aux_free_PemMessageLocal(&local);
						return( (PemMessageLocal *) 0);
					}
					lhd->dek_fields->recipients = lrecips;
				}
				lrecips->next = (SET_OF_PemRecLocal *)0;

				if(crecips->element) {
					if(!(lrecips->element = ( PemRecLocal *)calloc(1, sizeof( PemRecLocal)))) {
						aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
						 aux_free_PemMessageLocal(&local);
						return( (PemMessageLocal *) 0);
					}

					if(crecips->element->enc_alg)
						if(!(lrecips->element->enc_alg = aux_Name2AlgId(crecips->element->enc_alg))){
							AUX_ADD_ERROR;
							aux_free_PemMessageLocal(&local);
							return((PemMessageLocal *) 0);
						}
					if(crecips->element->dek)
						if(!(lrecips->element->dek = rfc64toBitString(crecips->element->dek, 1))){
							AUX_ADD_ERROR;
							aux_free_PemMessageLocal(&local);
							return((PemMessageLocal *) 0);
						}
					if(crecips->element->issuer && crecips->element->serialnumber) {
						if(!(lrecips->element->certificate = ( Certificate *)calloc(1, sizeof( Certificate)))) {
							aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
							 aux_free_PemMessageLocal(&local);
							return( (PemMessageLocal *) 0);
						}
						if(!(lrecips->element->certificate->tbs = ( ToBeSigned *)calloc(1, sizeof( ToBeSigned)))) {
							aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
							 aux_free_PemMessageLocal(&local);
							return( (PemMessageLocal *) 0);
						}

						if(!(tmp_ostr2 = rfc64toOctetString(crecips->element->issuer, 1))){
							AUX_ADD_ERROR;
							aux_free_PemMessageLocal(&local);
							return((PemMessageLocal *) 0);
						}
						if(!(lrecips->element->certificate->tbs->issuer = d_DName(tmp_ostr2))){
							aux_add_error(EDECODE, "Can't decode DName", crecips->element->issuer, char_n, proc);
							aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageLocal(&local);
							return((PemMessageLocal *) 0);
						}
						aux_free_OctetString(&tmp_ostr2);

						tmp_ostr1.octets = crecips->element->serialnumber;
						tmp_ostr1.noctets = strlen(tmp_ostr1.octets);

						if(!(lrecips->element->certificate->tbs->serialnumber = aux_dechex(&tmp_ostr1))){
							AUX_ADD_ERROR;
							aux_free_PemMessageLocal(&local);
							return((PemMessageLocal *) 0);
						}
	
					}
					
				}

			}

			if(pem_verbose_1 && n) 
			if(!(local->comment = CATSPRINTF(local->comment, "%d recipient keys found\n", n))){
				AUX_ADD_ERROR;
				 aux_free_PemMessageLocal(&local);
				return((PemMessageLocal *)0);
			}





		}
		if(chd->orig_fields) {
			if(!(lhd->certificates = ( Certificates *)calloc(1, sizeof( Certificates)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_PemMessageLocal(&local);
				return( (PemMessageLocal *) 0);
			}

			if(chd->orig_fields->certificate) {
				if(pem_verbose_1) 
				if(!(local->comment = CATSPRINTF(local->comment, "Originator-Certificate found\n"))){
					AUX_ADD_ERROR;
					 aux_free_PemMessageLocal(&local);
					return((PemMessageLocal *)0);
				}

				if(!(tmp_ostr2 = rfc64toOctetString(chd->orig_fields->certificate, 1))){
					AUX_ADD_ERROR;
					aux_free_PemMessageLocal(&local);
					return((PemMessageLocal *) 0);
				}
				if(!(lhd->certificates->usercertificate = d_Certificate(tmp_ostr2))){
					aux_add_error(EDECODE, "Can't decode Certificate", chd->orig_fields->certificate, char_n, proc);
					aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageLocal(&local);
					return((PemMessageLocal *) 0);
				}
				aux_free_OctetString(&tmp_ostr2);

			}

			if(chd->orig_fields->issuer && chd->orig_fields->serialnumber) {
				if(pem_verbose_1) 
				if(!(local->comment = CATSPRINTF(local->comment, "Originator-ID-Asymmetric found\n"))){
					AUX_ADD_ERROR;
					 aux_free_PemMessageLocal(&local);
					return((PemMessageLocal *)0);
				}

				if(!(lhd->certificates->usercertificate = ( Certificate *)calloc(1, sizeof( Certificate)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					 aux_free_PemMessageLocal(&local);
					return( (PemMessageLocal *) 0);
				}
				if(!(lhd->certificates->usercertificate->tbs = ( ToBeSigned *)calloc(1, sizeof( ToBeSigned)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					 aux_free_PemMessageLocal(&local);
					return( (PemMessageLocal *) 0);
				}
				if(!(tmp_ostr2 = rfc64toOctetString(chd->orig_fields->issuer, 1))){
					AUX_ADD_ERROR;
					aux_free_PemMessageLocal(&local);
					return((PemMessageLocal *) 0);
				}
				if(!(lhd->certificates->usercertificate->tbs->issuer = d_DName(tmp_ostr2))){
					aux_add_error(EDECODE, "Can't decode DName", chd->orig_fields->issuer, char_n, proc);
					aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageLocal(&local);
					return((PemMessageLocal *) 0);
				}
				aux_free_OctetString(&tmp_ostr2);

				tmp_ostr1.octets = chd->orig_fields->serialnumber;
				tmp_ostr1.noctets = strlen(tmp_ostr1.octets);

				if(!(lhd->certificates->usercertificate->tbs->serialnumber = aux_dechex(&tmp_ostr1))){
					AUX_ADD_ERROR;
					aux_free_PemMessageLocal(&local);
					return((PemMessageLocal *) 0);
				}

			}


			if((issuer_certs = chd->issuer_fields)) {
				if(!(lhd->certificates->forwardpath = ( FCPath *)calloc(1, sizeof( FCPath)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					 aux_free_PemMessageLocal(&local);
					return( (PemMessageLocal *) 0);
				}
			}
			else lhd->certificates->forwardpath = (FCPath *) 0;
				
			path = lhd->certificates->forwardpath;
			subj = (DName *)0;

			n = 0;
			while(issuer_certs) {
				n++;
				if(issuer_certs->element) {
					if(!(tmp_ostr2 = rfc64toOctetString(issuer_certs->element, 1))){
						AUX_ADD_ERROR;
						aux_free_PemMessageLocal(&local);
						return((PemMessageLocal *) 0);
					}
					if(!(cert = d_Certificate(tmp_ostr2))){
						aux_add_error(EDECODE, "Can't decode Certificate", issuer_certs->element, char_n, proc);
						aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageLocal(&local);
						return((PemMessageLocal *) 0);
					}
					aux_free_OctetString(&tmp_ostr2);

					if(!aux_cmp_DName(cert->tbs->issuer, cert->tbs->subject)) {
	
						/* This is a prototype certificate which is supposed to be the top-level certificate */
						lhd->root_certificate = cert;
					} 
					else if(!subj || aux_cmp_DName(subj, cert->tbs->subject)) {
						if(subj) {
							if(!(path->next_forwardpath = ( FCPath *)calloc(1, sizeof( FCPath)))) {
								aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
								 aux_free_PemMessageLocal(&local);
								return( (PemMessageLocal *) 0);
							}
							path = path->next_forwardpath;
						}
	
						if(!(cross = path->liste = ( SET_OF_Certificate *)calloc(1, sizeof( SET_OF_Certificate)))) {
							aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
							 aux_free_PemMessageLocal(&local);
							return( (PemMessageLocal *) 0);
						}
						path->liste->element = cert;
						if(!(subj = aux_cpy_DName(cert->tbs->subject))) {
							AUX_ADD_ERROR;
							aux_free_PemMessageLocal(&local);
							return((PemMessageLocal *) 0);
						}
							
					} 
					else {	
						if(!(cross->next = ( CrossCertificates *)calloc(1, sizeof( CrossCertificates)))) {
							aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
							 aux_free_PemMessageLocal(&local);
							return( (PemMessageLocal *) 0);
						}
						cross = cross->next;
						cross->element = cert;
					}
				}
				issuer_certs = issuer_certs->next;
			}
			if(!subj && lhd->certificates->forwardpath) {
				free(lhd->certificates->forwardpath);
				lhd->certificates->forwardpath = (FCPath *) 0;
			}
			aux_free_DName(&subj);

			if(pem_verbose_1 && n) 
			if(!(local->comment = CATSPRINTF(local->comment, "%d issuer certificates found\n", n))){
				AUX_ADD_ERROR;
				 aux_free_PemMessageLocal(&local);
				return((PemMessageLocal *)0);
			}

		}

		if(chd->mic_fields) {
			if(pem_verbose_1) 
			if(!(local->comment = CATSPRINTF(local->comment, "MIC-Info found\n"))){
				AUX_ADD_ERROR;
				 aux_free_PemMessageLocal(&local);
				return((PemMessageLocal *)0);
			}

			if(!(lhd->mic_fields = ( PemMicLocal *)calloc(1, sizeof( PemMicLocal)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_PemMessageLocal(&local);
				return( (PemMessageLocal *) 0);
			}
						
			wrong_hash = FALSE;
			lhd->mic_fields->PEM_conformant = FALSE;

			switch(aux_Name2AlgHash(chd->mic_fields->mic_alg)) {

				case MD2:	
					if(aux_Name2AlgEnc(chd->mic_fields->micenc_alg) == RSA) switch(aux_Name2AlgSpecial(chd->mic_fields->micenc_alg)) {

						case NoAlgSpecial :
							lhd->mic_fields->signAI = aux_cpy_AlgId(md2WithRsa);
							break;

						case PKCS_BT_02:
							lhd->mic_fields->signAI = aux_cpy_AlgId(md2WithRsaEncryption);
							lhd->mic_fields->PEM_conformant = TRUE;
							break;
					}
					break;

				case MD4:	
					if(aux_Name2AlgEnc(chd->mic_fields->micenc_alg) == RSA) switch(aux_Name2AlgSpecial(chd->mic_fields->micenc_alg)) {

						case NoAlgSpecial:
							lhd->mic_fields->signAI = aux_cpy_AlgId(md4WithRsa);
							break;

						case PKCS_BT_02:
							lhd->mic_fields->signAI = aux_cpy_AlgId(md4WithRsaEncryption);
							break;
					}
					break;

				case MD5:	
					if(aux_Name2AlgEnc(chd->mic_fields->micenc_alg) == RSA) switch(aux_Name2AlgSpecial(chd->mic_fields->micenc_alg)) {

						case NoAlgSpecial:
							lhd->mic_fields->signAI = aux_cpy_AlgId(md5WithRsa);
							break;

						case PKCS_BT_02:
							lhd->mic_fields->signAI = aux_cpy_AlgId(md5WithRsaEncryption);
							lhd->mic_fields->PEM_conformant = TRUE;
							break;
					}
					break;
				case SHA:
					if(aux_Name2AlgEnc(chd->mic_fields->micenc_alg) == DSA) lhd->mic_fields->signAI = aux_cpy_AlgId(dsaWithSHA);
					break;
				default:
					wrong_hash = TRUE;
			}
			if(lhd->mic_fields->PEM_conformant) {
				if(strcmp(chd->mic_fields->mic_alg, "RSA-MD2") && strcmp(chd->mic_fields->mic_alg, "RSA-MD5")) 
					lhd->mic_fields->PEM_conformant = FALSE;
			}


			if(!lhd->mic_fields->signAI) {
				if(wrong_hash) {
					aux_add_error(EMSGBUF, "wrong MIC algorithm", (char *) chd->mic_fields->mic_alg, char_n, proc);
				}
				else {
					aux_add_error(EMSGBUF, "wrong MIC-ENC algorithm", (char *) chd->mic_fields->micenc_alg, char_n, proc);
				}
				aux_free_PemMessageLocal(&local);
				return((PemMessageLocal *) 0);
			}

			if(chd->mic_fields->mic) {
				if(!(lhd->mic_fields->mic = rfc64toBitString(chd->mic_fields->mic, 1))){
					AUX_ADD_ERROR;
					 aux_free_PemMessageLocal(&local);
					return((PemMessageLocal *) 0);
				}
			}
		}
		for(ccrls = chd->crl_fields, n = 0; ccrls; ccrls = ccrls->next, n++ ) {
			if(lhd->crl_fields) {
				if(!(lcrls->next = ( SET_OF_CRLWithCertificates *)calloc(1, sizeof( SET_OF_CRLWithCertificates)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					 aux_free_PemMessageLocal(&local);
					return( (PemMessageLocal *) 0);
				}
				lcrls = lcrls->next;
			}
			else {
				if(!(lcrls = ( SET_OF_CRLWithCertificates *)calloc(1, sizeof( SET_OF_CRLWithCertificates)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					 aux_free_PemMessageLocal(&local);
					return( (PemMessageLocal *) 0);
				}
				lhd->crl_fields = lcrls;
			}
			lcrls->next = (SET_OF_CRLWithCertificates *)0;

			if(ccrls->element) {
				if(!(lcrls->element = ( CRLWithCertificates *)calloc(1, sizeof( CRLWithCertificates)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					 aux_free_PemMessageLocal(&local);
					return( (PemMessageLocal *) 0);
				}

				if(ccrls->element->crl) {
					if(!(tmp_ostr2 = rfc64toOctetString(ccrls->element->crl, 1))){
						AUX_ADD_ERROR;
						aux_free_PemMessageLocal(&local);
						return((PemMessageLocal *) 0);
					}
					if(!(lcrls->element->crl = d_CRL(tmp_ostr2))){
						aux_add_error(EDECODE, "Can't decode CRL", ccrls->element->crl, char_n, proc);
						aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageLocal(&local);
						return((PemMessageLocal *) 0);
					}
					aux_free_OctetString(&tmp_ostr2);
				}
				if(!(lcrls->element->certificates = ( Certificates *)calloc(1, sizeof( Certificates)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					 aux_free_PemMessageLocal(&local);
					return( (PemMessageLocal *) 0);
				}
				if(ccrls->element->certificate) {
					if(!(tmp_ostr2 = rfc64toOctetString(ccrls->element->certificate, 1))){
						AUX_ADD_ERROR;
						aux_free_PemMessageLocal(&local);
						return((PemMessageLocal *) 0);
					}
					if(!(lcrls->element->certificates->usercertificate = d_Certificate(tmp_ostr2))){
						aux_add_error(EDECODE, "Can't decode Certificate", ccrls->element->certificate, char_n, proc);
						aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageLocal(&local);
						return((PemMessageLocal *) 0);
					}
					aux_free_OctetString(&tmp_ostr2);

				}
				if((crl_issuer_certs = ccrls->element->issuer_certificate)) {
					if(!(lcrls->element->certificates->forwardpath = ( FCPath *)calloc(1, sizeof( FCPath)))) {
						aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
						 aux_free_PemMessageLocal(&local);
						return( (PemMessageLocal *) 0);
					}
				}
				else lcrls->element->certificates->forwardpath = (FCPath *) 0;

				path = lcrls->element->certificates->forwardpath;
				subj = (DName *)0;
				n = 0;
				while(crl_issuer_certs) {
					n++;
					if(!(tmp_ostr2 = rfc64toOctetString(crl_issuer_certs->element, 1))){
						AUX_ADD_ERROR;
						aux_free_PemMessageLocal(&local);
						return((PemMessageLocal *) 0);
					}
					if(!(cert = d_Certificate(tmp_ostr2))){
						aux_add_error(EDECODE, "Can't decode Certificate", crl_issuer_certs->element, char_n, proc);
						aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageLocal(&local);
						return((PemMessageLocal *) 0);
					}
					aux_free_OctetString(&tmp_ostr2);

					if(!subj || aux_cmp_DName(subj, cert->tbs->subject)) {
						if(subj) {
							if(!(path->next_forwardpath = ( FCPath *)calloc(1, sizeof( FCPath)))) {
								aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
								 aux_free_PemMessageLocal(&local);
								return( (PemMessageLocal *) 0);
							}
							path = path->next_forwardpath;
						}
	
						if(!(cross = path->liste = ( SET_OF_Certificate *)calloc(1, sizeof( SET_OF_Certificate)))) {
							aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
							 aux_free_PemMessageLocal(&local);
							return( (PemMessageLocal *) 0);
						}

						path->liste->element = cert;
						if(!(subj = aux_cpy_DName(cert->tbs->subject))) {
							AUX_ADD_ERROR;
							aux_free_PemMessageLocal(&local);
							return((PemMessageLocal *) 0);
						}
							
					} 
					else {	
						if(!(cross->next = ( CrossCertificates *)calloc(1, sizeof( CrossCertificates)))) {
							aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
							 aux_free_PemMessageLocal(&local);
							return( (PemMessageLocal *) 0);
						}
						cross = cross->next;
						cross->element = cert;
					}
					crl_issuer_certs = crl_issuer_certs->next;
				}
				if(!subj) {
					free(lcrls->element->certificates->forwardpath);
					lcrls->element->certificates->forwardpath = (FCPath *) 0;
				}
				aux_free_DName(&subj);

				if(pem_verbose_1 && n) 
				if(!(local->comment = CATSPRINTF(local->comment, "%d certificates to CRL found\n", n))){
					AUX_ADD_ERROR;
					 aux_free_PemMessageLocal(&local);
					return((PemMessageLocal *)0);
				}

				
			}

		}
		if(pem_verbose_1 && n) 
		if(!(local->comment = CATSPRINTF(local->comment, "%d CRLs found\n", n))){
			AUX_ADD_ERROR;
			 aux_free_PemMessageLocal(&local);
			return((PemMessageLocal *)0);
		}

		for(ccrlrrs = chd->crl_rr_fields, n = 0; ccrlrrs; ccrlrrs = ccrlrrs->next, n++ ) {
			if(lhd->crl_rr_fields) {
				if(!(lcrlrrs->next = ( SET_OF_DName *)calloc(1, sizeof( SET_OF_DName)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					 aux_free_PemMessageLocal(&local);
					return( (PemMessageLocal *) 0);
				}
				lcrlrrs = lcrlrrs->next;
			}
			else {
				if(!(lcrlrrs = ( SET_OF_DName *)calloc(1, sizeof( SET_OF_DName)))) {
					aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
					 aux_free_PemMessageLocal(&local);
					return( (PemMessageLocal *) 0);
				}
				lhd->crl_rr_fields = lcrlrrs;
			}
			lcrlrrs->next = (SET_OF_DName *)0;

			if(ccrlrrs->element) {
				if(!(tmp_ostr2 = rfc64toOctetString(ccrlrrs->element, 1))){
					AUX_ADD_ERROR;
					aux_free_PemMessageLocal(&local);
					return((PemMessageLocal *) 0);
				}
				if(!(lcrlrrs->element = d_DName(tmp_ostr2))){
					aux_add_error(EDECODE, "Can't decode DName", ccrlrrs->element, char_n, proc);
					aux_free_OctetString(&tmp_ostr2);aux_free_PemMessageLocal(&local);
					return((PemMessageLocal *) 0);
				}
				aux_free_OctetString(&tmp_ostr2);
			}

		}
		if(pem_verbose_1 && n) 
		if(!(local->comment = CATSPRINTF(local->comment, "%d CRL-RRs found\n", n))){
			AUX_ADD_ERROR;
			 aux_free_PemMessageLocal(&local);
			return((PemMessageLocal *)0);
		}




	}
	else {
		if(pem_verbose_1) 
		if(!(local->comment = CATSPRINTF(local->comment, "Clear text found\n"))){
			AUX_ADD_ERROR;
			 aux_free_PemMessageLocal(&local);
			return((PemMessageLocal *)0);
		}

	}
	if(canon->body) {
		if(canon->header && (lhd->proctype == PEM_MCO || lhd->proctype == PEM_ENC)) {
			if(!(local->body = rfc64toOctetString(canon->body, 0))) {
				AUX_ADD_ERROR;
				 aux_free_PemMessageLocal(&local);
				return((PemMessageLocal *) 0);
			}
		}
		else {
			if(!(local->body = aux_create_OctetString(canon->body))){
				AUX_ADD_ERROR;
				 aux_free_PemMessageLocal(&local);
				return((PemMessageLocal *) 0);
			}

			if(canon->header && lhd->proctype == PEM_MCC) 	if (aux_strip_dash_(local->body, 1) < 0){
				AUX_ADD_ERROR;
				 aux_free_PemMessageLocal(&local);
				return((PemMessageLocal *)0);
			}

		}
		if(pem_verbose_1) 
		if(!(local->comment = CATSPRINTF(local->comment, "%d octets body found\n", local->body->noctets))){
			AUX_ADD_ERROR;
			 aux_free_PemMessageLocal(&local);
			return((PemMessageLocal *)0);
		}

	}
	return(local);
}
/*------------------------------------------------------------------
  pem_CanonSet2LocalSet() converts each element of a message
  set from a canonical to
  a local structure. It uses ASN.1 and RFC 8 to 6 bit
  decoding and transforms names to the
  representing AlgId's or elements of enumerations.
------------------------------------------------------------------*/
/***************************************************************
 *
 * Procedure pem_CanonSet2LocalSet
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_PemMessageLocal *pem_CanonSet2LocalSet(
	SET_OF_PemMessageCanon	 *canon
)

#else

SET_OF_PemMessageLocal *pem_CanonSet2LocalSet(
	canon
)
SET_OF_PemMessageCanon	 *canon;

#endif

{
	SET_OF_PemMessageLocal 	*local = (SET_OF_PemMessageLocal *)0,
				*local2;
	char			*proc = "pem_CanonSet2LocalSet";
	
	while(canon) {
		if(local) {
			if(!(local2->next = ( SET_OF_PemMessageLocal *)calloc(1, sizeof( SET_OF_PemMessageLocal)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_SET_OF_PemMessageLocal(&local);
				return( (SET_OF_PemMessageLocal *) 0);
			}
			local2 = local2->next;
		}
		else {
			if(!(local2 = ( SET_OF_PemMessageLocal *)calloc(1, sizeof( SET_OF_PemMessageLocal)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_SET_OF_PemMessageLocal(&local);
				return( (SET_OF_PemMessageLocal *) 0);
			}
			local = local2;
		}
		local2->next = (SET_OF_PemMessageLocal *)0;
		local2->element = pem_Canon2Local(canon->element);
		if(canon->element && !local2->element){
			AUX_ADD_ERROR;
			 aux_free_SET_OF_PemMessageLocal(&local);
			return((SET_OF_PemMessageLocal *) 0);
		}
		canon = canon->next;
	}
	return(local);
	
}
/*------------------------------------------------------------------
  pem_Local2Canon() converts each element of a
  message set from a local to
  a canonical structure. It uses ASN.1 and RFC 8 to 6 bit
  encoding and transforms enumerations or AlgId's to the
  representing names.
------------------------------------------------------------------*/
/***************************************************************
 *
 * Procedure pem_LocalSet2CanonSet
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_PemMessageCanon *pem_LocalSet2CanonSet(
	SET_OF_PemMessageLocal	 *local
)

#else

SET_OF_PemMessageCanon *pem_LocalSet2CanonSet(
	local
)
SET_OF_PemMessageLocal	 *local;

#endif

{
	SET_OF_PemMessageCanon 	*canon = (SET_OF_PemMessageCanon *)0,
				*canon2;
	char			*proc = "pem_LocalSet2CanonSet";
	
	while(local) {
		if(canon) {
			if(!(canon2->next = ( SET_OF_PemMessageCanon *)calloc(1, sizeof( SET_OF_PemMessageCanon)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_SET_OF_PemMessageCanon(&canon);
				return( (SET_OF_PemMessageCanon *) 0);
			}
			canon2 = canon2->next;
		}
		else {
			if(!(canon2 = ( SET_OF_PemMessageCanon *)calloc(1, sizeof( SET_OF_PemMessageCanon)))) {
				aux_add_error(EMALLOC, "Can't allocate memory", CNULL, 0, proc);
				 aux_free_SET_OF_PemMessageCanon(&canon);
				return( (SET_OF_PemMessageCanon *) 0);
			}
			canon = canon2;
		}
		canon2->next = (SET_OF_PemMessageCanon *)0;
		canon2->element = pem_Local2Canon(local->element);
		if(local->element && !canon2->element){
			AUX_ADD_ERROR;
			 aux_free_SET_OF_PemMessageCanon(&canon);
			return((SET_OF_PemMessageCanon *) 0);
		}
		local = local->next;
	}
	return(canon);
	
}
