static char *rcsid = "$Header: /nette/secude/src/sca/stamod/RCS/aux_PKCS.c,v 1.3 1995/02/21 15:11:13 surkau Exp $";
/*
 * $Id: aux_PKCS.c,v 1.3 1995/02/21 15:11:13 surkau Exp $
 * 
 * $Log: aux_PKCS.c,v $
 * 
 */
/********************************************************************
 * Copyright (C) 1991, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include "sec_global.h"

unsigned char	md2_digest[12]={0x06, 0x08, 0x2A, 0x86,
				0x48, 0x86, 0xF7, 0x0D,
				0x02, 0x02, 0x05, 0x00};

unsigned char	md4_digest[12]={0x06, 0x08, 0x2A, 0x86,
				0x48, 0x86, 0xF7, 0x0D,
				0x02, 0x04, 0x05, 0x00};

unsigned char	md5_digest[12]={0x06, 0x08, 0x2A, 0x86,
				0x48, 0x86, 0xF7, 0x0D,
				0x02, 0x05, 0x05, 0x00};

/***************************************************************
 *
 * Procedure aux_new_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_new_OctetString(
	int	  length
)

#else

OctetString *aux_new_OctetString(
	length
)
int	  length;

#endif

{
	unsigned int	   n;
	OctetString      * ostr;
	char		 * proc = "aux_new_OctetString";

	if (!(ostr = (OctetString * ) malloc( sizeof( OctetString ) ))) {
		global_add_error(EMALLOC, "ostr", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}
	ostr->noctets = length;
	if ( length > 0 ) {
		ostr->octets = (char * ) calloc( 1 , length );
		if ( !ostr->octets ) {
			free( ostr );
			global_add_error(EMALLOC, "ostr->octets", CNULL, 0, proc);
			return (NULLOCTETSTRING);
		}
	}
	else ostr->octets = CNULL;

	return ( ostr );
}


/***************************************************************
 *
 * Procedure aux_create_PKCSBlock
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_create_PKCSBlock(
	char		  BT,
	OctetString	 *D
)

#else

OctetString *aux_create_PKCSBlock(
	BT,
	D
)
char		  BT;
OctetString	 *D;

#endif
{

/*
 *  aux_create_PKCSBlock returns a newly created OctetString
 *  of length blocksize = (keysize - 1) / 8 (e.g blocksize 63
 *  in case of RSA keysize 512 bits) which consists of a concatenation
 *  of BT || PS || 0x00 || D. This is the encryption block formatting
 *  of PKCS#1 without the leading 0x00.
 *  PS is a padding string dependant on blocktype BT. It consists of
 *  0x00 in case of BT = 0x00, 
 *  0xff in case of BT = 0x01,
 *  non-zero pseudo random numbers in case of BT = 0x02.
 */

	OctetString	*PKCSBlock, *PS;
	int		PS_length, CT_length;
	char            *dd, *bb, *ct;
	int		blocksize, i;
	char		*proc = "aux_create_PKCSBlock";

	if(BT < 0 || BT > PKCS_BT_TD) {
		global_add_error(EINVALID, "Wrong BT", CNULL, 0, proc);
		return ((OctetString * )0);
	}

	if(!D || !D->noctets || !D->octets) {
		global_add_error(EINVALID, "Wrong D", CNULL, 0, proc);
		return ((OctetString * )0);
	}


	blocksize = (RSA_PARM(rsaEncryption->param) - 1) / 8;

	PS_length = blocksize - 2 - D->noctets;

	if(PS_length < 0) {
		global_add_error(EINVALID, "D too long", CNULL, 0, proc);
		return ((OctetString *)0);
	}

	if(!(PKCSBlock = aux_new_OctetString(blocksize))) {
		global_add_error(EMALLOC, "PKCSBlock", CNULL, 0, proc);
		return ((OctetString * )0);
	}

	/* First BT */

	PKCSBlock->octets[0] = BT;

	switch(BT) {
		case 0:
			break;
		case 1:
			dd = PKCSBlock->octets + 1;
			while(PS_length--) *dd++ = 0xff;
			break;
		case 2:
			if(!(PS = sec_random_ostr(PS_length))) {
				global_add_error(EMALLOC, "PS", CNULL, 0, proc);
				return ((OctetString *)0);
			}
			bb = PS->octets;
			dd = PKCSBlock->octets + 1;
			while(PS_length--) {
				if(!(*bb)) *bb = 0xff;
				*dd++ = *bb++;
			}
/* STARCOS - hinzugefuegt */
			aux_free_OctetString(&PS);
/* STARCOS-ENDE */
			break;
		case PKCS_BT_TD:
/* STARCOS 
   wird nicht unterstuetzt
			ct = (char *)aux_current_UTCTime();
			CT_length = strlen(ct);
			PS_length = PS_length - CT_length;
			dd = PKCSBlock->octets + 1;
			while(CT_length--) *dd++ = *ct++;
			while(PS_length--) *dd++ = 0xff;
 STARCOS-ENDE */
			break;
			
	}

	bb = D->octets;
	dd = PKCSBlock->octets + blocksize - (int)D->noctets;
	i = D->noctets;
	while(i--) *dd++ = *bb++;
	return(PKCSBlock);
}

/***************************************************************
 *
 * Procedure aux_create_PKCS_MIC_D
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_create_PKCS_MIC_D(
	OctetString	 *hash_result,
	AlgId		 *signatureAlgorithm
)

#else

OctetString *aux_create_PKCS_MIC_D(
	hash_result,
	signatureAlgorithm
)
OctetString	 *hash_result;
AlgId		 *signatureAlgorithm;

#endif

/*
 *  aux_create_PKCS_MIC_D returns a newly created OctetString
 *  which comprises the data quantity D in case of MIC encryption.
 *  The return value of aux_create_PKCS_MIC_D can be used as input
 *  parameter D of aux_create_PKCSBlock in case of BT = 01.
 *
 *  hash_result is the OctetString resulting from the hash-routine
 *  (e.g. the 16 octets from md2).
 *
 *  signatureAlgorithm is the algorithm identifier of the signature 
 *  algorithm which must be one of the PKCS signature algorithms
 *  (i.e. algspecial of that algorithm must be PKCS_BT_01). From this
 *  the digestAlgorithm is derived
 *
 *  aux_create_PKCS_MIC_D does the following 
 *  (according to PKCS#1 and RFC1423):
 *
 *  1. hash_result is ASN.1 encoded as an OCTET STRING.
 *
 *  2. The data quantity D is generated as the ASN.1 encoding of
 *
 *     SEQUENCE {
 *  		digestAlgorithm	AlgorithmIdentifier,
 *  		digest		OCTET STRING
 *     }
 *
 *     The octets of digest consist of the previously generated
 *     ASN.1 encoding of the hash_result as an OCTET STRING.
 */

{
	DigestInfo      digestinfo;
	AlgId 		*digestAlgorithm;
	AlgSpecial	algspecial;
	AlgHash		alghash;
	OctetString	*encodedDigest;
	int		len, offset, i;
	unsigned char	*digest;
	char		*proc = "aux_create_PKCS_MIC_D";

	algspecial = aux_ObjId2AlgSpecial(signatureAlgorithm->objid);
	if(algspecial != PKCS_BT_01) {
		global_add_error(EINVALID, "algspecial is not PKCS_BT_01", CNULL, 0, proc);
		return((OctetString *)0);
	}
	alghash = aux_ObjId2AlgHash(signatureAlgorithm->objid);
	switch(alghash) {
		case MD2:
			digestAlgorithm = md2;
			digest = md2_digest;
			break;
		case MD4:
			digestAlgorithm = md4;
			digest = md4_digest;
			break;
		case MD5:
			digestAlgorithm = md5;
			digest = md5_digest;
			break;
		default:
			global_add_error(EINVALID, "alghash is not MD2, MD4, MD5", CNULL, 0, proc);
			return((OctetString *)0);
	}



	/*
	 * compute len
	 * len = hash_result->noctets +
	 *       12 (= digest) +
	 *        6 (= tags and lengths)
	 */
	len = hash_result->noctets + 18;

	if(!(encodedDigest = aux_new_OctetString(len))) {
		global_add_error(EMALLOC, "PKCSBlock", CNULL, 0, proc);
		return ((OctetString * )0);
	}
	encodedDigest->noctets = len;
	offset = 0;
	*(encodedDigest->octets + offset++) = 0x30; 	/* SEQUENCE Tag */ 
	*(encodedDigest->octets + offset++) = len -2; 	/* length	*/
	*(encodedDigest->octets + offset++) = 0x30;	/* SEQUENCE Tag	*/
	*(encodedDigest->octets + offset++) = 0x0c;	/* length of digest */
	for (i=0; i<12; i++)	
		*(encodedDigest->octets + offset++) = *(digest + i);

	*(encodedDigest->octets + offset++) = 0x04;	/* OCTET STRING Tag */
	*(encodedDigest->octets + offset++) = hash_result->noctets;
							/* length of hash */
	for (i=0; i<hash_result->noctets; i++)
		*(encodedDigest->octets + offset++) = *(hash_result->octets);
	

	return(encodedDigest);
}

