/* ./src/util/cacreate.c */

static char *rcsid = "$Id: cacreate.c,v 1.16 1995/03/07 10:56:26 surkau Exp surkau $";

/* 
 *
 * $Id: cacreate.c,v 1.16 1995/03/07 10:56:26 surkau Exp surkau $
 *
 * $Log: cacreate.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*
	CA creation


*/

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>

#include "cadb.h"

#ifdef GDBM
#include "../gdbm/ndbm.h"
#else
#ifdef NDBM
#include <ndbm.h>  
#else
#include <dbm.h>
#endif
#endif

#ifdef MS_DOS
#include <fcntl.h>
#endif


#ifndef S_IRWXU
#define S_IRWXU (S_IREAD|S_IWRITE|S_IEXEC)
#endif

extern int errno;
extern char *sys_errlist[ ];

#ifdef __STDC__
static int	cainit	(DName *ca, AlgId *s_alg, char *cadir_abs, OctetString *serial, AlgId *sig_alg, int keysize, Boolean onepaironly, Boolean root);
static int	localinit	(Name *ca, char *cadir_abs);
static int	encrinit	(DName *ca, AlgId *e_alg, AlgId *s_alg, char *cadir_abs, int keysize, Boolean root);
static int	crlinit	(char *cadir_abs, AlgId *sig_alg, char *nextupdate);
static void usage(int help);
#else
static int	cainit	();
static int	localinit	();
static int	encrinit	();
static int	crlinit	();
static void usage();
#endif


char    * cmd;
UTCTime * notbefore, * notafter;
Name	* caname;
PSELocation     pse_location;

int       verbose = 0;


/***************************************************************
 *
 * Procedure main
 *
 ***************************************************************/
#ifdef __STDC__

int main(
	int	  cnt,
	char	**parm
)

#else

int main(
	cnt,
	parm
)
int	  cnt;
char	**parm;

#endif

{
	int	        i;
	RC		rc;
	DName		*ca_dname;
	char	        *psename, *cadir, *cadir_abs, * nextupdate = CNULL;
	char	        *pin;
	Boolean	        onekeypaironly = TRUE, root = FALSE;
	OctetString	*encname;
	extern char	*optarg;
	extern int	optind, opterr;
	char	        line[256];
	int             opt;
	AlgId           *algorithm = (AlgId * )0, *sig_alg = (AlgId * )0;
	AlgId           *s_alg = DEF_SUBJECT_SIGNALGID, *e_alg = DEF_SUBJECT_ENCRALGID;
        ObjId           *oid;
	OctetString     *ostr;
        int             keysizes[2];
        int             ka = 0, kk = 0, kx = 0;
	int	        keysize = DEF_ASYM_KEYSIZE;
	OctetString     *serial = NULLOCTETSTRING;
	int             rcode;

#ifdef X500
	char	        * env_af_dir_authlevel;
#endif

	char 		*proc = "main (cacreate)";

#ifdef MS_DOS
	_fmode = O_BINARY;
#endif

        cmd = *parm;
        cadir = CNULL;
	caname	 = CNULL;
	psename	 = CNULL;
        sec_verbose = FALSE;

	keysizes[0] = DEF_ASYM_KEYSIZE;
	keysizes[1] = DEF_ASYM_KEYSIZE;
	ka = 2;

	optind = 1;
	opterr = 0;

	af_sign_check_Validity = FALSE;
	af_access_directory = FALSE;
	MF_check = FALSE;

	notbefore = notafter = (UTCTime * )0;

nextopt:

#ifdef X500
	while ( (opt = getopt(cnt, parm, "a:A:d:t:c:s:e:k:p:n:l:f:u:hqrvzDVW")) != -1 ) {
#else
	while ( (opt = getopt(cnt, parm, "a:c:s:e:k:p:n:l:f:u:hqrvzDVW")) != -1 ) {
#endif
		switch (opt) {
		case 'a':
                        oid = aux_Name2ObjId(optarg);
                        if (aux_ObjId2AlgType(oid) != SIG)  {
				fprintf(stderr, "%s: Not a signature algorithm: %s\n\n", cmd, optarg);
				usage(SHORT_HELP);
			}
                        if (aux_ObjId2AlgHash(oid) == NoAlgHash)  {
				fprintf(stderr, "%s: Need a signature algorithm with hashing: %s\n\n", cmd, optarg);
				usage(SHORT_HELP);
			}
			algorithm = aux_ObjId2AlgId(oid);
			break;
		case 'n':
			if (serial) usage(SHORT_HELP);
			else serial = aux_create_SerialNo(optarg);
			break;
		case 'f':
			if(!root) {
				fprintf(stderr, "%s: You can set the validity interval only for creating a root CA. See -r.\n\n", cmd);
				usage(SHORT_HELP);
			}
			if (notbefore) usage(SHORT_HELP);
			else notbefore = optarg;
			break;
		case 'l':
			if(!root) {
				fprintf(stderr, "%s: You can set the validity interval only for creating a root CA. See -r.\n\n", cmd);
				usage(SHORT_HELP);
			}
			if (notafter) usage(SHORT_HELP);
			else notafter = optarg;
			break;
		case 'u':
			if (nextupdate) usage(SHORT_HELP);
			else nextupdate = optarg;
			break;
		case 's':
                        oid = aux_Name2ObjId(optarg);
                        if ( (aux_ObjId2AlgType(oid) != SIG) && (aux_ObjId2AlgType(oid) != ASYM_ENC) ) {
				fprintf(stderr, "%s: Wrong algorithm: %s\n\n", cmd, optarg);
				usage(SHORT_HELP);
			}
			s_alg = aux_ObjId2AlgId(oid);
			kk = 0;
			break;
		case 'e':
                        oid = aux_Name2ObjId(optarg);
                        if(aux_ObjId2AlgType(oid) != ASYM_ENC)  {
				fprintf(stderr, "%s: Wrong algorithm: %s\n\n", cmd, optarg);
				usage(SHORT_HELP);
			}

			e_alg = aux_ObjId2AlgId(oid);
			kk = 1;
			break;
                case 'k':
			keysize = atoi(optarg);
			if ( (keysize < MIN_ASYM_KEYSIZE) || (keysize > MAX_ASYM_KEYSIZE))  {
				fprintf(stderr, "%s: Wrong keysize: %d  (must be between %d and %d).\n\n", cmd, keysize, MIN_ASYM_KEYSIZE, MAX_ASYM_KEYSIZE);
				usage(SHORT_HELP);
			}

			keysizes[kk] = keysize;
			kk = 1 - kk;
			break;
		case 'c':
			if (cadir) usage(SHORT_HELP);
			else cadir = optarg;
			break;
		case 'p':
			if (psename) usage(SHORT_HELP);
			else psename = optarg;
			break;
                case 'q':
                        onekeypaironly = FALSE;
                        break;
                case 'r':
                        root = TRUE;
                        break;
#ifdef X500
		case 'd':
			af_dir_dsaname = aux_cpy_String(optarg);
			break;
		case 't':
			af_dir_tailor = aux_cpy_String(optarg);
			break;
		case 'A':
			if (! strcasecmp(optarg, "STRONG"))
				af_dir_authlevel = DBA_AUTH_STRONG;
			else if (! strcasecmp(optarg, "SIMPLE"))
				af_dir_authlevel = DBA_AUTH_SIMPLE;
			break;
#endif
		case 'D':
                        af_access_directory = TRUE;
                        break;
                case 'z':
                        MF_check = TRUE;
                        break;
		case 'v':
			verbose = 1;
			sec_gen_verbose = TRUE;
			continue;
		case 'V':
			verbose = 2;
			sec_gen_verbose = TRUE;
			continue;
		case 'W':
			verbose = 2;
			af_verbose = TRUE;
			sec_verbose = TRUE;
			continue;
		case 'X':
			 random_from_pse = TRUE;
			 break;
		case 'Y':
			 sec_init_random_seed_from_keyboard();
			 break;
		case 'h':
			usage(LONG_HELP);
			continue;
		default:
		case '?':
			usage(SHORT_HELP);
		}
	}

	if (optind < cnt) {
		caname = parm[optind++];
		goto nextopt;
	}


	if ((optind < cnt)) usage(SHORT_HELP);

	if(algorithm){
		if(aux_ObjId2AlgEnc(algorithm->objid) != aux_ObjId2AlgEnc(s_alg->objid)) {
			fprintf(stderr, "%s: ",cmd);
                	fprintf(stderr, "signature algorithm does not fit to signature key\n");
			exit(-1);
		}
	}

	/* 
	 * if(root == TRUE && onekeypaironly == FALSE){
	 * 	if(aux_ObjId2AlgEnc(s_alg->objid) != aux_ObjId2AlgEnc(e_alg->objid)) {
	 * 		fprintf(stderr, "%s: ",cmd);
	 *                 	fprintf(stderr, "Signature and encryption keypairs of Root-CA have different algorithms.\n");
	 *                 	fprintf(stderr, "          Therefore, ENCRYPTION certificate cannot be signed with signature key\n");
	 * 		if(verbose) aux_fprint_error(stderr, verbose);
	 * 		exit(-1);
	 * 	}
	 * }
	 */

	if(!serial) {
		serial = aux_new_OctetString(1);
		serial->octets[0] = 0x00;
	}

	sig_alg = algorithm;
	if(!sig_alg){
		if(aux_ObjId2AlgEnc(s_alg->objid) == RSA) 
			sig_alg = aux_cpy_AlgId(md2WithRsaEncryption);
	}
	if(root) {
		if(!notbefore) notbefore = aux_current_UTCTime();
	
		if(!notafter) notafter = aux_delta_UTCTime(notbefore, 0);
	
	
		/* check validity for root certificate */
		rc = aux_interval2_UTCTime(CNULL,
					   notbefore, 
					   notafter);
		if (rc == -1) {
			fprintf(stderr, "%s: Something wrong with UTCTime %s or %s.\n", cmd, notbefore, notafter);
			if(verbose) aux_fprint_error(stderr, verbose);
			exit(-1);
		}
		else if (rc == 2) {
			fprintf(stderr, "%s: Validity interval incorrectly specified: \n       last date on which certificate is valid is in the past.\n", cmd);
			exit(-1);
		}
		else if (rc == 3) {
			fprintf(stderr, "%s: Validity interval incorrectly specified: \n       last date on which certificate is valid is before first date.\n", cmd);
			exit(-1);
		}
		else if (rc == 1) {
			fprintf(stderr, "%s: Warning: First date on which certificate is valid is in the future.\n", cmd);
		}
	}

	/* first steps: 
		create PSE
		associate name
		generate sign key
		store this as PKRoot
		and a pseudo certificate
	   gives PSE with signature key
	*/

        if(!cadir) cadir = DEF_CADIR;

	if(!(cadir_abs = aux_cat_paths(getenv("HOME"), cadir))) {
                fprintf(stderr, "%s: Can't create CA directory path\n", cmd);
		if(verbose) aux_fprint_error(stderr, verbose);
		exit(-1);
	}
		
	if (mkdir(cadir_abs, S_IRWXU) < 0) {
                fprintf(stderr, "%s: Can't create %s (%d: %s)\n", cmd, cadir, errno, sys_errlist[errno]);
		exit(-1);
	}

	aux_set_pse(psename, cadir);

	if((pse_location = sec_psetest(AF_pse.app_name)) == ERR_in_psetest) {
		if (aux_last_error() == EDEVLOCK) 
			fprintf(stderr, "Cannot open device for SCT (No such device or device busy)\n");
		else	fprintf(stderr, "Error during SC configuration.\n");
		if(verbose) aux_fprint_error(stderr, verbose);
		exit(-1);
	}

	if (pse_location == SCpse) 
		fprintf(stderr, "\n    Please insert smartcard for %s\n", AF_pse.app_name);


#ifdef X500
	if (af_dir_authlevel == DBA_AUTH_NONE) {
		env_af_dir_authlevel = getenv("AUTHLEVEL");
		if (env_af_dir_authlevel) {
			if (! strcasecmp(env_af_dir_authlevel, "STRONG"))
				af_dir_authlevel = DBA_AUTH_STRONG;
			else if (! strcasecmp(env_af_dir_authlevel, "SIMPLE"))
				af_dir_authlevel = DBA_AUTH_SIMPLE;
		}
	}
#endif

	accept_alias_without_verification = TRUE;
        if(!caname) { /* read CA directory name from stdin */
again:
                sprintf(line, "%s: Directory name of new CA: ", cmd);
                aux_fgets(line, line, sizeof(line), stderr, stdin);
                caname = line;
		if(!(ca_dname = aux_alias2DName(caname))) {
                        fprintf(stderr, "%s: Invalid directory name\n", cmd);
                        goto again;
                }
        }
        else {
		if(!(ca_dname = aux_alias2DName(caname))) {
                        fprintf(stderr, "%s: Invalid directory name\n", cmd);
			if(verbose) aux_fprint_error(stderr, verbose);
                        exit(-1);
                }
	}

	if (localinit(caname, cadir_abs) != 0) {
                rmdir(cadir);
		fprintf(stderr, "%s: ",cmd);
                fprintf(stderr, "Can't init CA");
		if(verbose) aux_fprint_error(stderr, verbose);
                exit(-1);
        }

	if (cainit(ca_dname, s_alg, cadir_abs, serial, sig_alg, keysizes[0], onekeypaironly, root) != 0) {
                rmdir(cadir);
		fprintf(stderr, "%s: ",cmd);
                fprintf(stderr, "Can't init CA");
		if(verbose) aux_fprint_error(stderr, verbose);
                exit(-1);
        }

	if (onekeypaironly == FALSE) { 
		if(encrinit(ca_dname, e_alg, sig_alg, cadir_abs, keysizes[1], root) != 0) {
                	rmdir(cadir);
			fprintf(stderr, "%s: ",cmd);
                	fprintf(stderr, "Can't init CA");
			if(verbose) aux_fprint_error(stderr, verbose);
                	exit(-1);
        	}
	}

	if(crlinit(cadir_abs, sig_alg, nextupdate) != 0){
                rmdir(cadir);
		fprintf(stderr, "%s: ",cmd);
                fprintf(stderr, "Can't init CA");
		if(verbose) aux_fprint_error(stderr, verbose);
                exit(-1);
	}

        if(verbose) {
        	fprintf(stderr, "%s: CA with issuer name <%s> complete.\n", cmd, caname);
        	fprintf(stderr, "          CA-DB resides in ");
                fprintf(stderr, "%s\n", cadir_abs);
                fprintf(stderr, "          PSE %s contains PSE objects PKRoot, ", AF_pse.app_name);
		if(onekeypaironly == TRUE) fprintf(stderr, "SKnew, Cert,\n");
		else fprintf(stderr, "SignSK, SignCert, DecSKnew, EncCert,\n");
                fprintf(stderr, "                                             SerialNumber, CrlSet\n");
        }

	exit(0);
}


/***************************************************************
 *
 * Procedure cainit
 *
 ***************************************************************/
#ifdef __STDC__

static int cainit(
	DName		 *ca,
	AlgId		 *s_alg,
	char		 *cadir_abs,
	OctetString	 *serial,
	AlgId		 *sig_alg,
	int		  keysize,
	Boolean		  onepaironly,
	Boolean		  root
)

#else

static int cainit(
	ca,
	s_alg,
	cadir_abs,
	serial,
	sig_alg,
	keysize,
	onepaironly,
	root
)
DName		 *ca;
AlgId		 *s_alg;
char		 *cadir_abs;
OctetString	 *serial;
AlgId		 *sig_alg;
int		  keysize;
Boolean		  onepaironly;
Boolean		  root;

#endif

{
	ParmType      parm_type;
	AlgEnc	      alg_enc;
        PSESel      * pse, * pse_sel;
	PSEToc      * psetoc;
	Key	      nkey;
	KeyInfo       nkinfo;
	PKRoot	    * pkroot;
	Certificate * cert;
	OctetString   content;
	ObjId         objid;       
	ObjId       * obj_type;
	int	      fd, rc;
	Boolean       x500 = TRUE;
	int	      i;
	char        * logpath;
#ifdef AFDBFILE
	char	      afdb[256];
#endif
	char        * proc = "cainit";

	/* init ca data files */

	if(!(logpath = aux_cat_paths(cadir_abs, CALOG))) {
		AUX_ADD_ERROR;
		return(-1);
	}

	if ((logfile = fopen(logpath, LOGFLAGS)) == (FILE * ) 0) return(-1);
	free(logpath);
	LOGINIT;

	/*
	 *  Create PSE
         *
	 *  Set global flag "sec_onekeypair" used in function "sec_create"
	 */

	sec_onekeypair = onepaironly;

#ifdef SCA
	/*
	 *  If not yet done a PSE frame is installed on the SC.
	 */

	if (pse_location == SCpse) {
		if (secsc_install_SCPSE (AF_pse.app_name, CNULL)) {
			if (aux_last_error() != ECREATEAPP) {
				fprintf(stderr, "\n    %s: Cannot install a PSE frame on the SC. \n\n,", cmd);
				if(verbose) aux_fprint_error(stderr, verbose);
				exit(-1);
			}
			/*
			 *  If LASTERROR == ECREATEAPP, 
			 *     the PSE frame exists already on the SC and
			 *     this is no error
			 */
		}	
		else  {
			if (sec_onekeypair == TRUE)
				fprintf(stderr, "\nFrame for an SC-PSE with one keypair has been installed, this includes:\n");
			else 
				fprintf(stderr, "\nFrame for an SC-PSE with two keypairs has been installed, this includes:\n");

			fprintf(stderr, "   - reservation of space on the SC,\n");
			fprintf(stderr, "   - installation of the PIN for the PSE extension,\n");
			fprintf(stderr, "   - installation of the PIN for the SC (value: %s).\n\n", DEFAULT_PIN);
			fprintf(stderr, "Please change the value of the SC-PIN as soon as possible (command: chpin).\n\n");
		}
	}						

#endif

	if(!(pse = af_pse_create(CNULL))) {
		fprintf(stderr, "%s: ",cmd);
                fprintf(stderr, "PSE creation failed\n");
		aux_add_error(EINVALID, "PSE creation failed", CNULL, 0, proc);
		LOGSECERR;
		return(-1);
	}
	aux_free_PSESel(&pse);


	/* create PSE object "SerialNumber" */

	if(af_pse_update_SerialNumber(serial) < 0){
		fprintf(stderr, "%s: ",cmd);
                fprintf(stderr, "unable to create SerialNumber on PSE");
		aux_add_error(EINVALID, "unable to create SerialNumber on PSE", CNULL, 0, proc);
		LOGAFERR;
		return(-1);
	}

	/* now generate a new sign key, with default parm */

	nkey.keyref = 0;
	nkey.pse_sel = (PSESel * ) 0;
	nkey.key = &nkinfo;
	nkinfo.subjectAI = aux_cpy_AlgId(s_alg);

	parm_type = aux_ObjId2ParmType(s_alg->objid);
	alg_enc = aux_ObjId2AlgEnc(s_alg->objid);

	if(parm_type == PARM_INTEGER)
		*(int *)(nkinfo.subjectAI->param) = keysize;
	else {
		switch(alg_enc) {
			case RSA: 
				aux_free_AlgId(&nkinfo.subjectAI);
			  	nkinfo.subjectAI = aux_cpy_AlgId(rsa);
				*(int *)(nkinfo.subjectAI->param) = keysize;
				break;
			case DSA: 
				sec_dsa_keysize = keysize;
			  	nkey.alg = (AlgId *)0;
				break;
		}
	}
	
	if(verbose) {
		if(onepaironly) fprintf(stderr, "%s: Generating CA key pair (algorithm %s)...\n", cmd, aux_ObjId2Name(s_alg->objid));
		else fprintf(stderr, "%s: Generating CA signature key pair (algorithm %s)...\n", cmd, aux_ObjId2Name(s_alg->objid));
	}

	if (af_gen_key(&nkey, SIGNATURE, FALSE) < 0) {
		fprintf(stderr, "%s: ",cmd);
		fprintf(stderr, "unable to generate sign key");
		aux_add_error(EINVALID, "unable to generate sign key", CNULL, 0, proc);
		LOGAFERR;
		return(-1);
	}
	/* now build a prototype certificate ... */
	if(onepaironly == TRUE)
		cert = af_create_Certificate(&nkinfo, sig_alg, SKnew_name, ca, serial);
	else
		cert = af_create_Certificate(&nkinfo, sig_alg, SignSK_name, ca, serial);

	if (! cert) {
		fprintf(stderr, "%s: ",cmd);
		fprintf(stderr, "unable to create prototype certificate\n");
		aux_add_error(EINVALID, "unable to create prototype certificate", CNULL, 0, proc);
		LOGAFERR;
		return(-1);
	}

	if(root && (notbefore || notafter)){
		/* af_sign() shall only be performed by RootCA, whose ENCRYPTION and
                   SIGNATURE certificates shall both be verified with its private SIGNATURE
	           key  
		*/
	
		/* af_sign will not work, if no certificate has been installed */
		if (af_pse_update_Certificate(SIGNATURE, cert, TRUE) < 0) {
			fprintf(stderr, "%s: ",cmd);
			fprintf(stderr, "unable to store signature prototype certificate on PSE");
			aux_add_error(EINVALID, "unable to store signature prototype certificate on PSE", CNULL, 0, proc);
			LOGAFERR;
			return(-1);
		}

		/* tbs->valid with its 'notbefore' and 'notafter' fields has been allocated
	           by routine af_create_Certificate() above
		 */

		if(notbefore) {
			free(cert->tbs->valid->notbefore);
			cert->tbs->valid->notbefore = aux_cpy_String(notbefore);
		}
		if(notafter) {
			free(cert->tbs->valid->notafter);
			cert->tbs->valid->notafter = aux_cpy_String(notafter);
		}
		
		/* re-encode ToBeSigned and re-sign certificate */
	
		aux_free_OctetString(&cert->tbs_DERcode);
		cert->tbs_DERcode = e_ToBeSigned(cert->tbs);
		if(!cert->tbs_DERcode){
			if(onepaironly == TRUE) aux_add_error(EENCODE, "e_ToBeSigned of prototype certificate FAILED", CNULL, 0, proc);
			else aux_add_error(EENCODE, "e_ToBeSigned of SIGNATURE prototype certificate FAILED", CNULL, 0, proc);
			LOGAFERR;
			return(-1);
		}

		if (af_sign(cert->tbs_DERcode, cert->sig, SEC_END) < 0) {
			aux_add_error(EINVALID, "Can't self-sign signature certificate", CNULL, 0, proc);
			LOGAFERR;
			return(-1);
		}
	}

	/* ... and store it on the PSE */
	if (af_pse_update_Certificate(SIGNATURE, cert, TRUE) < 0) {
		fprintf(stderr, "%s: ",cmd);
		fprintf(stderr, "unable to store self-signed signature certificate on PSE");
		aux_add_error(EINVALID, "unable to store self-signed signature certificate on PSE", CNULL, 0, proc);
		LOGAFERR;
		return(-1);
	}

	/* now build PKRoot with public key */

	if(!(pkroot = aux_create_PKRoot(cert, (Certificate *)0))) {
		fprintf(stderr, "%s: ",cmd);
		  fprintf(stderr, "Can't create PKRoot\n");
		aux_add_error(aux_last_error(), "Can't create PKRoot", CNULL, 0, proc);
		return(-1);
	}

	/* ... and install it so far */
	if (af_pse_update_PKRoot(pkroot) < 0) {
		fprintf(stderr, "%s: ",cmd);
		fprintf(stderr, "update of PKRoot failed");
		aux_add_error(EINVALID, "update of PKRoot failed", CNULL, 0, proc);
		LOGAFERR;
		return(-1);
	}
	aux_free_PKRoot(&pkroot);

	/* Enter SignCert to certdb: */

	if(onepaironly == TRUE)
		af_cadb_add_Certificate(3, cert, cadir_abs);
	else
		af_cadb_add_Certificate(SIGNATURE, cert, cadir_abs);


	/* Enter SignCert into Directory: */	

	if (af_access_directory == TRUE) {
#ifdef AFDBFILE
		/* Determine whether X.500 directory shall be accessed */
		x500 = af_x500_check();
#endif
#ifdef X500
		if ( x500 ) {
			directory_user_dname = aux_cpy_DName(cert->tbs->subject);
			if ( verbose ) {
				fprintf(stderr, "%s: Accessing the X.500 directory entry of ", cmd);
				fprintf(stderr, "owner = \"%s\" ...\n", aux_DName2Name(cert->tbs->subject));
			} 
			rc = af_dir_enter_Certificate(cert, cACertificate);
			if ( rc < 0 ) {
				fprintf(stderr, "%s: Directory entry (X.500) failed.\n", cmd);
				if(verbose) aux_fprint_error(stderr, verbose);
			}
			else if ( verbose ) fprintf(stderr, "%s: Certificate entered into X.500 Directory.\n", cmd);
		}
#endif
#ifdef AFDBFILE
		if ( verbose ) {
			fprintf(stderr, "%s: Accessing the AF-DB directory entry of ", cmd);
			fprintf(stderr, "owner = \"%s\" ...\n", aux_DName2Name(cert->tbs->subject));
		} 
		rc = af_afdb_enter_Certificate(cert, SIGNATURE);
		if ( rc < 0 ) {
			fprintf(stderr, "%s: Directory entry (AF-DB) failed.\n", cmd);
           	        if(verbose) aux_fprint_error(stderr, verbose);
		}
		else if ( verbose ) if(onepaironly == TRUE)
					fprintf(stderr, "%s: Certificate entered into AF-DB Directory.\n", cmd);
				    else
					fprintf(stderr, "%s: SIGNATURE Certificate entered into AF-DB Directory.\n", cmd);
#endif
	}  /* if(af_access_directory) */

	aux_free_Certificate(&cert);
	return(0);
}


/***************************************************************
 *
 * Procedure localinit
 *
 ***************************************************************/
#ifdef __STDC__

static int localinit(
	Name	 *ca,
	char	 *cadir_abs
)

#else

static int localinit(
	ca,
	cadir_abs
)
Name	 *ca;
char	 *cadir_abs;

#endif

{
#define	DBMOPENFL	O_RDWR|O_CREAT, S_IREAD|S_IWRITE

#ifdef NDBM
	DBM	* user;
	DBM	* cert;
	DBM     * crl;
#else
	FILE    * fd;
	char	  fn[PATH_LENGTH];
#endif
	char    * userdbpath, * certdbpath, * crldbpath;

	char    * proc = "localinit";

	if(!(userdbpath = aux_cat_paths(cadir_abs, USERDB))) {
		AUX_ADD_ERROR;
		return(-1);
	}
	if(!(certdbpath = aux_cat_paths(cadir_abs, CERTDB))) {
		AUX_ADD_ERROR;
		return(-1);
	}
	if(!(crldbpath = aux_cat_paths(cadir_abs, CRLDB))) {
		AUX_ADD_ERROR;
		return(-1);
	}

	
	/* user dbm */

#ifdef NDBM
	user = dbm_open(userdbpath, DBMOPENFL);
	if (!user) return(-1);
	dbm_close(user);
#else
	strcpy(fn, userdbpath);
	strcat(fn, ".pag");
	fd = fopen(fn, "r");
	if (fd) fclose(fd);
	else {
		fd = fopen(fn, "w");
		fclose(fd);
	}	
	strcpy(fn, userdbpath);
	strcat(fn, ".dir");
	fd = fopen(fn, "r");
	if (fd)	fclose(fd);
	else {
		fd = fopen(fn, "w");
		fclose(fd);
	}
	if (dbminit(userdbpath) < 0) return(-1);
	else dbmclose();
#endif


	/* cert dbm */

#ifdef NDBM
	cert = dbm_open(certdbpath, DBMOPENFL);
	if (!cert) return(-1);
	dbm_close(cert);
#else
	strcpy(fn, certdbpath);
	strcat(fn, ".pag");
	fd = fopen(fn, "r");
	if (fd) fclose(fd);
	else {
		fd = fopen(fn, "w");
		fclose(fd);
	}
	strcpy(fn, certdbpath);
	strcat(fn, ".dir");
	fd = fopen(fn, "r");
	if (fd) fclose(fd);
	else {
		fd = fopen(fn, "w");
		fclose(fd);
	}
	if (dbminit(certdbpath) < 0) return(-1);
	else dbmclose();
#endif


	/* crl dbm */

#ifdef NDBM
	crl = dbm_open(crldbpath, DBMOPENFL);
	if (!crl) return(-1);
	dbm_close(crl);
#else
	strcpy(fn, crldbpath);
	strcat(fn, ".pag");
	fd = fopen(fn, "r");
	if (fd) fclose(fd);
	else {
		fd = fopen(fn, "w");
		fclose(fd);
	}
	strcpy(fn, crldbpath);
	strcat(fn, ".dir");
	fd = fopen(fn, "r");
	if (fd) fclose(fd);
	else {
		fd = fopen(fn, "w");
		fclose(fd);
	}
	if (dbminit(crldbpath) < 0) return(-1);
	else dbmclose();
#endif


	return 0;
}


/***************************************************************
 *
 * Procedure encrinit
 *
 ***************************************************************/
#ifdef __STDC__

static int encrinit(
	DName	 *ca,
	AlgId	 *e_alg,
	AlgId	 *sig_alg,
	char	 *cadir_abs,
	int	  keysize,
	Boolean	  root
)

#else

static int encrinit(
	ca,
	e_alg,
	sig_alg,
	cadir_abs,
	keysize,
	root
)
DName	 *ca;
AlgId	 *e_alg;
AlgId	 *sig_alg;
char	 *cadir_abs;
int	  keysize;
Boolean	  root;

#endif

{
	AlgId	    * proto_sig_alg;
	Key	      nkey;
	KeyInfo	      nkinfo;
	PSESel	      psesk;
	Boolean       x500 = TRUE;
	OctetString * serialnumber;
	Certificate * cert;
	int           rc;
	AlgEnc        s_algenc, k_algenc;
#ifdef AFDBFILE
	char          afdb[256];
#endif
	char	    * proc = "encrinit";

	/*	generate encryption key */

	nkey.key = &nkinfo;
	nkey.keyref = 0;
	nkey.pse_sel = (PSESel * ) 0;
	nkinfo.subjectAI = aux_cpy_AlgId(e_alg);
        if(aux_ObjId2ParmType(e_alg->objid) != PARM_NULL)
	        *(int *)(nkinfo.subjectAI->param) = keysize;
	else {
		if(aux_ObjId2AlgEnc(e_alg->objid) == RSA) {
			  	nkinfo.subjectAI = aux_cpy_AlgId(rsa);
				*(int *)(nkinfo.subjectAI->param) = keysize;
		}
	}

        if(verbose) fprintf(stderr, "%s: Generating CA encryption key pair (algorithm %s)...\n", cmd, aux_ObjId2Name(e_alg->objid));

	if (af_gen_key(&nkey, ENCRYPTION, FALSE) < 0) {
		fprintf(stderr, "%s: ",cmd);
                fprintf(stderr, "unable to generate encryption key");
		aux_add_error(EINVALID, "unable to generate encryption key", CNULL, 0, proc);
		LOGAFERR;
		return(-1);
	}

	psesk.app_name	  = 	AF_pse.app_name;
	psesk.pin	  = 	aux_cpy_String(AF_pse.pin);
	psesk.app_id	  = 	AF_pse.app_id;
	psesk.object.name = 	DecSKnew_name;
	psesk.object.pin  =     aux_cpy_String(AF_pse.pin);

	nkey.pse_sel = &psesk;

	k_algenc = aux_ObjId2AlgEnc(nkinfo.subjectAI->objid);

	if(!sig_alg || aux_ObjId2AlgEnc(sig_alg->objid) != k_algenc) {

		if(k_algenc == RSA)  proto_sig_alg = md2WithRsaEncryption;
		else if(k_algenc == DSA)  proto_sig_alg = dsaWithSHA;
	}
	else proto_sig_alg = sig_alg;

	serialnumber = af_pse_incr_serial();
	if(!serialnumber){
		aux_add_error(EINVALID, "problems with serial number", CNULL, 0, proc);
		return(-1);
	}

	cert = af_create_Certificate(&nkinfo, proto_sig_alg, DecSKnew_name, ca, serialnumber);
	aux_free_OctetString(&serialnumber);

	if (!cert) {
		fprintf(stderr, "%s: ",cmd);
                fprintf(stderr, "unable to create prototype certificate\n");
		aux_add_error(EINVALID, "unable to create prototype certificate", CNULL, 0, proc);
		LOGAFERR;
		return(-1);
	}

	if(root){
		/* af_sign() shall only be performed by RootCA, whose ENCRYPTION and
                   SIGNATURE certificates shall both be verified with its private SIGNATURE
	           key  
		*/
	
		/* tbs->valid with its 'notbefore' and 'notafter' fields has been allocated
	           by routine af_create_Certificate() above
		 */

		if(notbefore) {
			free(cert->tbs->valid->notbefore);
			cert->tbs->valid->notbefore = aux_cpy_String(notbefore);
		}
		if(notafter) {
			free(cert->tbs->valid->notafter);
			cert->tbs->valid->notafter = aux_cpy_String(notafter);
		}
	
		if(notbefore || notafter){
			/* ToBeSigned has been modified, so re-encode it */
			aux_free_OctetString(&cert->tbs_DERcode);
			cert->tbs_DERcode = e_ToBeSigned(cert->tbs);
			if(!cert->tbs_DERcode){
				aux_add_error(EENCODE, "e_ToBeSigned of ENCRYPTION prototype certificate FAILED", CNULL, 0, proc);
				LOGAFERR;
				return(-1);
			}
		}

		/* certificate finished, now sign again */
		   
		aux_free_AlgId(&cert->sig->signAI);

		cert->sig->signAI = aux_cpy_AlgId(sig_alg);

		if (af_sign(cert->tbs_DERcode, cert->sig, SEC_END) < 0) {
			aux_add_error(ESIGNATURE, "Can't self-sign ENCRYPTION certificate", CNULL, 0, proc);
			LOGAFERR;
			return(-1);
		}
	}

	/* ... and store it on the PSE */
	if (af_pse_update_Certificate(ENCRYPTION, cert, TRUE) < 0) {
		fprintf(stderr, "%s: ",cmd);
		fprintf(stderr, "unable to store self-signed encryption certificate on PSE\n");
		aux_add_error(EINVALID, "unable to store self-signed encryption certificate on PSE", CNULL, 0, proc);
		LOGAFERR;
		return(-1);
	}

	/* ... and store it on the CA DB */
	af_cadb_add_Certificate(ENCRYPTION, cert , cadir_abs);


	/* Enter EncCert into Directory: */

	if (af_access_directory == TRUE) {
#ifdef AFDBFILE
		/* Determine whether X.500 directory shall be accessed */
		x500 = af_x500_check();
#endif
#ifdef X500
		if ( x500 ) {
			if ( verbose ) {
				fprintf(stderr, "%s: Accessing the X.500 directory entry of ", cmd);
				fprintf(stderr, "owner = \"%s\" ...\n", caname);
			} 
			rc = af_dir_enter_Certificate(cert, cACertificate);
			if ( rc < 0 ) {
				fprintf(stderr, "%s: Directory entry (X.500) failed.\n", cmd);
				if(verbose) aux_fprint_error(stderr, verbose);
			}
			else if ( verbose ) fprintf(stderr, "%s: Certificate entered into X.500 Directory.\n", cmd);
		}
#endif
#ifdef AFDBFILE
		if ( verbose ) {
			fprintf(stderr, "%s: Accessing the AF-DB directory entry of ", cmd);
			fprintf(stderr, "owner = \"%s\" ...\n", caname);
		} 
		rc = af_afdb_enter_Certificate(cert, ENCRYPTION);
		if ( rc < 0 ) {
			fprintf(stderr, "%s: Directory entry (AF-DB) failed.\n", cmd);
           	        if(verbose) aux_fprint_error(stderr, verbose);
		}
		else if ( verbose ) fprintf(stderr, "%s: ENCRYPTION Certificate entered into AF-DB Directory.\n", cmd);

#endif
	}  /* if (af_access_directory) */


	aux_free_Certificate(&cert);
	
	return (0);
}


/***************************************************************
 *
 * Procedure crlinit
 *
 ***************************************************************/
#ifdef __STDC__

static int crlinit(
	char	 *cadir_abs,
	AlgId	 *sig_alg,
	char	 *nextupdate
)

#else

static int crlinit(
	cadir_abs,
	sig_alg,
	nextupdate
)
char	 *cadir_abs;
AlgId	 *sig_alg;
char	 *nextupdate;

#endif

{
	CRL                  * crl;
	CRLWithCertificates  	* crlwithcerts;
	Boolean                   x500 = TRUE;
	int			  rc;
	Crl			* crlpse;
	AlgId			* alg;
#ifdef AFDBFILE
	char                      afdb[256];
#endif

	char	    * proc = "crlinit";


	crl = (CRL * )malloc(sizeof(CRL));
	if (! crl) {
		fprintf(stderr, "%s: ",cmd);
  	        fprintf(stderr, "Can't allocate memory\n");
		aux_add_error(EMALLOC, "crl", CNULL, 0, proc);
		return(-1);
	}

	crl->tbs = (CRLTBS * )malloc(sizeof(CRLTBS));
	if (! crl->tbs) {
		fprintf(stderr, "%s: ",cmd);
  	        fprintf(stderr, "Can't allocate memory\n");
		aux_add_error(EMALLOC, "crl->tbs", CNULL, 0, proc);
		return(-1);
	}

	if (!(crl->tbs->issuer = af_pse_get_Name())) {
		aux_add_error(EREADPSE, "af_pse_get_Name failed", CNULL, 0, proc);
		return(-1);
	}

	crl->tbs->lastUpdate = aux_current_UTCTime();
	if(nextupdate){ 
		if (aux_interval_UTCTime(CNULL, crl->tbs->lastUpdate, nextupdate)) {
			fprintf(stderr, "%s: ",cmd);
          		fprintf(stderr, "Validity interval of CRL incorrectly specified\n");
			aux_add_error(EVALIDITY, "aux_interval_UTCTime failed", CNULL, 0, proc);
			return(-1);
		}
		crl->tbs->nextUpdate = nextupdate;
	}
	else
		crl->tbs->nextUpdate = aux_delta_UTCTime(crl->tbs->lastUpdate, 0);

	crl->tbs->revokedCertificates = (SEQUENCE_OF_CRLEntry * )0;

	crl->sig = (Signature * )malloc(sizeof(Signature));
	if (! crl->sig) {
		fprintf(stderr, "%s: ",cmd);
  	        fprintf(stderr, "Can't allocate memory\n");
		aux_add_error(EMALLOC, "crl->sig", CNULL, 0, proc);
		return(-1);
	}
	crl->sig->signature.nbits = 0;
	crl->sig->signature.bits = CNULL;

	crl->tbs->signatureAI = af_get_signature_alg(sig_alg, (AlgId *)0);
	crl->sig->signAI = aux_cpy_AlgId(crl->tbs->signatureAI);

	if ((crl->tbs_DERcode = e_CRLTBS(crl->tbs)) == NULLOCTETSTRING) {
		fprintf(stderr, "%s: ",cmd);
  	        fprintf(stderr, "e_CRLTBS failed\n");
		aux_add_error(EENCODE, "e_CRLTBS failed", CNULL, 0, proc);
		return(-1);
	}

	if (af_sign(crl->tbs_DERcode, crl->sig, SEC_END) < 0 ) {
		aux_add_error(ESIGN, "af_sign failed", CNULL, 0, proc);
		return(-1);
	}

	crlwithcerts = (CRLWithCertificates * )malloc(sizeof(CRLWithCertificates));
	if (! crlwithcerts) {
		fprintf(stderr, "%s: ",cmd);
  	        fprintf(stderr, "Can't allocate memory\n");
		aux_add_error(EMALLOC, "crlwithcerts", CNULL, 0, proc);
		return(-1);
	}

	crlwithcerts->crl = crl;
	crlwithcerts->certificates = (Certificates * )0;

	af_cadb_add_CRLWithCertificates(crlwithcerts, cadir_abs);

	
	/* Store own CRL in PSE object CrlSet */

	crlpse = CRL2Crl(crl);
	rc = af_pse_add_CRL(crlpse);
	if (rc != 0) {
		fprintf(stderr, "%s: ",cmd);
  	        fprintf(stderr, "Cannot update PSE object CrlSet\n");
		aux_add_error(EWRITEPSE, "af_pse_add_CRL failed", CNULL, 0, proc);
		aux_free_Crl(&crlpse);
		aux_free_CRLWithCertificates(&crlwithcerts);
		return(-1);
	}
	aux_free_Crl(&crlpse);

	/* Enter CRL into Directory: */

	if (af_access_directory == TRUE) {
#ifdef AFDBFILE
		/* Determine whether X.500 directory shall be accessed */
		x500 = af_x500_check();
#endif
#ifdef X500
		if ( x500 ) {
			if ( verbose ) {
				fprintf(stderr, "%s: Accessing the X.500 directory entry of ", cmd);
				fprintf(stderr, "owner = \"%s\" ...\n", caname);
			} 
			rc = af_dir_enter_CRL(crl);
			if ( rc < 0 ) {
				fprintf(stderr, "%s: Directory entry (X.500) failed.\n", cmd);
				if(verbose) aux_fprint_error(stderr, verbose);
			}
			else if ( verbose ) fprintf(stderr, "%s: CRL entered into X.500 Directory.\n", cmd);
		}
#endif
#ifdef AFDBFILE
		if ( verbose ) {
			fprintf(stderr, "%s: Accessing the AF-DB directory entry of ", cmd);
			fprintf(stderr, "owner = \"%s\" ...\n", caname);
		} 
		rc = af_afdb_enter_CRL(crl);
		if ( rc < 0 ) {
			fprintf(stderr, "%s: Directory entry (AF-DB) failed.\n", cmd);
           	        if(verbose) aux_fprint_error(stderr, verbose);
		}
		else if ( verbose ) fprintf(stderr, "%s: CRL entered into AF-DB Directory.\n", cmd);
	
#endif
	}  /* if (af_access_directory) */

	aux_free_CRLWithCertificates(&crlwithcerts);


	return(0);
}




/***************************************************************
 *
 * Procedure usage
 *
 ***************************************************************/
#ifdef __STDC__

static void usage(
	int	  help
)

#else

static void usage(
	help
)
int	  help;

#endif

{

	aux_fprint_version(stderr);

        fprintf(stderr, "cacreate: Create CA (CA command)\n\n\n");
	fprintf(stderr, "Description:\n\n"); 
	fprintf(stderr, "'cacreate' creates a CA directory containing the CA PSE with one or two\n");
        fprintf(stderr, "asymmetric keypairs,  self-signed prototype certificate(s), an empty\n");
        fprintf(stderr, "revocation list, and the SerialNumber on it, and the CA database.\n\n\n");

        fprintf(stderr, "usage:\n\n");
#ifdef X500
	fprintf(stderr, "cacreate [-hrqvzDVWXY] [-p <pse>] [-c <cadir>] [-a <issueralg>] [-s <signalg>] [-k <keysize>]\n");
	fprintf(stderr, "         [-e <encalg>] [-k <keysize>] [-n <serial>] [-u <nextupdate>]\n");
	fprintf(stderr, "         [-f <notbefore>] [-l <notafter>] [-d <dsa name>] [-t <dsaptailor>] [-A <authlevel>] [CA-Name]\n\n");
#else
	fprintf(stderr, "cacreate [-hrqvzDVWXY] [-p <pse>] [-c <cadir>] [-a <issueralg>] [-s <signalg>] [-k <keysize>]\n");
	fprintf(stderr, "         [-e <encalg>] [-k <keysize>] [-n <serial>] [-u <nextupdate>]\n");
	fprintf(stderr, "         [-f <notbefore>] [-l <notafter>] [CA-Name]\n\n");
#endif


        if(help == LONG_HELP) {
        fprintf(stderr, "with:\n\n");
        fprintf(stderr, "-p <psename>       PSE name (default: environment variable CAPSE or .capse)\n");
        fprintf(stderr, "-c <cadir>         Name of CA-directory (default: environment variable CADIR or .ca)\n");
	fprintf(stderr, "-a <issueralg>     Issuer algorithm associated with the signature of the prototype certificate(s)\n");
	fprintf(stderr, "                   (default: md2WithRsaEncryption)\n");
	fprintf(stderr, "-s <signalg>       Signature algorithm (default: rsa)\n");
	fprintf(stderr, "-k <keysize>       Keysize of RSA signature key\n");
	fprintf(stderr, "-e <encalg>        Encryption algorithm (default: rsa)\n");
	fprintf(stderr, "-k <keysize>       Keysize of RSA encryption key\n");
	fprintf(stderr, "-n <serial>        Initial value of the serial number to be used by the CA. <serial> must be a\n");
	fprintf(stderr, "                   string from [0..9,A..F] representing the hexadecimal notation of the number.\n");
	fprintf(stderr, "-r                 create Root-CA, which means that if the generated PSE holds two keypairs,\n");
	fprintf(stderr, "                   the corresponding certificates are both signed by the signature key\n");
	fprintf(stderr, "                   (default: the encryption certificate is signed by the private decryption key)\n");
	fprintf(stderr, "-D                 store self-signed certificate(s) in Directory (X.500 or AF-DB)\n");
	fprintf(stderr, "-u <nextupdate>    Time and date of next scheduled CRL update (default: current date + one year)\n");
	fprintf(stderr, "-f <notbefore>     First date on which self-signed certificate is valid (default: current date).\n");
	fprintf(stderr, "                   (is only evaluated if option -r was supplied)\n");
	fprintf(stderr, "                   Date is given as UTCTime: yymmddhhmmssZ or yymmddhhmmss+hhmm\n");
	fprintf(stderr, "-l <notafter>      Last date on which self-signed certificate is valid (default: notbefore + one year)\n");
	fprintf(stderr, "                   (is only evaluated if option -r was supplied)\n");
	fprintf(stderr, "-q                 create PSE that contains two RSA keypairs (default: one RSA keypair only)\n");
	fprintf(stderr, "-t                 control malloc/free behaviour\n");
        fprintf(stderr, "-h                 write this help text\n");
        fprintf(stderr, "-v                 verbose\n");
        fprintf(stderr, "-V                 Verbose\n");
        fprintf(stderr, "-W                 Grand Verbose (for testing only)\n");
        fprintf(stderr, "-X                 Read random number generator seed from PSE-object Random\n");
        fprintf(stderr, "-Y                 Init random number generator seed through keyboard input\n");
#ifdef X500
	fprintf(stderr, "-d <dsa name>      Name of the DSA to be initially accessed (default: locally configured DSA)\n");
	fprintf(stderr, "-t <dsaptailor>    Location of dsaptailor file (default: dsaptailor in the ISODE ETCDIR directory)\n");
	fprintf(stderr, "-A <authlevel>     Level of authentication used for X.500 Directory access\n");
	fprintf(stderr, "                   <authlevel> may have one of the values 'SIMPLE' or 'STRONG'\n");
	fprintf(stderr, "                   (default: environment variable AUTHLEVEL or 'No authentication')\n");
	fprintf(stderr, "                   STRONG implies the use of signed DAP operations\n");
#endif
	fprintf(stderr, "<CA-Name>          Intended owner of the generated CA PSE\n");
        }

        if(MF_check) MF_fprint(stderr);

        exit(-1);                                /* IRREGULAR EXIT FROM CACREATE */
}
