/* ./src/util/certify.c */

static char *rcsid = "$Id: certify.c,v 1.6 1995/01/09 08:52:00 surkau Exp $";

/* 
 *
 * $Id: certify.c,v 1.6 1995/01/09 08:52:00 surkau Exp $
 *
 * $Log: certify.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*
 *      Program to certify ones Public Key contained in a Prototype Certificate
 *      to be run by CA, which replaces Certificate file.
 */

#include <fcntl.h>
#include <stdio.h>
#include "cadb.h"

#ifdef MS_DOS
#include <fcntl.h>
#endif



Boolean		selfsigned_check = TRUE;
int             verbose = 0;

#ifdef __STDC__
static void     usage(int help);
#else
static void     usage();
#endif


/***************************************************************
 *
 * Procedure main
 *
 ***************************************************************/
#ifdef __STDC__

int main(
	int	  cnt,
	char	**parm
)

#else

int main(
	cnt,
	parm
)
int	  cnt;
char	**parm;

#endif

{
	int	        i;
        RC              rc;
	char	        *pf[2];
	int	        pfd[2];
	OctetString     *cin, *newcert;
	AlgId           *algorithm = (AlgId *)0;
	ObjId           *oid;
        Key             key;
	Certificate     *cert;
	Certificates    orig_cert;
	FCPath          fcpath;
	extern char	*optarg;
	extern int	optind, opterr;
	char	        *cmd = *parm;
	int             opt;
	char	        *psename = CNULL, *cadir = CNULL, *home, * pin;
	char		*logpath, *notbefore = CNULL, *notafter = CNULL;
	Name		*printrepr;
	Validity	validity;
	Certificate     *new_cert;

	char		*proc = "main (certify)";

#ifdef MS_DOS
	_fmode = O_BINARY;
#endif

        pf[0] = pf[1] = 0;
	optind = 1;
	opterr = 0;

	MF_check = FALSE;

	while ( (opt = getopt(cnt, parm, "a:c:p:f:l:nhvzVW")) != -1 ) {
		switch (opt) {
		case 'a':
                        oid = aux_Name2ObjId(optarg);
                        if (aux_ObjId2AlgType(oid) != SIG) usage(SHORT_HELP);
			algorithm = aux_ObjId2AlgId(oid);
			break;
		case 'c':
			if (cadir) usage(SHORT_HELP);
			else cadir = optarg;
			break;
		case 'p':
			if (psename) usage(SHORT_HELP);
			else psename = optarg;
			break;
		case 'f':
			if (notbefore) usage(SHORT_HELP);
			else notbefore = optarg;
			break;
		case 'l':
			if (notafter) usage(SHORT_HELP);
			else notafter = optarg;
			break;
		case 'n':
			selfsigned_check = FALSE;
			break;
                case 'z':
                        MF_check = TRUE;
                        break;
		case 'v':
			verbose = 1;
			continue;
		case 'V':
			verbose = 2;
			continue;
		case 'W':
			verbose = 2;
			af_verbose = TRUE;
			sec_verbose = TRUE;
			continue;
		case 'h':
			usage(LONG_HELP);
			continue;
		default:
		case '?':
			usage(SHORT_HELP);
		}
	}

	if ((notbefore && !notafter) || (!notbefore && notafter))
		usage(SHORT_HELP);



        i = 0;
	while (optind < cnt && i < 2) pf[i++] = parm[optind++];

        if(!cadir) cadir = getenv("CADIR");
        if(!cadir) cadir = DEF_CADIR;

	aux_set_pse(psename, cadir);

	if (!(cin = aux_file2OctetString(pf[0]))) {
		fprintf(stderr,"%s: Can't read %s\n", cmd, pf[0]);
		aux_add_error(EINVALID, "Can't read file", CNULL, 0, proc);
		aux_fprint_error(stderr, verbose);
		exit(-1);
	}

	/* O.K. skip to CA dir */

	if(!(logpath = aux_get_abs_path(cadir, CALOG))) {
		AUX_ADD_ERROR;
		return(-1);
	}

	if ((logfile = fopen(logpath, LOGFLAGS)) == (FILE * ) 0) {
		fprintf(stderr, "%s: Can't open %s\n", cmd, CALOG);
		aux_add_error(EINVALID, "Can't open", CALOG, char_n, proc);
		aux_fprint_error(stderr, verbose);
		exit(-1);
	}

	cert = d_Certificate(cin);
	if (!cert) {
		fprintf(stderr, "%s: Can't decode prototype certificate\n", cmd);
		aux_add_error(EINVALID, "Can't decode prototype certificate", CNULL, 0, proc);
		aux_fprint_error(stderr, verbose);
		exit(-1);
	}


	if ((selfsigned_check == TRUE) && 
	    (aux_cmp_DName(cert->tbs->subject, cert->tbs->issuer))) {
		fprintf(stderr, "%s: Certificate is not a prototype certificate\n", cmd);
		aux_add_error(EINVALID, "Certificate is not a prototype certificate", CNULL, 0, proc);
		aux_fprint_error(stderr, verbose);
		exit(-1);
	}


	validity.notbefore = notbefore;
	validity.notafter = notafter;
	new_cert = af_certify (cert, 
				&validity,
				algorithm);

	if (new_cert == (Certificate *) 0) {
                LOGERR("can't certify certificate");
		fprintf(stderr, "%s: ",cmd);
                fprintf(stderr, "can't certify certificate\n");
		aux_add_error(EINVALID, "can't certify certificate", CNULL, 0, proc);
		aux_fprint_error(stderr, verbose);
                exit(-1);		
	}
	aux_free_Certificate(&cert);
	cert = new_cert;
	

	printrepr = aux_DName2Name(cert->tbs->subject);
        if(af_cadb_add_user(printrepr, cadir) < 0) {
                LOGERR("can't access user db");
		fprintf(stderr, "%s: ",cmd);
                fprintf(stderr, "Can't access user db\n");
		aux_add_error(EINVALID, "can't access user db", CNULL, 0, proc);
		aux_fprint_error(stderr, verbose);
                exit(-1);
        }
	free(printrepr);

	if (af_cadb_add_Certificate(0, cert, cadir)) {
		LOGERR("Can't access cert db");
		aux_add_error(EINVALID, "can't access user db", CNULL, 0, proc);
		aux_fprint_error(stderr, verbose);
		exit(-1);
	}


	newcert = e_Certificate(cert);
	if (!newcert) {
		fprintf(stderr, "%s: Can't encode new Certificate.\n", cmd);
		aux_add_error(EENCODE, "can't encode new Certificate", CNULL, 0, proc);
		aux_fprint_error(stderr, verbose);
		exit(-1);
	}

	if (aux_OctetString2file(newcert, pf[1], 2)) {
		fprintf(stderr, "%s: Can't create or write %s\n", cmd, pf[1]);
		aux_add_error(EINVALID, "Can't create or write file", pf[1], char_n, proc);
		aux_fprint_error(stderr, verbose);
		exit(-1);
	}

        if(verbose) {
		printrepr = aux_DName2Name(cert->tbs->issuer);
        	fprintf(stderr, "%s: The following certificate was generated by <%s> using PSE %s:\n", cmd, printrepr, AF_pse.app_name);
        	aux_fprint_Certificate(stderr, cert);
		free(printrepr);
        }
	exit(0);
}



/***************************************************************
 *
 * Procedure usage
 *
 ***************************************************************/
#ifdef __STDC__

static void usage(
	int	  help
)

#else

static void usage(
	help
)
int	  help;

#endif

{

	aux_fprint_version(stderr);

        fprintf(stderr, "certify: Certify Public Key (CA command)\n\n\n");
	fprintf(stderr, "Description:\n\n");
	fprintf(stderr, "'certify' reads a prototype certificate from file <proto> or stdin, if\n");
	fprintf(stderr, "<proto> is omitted, and transforms it into a 'valid' certificate.\n");
	fprintf(stderr, "It replaces the 'issuer' and 'serialnumber' fields of the prototype\n");
	fprintf(stderr, "certificate by its CA values (taken from its CA PSE), and replaces\n");
	fprintf(stderr, "the signature appended to the prototype certificate by its own signature.\n");
	fprintf(stderr, "The resulting certificate is written to file <cert> or stdout, if <cert>\n");
	fprintf(stderr, "is omitted.\n\n\n");

        fprintf(stderr, "usage:\n\n");
	fprintf(stderr, "certify [-hvzVW] [-p <pse>] [-c <cadir>] [-a <issueralg>] [-f <notbefore>] [-l <notafter>] [proto [cert]]\n\n");
 

        if(help == LONG_HELP) {
        	fprintf(stderr, "with:\n\n");
        	fprintf(stderr, "-p <psename>       PSE name (default: environment variable CAPSE or .capse)\n");
        	fprintf(stderr, "-c <cadir>         Name of CA-directory (default: environment variable CADIR or .ca)\n");
		fprintf(stderr, "-a <issueralg>     CA's signature algorithm (default: md2WithRsaEncryption)\n");
		fprintf(stderr, "-f <notbefore>     First date on which the certificate is valid\n");
		fprintf(stderr, "-l <notafter>      Last date on which the certificate is valid\n");
		fprintf(stderr, "-n 		    Certificate to be certified must not be a prototype certificate\n");
		fprintf(stderr, "-z                 control malloc/free behaviour\n");
        	fprintf(stderr, "-h                 write this help text\n");
        	fprintf(stderr, "-v                 verbose\n");
        	fprintf(stderr, "-V                 Verbose\n");
        	fprintf(stderr, "-W                 Grand Verbose (for testing only)\n");
		fprintf(stderr, "<proto>            File containing the prototype certificate (or stdin, if omitted)\n");
		fprintf(stderr, "<cert>             File containing the resulting certificate (or stdout, if omitted)\n");
        }

        if(MF_check) MF_fprint(stderr);

        exit(-1);                                /* IRREGULAR EXIT FROM CERTIFY */
}
