/* ./src/util/gen_pse.c */

static char *rcsid = "$Id: gen_pse.c,v 1.15 1995/03/07 14:05:23 viebeg Exp $";

/* 
 *
 * $Id: gen_pse.c,v 1.15 1995/03/07 14:05:23 viebeg Exp $
 *
 * $Log: gen_pse.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*
 *      Program to generate PSEs at CA sites
 */


#define SIGNKEY "signature"
#define ENCKEY  "encryption"

#define NEXTC  if ((c = getc(scr)) == EOF) return

#include <fcntl.h>
#include <stdio.h>
#include <pwd.h>
#include <sys/wait.h>

#include "cadb.h"
#include "aux_time.h"

#include <errno.h>

#ifdef GDBM
#include "../gdbm/ndbm.h"
#else
#ifdef NDBM
#include <ndbm.h>
#else
#include <dbm.h>
#endif
#endif

#ifdef MS_DOS
#define setuid(a) 0
#endif

#include <sys/types.h>
#include <sys/stat.h>
struct stat     buf;

struct passwd  *pwentry;



/* 			parameter structure for a PSE-creation 		*/

struct parms {
	char           *userpse, *nameprefix, *notbefore, *notafter, *userpin,
	               *capin, *newca, *HOME;
#ifdef X500
	char *dsa, *dsap_tailor;
#endif
	AlgId          *issuer_alg, *algorithms[2];
	int             oldpkroot, keysizes[2];
	OctetString    *serial;
	Boolean         pkroot, oldpkr, newpkr, enter, SC_ignore, replace,
	                create, fcpath, cert[2], newkey[2], onekeypair;
#ifdef X500
	char           *vecptr2;
#endif
};

/*		Commands of script file   */
char           *script_cmds[] = {
	"issuer_alg",
	"subject_encalg",
	"subject_sigalg",
	"subject_pse",
	"notbefore",
	"notafter",
	"validity",
	"enter",
	"notenter",
#ifdef X500
	"dsa",
	"dsap_tailor",
#endif
	"nameprefix",
	"transportpin",
	"sw_pse",
	"sc_pse",
	"home",
	"user",
	"userhome",
	"ca",
	"replace",
	"notreplace",
	"create",
	"update",
	"onekeypair",
	"twokeypairs",
	CNULL
};

typedef enum {
	ISSUER_ALG, SUBJECT_ENCALG, SUBJECT_SIGALG, SUBJECT_PSE, NOTBEFORE, NOTAFTER, VALIDITY, ENTER, NOTENTER, 
#ifdef X500
DSA_NAME, DSAP_TAILOR, 
#endif
NAMEPREFIX, TRANSPORTPIN, SW_PSE, SC_PSE, HOMEDIRS, USER_PSE, USER_HOME, CA_PSE, REPLACE_KEY, NOT_REPLACE_KEY, CREATE, UPDATE, ONE_KEY_PAIR, TWO_KEY_PAIRS
}               Script_Cmds;


typedef enum {
	UNIXNAME, ADDRESS, SUFFIX, PARMMAX
}               PSE_Items;


/* 		Keywords of an update command */
char           *update_parm[] = {
	"oldpkroot",
	"newpkroot",
	"pkroot",
	"fcpath",
	"signcert",
	"encrcert",
	"newkey",
	CNULL
};
typedef enum {
	OLD_TO_PKLIST, NEW_TO_PKLIST, PKROOT, FCPATH, SIGN_CERT, ENCR_CERT, NEW_KEY
}               Update_Parms;



struct parms    local, global;
struct parms   *actualparms = &global;

int             keysize = DEF_ASYM_KEYSIZE, ka = 0, kk = 0, fd;
RC              rc, rc_psecreate;
int	        verbose = 0;
OctetString    *ostr, *newcert;
PKRoot         *pkroot, *oldpkroot;
PKList         *pklist, *newpklist;
FCPath         *fcpath;
SET_OF_Certificate *soc, *fcpathcerts;
Certificates   *certs;
Name           *subject_Name, *issuer = CNULL, *printrepr, *name;
DName          *subject_DName, *issuer_dn = NULLDNAME, *proto_dn = NULLDNAME;
AlgId          *algorithm;
ObjId          *oid;
PSESel         *pse, psesel;
Key             key;
KeyInfo         keyinfo;
KeyType         ktype;
Certificate    *subject_Certificate;
Boolean         hierarchy = TRUE, x500 = FALSE, af_db = FALSE;
char           *keytype, *home, *useraddress, *namesuffix = "\0", *userunixname = " ",
               *userhomedir;
int             userunixuid, caunixuid;
char           *cadir_abs, *logpath;
char           *keytypes[2], *script, line[256], afdb[256];

extern char    *optarg;
extern int      optind, opterr;


#ifdef X500
char            name_from_pse = TRUE;
CertificateType certtype;
#endif

char           *capse = DEF_CAPSE, *capsepath = CNULL, *cadir = CNULL;
char            userhome[256], cahome[256], cahomedir[256], username[16],
               *genpsedir, userappldir[256], userpsedir[256], userfiledir[256],
                userfilebakdir[256], *userappldir_rel;

typedef enum {
	USER, CA
}               PSEtype;

char		 *pinfile_name = CNULL;
char		 *pinfile_encname = CNULL;
char		 *pinfile_keyname = CNULL;
Key		  pinfile_deskey;
Key		  pinfile_rsakey;
Certificate	 *pinfile_cert;
EncryptedKey      pinfile_encrypted_deskey;
OctetString      *pinfile_encoded_encrypted_deskey;

char            c, syscmd[256];
int             linenr = 1, n, psenumber = 0;
FILE           *scr, *fopen();
char            scrstr[256], scrcmd[256], filename[256], scrword1[256],
                scrword2[256], scrword3[256];
T_REC           trec;

int             parmno = UNIXNAME;

#ifdef __STDC__
static void	usage	(int help);
static int	localinit	(char *cadir_abs);
static int	set_AF_pse	(PSEtype psetype);
static RC	psecreate	(char *cmd);
static int	parmnumber	(char *a);
static int	cmdnumber	(char *a);
static void	replacestr	(char **a, char *b, char *bb);
static int	readword	(char *str);
static void	readtimeformat	(char *s, int *i);
static UTCTime	*txt2UTCTime	(char *txt, UTCTime *oldtime);
static void scancmd();
static void nextnonblank();
static RC chk_pse_dir();
static RC make_genpsedir();
static char *create_random_pin();
static int create_pinfile_entry();
static RC handle_afdb_directory(Certificate  *subject_Certificate);

#else
static void	usage	();
static int	localinit	();
static int	set_AF_pse	();
static RC	psecreate	();
static int	parmnumber	();
static int	cmdnumber	();
static void	replacestr	();
static int	readword	();
static void	readtimeformat	();
static UTCTime	*txt2UTCTime	();
static void scancmd();
static void nextnonblank();
static RC chk_pse_dir();
static RC make_genpsedir();
static char *create_random_pin();
static int create_pinfile_entry();
static RC handle_afdb_directory();
#endif



/***************************************************************
 *
 * Procedure main
 *
 ***************************************************************/
#ifdef __STDC__

int main(
	int	  cnt,
	char	**parm
)

#else

int main(
	cnt,
	parm
)
int	  cnt;
char	**parm;

#endif

{
	int             i;
	char           *cmd = *parm, *cc, *dd, *nb, *na, *sma, *repl;
	int             opt;
	char           *p1, *p2;
	char            keyno = -1;
	Boolean         sc = FALSE;
	PSELocation     pse_location;
	PSELocation     capse_location;

	char           *proc = "main (ca_gen_pse)";

#ifdef MS_DOS
	_fmode = O_BINARY;
#endif

	optind = 1;
	opterr = 0;

	psesel.app_name = CNULL;
	psesel.pin = CNULL;
	psesel.object.name = CNULL;
	psesel.object.pin = CNULL;
	psesel.app_id = 0;

	actualparms->serial = (OctetString *) 0;
#ifdef X500
	actualparms->dsa = CNULL;
	actualparms->dsap_tailor = CNULL;
#endif
	actualparms->newca = CNULL;
	actualparms->enter = FALSE;
	actualparms->replace = FALSE;
	actualparms->SC_ignore = FALSE;
	actualparms->HOME = CNULL;
	actualparms->notbefore = CNULL;
	actualparms->notafter = CNULL;
	actualparms->userpse = DEF_PSE;
	actualparms->nameprefix = "\0";
	actualparms->algorithms[0] = DEF_SUBJECT_SIGNALGID;	/* rsa        */
	actualparms->algorithms[1] = DEF_SUBJECT_ENCRALGID;	/* rsa        */
	actualparms->issuer_alg = (AlgId *)0;	
	actualparms->create = TRUE;
	actualparms->pkroot = TRUE;
	actualparms->oldpkr = FALSE;
	actualparms->newpkr = FALSE;
	actualparms->fcpath = TRUE;
	actualparms->cert[0] = TRUE;
	actualparms->newkey[0] = TRUE;
	actualparms->cert[1] = TRUE;
	actualparms->newkey[1] = TRUE;
	keytypes[0] = SIGNKEY;
	keytypes[1] = ENCKEY;
	actualparms->keysizes[0] = DEF_ASYM_KEYSIZE;
	actualparms->keysizes[1] = DEF_ASYM_KEYSIZE;
	actualparms->onekeypair = TRUE;
	ka = 2;
	caunixuid = getuid();

#ifdef X500
	certtype = userCertificate;	/* default */
	af_dir_authlevel = DBA_AUTH_SIMPLE;	/* default */
#endif

	MF_check = FALSE;

#ifdef X500
	while ((opt = getopt(cnt, parm, "a:s:e:k:i:c:p:P:f:l:d:t:u:H:g:x:C:T:rDvVWqnzXYh")) != -1) {
#else
	while ((opt = getopt(cnt, parm, "a:s:e:k:i:c:p:P:f:l:u:H:g:x:C:T:rDvVWqzXYh")) != -1) {
#endif
		switch (opt) {

		case 'g':
			if (!actualparms->serial) actualparms->serial = aux_create_SerialNo(optarg);
			else usage(SHORT_HELP);
			break;
		case 'q':
			actualparms->onekeypair = FALSE;
			break;
#ifdef X500
		case 'n':
			name_from_pse = TRUE;
			break;
#endif
		case 'C':
			actualparms->newca = optarg;
#ifdef X500
			certtype = cACertificate;
#endif
			break;
		case 'z':
			MF_check = TRUE;
			break;
		case 'i':
			script = optarg;
			break;
		case 'a':
			oid = aux_Name2ObjId(optarg);
			if (aux_ObjId2AlgType(oid) != SIG)
				usage(SHORT_HELP);
			actualparms->issuer_alg = aux_ObjId2AlgId(oid);
			break;
		case 'T':
			pinfile_name = aux_cpy_String(optarg);
			break;
		case 's':
			oid = aux_Name2ObjId(optarg);
			if (aux_ObjId2AlgType(oid) != ASYM_ENC && aux_ObjId2AlgType(oid) != SIG)
				usage(SHORT_HELP);
			actualparms->algorithms[0] = aux_ObjId2AlgId(oid);
			kk = 0;
			break;
		case 'k':
			keysize = atoi(optarg);
			if ((keysize < MIN_ASYM_KEYSIZE) || (keysize > MAX_ASYM_KEYSIZE))
				usage(SHORT_HELP);
			actualparms->keysizes[kk] = keysize;
			break;
		case 'c':
			if (cadir)
				usage(SHORT_HELP);
			else
				cadir = optarg;
			break;
		case 'H':
			actualparms->HOME = optarg;
			break;
		case 'p':
			capse = optarg;
			break;
		case 'P':
			actualparms->userpse = optarg;
			break;
		case 'u':
			userunixname = optarg;
			break;
		case 'x':
			actualparms->nameprefix = optarg;
			break;
		case 'f':
			if (actualparms->notbefore)
				usage(SHORT_HELP);
			else
				actualparms->notbefore = txt2UTCTime(optarg, CNULL);
			break;
		case 'l':
			if (actualparms->notafter)
				usage(SHORT_HELP);
			else
				actualparms->notafter = txt2UTCTime(optarg, CNULL);
			break;
		case 'D':
			actualparms->enter = TRUE;
			break;
		case 'r':
			actualparms->replace = TRUE;
			break;
		case 'e':
			oid = aux_Name2ObjId(optarg);
			if (aux_ObjId2AlgType(oid) != ASYM_ENC)
				usage(SHORT_HELP);
			actualparms->algorithms[1] = aux_ObjId2AlgId(oid);
			kk = 1;
			break;
		case 'v':
			verbose = 1;
			sec_gen_verbose = TRUE;
			break;
		case 'V':
			verbose = 2;
			sec_gen_verbose = TRUE;
			continue;
		case 'W':
			verbose = 2;
			af_verbose = TRUE;
			sec_verbose = TRUE;
			continue;
		case 'X':
			random_from_pse = TRUE;
			break;
		case 'Y':
			sec_init_random_seed_from_keyboard();
			break;
		case 'h':
			usage(LONG_HELP);
#ifdef X500
		case 'd':
			af_dir_dsaname = aux_cpy_String(optarg);
			continue;
		case 't':
			af_dir_tailor = aux_cpy_String(optarg);
			continue;
#endif
		}
	}

	if (!script) {
		if (optind < cnt)
			namesuffix = parm[optind++];

		subject_Name = (char *) malloc(strlen(actualparms->nameprefix) + strlen(namesuffix) + 1);
		strcpy(subject_Name, actualparms->nameprefix);
		strcat(subject_Name, namesuffix);

		if (!strlen(subject_Name)) {	/* read CA directory name
						 * from stdin */
	again:
			sprintf(line, "    %s: Directory name of PSE owner: ", cmd);
			aux_fgets(line, line, sizeof(line), stderr, stdin);
			subject_Name = line;
			if (!(subject_DName = aux_alias2DName(subject_Name))) {

				subject_DName = aux_Name2DName(subject_Name);
				if (!subject_DName) {
					fprintf(stderr, "    %s: Invalid directory name\n", cmd);
					goto again;
				}
			}
		} 
		else {
			if (!(subject_DName = aux_alias2DName(subject_Name))) {
				subject_DName = aux_Name2DName(subject_Name);
				if (!subject_DName) {
					fprintf(stderr, "    %s: Invalid directory name\n", cmd);
				}
			}
		}

		if ((optind < cnt) || !subject_Name || !subject_DName) usage(SHORT_HELP);

		if (subject_Name) free(subject_Name);

		subject_Name = aux_DName2Name(subject_DName);	/* reconstruct
								 * subject_Name for
								 * uniqueness */

		if ((actualparms->notbefore && !actualparms->notafter) || (!actualparms->notbefore && actualparms->notafter))
			usage(SHORT_HELP);


	}
	if (!capse)
		capse = DEF_CAPSE;
	if (!cadir)
		cadir = DEF_CADIR;

#ifdef X500
	/* Determine whether X.500 directory shall be accessed */
	x500 = af_x500_check();
#endif
#ifdef AFDBFILE
	af_db = TRUE;
#endif

	capsepath = (char *) malloc(strlen(cadir) + strlen(capse) + 2);
	if (!capsepath) {
		fprintf(stderr, "%s: ", cmd);
		fprintf(stderr, "Can't allocate memory\n");
		aux_add_error(EMALLOC, "capsepath", CNULL, 0, proc);
		if (verbose)
			aux_fprint_error(stderr, verbose);
		exit(1);
	}
	strcpy(capsepath, cadir);
	strcat(capsepath, PATH_SEPARATION_STRING);
	strcat(capsepath, capse);

	actualparms->userpin = getenv("USERPIN");
	actualparms->capin = getenv("CAPIN");

	/*
	 *  Check whether the CA-PSE is located on the smartcard.
	 *  If the CA-PSE is an SW-PSE, the PIN is requested at tty.
	 *  Otherwise the smartcard is requested.
	 */
	capse_location = sec_psetest(capsepath);
#ifdef SCA
	if (capse_location == ERR_in_psetest) {
		if (aux_last_error() == EDEVLOCK) 
			fprintf(stderr, "Cannot open device for SCT (No such device or device busy).\n");
		else	fprintf(stderr, "Error during SC configuration.\n");
		aux_fprint_error(stderr, verbose);
		exit(-1);
	}
#endif
	if (capse_location == SWpse) {
		if (!actualparms->capin)
			actualparms->capin = sec_read_pin("PIN of CA", "", FALSE);
	}
	else {
		fprintf(stderr, "\n    Please insert Smartcard of CA: %s\n\n", capsepath);
	}


	strcpy(cahome, "HOME=");
	strcpy(cahomedir, getenv("HOME"));
	strcat(cahome, cahomedir);


/************************************* g e t n a m e *******************************************/

	proto_dn = aux_Name2DName(aux_cpy_String("cn=PROTO"));

	set_AF_pse(CA);

	if (!(issuer_dn = af_pse_get_Name())) {
		fprintf(stderr, "%s: Can't read Name from PSE %s\n", cmd, capsepath);
		if (verbose)
			aux_fprint_error(stderr, verbose);
		exit(1);
	}
	if(pinfile_name) {
		/* 
		 * if a PIN file is set then create a desECB key,
		 * encrypt it with the PK of the CA and store it in the key file
		 */
		int file;

		if(!(pinfile_encname = (char *)malloc(strlen(pinfile_name) + 8))) {
			aux_add_error(EINVALID, "unable to create Serial on PSE", CNULL, 0, proc);
			fprintf(stderr, "Can't allocate memory\n");
			if(verbose) aux_fprint_error(stderr, verbose);
			exit (-1);
		}
                strcpy(pinfile_encname, pinfile_name);
                aux_set_extension(pinfile_encname, EXT_ENCRYPTION_FILE);

		if((file = open(pinfile_encname, O_RDONLY)) > 0) {
			close(file);
			if(unlink(pinfile_encname) < 0) {
				fprintf(stderr, "Can't unlink old encrypted pin file: %s\n", pinfile_encname);
				exit (-1);
			}
		}

		if(!(pinfile_keyname = (char *)malloc(strlen(pinfile_name) + 8))) {
			aux_add_error(EINVALID, "unable to create Serial on PSE", CNULL, 0, proc);
			fprintf(stderr, "Can't allocate memory\n");
			if(verbose) aux_fprint_error(stderr, verbose);
			exit (-1);
		}

                strcpy(pinfile_keyname, pinfile_name);
                aux_set_extension(pinfile_keyname, EXT_ENCRYPTION_KEY);

		if(!(pinfile_cert = af_pse_get_Certificate(ENCRYPTION, NULLDNAME, 0))) {
			AUX_ADD_ERROR;
			fprintf(stderr, "Can't get Certificate\n");
			if(verbose) aux_fprint_error(stderr, verbose);
			exit (-1);
		}
                pinfile_rsakey.alg = rsaEncryption;
                pinfile_rsakey.keyref = 0;
                pinfile_rsakey.pse_sel = (PSESel *)0;
                pinfile_rsakey.key = pinfile_cert->tbs->subjectPK;

		pinfile_deskey.keyref = 0;
		pinfile_deskey.key = (KeyInfo *)malloc(sizeof(KeyInfo));
		pinfile_deskey.key->subjectAI = desECB;
		pinfile_deskey.alg = desECB;
		pinfile_deskey.pse_sel = (PSESel *)0;

		if(sec_gen_key(&pinfile_deskey, TRUE) < 0) {
			AUX_ADD_ERROR;
			fprintf(stderr, "Can't generate DES key for pin file\n");
			if(verbose) aux_fprint_error(stderr, verbose);
			exit (-1);
		}
		if(sec_get_EncryptedKey(&pinfile_encrypted_deskey, &pinfile_deskey, &pinfile_rsakey) < 0) {
			AUX_ADD_ERROR;
			fprintf(stderr, "Can't encrypt DES key for pin file\n");
			if(verbose) aux_fprint_error(stderr, verbose);
			exit (-1);
		}
		if(!(pinfile_encoded_encrypted_deskey = e_EncryptedKey(&pinfile_encrypted_deskey))) {
			AUX_ADD_ERROR;
			fprintf(stderr, "Can't encode encrypted key for pin file\n");
			if(verbose) aux_fprint_error(stderr, verbose);
			exit (-1);
		}
		if(aux_OctetString2file(pinfile_encoded_encrypted_deskey, pinfile_keyname, 2) < 0) {
			AUX_ADD_ERROR;
			fprintf(stderr, "Can't create or write encrypted pin file key\n");
			if(verbose) aux_fprint_error(stderr, verbose);
			exit (-1);
		}
		aux_free_Certificate(&pinfile_cert);
		aux_free_OctetString(&pinfile_encoded_encrypted_deskey);
		
	}
	issuer = aux_DName2Name(issuer_dn);
#ifdef X500
	directory_user_dname = issuer_dn;
#endif
	fprintf(stderr, "\nIssuing CA is <%s>\n", issuer);
	if(pinfile_name)
		fprintf(stderr, "Create encrypted PIN file <%s> with -E desECB\n", pinfile_name);

/************************************* scriptfile *********************************************/
	if (script) {
		rc_psecreate = 0;
		scr = fopen(script, "r");
		if (!scr) {
			fprintf(stderr, "Error: Scriptfile '%s' not found\n", script);
			exit(1);
		}
		c = getc(scr);
		while (c != EOF) {
			switch (c) {
			case ' ':
				nextnonblank();
				break;
			case ',':
				c = getc(scr);
				fprintf(stderr, "*** Warning in line %d: ',' unexpected\n", linenr);
				break;
			case '\t':
				nextnonblank();
				break;
			case '#':
				while ((c = getc(scr)) != EOF && c != '\n');
				break;
			case '$':
				c = getc(scr);
				scancmd();
				if (verbose && sec_debug > 2) {
					if (actualparms == &local)
						fprintf(stderr, "Local-");
					fprintf(stderr, "Command %s\n", scrword1);

					/*
					 * fprintf(stderr, " %s %s %d\n",
					 * scrword2, scrword3, linenr);
					 */
				}
				switch (cmdnumber(scrword1)) {
				case -1:
					fprintf(stderr, "*** Warning in line %d: Command '%s' not found\n", linenr, scrstr);
					break;
				case -2:
					fprintf(stderr, "*** Warning in line %d: Command '%s' ambiguous\n", linenr, scrstr);
					break;
				case NAMEPREFIX:
					replacestr(&actualparms->nameprefix, scrword2, CNULL);
					break;
				case ISSUER_ALG:
					oid = aux_Name2ObjId(scrword2);
					if (aux_ObjId2AlgType(oid) != SIG) {
						if (oid)
							fprintf(stderr, "*** Warning in line %d: Algoritm '%s' not allowed for issuer. I take 'md5WithRsa'\n", linenr, scrword2);
						else
							fprintf(stderr, "*** Warning in line %d: Algoritm '%s' not known. I take 'md5WithRsa'\n", linenr, scrword2);

						oid = aux_Name2ObjId("md5WithRsa");

					}
					actualparms->issuer_alg = aux_ObjId2AlgId(oid);
					break;
				case SUBJECT_PSE:
					replacestr(&actualparms->userpse, scrword2, CNULL);
					break;
				case TRANSPORTPIN:
					replacestr(&actualparms->userpin, scrword2, CNULL);
					break;
				case HOMEDIRS:
					if (!strlen(scrword2))
						actualparms->HOME = CNULL;
					else
						replacestr(&actualparms->HOME, scrword2, CNULL);
					break;
				case USER_PSE:
					actualparms->newca = CNULL;
					break;
				case USER_HOME:
					replacestr(&userhomedir, scrword2, CNULL);
					break;
#ifdef X500
				case DSA_NAME:
					if (!strlen(scrword2))
						actualparms->dsa = CNULL;
					else
						replacestr(&actualparms->dsa, scrword2, CNULL);
				case DSAP_TAILOR:
					if (!strlen(scrword2))
						actualparms->dsap_tailor = CNULL;
					else
						replacestr(&actualparms->dsap_tailor, scrword2, CNULL);
#endif
				case CA_PSE:
					if (strlen(scrword2))
						replacestr(&actualparms->newca, scrword2, CNULL);
					else
						replacestr(&actualparms->newca, DEF_CADIR, CNULL);
					if (!actualparms->serial) {
						if(strlen(scrword3)) actualparms->serial = aux_create_SerialNo(scrword3);
						else {
							actualparms->serial = aux_new_OctetString(1);
							actualparms->serial->octets[0] = 0x00;
						}
					}
#ifdef X500
					certtype = cACertificate;
#endif
					break;
				case ENTER:
					actualparms->enter = TRUE;
					break;
				case NOTENTER:
					actualparms->enter = FALSE;
					break;
				case ONE_KEY_PAIR:
					actualparms->onekeypair = TRUE;
					break;
				case TWO_KEY_PAIRS:
					actualparms->onekeypair = FALSE;
					break;
				case REPLACE_KEY:
					actualparms->replace = TRUE;
					break;
				case NOT_REPLACE_KEY:
					actualparms->replace = FALSE;
					break;
				case SW_PSE:
#ifdef SCA
/*					If this global flag would be set to TRUE,
					all Smartcard-PSEs would be ignored,
					even a CA-PSE on the card.  
					actualparms->SC_ignore = TRUE; 
*/
#endif
					break;
				case SC_PSE:
#ifdef SCA
					actualparms->SC_ignore = FALSE;
#endif
					break;
				case SUBJECT_ENCALG:
					oid = aux_Name2ObjId(scrword2);
					if (aux_ObjId2AlgType(oid) != ASYM_ENC) {
						if (oid)
							fprintf(stderr, "*** Warning in line %d: Algoritm '%s' not allowed for encryption-algorithm of subject. I take 'RSA'\n", linenr, scrword2);
						else
							fprintf(stderr, "*** Warning in line %d: Algoritm '%s' not known. I take 'RSA'\n", linenr, scrword2);

						oid = aux_Name2ObjId("RSA");

					}
					actualparms->algorithms[1] = aux_ObjId2AlgId(oid);
					if (strlen(scrword3)) {
						keysize = atoi(scrword3);
						if ((keysize < MIN_ASYM_KEYSIZE) || (keysize > MAX_ASYM_KEYSIZE)) {
							fprintf(stderr, "*** Warning in line %d: Keysize '%d' not allowed. I take '%d'\n", linenr, keysize, MAX_ASYM_KEYSIZE);
							keysize = MAX_ASYM_KEYSIZE;

						}
						actualparms->keysizes[1] = keysize;
					}
					break;
				case SUBJECT_SIGALG:
					oid = aux_Name2ObjId(scrword2);
					if (aux_ObjId2AlgType(oid) != ASYM_ENC && aux_ObjId2AlgType(oid) != SIG) {
						if (oid)
							fprintf(stderr, "*** Warning in line %d: Algoritm '%s' not allowed for signature-algorithm of subject. I take 'RSA'\n", linenr, scrword2);
						else
							fprintf(stderr, "*** Warning in line %d: Algoritm '%s' not known. I take 'RSA'\n", linenr, scrword2);

						oid = aux_Name2ObjId("RSA");

					}
					actualparms->algorithms[0] = aux_ObjId2AlgId(oid);
					if (strlen(scrword3)) {
						keysize = atoi(scrword3);
						if ((keysize < MIN_ASYM_KEYSIZE) || (keysize > MAX_ASYM_KEYSIZE)) {
							fprintf(stderr, "*** Warning in line %d: Keysize '%d' not allowed. I take '%d'\n", linenr, keysize, MAX_ASYM_KEYSIZE);
							keysize = MAX_ASYM_KEYSIZE;

						}
						actualparms->keysizes[0] = keysize;
					}
					break;
				case NOTBEFORE:
					actualparms->notbefore = txt2UTCTime(scrword2, CNULL);
					break;
				case NOTAFTER:
					actualparms->notafter = txt2UTCTime(scrword2, CNULL);
					break;
				case VALIDITY:
					actualparms->notafter = txt2UTCTime(scrword2, actualparms->notbefore);
					break;
				case CREATE:
					actualparms->create = TRUE;
					actualparms->pkroot = TRUE;
					actualparms->oldpkr = FALSE;
					actualparms->newpkr = FALSE;
					actualparms->fcpath = TRUE;
					actualparms->cert[0] = TRUE;
					actualparms->newkey[0] = TRUE;
					actualparms->cert[1] = TRUE;
					actualparms->newkey[1] = TRUE;
					break;
				case UPDATE:
					actualparms->create = FALSE;
					actualparms->pkroot = FALSE;
					actualparms->oldpkr = FALSE;
					actualparms->newpkr = FALSE;
					actualparms->fcpath = FALSE;
					actualparms->cert[0] = FALSE;
					actualparms->newkey[0] = FALSE;
					actualparms->cert[1] = FALSE;
					actualparms->newkey[1] = FALSE;
					for (p1 = scrword2; *p1 != '\0'; p1 = p2) {
						p2 = p1;
						while (*p2 != ' ' && *p2 != '\0') {
							p2++;
						}
						*(p2++) = '\0';
						while (*p2 == ' ')
							p2++;
						switch (parmnumber(p1)) {
						case -1:
							fprintf(stderr, "*** Warning in line %d: Parameter '%s' not found\n", linenr, p1);
							break;
						case -2:
							fprintf(stderr, "*** Warning in line %d: Parameter '%s' ambiguous\n", linenr, p1);
							break;
						case OLD_TO_PKLIST:
							actualparms->pkroot = TRUE;
							actualparms->oldpkr = TRUE;
							actualparms->fcpath = TRUE;
							break;
						case NEW_TO_PKLIST:
							actualparms->pkroot = TRUE;
							actualparms->newpkr = TRUE;
							actualparms->fcpath = TRUE;
							break;
						case PKROOT:
							actualparms->pkroot = TRUE;
							actualparms->fcpath = TRUE;
							break;
						case FCPATH:
							actualparms->fcpath = TRUE;
							break;
						case SIGN_CERT:
							actualparms->cert[0] = TRUE;
							keyno = 0;
							break;
						case ENCR_CERT:
							actualparms->cert[1] = TRUE;
							if (actualparms->onekeypair)
								actualparms->cert[0] = TRUE;
							keyno = 1;
							break;
						case NEW_KEY:
							if (keyno >= 0) {
								actualparms->newkey[keyno] = TRUE;
								if (actualparms->onekeypair) 
									actualparms->newkey[0] = TRUE;
							} else
								fprintf(stderr, "*** Warning in line %d: Paramter '%s' is only allowed after '%s' or '%s'.\n", linenr, update_parm[NEW_KEY], update_parm[ENCR_CERT], update_parm[SIGN_CERT]);
							break;
						}

					}
					break;
				}
				nextnonblank();
				while (actualparms == &global &&c != '$' && c != '#' && c != '\n' && c != EOF) {
					readword(scrstr);
					fprintf(stderr, "*** Warning in line %d : parameter '%s' ignored.\n", linenr, scrstr);
				}
				break;
			case '\n':

				if (actualparms == &global) {
					linenr++;
					c = getc(scr);
					break;
				}
				if (parmno != PARMMAX) {
					fprintf(stderr, "*** Error in line %d : %d parameters instead of %d. Cannot create PSE.\n", linenr, parmno, PARMMAX);
					parmno = UNIXNAME;
					actualparms = &global;

					break;
				}
				parmno = UNIXNAME;
				replacestr(&subject_Name, actualparms->nameprefix, namesuffix);
				if (subject_DName)
					aux_free_DName(&subject_DName);
				subject_DName = aux_alias2DName(subject_Name);

				if (!subject_DName) {
					subject_DName = aux_Name2DName(subject_Name);
				}
	
				if (!subject_DName) {
					fprintf(stderr, "*** Error in line %d: Name '%s' is a wrong format. Cannot create PSE.\n", linenr, subject_Name);
					actualparms = &global;

					break;
				}
/*
					if(subject_Name) free(subject_Name);
					subject_Name = aux_DName2Name(subject_DName);
*/

				if (!actualparms->notbefore)
					actualparms->notbefore = aux_current_UTCTime();
				if (!actualparms->notafter)
					actualparms->notafter = aux_delta_UTCTime(actualparms->notbefore, 0);


#ifdef X500
				if(af_dir_dsaname) free(af_dir_dsaname);
				if(actualparms->dsa) af_dir_dsaname = aux_cpy_String(actualparms->dsa);

				if(af_dir_tailor) free(af_dir_tailor);
				if(actualparms->dsap_tailor) af_dir_tailor = aux_cpy_String(actualparms->dsap_tailor);
#endif

#ifdef SCA
				if (actualparms->SC_ignore)
					SC_ignore = TRUE;
				else
					SC_ignore = FALSE;
#endif
				if (actualparms->create)
					repl = "Creating";
				else
					repl = "Updating";


				strcpy(username, "USER=");
				if (userunixname)
					strcat(username, userunixname);
				else
					strcat(username, getenv("USER"));
				putenv(username);
				pwentry = getpwnam(userunixname);
				if (pwentry)
					userunixuid = pwentry->pw_uid;
				else
					fprintf(stderr, "\n\n\nWarning: user %s does not exist\n", userunixname);

				sma = "";
				sc = FALSE;
#ifdef SCA
				set_AF_pse(USER);

				pse_location = sec_psetest(actualparms->userpse);
				if(pse_location == ERR_in_psetest) {
					if (aux_last_error() == EDEVLOCK) 
						fprintf(stderr, "Cannot open device for SCT (No such device or device busy).\n");
					else	fprintf(stderr, "Error during SC configuration.\n");
					aux_fprint_error(stderr, verbose);
					exit(-1);
				}

				if (pse_location == SCpse) {
					sma = " Smartcard";
					sc = TRUE;
				}
				set_AF_pse(CA);
#endif

				if(!sc)
				if (make_genpsedir() < 0) {
					if (actualparms->create)
						repl = "Created";
					else
						repl = "Updated";
					fprintf(stderr, "    PSE not %s for %s\n", repl, userunixname);
					actualparms = &global;

					userhomedir = CNULL;
					break;
				}

				if (actualparms->newca)
					fprintf(stderr, "\n\n\n%2d. %s CA <%s> (Unix-Uid %s)\n", ++psenumber, repl, subject_Name, userunixname);
				else
					fprintf(stderr, "\n\n\n%2d. %s%s PSE for %s <%s>\n", ++psenumber, repl, sma, userunixname, subject_Name);


				if (!actualparms->create) {
					if (!actualparms->HOME && !sc) {


#ifdef MS_DOS
						if(rename(userfiledir, userappldir) < 0) 
							fprintf(stderr, "Can't rename %s to %s%s", userfiledir, userappldir, NEWLINE);
#else
						strcpy(syscmd, "cd ");
						strcat(syscmd, genpsedir);
						strcat(syscmd, ";");
						strcat(syscmd, "decode -r < ");
						strcat(syscmd, userunixname);
						strcat(syscmd, " | uncompress | tar xf - ");
						system(syscmd);
#endif
					}
				}
				if (chk_pse_dir() < 0) {
					if (actualparms->create)
						repl = "Created";
					else
						repl = "Updated";
					fprintf(stderr, "    PSE not %s for %s\n", repl, userunixname);
					actualparms = &global;

					userhomedir = CNULL;
					break;
				}
				if(actualparms->onekeypair == TRUE) fprintf(stderr, "    - with one keypair for both authentication and confidentiality purposes\n");
				else fprintf(stderr, "    - with two keypairs, one for authentication and one for confidentiality purposes\n");
				if (actualparms->newca)
					fprintf(stderr, "    - CA directory is %s, application name (PSE name) is %s\n", actualparms->newca, actualparms->userpse);
				else
					fprintf(stderr, "    - application name (PSE name) is %s\n", actualparms->userpse);

				nb = aux_readable_UTCTime(actualparms->notbefore);
				na = aux_readable_UTCTime(actualparms->notafter);
				fprintf(stderr, "    - Certificate validity is from %s", nb);
				fprintf(stderr, " to %s\n", na);
				if (nb)
					free(nb);
				if (na)
					free(na);
				if(actualparms->issuer_alg) fprintf(stderr, "    - Certificates are signed using algorithm %s\n", aux_ObjId2Name(actualparms->issuer_alg->objid));
				else fprintf(stderr, "    - Certificates are signed using default signature algorithm\n");
				fprintf(stderr, "    - Subject's default signature algorithm is %s, keysize %d\n", aux_ObjId2Name(actualparms->algorithms[0]->objid), actualparms->keysizes[0]);
				fprintf(stderr, "    - Subject's default encryption algorithm %s, keysize %d\n", aux_ObjId2Name(actualparms->algorithms[1]->objid), actualparms->keysizes[1]);
				if (actualparms->enter && x500)
					fprintf(stderr, "    - The certificates will be entered into the X.500 directory\n");
				if (actualparms->enter && af_db)
					fprintf(stderr, "    - The certificates will be entered into the AF-DB directory\n");

				pse_location = sec_psetest(actualparms->userpse);
#ifdef SCA
				if (pse_location == ERR_in_psetest) {
					if (aux_last_error() == EDEVLOCK) 
						fprintf(stderr, "Cannot open device for SCT (No such device or device busy).\n");
					else	fprintf(stderr, "Error during SC configuration.\n");
					aux_fprint_error(stderr, verbose);
					exit(-1);
				}
#endif
				if (pse_location == SWpse) {
					if(pinfile_name && actualparms->create) {
						/* 
						 * If a new PSE is created and a pin file is given
						 * the PIN is create randomly and written
						 * with the DName to then pin file (encrypted)
						 */
						actualparms->userpin = create_random_pin();
						if(!actualparms->userpin || create_pinfile_entry() < 0) {
							AUX_ADD_ERROR;
							fprintf(stderr, "Can't add PIN to pinfile\n");
							if(verbose) aux_fprint_error(stderr, verbose);
						}

					} else {

						if (!actualparms->userpin)
							actualparms->userpin = global.userpin = sec_read_pin("Transport PIN for user-PSE's", "", TRUE);
					}
				}
				rc_psecreate = psecreate(cmd);
				if (rc_psecreate == 0) {
					if (!actualparms->HOME && !sc) {

						/*
						 * If HOME is Null and user PSE is not an SC, create a
						 * compressed tar file of the
						 * PSE and store it in
						 * <genpsedir>/<userunixname>,
						 * and remove the temporary
						 * <genpsedir>/<userhomedir>
						 */

#ifdef MS_DOS
						if(rename(userappldir, userfiledir) < 0) 
							fprintf(stderr, "Can't rename %s to %s%s", userappldir, userfiledir, NEWLINE);
#else
						strcpy(syscmd, "cd ");
						strcat(syscmd, genpsedir);
						strcat(syscmd, ";");
						strcat(syscmd, "tar cf - ");
						strcat(syscmd, userappldir_rel);
						strcat(syscmd, " | compress | encode -r >");
						strcat(syscmd, userunixname);
						strcat(syscmd, ";");
						strcat(syscmd, "rm -r -f ");
						strcat(syscmd, userappldir);
						system(syscmd);
#endif
					}

					set_AF_pse(CA);

					if (userunixname)
						if (aux_add_alias_name(	userunixname,
									subject_Name,
									systemalias,
									TRUE,
									TRUE) < 0) {
									
						fprintf(stderr, "Can't add system alias %s for %s\n",
								userunixname, subject_Name);
						if(verbose) aux_fprint_error(stderr, verbose);
					}
					if (useraddress)
						if (aux_add_alias_name(	useraddress,
									subject_Name,
									systemalias,
									TRUE,
									TRUE) < 0) {
									
						fprintf(stderr, "Can't add system alias %s for %s\n",
								useraddress, subject_Name);
						if(verbose) aux_fprint_error(stderr, verbose);
					}
					fprintf(stderr, "    PSE generation finished\n");
					if(sc) 	fprintf(stderr, "    Remove Smardcard from Smardcard-Terminal\n");

					else if (!actualparms->HOME)
						fprintf(stderr, "    Generated PSE is compressed tar file %s/%s\n", genpsedir, userunixname);
					else
						fprintf(stderr, "    Generated PSE is directory %s/%s\n", genpsedir, actualparms->userpse);
					fprintf(stderr, "    Alias names %s and %s with\n    target name <%s> generated\n", userunixname, useraddress, subject_Name);
				} else {
					fprintf(stderr, "\n    PSE generation failed for %s\n", userunixname);
					
					if (!actualparms->HOME && !sc && !actualparms->newca) {
#ifdef MS_DOS
						strcpy(syscmd, "deltree /Y ");
#else
						strcpy(syscmd, "rm -f -r ");
#endif
						strcat(syscmd, genpsedir);
						strcat(syscmd, PATH_SEPARATION_STRING);
						strcat(syscmd, actualparms->userpse);
						system(syscmd);
					}
				}
#ifdef SCA
				if (pse_location == SCpse) {
					/* eject user card */
					set_AF_pse(USER); 
					sec_sc_eject(CURRENT_SCT);
					/* switch to CA-PSE */
					set_AF_pse(CA); 
				}
#endif
				userhomedir = CNULL;
				aux_free_error();
				actualparms = &global;

				c = getc(scr);
				break;
			default:
				if (!parmno) {
					local.userpse = global.userpse;

					if (!local.userpse)
						local.userpse = (actualparms->newca) ? DEF_CAPSE : DEF_PSE;
					if (!global.serial) {
						global.serial = aux_new_OctetString(1);
						global.serial->octets[0] = 0x00;
					}
					local.serial = aux_cpy_OctetString(global.serial);
					local.nameprefix = global.nameprefix;
					local.notbefore = global.notbefore;
					local.notafter = global.notafter;

					if (global.userpin)
						local.userpin = aux_cpy_String(global.userpin);
					else
						local.userpin = CNULL;
					local.capin = aux_cpy_String(global.capin);
#ifdef X500
					local.dsa = aux_cpy_String(global.dsa);
					local.dsap_tailor = aux_cpy_String(global.dsap_tailor);
#endif
					local.HOME = global.HOME;
					local.issuer_alg = global.issuer_alg;
					local.algorithms[0] = global.algorithms[0];
					local.algorithms[1] = global.algorithms[1];
					local.keysizes[0] = global.keysizes[0];
					local.keysizes[1] = global.keysizes[1];
					local.enter = global.enter;
					local.SC_ignore = global.SC_ignore;
					local.newca = global.newca;
					local.replace = global.replace;
					local.create = global.create;
					local.pkroot = global.pkroot;
					local.oldpkr = global.oldpkr;
					local.fcpath = global.fcpath;
					local.cert[0] = global.cert[0];
					local.cert[1] = global.cert[1];
					local.newkey[0] = global.newkey[0];
					local.newkey[1] = global.newkey[1];
					local.onekeypair = global.onekeypair;

#ifdef X500
					local.vecptr2 = global.vecptr2;

#endif
					actualparms = &local;
				}
				readword(scrstr);

				switch (parmno++) {
				case UNIXNAME:
					replacestr(&userunixname, scrstr, CNULL);
					break;
				case ADDRESS:
					replacestr(&useraddress, scrstr, CNULL);
					break;
				case SUFFIX:
					replacestr(&namesuffix, scrstr, CNULL);
					break;
				}

				break;
			}

		}
		fclose(scr);
	} 
	else {		/* no script file */

		pse_location = sec_psetest(actualparms->userpse);
#ifdef SCA
		if (pse_location == ERR_in_psetest) {
			if (aux_last_error() == EDEVLOCK) 
				fprintf(stderr, "Cannot open device for SCT (No such device or device busy)\n");
			else	fprintf(stderr, "Error during SC configuration.\n");
			aux_fprint_error(stderr, verbose);
			exit(-1);
		}
#endif

		if (pse_location == SWpse) {
			if (!actualparms->userpin)
				actualparms->userpin = global.userpin = sec_read_pin("PIN for user-PSE's", "", TRUE);
		}
		if (make_genpsedir() == 0) rc_psecreate = psecreate(cmd);
	}



	set_AF_pse(CA);


	exit(rc_psecreate);
}

/***************************************************************
 *
 * Procedure handle_afdb_directory
 *
 * Creates afdb-directory for "etc/.af-db/C=DE/O=GMD/L=DARMSTADT/CN=......"
 * 
 ***************************************************************/
#ifdef __STDC__

static RC handle_afdb_directory(
	Certificate  *subject_Certificate
)

#else

static RC handle_afdb_directory(
	subject_Certificate
)
Certificate  *subject_Certificate;

#endif

{
#define DIRMASK 0775		/* directory creation mask */
	char *afdbname, *zwname, *zwname_malloc, zwname_part[512];
	int len, zwname_pos;
	DName	 *dname;

	char           		*proc = "handle_afdb_directory";


	dname = subject_Certificate->tbs->subject;
	zwname = zwname_malloc = aux_DName2CAPITALString(dname, PATH_SEPARATION_STRING);
	if(!zwname) {
		aux_add_error(EINVALID, "Can't build AF-DB name from dname", CNULL, 0, proc);
		return(-1);
	}
	if(!(afdbname = malloc(1024))) {
		aux_add_error(EMALLOC, "Can't malloc afdbname", CNULL, 0, proc);
		return(-1);
	}
	strcpy(afdbname, AFDBFILE); 

	if(afdbname[strlen(afdbname) - 1] == PATH_SEPARATION_CHAR)
		afdbname[strlen(afdbname) - 1] = '\0';

	if(*zwname == PATH_SEPARATION_CHAR) zwname++;
	while(*zwname != '\0') {

		zwname_pos = 0;
		while(zwname[zwname_pos] != '\0' &&
		      zwname[zwname_pos] != PATH_SEPARATION_CHAR) 
			zwname_pos++;

		strncpy(zwname_part, zwname, zwname_pos);
		zwname_part[zwname_pos] = '\0';

		if(!zwname_pos) {
			return(-1);
		}

		strcat(afdbname, PATH_SEPARATION_STRING);
		strcat(afdbname, zwname_part);

		/*
		 *    directory dir/rdname exists ?
		 */
		if(aux_file_type(afdbname) != F_DIRECTORY) { 

			if (mkdir(afdbname, DIRMASK) < 0) {
				if (errno != EEXIST) {
					aux_add_error(ESYSTEM, "mkdir failed for", (char *) afdbname, char_n, proc);
					if (afdbname) free(afdbname);
					return (-1);
				}
			}
			else
				chmod(afdbname, DIRMASK);
		} 
		zwname += zwname_pos;
		if(*zwname == PATH_SEPARATION_CHAR) zwname++;
	}

	free(zwname_malloc);

	if (afdbname) free(afdbname);

	return(0);
}




/***************************************************************
 *
 * Procedure create_pinfile_entry
 *
 * Creates the text 
 * C=DE, O=Gesellschaft fuer Mathematik und Datenverarbeitung, L=Darmstadt, CN=Thomas Surkau
 * 	PIN
 *
 * which is padded with some TABs to complete the last 8 byte block
 * This text is encrpyted with desECB and appended to pinfile.enc
 * 
 ***************************************************************/

static int create_pinfile_entry()
{
	static char 	 plain_pinfile_entry[2048];
	static char 	 encr_pinfile_entry[2048];
	int		 size, enc_size;
	OctetString	 in_octets;
	BitString	 out_bits;
	char		*proc = "create_pinfile_entry";
	int		 file;

	strcpy(plain_pinfile_entry, subject_Name);
	strcat(plain_pinfile_entry, "\n\t");
	strcat(plain_pinfile_entry, actualparms->userpin);

	strcat(plain_pinfile_entry, "\n");

	size = strlen(plain_pinfile_entry);
	while((size % 8) != 7) plain_pinfile_entry[size++] = '\t';
	plain_pinfile_entry[size++] = '\n';


	in_octets.octets = plain_pinfile_entry;
	in_octets.noctets = size;
	out_bits.bits = encr_pinfile_entry;
	out_bits.nbits = 0;

	if((enc_size = sec_encrypt(&in_octets, &out_bits, SEC_END, &pinfile_deskey)) < 0) {
		AUX_ADD_ERROR;
		return(-1);
	}

        if((file = open(pinfile_encname, O_WRONLY|O_CREAT|O_APPEND, 0644)) <= 0) {
		aux_add_error(ESYSTEM, "Can't open pin file", CNULL, 0, proc);
		return(-1);
	}
	if(write(file, encr_pinfile_entry, enc_size / 8) <= 0) {
		aux_add_error(ESYSTEM, "Can't write pin to pin file", CNULL, 0, proc);
		return(-1);
	}
	close(file);

}
/***************************************************************
 *
 * Procedure create_random_pin
 *
 * returns a PIN of 8 characters (0..9,a..z,A..Z) in static memory
 *
 ***************************************************************/

static char *create_random_pin()
{
	static char   		 pin[9];
	static unsigned int   	 rand_val;
	int           		 n;
	char			*proc = "create_random_pin";

	pin[8] = '\0';

	for(n = 0; n < 8; n++ ) {

		if(sec_random_unsigned(&rand_val) < 0) {
			AUX_ADD_ERROR;
			return(CNULL);
		}
		/* 
		 * using 0..9,a..z,A..Z
		 */
		rand_val %= 62;

		if(rand_val < 10) pin[n] = '0' + rand_val;
		else if(rand_val < 36) pin[n] = 'a' + (rand_val - 10);
		else pin[n] = 'A' + (rand_val - 36);
	}
	return(pin);
}
/***************************************************************
 *
 * Procedure txt2UTCTime
 *
 ***************************************************************/
#ifdef __STDC__

static UTCTime *txt2UTCTime(
	char	 *txt,
	UTCTime	 *oldtime
)

#else

static UTCTime *txt2UTCTime(
	txt,
	oldtime
)
char	 *txt;
UTCTime	 *oldtime;

#endif

{
	char           *dd, *cc;
	int             i;
	UTCTime        *newtime;
	T_REC           trec;

	trec.zone = -aux_get_timezone();
	trec.year = 0;
	trec.mon = 0;
	trec.day = 0;
	trec.hour = 0;
	trec.minu = 0;
	trec.sec = 0;

	dd = txt;
	i = 0;
	while ((cc = strchr(dd, ':'))) {
		i++;
		*cc = '\0';
		switch (i) {
		case 1:
			trec.year = atoi(dd);
			break;
		case 2:
			trec.mon = atoi(dd);
			break;
		case 3:
			trec.day = atoi(dd);
			break;
		case 4:
			trec.hour = atoi(dd);
			break;
		case 5:
			trec.minu = atoi(dd);
			break;
		case 6:
			trec.sec = atoi(dd);
			break;
		case 7:
			trec.zone = atoi(dd);
			break;
		}
		dd = cc + 1;
	}
	if(trec.zone < 60 && trec.zone > -60) trec.zone *= 60;
	if (i)
		if (oldtime) 
			newtime = aux_delta_UTCTime_T_REC(oldtime, &trec);
		else
			newtime = aux_T_REC2UTCTime(&trec);

	else
		replacestr(&newtime, txt, CNULL);
	return (newtime);
}

/***************************************************************
 *
 * Procedure readtimeformat
 *
 ***************************************************************/
#ifdef __STDC__

static void readtimeformat(
	char	 *s,
	int	 *i
)

#else

static void readtimeformat(
	s,
	i
)
char	 *s;
int	 *i;

#endif

{
	int             n, m = 0;

	for (n = 0; n < (int)strlen(s); n++) {
		if (s[n] <= '9' && s[n] >= '0')
			m = 10 * m + s[n] - '0';
		else if (n && s[n - 1] <= '9' && s[n - 1] >= '0') {
			*(i--) = m;
			m = 0;
		}
	}
	if (n && s[n - 1] <= '9' && s[n - 1] >= '0')
		*i = m;

}

/***************************************************************
 *
 * Procedure readword
 *
 ***************************************************************/
#ifdef __STDC__

static int readword(
	char	 *str
)

#else

static int readword(
	str
)
char	 *str;

#endif

{
	int             n = 0, text = 0;

	nextnonblank();
	while (c != EOF && n < 255) {
		if (c == '"') {
			NEXTC(-1);
			text = 1 - text;
		} else {
			if (c == 13) NEXTC(-1);
			if (c == '\t')
				c = ' ';
			if (!text && (c == ' ' || c == '=' || c == ',' || c == '$' || c == '#' || c == '\n'))
				break;
			if (c == '\n')
				linenr++;
			else
				str[n++] = c;
			NEXTC(-1);
		}
	}
	str[n] = '\0';
	if (n >= 254) {
		fprintf(stderr, "*** Fatal error: Word to long in line %d ( %s )\n", linenr, str);
		exit(-1);
	}
	for (--n; n >= 0 && str[n] == ' '; n--)
		str[n] = '\0';

	return (strlen(str));
}
static void scancmd()
{
	int             n = 0, m, l;

	if (!readword(scrword1)) {
		scrword2[0] = '\0';
		return;
	}
	nextnonblank();
	if (c == '=') {
		NEXTC;
		if (!readword(scrword2)) {
			scrword3[0] = '\0';
			return;
		}
		nextnonblank();
		if (c == ',') {
			NEXTC;
			readword(scrword3);
		} else
			scrword3[0] = '\0';
	} else
		scrword2[0] = '\0';
}
static void nextnonblank()
{
	while (c == ' ' || c == '\t') {
		NEXTC;
	}
}
/***************************************************************
 *
 * Procedure replacestr
 *
 ***************************************************************/
#ifdef __STDC__

static void replacestr(
	char	**a,
	char	 *b,
	char	 *bb
)

#else

static void replacestr(
	a,
	b,
	bb
)
char	**a;
char	 *b;
char	 *bb;

#endif

{ 	if (bb && *bb) {
		*a = malloc(strlen(b) + strlen(bb) + 1);
		strcpy(*a, b);
		strcat(*a, bb);
	} else {
		*a = malloc(strlen(b) + 1);
		strcpy(*a, b);
	}

}
/***************************************************************
 *
 * Procedure cmdnumber
 *
 ***************************************************************/
#ifdef __STDC__

static int cmdnumber(
	char	 *a
)

#else

static int cmdnumber(
	a
)
char	 *a;

#endif

{
	int             n, cmd, anz = 0, m = strlen(a);

	for (n = 0; script_cmds[n]; n++) {
		if (!strncmp(script_cmds[n], a, m)) {
			if (m == strlen(script_cmds[n]))
				return (n);
			cmd = n;
			anz++;
		}
	}
	if (anz == 1)
		return (cmd);	/* 1 match found */
	if (anz > 1)
		return (-2);	/* cmd not uniquely abbr */
	return (-1);
}
/***************************************************************
 *
 * Procedure parmnumber
 *
 ***************************************************************/
#ifdef __STDC__

static int parmnumber(
	char	 *a
)

#else

static int parmnumber(
	a
)
char	 *a;

#endif

{
	int             n, cmd, anz = 0, m = strlen(a);

	for (n = 0; update_parm[n]; n++) {
		if (!strncmp(update_parm[n], a, m)) {
			if (m == strlen(update_parm[n]))
				return (n);
			cmd = n;
			anz++;
		}
	}
	if (anz == 1)
		return (cmd);	/* 1 match found */
	if (anz > 1)
		return (-2);	/* cmd not uniquely abbr */
	return (-1);
}

static RC make_genpsedir()
{
	char            userpsepath[256], userpsebak[256];
	int             i;

/*
 *  This routine creates the pathname of the directory where the user PSE
 *  is to be installed. This pathname is stored in genpsedir.
 *  genpsedir is either
 *  - the home directory of the user <userunixname> or <userhomedir>. This
 *    happens to be if HOME (option -h) is set and is the directory where
 *    the home directories are located (e.g. /home). It is assumed that the home
 *    directory of the user is the subdirectory of HOME with the name
 *    <userunixname>. If this is not the case, the name of the home directory
 *    can be set using $userhome in the scriptfile. This parameter sets
 *    usehomedir to the name of the home directory. If userhomedir is nonzero,
 *    it is taken as the name of the home directory instead of userunixname.
 *  - or the directory genpse in the CA directory. This happens to be if
 *    HOME is NULL (i.e. option -h is not used).
 *
 *  make_genpsedir returns 0 if all of the following conditions are true:
 *
 *  - <genpsedir> exists and is a directory if HOME is set, or <genpsedir>
 *    does not exist and HOME is not set (genpsedir is created in this case).
 *  - <genpsedir>/<userhomedir> does not exist and mode is create, or it exists and is a directory
 *    and (replace is TRUE or HOME is Null or mode is update).
 *
 *  In all other cases it returns -1
 */

	strcpy(userhome, "HOME=");
	if (actualparms->HOME) {
		if(!(genpsedir = aux_cat_paths(actualparms->HOME, userhomedir ? userhomedir : userunixname))) {
			AUX_ADD_ERROR;
			return(-1);
		}
	} else {
		if(!(cadir_abs = aux_cat_paths(cahomedir, cadir))) {
			AUX_ADD_ERROR;
			return(-1);
		}
		if(!(genpsedir = aux_cat_paths(cadir_abs, GENPSE_DIR))) {
			AUX_ADD_ERROR;
			return(-1);
		}
		free(cadir_abs);

	}
	strcat(userhome, genpsedir);

	if (stat(genpsedir, &buf) < 0) {
		if (!actualparms->HOME) {
			if (mkdir(genpsedir, 7 * 64) < 0) {
				fprintf(stderr, "    Can't create %s\n", genpsedir);
				return (-1);
			}
		} else {
			fprintf(stderr, "    Can't find the subject's home directory %s\n", genpsedir);
			return (-1);
		}
	} else {
		if (!(buf.st_mode & S_IFDIR)) {
			fprintf(stderr, "    File %s exists\n", genpsedir);
			return (-1);
		}
	}
	strcpy(userfiledir, genpsedir);
	strcat(userfiledir, PATH_SEPARATION_STRING);

	if (actualparms->HOME) {
		if (actualparms->newca)
			strcat(userfiledir, actualparms->newca);
		else
			strcat(userfiledir, actualparms->userpse);
	} else {
		strcat(userfiledir, userunixname);
	}

	strcpy(userpsedir, genpsedir);
	strcat(userpsedir, PATH_SEPARATION_STRING);
	strcpy(userappldir, genpsedir);
	strcat(userappldir, PATH_SEPARATION_STRING);

	if (actualparms->newca) {
		strcat(userhome, PATH_SEPARATION_STRING);
		strcat(userhome, actualparms->newca);

		strcat(userpsedir, actualparms->newca);
		strcat(userpsedir, PATH_SEPARATION_STRING);
		strcat(userappldir, actualparms->newca);
	} else
		strcat(userappldir, actualparms->userpse);

	strcat(userpsedir, actualparms->userpse);

	userappldir_rel = userappldir + strlen(genpsedir) + 1;

	if (stat(userfiledir, &buf) == 0) {
		if (!(buf.st_mode & S_IFDIR) == !actualparms->HOME) {

			/*
			 * remove existing directory if actualparms->replace
			 * == TRUE and mode is create.
			 */
			if (actualparms->create)
				if (actualparms->replace) {
					strcpy(userfilebakdir, userfiledir);
					strcat(userfilebakdir, EXT_BACKUP);
					i = rename(userfiledir, userfilebakdir);
#ifdef MS_DOS
					if (i < 0) {
						strcpy(syscmd, "deltree /Y ");
#else
					if (i < 0) {
						strcpy(syscmd, "rm -r -f ");
#endif
						strcat(syscmd, userfilebakdir);
						system(syscmd);
						i = rename(userfiledir, userfilebakdir);
						fprintf(stderr, "    Directory %s deleted%s", userfilebakdir, NEWLINE);
					}
					if (i < 0) {
						perror("rename failed");
						fprintf(stderr, "    Directory %s exists already. Move to %s failed\n", userfiledir, userfilebakdir);
						return (-1);
					}
				} else {
					fprintf(stderr, "    Directory or file %s exists already. Use $replace to overwrite.\n", userfiledir);
					return (-1);
				}
		} else {

			/*
			 * file with name userfiledir exists, but is must be
			 * a directory. or directory with name userfiledir
			 * exists, but is must be  a file. This is an error
			 * in any case
			 */
			if (actualparms->HOME)
				fprintf(stderr, "    A file %s exists\n", userfiledir);
			else
				fprintf(stderr, "    A directory %s exists\n", userfiledir);
			return (-1);
		}


	} else if (!actualparms->create) {
		fprintf(stderr, "    Can't find directory %s for updating.\n", userfiledir);
		return (-1);
	}
	if (!actualparms->HOME) {
		if (stat(userappldir, &buf) == 0) {
			if (buf.st_mode & S_IFDIR) {
#ifdef MS_DOS
				strcpy(syscmd, "deltree /Y ");
#else
				strcpy(syscmd, "rm -r -f ");
#endif
				strcat(syscmd, userappldir);
				system(syscmd);
			} else {
				fprintf(stderr, "    File %s exists. Can`t create application directory.\n", userappldir);
				return (-1);


			}
		}
	}
	return (0);
}


static RC chk_pse_dir()
{
	char            userpsepath[256];

	if (actualparms->newca)
		if (!actualparms->create) {
			if (stat(userappldir, &buf) == 0) {
				if (!(buf.st_mode & S_IFDIR)) {
					fprintf(stderr, "    %s is no directory.\n", userappldir);
					return (-1);


				}
			} else {
				fprintf(stderr, "    Application %s does not exists. Can`t update.\n", userappldir);
				return (-1);

			}
		}
	if (!actualparms->create) {
		if (stat(userpsedir, &buf) == 0) {
			if (!(buf.st_mode & S_IFDIR)) {
				fprintf(stderr, "    %s is no directory.\n", userpsedir);
				return (-1);


			}
		} else {
			fprintf(stderr, "    Application %s does not exists. Can`t update.\n", userpsedir);
			return (-1);

		}
	}
	return (0);
}

/***************************************************************
 *
 * Procedure psecreate
 *
 ***************************************************************/
#ifdef __STDC__

static RC psecreate(
	char	 *cmd
)

#else

static RC psecreate(
	cmd
)
char	 *cmd;

#endif

{
	char           *proc = "psecreate (ca_gen_pse)";
	int             kx = 0;
	PSEToc         *sctoc = (PSEToc *) 0;
	PSEToc         *psetoc = (PSEToc *) 0;
	Certificate    *protocert;
	RC              ret;
	PSESel         *pse_sel;
	PSELocation     pse_location;
	Boolean		onekeypaironly;
	char		*app_text;
	Validity	validity;
	Certificate    *new_cert;




	set_AF_pse(USER);
	psesel.app_name = actualparms->userpse;
	psesel.pin = aux_cpy_String(actualparms->userpin);
	psesel.object.name = CNULL;
	psesel.object.pin = CNULL;


	if((pse_location = sec_psetest(actualparms->userpse)) == ERR_in_psetest) {
		if (aux_last_error() == EDEVLOCK) 
			fprintf(stderr, "Cannot open device for SCT (No such device or device busy)\n");
		else	fprintf(stderr, "Error during SC configuration.\n");
		aux_fprint_error(stderr, verbose);
		return(-1);
	}

	if (pse_location == SCpse) {
		name = aux_DName2Attr(subject_DName, "CN");
		fprintf(stderr, "    Please insert Smartcard of %s\n\n", name);
		if (name)
			free(name);
		app_text = "SC-PSE";
	}
	else 
		app_text = "PSE";


	if (actualparms->create) {

		psetoc = sec_read_toc(&psesel);

		if (psetoc && actualparms->replace == FALSE) {

			/* 
			 *  PSE exists already, replace flag not set 
			 */

			if (pse_location == SCpse) 
				fprintf(stderr, "\n    %s: Inserted smartcard is not virgin  ... try replace option\n\n", cmd);
			else    fprintf(stderr, "\n    %s: PSE exists already ... try replace option\n\n", cmd);
			if (verbose)
				aux_fprint_error(stderr, verbose);
			return (-1);
		}

		if (!psetoc && (actualparms->replace == TRUE) && (pse_location == SCpse)) {

			/* 
			 *  SC-PSE doesn't exist, replace flag set 
			 */
			/*
			 *  In case of an SW-PSE:
			 *     If replace flag is set, an existing directory has already been removed.
			 */

			fprintf(stderr, "\n    %s: Inserted smartcard is virgin  ... don't use replace option\n\n", cmd);
			if (verbose)
				aux_fprint_error(stderr, verbose);
			return (-1);
		}

		if (pse_location == SCpse)
			strzfree(&psesel.pin);


		/*
		 *  Set global flag "sec_onekeypair" used in function "sec_create"
		 */

		sec_onekeypair = actualparms->onekeypair;

#ifdef SCA
		/*
		 *  If not yet done a PSE frame is installed on the SC.
		 */

		if ((pse_location == SCpse) && (!psetoc) && (aux_last_error() == EAPPNAME)) {
			if (secsc_install_SCPSE (psesel.app_name, CNULL)) {
				fprintf(stderr, "\n    %s: Cannot install a PSE frame on the SC. \n\n,", cmd);
				return(-1);
			}	
			else  {
				if (sec_onekeypair == TRUE)
					fprintf(stderr, "\nFrame for an SC-PSE with one keypair has been installed, this includes:\n");
				else 
					fprintf(stderr, "\nFrame for an SC-PSE with two keypairs has been installed, this includes:\n");

				fprintf(stderr, "   - reservation of space on the SC,\n");
				fprintf(stderr, "   - installation of the PIN for the PSE extension,\n");
				fprintf(stderr, "   - installation of the PIN for the SC (value: %s).\n\n", DEFAULT_PIN);
				fprintf(stderr, "Please change the value of the SC-PIN as soon as possible (command: chpin).\n\n");
			}
		}
#endif

		aux_free_error();
		ret = sec_create(&psesel);
		if (ret < 0) {
			if ((psetoc) && (aux_last_error() == ECREATEAPP)) {

				aux_free_error();

				/*
				 *  Existing SC-PSE shall be replaced !
				 *  
				 *    Check whether the new PSE fits to the old one. 
				 */

				if(psetoc->status & ONEKEYPAIRONLY) 
					onekeypaironly = TRUE;
				else 
					onekeypaironly = FALSE;

				if (actualparms->onekeypair != onekeypaironly) {
					if (actualparms->onekeypair == TRUE) 
						fprintf(stderr,"\n    %s: Existing %s contains two RSA keypairs  ... cannot be replaced by one keypair. \n\n", cmd, app_text);
					else 
						fprintf(stderr,"\n    %s: Existing %s contains one RSA keypair  ... cannot be replaced by two keypairs. \n\n", cmd, app_text);
					if (verbose)
						aux_fprint_error(stderr, verbose);
					return (-1);
				}

			}
			else {
				/* 
				 *  Error during creation of application 
				 */

				fprintf(stderr, "\n   %s: ", cmd);
				fprintf(stderr, "Creation of %s failed\n\n", app_text);
				if (verbose)
					aux_fprint_error(stderr, verbose);
				return (-1);
			}
		}

		actualparms->userpin = global.userpin = psesel.pin;

		set_AF_pse(USER);


		/* create and install PSE object "Serial" */

		if (actualparms->newca) {
			if (af_pse_update_SerialNumber(actualparms->serial) < 0) {
				fprintf(stderr, "    %s: ", cmd);
				fprintf(stderr, "unable to create Serial on PSE");
				aux_add_error(EINVALID, "unable to create Serial on PSE", CNULL, 0, proc);
				if (verbose)
					aux_fprint_error(stderr, verbose);
				return (-1);
			}
		}
		if (verbose)
			fprintf(stderr, "    %s: PSE created for <%s> and application %s.\n", cmd, subject_Name, actualparms->userpse);
	}
/************************************* g e t p k r o o t ***************************************/
	if (actualparms->pkroot) {
		set_AF_pse(CA);

		if (!(pkroot = af_pse_get_PKRoot())) {
			aux_add_error(EINVALID, "Can't read PKRoot from PSE", CNULL, 0, proc);
			if (verbose)
				aux_fprint_error(stderr, verbose);
			fprintf(stderr, "    %s: Can't read PKRoot from PSE %s\n", cmd, capsepath);
			return (-1);
		}
		if (verbose)
			fprintf(stderr, "    Get PKRoot from %s: done.\n", capsepath);

/************************************* i n s t p k r o o t *************************************/

		set_AF_pse(USER);

		if (actualparms->newpkr || actualparms->oldpkr)
			if ((oldpkroot = af_pse_get_PKRoot())) {

				pklist = af_pse_get_PKList(SIGNATURE);

				if (actualparms->oldpkr && oldpkroot->oldkey) {
					if (!(newpklist = (PKList *) malloc(sizeof(PKList)))) {
						fprintf(stderr, "    %s: ", cmd);
						fprintf(stderr, "Can't allocate memory\n");
						aux_add_error(EMALLOC, "newpklist", CNULL, 0, proc);
						if (verbose)
							aux_fprint_error(stderr, verbose);
						return (-1);
					}
					newpklist->next = pklist;
					if (!(newpklist->element = (ToBeSigned *) malloc(sizeof(ToBeSigned)))) {
						fprintf(stderr, "    %s: ", cmd);
						fprintf(stderr, "Can't allocate memory\n");
						aux_add_error(EMALLOC, "newpklist->element", CNULL, 0, proc);
						if (verbose)
							aux_fprint_error(stderr, verbose);
						return (-1);
					}
					newpklist->element->version = 0;
					newpklist->element->serialnumber = oldpkroot->oldkey->serial;
					if(oldpkroot->oldkey->sig && oldpkroot->oldkey->sig->signAI)
						newpklist->element->signatureAI = oldpkroot->oldkey->sig->signAI;
					else 	newpklist->element->signatureAI = DEF_ISSUER_ALGID;
					newpklist->element->issuer = oldpkroot->ca;
					if (!(newpklist->element->valid = (Validity *) malloc(sizeof(Validity)))) {
						fprintf(stderr, "    %s: ", cmd);
						fprintf(stderr, "Can't allocate memory\n");
						aux_add_error(EMALLOC, "newpklist->element->valid", CNULL, 0, proc);
						if (verbose)
							aux_fprint_error(stderr, verbose);
						return (-1);
					}
					newpklist->element->valid->notbefore = "900101000000+0000";
					newpklist->element->valid->notafter = "990101000000+0000";
					newpklist->element->subject = oldpkroot->ca;
					newpklist->element->subjectPK = oldpkroot->oldkey->key;
#ifdef COSINE
					newpklist->element->authatts = (AuthorisationAttributes *) 0;
#endif

					pklist = newpklist;
				}
				if (actualparms->newpkr && oldpkroot->newkey) {
					if (!(newpklist = (PKList *) malloc(sizeof(PKList)))) {
						fprintf(stderr, "    %s: ", cmd);
						fprintf(stderr, "Can't allocate memory\n");
						aux_add_error(EMALLOC, "newpklist", CNULL, 0, proc);
						if (verbose)
							aux_fprint_error(stderr, verbose);
						return (-1);
					}
					newpklist->next = pklist;
					if (!(newpklist->element = (ToBeSigned *) malloc(sizeof(ToBeSigned)))) {
						fprintf(stderr, "    %s: ", cmd);
						fprintf(stderr, "Can't allocate memory\n");
						aux_add_error(EMALLOC, "newpklist->element", CNULL, 0, proc);
						if (verbose)
							aux_fprint_error(stderr, verbose);
						return (-1);
					}
					newpklist->element->version = 0;
					newpklist->element->serialnumber = oldpkroot->newkey->serial;
					if(oldpkroot->newkey->sig && oldpkroot->newkey->sig->signAI)
						newpklist->element->signatureAI = oldpkroot->newkey->sig->signAI;
					else 	newpklist->element->signatureAI = DEF_ISSUER_ALGID;
					newpklist->element->issuer = oldpkroot->ca;
					if (!(newpklist->element->valid = (Validity *) malloc(sizeof(Validity)))) {
						fprintf(stderr, "    %s: ", cmd);
						fprintf(stderr, "Can't allocate memory\n");
						aux_add_error(EMALLOC, "newpklist->element->valid", CNULL, 0, proc);
						if (verbose)
							aux_fprint_error(stderr, verbose);
						return (-1);
					}
					newpklist->element->valid->notbefore = "900101000000+0000";
					newpklist->element->valid->notafter = "990101000000+0000";
					newpklist->element->subject = oldpkroot->ca;
					newpklist->element->subjectPK = oldpkroot->newkey->key;
#ifdef COSINE
					newpklist->element->authatts = (AuthorisationAttributes *) 0;
#endif

					pklist = newpklist;
				}
				if (af_pse_update_PKList(SIGNATURE, pklist) < 0) {
					fprintf(stderr, "    %s: Can't install PKList on PSE %s\n", cmd, actualparms->userpse);
					aux_add_error(EINVALID, "af_pse_update_PKList failed", CNULL, 0, proc);
					if (verbose)
						aux_fprint_error(stderr, verbose);
					aux_free_PKList(&pklist);
					return (-1);
				}
				if (actualparms->newpkr && oldpkroot->newkey) {
					newpklist = pklist;
					free(pklist->element);
					pklist = pklist->next;
					free(newpklist);
				}
				if (actualparms->oldpkr && oldpkroot->oldkey) {
					newpklist = pklist;
					free(pklist->element);
					pklist = pklist->next;
					free(newpklist);
				}
				aux_free_PKList(&pklist);
				aux_free_PKRoot(&oldpkroot);

			}
		if (af_pse_update_PKRoot(pkroot) < 0) {
			fprintf(stderr, "    %s: Can't install PKRoot on PSE %s\n", cmd, actualparms->userpse);
			aux_add_error(EINVALID, "af_pse_update_PKRoot failed", CNULL, 0, proc);
			if (verbose)
				aux_fprint_error(stderr, verbose);
			aux_free_PKRoot(&pkroot);
			return (-1);
		}
		if (verbose) {
			fprintf(stderr, "    %s: The following PKRoot was installed on the user PSE:\n", cmd);
			aux_fprint_PKRoot(stderr, pkroot);
		}
	}
/************************************* g e t f c p a t h ***************************************/

	set_AF_pse(CA);
	if (actualparms->fcpath || actualparms->pkroot >= OLD_TO_PKLIST) {
		if (!(soc = (SET_OF_Certificate *) malloc(sizeof(SET_OF_Certificate)))) {
			fprintf(stderr, "    %s: ", cmd);
			fprintf(stderr, "Can't allocate memory\n");
			aux_add_error(EMALLOC, "soc", CNULL, 0, proc);
			if (verbose)
				aux_fprint_error(stderr, verbose);
			return (-1);
		}
		soc->element = af_pse_get_Certificate(SIGNATURE, NULLDNAME, 0);

		if (aux_cmp_DName(soc->element->tbs->issuer, soc->element->tbs->subject))
			soc->next = af_pse_get_CertificateSet(SIGNATURE);
		else {
			/* get FCPath from root CA */
			soc->next = (SET_OF_Certificate *) 0;
			aux_free_CertificateSet(&soc);
			soc = af_pse_get_CertificateSet(SIGNATURE);
		}
		aux_free_error();

		if (!soc) {
			/* empty FCPath */
			if (verbose)
				fprintf(stderr, "    Empty FCPath from %s: done.\n", capsepath);
			goto genkey;
		}
		if (!(fcpath = (FCPath *) malloc(sizeof(FCPath)))) {
			fprintf(stderr, "    %s: ", cmd);
			fprintf(stderr, "Can't allocate memory\n");
			aux_add_error(EMALLOC, "fcpath", CNULL, 0, proc);
			if (verbose)
				aux_fprint_error(stderr, verbose);
			return (-1);
		}
		fcpath->liste = soc;
		fcpath->next_forwardpath = af_pse_get_FCPath(NULLDNAME);
		aux_free_error();

		if (verbose)
			fprintf(stderr, "    Get FCPath from %s: done.\n", capsepath);
	}
/************************************* i n s t f c p a t h *************************************/

	if (actualparms->fcpath) {

		set_AF_pse(USER);

		if (af_pse_update_FCPath(fcpath) < 0) {
			fprintf(stderr, "    %s: Can't install FCPath on PSE %s\n", cmd, actualparms->userpse);
			aux_add_error(EINVALID, "af_pse_update_FCPath failed", CNULL, 0, proc);
			if (verbose)
				aux_fprint_error(stderr, verbose);
			return (-1);
		}
		if (verbose) {
			fprintf(stderr, "    %s: The following FCPath was installed on the user PSE:\n", cmd);
			aux_fprint_FCPath(stderr, fcpath);
		}
	}
/***************************************** g e n k e y *****************************************/

genkey:
	if (actualparms->onekeypair)
		ka = 1;
	else
		ka = 2;
	for (kx = 0; kx < ka; kx++)
		if (actualparms->cert[kx]) {
			set_AF_pse(USER);

			if (kx == 0)
				ktype = SIGNATURE;
			else
				ktype = ENCRYPTION;

			if (actualparms->newkey[kx]) {
				algorithm = actualparms->algorithms[kx];
				keytype = keytypes[kx];
				keysize = actualparms->keysizes[kx];

				key.keyref = 0;
				key.pse_sel = (PSESel *) 0;
				key.key = &keyinfo;
				keyinfo.subjectAI = aux_cpy_AlgId(algorithm);
				if (aux_ObjId2ParmType(algorithm->objid) != PARM_NULL)
					*(int *) (keyinfo.subjectAI->param) = keysize;

				name = aux_ObjId2Name(algorithm->objid);
				if (verbose)
					fprintf(stderr, "    %s: Generating %s key pair (Algorithm %s)\n        for <%s> with PSE %s ...\n", cmd, keytype, name, subject_Name, actualparms->userpse);
				free(name);

				if (verbose) sec_gen_verbose = TRUE;

				rc = af_gen_key(&key, ktype, actualparms->replace);

				if (rc < 0) {
					fprintf(stderr, "    %s: ", cmd);
					fprintf(stderr, "Can't generate new keys\n");
					aux_add_error(EINVALID, "Can't generate new keys", CNULL, 0, proc);
					if (verbose)
						aux_fprint_error(stderr, verbose);
					aux_free_FCPath(&fcpath);
					aux_free_PKRoot(&pkroot);
					return (-1);
				} else if (verbose)
					fprintf(stderr, "    %s: Key generation O.K.\n", cmd);


				if (ktype == SIGNATURE) {
					if (actualparms->onekeypair)
						subject_Certificate = af_create_Certificate(&keyinfo, actualparms->issuer_alg, SKnew_name, subject_DName, NULLOCTETSTRING);
					else
						subject_Certificate = af_create_Certificate(&keyinfo, actualparms->issuer_alg, SignSK_name, subject_DName, NULLOCTETSTRING);
				} 
				else
					subject_Certificate = af_create_Certificate(&keyinfo, actualparms->issuer_alg, DecSKnew_name, subject_DName, NULLOCTETSTRING);

				if (!subject_Certificate) {
					fprintf(stderr, "    %s: ", cmd);
					fprintf(stderr, "Can't create prototype certificate\n");
					aux_add_error(EINVALID, "Can't create prototype certificate", CNULL, 0, proc);
					if (verbose)
						aux_fprint_error(stderr, verbose);
					aux_free_FCPath(&fcpath);
					aux_free_PKRoot(&pkroot);
					return (-1);
				}
				if (af_pse_update_Certificate(ktype, subject_Certificate, TRUE) < 0) {
					fprintf(stderr, "%s: ", cmd);
					fprintf(stderr, "unable to store prototype certificate on PSE");
					aux_add_error(EINVALID, "unable to store prototype certificate on PSE", CNULL, 0, proc);
					if (verbose)
						aux_fprint_error(stderr, verbose);
					return(-1);
				}
			} else {
				subject_Certificate = af_pse_get_Certificate(ktype, NULLDNAME, 0);
				aux_cpy2_KeyInfo(&keyinfo, subject_Certificate->tbs->subjectPK);
				aux_free_Certificate(&subject_Certificate);

				if (ktype == SIGNATURE) {
					if (actualparms->onekeypair)
						subject_Certificate = af_create_Certificate(&keyinfo, actualparms->issuer_alg, SKnew_name, subject_DName, NULLOCTETSTRING);
					else
						subject_Certificate = af_create_Certificate(&keyinfo, actualparms->issuer_alg, SignSK_name, subject_DName, NULLOCTETSTRING);
				} else
					subject_Certificate = af_create_Certificate(&keyinfo, actualparms->issuer_alg, DecSKnew_name, subject_DName, NULLOCTETSTRING);


			}
/***************************************** c e r t i f y ****************************************/

			set_AF_pse(CA);

			/* O.K. skip to CA dir */

			if(!(cadir_abs = aux_cat_paths(getenv("HOME"), cadir))) {
				AUX_ADD_ERROR;
				return(-1);
			}
			if(!(logpath = aux_cat_paths(cadir_abs, CALOG))) {
				AUX_ADD_ERROR;
				return(-1);
			}

			if ((logfile = fopen(logpath, LOGFLAGS)) == (FILE *) 0) {
				fprintf(stderr, "    %s: Can't open %s\n", cmd, CALOG);
				aux_add_error(EINVALID, "Can't open", CALOG, char_n, proc);
				if (verbose)
					aux_fprint_error(stderr, verbose);
				free(logpath);
				aux_free_FCPath(&fcpath);
				aux_free_PKRoot(&pkroot);
				aux_free_Certificate(&subject_Certificate);
				return (-1);
			}
			free(logpath);


			validity.notbefore = actualparms->notbefore;
			validity.notafter = actualparms->notafter;

			new_cert = af_certify (subject_Certificate, 
						&validity,
						actualparms->issuer_alg);

			if (new_cert == (Certificate *) 0) {
				fprintf(stderr, "    %s: ", cmd);
				fprintf(stderr, "AF Error with CA Certify\n");
				AUX_ADD_ERROR;
				if (verbose)
					aux_fprint_error(stderr, verbose);
				LOGAFERR;
				fclose(logfile);
				aux_free_FCPath(&fcpath);
				aux_free_PKRoot(&pkroot);
				aux_free_Certificate(&subject_Certificate);
				return (-1);
			}
			aux_free_Certificate(&subject_Certificate);
			subject_Certificate = new_cert;
	


			if (af_cadb_add_user(subject_Name, cadir_abs) < 0) {
				LOGERR("can't access user db");
				fprintf(stderr, "    %s: ", cmd);
				fprintf(stderr, "Warning: Can't access user db\n");
			}

			if (af_cadb_add_Certificate(ktype, subject_Certificate, cadir_abs)) {
				LOGERR("Can't access certificate db");
				fprintf(stderr, "    %s: ", cmd);
				fprintf(stderr, "Warning: Can't access certificate db\n");
			}
			if (verbose) {
				fprintf(stderr, "%s: The following certificate was generated by <%s>\n    using PSE %s:\n", cmd, issuer, capsepath);
				aux_fprint_Certificate(stderr, subject_Certificate);
			}
			fclose(logfile);

/***************************************** i n s t c e r t *****************************************/

			set_AF_pse(USER);

			if (hierarchy) {
				if (verbose)
					fprintf(stderr, "%s: Verifying and installing certificate in PSE %s ...\n", cmd, actualparms->userpse);

				if ((aux_ObjId2AlgType(subject_Certificate->tbs->subjectPK->subjectAI->objid) == SIG) && ktype == ENCRYPTION) {
					fprintf(stderr, "%s: Signature key to be installed as Encryption key\n", cmd);
					aux_add_error(EINVALID, "Signature key to be installed as Encryption key", CNULL, 0, proc);
					if (verbose)
						aux_fprint_error(stderr, verbose);
					return(-1);
				}
				protocert = af_pse_get_Certificate(ktype, NULLDNAME, 0);
				if (!protocert) {

					/*
					 * check whether PK of cert to be
					 * installed fits to SKnew or SignSK or DecSKnew
					 */

					if(actualparms->onekeypair == TRUE)
						pse_sel = af_pse_open(SKnew_OID, FALSE);
					else{
        					if(ktype == SIGNATURE) pse_sel = af_pse_open(SignSK_OID, FALSE);
        					else pse_sel = af_pse_open(DecSKnew_OID, FALSE);
					}
        				if(!pse_sel) {
						if(actualparms->onekeypair == TRUE){
							fprintf(stderr,"%s: Can't open SKnew to check PK\n", cmd);
							aux_add_error(EINVALID, "Can't open SKnew to check PK", CNULL, 0, proc);
						}
						else{
							fprintf(stderr,"%s: Can't open SignSK or DecSKnew to check PK\n", cmd);
							aux_add_error(EINVALID, "Can't open SignSK or DecSKnew to check PK", CNULL, 0, proc);
						}
						aux_fprint_error(stderr, verbose);
						return(-1); 
					}
					key.key = (KeyInfo *) 0;
					key.keyref = 0;
					key.pse_sel = pse_sel;
#ifdef SCA
					if((pse_location = sec_psetest(actualparms->userpse)) == ERR_in_psetest) {
						if (aux_last_error() == EDEVLOCK) 
							fprintf(stderr, "Cannot open device for SCT (No such device or device busy)\n");
						else	fprintf(stderr, "Error during SC configuration.\n");
						aux_fprint_error(stderr, verbose);
						return(-1);
					}

					if (pse_location == SCpse)
						rc = 0;
					else
						rc = sec_checkSK(&key, subject_Certificate->tbs->subjectPK);
#else
					rc = sec_checkSK(&key, subject_Certificate->tbs->subjectPK);
#endif
				} else {
					rc = aux_cmp_KeyInfo(subject_Certificate->tbs->subjectPK, protocert->tbs->subjectPK);
					aux_free_Certificate(&protocert);
				}

				if (rc < 0) {
					fprintf(stderr, "%s: PK of certificate to be installed does not fit to SignSK or DecSKnew\n", cmd);
					aux_add_error(EINVALID, "PK of certificate to be installed does not fit to SignSK or DecSKnew", CNULL, 0, proc);
					if (verbose)
						aux_fprint_error(stderr, verbose);
					return(-1);
				}
				fcpath = af_pse_get_FCPath(NULLDNAME);
				certs = aux_create_Certificates(subject_Certificate, fcpath);
				rc = af_verify_Certificates(certs, CNULL, (PKRoot *) 0);
				if (rc < 0) {
					fprintf(stderr, "%s: Can't verify hierarchy certificate to be installed\n", cmd);
					aux_add_error(EINVALID, "Can't verify hierarchy certificate to be installed", CNULL, 0, proc);
					if (verbose)
						aux_fprint_error(stderr, verbose);
					return(-1);
				} else if (verbose)
					fprintf(stderr, "%s: Hierarchy Certificate verified\n", cmd);
			}
			rc = af_pse_update_Certificate(ktype, subject_Certificate, hierarchy);

			if (rc < 0) {
				fprintf(stderr, "%s: Can't install certificate\n", cmd);
				aux_add_error(EINVALID, "Can't install certificate", CNULL, 0, proc);
				if (verbose)
					aux_fprint_error(stderr, verbose);
				return(-1);
			} else if (verbose) {

				if (hierarchy) {
					if (ktype == SIGNATURE) {
						if (actualparms->onekeypair)
							fprintf(stderr, "%s: %s Certificate installed as object Cert on PSE %s\n", cmd, keytype, actualparms->userpse);
						else
							fprintf(stderr, "%s: %s Certificate installed as object SignCert on PSE %s\n", cmd, keytype, actualparms->userpse);
					}
					else
						fprintf(stderr, "%s: %s Certificate installed as object EncCert on PSE %s\n", cmd, keytype, actualparms->userpse);
				}

				else {
					if (ktype == SIGNATURE) {
						if (actualparms->onekeypair)
							fprintf(stderr, "%s: %s Certificate added to object CSet on PSE %s\n", cmd, keytype, actualparms->userpse);
						else
							fprintf(stderr, "%s: %s Certificate added to object SignCSet on PSE %s\n", cmd, keytype, actualparms->userpse);
					}
					else
						fprintf(stderr, "%s: %s Certificate added to object EncCSet on PSE %s\n", cmd, keytype, actualparms->userpse);
				}
			}

			if (hierarchy && actualparms->enter) {
#ifdef AFDBFILE

				/*
				 * Determine whether X.500 directory shall be
				 * accessed
				 */
				x500 = af_x500_check();
#endif
#ifdef X500
				if (name_from_pse && x500)
					directory_user_dname = af_pse_get_Name();
				if (x500) {
					if (verbose) {
						fprintf(stderr, "%s: Accessing the X.500 directory entry of ", cmd);
						fprintf(stderr, "owner = \"%s\" ...\n", subject_Name);
					}
					rc = af_dir_enter_Certificate(subject_Certificate, certtype);
					if (verbose) {
						if (rc < 0)
							fprintf(stderr, "%s: Directory entry (X.500) failed.\n", cmd);
						else
							fprintf(stderr, "%s: Certificate entered into X.500 Directory.\n", cmd);
					}
					if (kx == 0) {	/* SIGNATURE certificate */
						rc = af_dir_delete_Certificate_from_targetObject(subject_Certificate->tbs->subject, proto_dn, certtype);
						if (verbose) {
							if (rc < 0)
								fprintf(stderr, "    %s: Directory operation (X.500) failed.\n", cmd);
							else
								fprintf(stderr, "    %s: Certificate with issuer <%s> removed from X.500 Directory entry of <%s>.\n", cmd, "cn=PROTO\0", subject_Name);
						}
					}
				}
#endif
#ifdef AFDBFILE
				if (actualparms->enter) {

					if (ktype == SIGNATURE || !actualparms->onekeypair) {
						if (verbose) {
							fprintf(stderr, "%s: Accessing the AF-DB directory entry of ", cmd);
							fprintf(stderr, "owner = \"%s\" ...\n", userunixname);
						}
						setuid(userunixname);

					        /*
					         * afdb directory for user is automatically created
 						 */
						rc = handle_afdb_directory(subject_Certificate);
						if (rc < 0)
							fprintf(stderr, "%s: Cannot create directory\n", cmd);
	

						rc = af_afdb_enter_Certificate(subject_Certificate, ktype);
						if (verbose) {
							if (rc < 0)
								fprintf(stderr, "%s: Directory entry (AF-DB) failed.\n", cmd);
							else
								fprintf(stderr, "%s: %s Certificate entered into AF-DB Directory.\n", cmd, keytypes[1]);
						}
					}
				}
#endif
			}
			aux_free_Certificate(&subject_Certificate);
			aux_free_FCPath(&fcpath);
			aux_free_PKRoot(&pkroot);
		}
			
        af_pse_close(NULLOBJID); 

	return (0);
}
/***************************************************************
 *
 * Procedure set_AF_pse
 *
 ***************************************************************/
#ifdef __STDC__

static int set_AF_pse(
	PSEtype	  psetype
)

#else

static int set_AF_pse(
	psetype
)
PSEtype	  psetype;

#endif

{
	int             i;
	static Boolean  CA_open,   CA_object_open[PSE_MAXOBJ]; 
	static Boolean  USER_open, USER_object_open[PSE_MAXOBJ];
#ifdef SCA
	static 	Boolean  	CA_checked = FALSE;
	static 	Boolean  	new_PSE;
	static 	Boolean  	two_SCTs_req = FALSE;
	static 	PSEConfig 	user_pse_status;
		PSESel		user_pse_sel;
	static 	PSEConfig 	ca_pse_status;
		PSESel		ca_pse_sel;
#endif
	char           *proc = "set_AF_pse";


	/*
	 *  This function sets AF_pse to a new value, so all *_caches 
	 *  from the previous PSE have to be released.
	 */
	af_pse_reset(CNULL);


	if(strcmp(AF_pse.app_name, capsepath) == 0) {
		CA_open = AF_pse.open;
		for(i = 0; i < PSE_MAXOBJ; i++) 
			CA_object_open[i] = AF_pse.object[i].open;
	}
	if(strcmp(AF_pse.app_name, actualparms->userpse) == 0) {
		USER_open = AF_pse.open;
#ifdef SCA
		new_PSE = FALSE;
#endif
		for(i = 0; i < PSE_MAXOBJ; i++) 
			USER_object_open[i] = AF_pse.object[i].open;
	}
#ifdef SCA
	else
		new_PSE = TRUE;
#endif

#ifdef SCA
	/*
	 *  Check whether one or two SCTs are required
	 *   - If both the userpse and the capse are on the SC, we need two SCTs
	 */
	if ((psetype == CA) && (CA_checked == FALSE)) {
		ca_pse_sel.app_name = capsepath;
		ca_pse_sel.object.name = CNULL;
		ca_pse_status = sec_pse_config(&ca_pse_sel);
		if (ca_pse_status == ERR_in_pseconfig) {
			AUX_ADD_ERROR;
			return -1;
		}
		CA_checked = TRUE;
	}

	if ((psetype == USER) && (new_PSE = TRUE)) {
		user_pse_sel.app_name = actualparms->userpse;
		user_pse_sel.object.name = CNULL;
		user_pse_status = sec_pse_config(&user_pse_sel);
		if (user_pse_status == ERR_in_pseconfig) {
			AUX_ADD_ERROR;
			return -1;
		}

		if (CA_checked == TRUE) {
			if ( (user_pse_status == PSE_ON_SC) && 
			     (ca_pse_status == PSE_ON_SC) ) 
				two_SCTs_req = TRUE;
			else 
				two_SCTs_req = FALSE;
		}
	}
#endif



	if (psetype == CA) {
		if (aux_create_AFPSESel(capsepath, actualparms->capin) < 0) {
			aux_add_error(EINVALID, "Cannot create AFPSESel", CNULL, 0, proc);
			return -1;
		}
		AF_pse.open = CA_open;
		for(i = 0; i < PSE_MAXOBJ; i++) AF_pse.object[i].open = CA_object_open[i];
		putenv(cahome);
		if (actualparms->HOME || actualparms->enter) {
			i = setuid(caunixuid);
/*			if (i < 0)
				fprintf(stderr, "setuid to %d failed\n", caunixuid); */
		}
	} else {
		if (aux_create_AFPSESel(actualparms->userpse, actualparms->userpin) < 0) {
			aux_add_error(EINVALID, "Cannot create AFPSESel", CNULL, 0, proc);
			return -1;
		}
		AF_pse.open = USER_open;
		for(i = 0; i < PSE_MAXOBJ; i++) AF_pse.object[i].open = USER_object_open[i];
		putenv(userhome);
		if (actualparms->HOME || actualparms->enter) {
			i = setuid(userunixuid);
/*			if (i < 0)
				fprintf(stderr, "setuid to %d failed\n", userunixuid); */
		}
	}


#ifdef SCA
	/*
	 *  Set the sct_id:
	 *	If only one SCT is needed,
	 *	   the SCT with sct_id = 1 is taken.
	 *      If both the CA-PSE and the USER-PSE are located on smartcards,
	 *         the SCT with sct_id = 1 is taken for the CA and
	 *	   the SCT with sct_id = 2 is taken for the USER.
	 */

	if (psetype == CA) {
		if (ca_pse_status == PSE_ON_SC)
			sc_sel.sct_id = 1;
	}
	else {
		if (two_SCTs_req == TRUE)
			sc_sel.sct_id = 2;
		else
			sc_sel.sct_id = 1;
	}
#endif

	return (0);
}

/***************************************************************
 *
 * Procedure localinit
 *
 ***************************************************************/
#ifdef __STDC__

static int localinit(
	char	 *cadir_abs
)

#else

static int localinit(
	cadir_abs
)
char	 *cadir_abs;

#endif

{
#define	DBMOPENFL	O_RDWR|O_CREAT, S_IREAD|S_IWRITE
#ifdef NDBM
	DBM            *user;
	DBM            *cert;

#else
	FILE           *fd;
	char            fn[PATH_LENGTH];

#endif
	datum           key, data;
	int             i;
	char           *userdbpath, *certdbpath;
	char           *proc = "localinit";



	if(!(userdbpath = aux_cat_paths(cadir_abs, USERDB))) {
		AUX_ADD_ERROR;
		return(-1);
	}
	if(!(certdbpath = aux_cat_paths(cadir_abs, CERTDB))) {
		AUX_ADD_ERROR;
		return(-1);
	}


	/* user dbm */

#ifdef NDBM
	user = dbm_open(userdbpath, DBMOPENFL);
	if (!user)
		return 1;
	dbm_close(user);
#else
	strcpy(fn, userdbpath);
	strcat(fn, ".pag");
	fd = fopen(fn, "r");
	if (fd)
		fclose(fd);
	else {
		fd = fopen(fn, "w");
		fclose(fd);
	}
	strcpy(fn, userdbpath);
	strcat(fn, ".dir");
	fd = fopen(fn, "r");
	if (fd)
		fclose(fd);
	else {
		fd = fopen(fn, "w");
		fclose(fd);
	}
	if (dbminit(userdbpath) < 0)
		return 1;
	else
		dbmclose();
#endif

	/* cert dbm */

#ifdef NDBM
	cert = dbm_open(certdbpath, DBMOPENFL);
	if (!cert)
		return 1;
	dbm_close(cert);
#else
	strcpy(fn, certdbpath);
	strcat(fn, ".pag");
	fd = fopen(fn, "r");
	if (fd)
		fclose(fd);
	else {
		fd = fopen(fn, "w");
		fclose(fd);
	}
	strcpy(fn, certdbpath);
	strcat(fn, ".dir");
	fd = fopen(fn, "r");
	if (fd)
		fclose(fd);
	else {
		fd = fopen(fn, "w");
		fclose(fd);
	}
	if (dbminit(certdbpath) < 0)
		return 1;
	else
		dbmclose();

#endif

	return 0;
}




/***************************************************************
 *
 * Procedure usage
 *
 ***************************************************************/
#ifdef __STDC__

static void usage(
	int	  help
)

#else

static void usage(
	help
)
int	  help;

#endif

{
	aux_fprint_version(stderr);

        fprintf(stderr, "gen_pse  Creating and updating of PSE's\n\n");
        fprintf(stderr, "usage:\n\n");
	fprintf(stderr, "gen_pse            [-i script][-c cadir][-p capse][-H home][-u userunixname]\n");
	fprintf(stderr, "                   [-a issueralg][-s signalg][-e encalg][-k keysize]\n");
	fprintf(stderr, "                   [-f notbefore][-l notafter][-x nameprefix][-T pinfile]\n");
	fprintf(stderr, "                   [-P subjectpse][-C caname][-g serialnumber]\n");
	fprintf(stderr, "                   ");
#ifdef X500
	fprintf(stderr, "[-d dsaname] [-t <dsaptailor>] [-n]");
#endif
	fprintf(stderr, "[-vrDqzXYh][namesuffix]\n");

        if(help == LONG_HELP) {




        fprintf(stderr, "                   \n");
        fprintf(stderr, "-i <script>        Name of a script file where these options can be set for more than one creation\n");
        fprintf(stderr, "-c <cadir>         Name of CA-directory (default: environment variable CADIR or %s)\n", DEF_CADIR);
        fprintf(stderr, "-p <capse>         CA's PSE name (default: environment variable CAPSE or %s)\n", DEF_CAPSE);
        fprintf(stderr, "-H <home>          Path of all home-directories\n");
        fprintf(stderr, "-u <userunixname>  Unixname of the owner of a PSE to create/update\n");
        fprintf(stderr, "-T <pinfile>       Create random PINs and store them in a encrypted pinfile\n");
        fprintf(stderr, "-a <issueralg>     Algorithm to sign certificates with\n");
        fprintf(stderr, "-s <signalg>       Algorithm of signature key to create/update\n");
        fprintf(stderr, "-e <encalg>        Algorithm of encryption key to create/update\n");
        fprintf(stderr, "-k <keysize>       Keysize of key to generate\n");
        fprintf(stderr, "-f <notbefore>     First date on which the certificate is valid\n");
        fprintf(stderr, "-l <notafter>      Last date on which the certificate is valid\n");
        fprintf(stderr, "-x <nameprefix>    First part of the name associated to the PSE\n");
        fprintf(stderr, "-P <subjectpse>    Name of PSE to create/update (default: environment variable PSE or %s)\n", DEF_PSE);
        fprintf(stderr, "-C <caname>        Create a CA with CA-directory name <caname>\n");
        fprintf(stderr, "-g <serialnumber>  If a CA is created a serialnumber to start with can be specified\n");
#ifdef X500
        fprintf(stderr, "-d <dsaname>       Name of the dsa\n");
	fprintf(stderr, "-t <dsaptailor>    Location of dsaptailor file (default: dsaptailor in the ISODE ETCDIR directory)\n");

        fprintf(stderr, "-n                 Read the name of the dsa from PSE\n");
#endif
        fprintf(stderr, "-v                 verbose\n");
        fprintf(stderr, "-V                 Verbose\n");
        fprintf(stderr, "-W                 Grand Verbose (for testing only)\n");
        fprintf(stderr, "-r                 Replace an existing PSE in case of creation\n");
        fprintf(stderr, "-D                 Store generated certificates in X500 directory\n");
        fprintf(stderr, "-q                 Create two different key pairs for signature and encryption\n");
        fprintf(stderr, "-z                 Check malloc/free behaviour\n");
        fprintf(stderr, "-X                 Read random number generator seed from PSE-object Random\n");
        fprintf(stderr, "-Y                 Init random number generator seed through keyboard input\n");
        fprintf(stderr, "-h                 Write this help text\n");
        fprintf(stderr, "                   \n");

        fprintf(stderr, "<namesuffix>      Second part of the name associated to the PSE\n");


        }

        if(MF_check) MF_fprint(stderr);

        exit(-1);                                /* IRREGULAR EXIT FROM GEN_PSE */
}

