/* ./src/util/getalias.c */

static char *rcsid = "$Id: getalias.c,v 1.4 1994/11/02 16:38:51 schneiw Exp $";

/* 
 *
 * $Id: getalias.c,v 1.4 1994/11/02 16:38:51 schneiw Exp $
 *
 * $Log: getalias.c,v $
 *
 */
 
/*
 *  
 */

/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/


#include <stdio.h>
#include "af.h"


extern char		*optarg;
extern int		optind, opterr;

int		opt;
int             	verbose = 0;
Boolean			localname = FALSE;
Boolean			rfcmailaddress = FALSE;
Boolean			x400mailaddress = FALSE;
Boolean			dname = FALSE;
Boolean			all_aliases = FALSE;
Boolean			search = FALSE;
Boolean			user_aliases = FALSE;
Boolean			system_aliases = FALSE;
char			*pattern = CNULL;
char			*psename = CNULL;
char			*cadir = CNULL;

static char     	*find_pattern();
static void     	print_aliases();
static void     	usage();




/***************************************************************
 *
 * Procedure main
 *
 ***************************************************************/
#ifdef __STDC__

int main(
	int	  cnt,
	char	**parm
)

#else

int main(
	cnt,
	parm
)
int	  cnt;
char	**parm;

#endif

{
	char 			*proc = "main (get_alias)";
	char			**name;
	char			*aliases = CNULL;
	char			*a = CNULL;
	

	optind = 1;
	opterr = 0;

	accept_alias_without_verification = FALSE;
	MF_check = FALSE;

	while ( (opt = getopt(cnt, parm, "p:c:hLRXDUSasnvzVW")) != -1 ) { 
		switch(opt) {
	                case 'p':
				if (psename) usage(SHORT_HELP);
				else psename = optarg;
	                        continue;
			case 'c':
				if (cadir) usage(SHORT_HELP);
				cadir = optarg;
				continue;
			case 'L':
				localname = TRUE;
				continue;
			case 'R':
				rfcmailaddress = TRUE;
				continue;
			case 'X':
				x400mailaddress = TRUE;
				continue;
			case 'D':
				dname = TRUE;
				continue;
			case 'U':
				user_aliases = TRUE;
				continue;
			case 'S':
				system_aliases = TRUE;
				continue;
			case 'a':
				all_aliases = TRUE;
				continue;
			case 's':
				search = TRUE;
				continue;
			case 'n':
				accept_alias_without_verification = TRUE;
				continue;
			case 'v':
				verbose = 1;
				continue;
			case 'V':
				verbose = 2;
				continue;
			case 'W':
				verbose = 2;
				af_verbose = TRUE;
				sec_verbose = TRUE;
				continue;
	                case 'z':
	                        MF_check = TRUE;
	                        continue;
			case 'h':
				usage(LONG_HELP);
				break;
	                default:
			case '?':
				usage(SHORT_HELP);
				break;
		}
	}

	/* pattern is last parameter; cut back string */
	if (optind < cnt) {
	
		pattern = aux_cpy_ReducedString(parm[optind]);
        }
        
        if (!user_aliases && !system_aliases) {
        
        	user_aliases = system_aliases = TRUE;
        }
        
        /* open PSE */
	if (user_aliases || (system_aliases && !accept_alias_without_verification)) {
	
		aux_set_pse(psename, cadir);
	}

        /* get aliases */
 	if (!aux_filter_AliasList(user_aliases, system_aliases)) {

		fprintf(stderr, "%s ERROR: Can't read selected alias list.\n", proc);
		
		exit(-1);

	}
	if (verbose) {
	
		aux_check_AliasList(stderr);
	}
	
	aliases = find_pattern(CNULL, name);
	while (aliases) {
	
		print_aliases(*name, aliases);
		
		free(*name);
		free(aliases);
		
		aliases = find_pattern("", name);
	}
	
	
	if (pattern) free(pattern);
	
	exit(0);
}



/*
 *	find pattern in alias list
 *	return string with selected aliases if first/another DName was found, CNULL if not
 */
/***************************************************************
 *
 * Procedure find_pattern
 *
 ***************************************************************/
#ifdef __STDC__

static
char *find_pattern(
	char	 *init_string,
	char	 **name
)

#else

static
char *find_pattern(
	init_string,
	name
)
char	 *init_string;
char	 **name;

#endif

{
	char				*proc = "find_pattern";
	char				*first_name = CNULL;
	char				*aliases;
	AliasFile			afile;


	/* any fitting DName ? */
	if (! (*name = aux_search_AliasList(init_string, pattern))) {
	
		if (first_name) free(first_name);
		
		return(CNULL);
		
	} else {

		if (!first_name) {
		
			/* remember first fitting DName */
			first_name = aux_cpy_String(*name);
			
		} else if (!strcmp(first_name, *name)) {
		
			/* first one again */
			free(*name);
			if (first_name) free(first_name);
			
			return(CNULL);
		}

		aliases = aux_alias_getall(*name);
		
		return(aliases);
	}
}



/*
 *	print name/aliases 
 */
/***************************************************************
 *
 * Procedure print_aliases
 *
 ***************************************************************/
#ifdef __STDC__

static
void print_aliases(
	char	 *name,
	char	 *aliases
)

#else

static
void print_aliases(
	name,
	aliases
)
char	 *name;
char	 *aliases;

#endif
{
	char				*proc = "print_aliases";
	char				*a;
	AliasFile			afile;
	char				*cr = "\n";

	
	/* DName requested */
	fprintf(stdout, "%s%s%s",
			dname && verbose ? "<DName> = " : "",
			dname ? name : "",
			dname ? cr : "");
			
	fprintf(stdout, "%s%s%s",
			verbose ? "<Aliases> = " : "",
			aliases,
			cr);
			
	fprintf(stdout, "%s",
			verbose ? cr : "");
			

}






/***************************************************************
 *
 * Procedure usage
 *
 ***************************************************************/
#ifdef __STDC__

static void usage(
	int	  help
)

#else

static void usage(
	help
)
int	  help;

#endif

{
	aux_fprint_version(stderr);

        fprintf(stderr, "get_alias  Transform aliases to DNames and vice versa\n\n");
        fprintf(stderr, "usage:\n\n");
	fprintf(stderr, "get_alias [-hLRXDasUSn] [-p <psename>] [-c <cadir>] [pattern]\n\n");
 

        if(help == LONG_HELP) {
        	fprintf(stderr, "with:\n\n");
        	fprintf(stderr, "-h               write this help text\n");
        	fprintf(stderr, "-L               Show Local Name\n");
        	fprintf(stderr, "-R               Show RFC Mail address\n");
        	fprintf(stderr, "-X               Show X.400 Mail address\n");
		fprintf(stderr, "-D               Show DName\n");
        	fprintf(stderr, "-a               Show all aliases\n");
		fprintf(stderr, "-s               Additionally search for aliases\n");
		fprintf(stderr, "                   that contains pattern as a substring.\n");
		fprintf(stderr, "-U               Only search in User's local AliasList\n");
		fprintf(stderr, "-S               Only search in System alias list\n");
		fprintf(stderr, "-n               Do NOT verify system alias list\n");
        	fprintf(stderr, "-p <psename>     PSE name (default: %s)\n", DEF_PSE);
        	fprintf(stderr, "-c <cadir>       name of CA-directory (default: %s)\n", DEF_CADIR);
        	fprintf(stderr, "pattern          substring that is searched for in all components\n");
        	fprintf(stderr, "                   of the selected alias entries\n");

        }


        exit(-1);                                /* IRREGULAR EXIT FROM get_alias */
}
