#!/bin/sh

# $Id: test_TestTree.sh,v 1.6 1995/03/07 14:40:49 surkau Exp $

# $Log: test_TestTree.sh,v $
 
set -e
#
#  
#
encode=yes
sign=yes
micclearupdate=yes
miconly=yes
encr=yes
encrypt=yes

testtree=TestTree
if [ "$TESTTREE" != "" ]; then
	testtree=$TESTTREE
fi


for par do case $par in
        -v)
		v=$par;;
        -1)
		encode=$par;;
        -2)
		sign=$par;;
        -3)
		micclearupdate=$par;;
        -4)
		miconly=$par;;
        -5)
		encr=$par;;
        -6)
		encrypt=$par;;
        -h)
                echo ""
                echo "SecuDE-4.4                      (c)1993 GMD Darmstadt"
                echo ""
                echo "test_TestTree tests some utilities using the TestTree"
                echo "                en/decode sign/verify pem en/decrypt."
                echo "usage:"
                echo "test_TestTree [-v] [-h]"
                echo "with:"
                echo "-v             verbose"
                echo "-h             this help text"
                echo ""
                echo "test_test_tree needs about 200 sec on a Sun SPARC10-41."
                exit;;
esac done

cd
cd $testtree
HOME=`pwd`
export HOME

CAPIN=test
USERPIN=test
export USERPIN CAPIN


if [ "$encode" = "yes" ]; then

	echo "---------------Testing encode/decode-------------------"
	echo " "
	echo "SecuDE test file." > test
	echo "SecuDE test file." > test.cmp
	
	echo " "
	echo "     Encoding."
	encode test test.cod
	cat test.cod
	echo " "
	echo "     Decoding."
	decode test.cod test
	
	
	echo " "
	echo "     Comparing with original file."
	if cmp test test.cmp; then
		echo "Decoding OK."
	else
		echo "Decoding NOT OK."
		echo "SecuDE test file." > test
	fi
	
	echo "SecuDE test file." > test
	echo "SecuDE test file." > test.cmp
	
	echo " "
	echo "     Encoding."
	encode -x test test.cod
	cat test.cod
	
	echo " "
	echo "     Decoding."
	decode -x test.cod test
	
	
	echo " "
	echo "     Comparing with original file."
	if cmp test test.cmp; then
		echo "Decoding OK."
	else
		echo "Decoding NOT OK."
		echo "SecuDE test file." > test
	fi
fi	
	
if [ "$sign" = "yes" ]; then
	
	echo " "
	echo "---------------Testing sign/verify-------------------"
	echo " "
	echo "SecuDE test file." > test
	rm -f test.sig test.ctf
	
	
	for n in "-p org1usr1" "-c org1"
	do
		echo " "
		echo "     Signing ($n)."
		sign $v $n test
	
		echo " "
		echo "     Verifiing ($n)."
		verify $v $n test
	
		rm -f test.sig
	
		echo " "
		echo "     Signing with -C ($n)."
		sign $v -C $n test
		for m in "-p org1usr1" "-c org2" "-c rootca"
		do
			echo " "
			echo "     Verifiing ($m)."
			verify $v $m test
		done
		rm -f test.sig test.ctf
	done
fi

	
if [ "$micclearupdate" = "yes" ]; then
	
	echo "SecuDE test file." > test
	
	echo " "
	echo "---------------Testing PEM mic-clear\scan with updating PKList-------------------"
	echo " "
	
	for n in "-p org1usr1" "-p org1usr2" "-p org2usr1" "-p org2usr2" "-c org1" "-c org2" "-c rootca"
	do
		echo ""
		echo "     Creating PEM mic-clear message ($n)."
		pem mic-clear -C $v $n -i test -o test.pem
	
		for m in "-p org1usr1" "-p org1usr2" "-p org2usr1" "-p org2usr2" "-c org1" "-c org2" "-c rootca"
		do
			if [ "$n" != "$m" ]; then
				echo ""
				echo "     Scaning PEM message and update PKList ($m)."
				pem $v $m -i test.pem -o test.clr -u yes
			fi
		done
	done
	
fi

	
if [ "$miconly" = "yes" ]; then
	
	echo " "
	echo "---------------Testing PEM mic-only -------------------"
	echo " "

	echo "SecuDE test file." > test

	for n in "-p org1usr1" "-c org2" "-c rootca"
	do
		echo " "
		echo "     pem mic-only ($n)."
		pem mic-only $v $n -i test -o test.pem
		for m in "-p org2usr1" "-c org1"
		do
			if [ "$n" != "$m" ]; then
				echo ""
				echo "     Scaning PEM message ($m)."
				pem $v $m -i test.pem -o test.clr -u no
			fi
		done
	
	done
	
fi

	
if [ "$encr" = "yes" ]; then
	
	echo " "
	echo "---------------Testing PEM encrypted -------------------"
	echo " "

	echo "SecuDE test file." > test

	for n in "-p org2usr1" "-c org1"  
	do
		echo " "
		echo "     pem encrypted ($n) for C=DE, O=ORG-2."
		pem encrypted $v $n -i test -o test.pem -r "C=DE, O=ORG-2" 
		echo " "
		echo "     Scaning PEM message (-c org2) ."
		pem $v -c org2 -i test.pem -o test.clr -u no
	
		echo " "
		echo "     pem encrypted ($n) for C=DE, O=ORG-1, CN=User-1."
		pem encrypted $v $n -i test -o test.pem -r "C=DE, O=ORG-1, CN=User-1" 
		echo " "
		echo "     Scaning PEM message (-p org1usr1) ."
		pem $v -p org1usr1 -i test.pem -o test.clr -u no
	
		echo " "
		echo "     pem encrypted ($n) for C=DE, O=Root-CA."
		pem encrypted $v $n -i test -o test.pem -r "C=DE, O=Root-CA" 
		echo " "
		echo "     Scaning PEM message (-c rootca) ."
		pem $v -c rootca -i test.pem -o test.clr -u no
	
		echo " "
		echo "     pem encrypted ($n) for C=DE, O=Root-CA ; C=DE, O=ORG-2 and C=DE, O=ORG-1, CN=User-1."
		pem encrypted $v $n -i test -o test.pem -r "C=DE, O=Root-CA" "C=DE, O=ORG-2" "C=DE, O=ORG-1, CN=User-1"
		echo " "
		echo "     Scaning PEM message (-c rootca) ."
		pem $v -c rootca -i test.pem -o test.clr -u no
		echo " "
		echo "     Scaning PEM message (-p org1usr1) ."
		pem $v -p org1usr1 -i test.pem -o test.clr -u no
		echo " "
		echo "     Scaning PEM message (-c org2) ."
		pem $v -c org2 -i test.pem -o test.clr -u no
	
	done
fi

if [ "$encrypt" = "yes" ]; then
	
	echo " "
	echo "---------------Testing encrypt\decrypt-------------------"
	echo " "
	
	echo "SecuDE test file." > test
	echo "SecuDE test file." > test.cmp
	
	for key in "-x -e 0123456789abcdef" "-x -e fedcba9876543210" "-e Bubble_Gum" "-e Queen_Elizabeth"
	do
		echo " "
		echo "     Encrypting ($key)."
		encrypt $key test
			
		echo " "
		echo "     Decrypting ($key)."
		decrypt $key test
			
		echo " "
		echo "     Comparing with original file."
		if cmp test test.cmp; then
			echo "Decryption OK."
		else
			echo "Decryption NOT OK."
			echo "SecuDE test file." > test
		fi
	done
	
	for hybrid in "" "-n"
	do
		echo " "
		echo " "
		if [ "$hybrid" = "" ]; then
			echo "Encryption using hybrid method"
		else
			echo "Encryption without hybrid method"
		fi
		echo " "
	
		for n in "-p org1usr1" "-c org1"
		do
		
			echo " "
			echo "     Encrypting ($n)."
			encrypt $hybrid $v $n test
		
			echo " "
			echo "     Decrypting ($n)."
			decrypt $hybrid $v $n test
		
			echo " "
			echo "     Comparing with original file."
			if cmp test test.cmp; then
				echo "Decryption OK."
			else
				echo "Decryption NOT OK."
				echo "SecuDE test file." > test
			fi
		
		done
		
		echo " "
		echo "     Encrypting (-c rootca) for C=DE, O=ORG-1."
		encrypt $hybrid $v -c rootca -r "C=DE, O=ORG-1" test
		
		echo " "
		echo "     Decrypting by ORG-1."
		decrypt $hybrid $v -c org1 test
		
		echo " "
		echo "     Comparing with original file."
		if cmp test test.cmp; then
			echo "Decryption OK."
		else
			echo "Decryption NOT OK."
			echo "SecuDE test file." > test
		fi
		
		
		echo " "
		echo "     Encrypting (-c rootca) for C=DE, O=ORG-1, CN=User-1."
		encrypt $hybrid $v -c rootca -r "C=DE, O=ORG-1, CN=User-1" test
		
		echo " "
		echo "     Decrypting by C=DE, O=ORG-1, CN=User-1."
		decrypt $hybrid $v -p org1usr1 test
		
		echo " "
		echo "     Comparing with original file."
		if cmp test test.cmp; then
			echo "Decryption OK."
		else
			echo "Decryption NOT OK."
			echo "SecuDE test file." > test
		fi
		
		
		echo " "
		echo "     Encrypting (-c org1) for C=DE, O=Root-CA."
		encrypt $hybrid $v -c org1 -r "C=DE, O=Root-CA" test
		
		echo " "
		echo "     Decrypting by C=DE, O=Root-CA."
		decrypt $hybrid $v -c rootca test
		
		echo " "
		echo "     Comparing with original file."
		if cmp test test.cmp; then
			echo "Decryption OK."
		else
			echo "Decryption NOT OK."
			echo "SecuDE test file." > test
		fi
		
		
		echo " "
		echo "     Encrypting (-c org1) for C=DE, O=ORG-2."
		encrypt $hybrid $v -c org1 -r "C=DE, O=ORG-2" test
		
		echo " "
		echo "     Decrypting by C=DE, O=ORG-2."
		decrypt $hybrid $v -c org2 test
		
		echo " "
		echo "     Comparing with original file."
		if cmp test test.cmp; then
			echo "Decryption OK."
		else
			echo "Decryption NOT OK."
			echo "SecuDE test file." > test
		fi
		
		
		echo " "
		echo "     Encrypting (-c org1) for C=DE, O=ORG-1, CN=User-1."
		encrypt $hybrid $v -c org1 -r "C=DE, O=ORG-1, CN=User-1" test
		
		echo " "
		echo "     Decrypting by C=DE, O=ORG-1, CN=User-1."
		decrypt $hybrid $v -p org1usr1 test
		
		echo " "
		echo "     Comparing with original file."
		if cmp test test.cmp; then
			echo "Decryption OK."
		else
			echo "Decryption NOT OK."
			echo "SecuDE test file." > test
		fi
		
		
		echo " "
		echo "     Encrypting (-c org1) for C=DE, O=ORG-2, CN=User-2."
		encrypt $hybrid $v -c org1 -r "C=DE, O=ORG-2, CN=User-2" test
		
		echo " "
		echo "     Decrypting by C=DE, O=ORG-2, CN=User-2."
		decrypt $hybrid $v -p org2usr2 test
		
		echo " "
		echo "     Comparing with original file."
		if cmp test test.cmp; then
			echo "Decryption OK."
		else
			echo "Decryption NOT OK."
			echo "SecuDE test file." > test
		fi
		
		
		echo " "
		echo "     Encrypting (-p org1usr1) for C=DE, O=Root-CA."
		encrypt $hybrid $v -p org1usr1 -r "C=DE, O=Root-CA" test
		
		echo " "
		echo "     Decrypting by C=DE, O=Root-CA."
		decrypt $hybrid $v -c rootca test
		
		echo " "
		echo "     Comparing with original file."
		if cmp test test.cmp; then
			echo "Decryption OK."
		else
			echo "Decryption NOT OK."
			echo "SecuDE test file." > test
		fi
		
		
		echo " "
		echo "     Encrypting (-p org1usr1) for ORG-1."
		encrypt $hybrid $v -p org1usr1 -r "C=DE, O=ORG-1" test
		
		echo " "
		echo "     Decrypting by ORG-1."
		decrypt $hybrid $v -c org1 test
		
		echo " "
		echo "     Comparing with original file."
		if cmp test test.cmp; then
			echo "Decryption OK."
		else
			echo "Decryption NOT OK."
			echo "SecuDE test file." > test
		fi
		
		
		echo " "
		echo "     Encrypting (-p org1usr1) for ORG-2."
		encrypt $hybrid $v -p org1usr1 -r "C=DE, O=ORG-2" test
		
		echo " "
		echo "     Decrypting by ORG-2."
		decrypt $hybrid $v -c org2 test
		
		echo " "
		echo "     Comparing with original file."
		if cmp test test.cmp; then
			echo "Decryption OK."
		else
			echo "Decryption NOT OK."
			echo "SecuDE test file." > test
		fi
		
		
		echo " "
		echo "     Encrypting (-p org1usr1) for C=DE, O=ORG-1, CN=User-2."
		encrypt $hybrid $v -p org1usr1 -r "C=DE, O=ORG-1, CN=User-2" test
		
		echo " "
		echo "     Decrypting by C=DE, O=ORG-1, CN=User-2."
		decrypt $hybrid $v -p org1usr2 test
		
		echo " "
		echo "     Comparing with original file."
		if cmp test test.cmp; then
			echo "Decryption OK."
		else
			echo "Decryption NOT OK."
			echo "SecuDE test file." > test
		fi
		
		
		echo " "
		echo "     Encrypting (-p org1usr1) for C=DE, O=ORG-2, CN=User-2."
		encrypt $hybrid $v -p org1usr1 -r "C=DE, O=ORG-2, CN=User-2" test
		
		echo " "
		echo "     Decrypting by C=DE, O=ORG-2, CN=User-2."
		decrypt $hybrid $v -p org2usr2 test
		
		echo " "
		echo "     Comparing with original file."
		if cmp test test.cmp; then
			echo "Decryption OK."
		else
			echo "Decryption NOT OK."
			echo "SecuDE test file." > test
		fi
	
	
	done
fi	

rm -f test.*
