/* ./src/util/xmsectool/ae_dialog.c */

static char *rcsid = "$Id: ae_dialog.c,v 1.8 1995/01/30 13:14:27 koletzki Exp $";

/*
 * $Id: ae_dialog.c,v 1.8 1995/01/30 13:14:27 koletzki Exp $
 *
 * $Log: ae_dialog.c,v $
 *
 */
 
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/





/*
 ************************
 *	INCLUDES	*
 ************************
 */

#include "xmst.h"




/*
 ************************
 *	statics		*
 ************************
 */
static char		*last_search_pattern = CNULL;

#ifdef __STDC__
	
        static void	alias_add_callbacks	();
        static void	alias_check_aliaslist	();
        static void	alias_fill_list	();
        static void	alias_fill_textfields	();
        static int	alias_find_pattern	(char *init_string);
        static void	otheraliases_dialog_open	();
       
#else
      
	static int		alias_find_pattern();
	static void		alias_add_callbacks();
	static void		alias_check_aliaslist();
	static void		alias_fill_list();
	static void		alias_fill_textfields();
	static void		otheraliases_dialog_open();

#endif




/***************************************************************
 *
 * Procedure alias_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void alias_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void alias_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	char				*proc = "alias_dialog_cb";
	XmSelectionBoxCallbackStruct	*cbs;


	XmUpdateDisplay(applicationShell);
	
	cbs = (XmSelectionBoxCallbackStruct *)callback_data;
	
	switch (cbs->reason) {

		case XmCR_OK:
		case XmCR_CANCEL:
		case XmCR_PROTOCOLS:

			/*
			 *	refresh SecTool widgets if AliasList has been changed
			 *	but don't apply to PSE here!
			 */
			if (alias_save_required) st_fill_widgets();
		
			XtUnmanageChild(widget);
			XtUnmanageChild(ADWIDGET("*cont_show_dialog"));
			XtUnmanageChild(ADWIDGET("*otheraliases_dialog"));
			XtUnmanageChild(name2widget(ADWIDGET("*otheraliases_dialog"), "*ok_dialog"));
			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}
	
	dialog_finished = TRUE;
}




/***************************************************************
 *
 * Procedure alias_file_toggle_cb
 *
 ***************************************************************/
#ifdef __STDC__

void alias_file_toggle_cb(
	Widget				  widget,
	char				 *tag,
	XmToggleButtonCallbackStruct	 *callback_data
)

#else

void alias_file_toggle_cb(
	widget,
	tag,
	callback_data
)
Widget				  widget;
char				 *tag;
XmToggleButtonCallbackStruct	 *callback_data;

#endif

{
	static unsigned			last_file_setting_value = XMST_ALIAS_USER;
	static Boolean			ignore = FALSE;

	unsigned			file_setting_value = XMST_NONE;


	if (!XtIsSensitive(ADWIDGET("*alias_system_toggle"))) {		/* No system alias file */
	
		XmToggleButtonSetState(ADWIDGET("*alias_user_toggle"), TRUE, FALSE);
		
		return;
	}

	if (!ignore) {		/* ignore self-generated events */

		if (XmToggleButtonGetState(ADWIDGET("*alias_user_toggle")))
			file_setting_value = XMST_ALIAS_USER;
		if (XmToggleButtonGetState(ADWIDGET("*alias_system_toggle"))) {
	
			if (file_setting_value == XMST_ALIAS_USER)
				file_setting_value = XMST_ALIAS_BOTH;
			else file_setting_value = XMST_ALIAS_SYSTEM;
		}
	
		if (file_setting_value == XMST_NONE) {
	
			if (last_file_setting_value == XMST_ALIAS_SYSTEM) {
	
				ignore = TRUE;
				last_file_setting_value = XMST_ALIAS_USER;
				XmToggleButtonSetState(ADWIDGET("*alias_user_toggle"), TRUE, TRUE);
				
				return;
			}
			if (last_file_setting_value == XMST_ALIAS_USER) {
	
				ignore = TRUE;
				last_file_setting_value = XMST_ALIAS_SYSTEM;
				XmToggleButtonSetState(ADWIDGET("*alias_system_toggle"), TRUE, TRUE);
				
				return;
			}
			
		} else last_file_setting_value = file_setting_value;
	}

	ignore = FALSE;

	if (last_search_pattern) free (last_search_pattern);
	last_search_pattern = CNULL;

	alias_fill_list();

}


/***************************************************************
 *
 * Procedure alias_type_toggle_cb
 *
 ***************************************************************/
#ifdef __STDC__

void alias_type_toggle_cb(
	Widget				  widget,
	char				 *tag,
	XmToggleButtonCallbackStruct	 *callback_data
)

#else

void alias_type_toggle_cb(
	widget,
	tag,
	callback_data
)
Widget				  widget;
char				 *tag;
XmToggleButtonCallbackStruct	 *callback_data;

#endif

{
	static Widget			last_widget = (Widget)NULL;


	/* RadioBox behaviour: there can be only one... ignore unset / same state */

	if (last_widget == widget) return;

	last_widget = widget;

	if (callback_data->set) alias_fill_list();

}



/***************************************************************
 *
 * Procedure alias_find_cb
 *
 ***************************************************************/
#ifdef __STDC__

void alias_find_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void alias_find_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	char			*pattern;
	char			*client_data;


	XtVaGetValues(	aliasList,
			XmNuserData, 	&client_data,
			NULL);

	pattern = XmTextGetString(ADWIDGET("*alias_find_textfield"));

	if (pattern) {

		if (last_search_pattern && !strcmp(pattern, last_search_pattern))
			alias_find_pattern(client_data);
		else alias_find_pattern(CNULL);

		if (last_search_pattern) free(last_search_pattern);
		last_search_pattern = aux_cpy_String(pattern);
	}
}


/***************************************************************
 *
 * Procedure alias_apply_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void alias_apply_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void alias_apply_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	if (alias_save_required) {

		BUSY_CURSOR();

		/* write alias list to user's file */
		aux_put_AliasList(useralias);
		alias_save_required = FALSE;
	
		/* apply edits to sectool */
		st_fill_widgets();

		alias_fill_list();
		alias_fill_textfields();
		
		IDLE_CURSOR();

	} else ALARM();
}



/***************************************************************
 *
 * Procedure alias_reset_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void alias_reset_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void alias_reset_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	char			*proc = "alias_reset_handler";


	if (alias_save_required
	    && !cont_canc_dialog_open(	aliasDialog,
	    	"AliasList has been changed!\nYou may continue and discard edits\nor cancel reset."))  {
			
			return;
	}
	alias_save_required = FALSE;

	if (!aux_get_AliasList())  {

		cont_quit_dialog_open(aliasDialog, "Can't read AliasList.");

	} else alias_check_aliaslist();

	alias_fill_list();
}



/***************************************************************
 *
 * Procedure alias_clear_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void alias_clear_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void alias_clear_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	char			*client_data;


	XtVaGetValues(	aliasList,
			XmNuserData, 	&client_data,
			NULL);

	if (client_data) {

		XtVaSetValues(	aliasList,
				XmNuserData, 	CNULL,
				NULL);

		alias_fill_list();

	} else alias_fill_textfields();
}



/***************************************************************
 *
 * Procedure alias_insert_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void alias_insert_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void alias_insert_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	char				*proc = "alias_insert_drawnbutton_cb";
	char				*name;
	DName				*dname;
	char				*localnamealias;
	char				*rfcmailalias;
	char				*x400mailalias;
	Boolean				do_refresh = FALSE;


	/* adding new dname with at least one alias */
	name = aux_cpy_ReducedString(XmTextGetString(ADWIDGET("*alias_dname_textfield")));

	if (!name)  {

		ok_dialog_open(aliasDialog, "DName textfield is empty.");

		return;
	}

	dname = aux_Name2DName(name);
	if (!dname)  {

		ok_dialog_open(aliasDialog, "DName field represents no distinguished name.");
		if (name) free(name);

		return;
	}

	if (aux_alias_chkfile(name, useralias))  {

		ok_dialog_open(aliasDialog, "User's DName entry exists.\nUse Change function!");
		if (name) free(name);

		return;
	}

	localnamealias = aux_cpy_ReducedString(XmTextGetString(ADWIDGET("*alias_localname_textfield")));
	rfcmailalias = aux_cpy_ReducedString(XmTextGetString(ADWIDGET("*alias_rfcmail_textfield")));
	x400mailalias = aux_cpy_ReducedString(XmTextGetString(ADWIDGET("*alias_x400mail_textfield")));

	if (localnamealias)  {

		if (aux_alias(localnamealias) != notstored)
			ok_dialog_open(aliasDialog, "Local Name alias already exists.");
		else  {

			aux_add_alias(localnamealias, dname, useralias, TRUE, FALSE);
			do_refresh = TRUE;
		}
	}

	if (rfcmailalias)  {

		if (aux_alias(rfcmailalias) != notstored)
			ok_dialog_open(aliasDialog, "Internet Mail alias already exists.");
		else  {

			aux_add_alias(rfcmailalias, dname, useralias, TRUE, FALSE);
			do_refresh = TRUE;
		}
	}

	if (x400mailalias)  {

		if (aux_alias(x400mailalias) != notstored)
			ok_dialog_open(aliasDialog, "X400 Mail alias already exists.");
		else  {

			aux_add_alias(x400mailalias, dname, useralias, TRUE, FALSE);
			do_refresh = TRUE;
		}
	}
	
	if (do_refresh)  {

		XtVaGetValues(	aliasList,
				XmNuserData, 	(char *)name,
				NULL);

		alias_save_required = TRUE;

		alias_fill_list();

	} else ok_dialog_open(aliasDialog, "Can't add DName entry.\nEnter at least one new alias!");

	if (name) free(name);
	if (dname) aux_free_DName(&dname);
	if (localnamealias) free(localnamealias);
	if (rfcmailalias) free(rfcmailalias);
	if (x400mailalias) free(rfcmailalias);
}



/***************************************************************
 *
 * Procedure alias_change_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void alias_change_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void alias_change_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	char			*proc = "alias_change_drawnbutton_cb";
	char			*client_data;
	char			*name;
	DName			*dname;
	char			*old_localnamealias;
	char			*old_rfcmailalias;
	char			*old_x400mailalias;
	char			*localnamealias;
	char			*rfcmailalias;
	char			*x400mailalias;
	Boolean			do_refresh = FALSE;


	XtVaGetValues(	aliasList,
			XmNuserData, &client_data,
			NULL);

	if (!client_data) {

		ALARM();

		return;
	}

	name = aux_cpy_ReducedString(XmTextGetString(ADWIDGET("*alias_dname_textfield")));

	if (!name)  {

		ok_dialog_open(aliasDialog, "DName textfield is empty.");

		return;
	}
	dname = aux_Name2DName(name);
	if (!dname)  {

		ok_dialog_open(aliasDialog, "DName field represents no distinguished name.");
		if (name) free(name);

		return;
	}

	if (aux_cmp_Name(client_data, name))  {

		ok_dialog_open(aliasDialog, "DName field has changed.\nUse Insert function!");
		if (name) free(name);

		return;
	}


	/* insert new aliases on top of dname's alias list, delete old user aliases */	
	XtVaGetValues(	ADWIDGET("*alias_localname_textfield"),
			XmNuserData, 	&old_localnamealias,
			XmNvalue, 	&localnamealias,
			NULL);

	XtVaGetValues(	ADWIDGET("*alias_rfcmail_textfield"),
			XmNuserData, 	&old_rfcmailalias,
			XmNvalue, 	&rfcmailalias,
			NULL);

	XtVaGetValues(	ADWIDGET("*alias_x400mail_textfield"),
			XmNuserData, 	&old_x400mailalias,
			XmNvalue, 	&x400mailalias,
			NULL);

	localnamealias = aux_cpy_ReducedString(localnamealias);
	rfcmailalias = aux_cpy_ReducedString(rfcmailalias);
	x400mailalias = aux_cpy_ReducedString(x400mailalias);

	if (!localnamealias && !rfcmailalias && !x400mailalias)  {

		sprintf(dialog_message,	"%s%s%s",
					"Can't change DName entry.\n",
					"Enter at least one alias\n",
					"or use Delete function!");
		ok_dialog_open(aliasDialog, dialog_message);
		if (name) free(name);
		if (dname) aux_free_DName(&dname);
		if (localnamealias) free(localnamealias);
		if (rfcmailalias) free(rfcmailalias);
		if (x400mailalias) free(x400mailalias);

		return;
	}

	if ((!localnamealias && strcmp(old_localnamealias, ""))
	   || (localnamealias && strcmp(old_localnamealias, localnamealias)))  {

		if (localnamealias && aux_alias(localnamealias) != notstored)  {

			ok_dialog_open(aliasDialog, "Local name already exists.");
			if (name) free(name);
			if (dname) aux_free_DName(&dname);
			if (localnamealias) free(localnamealias);
			if (rfcmailalias) free(rfcmailalias);
			if (x400mailalias) free(x400mailalias);

			return;
		}

		if (localnamealias) aux_add_alias(localnamealias, dname, useralias, TRUE, FALSE);
		aux_delete_alias(old_localnamealias, useralias, FALSE);

		do_refresh = TRUE;
	}

	if ((!rfcmailalias && strcmp(old_rfcmailalias, ""))
	   || (rfcmailalias && strcmp(old_rfcmailalias, rfcmailalias)))  {

		if (rfcmailalias && aux_alias(rfcmailalias) != notstored)  {

			ok_dialog_open(aliasDialog, "Internet Mail address already exists.");
			if (name) free(name);
			if (dname) aux_free_DName(&dname);
			if (localnamealias) free(localnamealias);
			if (rfcmailalias) free(rfcmailalias);
			if (x400mailalias) free(x400mailalias);

			return;
		}

		if (rfcmailalias) aux_add_alias(rfcmailalias, dname, useralias, TRUE, FALSE);
		aux_delete_alias(old_rfcmailalias, useralias, FALSE);

		do_refresh = TRUE;
	}

	if ((!x400mailalias && strcmp(old_x400mailalias, ""))
	   || (x400mailalias && strcmp(old_x400mailalias, x400mailalias)))  {

		if (x400mailalias && aux_alias(x400mailalias) != notstored)  {

			ok_dialog_open(aliasDialog, "X.400 Mail address already exists.");
			if (name) free(name);
			if (dname) aux_free_DName(&dname);
			if (localnamealias) free(localnamealias);
			if (rfcmailalias) free(rfcmailalias);
			if (x400mailalias) free(x400mailalias);

			return;
		}

		if (x400mailalias) aux_add_alias(x400mailalias, dname, useralias, TRUE, FALSE);
		aux_delete_alias(old_x400mailalias, useralias, FALSE);

		do_refresh = TRUE;
	}

	if (name) free(name);
	aux_free_DName(&dname);
	if (localnamealias) free(localnamealias);
	if (rfcmailalias) free(rfcmailalias);
	if (x400mailalias) free(x400mailalias);

	if (do_refresh)  {

		alias_save_required = TRUE;

		alias_fill_list();
	}
}



/***************************************************************
 *
 * Procedure alias_delete_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void alias_delete_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void alias_delete_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	char			*proc = "alias_delete_drawnbutton_cb";
	char			*client_data;
	char			*alias;

	
	XtVaGetValues(	aliasList,
			XmNuserData, 	&client_data,
			NULL);

	if (!client_data) {

		ALARM();

		return;
	}

	if (!aux_alias_chkfile(client_data, useralias))  {

		sprintf(dialog_message, "No User aliases stored for\n%s", client_data);
		ok_dialog_open(aliasDialog, dialog_message);

		return;
	}

	sprintf(dialog_message, "Delete User's DName entry for\n%s ?", client_data);
	if (! cont_canc_dialog_open(aliasDialog, dialog_message)) {

		return;
	}

	while (alias = aux_Name2aliasf(client_data, ANYALIAS, useralias))
		if (aux_delete_alias(alias, useralias, FALSE) < 0) break;

	XtVaSetValues(	aliasList,
			XmNuserData, 	CNULL,
			NULL);

	alias_save_required = TRUE;

	alias_fill_list();
	alias_fill_textfields();
}




/***************************************************************
 *
 * Procedure alias_list_action_cb
 *
 ***************************************************************/
#ifdef __STDC__

void alias_list_action_cb(
	Widget			  widget,
	char			 *tag,
	XmListCallbackStruct	 *callback_data
)

#else

void alias_list_action_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmListCallbackStruct	 *callback_data;

#endif

{
	static char		*client_data;


	if (client_data) free(client_data);
	client_data = aux_cpy_String((char *)
			get_clientdata(aliaslist_clientdata, callback_data->item_position));

	switch (callback_data->reason) {

		case XmCR_BROWSE_SELECT:

			if (sectool_verbose) fprintf(stderr, "aliasList: XmCR_BROWSE_SELECT\n");

			XtVaSetValues(	widget,
					XmNuserData, 	client_data,
					NULL);

			alias_fill_textfields(); 

			break;

		case XmCR_DEFAULT_ACTION:

			if (sectool_verbose) fprintf(stderr, "aliasList: XmCR_DEFAULT_ACTION\n");

			otheraliases_dialog_open();

			break;

		default:

	 		if (sectool_verbose)
	 			fprintf(stderr, "aliasList: Oops - unknown callback reason!\n");
	}
 
}




/***************************************************************
 *
 * Procedure alias_otheraliases_pushbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void alias_otheraliases_pushbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void alias_otheraliases_pushbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	otheraliases_dialog_open();
}






/*
 *	Add callbacks to dialogs of alias tool toplevel window
 */
/***************************************************************
 *
 * Procedure alias_add_callbacks
 *
 ***************************************************************/
#ifdef __STDC__

static
void alias_add_callbacks(
)

#else

static
void alias_add_callbacks(
)

#endif

{

	/*
	 *	Add WM focus/delete callbacks for dialogs
	 */
	add_focus_callbacks(XmSelectionBoxGetChild(name2widget(aliasDialog, "*otheraliases_dialog"),
										XmDIALOG_TEXT));
		
	add_destroy_callback(aliasDialog, (caddr_t)alias_dialog_cb);			
	add_destroy_callback(ADWIDGET("*otheraliases_dialog"), (caddr_t)otheraliases_dialog_cb);			
	add_destroy_callback(name2widget(ADWIDGET("*otheraliases_dialog"), "*ok_dialog"),
								(caddr_t)ok_dialog_cb);
					
	add_destroy_callback(ADWIDGET("*ok_dialog"), (caddr_t)ok_dialog_cb);			
	add_destroy_callback(ADWIDGET("*cont_quit_dialog"), (caddr_t)error_dialog_cb);			
	add_destroy_callback(ADWIDGET("*cont_canc_dialog"), (caddr_t)warning_dialog_cb);			
	add_destroy_callback(ADWIDGET("*save_loose_dialog"), (caddr_t)warning_dialog_cb);			
	add_destroy_callback(ADWIDGET("*cont_show_dialog"), (caddr_t)warning_dialog_cb);			
}




/*
 * 	Open alias dialog, read AliasList, init panels
 */
/***************************************************************
 *
 * Procedure alias_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

void alias_dialog_open(
)

#else

void alias_dialog_open(
)

#endif

{
	char			*proc = "alias_dialog_open";
	AliasList		*sys_alist;


	if (!aliasDialog) {
	
		aliasDialog = STWIDGET("*alias_dialog");
		
		MANAGE_MODELESS_DIALOG(aliasDialog);
		THINK_CURSOR();
		
		alias_add_callbacks();
		
		aliasList = ADWIDGET("*alias_list");
				
		alias_check_aliaslist();
		
		if (! (sys_alist = aux_select_AliasList(systemalias)))
			XtSetSensitive(ADWIDGET("*alias_system_toggle"), FALSE);
		else aux_free_AliasList(&sys_alist);
	
		XtVaSetValues(	aliasList,
				XmNuserData, 	CNULL,
				NULL);
	
		alias_fill_list();	
		
		READY_CURSOR();
	
	} else {
	
		THINK_CURSOR();
		
		MANAGE_MODELESS_DIALOG(aliasDialog);
		
		alias_fill_list();	
		
		READY_CURSOR();
	}
}



/*
 * 	check AliasList
 */
/***************************************************************
 *
 * Procedure alias_check_aliaslist
 *
 ***************************************************************/
#ifdef __STDC__

static
void alias_check_aliaslist(
)

#else

static
void alias_check_aliaslist(
)

#endif

{
	char			*proc = "alias_check_aliaslist";

	
	if (sectool_verbose)  fprintf(stderr, "--> %s\n", proc);

	if (open_write_tempfile(aliasDialog) >= 0)  {

		if (!aux_check_AliasList(logfile)) {

			close_tempfile();
			sprintf(dialog_message, "%s%s%s%s",
				"         Some double aliases were found!\n",
				"This may confuse (but not really bother) SecTool.\n",
				"If the System Alias List is stable now, you can\n",
				"     delete twins in your PSE's Alias List.");

			if (cont_show_dialog_open(aliasDialog, dialog_message)) {
			
				/* manage viewer to avoid usage of external editor */
				MANAGE_MODELESS_DIALOG(STWIDGET("*viewer_dialog"));
				start_editor();
			}

		}
		remove_tempfile();

	} else aux_check_AliasList(stderr);
}


/* 
 *	 fill alias_list
 */
/***************************************************************
 *
 * Procedure alias_fill_list
 *
 ***************************************************************/
#ifdef __STDC__

static
void alias_fill_list(
)

#else

static
void alias_fill_list(
)

#endif

{
	char				*proc = "alias_fill_list";
	int				i;
	AliasFile			current_afile;
	unsigned			file_setting_value = XMST_NONE;
	unsigned			type_setting_value = XMST_NONE;
	Boolean				dname_in_both_files;
	char				*client_data;
	Name				*al_name;		
	char				*al_alias;
	char				alias_string[33];
	char				name_string[XMST_ALIASLISTSTR_LENGTH + 1];
	int				selected_row = 0;
	char				*fill = "";
	char				*dummy = "     ???";
	XmString			cmpdstring, cmpdalias, cmpdname;


	if (sectool_verbose)  fprintf(stderr, "--> %s\n", proc);

	if (XmToggleButtonGetState(ADWIDGET("*alias_user_toggle")))
		file_setting_value = XMST_ALIAS_USER;
	if (XmToggleButtonGetState(ADWIDGET("*alias_system_toggle"))) {

		if (file_setting_value == XMST_ALIAS_USER) file_setting_value = XMST_ALIAS_BOTH;
		else file_setting_value = XMST_ALIAS_SYSTEM;
	}

	if (XmToggleButtonGetState(ADWIDGET("*alias_localname_toggle")))
		type_setting_value = XMST_ALIAS_LOCALNAME;
	if (XmToggleButtonGetState(ADWIDGET("*alias_nextbest_toggle")))
		type_setting_value = XMST_ALIAS_NEXTBEST;
	if (XmToggleButtonGetState(ADWIDGET("*alias_rfcmail_toggle")))
		type_setting_value = XMST_ALIAS_RFCMAIL;
	if (XmToggleButtonGetState(ADWIDGET("*alias_x400mail_toggle")))
		type_setting_value = XMST_ALIAS_X400MAIL;

	/* check which (if any) list item is selected */
	XtVaGetValues(	aliasList,
			XmNuserData, 	&client_data,
			NULL);

	/* Clear List */
	
	XmListDeleteAllItems(aliasList);
	init_clientdata(aliaslist_clientdata);
	XtVaSetValues(	aliasList,
			XmNuserData, 	CNULL,
			NULL);



	/*
         *	Read all DNames from aliaslist->dname, get alias
         */

	for (i = 0; i < 2; i++)  {

		current_afile = (i == 0) ? useralias : systemalias; 

		if ( (file_setting_value == XMST_ALIAS_USER && current_afile == systemalias)
		    || (file_setting_value == XMST_ALIAS_SYSTEM && current_afile == useralias)) {
		    
		    	continue;
		}

		al_name = aux_alias_nxtname(TRUE);

		while (al_name) {

			if (!aux_alias_chkfile(al_name, current_afile))  {

				if (al_name) free(al_name);
				al_name = aux_alias_nxtname(FALSE);
				continue;
			}

			/* read demanded alias or next best */
			switch(type_setting_value)  {

				case XMST_ALIAS_LOCALNAME:

					al_alias = aux_Name2aliasf(al_name, LOCALNAME, current_afile);
					break;

				case XMST_ALIAS_RFCMAIL:

					al_alias = aux_Name2aliasf(al_name, RFCMAIL, current_afile);
					break;

				case XMST_ALIAS_X400MAIL:

					al_alias = aux_Name2aliasf(al_name, X400MAIL, current_afile);
					break;

				case XMST_ALIAS_NEXTBEST:

					al_alias = aux_Name2aliasf(al_name, ANYALIAS, current_afile);
					break;
			}

			if (!al_alias) {

				/* another type of alias ? */
				if (al_alias = aux_Name2aliasf(al_name, ANYALIAS, current_afile)) {

					free(al_alias);
					al_alias = aux_cpy_String(dummy);
				}
			}

			/* Format element length <= XMST_ALIASLISTSTR_LENGTH ! */
			sprintf(alias_string, "%-23.23s%2s", al_alias, fill);
			sprintf(name_string, "%s", al_name);
				
			/*
			 *	display dname with bold fixed font if dname is in both alias files
			 */

			cmpdname = (XmString)NULL;
			dname_in_both_files = (aux_alias_chkfile(al_name, useralias)
						&& aux_alias_chkfile(al_name, systemalias));

			if ((dname_in_both_files && (current_afile == useralias))
			    || (dname_in_both_files && (current_afile == systemalias)
			        && (file_setting_value == XMST_ALIAS_SYSTEM)) ) {

				cmpdname = CPDSTRINGBOLD(name_string);

			}
			else if (current_afile == useralias
				|| (!dname_in_both_files && (current_afile == systemalias))) {

				cmpdname = CPDSTRINGFIXED(name_string);

			}

			/* Don't display double DNames twice */
			if (cmpdname) {

				if (current_afile == useralias)
					cmpdalias = CPDSTRINGBOLD(alias_string);
				else cmpdalias = CPDSTRINGFIXED(alias_string);
				
				cmpdstring = XmStringConcat(cmpdalias, cmpdname);

				if (append_clientdata(aliaslist_clientdata, (XtPointer)al_name))
					XmListAddItem(aliasList, cmpdstring, 0);

				if (client_data && !strcmp(client_data, al_name))
					selected_row = count_clientdata(aliaslist_clientdata);

				XmStringFree(cmpdstring);
				XmStringFree(cmpdname);
				XmStringFree(cmpdalias);
			}

			if (al_alias) free(al_alias);
			al_name = aux_alias_nxtname(FALSE);	/* don't free: user data! */
		}
	}

	if (selected_row > 0) {

		XmListSelectPos(aliasList, selected_row, TRUE);
		XmListSetBottomPos(aliasList, selected_row);

	} else XtUnmanageChild(ADWIDGET("*otheraliases_dialog"));	/* no selection */


	XmUpdateDisplay(applicationShell);
}


/* 
 *	 fill alias textfields
 */
/***************************************************************
 *
 * Procedure alias_fill_textfields
 *
 ***************************************************************/
#ifdef __STDC__

static
void alias_fill_textfields(
)

#else

static
void alias_fill_textfields(
)

#endif

{
	char				*proc = "alias_fill_textfields";
	char				*client_data;
	char				*user_data;
	char				*localnamealias;
	char				*rfcmailalias;
	char				*x400mailalias;
	DName				*dname;
	int				total_rows;
	char				*fill = "";
	char				*dummy = "";
	char				*divider = " : ";
	int				menu_row;
	char				*alias_string;
	char				*alias;
	XmString			otheraliases_list[XMST_MAX_OTHERALIASES];
	int				item = 0;


	if (sectool_verbose)  fprintf(stderr, "--> %s\n", proc);


	XtVaGetValues(	aliasList,
			XmNuserData, 	&client_data,
			NULL);

	if (!client_data)  {

		name = aux_cpy_String("");
		localnamealias = aux_cpy_String("");
		rfcmailalias = aux_cpy_String("");
		x400mailalias = aux_cpy_String("");
		
		XtUnmanageChild(ADWIDGET("*otheraliases_dialog"));

	} else  {

		dname = aux_Name2DName(client_data);
	
		/* fill textfields */

		name = aux_cpy_String(client_data);
		if (! (localnamealias = aux_DName2alias(dname, LOCALNAME)) )
			localnamealias = aux_cpy_String(dummy);
		if (! (rfcmailalias = aux_DName2alias(dname, RFCMAIL)) )
			rfcmailalias = aux_cpy_String(dummy);
		if (! (x400mailalias = aux_DName2alias(dname, X400MAIL)) )
			x400mailalias = aux_cpy_String(dummy);

		if (alias_string = aux_alias_getall(client_data)) {

			alias = strtok(alias_string, ":");

			do  {
				if (item >= XMST_MAX_OTHERALIASES) {

					sprintf(	dialog_message,
							"Too many aliases for DName\n\"%s\"",
							client_data);
					ok_dialog_open(aliasDialog, dialog_message);
		
					break;
				}
				otheraliases_list[item] = (aux_alias(alias) == useralias)
								? CPDSTRINGBOLD(alias)
								: CPDSTRINGFIXED(alias);

				item++;
				alias = strtok(CNULL, ":");
	
			} while (alias);

			free(alias_string);


			XtVaSetValues(	ADWIDGET("*otheraliases_dialog"),
					XmNlistItemCount, 	item,
					XmNlistItems, 		otheraliases_list,
					NULL);
		}
		aux_free_DName(&dname);
	}

	/* free old user data */
	XtVaGetValues(	ADWIDGET("*alias_dname_textfield"),
			XmNuserData, 	&user_data,
			NULL);
	if (user_data) free(user_data);

	XtVaGetValues(	ADWIDGET("*alias_localname_textfield"),
			XmNuserData, 	&user_data,
			NULL);
	if (user_data) free(user_data);

	XtVaGetValues(	ADWIDGET("*alias_rfcmail_textfield"),
			XmNuserData, 	&user_data,
			NULL);
	if (user_data) free(user_data);

	XtVaGetValues(	ADWIDGET("*alias_x400mail_textfield"),
			XmNuserData, 	&user_data,
			NULL);
	if (user_data) free(user_data);

	/* enter new user data */
	XtVaSetValues(	ADWIDGET("*alias_dname_textfield"),
			XmNuserData, 	(char *)name,
			XmNvalue, 	(char *)name,
			NULL);

	XtVaSetValues(	ADWIDGET("*alias_localname_textfield"),
			XmNuserData, 	(char *)localnamealias,
			XmNvalue, 	(char *)localnamealias,
			NULL);

	XtVaSetValues(	ADWIDGET("*alias_rfcmail_textfield"),
			XmNuserData, 	(char *)rfcmailalias,
			XmNvalue, 	(char *)rfcmailalias,
			NULL);

	XtVaSetValues(	ADWIDGET("*alias_x400mail_textfield"),
			XmNuserData, 	(char *)x400mailalias,
			XmNvalue, 	(char *)x400mailalias,
			NULL);
}
	



/*
 *	find pattern (given in alias_find_textfield) in alias list
 */
/***************************************************************
 *
 * Procedure alias_find_pattern
 *
 ***************************************************************/
#ifdef __STDC__

static
int alias_find_pattern(
	char	 *init_string
)

#else

static
int alias_find_pattern(
	init_string
)
char	 *init_string;

#endif

{
	char				*proc = "alias_find_pattern";
	char				*name;
	char				*first_name;
	char				*pattern;
	int				entry;
	char				*list_data;
	char				*client_data;
	unsigned			file_setting_value = XMST_NONE;
	AliasFile			afile;


	if (sectool_verbose)  fprintf(stderr, "--> %s\n", proc);

	if (! (pattern = aux_cpy_ReducedString(XmTextGetString(
					ADWIDGET("*alias_find_textfield")))) ) {

		return(-1);
	}

	XtVaGetValues(	aliasList,
			XmNuserData, &client_data,
			NULL);

	if (XmToggleButtonGetState(ADWIDGET("*alias_user_toggle")))
		file_setting_value = XMST_ALIAS_USER;
	if (XmToggleButtonGetState(ADWIDGET("*alias_system_toggle"))) {

		if (file_setting_value == XMST_ALIAS_USER) file_setting_value = XMST_ALIAS_BOTH;
		else file_setting_value = XMST_ALIAS_SYSTEM;
	}

	if (! (name = aux_search_AliasList(init_string, pattern))) {
	
		ALARM();
		
	} else {

		first_name = aux_cpy_String(name);

		if (file_setting_value != XMST_ALIAS_BOTH) {

			afile = (file_setting_value == XMST_ALIAS_USER) ? useralias : systemalias;

			do {
				if (!aux_alias_chkfile(name, afile)) {
			
					free(name);
					if (! (name = aux_search_AliasList("", pattern))) {

						free(first_name);
						free(pattern);

						ALARM();
						
						return(0);
					}
	
				} else break;

			} while (strcmp(first_name, name));
		}

		free(first_name);
			
		for (entry = count_clientdata(aliaslist_clientdata); entry > 0; entry--) {

			list_data = (char *)get_clientdata(aliaslist_clientdata, entry);
			if (!strcmp(list_data, name)) {
				/* already selected */	
				if (client_data && !strcmp(client_data, list_data)) {

					break;
				}
				XmListSelectPos(aliasList, entry, TRUE);
				XmListSetBottomPos(aliasList, entry);

				break;
			}
		}
		if (entry <= 0) ALARM();

		free(name);
	}

	free(pattern);

	return(0);

}



/*
 *	Other Aliases dialog
 */
/***************************************************************
 *
 * Procedure otheraliases_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

static
void otheraliases_dialog_open(
)

#else

static
void otheraliases_dialog_open(
)

#endif

{
	char		*proc = "otheraliases_dialog_open";
	char		*client_data;


	if (sectool_verbose)  fprintf(stderr, "--> %s\n", proc);

	XtVaGetValues(	aliasList,
			XmNuserData, 	&client_data,
			NULL);

	if (client_data) {

		MANAGE_DIALOG(name2widget(aliasDialog, "*otheraliases_dialog"));
	}
	
	dialog_finished = TRUE;
}

/***************************************************************
 *
 * Procedure otheraliases_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void otheraliases_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void otheraliases_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs = (XmSelectionBoxCallbackStruct *)callback_data;
	char				*client_data;
	int				list_items;
	char				*alias;
	char				*name;


	if (sectool_verbose) fprintf(stderr, "--> otheraliases_dialog_open\n");

	XmUpdateDisplay(applicationShell);

	XtVaGetValues(	aliasList,
			XmNuserData, 	&client_data,
			NULL);

	switch (cbs->reason) {

		case XmCR_OK:		/* Insert */

			if (!client_data) return;
			
			alias = aux_cpy_ReducedString(XmTextGetString(
					XmSelectionBoxGetChild(widget, XmDIALOG_TEXT)));
	
			if (!alias) return;

			if (aux_alias(alias) != notstored) {

				name = aux_alias2Name(alias);
				sprintf(dialog_message,
					"This alias exists and is targeted at DName\n\"%s\"",
					name);
				ok_dialog_open(widget, dialog_message);
				free(name);
				free(alias);

				return;
			}

			XtVaGetValues(	widget,
					XmNlistItemCount, &list_items,
					NULL);

			if (list_items >= XMST_MAX_OTHERALIASES) {

				sprintf(dialog_message,
					"Too many aliases for DName\n\"%s\"",
					client_data);
				ok_dialog_open(widget, dialog_message);
				free(alias);

				return;
			}
	
			aux_add_alias_name(alias, client_data, useralias, FALSE, FALSE);
			
			free(alias);

			break;

		case XmCR_APPLY:	/* Delete */

			if (!client_data) return;
			
			alias = aux_cpy_ReducedString(XmTextGetString(
					XmSelectionBoxGetChild(widget, XmDIALOG_TEXT)));
	
			if (!alias) return;

			if (aux_alias(alias) != notstored) {

				name = aux_alias2Name(alias);
				if (strcmp(client_data, name)) {
		
					sprintf(dialog_message,
						"This alias is targeted at another DName:\n\"%s\"",
						name);
					ok_dialog_open(widget, dialog_message);
					free(name);
					free(alias);
	
					return;
				}
				free(name);

			} else {
		
				ok_dialog_open(widget, "Unknown alias!");
				free(alias);

				return;
			}
	
			if (aux_delete_alias(alias, useralias, FALSE) < 0) {
	
				ok_dialog_open(widget, "Can't delete System alias.");
				free(alias);

				return;
			}
			free(alias);
	
			break;

		case XmCR_CANCEL:	/* Dismiss */
		case XmCR_PROTOCOLS:

			XtUnmanageChild(widget);
			XtUnmanageChild(name2widget(widget, "*ok_dialog"));

			return;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");

			return;
	}

	alias_save_required = TRUE;

	alias_fill_list();
}
















