/* ./src/util/xmsectool/clipboard.c */

static char *rcsid = "$Id: clipboard.c,v 1.15 1995/03/06 13:48:00 nuessler Exp $";

/*
 * $Id: clipboard.c,v 1.15 1995/03/06 13:48:00 nuessler Exp $
 *
 * $Log: clipboard.c,v $
 * 	configuration
 * 	properties
 * 	clipboard
 *
 * Revision 1.12  1994/12/09  17:02:22  koletzki
 * clipboard copy/retrieve/swap
 * object copy/cut
 *
 * Revision 1.11  1994/12/05  11:36:44  nuessler
 * *** empty log message ***
 *
 * Revision 1.10  1994/12/02  16:09:52  koletzki
 * *** empty log message ***
 *
 * Revision 1.9  1994/12/02  14:35:26  koletzki
 * vendor pixmap
 * clipboard copy/retrieve
 *
 * Revision 1.8  1994/11/14  18:59:42  koletzki
 * *** empty log message ***
 *
 * Revision 1.7  1994/11/14  18:48:00  koletzki
 * *** empty log message ***
 *
 * Revision 1.6  1994/11/08  16:34:25  koletzki
 * clipboard functions in clipboard.c
 *
 * Revision 1.5  1994/11/02  10:44:39  surkau
 * Header replaced by Id
 *
 * Revision 1.4  1994/11/02  09:39:08  surkau
 * SecuDE-4.4.a0
 *
 *
 */
 
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/






/*
 ************************
 *	INCLUDES	*
 ************************
 */

#include "xmst.h"



/*
 ************************
 *	STATICS		*
 ************************
 */




static	OctetString	cb_octetstring;
static	BitString	cb_bitstring;






/*
 *	Clipboard functions
 */
 
/*
 *	xmst reads/writes in its own protocol format from/to the Motif clipboard
 *	to ensure recognization of (PSE-)objects.
 *
 *	Clipboard protocol data unit format:
 *                        (buffer)                           (add. info)
 *	 ________ ________ ________ ____ ________  .................... ............
 *	|        |        |        |    |        ||                    |            |
 * 	| Source | id_len | op_len | id | opaque || XmClipboard format | Private ID |
 *	|________|________|________|____|________||....................|............|
 *
 *	Source: (e.g. list) of type ClipboardSource (CB_UNKNOWN, CB_PSE, CB_PK, CB_EK, CB_PCA)
 *	id: (e.g. object in list) any source specific data (id_len * 8 bit)
 *	    CB_ERROR:		return value for failed retrieval
 *	    CB_UNKNOWN:		no id specified
 *	    CB_PSE:		"object name" (without \0)
 *	    CB_PK/EK/PCA:	omitted (entry is identified by its contents)
 *	opaque: any ASN.1 data, op_len * 8 bit
 *	XmClipboard format: XMST_CLEAR_CLIPBOARD_FORMAT or XMST_CRYPTED_CLIPBOARD_FORMAT
 *				They have a format length of 32 bit. The block [Source..opaque]
 *				is padded if the last 32 word is not filled.
 *	Private ID: Originator's PID
 */
		 
		 
		 
		 
		 
		 
/***************************************************************
 *
 * Procedure clipboard_copy()
 *
 *	Parameters:	Source identifier in clipboard_source
 *			Clipboard data id in data_id (void * type)
 *			Object in opaque/opaque_oid
 *	Returns:	0 = OK, -1 = NOT OK
 *
 ***************************************************************/
#ifdef __STDC__

RC clipboard_copy(
	Widget			widget,
	ClipboardSource		clipboard_source,
	void			*data_id,
	void			*opaque,
	ObjId			opaque_oid
)

#else

RC clipboard_copy(
	widget,
	clipboard_source,
	data_id,
	opaque,
	opaque_oid
)
Widget			widget;
ClipboardSource		clipboard_source;
void			*data_id;
void			*opaque;
ObjId			opaque_oid;

#endif

{
	char				*id_name = "";
	unsigned long			clipboard_pdulen = 0;
	int				clipboard_private_id = XMST_PID;
	char				*proc = "clipboard_copy";
	XtPointer			id;
	int				id_len;
	char				*clipboard_pdu = CNULL;
	int				cpdu_idx;
	char				*clipboard_buf = CNULL;
	int				clipboard_buflen;
	OctetString			*clipboard_ostr = NULLOCTETSTRING;
        BitString 			*clipboard_bits = NULLBITSTRING;
	long				clipboard_item_id;
	int				start_status;
	int				copy_status;
	int				end_status;
	Window				clipboard_window = XtWindow(applicationShell);
	XmString			clipboard_label;
	int				rcode;
	char				*clipboard_report;
	char				*clipboard_object;
	
	
	if (!data_id || !opaque) {
	
		return(-1);
	}

	/*
	 * Check for secret object types: they must not be copied to the clipboard!
	 */
	if (!cryptoClipboard
	          && (	  !aux_cmp_ObjId(&opaque_oid, SKnew_OID)
	               || !aux_cmp_ObjId(&opaque_oid, SKold_OID)
	               || !aux_cmp_ObjId(&opaque_oid, SignSK_OID)
	               || !aux_cmp_ObjId(&opaque_oid, DecSKold_OID)
	               || !aux_cmp_ObjId(&opaque_oid, DecSKnew_OID))) {
	               
	        ALARM();
	     
		sprintf(dialog_message, "%s%s",
					"Secret keys must not be copied\n",
					"to the clipboard non-encrypted.");
		ok_dialog_open(widget, dialog_message);
		
		return(-1);
        }
	
	BUSY_CURSOR();
	
	/*
	 *	SOURCE
	 */
	 
	switch (clipboard_source) {
	
		case CB_PSE:
			
			id = (char *)data_id;
			id_len = strlen(id);
			id_name = strdup(id);
			break;
			
		case CB_PK:
		
			id = NULL;
			id_len = 0;
			id_name = strdup("PKList entry");
			break;
			
		case CB_EK:
		
			id = NULL;
			id_len = 0;
			id_name = strdup("EKList entry");
			break;
			
		case CB_PCA:
		
			id = NULL;
			id_len = 0;
			id_name = strdup("PCAList entry");
			break;
			
		case CB_X500:
		
			id = NULL;
			id_len = 0;
			id_name = strdup("X.500 entry");
			break;
			
		case CB_AFDB:
		
			id = NULL;
			id_len = 0;
			id_name = strdup("AF-DB entry");
			break;
			
		case CB_UNKNOWN:
		
			id = NULL;
			id_len = 0;
			id_name = strdup("unknown source");
			break;
			
		default:
		
			id = NULL;
			id_len = 0;
			id_name = strdup("undefined");
	}
	
	
	/*
	 *	OBJECT
	 */
	
	
	/*
	 *	ENCODE
	 */
	if (! (clipboard_ostr = af_pse_encode((char *)id, opaque, &opaque_oid)) ) {
	
		sprintf(dialog_message, "Unable to encode %s", id_name);
		ok_dialog_open(widget, dialog_message);
		
		goto clipboard_copy_error;
        }
        
        /* encrypt OctetString to BitString */
        if (cryptoClipboard) {
        
		/* max. n+8 bytes for DES-CBC */
		clipboard_bits = &cb_bitstring;
		clipboard_bits->bits = (char *)malloc(sizeof(char) * (clipboard_ostr->noctets + 8));
		if (!clipboard_bits->bits) {
		
			sprintf(dialog_message, "Out of memory!");
			ok_dialog_open(widget, dialog_message);
			
			goto clipboard_copy_error;
	        }
	        clipboard_bits->nbits = 0;
			
		/*
		 *	ENCRYPT
		 */
		if (des_encrypt(clipboard_ostr,
				clipboard_bits,
				SEC_END,
				clipboard_sessionkey->key) < 0) {
		
			sprintf(dialog_message, "Unable to encrypt %s", id_name);
			ok_dialog_open(widget, dialog_message);
			
			goto clipboard_copy_error;
	        }
	        
	        clipboard_buf = clipboard_bits->bits;
	        clipboard_buflen = clipboard_bits->nbits / 8;
	        
	} else {
	
	        clipboard_buf = clipboard_ostr->octets;
	        clipboard_buflen = clipboard_ostr->noctets;
	}
		        
	
	/*
	 *	PDU
	 */
	
	/* create Clipboard Protocol Data Unit */
	
	clipboard_pdulen = (unsigned long)(sizeof(ClipboardSource)
						+ sizeof(int)
						+ sizeof(int)
						+ id_len
						+ clipboard_buflen);
						
	/* padding to 32 bit format */
	clipboard_pdulen += 3 - (clipboard_pdulen + 3 ) % 4;
	
	clipboard_pdu = (char *)malloc(clipboard_pdulen);
	if (!clipboard_pdu) {
	
		sprintf(dialog_message, "Clipboard: Out of memory!");
		ok_dialog_open(widget, dialog_message);
		goto clipboard_copy_error;
        }
	
	/*
	 *	PDU items that are read via casting must be placed on top (alignment)
	 */
	
	cpdu_idx = 0;
	/* Add clipboard source token */
	bcopy((char *)&clipboard_source, clipboard_pdu, sizeof(ClipboardSource));
	/* Add length of data ID */
	bcopy((char *)&id_len, clipboard_pdu + (cpdu_idx += sizeof(ClipboardSource)), sizeof(int));
	/* Add length of ASN.1 data */
	bcopy((char *)&clipboard_buflen, clipboard_pdu + (cpdu_idx += sizeof(int)), sizeof(int));
	/* Add data ID */
	bcopy(id, clipboard_pdu + (cpdu_idx += sizeof(int)), id_len);
	/* Add ASN.1 data */
	bcopy(clipboard_buf, clipboard_pdu + (cpdu_idx += id_len), clipboard_buflen);
	
	
	
	/*
	 *	CLIPBOARD LOCK
	 */
	clipboard_label = XmStringCreateLocalized(XMST_CLIPBOARD_LABEL);
	
	do {
		start_status = XmClipboardStartCopy(	display,
							clipboard_window,
							clipboard_label,
							CurrentTime,
							NULL,
							NULL,
							&clipboard_item_id);
		if (start_status == XmClipboardLocked
		   && !retr_canc_dialog_open(	widget,
						"Clipboard is locked\nby another process.")) {
						
			goto clipboard_copy_error;
		}
	} while (start_status == XmClipboardLocked);
	
	XmStringFree(clipboard_label);
	
	/*
	 *	CLIPBOARD COPY
	 */
	copy_status = XmClipboardCopy(	display,
					clipboard_window,
					clipboard_item_id,
					cryptoClipboard ? XMST_CRYPTED_CLIPBOARD_FORMAT
 							: XMST_CLEAR_CLIPBOARD_FORMAT,
					(XtPointer)clipboard_pdu,
					clipboard_pdulen,
					clipboard_private_id,
					NULL);
					
	if (copy_status != XmClipboardSuccess) {
	
	   	ok_dialog_open(widget, "Unable to copy to clipboard.");
					
		goto clipboard_copy_error;
	}
	
	/*
	 *	CLIPBOARD END
	 */
	end_status = XmClipboardEndCopy(	display,
						clipboard_window,
						clipboard_item_id);
						
	if (end_status != XmClipboardSuccess) {
	
	   	ok_dialog_open(widget, "Unable to end copy to clipboard.");
					
		goto clipboard_copy_error;
	}
			
	rcode = 0;
	goto clipboard_copy_ok;
	
clipboard_copy_error:
	XmClipboardUnlock(	display,
				clipboard_window,
				TRUE);
	rcode = -1;
	
clipboard_copy_ok:
	if (clipboard_bits) aux_free_BitString(&clipboard_bits);
	if (clipboard_ostr) aux_free_OctetString(&clipboard_ostr);
	if (clipboard_pdu) free(clipboard_pdu);
	
	if (rcode >= 0) {
	
		clipboard_report = CATSPRINTF(CNULL, " %s%d%s\n %s%s\n %s%s\n %s%s\n %s%d%s\n\n",
			"Origin PID:  ", clipboard_private_id,
				         clipboard_private_id == XMST_PID ? " <myself>" : " <foreigner>",
			"Source:      ", ClipboardSource_name[(int)clipboard_source],
			"Format:      ", cryptoClipboard ? XMST_CRYPTED_CLIPBOARD_FORMAT
						      : XMST_CLEAR_CLIPBOARD_FORMAT,
			"Data ID:     ", id_name,
			"Length:      ", clipboard_pdulen, " bytes");
			
	
		clipboard_object = af_pse_sprint(CNULL, CNULL, opaque, &opaque_oid);
		
	} else {
	
		clipboard_report = CNULL;
		clipboard_object = CNULL;
	}
			
	clipboard_dialog_refresh(widget, clipboard_report, clipboard_object);

	IDLE_CURSOR();
	
	return(rcode);
}





/***************************************************************
 *
 * Procedure clipboard_retrieve
 *
 ***************************************************************/
#ifdef __STDC__

ClipboardSource clipboard_retrieve(
	Widget			widget,
	void			**data_id,
	void			**opaque,
	ObjId			*opaque_oid
)

#else

ClipboardSource clipboard_retrieve(
	widget,
	data_id,
	opaque,
	opaque_oid
)
Widget	widget;
void	**data_id;
void	**opaque;
ObjId	*opaque_oid;

#endif

{
	char				*id_name = "";
	char				*clipboard_format = "";
	ClipboardSource			clipboard_source = CB_ERROR;
	unsigned long			clipboard_pdulen = 0;
	long				clipboard_private_id = 0;
	char				*clipboard_pdu = CNULL;
	Boolean				clipboard_error = TRUE;
	XtPointer			id;
	int				id_len;
	int				cpdu_idx;
	char				*clipboard_buf = CNULL;
	int				clipboard_buflen;
	OctetString			*clipboard_ostr = NULLOCTETSTRING;
        BitString 			*clipboard_bits = NULLBITSTRING;
	unsigned long			clipboard_bytes;
	int				start_status;
	int				retrieve_status;
	int				end_status;
	int				inquire_status;
	Window				clipboard_window = XtWindow(applicationShell);
	char				buf[BUFSIZ];
	char				*format_name_buf = CNULL;
	unsigned long			copied_len;
	Boolean				clipboard_is_encrypted;
	int				format_count;
	int				format_idx;
	unsigned long			max_format_name_length;
	char				*clipboard_report;
	char				*clipboard_object;
	
	
	BUSY_CURSOR();
	
	*opaque = (void *)NULL;
	*data_id = (void *)NULL;
	
	/*
	 *	CLIPBOARD LOCK
	 */
	do {
		start_status = XmClipboardStartRetrieve(	display,
								clipboard_window,
								CurrentTime);
		if (start_status == XmClipboardLocked
		   && !retr_canc_dialog_open(	widget,
						"Clipboard is locked\nby another process.")) {
						
			goto clipboard_retrieve_error;
		}
	} while (start_status == XmClipboardLocked); 
	 	
	/*
	 *	CLIPBOARD INQUIRE COUNT
	 */
	inquire_status = XmClipboardInquireCount(	display,
							clipboard_window,
							&format_count,
							&max_format_name_length);
							
	if (inquire_status != ClipboardSuccess || !format_count) {
	
		ok_dialog_open(widget, "No data in clipboard.");
		
		goto clipboard_retrieve_error;
	}
	
	format_name_buf = (char *)malloc(sizeof(char) * (max_format_name_length + 1));
	if (!format_name_buf) {
	
		ok_dialog_open(widget, "Out of memory!");
		
		goto clipboard_retrieve_error;
        }
        
	/*
	 *	CLIPBOARD INQUIRE FORMAT
	 */
	 for (format_idx = 1; format_idx <= format_count; format_idx++) {
	 
		inquire_status = XmClipboardInquireFormat(	display,
								clipboard_window,
								format_idx,
								(XtPointer)format_name_buf,
								max_format_name_length,
								&copied_len);
								
		if (!copied_len)
				
			continue;
			
		if ( !strncmp(format_name_buf, XMST_CLEAR_CLIPBOARD_FORMAT, copied_len)
		  || !strncmp(format_name_buf, XMST_CRYPTED_CLIPBOARD_FORMAT, copied_len))
				
			break;
	}

	if (!copied_len || format_idx > format_count) {
	
		ok_dialog_open(widget, "No data in XMST format in clipboard.");
		
		goto clipboard_retrieve_error;
	}
	
	format_name_buf[copied_len] = '\0';
	clipboard_format = strdup(format_name_buf);
	clipboard_is_encrypted = (strcmp(clipboard_format, XMST_CLEAR_CLIPBOARD_FORMAT) ? TRUE : FALSE);
	free(format_name_buf);
	
	/*
	 *	CLIPBOARD INQUIRE LENGTH
	 */
 	inquire_status = XmClipboardInquireLength(	display,
		 					clipboard_window,
		 					clipboard_format,
		 					&clipboard_pdulen);
	
	if (inquire_status != ClipboardSuccess || !clipboard_pdulen) {
			
		ok_dialog_open(widget, "Unable to inquire length of clipboard data.");
		
		goto clipboard_retrieve_error;
	}
	
	
	clipboard_pdu = (char *)malloc(sizeof(char) * clipboard_pdulen);
	if (!clipboard_pdu) {
	
		ok_dialog_open(widget, "Out of memory!");
		
		goto clipboard_retrieve_error;
        }
        
        
        /*
         *	CLIPBOARD RETRIEVE
	 */
	retrieve_status = XmClipboardRetrieve(	display,
						clipboard_window,
						clipboard_format,
						(XtPointer)clipboard_pdu,
						clipboard_pdulen,
						&clipboard_bytes,
						&clipboard_private_id);
						
	if (retrieve_status != XmClipboardSuccess) {
					
		ok_dialog_open(widget, "Unable to retrieve from clipboard.");
		
		goto clipboard_retrieve_error;
	}
	
        /*
         *	CLIPBOARD END
	 */
	end_status = XmClipboardEndRetrieve(	display,
						clipboard_window);
						
	if (end_status != XmClipboardSuccess) {
					
		ok_dialog_open(widget, "Unable to end retrieve from clipboard.");
		
		goto clipboard_retrieve_error;
	}
	
	
	/*
	 *	LENGTH
	 */
	if (clipboard_bytes != clipboard_pdulen) {
	
		ok_dialog_open(widget, "Clipboard data do not have inquired length.");
		
		goto clipboard_retrieve_error;
        }
	
	
	/*
	 *	PDU
	 */
	 
	/* parse Clipboard Protocol Data Unit */
	cpdu_idx = 0;
	/* Get clipboard source token to PDU */
	clipboard_source = *(ClipboardSource *)clipboard_pdu;
	/* Get length of data ID */
	id_len = *(int *)(clipboard_pdu + (cpdu_idx += sizeof(ClipboardSource)));
	/* Get length of ASN.1 data */
	clipboard_buflen = *(int *)(clipboard_pdu + (cpdu_idx += sizeof(int)));
	cpdu_idx += sizeof(int);
	
	
	clipboard_error = FALSE;	/* pdu is "physically" OK, now check protocol */
	 
	/*
	 *	SOURCE
	 */
	 
	/* Get data ID */
	switch (clipboard_source) {
		
		case CB_PSE:
			
			if (!id_len) {
			
				ok_dialog_open(widget,
					"Clipboard protocol error!\n\nMissing PSE object ID.");
				
				goto clipboard_retrieve_error;
		        }
		        
			id = (char *)malloc(id_len + 1);
			if (!id) {
			
				ok_dialog_open(widget, "Out of memory!");
				
				goto clipboard_retrieve_error;
		        }
        
        		/* Get data ID */
			bcopy(clipboard_pdu + cpdu_idx, (char *)id, id_len);
			
			*((char *)id + id_len) = '\0';
			id_name = strdup((char *)id);

			*data_id = (void *)aux_cpy_String(id_name);
			
			break;
			
		case CB_PK:
		
			if (id_len) {
			
				ok_dialog_open(widget,
					"Clipboard protocol error!\n\nSuperfluous ID for ToBeSigned.");
				
				goto clipboard_retrieve_error;
		        }
		        
			id = NULL;
			id_name = strdup("PKList entry");
			
			*data_id = (void *)NULL;
			
			break;
			
		case CB_EK:
		
			if (id_len) {
			
				ok_dialog_open(widget,
					"Clipboard protocol error!\n\nSuperfluous ID for ToBeSigned.");
				
				goto clipboard_retrieve_error;
		        }
		        
			id = NULL;
			id_name = strdup("EKList entry");
			
			*data_id = (void *)NULL;
			
			break;
			
		case CB_PCA:
		
			if (id_len) {
			
				ok_dialog_open(widget,
					"Clipboard protocol error!\n\nSuperfluous ID for ToBeSigned.");
				
				goto clipboard_retrieve_error;
		        }
		        
			id = NULL;
			id_name = strdup("PCAList entry");
			
			*data_id = (void *)NULL;
			
			break;
		
		case CB_X500:
		
			if (id_len) {
			
				ok_dialog_open(widget,
					"Clipboard protocol error!\n\nSuperfluous ID for ToBeSigned.");
				
				goto clipboard_retrieve_error;
		        }
		        
			id = NULL;
			id_name = strdup("X.500 entry");
			
			*data_id = (void *)NULL;
			break;
			
		case CB_AFDB:
		
			if (id_len) {
			
				ok_dialog_open(widget,
					"Clipboard protocol error!\n\nSuperfluous ID for ToBeSigned.");
				
				goto clipboard_retrieve_error;
		        }
		        
			id = NULL;
			id_name = strdup("AF-DB entry");
			
			*data_id = (void *)NULL;
			break;
				
		case CB_UNKNOWN:
		
			id = NULL;
			id_name = strdup("unknown source");
			
			*data_id = (void *)NULL;
			
			break;
			
		default:
		
			id = NULL;
			id_name = strdup("undefined");
			
			*data_id = (void *)NULL;
	}


	/*
	 *	OBJECT
	 */

	/* Get ASN.1 data */
	clipboard_buf = (char *)malloc(clipboard_buflen);
	if (!clipboard_buf) {
	
		ok_dialog_open(widget, "Out of memory!");
		
		goto clipboard_retrieve_error;
        }
	bcopy(clipboard_pdu + (cpdu_idx += id_len), clipboard_buf, clipboard_buflen);

	if (clipboard_is_encrypted) {
	
		/*
		 *	only same process may decrypt
		 */
		if (clipboard_private_id != XMST_PID) {
		
			sprintf(dialog_message,	"%s%s%s%d\n%s%d",
						"The current clipboard data cannot be decrypted\n",
						"because its origin is a foreign XMST process.\n\n",
						"PID of actual session is ",
						XMST_PID,
						"Originator's PID is ",
						clipboard_private_id);
			ok_dialog_open(widget, dialog_message);
			
			goto clipboard_retrieve_error;
		}
		
		clipboard_bits = &cb_bitstring;
		clipboard_bits->bits = clipboard_buf;
		clipboard_bits->nbits = clipboard_buflen * 8;
		
		/* max. n for DES-CBC */
		clipboard_ostr = &cb_octetstring;
		clipboard_ostr->octets = (char *)malloc(sizeof(char) * clipboard_buflen);
		if (!clipboard_ostr->octets) {
		
			sprintf(dialog_message, "Out of memory!");
			ok_dialog_open(widget, dialog_message);
			
			goto clipboard_retrieve_error;
	        }
	        clipboard_ostr->noctets = 0;
	        
	        /*
		 *	DECRYPT
		 */	
		if (des_decrypt(	clipboard_bits,
					clipboard_ostr,
					SEC_END,
					clipboard_sessionkey->key) < 0) {
		
			sprintf(dialog_message,	"%s\n%s",
						"Unable to decrypt clipboard data.",
						"Try again with clipboard encryption property set off.");
			ok_dialog_open(widget, dialog_message);
			
			goto clipboard_retrieve_error;
	        }
	        
	} else {
	
		clipboard_ostr = &cb_octetstring;
		clipboard_ostr->octets = clipboard_buf;
		clipboard_ostr->noctets = clipboard_buflen;
	}
	        
	/*
	 *	DECODE
	 */
	if (! (*opaque = af_pse_decode(CNULL, clipboard_ostr, opaque_oid))
	    || !aux_cmp_ObjId(opaque_oid, Uid_OID) ) {
	
		ok_dialog_open(widget, "Unable to decode object from clipboard.");
		goto clipboard_retrieve_error;
        }
	
	
	
	/*
	 * Got object from clipboard
	 */
	goto clipboard_retrieve_ok;


clipboard_retrieve_error:
	XmClipboardUnlock(	display,
				clipboard_window,
				TRUE);
	if (clipboard_error) clipboard_source = CB_ERROR;
	
clipboard_retrieve_ok:
	if (clipboard_ostr) aux_free_OctetString(&clipboard_ostr);
	if (clipboard_bits) aux_free_BitString(&clipboard_bits);
	if (clipboard_pdu) free(clipboard_pdu);
	
	if (!clipboard_error) {
	
		clipboard_report = CATSPRINTF(CNULL, " %s%d%s\n %s%s\n %s%s\n %s%s\n %s%d%s\n\n",
			"Origin PID:  ", clipboard_private_id,
				         clipboard_private_id == XMST_PID ? " <myself>" : " <foreigner>",
			"Source:      ", (clipboard_source >= CB_PSE)
					? ClipboardSource_name[(int)clipboard_source]
					: "<empty>",
			"Format:      ", clipboard_format,
			"Data ID:     ", id_name,
			"Length:      ", clipboard_pdulen, " bytes");
			
		clipboard_object = af_pse_sprint(CNULL, CNULL, *opaque, opaque_oid);
			
	} else {
	
		clipboard_report = CNULL;
		clipboard_object = CNULL;
	}
			
	clipboard_dialog_refresh(widget, clipboard_report, clipboard_object);

	IDLE_CURSOR();
	
	return(clipboard_source);
}



/***************************************************************
 *
 * Procedure clipboard_swap
 *
 *	Swapping only works properly if the same XMST instance
 *	copies TWO (different) objects to the clipboard.
 *	If the second clipboard item if owned by another
 *	widget's window, the first swapping is performed
 *	(retrievable data only for non-encrypted objects),
 *	but swapping back doesn't work!
 *
 ***************************************************************/
#ifdef __STDC__

void clipboard_swap(
	Widget		widget
)

#else

void clipboard_swap(
	widget
)
Widget	widget;

#endif

{
	int				swap_status;
	Window				clipboard_window = XtWindow(applicationShell);

	do {
		swap_status = XmClipboardUndoCopy(	display,
							clipboard_window);
		if (swap_status == XmClipboardLocked
		   && !retr_canc_dialog_open(	widget,
						"Clipboard is locked\nby another process.")) {
						
			break;
		}
	} while (swap_status == ClipboardLocked);
	
	XmClipboardUnlock(	display,
				clipboard_window,
				TRUE);
}



