/* ./src/util/xmsectool/d5_dialog.c */

static char *rcsid = "$Id: d5_dialog.c,v 1.57 1995/03/17 17:04:50 koletzki Exp $";

/*
 * $Id: d5_dialog.c,v 1.57 1995/03/17 17:04:50 koletzki Exp $
 *
 * $Log: d5_dialog.c,v $
 * removed BUG:
 *   selected List-Item wouldn't deselected correct.
 *
 * removed BUG:
 *   (reported by surkau) compile without ansi
 *
 * Revision 1.38  1995/02/06  07:44:05  nuessler
 * *** empty log message ***
 *
 * Revision 1.37  1995/01/30  12:05:06  nuessler
 * *** empty log message ***
 *
 * Revision 1.36  1995/01/23  11:51:13  nuessler
 * Using of global function
 *   verificate().
 *
 * Removed PSE-Object List from Dialog.
 *
 * Revision 1.35  1995/01/04  13:44:39  nuessler
 * Cleaned source code
 *
 * Revision 1.34  1995/01/04  07:48:59  nuessler
 * Inserted   #ifdef X500
 *                 ....
 *            #endif
 * in retrieve-function
 *
 * Revision 1.33  1995/01/02  13:56:37  nuessler
 * New Dialog :
 * X500.Directory Browser -> Verify Dialog
 *
 * Revision 1.32  1994/12/30  08:49:13  nuessler
 * New User-Interface in Directory Browser
 *
 * Revision 1.31  1994/12/19  11:48:30  nuessler
 * view-function of attribute list realized!
 *
 * Revision 1.30  1994/12/15  20:07:46  nuessler
 * d5bwr_XmStringTable... -> util_XmStringTable...
 *
 * Bugs fixed in ..._XmStringTable...
 *
 * Revision 1.29  1994/12/09  17:00:39  nuessler
 * nicer busy and think Cursor Function called
 * setCursor
 *
 * Revision 1.28  1994/12/09  16:56:46  nuessler
 * There is a better and nicer busy - and think
 * Cursor function called setCursor!
 *
 * Revision 1.27  1994/12/09  11:29:49  koletzki
 * *** empty log message ***
 *
 * Revision 1.26  1994/12/05  11:38:50  nuessler
 * *** empty log message ***
 *
 * Revision 1.25  1994/12/02  14:37:54  nuessler
 * *** empty log message ***
 *
 * Revision 1.24  1994/12/02  11:51:02  nuessler
 * *** empty log message ***
 *
 * Revision 1.23  1994/11/30  12:12:59  nuessler
 * *** empty log message ***
 *
 * Revision 1.22  1994/11/21  16:13:28  nuessler
 * *** empty log message ***
 *
 * Revision 1.21  1994/11/18  15:58:49  nuessler
 * *** empty log message ***
 *
 * Revision 1.20  1994/11/14  19:06:20  koletzki
 * *** empty log message ***
 *
 * Revision 1.19  1994/11/14  12:14:26  nuessler
 * *** empty log message ***
 *
 * Revision 1.18  1994/11/11  16:19:34  nuessler
 * *** empty log message ***
 *
 * Revision 1.17  1994/11/07  11:27:30  nuessler
 * *** empty log message ***
 *
 * Revision 1.16  1994/11/04  15:57:06  nuessler
 * *** empty log message ***
 *
 * Revision 1.15  1994/11/04  13:22:47  nuessler
 * *** empty log message ***
 *
 * Revision 1.14  1994/11/02  10:44:39  surkau
 * Header replaced by Id
 *
 * Revision 1.13  1994/11/02  09:39:08  surkau
 * SecuDE-4.4.a0
 *
 *
 */
 
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/


/*
 ************************
 *	INCLUDES	*
 ************************
 */

#include "xmst.h"
#include "d5_dialog.h"
#include <signal.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>



/****************************
 *	  STATICS	    *
 ****************************/

/***  Widgets  ***/

static	struct { String		uil_name;
		 Widget		ptr;
	       } widgets[] = {
	{"*d5bwr_working_dialog",			NULL},
	{"*d5bwr_name_text",				NULL},
	{"*d5bwr_dname_textfield",			NULL},
	       
	{"*d5bwr_action_enter_togglebutton",		NULL},
	{"*d5bwr_action_retrieve_togglebutton",		NULL},
	{"*d5bwr_action_remove_togglebutton",		NULL},
	{"*d5bwr_x500_drawnbutton", 			NULL},
	{"*d5bwr_afdb_drawnbutton", 			NULL},
	
	{"*d5bwr_tb_us_ce",				NULL},
	{"*d5bwr_tb_ca_ce",				NULL},
	{"*d5bwr_tb_si_ce",				NULL},
	{"*d5bwr_tb_en_ce",				NULL},
	
	{"*d5bwr_attrlist_list",			NULL},
	{"*d5bwr_attrlist_list_label",			NULL},
	{"*d5bwr_attrlist_next_pushbutton",		NULL},
	{"*d5bwr_attrlist_text",			NULL},
	{"*d5bwr_attrlist_view",			NULL},
	{"*d5bwr_attrlist_verify",			NULL},
	{"*d5bwr_attrlist_addtopk",			NULL},
	{"*d5bwr_attrlist_addtoek",			NULL},
	{"*d5bwr_attrlist_addtopca",			NULL},
	{"*d5bwr_attrlist_addtopseobj",			NULL},
	{"*d5bwr_attrlist_addtoclipboard",		NULL},
	
	{NULL}
};

enum Widgets {
	working_dialog,
	
	name_text,
	dname_text,

	action_enter,
	action_retrieve,
	action_remove,
	x500_access,
	afdb_access,
	
	toggle_us_ce,
	toggle_ca_ce,
	toggle_si_ce,
	toggle_en_ce,
	
	attrlist_list,
	attrlist_label,
	attrlist_next,
	attrlist_text,
	attrlist_view,
	attrlist_verify,
	attrlist_pk,
	attrlist_ek,
	attrlist_pca,
	attrlist_pseobj,
	attrlist_clipboard
	};
	
	
/*** Status of Directory Browser ***/

static struct { Boolean				dname_flag;
		DName				*dname;
		Boolean				attributes_flag;
		enum d5bwr_ActionSwitch		action;
	      } d5bwr_status;


/*** Attribute List ***/

static	struct { XmString		labels[D5BWR_attr_last];	/* list-label strings */
		 Boolean		lists[D5BWR_attr_last];		/* which lists are build */
		 enum d5bwr_AttrSwitch	current;			/* current list type */
		 int			count;				/* count of entries of current list */
		 XmStringTable		strtable;			/* StrTable of current list */
		 int			selectedItem;			/* Selected Item of current list */
	       } d5bwr_attrlist;

static	Boolean			d5bwr_attribute[D5BWR_attr_last];


/*** dir & afdb Entries ***/

static struct { SET_OF_Certificate	*certset;
		int			count;
		XmStringTable		strtable;
		Certificate		**ptr2element;
	      }  d5bwr_us, d5bwr_ca, d5bwr_si, d5bwr_en;

static	CRL			*d5bwr_CRL;
static	SET_OF_CertificatePair	*d5bwr_certpairset;

static XmString			*d5bwr_list_CRL;
static XmString			*d5bwr_list_certpairset;

/*** Others ***/

static pid_t	fork_retrieve_pid;

/*** Local Functions ***/

#ifdef __STDC__

static	void	d5bwr_init();
static	void	d5bwr_dialog_refresh();
static	void	d5bwr_enter();
static	void	retrieve();
static	void	fork_retrieve();
static	void	fork_retrieve_reset1();
static	void	fork_retrieve_reset2();
static	void	d5bwr_remove();
static	void	doaction_sensitive_test();

static	void	attrlist_build(enum d5bwr_AttrSwitch);
static	void	attrlist_delete_all();
static	void	attrlist_delete(enum d5bwr_AttrSwitch);
static	void	attrlist_refresh(enum d5bwr_AttrSwitch);
static	void	attrlist_selectItem(XmListCallbackStruct *);
static	void	attrlist_unselectItem();
static	String 	build_CertString(Certificate *);

static	void 	bitstr2file(BitString*, FILE*);
static	void 	file2bitstr(FILE*, BitString**);

#else

static	void	d5bwr_init();
static	void	d5bwr_dialog_refresh();
static	void	d5bwr_enter();
static	void	retrieve();
static	void	fork_retrieve();
static	void	fork_retrieve_reset1();
static	void	fork_retrieve_reset2();
static	void	d5bwr_remove();
static	void	doaction_sensitive_test();

static 	void	attrlist_build();
static	void	attrlist_delete_all();
static	void	attrlist_delete();
static 	void	attrlist_refresh();
static	void	attrlist_selectItem();
static	void	attrlist_unselectItem();
static	String 	build_CertString();

static	void 	bitstr2file();
static	void 	file2bitstr();

#endif



/**************************************************************************
 *
 * Procedure d5bwr_dialog_open
 *
 * Last modified: 06.03.95
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_dialog_open()

#else

void d5bwr_dialog_open()

#endif

{
	int i;
	
	if (!d5bwrDialog){
		
		/*** Initialize Widget IDs ***/
		d5bwrDialog = STWIDGET("*d5bwr_dialog");
		for(i=0; widgets[i].uil_name; i++)
			widgets[i].ptr = name2widget(d5bwrDialog, widgets[i].uil_name);
			
		d5bwr_init();

		add_focus_callbacks(name2widget(d5bwrDialog, "*pseobjselection_sel_text"));
		add_focus_callbacks(widgets[name_text].ptr);

		d5bwr_onekeypair( onekeypaironly );
			
		MANAGE_MODELESS_DIALOG(d5bwrDialog);
		
		add_destroy_callback(name2widget(d5bwrDialog, "*pseobjselection_dialog"),
							(caddr_t)pseobjselection_dialog_cb);
		add_destroy_callback(name2widget(d5bwrDialog, "*ok_dialog"), (caddr_t)ok_dialog_cb);
		add_destroy_callback(widgets[working_dialog].ptr, (caddr_t)d5bwr_workdiag_cb);
		if ( x500 ){
			XtManageChild(widgets[toggle_us_ce].ptr);
			XtManageChild(widgets[toggle_ca_ce].ptr);
			XtManageChild(widgets[x500_access].ptr);
		}
		else {
			XtManageChild(widgets[toggle_si_ce].ptr);
			XtManageChild(widgets[toggle_en_ce].ptr);
			XtManageChild(widgets[afdb_access].ptr);
		}
		
		attrlist_refresh(D5BWR_attr_none);
		
	}
	else {
		d5bwr_onekeypair( onekeypaironly );
			
		MANAGE_MODELESS_DIALOG(d5bwrDialog);
	}	

	d5bwr_dialog_refresh();

}

/**************************************************************************
 *
 * Procedure d5bwr_onekeypair
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_onekeypair(
	Boolean	onekeypair
	)

#else

void d5bwr_onekeypair(
	onekeypair
	)
Boolean	onekeypair;

#endif

{
	
	if (d5bwrDialog){
		
		if ( !onekeypair )
			XtManageChild(widgets[attrlist_ek].ptr);
		else
			XtUnmanageChild(widgets[attrlist_ek].ptr);
	}
}



/**************************************************************************
 *
 * Procedure d5bwr_dialog_cb
 *
 * Last modified: 04.11.94
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_dialog_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void d5bwr_dialog_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{
	XmAnyCallbackStruct *cbs = (XmAnyCallbackStruct *)callback_data;

	switch(cbs->reason){
			case XmCR_CANCEL:
			case XmCR_PROTOCOLS:
				XtUnmanageChild(widget);
				break;
			default:
				if(sectool_verbose)
					fprintf(stderr, "Oops - unknown callback reason %d!\n", 
					        cbs->reason);
	}
}



/**************************************************************************
 *
 * Procedure d5bwr_dialog_refresh
 *
 * Last modified: 12.10.94
 *
 **************************************************************************/
#ifdef __STDC__

static
void d5bwr_dialog_refresh()

#else

static
void d5bwr_dialog_refresh()

#endif

{
}



/**************************************************************************
 *
 * Procedure d5bwr_action_toggle_cb
 *
 * Last modified: 28.12.94
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_action_toggle_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void d5bwr_action_toggle_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{
	XmToggleButtonCallbackStruct *cbs = (XmToggleButtonCallbackStruct *)callback_data;
	short button 			  = *(short*)client_data;
	
	switch(button){
		case D5BWR_action_enter:
			XmToggleButtonSetState(widgets[action_retrieve].ptr, FALSE, FALSE);
			XmToggleButtonSetState(widgets[action_remove].ptr, FALSE, FALSE);
			break;
		case D5BWR_action_retrieve:
			XmToggleButtonSetState(widgets[action_enter].ptr, FALSE, FALSE);
			XmToggleButtonSetState(widgets[action_remove].ptr, FALSE, FALSE);
			break;
		case D5BWR_action_remove:
			XmToggleButtonSetState(widgets[action_enter].ptr, FALSE, FALSE);
			XmToggleButtonSetState(widgets[action_retrieve].ptr, FALSE, FALSE);
			break;
	}
	
	if(cbs->set) d5bwr_status.action = button;
	else 	     d5bwr_status.action = D5BWR_none;
	doaction_sensitive_test();
}



/**************************************************************************
 *
 * Procedure d5bwr_doaction_cb
 *
 * Last modified: 23.02.94
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_doaction_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void d5bwr_doaction_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{

	switch(d5bwr_status.action){
		case D5BWR_action_enter:
			break;
			
		case D5BWR_action_retrieve:
			fork_retrieve();
			break;
			
		case D5BWR_action_remove:
			break;
	}
}



/**************************************************************************
 *
 * Procedure doaction_sensitive_test
 *
 * Last modified: 28.12.94
 *
 **************************************************************************/
#ifdef __STDC__

static
void doaction_sensitive_test()

#else

static
void doaction_sensitive_test()

#endif

{
	switch(d5bwr_status.action){
		case D5BWR_action_enter:
			break;
			
		case D5BWR_action_retrieve:
			if(d5bwr_status.dname_flag && d5bwr_status.attributes_flag){
				if( x500 ){
					XtSetSensitive(widgets[x500_access].ptr, TRUE);
				}
				else{
					XtSetSensitive(widgets[afdb_access].ptr, TRUE);
				}
			}
			else
				if( x500 ){
					XtSetSensitive(widgets[x500_access].ptr, FALSE);
				}
				else{
					XtSetSensitive(widgets[afdb_access].ptr, FALSE);
				}
			break;
			
		case D5BWR_action_remove:
			break;
		default:
			if( x500 ){
				XtSetSensitive(widgets[x500_access].ptr, FALSE);
			}
			else{
				XtSetSensitive(widgets[afdb_access].ptr, FALSE);
			}
	}
}



/**************************************************************************
 *
 * Procedure d5bwr_name_cb
 *
 * Last modified: 04.11.94
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_name_cb(
	Widget				widget,
	XtPointer			client_data,
	XtPointer			callback_data
	)
	
#else

void d5bwr_name_cb(
	widget,
	client_data,
	callback_data
	)
Widget				widget;
XtPointer			client_data;
XtPointer			callback_data;

#endif

{
	String   name  = XmTextFieldGetString(widgets[name_text].ptr);
	DName   *dname = NULL;
	
		text_unwrap_RDN(name);
 		if( (dname = aux_alias2DName(aux_cpy_ReducedString(name))) ){
 		/* Correct Alias or DName */
		d5bwr_status.dname = aux_cpy_DName(dname);
		XtFree(name);
		name = aux_DName2Name(d5bwr_status.dname);
		text_wrap_RDN(name);
		XmTextSetString(widgets[dname_text].ptr, name);
		free(name); 
		d5bwr_status.dname_flag = TRUE;
		doaction_sensitive_test();
	}
	else{
		/* No correct Alias or DName. */
		ALARM();
		sprintf(dialog_message, "\"%s\"\nis no Alias and no correct DName.", name);
		ok_dialog_open(d5bwrDialog, dialog_message);
		XmTextSetString(widgets[dname_text].ptr, "");
		if(d5bwr_status.dname) aux_free_DName(&d5bwr_status.dname);
		XtFree(name);
		d5bwr_status.dname_flag = FALSE;
		doaction_sensitive_test();
	}
	if(dname) aux_free_DName(&dname);
}



/**************************************************************************
 *
 * Procedure d5bwr_attrlist_list_cb
 *
 * Last modified: 16.03.95
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_attrlist_list_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void d5bwr_attrlist_list_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{		
	if ( ((XmListCallbackStruct *)(callback_data))->selected_item_count == 1 ){	
		attrlist_selectItem((XmListCallbackStruct *) callback_data);
	}
	else{
		attrlist_unselectItem();
	}
	
	
}



/**************************************************************************
 *
 * Procedure attrlist_unselectItem
 *
 * Last modified: 06.03.95
 *
 **************************************************************************/
#ifdef __STDC__

static void attrlist_unselectItem()

#else

static void attrlist_unselectItem()

#endif

{
	XmListDeselectPos(widgets[attrlist_list].ptr, d5bwr_attrlist.selectedItem+1);
	XmTextFieldSetString(widgets[attrlist_text].ptr, "");
 	XtSetSensitive(widgets[attrlist_view].ptr,   	FALSE);
 	XtSetSensitive(widgets[attrlist_verify].ptr, 	FALSE);
 	XtSetSensitive(widgets[attrlist_pk].ptr,	FALSE);
 	XtSetSensitive(widgets[attrlist_ek].ptr,	FALSE);
 	XtSetSensitive(widgets[attrlist_pca].ptr,	FALSE);
 	XtSetSensitive(widgets[attrlist_clipboard].ptr,	FALSE);
 	XtSetSensitive(widgets[attrlist_pseobj].ptr,	FALSE);
}



/**************************************************************************
 *
 * Procedure attrlist_selectItem
 *
 * Last modified: 06.03.95
 *
 **************************************************************************/
#ifdef __STDC__

static void attrlist_selectItem(
	XmListCallbackStruct  *cbs
	)

#else

static void attrlist_selectItem(
	cbs
	)
XmListCallbackStruct  *cbs;

#endif

{
	String item;
	
	XmStringGetLtoR(cbs->item, XmFONTLIST_DEFAULT_TAG, &item);
	XmTextFieldSetString(widgets[attrlist_text].ptr, item);
	d5bwr_attrlist.selectedItem = (cbs->item_position)-1;
	XtFree(item);
	
	XtSetSensitive(widgets[attrlist_view].ptr,  	TRUE);
	XtSetSensitive(widgets[attrlist_verify].ptr,	TRUE);
	XtSetSensitive(widgets[attrlist_pk].ptr,	TRUE);	
	XtSetSensitive(widgets[attrlist_ek].ptr,	TRUE);
	XtSetSensitive(widgets[attrlist_pca].ptr,	TRUE);
	XtSetSensitive(widgets[attrlist_clipboard].ptr,	TRUE);
	XtSetSensitive(widgets[attrlist_pseobj].ptr,	TRUE);
}



/**************************************************************************
 *
 * Procedure d5bwr_att_toggle_cb
 *
 * Last modified: 31.10.94
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_att_toggle_cb(
	Widget				widget,
	XtPointer			client_data,
	XtPointer			callback_data
	)
	
#else

void d5bwr_att_toggle_cb(
	widget,
	client_data,
	callback_data
	)
Widget				widget;
XtPointer			client_data;
XtPointer			callback_data;

#endif

{
	short button = *(short*)client_data;

	d5bwr_attribute[button] = d5bwr_attribute[button] ? FALSE : TRUE;
	
	if (d5bwr_attribute[D5BWR_attr_user_ce] ||
	    d5bwr_attribute[D5BWR_attr_ca_cert] ||
	    d5bwr_attribute[D5BWR_attr_ce_revo] ||
	    d5bwr_attribute[D5BWR_attr_cros_ce] ||
	    d5bwr_attribute[D5BWR_attr_sign_ce] ||
	    d5bwr_attribute[D5BWR_attr_encr_ce] ){
		d5bwr_status.attributes_flag = TRUE;
	}
	else{
		d5bwr_status.attributes_flag = FALSE;
	}
	doaction_sensitive_test();
}



/**************************************************************************
 *
 * Procedure attrlist_build
 *
 * Last modified: 19.12.94
 *
 **************************************************************************/
#ifdef __STDC__

static
void attrlist_build(
	enum d5bwr_AttrSwitch		attr_switch
	)
	
#else

static
void attrlist_build(
	attr_switch
	)
enum d5bwr_AttrSwitch	attr_switch;

#endif

{
	String			proc		= "attrlist_build";
	SET_OF_Certificate	*certset;
	CRL			*crl			= d5bwr_CRL;
	SET_OF_CertificatePair	*certpairset		= d5bwr_certpairset;
	
	int	i 	= 0;
	String 	string 	= NULL;
	
 	d5bwr_attrlist.lists[attr_switch] = TRUE;
 	
	switch(attr_switch){
		case D5BWR_attr_user_ce:
		
			/* Count Set */
			certset = d5bwr_us.certset;
			while(certset){
				(d5bwr_us.count)++;
				certset = certset->next;
			}
				
			/* Build XmStringTable and Pointers */
			certset           = d5bwr_us.certset;	
			d5bwr_us.strtable = util_XmStringTableCreate(d5bwr_us.count);
			d5bwr_us.ptr2element = (Certificate **)malloc(d5bwr_us.count*sizeof(Certificate *));
			if( !d5bwr_us.ptr2element ) {
				fprintf(stderr, "Memory Allocation error in %s.\n", proc);
				exit(-1);
			}
			for(i=0; i<d5bwr_us.count; i++){
				string = build_CertString(certset->element);
				util_XmStringTableInsert(d5bwr_us.strtable, i, string);
				d5bwr_us.ptr2element[i] = certset->element;
				if(string) { free(string); string = NULL; }
				certset = certset->next;
			}
			break;
			
		case D5BWR_attr_ca_cert:
		
			/* Count Set */
			certset = d5bwr_ca.certset;
			while(certset){
				(d5bwr_ca.count)++;
				certset = certset->next;
			}
				
			/* Build XmStringTable and Pointers */
			certset           = d5bwr_ca.certset;	
			d5bwr_ca.strtable = util_XmStringTableCreate(d5bwr_ca.count);
			d5bwr_ca.ptr2element = (Certificate **)malloc(d5bwr_ca.count*sizeof(Certificate *));
			if( !d5bwr_ca.ptr2element ) {
				fprintf(stderr, "Memory Allocation error in %s.\n", proc);
				exit(-1);
			}
			for(i=0; i<d5bwr_ca.count; i++){
				string = build_CertString(certset->element);
				util_XmStringTableInsert(d5bwr_ca.strtable, i, string);
				d5bwr_ca.ptr2element[i] = certset->element;
				if(string) { free(string); string = NULL; }
				certset = certset->next;
			}
			break;
			
		case D5BWR_attr_sign_ce:
		
			/* Count Set */
			certset = d5bwr_si.certset;
			while(certset){
				(d5bwr_si.count)++;
				certset = certset->next;
			}
				
			/* Build XmStringTable and Pointers */
			certset              = d5bwr_si.certset;	
			d5bwr_si.strtable    = util_XmStringTableCreate(d5bwr_si.count);
			d5bwr_si.ptr2element = (Certificate **)malloc(d5bwr_si.count*sizeof(Certificate *));
			if( !d5bwr_si.ptr2element ) {
				fprintf(stderr, "Memory Allocation error in %s.\n", proc);
				exit(-1);
			}
			for(i=0; i<d5bwr_si.count; i++){
				string = build_CertString(certset->element);
				util_XmStringTableInsert(d5bwr_si.strtable, i, string);
				d5bwr_si.ptr2element[i] = certset->element;
				if(string) { free(string); string = NULL; }
				certset = certset->next;
			}
			break;
			
		case D5BWR_attr_encr_ce:
		
			/* Count Set */
			certset = d5bwr_en.certset;
			while(certset){
				(d5bwr_en.count)++;
				certset = certset->next;
			}
				
			/* Build XmStringTable and Pointers */
			certset           = d5bwr_en.certset;	
			d5bwr_en.strtable = util_XmStringTableCreate(d5bwr_en.count);
			d5bwr_en.ptr2element = (Certificate **)malloc(d5bwr_en.count*sizeof(Certificate *));
			if( !d5bwr_en.ptr2element ) {
				fprintf(stderr, "Memory Allocation error in %s.\n", proc);
				exit(-1);
			}
			for(i=0; i<d5bwr_en.count; i++){
				string = build_CertString(certset->element);
				util_XmStringTableInsert(d5bwr_en.strtable, i, string);
				d5bwr_en.ptr2element[i] = certset->element;
				if(string) { free(string); string = NULL; }
				certset = certset->next;
			}
			break;
			
		case D5BWR_attr_cros_ce:
		
			d5bwr_attrlist.lists[attr_switch] = FALSE;
			break;
			
		case D5BWR_attr_ce_revo:
		
			d5bwr_attrlist.lists[attr_switch] = FALSE;
			break;
	}
}



/**************************************************************************
 *
 * Procedure attrlist_refresh
 *
 * Last modified: 06.02.95
 *
 **************************************************************************/
#ifdef __STDC__

static
void attrlist_refresh(
	enum d5bwr_AttrSwitch		attr_switch
	)
	
#else

static
void attrlist_refresh(
	attr_switch
	)
enum d5bwr_AttrSwitch	attr_switch;

#endif

{
	attrlist_unselectItem();
	util_XmStringTableDelete(&(d5bwr_attrlist.strtable));
	d5bwr_attrlist.count = 0;
	
	switch(attr_switch){
		case D5BWR_attr_user_ce:
		
			if( d5bwr_attrlist.lists[attr_switch] ){
		      		d5bwr_attrlist.strtable = util_XmStringTableCopy(d5bwr_us.strtable);
		      		d5bwr_attrlist.count    = d5bwr_us.count;			
		      	}
			break;
			
		case D5BWR_attr_ca_cert:
		
			if( d5bwr_attrlist.lists[attr_switch] ){
		      		d5bwr_attrlist.strtable = util_XmStringTableCopy(d5bwr_ca.strtable);
		      		d5bwr_attrlist.count    = d5bwr_ca.count;			
		      	}
			break;
			
		case D5BWR_attr_sign_ce:
		
			if( d5bwr_attrlist.lists[attr_switch] ){
		      		d5bwr_attrlist.strtable = util_XmStringTableCopy(d5bwr_si.strtable);
		      		d5bwr_attrlist.count    = d5bwr_si.count;			
		      	}
			break;
			
		case D5BWR_attr_encr_ce:
		
			if( d5bwr_attrlist.lists[attr_switch] ){
		      		d5bwr_attrlist.strtable = util_XmStringTableCopy(d5bwr_en.strtable);
		      		d5bwr_attrlist.count    = d5bwr_en.count;			
		      	}
			break;
			
		case D5BWR_attr_cros_ce:
		
			break;
		case D5BWR_attr_ce_revo:
		
			break;
			
		default:
			attr_switch = D5BWR_attr_none;
			break;
	}
	
	XtVaSetValues(	widgets[attrlist_label].ptr,
	      		XmNlabelString, d5bwr_attrlist.labels[attr_switch],
	      		NULL);
	XtVaSetValues(	widgets[attrlist_list].ptr,
			XmNitemCount, d5bwr_attrlist.count,
			XmNitems,     d5bwr_attrlist.strtable,
			NULL);
	d5bwr_attrlist.current = attr_switch;	
}



/**************************************************************************
 *
 * Procedure build_CertString
 *
 * Last modified: 28.11.94
 *
 **************************************************************************/
#ifdef __STDC__

static
String build_CertString(
	Certificate		*cert
	)
	
#else

static
String build_CertString(
	cert
	)
Certificate	*cert;

#endif

{
	String	string     = NULL,
	        helpstring = NULL;
	
	string = Serialnumber2String(cert->tbs->serialnumber);
	if(helpstring = aux_DName2alias(cert->tbs->issuer, LOCALNAME))
		string = CATSPRINTF(string, " <%s>", helpstring);
	string = CATSPRINTF(string, " (%s)", aux_DName2Name(cert->tbs->issuer));
	if(helpstring)	free(helpstring);
	return string;
}



/**************************************************************************
 *
 * Procedure d5bwr_attrlist_next_cb
 *
 * Last modified: 30.11.94
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_attrlist_next_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void d5bwr_attrlist_next_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{
	enum d5bwr_AttrSwitch	attr_switch = d5bwr_attrlist.current;
	
	do{
		++(attr_switch);
		if( attr_switch == D5BWR_attr_last ) attr_switch = D5BWR_attr_none;
	} while( !d5bwr_attrlist.lists[attr_switch] ); 
	attrlist_refresh(attr_switch);
}



/**************************************************************************
 *
 * Procedure d5bwr_init
 *
 * Last modified: 21.10.94
 *
 **************************************************************************/
#ifdef __STDC__

static
void d5bwr_init()

#else

static
void d5bwr_init()

#endif

{
	MrmCode	rtype; 
	
	if((MrmFetchLiteral(applicationHierarchy,
			    "d5bwr_string_us_ce",
			    display,
			    (XtPointer)&d5bwr_attrlist.labels[D5BWR_attr_user_ce],
			    &rtype) != MrmSUCCESS) || (rtype != MrmRtypeCString)){
		fprintf(stderr, "Error in xmst.uid: Can't fetch string d5bwr_string_us_ce!\n");	
		exit(-1);
	}

	if((MrmFetchLiteral(applicationHierarchy,
			    "d5bwr_string_ca_ce",
			    display,
			    (XtPointer)&d5bwr_attrlist.labels[D5BWR_attr_ca_cert],
			    &rtype) != MrmSUCCESS) || (rtype != MrmRtypeCString)){
		fprintf(stderr, "Error in xmst.uid: Can't fetch string d5bwr_string_ca_cert!\n");	
		exit(-1);
	}
		
	if((MrmFetchLiteral(applicationHierarchy,
			    "d5bwr_string_si_ce",
			    display,
			    (XtPointer)&d5bwr_attrlist.labels[D5BWR_attr_sign_ce],
			    &rtype) != MrmSUCCESS) || (rtype != MrmRtypeCString)){
		fprintf(stderr, "Error in xmst.uid: Can't fetch string d5bwr_string_si_ce!\n");	
		exit(-1);
	}
	
	if((MrmFetchLiteral(applicationHierarchy,
			    "d5bwr_string_en_ce",
			    display,
			    (XtPointer)&d5bwr_attrlist.labels[D5BWR_attr_encr_ce],
			    &rtype) != MrmSUCCESS) || (rtype != MrmRtypeCString)){
		fprintf(stderr, "Error in xmst.uid: Can't fetch string d5bwr_string_en_ce!\n");	
		exit(-1);
	}
	
	if((MrmFetchLiteral(applicationHierarchy,
			    "d5bwr_string_ce_re",
			    display,
			    (XtPointer)&d5bwr_attrlist.labels[D5BWR_attr_ce_revo],
			    &rtype) != MrmSUCCESS) || (rtype != MrmRtypeCString)){
		fprintf(stderr, "Error in xmst.uid: Can't fetch string d5bwr_string_ce_re!\n");	
		exit(-1);
		}

	if((MrmFetchLiteral(applicationHierarchy,
			    "d5bwr_string_cr_ce",
			    display,
			    (XtPointer)&d5bwr_attrlist.labels[D5BWR_attr_cros_ce],
			    &rtype) != MrmSUCCESS) || (rtype != MrmRtypeCString)){
		fprintf(stderr, "Error in xmst.uid: Can't fetch string d5bwr_string_cr_ce!\n");	
		exit(-1);
	}
	if((MrmFetchLiteral(applicationHierarchy,
			    "d5bwr_string_none",
			    display,
			    (XtPointer)&d5bwr_attrlist.labels[D5BWR_attr_none],
			    &rtype) != MrmSUCCESS) || (rtype != MrmRtypeCString)){
		fprintf(stderr, "Error in xmst.uid: Can't fetch string d5bwr_string_none!\n");	
		exit(-1);
	}
}



/**************************************************************************
 *
 * Procedure d5bwr_enter
 *
 * Last modified: 11.11.94
 *
 **************************************************************************/
#ifdef __STDC__

static
void d5bwr_enter()
	
#else

static
void d5bwr_enter()

#endif

{
	if(d5bwr_attribute[D5BWR_attr_user_ce]){
	/* User Certificate */
		if(x500){
		}
		else{
		}
	}
	if(d5bwr_attribute[D5BWR_attr_ca_cert]){
	/* CA Certificate */
		if(x500){
		}
		else{
		}
	}
	if(d5bwr_attribute[D5BWR_attr_ce_revo]){
	/* Certificate Revocation List */
		if(x500){
		}
		else{
		}
	}
	if(d5bwr_attribute[D5BWR_attr_cros_ce]){
	/* Cross Certificate */
		if(x500){
		}
		else{
		}
	}
}



/**************************************************************************
 *
 * Procedure retrieve
 *
 * Last modified: 06.02.95
 *
 **************************************************************************/
#ifdef __STDC__

static void retrieve()
	
#else

static void retrieve()

#endif

{
	enum d5bwr_AttrSwitch attrswitch;
	int  n=0;
	
	THINK_CURSOR();
	attrlist_delete_all();
	
	fork_retrieve();

/***	if(d5bwr_attribute[D5BWR_attr_ce_revo]){
		if(x500){
#ifdef X500
			if( (d5bwr_CRL = af_dir_retrieve_CRL(d5bwr_status.dname)) ){
				;
			}
#endif
			;
		}
		else{
			if( (d5bwr_CRL = af_afdb_retrieve_CRL(d5bwr_status.dname)) ){
				;
			}
		}
	}
	if(d5bwr_attribute[D5BWR_attr_cros_ce]){
		if(x500){
#ifdef X500
			if( (d5bwr_certpairset = 
					af_dir_retrieve_CertificatePair(d5bwr_status.dname)) ){
				;
			}
#endif
			;
		}
		else{
			if( (d5bwr_certpairset = 
					af_afdb_retrieve_CertificatePair(d5bwr_status.dname)) ){
				;
			}
		}
	}***/
	
	/*
	 * Display one of the retrieved attributes and check sensitivity of next-Button
	 */
	for(attrswitch = D5BWR_attr_last; attrswitch > D5BWR_attr_none;){
		if(d5bwr_attrlist.lists[--attrswitch]) n++;
	}
	if(n>0){ 
		attrswitch = D5BWR_attr_last;
		while(! (d5bwr_attrlist.lists[--attrswitch]) );
		attrlist_refresh(attrswitch);
		}
	if(n>1) XtSetSensitive(widgets[attrlist_next].ptr, TRUE);
	
	READY_CURSOR();
}



/**************************************************************************
 *
 * Procedure fork_retrieve
 *
 * Last modified: 02.03.95
 *
 **************************************************************************/
#ifdef __STDC__

static void fork_retrieve()
	
#else

static void fork_retrieve()

#endif

{
	attrlist_delete_all();
	signal(SIGCHLD, fork_retrieve_reset1);
	
	if(!(fork_retrieve_pid = fork())){
		/* child process*/
		SET_OF_Certificate	*certset;
		OctetString 		*octetstr;
		BitString		*bitstr;
		FILE			*tempfile;
		
		tempfile = fopen(d5bwr_tempfile, "w");
		chmod(d5bwr_tempfile, S_IWUSR | S_IRUSR);
		
#ifdef X500
		if(d5bwr_attribute[D5BWR_attr_user_ce] && x500){
			/* retrieve User Certificate */
			if((certset = af_dir_retrieve_Certificate(d5bwr_status.dname, userCertificate))){
				octetstr = e_CertificateSet(certset);
				bitstr   = OctStr2encBitStr(octetstr);
				bitstr2file(bitstr, tempfile);
				aux_free_BitString     (&bitstr);
				aux_free_OctetString   (&octetstr);
				aux_free_CertificateSet(&certset);
			}
			else bitstr2file(NULL, tempfile);
		}
#endif

#ifdef X500	
		if(d5bwr_attribute[D5BWR_attr_ca_cert] && x500){
			/* retrieve CA Certificate */
			if((certset = af_dir_retrieve_Certificate(d5bwr_status.dname, cACertificate)) ){
				octetstr = e_CertificateSet(certset);
				bitstr   = OctStr2encBitStr(octetstr);
				bitstr2file(bitstr, tempfile);
				aux_free_BitString     (&bitstr);
				aux_free_OctetString   (&octetstr);
				aux_free_CertificateSet(&certset);
			}
			else bitstr2file(NULL, tempfile);
		}
#endif

		if(d5bwr_attribute[D5BWR_attr_sign_ce] && !x500){
			/* retrieve Signature Certificate */
			if((certset = af_afdb_retrieve_Certificate(d5bwr_status.dname, SIGNATURE))){
				octetstr = e_CertificateSet(certset);
				bitstr   = OctStr2encBitStr(octetstr);
				bitstr2file(bitstr, tempfile);
				aux_free_BitString     (&bitstr);
				aux_free_OctetString   (&octetstr);
				aux_free_CertificateSet(&certset);
			}
			else bitstr2file(NULL, tempfile);
		}
	
		if(d5bwr_attribute[D5BWR_attr_encr_ce] && !x500){
			/* retrieve Encryption Certificate */
			if((certset = af_afdb_retrieve_Certificate(d5bwr_status.dname, ENCRYPTION))){
				octetstr = e_CertificateSet(certset);
				bitstr   = OctStr2encBitStr(octetstr);
				bitstr2file(bitstr, tempfile);
				aux_free_BitString     (&bitstr);
				aux_free_OctetString   (&octetstr);
				aux_free_CertificateSet(&certset);
			}
			else bitstr2file(NULL, tempfile);
		}

		fclose(tempfile);
		_exit(0); /*** fork()-Prozess ***/
	}	
	
	else if(fork_retrieve_pid == -1){
		/*** no child created ***/
		sprintf(dialog_message, "Can't open 2nd Process for\nretrieve operation");
		ok_dialog_open(d5bwrDialog, dialog_message);
	}
	else if(fork_retrieve_pid > 0){
		/*** child created ***/
		BUSY_CURSOR();
		MANAGE_MODELESS_DIALOG(widgets[working_dialog].ptr);
	}

}



/**************************************************************************
 *
 * Procedure d5bwr_workdiag_cb
 *
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_workdiag_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void d5bwr_workdiag_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{
	if(!kill(fork_retrieve_pid, 0)){
		kill(fork_retrieve_pid, SIGKILL);
		IDLE_CURSOR();
	}
}



/**************************************************************************
 *
 * Procedure fork_retrieve_reset1
 *
 * Last modified: 02.03.95
 *
 **************************************************************************/
#ifdef __STDC__

static void fork_retrieve_reset1()
	
#else

static void fork_retrieve_reset1()

#endif

{
	int 		status;
	
	waitpid(fork_retrieve_pid, &status, 0);

	if(WIFEXITED(status)){
		/*** fork exited normally ***/
		enum d5bwr_AttrSwitch 	attrswitch;
		int  			n;
		OctetString		*octetstr;
		BitString		*bitstr;
		FILE			*tempfile;
		
		tempfile = fopen(d5bwr_tempfile, "r");
			
#ifdef X500
		if(d5bwr_attribute[D5BWR_attr_user_ce] && x500){
			/* User Certificate */
			file2bitstr(tempfile, &bitstr);
			if(bitstr){
				octetstr         = BitStr2decOctStr(bitstr);
				d5bwr_us.certset = d_CertificateSet(octetstr);
				attrlist_build(D5BWR_attr_user_ce);
				aux_free_OctetString(&octetstr);
				aux_free_BitString(&bitstr);
			}
		}
#endif

#ifdef X500	
		if(d5bwr_attribute[D5BWR_attr_ca_cert] && x500){
			/* CA Certificate */
			file2bitstr(tempfile, &bitstr);
			if(bitstr){
				octetstr         = BitStr2decOctStr(bitstr);
				d5bwr_ca.certset = d_CertificateSet(octetstr);
				attrlist_build(D5BWR_attr_ca_cert);
				aux_free_OctetString(&octetstr);
				aux_free_BitString(&bitstr);
			}
		}
#endif

		if(d5bwr_attribute[D5BWR_attr_sign_ce] && !x500){
			/* Signature Certificate */
			file2bitstr(tempfile, &bitstr);
			if(bitstr){
				octetstr         = BitStr2decOctStr(bitstr);
				d5bwr_si.certset = d_CertificateSet(octetstr);
				attrlist_build(D5BWR_attr_sign_ce);
				aux_free_OctetString(&octetstr);
				aux_free_BitString(&bitstr);
			}
		}
		
		if(d5bwr_attribute[D5BWR_attr_encr_ce] && !x500){
			/* Encryption Certificate */
			file2bitstr(tempfile, &bitstr);
			if(bitstr){
				octetstr         = BitStr2decOctStr(bitstr);
				d5bwr_en.certset = d_CertificateSet(octetstr);
				attrlist_build(D5BWR_attr_encr_ce);
				aux_free_OctetString(&octetstr);
				aux_free_BitString(&bitstr);
			}
		}
		
		fclose(tempfile);
		
		/*
	 	 * Display one of the retrieved attributes and check sensitivity of next-Button
	 	 */
	 	n = 0;
		for(attrswitch = D5BWR_attr_last; attrswitch > D5BWR_attr_none;){
			if(d5bwr_attrlist.lists[--attrswitch]) n++;
		}
		if(n>0){ 
			attrswitch = D5BWR_attr_last;
			while(! (d5bwr_attrlist.lists[--attrswitch]) );
			attrlist_refresh(attrswitch);
		}
		if(n>1) XtSetSensitive(widgets[attrlist_next].ptr, TRUE);
		
		XtAppAddTimeOut (applicationContext, 0, fork_retrieve_reset2, NULL);
	}
	else {
		/*** fork killed ***/;
	}
	unlink(d5bwr_tempfile);
}



/**************************************************************************
 *
 * Procedure fork_retrieve_reset2
 *
 * Last modified: 17.03.95
 *
 **************************************************************************/
#ifdef __STDC__

static void fork_retrieve_reset2()
	
#else

static void fork_retrieve_reset2()

#endif

{
	XtUnmanageChild(widgets[working_dialog].ptr);
	IDLE_CURSOR();
}



/**************************************************************************
 *
 * Procedure d5bwr_remove
 *
 * Last modified: 11.11.94
 *
 **************************************************************************/
#ifdef __STDC__

static
void d5bwr_remove()
	
#else

static
void d5bwr_remove()

#endif

{
	if(d5bwr_attribute[D5BWR_attr_user_ce]){
	/* User Certificate */
		if(x500){
		}
		else{
		}
	}
	if(d5bwr_attribute[D5BWR_attr_ca_cert]){
	/* CA Certificate */
		if(x500){
		}
		else{
		}
	}
	if(d5bwr_attribute[D5BWR_attr_ce_revo]){
	/* Certificate Revocation List */
		if(x500){
		}
		else{
		}
	}
	if(d5bwr_attribute[D5BWR_attr_cros_ce]){
	/* Cross Certificate */
		if(x500){
		}
		else{
		}
	}
}



/**************************************************************************
 *
 * Procedure d5bwr_attrlist_view_cb
 *
 * Last modified: 19.12.94
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_attrlist_view_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void d5bwr_attrlist_view_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{
	if( open_write_tempfile(d5bwrDialog) >= 0 ){
		switch(d5bwr_attrlist.current){
			case D5BWR_attr_user_ce:
						
				aux_fprint_Certificate(logfile, d5bwr_us.ptr2element[d5bwr_attrlist.selectedItem]);
				break;

			case D5BWR_attr_ca_cert:
						
				aux_fprint_Certificate(logfile, d5bwr_ca.ptr2element[d5bwr_attrlist.selectedItem]);
				break;

			case D5BWR_attr_sign_ce:
			
				aux_fprint_Certificate(logfile, d5bwr_si.ptr2element[d5bwr_attrlist.selectedItem]);
				break;
				
			case D5BWR_attr_encr_ce:
			
				aux_fprint_Certificate(logfile, d5bwr_en.ptr2element[d5bwr_attrlist.selectedItem]);
				break;
				
			case D5BWR_attr_ce_revo:
				break;
				
			case D5BWR_attr_cros_ce:
				break;
			case D5BWR_attr_none:
				break;
		}
		close_tempfile();
		start_editor();
	}
	else remove_tempfile(); 
}



/**************************************************************************
 *
 * Procedure d5bwr_attrlist_verify_cb
 *
 * Last modified: 23.01.95
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_attrlist_verify_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void d5bwr_attrlist_verify_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{
	Certificate *cert = NULL;
	
	switch(d5bwr_attrlist.current){
		case D5BWR_attr_user_ce:
			cert = aux_cpy_Certificate(d5bwr_us.ptr2element[d5bwr_attrlist.selectedItem]);
			break;
		
		case D5BWR_attr_ca_cert:
			cert = aux_cpy_Certificate(d5bwr_ca.ptr2element[d5bwr_attrlist.selectedItem]);
			break;
			
		case D5BWR_attr_sign_ce:
			cert = aux_cpy_Certificate(d5bwr_si.ptr2element[d5bwr_attrlist.selectedItem]);
			break;
			
		case D5BWR_attr_encr_ce:
			cert = aux_cpy_Certificate(d5bwr_en.ptr2element[d5bwr_attrlist.selectedItem]);
			break;
			
		default:
			return;
			break;
	}
	
	verificate(d5bwrDialog, cert, TRUE); 
	aux_free2_Certificate(cert);	
}



/**************************************************************************
 *
 * Procedure attrlist_delete_all
 *
 * Last modified: 04.01.95
 *
 **************************************************************************/
#ifdef __STDC__

static void attrlist_delete_all()
	
#else

static void attrlist_delete_all()

#endif

{
	attrlist_delete(D5BWR_attr_sign_ce);
	attrlist_delete(D5BWR_attr_encr_ce);
	attrlist_delete(D5BWR_attr_ca_cert);
	attrlist_delete(D5BWR_attr_user_ce);
	attrlist_delete(D5BWR_attr_cros_ce);
	attrlist_delete(D5BWR_attr_ce_revo);
	
	attrlist_refresh(D5BWR_attr_none);
	XtSetSensitive(widgets[attrlist_next].ptr, FALSE);
	
}



/**************************************************************************
 *
 * Procedure attrlist_delete
 *
 * Last modified: 19.12.94
 *
 **************************************************************************/
#ifdef __STDC__

static
void attrlist_delete(
	enum d5bwr_AttrSwitch		attr_switch
	)
	
#else

static
void attrlist_delete(
	attr_switch
	)
enum d5bwr_AttrSwitch		attr_switch;

#endif

{
	d5bwr_attrlist.lists[attr_switch] = FALSE;
	
	switch(attr_switch){
		case D5BWR_attr_user_ce:
		
			aux_free_CertificateSet(&(d5bwr_us.certset));
			util_XmStringTableDelete(&(d5bwr_us.strtable));
			free(d5bwr_us.ptr2element);
			d5bwr_us.ptr2element = NULL;
			d5bwr_us.count = 0;
			break;
			
		case D5BWR_attr_ca_cert:
		
			aux_free_CertificateSet(&(d5bwr_ca.certset));
			util_XmStringTableDelete(&(d5bwr_ca.strtable));
			free(d5bwr_ca.ptr2element);
			d5bwr_ca.ptr2element = NULL;
			d5bwr_ca.count = 0;
			break;
			
		case D5BWR_attr_sign_ce:
		
			aux_free_CertificateSet(&(d5bwr_si.certset));
			util_XmStringTableDelete(&(d5bwr_si.strtable));
			free(d5bwr_si.ptr2element);
			d5bwr_si.ptr2element = NULL;
			d5bwr_si.count       = 0;
			break;
			
		case D5BWR_attr_encr_ce:
		
			aux_free_CertificateSet(&(d5bwr_en.certset));
			util_XmStringTableDelete(&(d5bwr_en.strtable));
			free(d5bwr_en.ptr2element);
			d5bwr_en.ptr2element = NULL;
			d5bwr_en.count = 0;
			break;
			
		case D5BWR_attr_ce_revo:
			break;
			
		case D5BWR_attr_cros_ce:
			break;
	}
}



/**************************************************************************
 *
 * Procedure d5bwr_attrlist_add2pk_cb
 *
 * Last modified: 15.03.95
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_attrlist_add2pk_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void d5bwr_attrlist_add2pk_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{
	ToBeSigned 	*tbs = NULL;
	

	switch(d5bwr_attrlist.current){
		case D5BWR_attr_user_ce:
			
			tbs = (d5bwr_us.ptr2element[d5bwr_attrlist.selectedItem])->tbs;					
			break;
			
		case D5BWR_attr_ca_cert:
					
			tbs = (d5bwr_ca.ptr2element[d5bwr_attrlist.selectedItem])->tbs;					
			break;

		case D5BWR_attr_sign_ce:
		
			tbs = (d5bwr_si.ptr2element[d5bwr_attrlist.selectedItem])->tbs;					
			break;
				
		case D5BWR_attr_encr_ce:
			
			tbs = (d5bwr_en.ptr2element[d5bwr_attrlist.selectedItem])->tbs;					
			break;
				
		case D5BWR_attr_ce_revo:
			break;
				
		case D5BWR_attr_cros_ce:
			break;
				
		case D5BWR_attr_none:
			break;
		}
		
	if(tbs){
		if(af_pse_add_PK(SIGNATURE, tbs) < 0){
			sprintf(dialog_message, "Unable to update key list");
			ok_dialog_open(d5bwrDialog, dialog_message);
		}
		else{
			st_fill_widgets();
		}
	}
	else{
		sprintf(dialog_message, "Unable to extract ToBeSigned from data");
		ok_dialog_open(d5bwrDialog, dialog_message);
	}	
}



/**************************************************************************
 *
 * Procedure d5bwr_attrlist_add2ek_cb
 *
 * Last modified: 15.03.95
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_attrlist_add2ek_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void d5bwr_attrlist_add2ek_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{
	ToBeSigned 	*tbs = NULL;
	

	switch(d5bwr_attrlist.current){
		case D5BWR_attr_user_ce:
			
			tbs = (d5bwr_us.ptr2element[d5bwr_attrlist.selectedItem])->tbs;					
			break;
			
		case D5BWR_attr_ca_cert:
					
			tbs = (d5bwr_ca.ptr2element[d5bwr_attrlist.selectedItem])->tbs;					
			break;

		case D5BWR_attr_sign_ce:
		
			tbs = (d5bwr_si.ptr2element[d5bwr_attrlist.selectedItem])->tbs;					
			break;
				
		case D5BWR_attr_encr_ce:
			
			tbs = (d5bwr_en.ptr2element[d5bwr_attrlist.selectedItem])->tbs;					
			break;
				
		case D5BWR_attr_ce_revo:
			break;
				
		case D5BWR_attr_cros_ce:
			break;
				
		case D5BWR_attr_none:
			break;
		}
		
	if(tbs){
		if(af_pse_add_PK(ENCRYPTION, tbs) < 0){
			sprintf(dialog_message, "Unable to update key list");
			ok_dialog_open(d5bwrDialog, dialog_message);
		}
		else{
			st_fill_widgets();
		}
	}
	else{
		sprintf(dialog_message, "Unable to extract ToBeSigned from data");
		ok_dialog_open(d5bwrDialog, dialog_message);
	}	
}



/**************************************************************************
 *
 * Procedure d5bwr_attrlist_add2pca_cb
 *
 * Last modified: 15.03.95
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_attrlist_add2pca_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void d5bwr_attrlist_add2pca_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{
	ToBeSigned 	*tbs = NULL;


	switch(d5bwr_attrlist.current){
		case D5BWR_attr_user_ce:
			
			tbs = (d5bwr_us.ptr2element[d5bwr_attrlist.selectedItem])->tbs;					
			break;
			
		case D5BWR_attr_ca_cert:
					
			tbs = (d5bwr_ca.ptr2element[d5bwr_attrlist.selectedItem])->tbs;					
			break;

		case D5BWR_attr_sign_ce:
		
			tbs = (d5bwr_si.ptr2element[d5bwr_attrlist.selectedItem])->tbs;					
			break;
				
		case D5BWR_attr_encr_ce:
			
			tbs = (d5bwr_en.ptr2element[d5bwr_attrlist.selectedItem])->tbs;					
			break;
				
		case D5BWR_attr_ce_revo:
			break;
				
		case D5BWR_attr_cros_ce:
			break;
				
		case D5BWR_attr_none:
			break;
		}
		
	if(tbs){
		if(af_pse_add_PCA(tbs) < 0){
			sprintf(dialog_message, "Unable to update key list");
			ok_dialog_open(d5bwrDialog, dialog_message);
		}
		else{
			st_fill_widgets();
		}
	}
	else{
		sprintf(dialog_message, "Unable to extract ToBeSigned from data");
		ok_dialog_open(d5bwrDialog, dialog_message);
	}		
}



/**************************************************************************
 *
 * Procedure d5bwr_attrlist_add2pseobj_cb
 *
 * Last modified: 16.03.95
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_attrlist_add2pseobj_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void d5bwr_attrlist_add2pseobj_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{
	void		*opaque = NULL;
	ObjId		opaque_oid;
	char		*selected_object;
	ObjId		*listofobjid[2];
	
	
	listofobjid[0] = Cert_OID;
	listofobjid[1] = NULL;
	
	if( selected_object = pseobjselection_open(d5bwrDialog,
			"Select a PSE-Object of the type\n * Certificate\n or enter a new name",
			listofobjid, TRUE) ){
			
		/*
		 *	check for secret objects
		 */
		if (!strcmp(selected_object, SKnew_name)
		     || !strcmp(selected_object, SKold_name)
		     || !strcmp(selected_object, SignSK_name)
		     || !strcmp(selected_object, DecSKnew_name)
		     || !strcmp(selected_object, DecSKold_name)) {
			      
			sprintf(dialog_message, "%s\n\"%s\"",
				"Secret keys must not be overwritten:",
				selected_object);
			
			return;
		}
		
		switch(d5bwr_attrlist.current){
			case D5BWR_attr_user_ce:
			
				opaque = d5bwr_us.ptr2element[d5bwr_attrlist.selectedItem];	
				aux_cpy2_ObjId(&opaque_oid, Cert_OID);
				break;
			
			case D5BWR_attr_ca_cert:
					
				opaque = d5bwr_ca.ptr2element[d5bwr_attrlist.selectedItem];				
				aux_cpy2_ObjId(&opaque_oid, Cert_OID);
				break;
	
			case D5BWR_attr_sign_ce:
		
				opaque = d5bwr_si.ptr2element[d5bwr_attrlist.selectedItem];				
				aux_cpy2_ObjId(&opaque_oid, Cert_OID);
				break;
				
			case D5BWR_attr_encr_ce:
				
				opaque = d5bwr_en.ptr2element[d5bwr_attrlist.selectedItem];				
				aux_cpy2_ObjId(&opaque_oid, Cert_OID);
				break;
				
			case D5BWR_attr_ce_revo:
				break;
				
			case D5BWR_attr_cros_ce:
				break;
					
			case D5BWR_attr_none:
				break;
		}

			
			
		if( af_pse_update(selected_object, opaque, &opaque_oid) < 0 ){
			sprintf(dialog_message, "%s\n\"%s\"",
						"Unable to write data into",
						selected_object);
			ok_dialog_open(d5bwrDialog, dialog_message);
		}
		else{
			st_fill_widgets();
		}
	}
}



/**************************************************************************
 *
 * Procedure d5bwr_attrlist_add2clipb_cb
 *
 * Last modified: 06.03.95
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_attrlist_add2clipb_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void d5bwr_attrlist_add2clipb_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{	
	void			*opaque = NULL;
	ObjId			opaque_oid;
	ClipboardSource 	clip_source = x500 ? CB_X500 : CB_AFDB;
	
	
	switch(d5bwr_attrlist.current){
		case D5BWR_attr_user_ce:
			
			opaque = d5bwr_us.ptr2element[d5bwr_attrlist.selectedItem];					
			aux_cpy2_ObjId(&opaque_oid, Cert_OID);
			break;
			
		case D5BWR_attr_ca_cert:
					
			opaque = d5bwr_ca.ptr2element[d5bwr_attrlist.selectedItem];					
			aux_cpy2_ObjId(&opaque_oid, Cert_OID);
			break;

		case D5BWR_attr_sign_ce:
		
			opaque = d5bwr_si.ptr2element[d5bwr_attrlist.selectedItem];					
			aux_cpy2_ObjId(&opaque_oid, Cert_OID);
			break;
				
		case D5BWR_attr_encr_ce:
			
			opaque = d5bwr_en.ptr2element[d5bwr_attrlist.selectedItem];					
			aux_cpy2_ObjId(&opaque_oid, Cert_OID);
			break;
				
		case D5BWR_attr_ce_revo:
			break;
				
		case D5BWR_attr_cros_ce:
			break;
				
		case D5BWR_attr_none:
			break;
		}
		
	if( clipboard_copy(	d5bwrDialog,
				clip_source,
				"empty",
				opaque,
				opaque_oid) < 0 ){
				
		sprintf(dialog_message, "Unable to copy to Clipboard");
		ok_dialog_open(d5bwrDialog, dialog_message);
	}
}



/**************************************************************************
 *
 * Procedure bitstr2file
 *
 * Last modified: 02.03.95
 *
 **************************************************************************/
#ifdef __STDC__

static void bitstr2file(
	BitString	*bitstr,
	FILE		*file
	)
	
#else

static void bitstr2file(
	bitstr,
	file
	)
BitString	*bitstr;
FILE		*file;

#endif

{
	char	string[21];
	int	len;
	
	if(bitstr){
		len = bitstr->nbits / 8;
		sprintf(string, "%20d", len);
		fwrite(string,       sizeof(char),  21, file);
		fwrite(bitstr->bits, sizeof(char), len, file);
	}
	else{
		sprintf(string, "%-20s", "empty");
		fwrite(string, sizeof(char), 21, file);	
	}
}



/**************************************************************************
 *
 * Procedure file2bitstr
 *
 * Last modified: 02.03.95
 *
 **************************************************************************/
#ifdef __STDC__

static void file2bitstr(
	FILE		*file,
	BitString	**bitstr
	)
	
#else

static void file2bitstr(
	file,
	bitstr
	)
FILE		*file;
BitString	**bitstr;

#endif

{
	char 	string[21];
	int	len;
	
	fread(string, sizeof(char), 21, file);
	if(strncmp(string, "empty", 5)){
		len              = atoi(string);
		*bitstr          = (BitString *)malloc(sizeof(BitString));
		(*bitstr)->bits  = (char *)malloc(sizeof(char) * len);
		(*bitstr)->nbits = len * 8;
		fread((*bitstr)->bits, sizeof(char), len, file);
	}
	else{
		*bitstr = NULL;
	}
}


/**************************************************************************
 *
 * Procedure d5bwr_attrlist_test_cb
 *
 * Last modified: 95
 *
 **************************************************************************/
#ifdef __STDC__

void d5bwr_attrlist_test_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void d5bwr_attrlist_test_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{
	ObjId			*listofobjid[5];
	String			selected_object;
		
	listofobjid[0] = Cert_OID;
	listofobjid[1] = SignCert_OID;
	listofobjid[2] = EncCert_OID;
	listofobjid[3] = FCPath_OID;
	listofobjid[4] = NULL;	

	if (!(selected_object = pseobjselection_open(d5bwrDialog,
 			"Select a PSE-Object of the type\n * FCPath or\n * Certificate",
 			listofobjid, FALSE))){
			/*** Fehler ***/
	}
}



