/* ./src/util/xmsectool/maintain.c */

static char *rcsid = "$Id: maintain.c,v 1.11 1995/03/07 10:58:54 surkau Exp $";

/*
 * $Id: maintain.c,v 1.11 1995/03/07 10:58:54 surkau Exp $
 *
 * $Log: maintain.c,v $
 *
 */
 
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/



/*
 ************************
 *	INCLUDES	*
 ************************
 */

#include "xmst.h"

#define DIRMASK 0755
#define OBJMASK 0644





/*
 ************************************************************************
 *									*
 *			psemaint.c					*
 *									*
 ************************************************************************
 */





/*
 ************************
 *	STATICS		*
 ************************
 */

#ifdef __STDC__
	static num(char	*par);
#else
	static num();
#endif


/***************************************************************
 *
 * Procedure num
 *
 ***************************************************************/
#ifdef __STDC__

static int num(
	register char	 *par
)

#else

static int num(
	par
)
register char	 *par;

#endif

{
        while(*par) {
                if (*par < '0' || *par > '9') return(FALSE);
                par++;
        }
        return(TRUE);
}






/*
 *	build_key
 *	Build Key structure for generation/deletion
 *
 * 	cmd			GENKEY, DELKEY
 * 	action			GEN_SYM, GEN_PUBLIC, GEN_SECRET 
 * 	sct_flag		TRUE: store/delete in SCT
 * 	rw_flag			OPEN_TO_READ, OPEN_TO_WRITE
 */

/***************************************************************
 *
 * Procedure build_key
 *
 ***************************************************************/
#ifdef __STDC__

Key *build_key(
	Widget		  parentShell,
	Command		  cmd,
	KeygenAction	  action,
	char		 *key_name_or_ref,
	Boolean		  sct_flag,
	int		  rw_flag
)

#else

Key *build_key(
	parentShell,
	cmd,
	action,
	key_name_or_ref,
	sct_flag,
	rw_flag
)
Widget		  parentShell;
Command		  cmd;
KeygenAction	  action;
char		 *key_name_or_ref;
Boolean		  sct_flag;
int		  rw_flag;

#endif

{
	char 			*proc = "build_key";
        char 			*dd, *cc;
	char 			answ[8];
	int 			i;
        KeyInfo 		zwkey;
        OctetString 		ostring;
	char 			newstring[64];
	Key 			*newkey;
	PSEConfig 		pse_config;
	AlgEnc   		algenc;
	int	 		keyref;


	newkey = (Key *)calloc(1, sizeof(Key));
	if (!newkey) return((Key *)0);

        if (cmd == GENKEY) {
                newkey->key = (KeyInfo *)calloc(1, sizeof(KeyInfo));
 		if (!newkey->key) {
			return((Key *)0);
		}
                newkey->key->subjectAI = aux_Name2AlgId(algname);
                if (!newkey->key->subjectAI) {
			free(newkey->key);
			free(newkey);
                        return((Key *)0);
                }
        }

        if (!key_name_or_ref || num(key_name_or_ref)) {
        
		if (!key_name_or_ref) newkey->keyref = -1;
                else {
                	if (strlen(key_name_or_ref) == 0) newkey->keyref = -1;
                	else sscanf(key_name_or_ref, "%d", &(newkey->keyref));
			if (newkey->keyref == 0) newkey->keyref = -1;
		}
		
		
/* DONT DO THAT ! */
#ifdef DONT_DO_THAT
		
#ifdef SCA
		else {
			/*
			 * GENKEY: 
			 *   check whether a DES/DES3 key shall be generated in SCT/SC 
			 * DELKEY: 
			 *   check whether a key stored in the SCT shall be deleted
			 */
		
			if (cmd == GENKEY) {
			
				algenc = aux_ObjId2AlgEnc(newkey->key->subjectAI->objid);
				
				if ((algenc == DES) || (algenc == DES3)) {
				
					fprintf	(stderr, "Store key in KeyPool (0), in the SCT (1), \
								in the Smartcard (2):");
					gets(answ);
					if ((answ[0] == '1') || (answ[0] == '2')) {

						/*
						 *  Store key in SCT/SC
						 */

						if (answ[0] == '1') {
							 keyref = newkey->keyref | SCT_KEY;
                               				 newkey->keyref = keyref;
						}
						else {
							/*
							 * Check whether pse = pse on SC
							 */
							if ((pse_location = sec_psetest(std_pse.app_name))
									== ERR_in_psetest) {
								fprintf(stderr,
									"Error during test for pse: %s\n",
									std_pse.app_name);
								aux_free_Key(&newkey);
								return((Key *)0);
							}

							if (pse_location == SWpse) {
                       						fprintf(stderr,
                       							"\nCannot generate a key on the \
                       							smartcard:\n");
                       						fprintf(stderr,
                       							"PSE %s is not a smartcard PSE\n",
                       							std_pse.app_name);
								aux_free_Key(&newkey);
								return((Key *)0);
							}
                               				keyref = newkey->keyref | SC_KEY;
                               				newkey->keyref = keyref;
						}
						return (newkey);
					}
				}
			
			}
			if (cmd == DELKEY) {
			
				if (sct_flag) {

					/*
					 *  Delete key in SCT
					 */

                               		keyref = newkey->keyref | SCT_KEY;
                               		newkey->keyref = keyref;
					return (newkey);

				}
			}
			
		}
#endif

#endif /* DONT_DO_THAT */



		if (cmd == GENKEY && publickey && newkey->keyref != -1
		    && newkey->keyref == publickey->keyref) {
		    
                       	ok_dialog_open(parentShell,
                       			"Public key and secret key must have different references.");
                       			
			aux_free_Key(&newkey);
			
			return((Key *)0);
		}
		
		if (newkey->keyref > 0 && cmd == GENKEY && replace == FALSE) {
		
			if (sec_get_key(&zwkey, newkey->keyref, (Key *)0) == 0) {
			
				aux_free2_KeyInfo(&zwkey);
				
                               	sprintf(dialog_message, "Keyref already exists:\n\"%d\"",
                               				newkey->keyref);
                               	if (repl_canc_dialog_open(parentShell, dialog_message)) {
                               	
					sec_del_key(newkey->keyref);
					
					if (action == GEN_SECRET) replace = TRUE;
					
				} else {
				
					aux_free_Key(&newkey);
					
					return((Key *)0);
				}
			} 
		}
		
        } else {
        
                newkey->pse_sel = aux_cpy_PSESel(&std_pse);
		newkey->pse_sel->object.name = aux_cpy_String(key_name_or_ref);
		
		for (i = 0; i < PSE_MAXOBJ; i++) {
		
			if (strcmp(AF_pse.object[i].name, newkey->pse_sel->object.name) == 0) {
			
				newkey->pse_sel->object.pin = aux_cpy_String(AF_pse.object[i].pin);
				break;
               		}
               	}	
               	
		if (cmd == GENKEY) {
		
			if (publickey && newkey->pse_sel && publickey->pse_sel
			    && !strcmp(newkey->pse_sel->object.name, publickey->pse_sel->object.name)) {
			
	                       	ok_dialog_open(	parentShell,
	                       			"Public key and secret key must have different names.");
	                       	
				aux_free_Key(&newkey);
				
				return((Key *)0);
			}


/* DONT DO THAT ! */
#ifdef DONT_DO_THAT

#ifdef SCA

			if ((pse_location = sec_psetest(newkey->pse_sel->app_name)) == ERR_in_psetest) {
				fprintf(stderr, "Error during test for pse: %s\n",
						newkey->pse_sel->app_name);
				aux_free_Key(&newkey);
				return((Key *)0);
			}

			if ((pse_location == SCpse) && (!sec_open(newkey->pse_sel))) {
				if (action == GEN_SECRET) {
                                	fprintf(stderr, "Replace existing secret key? (y/n): ");
                                	gets(answ);
                                	if (answ[0] == 'y') replace = TRUE;  /* replace is global */
				}
				if ((pse_config = sec_pse_config(newkey->pse_sel)) == ERR_in_pseconfig) {
	                       		fprintf(stderr, "Error in PSE configuration (SCINITFILE)\n");
					aux_free_Key(&newkey);
					return((Key *)0);
				}
				if (pse_config != NOT_ON_SC) {
					if (action == GEN_SYM) {
                                		fprintf(stderr, "Replace existing DES key? (y/n): ");
                                		gets(answ);
                                		if (answ[0] == 'y') replace = TRUE;
					}
				}
				return(newkey);
                        }
#endif

#endif /* DONT_DO_THAT */


		}
		
                if (sec_open(newkey->pse_sel) < 0) {
                
                        if (rw_flag == OPEN_TO_READ) {
                        
                                sprintf(dialog_message,
                                	"Can't open Object:\n\"%s\"", newkey->pse_sel->object.name);
                                ok_dialog_open(parentShell, dialog_message);
                                
				aux_add_error(EINVALID, "sec_open failed", CNULL, 0, proc);
				aux_free_Key(&newkey);
				
                                return((Key *)0);
                        }
                        
                        aux_free_error();

			/*
			 *  Open (object) failed => object doesn't exist.
			 *    
			 *  If object to be generated is a key on the SC => no creation of object.
			 *      
			 */

			if ((pse_config = sec_pse_config(newkey->pse_sel)) == ERR_in_pseconfig) {
			
	                       	ok_dialog_open(parentShell, "Error in PSE configuration.");
	                       	
				aux_free_Key(&newkey);
				
				return((Key *)0);
			}
			
			if (pse_config != KEY_ON_SC) {

                        	newkey->pse_sel->object.pin = aux_cpy_String(newkey->pse_sel->pin);
                        	
                        	if (sec_create(newkey->pse_sel) < 0) {
                        	
	                                sprintf(dialog_message,
	                                	"Can't create Object:\n\"%s\"", newkey->pse_sel->object.name);
	                                ok_dialog_open(parentShell, dialog_message);
	                                	
					aux_add_error(EINVALID, "sec_open failed", CNULL, 0, proc);
					aux_free_Key(&newkey);
					
                                	return((Key *)0);
                        	}
                        	
				if (action != GEN_PUBLIC) replace = TRUE;
				
				for (i = 0; i < PSE_MAXOBJ; i++) {
				
					if (!strcmp(AF_pse.object[i].name, newkey->pse_sel->object.name)) {
					
						AF_pse.object[i].pin =
							aux_cpy_String(newkey->pse_sel->object.pin);
						break;
                      	      		}
				}
			}
                        return(newkey);
                }
 
		for (i = 0; i < PSE_MAXOBJ; i++) {
		
			if (!strcmp(AF_pse.object[i].name, newkey->pse_sel->object.name)) {
			
				AF_pse.object[i].pin = aux_cpy_String(newkey->pse_sel->object.pin);
				break;
				
                        } else if (rw_flag == OPEN_TO_WRITE) {
                        
				if (cmd == GENKEY && replace == TRUE) return(newkey);
				
                               	sprintf(dialog_message, "Object already exists:\n\"%s\"",
                               				newkey->pse_sel->object.name);
                               	if (repl_canc_dialog_open(parentShell, dialog_message)) {
                               	
					if (action != GEN_PUBLIC) replace = TRUE;
					
				} else {

                                	aux_free_Key(&newkey);
                                	
					return((Key *)0);
				}
				
				
                                return(newkey);
                        }
                }
        }
        return(newkey);
}











/*
 ************************************************************************
 *									*
 *			algs.c						*
 *									*
 ************************************************************************
 */




/*
 ************************
 *	STATICS		*
 ************************
 */


static char lastname[64];
	
char            	*clearoctets;
char            	*encryptedbits;
char            	*recoveredoctets;
int			keysizes[128] = {512, 640, 768, 1024, 0};
int 			quantity = 102400;
char            	RSA_PK_name[16] = ALGS_RSA_PK_name;
char            	RSA_SK_name[16] = ALGS_RSA_SK_name;
char            	DSA_PK_name[16] = ALGS_DSA_PK_name;
char            	DSA_SK_name[16] = ALGS_DSA_SK_name;
PSESel          	psesel;
char			psename[256];
char           		*pseobject;
FILE			*ff;


#ifdef __STDC__

	static HashInput	*build_hashinput(KeyInfo *keyinfo);
	static KeyInfo		*getkey(char *name);
	static void		print_alginfo(AlgList *a, char *string, int keysize, long sec1, long usec1,
						long sec2, long usec2, long sec3, long usec3);
	static RC	 	check_testkeys_PSE(void);
	static RC	 	putkeys(AlgList	*a, char *sk, char *pk, BitString *skey_b, BitString *pkey_b, int keysize);
	static RC      		time_keygen(AlgList *a, char *sk, char *pk, int	keysize);
	static RC      		time_signverify(AlgList *a, char *sk, char *pk, int keysize);
	static RC      		time_encdec(AlgList *a, char *sk, char *pk, int keysize);
	static RC      		time_hash(AlgList *a);

#else

	static HashInput	*build_hashinput();
	static KeyInfo		*getkey();
	static void		print_alginfo();
	static RC	 	check_testkeys_PSE();
	static RC	 	putkeys();
	static RC      		time_keygen();
	static RC      		time_signverify();
	static RC      		time_encdec();
	static RC      		time_hash();

#endif



/***************************************************************
 *
 * Procedure test_alg
 *
 ***************************************************************/
#ifdef __STDC__

RC test_alg(
	Widget		parentShell,
	FILE	 	*logfile,
	AlgList	 	*a
)

#else

RC test_alg(
	parentShell,
	logfile,
	a
)
Widget		parentShell;
FILE	 	*logfile;
AlgList	 	*a;

#endif

{
	int  n, rc = 0, rc1;
	char *pk, *sk;
	
	
	ff = logfile;
		
	if (check_testkeys_PSE() < 0) return(-1);
	
	clearoctets = (char *)malloc(quantity);
	encryptedbits = (char *)malloc(quantity + 1024);
	recoveredoctets = (char *)malloc(quantity + 1024);
	for (n = 0; n < quantity; n++) clearoctets[n] = (n % 96) + 32;
	
	strcpy(lastname, "");
	
		
/*	test_alg tests a single algorithm. It performs
 *	-   time_signverify for each requested keysize in case of a SIG alg,
 *	-   time_encdec for each requested keysize in case of an ASYM_ENC alg,
 *      -   time_encdec in case of a SYM_ENC alg,
 *	-   time_hash in case of a HASH alg,
 */

	switch (a->algtype) {

	case SIG:
	case ASYM_ENC:

		n = 0;
		while (keysizes[n]) {

			sprintf(dialog_message, "Testing algorithm with keysize <%d>.", keysizes[n]);
			processing_dialog_open(parentShell, dialog_message);
		        XmUpdateDisplay(parentShell);
		        
			switch (a->algenc) {
			
				case RSA:
					sprintf(RSA_PK_name + strlen(ALGS_RSA_PK_name), "%d", keysizes[n]);
					sprintf(RSA_SK_name + strlen(ALGS_RSA_SK_name), "%d", keysizes[n]);
					pk = RSA_PK_name;
					sk = RSA_SK_name;
					break;
				case DSA:
					sprintf(DSA_PK_name + strlen(ALGS_DSA_PK_name), "%d", keysizes[n]);
					sprintf(DSA_SK_name + strlen(ALGS_DSA_SK_name), "%d", keysizes[n]);
					pk = DSA_PK_name;
					sk = DSA_SK_name;
					break;
			}
		
			if (a->algtype == ASYM_ENC) {
				if ((rc1 = time_encdec(a, pk, sk, keysizes[n])) < 0) rc = -1;
			}
			if (a->algtype == SIG && a->alghash != NoAlgHash) 
				if(a->alghash == NoAlgHash) {
					print_alginfo(a, "Can't test this algorithm (has no hash component)",0,0,0,0,0,0,0);
					break;
				}
				else if (time_signverify(a, sk, pk, keysizes[n]) < 0) rc = -1;

			processing_dialog_open(parentShell, CNULL);

			n++;
		}
		break;
		
	case SYM_ENC:
	
		processing_dialog_open(parentShell, "Testing algorithm ...");
		XmUpdateDisplay(applicationShell);
		
		if (time_encdec(a, CNULL, CNULL, 0) < 0) rc = -1;
		
		break;

	case HASH:
	
		processing_dialog_open(parentShell, "Testing algorithm ...");
		XmUpdateDisplay(applicationShell);
		
		rc = time_hash(a);
		
		break;

	}
	
	free(clearoctets);
	free(encryptedbits);
	free(recoveredoctets);
	
	processing_dialog_open(parentShell, CNULL);
	
	return(rc);
}

/***************************************************************
 *
 * Procedure time_signverify
 *
 ***************************************************************/
#ifdef __STDC__

static RC time_signverify(
	AlgList	 *a,
	char	 *sk,
	char	 *pk,
	int	  keysize
)

#else

static RC time_signverify(
	a,
	sk,
	pk,
	keysize
)
AlgList	 *a;
char	 *sk;
char	 *pk;
int	  keysize;

#endif

{
	Signature sign_signature;
	HashInput *hashinput;
	Key  key_sk, key_pk;
	OctetString ostr;
	struct timeval total_tp1, total_tp2;
	struct timezone total_tzp1, total_tzp2;
	long total_sec, total_usec;
	int rc = 0;

/*	time_signverify reads an asymmetric key pair (sk, pk) of alg a
 *	and performs a signature and verification operation with time measurement.
 *	If the key pair doesn't exist, it is created.
 *      It calls print_alginfo with the measured times.
 */

	ostr.octets    = clearoctets;
	ostr.noctets   = quantity;
	key_sk.keyref = 0;
	key_pk.keyref = 0;
	key_sk.pse_sel = (PSESel *)0;
	key_pk.pse_sel = (PSESel *)0;

/*
 *	Read keys. Generate new keys, if they don't exist
 */

	if (!(key_sk.key = getkey(sk))) {
		if (verbose) fprintf(ff, "%s and %s don't exist. Generating ...\n", sk, pk);
		if (time_keygen(a, sk, pk, keysize) < 0) return(-1);
		if (!(key_sk.key = getkey(sk))) return(-1);
	}
	if (!(key_pk.key = getkey(pk))) {
		fprintf(ff, "Can't read %s\n", pk);
		aux_free_KeyInfo(&key_sk.key);
		return(-1);
	}
	if (a->alghash == SQMODN) hashinput = build_hashinput(key_pk.key);
	else hashinput = (HashInput *)0;

	key_sk.alg = a->algid;
	sign_signature.signAI = (AlgId *)0;

/*
 * 	test signature time
 */

	gettimeofday(&total_tp1, &total_tzp1);

	if (sec_sign(&ostr, &sign_signature, SEC_END, &key_sk, hashinput) < 0) {
		fprintf(ff, "Sign with %s failed\n", sk); 
		aux_fprint_error(ff, verbose);
		aux_free_error();
		aux_free_KeyInfo(&key_sk.key);
		aux_free_KeyInfo(&key_pk.key);
		return(-1);
	}
	gettimeofday(&total_tp2, &total_tzp2);

	total_usec = (total_tp2.tv_sec - total_tp1.tv_sec) * 1000000
			+ total_tp2.tv_usec - total_tp1.tv_usec;
	total_sec = total_usec/1000000;
	total_usec = total_usec % 1000000;
	aux_free_KeyInfo(&key_sk.key);
	print_alginfo(a, "Sign", keysize, rsa_sec + dsa_sec, rsa_usec + dsa_usec, hash_sec,
				hash_usec, total_sec, total_usec);

/*
 * 	test verification time
 */

	gettimeofday(&total_tp1, &total_tzp1);

	if (sec_verify(&ostr, &sign_signature, SEC_END, &key_pk, hashinput) < 0) {
		fprintf(ff, "Verify with %s failed\n", pk); 
		aux_fprint_error(ff, verbose);
		aux_free_error();
		aux_free2_Signature(&sign_signature);
		aux_free_KeyInfo(&key_pk.key);
		return(-1);
	}
	gettimeofday(&total_tp2, &total_tzp2);

	total_usec = (total_tp2.tv_sec - total_tp1.tv_sec) * 1000000
			+ total_tp2.tv_usec - total_tp1.tv_usec;
	total_sec = total_usec/1000000;
	total_usec = total_usec % 1000000;
	print_alginfo(a, "Veri", keysize, rsa_sec + dsa_sec, rsa_usec + dsa_usec, hash_sec,
				hash_usec, total_sec, total_usec);
	aux_free2_Signature(&sign_signature);
	aux_free_KeyInfo(&key_pk.key);
	
	return(0);
}

/***************************************************************
 *
 * Procedure time_encdec
 *
 ***************************************************************/
#ifdef __STDC__

static RC time_encdec(
	AlgList	 *a,
	char	 *pk,
	char	 *sk,
	int	  keysize
)

#else

static RC time_encdec(
	a,
	pk,
	sk,
	keysize
)
AlgList	 *a;
char	 *pk;
char	 *sk;
int	  keysize;

#endif

{

/*	In case of an ASYM_ENC alg, time_encdec reads an asymmetric key pair (sk, pk) of alg a 
 *	and performs an encryption and decryption operation with time measurement.
 *	If the key pair doesn't exist, it is created.
 *
 *	In case of a SYM_ENC alg, time_encdec creates a symmetric key for alg a 
 *	and performs an encryption and decryption operation with time measurement.
 *
 *      It calls print_alginfo with the measured times.
 *
 *	time_encdec returns 0 if successful and did not generate keys,
 *                          1 if successful and generated keys;
 *                         -1 if not successful
 */

	Key  key;
	OctetString orig, recov;
	KeyInfo keyinfo;
	BitString bstr;
	int rc = 0, i;

	/* keysize 0 indicates symmetric algorithm, keysize > 0 indicates asymmetric algorithm */

	orig.octets    = clearoctets;
	orig.noctets   = (keysize ? keysize/16 : quantity);   /* half keysize fits into a 
                                                                  PKCS#2 block anyway */
	bstr.bits      = encryptedbits;
	bstr.nbits     = 0;

	key.keyref = 0;
	key.pse_sel = (PSESel *)0;

	rsa_sec = des_sec = idea_sec = idea_usec = rsa_usec = des_usec = 0;

	if (a->algtype == ASYM_ENC) {
		/* for encryption read public key from PSE .testkeys */
		if (!(key.key = getkey(pk))) {
			if (verbose) fprintf(ff, "%s and %s don't exist. Generating ...\n", pk, sk);
			if (time_keygen(a, sk, pk, keysize) < 0) return(-1);
			if (!(key.key = getkey(pk))) return(-1);
			rc = 1; 
		}
		key.alg = a->algid;
	}
	else {
		/* generate symmetric key */
		key.key = &keyinfo;
		key.key->subjectAI = a->algid;
		key.alg = (AlgId *)0;
	
		if (sec_gen_key(&key, FALSE) < 0) {
			fprintf(ff, "Generation of sym key failed for %s\n", a->name);
			aux_fprint_error(ff, verbose);
			aux_free_error();
			return(-1);
		}
	}


/*
 * 	test encryption time
 */

	if (sec_encrypt(&orig, &bstr, SEC_END, &key) < 0) {
		if (pk) fprintf(stderr, "Encrypt with %s failed\n", pk); 
		else fprintf(stderr, "Encrypt failed\n"); 
		aux_fprint_error(ff, verbose);
		aux_free_error();
		aux_free2_KeyInfo(key.key);
		return(-1);
	}
	print_alginfo(a, "Encr", keysize, rsa_sec + des_sec + idea_sec, rsa_usec + des_usec + idea_usec,
				0, 0, 0, 0);

/*
 * 	test decryption time
 */

	if (a->algtype == ASYM_ENC) {
		/* for decryption read secret key from PSE .testkeys */
		aux_free_KeyInfo(&(key.key));
		if (!(key.key = getkey(sk))) return(-1);
		key.alg = a->algid;
	}
	recov.noctets = 0;
	recov.octets  = recoveredoctets;
	if (sec_decrypt(&bstr, &recov, SEC_END, &key) < 0) {
		fprintf(ff, "Decrypt with %s failed\n", a->name); 
		aux_fprint_error(ff, verbose);
		aux_free_error();
		aux_free2_KeyInfo(key.key);
		return(-1);
	}
	if (a->algtype == ASYM_ENC) aux_free_KeyInfo(&(key.key));
	else aux_free2_KeyInfo(key.key);

	/* whether we can recover the cleartext */
	for (i = 0; i < orig.noctets; i++) if (orig.octets[i] != recov.octets[i]) {
		fprintf(ff, "encryption/decryption error\n");
		aux_fprint_error(ff, verbose);
		break;
	}
	print_alginfo(a, "Decr", keysize, rsa_sec + des_sec + idea_sec,
				rsa_usec + des_usec + idea_usec, 0, 0, 0, 0);

	return(0);
}

/***************************************************************
 *
 * Procedure time_hash
 *
 ***************************************************************/
#ifdef __STDC__

static RC time_hash(
	AlgList	 *a
)

#else

static RC time_hash(
	a
)
AlgList	 *a;

#endif

{
	OctetString ostr, hash_result;
	KeyInfo *keyinfo;
	HashInput *hashinput;

	ostr.octets    = clearoctets;
	ostr.noctets   = quantity;
	hash_result.octets  = encryptedbits;
	hash_result.noctets = 0;

	if (a->alghash == SQMODN) {
		sprintf(RSA_PK_name + strlen(ALGS_RSA_PK_name), "%d", 512);
		if (!(keyinfo = getkey(RSA_PK_name))) {
			fprintf(ff, "Can't get public key for %s\n", a->name);
			return(-1);
		}
		hashinput = build_hashinput(keyinfo);
	}
	else hashinput = (HashInput *)0;


/*
 * 	test hash time
 */

	if (sec_hash(&ostr, &hash_result, SEC_END, a->algid, hashinput) < 0) {
		fprintf(ff, "Hash with %s failed\n", a->name); 
		aux_fprint_error(ff, verbose);
		aux_free_error();
		if (a->alghash == SQMODN) aux_free_KeyInfo(&keyinfo);
		return(-1);
	}
	if (a->alghash == SQMODN) aux_free_KeyInfo(&keyinfo);
	print_alginfo(a, "Hash", 0, hash_sec, hash_usec, 0, 0, 0, 0);

	return(0);
}

/***************************************************************
 *
 * Procedure time_keygen
 *
 ***************************************************************/
#ifdef __STDC__

static RC time_keygen(
	AlgList	 *a,
	char	 *sk,
	char	 *pk,
	int	  keysize
)

#else

static RC time_keygen(
	a,
	sk,
	pk,
	keysize
)
AlgList	 *a;
char	 *sk;
char	 *pk;
int	  keysize;

#endif

{
	KeyBits *skey, *pkey, *dsacommon;
	OctetString *dsa_skey, *dsa_pkey;
	BitString *skey_b, *pkey_b;
	struct timeval total_tp1, total_tp2;
	struct timezone total_tzp1, total_tzp2;
	long total_sec, total_usec;
	int rc;


/*
 * 	test key generation time
 */

	gettimeofday(&total_tp1, &total_tzp1);

	switch(a->algenc) {
		case RSA: 
			rc = rsa_gen_key(keysize, &skey, &pkey);
			break;
		case DSA:
			dsacommon = dsa_gen_common(keysize);
			rc = dsa_gen_key(&dsa_skey, &dsa_pkey, dsacommon);
			aux_free_KeyBits(&dsacommon);
			break;
	}


	gettimeofday(&total_tp2, &total_tzp2);

	switch(a->algenc) {
		case RSA: 
			if(!(skey_b = e_KeyBits(skey))) {
				aux_free_KeyBits(&skey);
				aux_free_KeyBits(&pkey);
				fprintf(ff, "Can't encode Key\n");
				return(-1);
			}
			if(!(pkey_b = e_KeyBits(pkey))) {
				aux_free_KeyBits(&skey);
				aux_free_KeyBits(&pkey);
				fprintf(ff, "Can't encode Key\n");
				return(-1);
			}
			aux_free_KeyBits(&skey);
			aux_free_KeyBits(&pkey);
			break;
		case DSA: 
			if(!(skey_b = e_integer(dsa_skey))) {
				aux_free_OctetString(&dsa_skey);
				aux_free_OctetString(&dsa_pkey);
				fprintf(ff, "Can't encode Key\n");
				return(-1);
			}
			if(!(pkey_b = e_integer(dsa_pkey))) {
				aux_free_OctetString(&dsa_skey);
				aux_free_OctetString(&dsa_pkey);
				fprintf(ff, "Can't encode Key\n");
				return(-1);
			}
			aux_free_OctetString(&dsa_skey);
			aux_free_OctetString(&dsa_pkey);
			break;
	}
	if (rc != 0) fprintf(ff, "Key generation failed for %s (keysize %d)\n", a->name, keysize);
	else {
		if (pk) rc = putkeys(a, sk, pk, skey_b, pkey_b, keysize); /* store newly generated keys */ 
		total_usec = (total_tp2.tv_sec - total_tp1.tv_sec) * 1000000
				+ total_tp2.tv_usec - total_tp1.tv_usec;
		total_sec = total_usec/1000000;
		total_usec = total_usec % 1000000;
		print_alginfo(a, "KGen", keysize, total_sec, total_usec, 0, 0, 0, 0);
	}

	aux_free_BitString(&skey_b);
	aux_free_BitString(&pkey_b);

	return(rc);
}



/*
 *      getkey(name)
 *      reads a keyinfo from PSE 
 */

/***************************************************************
 *
 * Procedure getkey
 *
 ***************************************************************/
#ifdef __STDC__

static KeyInfo *getkey(
	char	 *name
)

#else

static KeyInfo *getkey(
	name
)
char	 *name;

#endif

{
	OctetString     ostr;
	ObjId           obj_id;
	KeyInfo        *keyinfo;

	psesel.object.name = name;

	if (sec_read_PSE(&psesel, &obj_id, &ostr) < 0) {
		aux_free_error();
		return ((KeyInfo *)0);
	}
	if (!(keyinfo = d_KeyInfo(&ostr))) {
		fprintf(ff, "Can't decode %s\n", name);
		aux_fprint_error(ff, verbose);
		aux_free_error();
		free(ostr.octets);
		aux_free2_ObjId(&obj_id);
		return ((KeyInfo *)0);
	}
	aux_free2_ObjId(&obj_id);
	free(ostr.octets);

	return (keyinfo);
}

/***************************************************************
 *
 * Procedure putkeys
 *
 ***************************************************************/
#ifdef __STDC__

static RC putkeys(
	AlgList		 *a,
	char		 *sk,
	char		 *pk,
	BitString	 *skey_b,
	BitString	 *pkey_b,
	int		  keysize
)

#else

static RC putkeys(
	a,
	sk,
	pk,
	skey_b,
	pkey_b,
	keysize
)
AlgList		 *a;
char		 *sk;
char		 *pk;
BitString	 *skey_b;
BitString	 *pkey_b;
int		  keysize;

#endif

{

	OctetString    *ostr;
	ObjId          *objid;
	KeyInfo		keyinfo;
	extern	ObjId  *RSA_SK_OID, *RSA_PK_OID, *DSA_SK_OID, *DSA_PK_OID;
	int i;

	for(i = 0; i < 2; i++) {
		if (i == 0) {
			psesel.object.name = sk;
			keyinfo.subjectkey.nbits = skey_b->nbits;
			keyinfo.subjectkey.bits = skey_b->bits;
		}
		else {
			psesel.object.name = pk;
			keyinfo.subjectkey.nbits = pkey_b->nbits;
			keyinfo.subjectkey.bits = pkey_b->bits;
		}
		switch(a->algenc) {
			case RSA:
				if (i == 0) objid = RSA_SK_OID;
				else objid = RSA_PK_OID;
				keyinfo.subjectAI = rsa;
				*(rsa_parm_type *)keyinfo.subjectAI->param = keysize;
				break;
			case DSA:
				if (i == 0) objid = DSA_SK_OID;
				else objid = DSA_PK_OID;
				keyinfo.subjectAI = dsa;
				break;
		}
	
		if (!(ostr = e_KeyInfo(&keyinfo))) {
			fprintf(ff, "Can't encode %s\n", sk);
			aux_fprint_error(ff, verbose);
			aux_free_error();
			return(-1);
		}
	
	
		if (sec_create(&psesel) < 0) {
			if (aux_last_error() != ECREATEOBJ) {
				fprintf(ff, "Can't create %s\n", sk);
				aux_fprint_error(ff, verbose);
				aux_free_error();
				aux_free_OctetString(&ostr);
				return(-1);
			}
			aux_free_error();
		}
		if (sec_write_PSE(&psesel, objid, ostr) < 0) {
			fprintf(ff, "Can't write %s\n", sk);
			aux_fprint_error(ff, verbose);
			aux_free_error();
			aux_free_OctetString(&ostr);
			return(-1);
		}
		strcpy(pseobject, psesel.object.name);
		chmod(psename, OBJMASK);
		strcpy(pseobject, "Toc");
		chmod(psename, OBJMASK);
	}
	
	return(0);
}





/*
 *      print name, action and time for a specified algorithm
 */

/***************************************************************
 *
 * Procedure print_alginfo
 *
 ***************************************************************/
#ifdef __STDC__

static void print_alginfo(
	AlgList	 *a,
	char	 *string,
	int	  keysize,
	long	  sec1,
	long	  usec1,
	long	  sec2,
	long	  usec2,
	long	  sec3,
	long	  usec3
)

#else

static void print_alginfo(
	a,
	string,
	keysize,
	sec1,
	usec1,
	sec2,
	usec2,
	sec3,
	usec3
)
AlgList	 *a;
char	 *string;
int	  keysize;
long	  sec1;
long	  usec1;
long	  sec2;
long	  usec2;
long	  sec3;
long	  usec3;

#endif

{
	char *aa;
	AlgType t;
	AlgId *aid;
	int paramchoice, n;
	rsa_parm_type  *rsa_parm;
	desCBC_parm_type *des_parm;
 	double rate, seconds, kbits;

	if (strncmp(string, "KGen", 4)) t = a->algtype;
	else t = ASYM_ENC;
	aid = a->algid;

	if (strcmp(a->name, lastname)) {
	
		aux_fprint_algorithm(ff, aid->objid);

		switch (aux_ObjId2AlgEnc(aid->objid)) {
			case DES:
				fprintf(ff, "          Keysize 64 Bits\n");
				break;
			case DES3:
			case IDEA:
				fprintf(ff, "          Keysize 128 Bits\n");
				break;

		}
		if (aid->param) {
			switch (paramchoice = aux_ObjId2ParmType(a->algid->objid)) {
	
			case PARM_INTEGER:
				rsa_parm = (rsa_parm_type *) (aid->param);
				fprintf(ff, "          Parameter Keysize (default %d)\n", *rsa_parm);
				break;
	
			case PARM_OctetString:
				des_parm = (desCBC_parm_type *) (aid->param);
				fprintf(ff, "          Parameter DES-IV (default zeros)\n");
				break;
			case PARM_KeyBits:
				if(a->algenc == DSA) fprintf(ff, "Parameter p, q, g\n");
				else fprintf(ff, "Parameter p, a\n");
				break;
			default:
				fprintf(stdout, "          ?? Unidentified parameter:\n");
				break;
			}
		} 
		else {
			switch (paramchoice = aux_ObjId2ParmType(aid->objid)) {
			case PARM_NULL:
				fprintf(ff, "          NULL parameter\n");
				break;
			case PARM_ABSENT:
				fprintf(ff, "          No parameter\n");
				break;
			}
		}
		if (!strlen(string)) return;
		
		if (!strncmp(string, "Irr", 3)) {
			fprintf(ff, "%s\n", string);
			return;
		}
		if (!strncmp(string, "Can", 3)) {
			fprintf(ff, "%s\n", string);
			return;
		}
		strcpy(lastname, a->name);
		
		fprintf(ff, "\n");
	}


	if (sec1 || usec1) {
		fprintf(ff, "%-21s%s ", "", string);
		switch(t) {
		case SIG:
			fprintf(ff, "(%4d bits): ", keysize);
			fprintf(ff, "%3ld.%03ld (total),", sec3, usec3/1000);
			fprintf(ff, "%3ld.%03ld (%s),", sec1, usec1/1000, algenc_name[a->algenc]);
			fprintf(ff, "%3ld.%03ld (%s)  \n", sec2, usec2/1000, alghash_name[a->alghash]);
			break;
  		case ASYM_ENC:
			seconds = (double)(sec1 * 1000000 + usec1) / (double)1000000;
			rate = (double)keysize / (seconds * (double)1024);
 			fprintf(ff, "(%4d bits): %3ld.%03ld (%.2f Kbits/sec) \n", keysize, sec1, usec1/1000, rate);
  			break;
  		case SYM_ENC:
 			kbits = (double)(quantity * 8 / 1024);
			seconds = (double)(sec1 * 1000000 + usec1) / (double)1000000;
 			rate = kbits / seconds;
			fprintf(ff, "(%d Kbytes): %3ld.%03ld (%.0f Kbits/sec) \n", quantity/1024, sec1, usec1/1000, rate);
  			break;
  		case HASH:
 			kbits = (double)(quantity * 8 / 1024);
 			seconds = (double)(sec1 * 1000000 + usec1) / (double)1000000;
 			rate = kbits / seconds;
 			fprintf(ff, "(%d Kbytes): %3ld.%03ld (%.0f Kbits/sec) \n", quantity/1024, sec1, usec1/1000, rate);
			break;
		}
	}
}


/***************************************************************
 *
 * Procedure check_testkeys_PSE
 *
 ***************************************************************/
#ifdef __STDC__

static RC check_testkeys_PSE(
)

#else

static RC check_testkeys_PSE(
)

#endif

{
	PSELocation	pse_location;



	if ((pse_location = sec_psetest(TESTKEYS_PSE)) == ERR_in_psetest) {
		fprintf(ff, "Error during test of PSE: %s\n", TESTKEYS_PSE);
		aux_fprint_error(ff, verbose);
		return(-1);
	}
	if (pse_location == SCpse) {
		fprintf(ff, "%s must not be defined as smartcard application\n", TESTKEYS_PSE);
		aux_fprint_error(ff, verbose);
		return(-1);
	}
	psesel.app_name = TESTKEYS_PSE;
	psesel.pin = "";
	psesel.object.name = CNULL;
	psesel.object.pin = "";
	if (sec_open(&psesel) < 0) if (sec_create(&psesel) < 0) {
		fprintf(ff, "Can't create PSE %s\n", TESTKEYS_PSE);
		aux_fprint_error(ff, verbose);
		return(-1);
	}
	chmod(TESTKEYS_PSE, DIRMASK);
	strcpy(psename, TESTKEYS_PSE);
	strcat(psename, "/");
	pseobject = psename + strlen(psename);
	strcpy(pseobject, "Toc");
	chmod(psename, OBJMASK);
	
	return(0);
}



/***************************************************************
 *
 * Procedure build_hashinput
 *
 ***************************************************************/
#ifdef __STDC__

static HashInput *build_hashinput(
	KeyInfo	 *keyinfo
)

#else

static HashInput *build_hashinput(
	keyinfo
)
KeyInfo	 *keyinfo;

#endif

{
	static HashInput hashinput;

	hashinput.sqmodn_input.nbits = keyinfo->subjectkey.nbits;
	hashinput.sqmodn_input.bits = keyinfo->subjectkey.bits;
	return(&hashinput);
}








