
static char *rcsid = "$Id: pse_objsel_box.c,v 1.14 1995/03/16 18:29:44 nuessler Exp $";

/*
 * $Id: pse_objsel_box.c,v 1.14 1995/03/16 18:29:44 nuessler Exp $
 *
 * $Log: pse_objsel_box.c,v $
 *
 */



/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/


/*
 ************************
 *	INCLUDES	*
 ************************
 */

#include "xmst.h"


/*** Type Definitions ***/

struct PseObjElem{	String	name;
			ObjId	*objid;
		 };


/*** Variables ***/

static PSEToc 			*tocs[2];
static struct PseObjElem	*pseobjlist;
static int			pseobjlistcount;
static XmStringTable		pseobjsel_strtable;
static String			returnstring;

static Widget			pseobjselectionDialog;
static Widget			pseobjsel_list_widg;
static Widget			pseobjsel_text_widg;
static Widget			pseobjsel_info_widg;


/*** Functions ***/

#ifdef __STDC__

static void pseobjselection_getlist();
static void pseobjselection_refresh(ObjId**);

#else

static void pseobjselection_getlist();
static void pseobjselection_refresh();

#endif



/**************************************************************************
 *
 * Procedure pseobjselection_open
 *
 * Last modified: 06.03.95
 *
 **************************************************************************/
#ifdef __STDC__

String pseobjselection_open(
	Widget		parentShell,
	String		infotext,	
	ObjId		**showobjids,
	Boolean		editable
	)
	
#else

String pseobjselection_open(
	parentShell,
	infotext,
	showobjids,
	editable)
Widget		parentShell;
String		infotext;
ObjId		**showobjids;
Boolean		editable;

#endif

{
	Pixel	parent_color;

	pseobjselectionDialog 	= name2widget(parentShell ,"*pseobjselection_dialog");		
	pseobjsel_list_widg 	= name2widget(parentShell, "*pseobjselection_obj_scrlist");
	pseobjsel_text_widg	= name2widget(parentShell, "*pseobjselection_sel_text");
	pseobjsel_info_widg	= name2widget(parentShell, "*pseobjselection_inf_text");
	
	BUSY_CURSOR();
	XmTextSetString(pseobjsel_info_widg, infotext);
	XtVaSetValues(	pseobjsel_text_widg,
		 	XmNeditable,   editable,
		 	NULL);
	
	returnstring = NULL;

	MANAGE_DIALOG(pseobjselectionDialog);
		
	pseobjselection_getlist();
	pseobjselection_refresh(showobjids);
	
	dialog_loop();
	
	XSync(XtDisplay(pseobjselectionDialog), 0);
	XmUpdateDisplay(parentShell);
	IDLE_CURSOR();
	
	return(returnstring);
}



/**************************************************************************
 *
 * Procedure pseobjselection_dialog_cb
 *
 * Last modified: 17.02.94
 *
 **************************************************************************/
#ifdef __STDC__

void pseobjselection_dialog_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void pseobjselection_dialog_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{
	XmAnyCallbackStruct 	*cbs = (XmAnyCallbackStruct *)callback_data;
	
	switch (cbs->reason) {

		case XmCR_OK:
			returnstring = XmTextGetString(pseobjsel_text_widg);
			if(strlen(returnstring) == 0){
				XtFree(returnstring);
				returnstring = NULL;
			}
	
			break;

		case XmCR_CANCEL:
		case XmCR_PROTOCOLS:
			returnstring = NULL;

			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}
	
	/*** dispose objects ***/
	if(pseobjlist) 	free(pseobjlist);
	XmListDeleteAllItems(pseobjsel_list_widg);
	util_XmStringTableDelete(&pseobjsel_strtable);
	XmTextSetString(pseobjsel_info_widg, "");
	XmTextFieldSetString(pseobjsel_text_widg, "");

	
	dialog_finished = TRUE;
}


/**************************************************************************
 *
 * Procedure pseobjselection_list_cb
 *
 * Last modified: 15.02.94
 *
 **************************************************************************/
#ifdef __STDC__

void pseobjselection_list_cb(
	Widget			widget,
	XtPointer		client_data,
	XtPointer		callback_data
	)
	
#else

void pseobjselection_list_cb(
	widget,
	client_data,
	callback_data
	)
Widget			widget;
XtPointer		client_data;
XtPointer		callback_data;

#endif

{
	String item;
	XmListCallbackStruct *cbs = (XmListCallbackStruct *)callback_data;
	
	if( cbs->selected_item_count == 1 ){
		XmStringGetLtoR(cbs->item, XmFONTLIST_DEFAULT_TAG, &item);
		XmTextFieldSetString(pseobjsel_text_widg, item);
		XtFree(item);
	}
	else{
		XmTextFieldSetString(pseobjsel_text_widg, "");
	}
}


/**************************************************************************
 *
 * Procedure pseobjselection_getlist
 *
 * Last modified: 24.02.95
 *
 **************************************************************************/
#ifdef __STDC__

static void pseobjselection_getlist()

#else

static void pseobjselection_getlist()

#endif

{
	struct	PSE_Objects 	*object;
	void			*opaque;
	ObjId			opaque_oid;
	int			i, j;
	
	if( sec_read_tocs(&std_pse, &tocs[0], &tocs[1]) < 0 || (!tocs[0] && !tocs[1])){
		ALARM();
		sprintf(dialog_message, "Can't read PSE-Object 'toc'");
		ok_dialog_open(d5bwrDialog, dialog_message);
	}
	
	/*** Count Elements ***/
	pseobjlistcount = 0;
	for(i=0; i <= 1; i++){
		if(tocs[i]){
			object = tocs[i]->obj;
			do {
				pseobjlistcount++;
			}while(object = object->next);
		}
	}		
	
	if(pseobjlistcount > 0){
		pseobjlist = (struct PseObjElem *)malloc(pseobjlistcount*sizeof(struct PseObjElem));
		j=0;
		for(i=0; i <= 1; i++){
			if(tocs[i]){
				object = tocs[i]->obj;
				do{
					pseobjlist[j].name = object->name;
					if(opaque = af_pse_get(pseobjlist[j].name, &opaque_oid)){
						pseobjlist[j].objid = aux_cpy_ObjId(&opaque_oid);
					}
					j++;
				}while(object = object->next);
			}
		}
	}
}



/**************************************************************************
 *
 * Procedure pseobjselection_refresh
 *
 * Last modified: 15.02.95
 *
 **************************************************************************/
#ifdef __STDC__

static void pseobjselection_refresh(	
	ObjId		**showobjids
	)
	
#else

static void pseobjselection_refresh(
	showobjids)
ObjId		**showobjids;

#endif

{
	int	j;
	String	*namelist;
	int	namelistcount = 0;
	
	while(*showobjids){
		for(j=0; j<pseobjlistcount; j++){
			if(!aux_cmp_ObjId(pseobjlist[j].objid, *showobjids)){
				namelistcount++;
				namelist = (String *)realloc(namelist, namelistcount*sizeof(String));
				namelist[namelistcount-1] = pseobjlist[j].name;
			}
		}
	showobjids++;
	}
	
	if(namelistcount > 0){
		util_XmStringTableDelete(&pseobjsel_strtable);
		pseobjsel_strtable = util_XmStringTableCreate(namelistcount);
		for(i=0; i<namelistcount; i++)
			util_XmStringTableInsert(pseobjsel_strtable, i, namelist[i]);
		free(namelist);
	}
	
	XtVaSetValues(	pseobjsel_list_widg,
			XmNitemCount, namelistcount,
			XmNitems,     pseobjsel_strtable,
			NULL);
}
