/* ./src/util/xmsectool/st_shell.c */

static char *rcsid = "$Id: st_shell.c,v 1.28 1995/03/17 17:05:10 koletzki Exp $";

/*
 * $Id: st_shell.c,v 1.28 1995/03/17 17:05:10 koletzki Exp $
 *
 * $Log: st_shell.c,v $
 * 	configuration
 * 	properties
 * 	clipboard
 *
 * Revision 1.21  1994/12/09  17:02:50  koletzki
 * clipboard copy/retrieve/swap
 * object copy/cut
 *
 * Revision 1.20  1994/12/05  10:18:06  koletzki
 * rename clipboard_undo() to clipboard_swap()
 *
 * Revision 1.19  1994/12/02  16:10:00  koletzki
 * *** empty log message ***
 *
 * Revision 1.18  1994/12/02  14:35:54  koletzki
 * vendor pixmap
 * clipboard copy/retrieve
 *
 * Revision 1.17  1994/11/24  18:15:56  koletzki
 * *** empty log message ***
 *
 * Revision 1.16  1994/11/22  11:07:57  koletzki
 * *** empty log message ***
 *
 * Revision 1.15  1994/11/14  18:28:50  koletzki
 * Color & font resources
 *
 * Revision 1.14  1994/11/11  16:18:00  nuessler
 * rename dir500bwr to d5bwr
 *
 * Revision 1.13  1994/11/11  13:32:40  koletzki
 * using af_x500_check now
 *
 * Revision 1.12  1994/11/11  11:09:28  koletzki
 * some changes for proper installation in /usr/local/secude
 *
 * Revision 1.11  1994/11/09  15:03:18  koletzki
 * begin boundary line in xmst.info: " _____"...
 *
 * Revision 1.10  1994/11/08  16:34:31  koletzki
 * clipboard functions in clipboard.c
 *
 * Revision 1.9  1994/11/04  15:44:18  koletzki
 * Refresh-Button:
 * 	re-open current PSE, re-read objects
 *
 * Revision 1.8  1994/11/04  13:21:27  koletzki
 * st_osisecxpem_button_cb():
 * 	putenv(USERPIN...)
 *
 * Revision 1.7  1994/11/02  10:44:39  surkau
 * Header replaced by Id
 *
 * Revision 1.6  1994/11/02  09:39:08  surkau
 * SecuDE-4.4.a0
 *
 *
 */
 
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/





/*
 ************************
 *	INCLUDES	*
 ************************
 */

#include "xmst.h"



/*
 ************************
 *	STATICS		*
 ************************
 */

#ifdef __STDC__

        static void	show_pse	(char *name);
        static void	show_pk		(Widget List, PKList_client_data *list_data);
        static void	print_pse	(char *name);
        static void	print_pk	(Widget List, PKList_client_data *list_data);
        static int	paste_pk	(Widget List, PKList_client_data *list_data, void *opaque, ObjId object_oid);
#else

	static void	show_pse();
	static void	print_pse();
	static void	show_pk();
	static void	print_pk();
	static int	paste_pk();

#endif



static	OctetString	cb_octetstring;
static	BitString	cb_bitstring;




/***************************************************************
 *
 * Procedure st_destroy_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_destroy_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_destroy_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	char			*proc = "st_destroy_cb";
	int			answer;


	exit_sectool();
}



/*
 *	Reopen PSE, Refresh PSE data widgets
 */
/***************************************************************
 *
 * Procedure st_reopen_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_reopen_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_reopen_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	char		*proc = "st_reopen_button_cb";
	char		*pin_save;
	
	
	/*
	 *	Open another PSE ?
	 */
	if (    (last_pse_name && pse_name && strcmp(last_pse_name, pse_name))
	     || (last_ca_dir && ca_dir && strcmp(last_ca_dir, ca_dir))
	     || (!last_pse_name && pse_name)
	     || (!last_ca_dir && ca_dir)) {
	
		sprintf(dialog_message, "%s%s \"%s%s%s\"\n%s",
					"Another PSE/CA name pair has been configured.\n",
					"Continue to close current PSE and open\n",
					ca_dir ? ca_dir : "", ca_dir ? PATH_SEPARATION_STRING : "",
					pse_name ? pse_name : DEF_PSE,
					"or cancel to keep current PSE open.");
		if (!cont_canc_dialog_open(applicationShell, dialog_message)) {
		
			return;
		}
		
		save_aliaslist();
		
		last_pse_name = pse_name ? strdup(pse_name)
					 : CNULL;
		last_ca_dir = ca_dir ? strdup(ca_dir)
				     : CNULL;
		
		pin_save = CNULL;
	
	} else pin_save = strdup(std_pse.pin);
	
	/*
	 * Close current PSE
	 */
	if (af_pse_close((ObjId *)NULL) < 0) {
	
		ALARM();
		ok_dialog_open(applicationShell, "Unable to close PSE.");
	}
	
	AF_pse.app_name = CNULL;
	if(std_pse.app_name) {
		free (std_pse.app_name);
		std_pse.app_name = CNULL;
	}
	if(std_pse.pin) strzfree (&(std_pse.pin));
	std_pse.app_id = 0;
	if ( std_pse.object.name ) {
		/*** free (std_pse.object.name); ***/
		std_pse.object.name = CNULL;
	}
	if(std_pse.object.pin) strzfree (&(std_pse.object.pin));
	
	/*
	 * Reopen PSE
	 */
	 
	if (!pin_save) set_pse_ca();

	st_open_pse(pin_save);
		
	st_fill_widgets();

}



/*
 *	PSE List Callbacks
 */


/***************************************************************
 *
 * Procedure st_pselist_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_pselist_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_pselist_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	st_activate_list(pseList, (XtPointer)NULL);

}



/***************************************************************
 *
 * Procedure st_pselist_action_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_pselist_action_cb(
	Widget			  widget,
	char			 *tag,
	XmListCallbackStruct	 *callback_data
)

#else

void st_pselist_action_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmListCallbackStruct	 *callback_data;

#endif

{
	char			*client_data;
	int			failed;


	client_data = (char *)get_clientdata(pselist_clientdata, callback_data->item_position);

	switch (callback_data->reason) {

		case XmCR_BROWSE_SELECT:

			if (sectool_verbose) fprintf(stderr, "pseList: XmCR_BROWSE_SELECT\n");

			st_activate_list(widget, (XtPointer)client_data);

			break;

		case XmCR_DEFAULT_ACTION:

			if (sectool_verbose) fprintf(stderr, "pseList: XmCR_DEFAULT_ACTION\n");

			BUSY_CURSOR();

			show_pse(client_data);

			IDLE_CURSOR();
			
			break;

		default:

	 		if (sectool_verbose) fprintf(stderr, "pseList: Oops - unknown callback reason!\n");
	}
 
}




/*
 *	PKList Callbacks
 */



/***************************************************************
 *
 * Procedure st_pklist_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_pklist_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_pklist_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	st_activate_list(pkList, (XtPointer)NULL);

}



/***************************************************************
 *
 * Procedure st_pklist_action_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_pklist_action_cb(
	Widget			  widget,
	char			 *tag,
	XmListCallbackStruct	 *callback_data
)

#else

void st_pklist_action_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmListCallbackStruct	 *callback_data;

#endif

{
	PKList_client_data	*client_data;


	client_data = (PKList_client_data *)get_clientdata(pklist_clientdata, callback_data->item_position);

	switch (callback_data->reason) {

		case XmCR_BROWSE_SELECT:

			if (sectool_verbose) fprintf(stderr, "pkList: XmCR_BROWSE_SELECT\n");

			st_activate_list(widget, (XtPointer)client_data);

			break;

		case XmCR_DEFAULT_ACTION:

			if (sectool_verbose) fprintf(stderr, "pkList: XmCR_DEFAULT_ACTION\n");

			BUSY_CURSOR();

			show_pk(pkList, client_data);

			IDLE_CURSOR();

			break;

		default:

	 		if (sectool_verbose) fprintf(stderr, "pkList: Oops - unknown callback reason!\n");
	}
 
}




/*
 *	EKList Callbacks
 */


/***************************************************************
 *
 * Procedure st_eklist_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_eklist_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_eklist_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	st_activate_list(ekList, (XtPointer)NULL);


}



/***************************************************************
 *
 * Procedure st_eklist_action_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_eklist_action_cb(
	Widget			  widget,
	char			 *tag,
	XmListCallbackStruct	 *callback_data
)

#else

void st_eklist_action_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmListCallbackStruct	 *callback_data;

#endif

{
	PKList_client_data	*client_data;


	client_data = (PKList_client_data *)get_clientdata(eklist_clientdata, callback_data->item_position);

	switch (callback_data->reason) {

		case XmCR_BROWSE_SELECT:

			if (sectool_verbose) fprintf(stderr, "ekList: XmCR_BROWSE_SELECT\n");

			st_activate_list(widget, (XtPointer)client_data);

			break;

		case XmCR_DEFAULT_ACTION:

			if (sectool_verbose) fprintf(stderr, "ekList: XmCR_DEFAULT_ACTION\n");

			BUSY_CURSOR();

			show_pk(ekList, client_data);

			IDLE_CURSOR();

			break;

		default:

	 		if (sectool_verbose) fprintf(stderr, "ekList: Oops - unknown callback reason!\n");
	}
 
}



/*
 *	PCAList Callbacks
 */


/***************************************************************
 *
 * Procedure st_pcalist_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_pcalist_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_pcalist_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	st_activate_list(pcaList, (XtPointer)NULL);


}



/***************************************************************
 *
 * Procedure st_pcalist_action_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_pcalist_action_cb(
	Widget			  widget,
	char			 *tag,
	XmListCallbackStruct	 *callback_data
)

#else

void st_pcalist_action_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmListCallbackStruct	 *callback_data;

#endif

{
	PKList_client_data	*client_data;


	client_data = (PKList_client_data *)get_clientdata(pcalist_clientdata, callback_data->item_position);

	switch (callback_data->reason) {

		case XmCR_BROWSE_SELECT:

			st_activate_list(widget, (XtPointer)client_data);

			break;

		case XmCR_DEFAULT_ACTION:

			BUSY_CURSOR();

			show_pk(pcaList, client_data);

			IDLE_CURSOR();

			break;

		default:

	 		if (sectool_verbose) fprintf(stderr, "pcaList: Oops - unknown callback reason!\n");
	}
 
}



/*
 *	Menu Button Callbacks
 */


/***************************************************************
 *
 * Procedure st_quit_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_quit_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_quit_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	exit_sectool();

}


/***************************************************************
 *
 * Procedure st_debug_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_debug_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_debug_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	debugmode_on = TRUE;

	XmToggleButtonSetState(STWIDGET("*st_debug_toggle"), TRUE, FALSE);

	set_properties(STWIDGET("*st_debug_toggle"));

	MANAGE_MODELESS_DIALOG(STWIDGET("*debug_dialog"));
}


/***************************************************************
 *
 * Procedure st_viewer_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_viewer_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_viewer_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	MANAGE_MODELESS_DIALOG(STWIDGET("*viewer_dialog"));

}


/***************************************************************
 *
 * Procedure st_clipboard_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_clipboard_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_clipboard_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	void				*data_id;
	void				*opaque;
	ObjId				opaque_oid;
	
	
	BUSY_CURSOR();
	
	/*
	 *	refresh clipboard dialog widgets
	 */
	clipboard_retrieve(applicationShell, &data_id, &opaque, &opaque_oid);
	
	if (opaque) {
		af_pse_free(&opaque, &opaque_oid);
		aux_free2_ObjId(&opaque_oid);
	}
	if (data_id) free(data_id);
		
	IDLE_CURSOR();
	
	MANAGE_MODELESS_DIALOG(STWIDGET("*clipboard_dialog"));
}


/***************************************************************
 *
 * Procedure st_config_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_config_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_config_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	config_dialog_open();
}




/***************************************************************
 *
 * Procedure st_keypool_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_keypool_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_keypool_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	ok_dialog_open(applicationShell, "Sorry...\nKey Pool Editor is not implemented.");

}



/***************************************************************
 *
 * Procedure st_xlock_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_xlock_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_xlock_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	ok_dialog_open(applicationShell, "Sorry...\nScreen Lock is not implemented.");
}




/*
 *	Called by st_checkpse_button, st_trustpath_button, and st_verify_button:
 *	Perform PSE-Check / Trust Path Check / Certificate Check
 */
/***************************************************************
 *
 * Procedure st_pse_check_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_pse_check_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_pse_check_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	secretkey = (Key *)malloc(sizeof(Key));
	if(!secretkey) {
		fprintf(stderr, "XMST pse_checkpse_button_cb: Can't malloc memory for secretkey\n");
		return;
	}
	secretkey->key = (KeyInfo *)0;
	secretkey->keyref = 0;
	secretkey->alg = (AlgId *)0;
	secretkey->pse_sel = &std_pse;
	signpk = (KeyInfo *)0;
	encpk = (KeyInfo *)0;
	signsubject = NULLDNAME;
	encsubject = NULLDNAME;

	if (open_write_tempfile(applicationShell) < 0) return;

	BUSY_CURSOR();

	if (widget == STWIDGET("*st_checkpse_button")) cmd = CHECK;
	if (widget == STWIDGET("*st_trustpath_button")) cmd = TRUSTPATH;
	if (widget == STWIDGET("*st_verify_button")) {
	
                certificate =  af_pse_get_Certificate(SIGNATURE, NULLDNAME, NULLOCTETSTRING);
		if (!certificate) {
			if (onekeypaironly) ok_dialog_open(applicationShell, "Can't read Certificate from PSE.");
			else ok_dialog_open(applicationShell, "Can't read Signature Certificate from PSE.");
		} else
			verificate(applicationShell, certificate, FALSE);

		IDLE_CURSOR();
		
		return;
	}

	certs = af_pse_get_Certificates(SIGNATURE, NULLDNAME);
	if(!certs) {
		if(onekeypaironly == TRUE) {
		
			ok_dialog_open(applicationShell, "Can't read Certificate from PSE.");
			IDLE_CURSOR();
			free(secretkey);
		
			return;
		}
		else {
		
			ok_dialog_open(applicationShell, "Can't read SIGNATURE Certificate from PSE.");
			IDLE_CURSOR();
			
			return;
		}
	}
	signpk = aux_cpy_KeyInfo(certs->usercertificate->tbs->subjectPK);
	signsubject = aux_cpy_DName(certs->usercertificate->tbs->subject);
	if(cmd == CHECK) {
		if(onekeypaironly == TRUE)
			fprintf(logfile, "\nVerifying Cert with FCPath and PKRoot ... ");
		else
			fprintf(logfile, "\nVerifying SignCert with FCPath and PKRoot ... ");
	}
        rcode = af_verify_Certificates(certs, (UTCTime *)0, (PKRoot *)0);
	aux_free_Certificates(&certs);
	if((af_verbose || sec_verbose) && cmd == CHECK) aux_fprint_VerificationResult(logfile, verifresult);
	if(cmd == TRUSTPATH) aux_fprint_TrustPath(logfile, verifresult);
	aux_free_VerificationResult(&verifresult);
	if(cmd == CHECK) {
		if(rcode == 0) fprintf(logfile, "O.K.\n");
		else fprintf(logfile, "failed\n");
		if(onekeypaironly == TRUE)
			fprintf(logfile, "\nChecking whether the keys in Cert and SKnew are an RSA key pair ... ");
		else
			fprintf(logfile, "\nChecking whether the keys in SignCert and SignSK are an RSA key pair ... ");
	}
	if(onekeypaironly == TRUE)
		std_pse.object.name = SKnew_name;
	else
		std_pse.object.name = SignSK_name;
	rcode = sec_checkSK(secretkey, signpk);
	if(rcode < 0) {
		if(onekeypaironly == TRUE)
			fprintf(logfile, "\nRSA keys in SKnew and Cert do not fit\n");
		else
			fprintf(logfile, "\nRSA keys in SignSK and SignCert do not fit\n");
	}
	else if(cmd == CHECK) fprintf(logfile, "O.K.\n");
	if(onekeypaironly == TRUE  || cmd == TRUSTPATH) goto show_results;


enccert:
	certs = af_pse_get_Certificates(ENCRYPTION, NULLDNAME);
	if(!certs) {
		fprintf(logfile, "Can't get ENCRYPTION Certificates from PSE (EncCert and/or FCPath missing)\n");
		if(signpk) aux_free_KeyInfo(&signpk);
		if(signsubject) aux_free_DName(&signsubject);
		free(secretkey);
		goto show_results;
	}
	encpk = aux_cpy_KeyInfo(certs->usercertificate->tbs->subjectPK);
	encsubject = aux_cpy_DName(certs->usercertificate->tbs->subject);
	if(signsubject) if(aux_cmp_DName(signsubject, encsubject)) {
		fprintf(logfile, "SignCert and EncCert have different subject names\n");
	}
	if(signsubject) aux_free_DName(&signsubject);
	aux_free_DName(&encsubject);
	fprintf(logfile, "\nVerifying EncCert with FCPath and PKRoot ...\n");
        rcode = af_verify_Certificates(certs, (UTCTime *)0, (PKRoot *)0);
	aux_free_Certificates(&certs);
	if(af_verbose || sec_verbose) aux_fprint_VerificationResult(logfile, verifresult);
	aux_free_VerificationResult(&verifresult);
	fprintf(logfile, "\nChecking whether the keys in EncCert and DecSKnew are an RSA key pair ... ");
	std_pse.object.name = DecSKnew_name;
	rcode = sec_checkSK(secretkey, encpk);
	if(rcode < 0) fprintf(logfile, "\nRSA keys in DecSKnew and EncCert do not fit\n");
	else fprintf(logfile, "O.K.\n");
	aux_free_KeyInfo(&signpk);
	aux_free_KeyInfo(&encpk);
	free(secretkey);

show_results:

	close_tempfile();
	start_editor();

	IDLE_CURSOR();
}


/***************************************************************
 *
 * Procedure st_pse_changepin_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_pse_changepin_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_pse_changepin_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	chpin_dialog_open();
}


/***************************************************************
 *
 * Procedure st_show_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_show_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_show_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XtPointer			data;
	
	
	if (!activeList) {
	
		ALARM();
		
		return;
	}
	
	XtVaGetValues(	activeList,
			XmNuserData, 	&data,
			NULL);
	
	if (!data) {
	
		ALARM();
		
		return;
	}
	
	BUSY_CURSOR();

	/*
	 *	PSE List Objects
	 */
	if (activeList == pseList) {

		show_pse((char *)data);
	}
	
	/*
	 *	PK/EK/PCA List Objects
	 */
	else if (activeList == pkList || activeList == ekList || activeList == pcaList) {

		show_pk(activeList, (PKList_client_data *)data);
	}
			
	IDLE_CURSOR();
}



/*
 *	Provide various information attachments for several PSE items
 */
/***************************************************************
 *
 * Procedure st_help_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_help_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_help_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XtPointer			data;
	void				*opaque;
	ObjId				opaque_oid;
	ObjId				*standard_oid;
	
	
	if (!activeList) {
	
		ALARM();
		
		return;
	}
	
	XtVaGetValues(	activeList,
			XmNuserData, 	&data,
			NULL);
	
	if (!data) {
	
		ALARM();
		
		return;
	}
	
	BUSY_CURSOR();

	/*
	 *	PSE List Objects
	 */
	if (activeList == pseList) {

		if (! (opaque = af_pse_get((char *)data, &opaque_oid)) ) {
		
			sprintf(dialog_message,"Object contains no data or unable to open:\n\"%s\"",
						(char *)data);
						
			ok_dialog_open(applicationShell, dialog_message);
			
			IDLE_CURSOR();
	
			return;
			
		} else if (aux_cmp_ObjId(&opaque_oid, Uid_OID)) {
		
			standard_oid = af_get_objoid((char *)data);
			
			if (aux_cmp_ObjId(standard_oid, Uid_OID))  {
			
				help_object_dialog_open(applicationShell, (char *)data);
				
			} else {
			
				help_type_dialog_open(applicationShell, &opaque_oid);
			}
			aux_free_ObjId(&standard_oid);
		}
		/*
		 *	Default: Unknown PSE Object type
		 */
		else {
		
			sprintf(dialog_message, "There is no Information attachment provided for:\n\"%s\"",
						(char *)data);
						
			ok_dialog_open(applicationShell, dialog_message);
		}
		
		af_pse_free(&opaque, &opaque_oid);
		aux_free2_ObjId(&opaque_oid);
	}
	
	/*
	 *	Pk/EkList List Objects
	 */
	else if (activeList == pkList) {

		sprintf(dialog_message, "There is no Information attachment provided for:\n\"%s\"",
					PKList_name);
		ok_dialog_open(applicationShell, dialog_message);
	}
	else if (activeList == ekList) {

		sprintf(dialog_message, "There is no Information attachment provided for:\n\"%s\"",
					EKList_name);
		ok_dialog_open(applicationShell, dialog_message);
	}
	else if (activeList == pcaList) {

		sprintf(dialog_message, "There is no Information attachment provided for:\n\"%s\"",
					PCAList_name);
		ok_dialog_open(applicationShell, dialog_message);
	}
	
	IDLE_CURSOR();
}




/*
 *	Show xmst user guide
 */
/***************************************************************
 *
 * Procedure st_guide_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_guide_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_guide_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	static Widget		guideDialog = (Widget)0;
	
	Widget			guide_text;
	OctetString		*file_ostr;
	char			*file_string;
	char			*file_dup;
	char			*file_begin;


	if (!guideDialog) {

		if (! (file_ostr = aux_file2OctetString(guide_file)) ) {
		
			sprintf(dialog_message, "Can't read help file\n\"%s\"", guide_file);
			ok_dialog_open(applicationShell, dialog_message);
			
		} else {
		
			file_string = CATNSTR(CNULL, file_ostr->octets, file_ostr->noctets);
			file_string = CATSPRINTF(file_string, "\n");
			file_dup = strdup(file_string);
			
			/* search boundary line */
			for (	file_begin = strtok(file_dup, "\n");
				file_begin, strncmp(	file_begin,
							XMST_INFOFILE_BEGIN,
							strlen(XMST_INFOFILE_BEGIN));
				file_begin = strtok(CNULL, "\n")) ;
							
			if (!file_begin) {
		
				sprintf(dialog_message, "Empty help file\n\"%s\"", guide_file);
				ok_dialog_open(applicationShell, dialog_message);
			
			} else {				
			
				guideDialog = STWIDGET("*guide_dialog");
				guide_text = STWIDGET("*guide_text");
			
				XmTextInsert(guide_text, 0, file_string + (file_begin - file_dup));
				XmTextShowPosition(guide_text, 1);
				
				MANAGE_MODELESS_DIALOG(guideDialog);
			}
			free(file_string);
			free(file_dup);
			aux_free_OctetString(&file_ostr);
		}
		
	} else MANAGE_MODELESS_DIALOG(guideDialog);
}



/*
 *	Verify selected certificate
 */
/***************************************************************
 *
 * Procedure st_verify_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_verify_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_verify_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	char				*data;
	void				*opaque;
	ObjId				opaque_oid;
	
	
	if (activeList != pseList) {
	
		ALARM();
		return;
	}
	
	XtVaGetValues(	activeList,
			XmNuserData,	&data,
			NULL);
	
	if (!data) {
	
		ALARM();
		return;
	}
	
	BUSY_CURSOR();

	if (! (opaque = af_pse_get(data, &opaque_oid)) ) {
	
		sprintf(dialog_message,"Object contains no data or unable to open:\n\"%s\"", data);
		
		ok_dialog_open(applicationShell, dialog_message);
		
		IDLE_CURSOR();

		return;
	}

	/*
	 *	Certificates
	 */
	if (!aux_cmp_ObjId(&opaque_oid, SignCert_OID)
	    || !aux_cmp_ObjId(&opaque_oid, EncCert_OID)
	    || !aux_cmp_ObjId(&opaque_oid, Cert_OID)) 	{ 
    
	   	verificate(applicationShell, (Certificate *)opaque, TRUE);
	   	
	} else {
	
		sprintf(dialog_message, "Object is not a Certificate:\n\"%s\"", data);
		
		ok_dialog_open(applicationShell, dialog_message);
	}
	
	af_pse_free(&opaque, &opaque_oid);
	aux_free2_ObjId(&opaque_oid);
	
	IDLE_CURSOR();
}

/*
 *	Directory Browser
 */
/***************************************************************
 *
 * Procedure st_dir500_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_dir500_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_dir500_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	d5bwr_dialog_open();

}





/*
 *	Crypto Interface
 */
/***************************************************************
 *
 * Procedure st_crypt_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_crypt_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_crypt_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	crypt_dialog_open();

}



/*
 *	Alias Editor
 */
/***************************************************************
 *
 * Procedure st_alias_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_alias_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_alias_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	alias_dialog_open();

}



		 
/***************************************************************
 *
 * Procedure st_copy_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_copy_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_copy_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	static int			clipboard_private_id = 1;
	
	XtPointer			activeListData;
	void				*opaque = (void *)0;
	ObjId				opaque_oid;
	OctetString			*id;
	
	
	if (!activeList) {
	
		ALARM();
		return;
	}
	
	XtVaGetValues(	activeList,
			XmNuserData, 	&activeListData,
			NULL);
	
	if (!activeListData) {
	
		ALARM();
		return;
	}
	
	BUSY_CURSOR();

	/*
	 *	PSE List Objects
	 */
	if (activeList == pseList) {
	
		/* get from PSE */
		if (! (opaque = af_pse_get((char *)activeListData, &opaque_oid)) ) {
		
			sprintf(dialog_message, "Object contains no data or unable to open:\n\"%s\"",
						(char *)activeListData);
			ok_dialog_open(applicationShell, dialog_message);
			
		} else {
		
			clipboard_copy(	applicationShell,
					CB_PSE,
					(void *)strdup((char *)activeListData),
					opaque,
					opaque_oid);
		}
	}
	
	/*
	 *	Pk/Ek/PCAList List Objects
	 */
	else if (activeList == pkList) {

		/* get from PKList */
		if (! (opaque = (void *)af_pse_get_TBS(	SIGNATURE,
							((PKList_client_data *)activeListData)->subject,
							((PKList_client_data *)activeListData)->issuer,
							((PKList_client_data *)activeListData)->serial))) {
							
			sprintf(dialog_message, "Unable to get ToBeSigned from PKList.");
			ok_dialog_open(applicationShell, dialog_message);
			
		} else {
		
			aux_cpy2_ObjId(&opaque_oid, ToBeSigned_OID);
			clipboard_copy(	applicationShell,
					CB_PK,
					(void *)strdup((char *)activeListData),
					opaque,
					opaque_oid);
		}
	}
	else if (activeList == ekList) {

		/* get from EKList */
		if (! (opaque = (void *)af_pse_get_TBS(	ENCRYPTION,
							((PKList_client_data *)activeListData)->subject,
							((PKList_client_data *)activeListData)->issuer,
							((PKList_client_data *)activeListData)->serial))) {
							
			sprintf(dialog_message, "Unable to get ToBeSigned from EKList.");
			ok_dialog_open(applicationShell, dialog_message);
			
		} else {
		
			aux_cpy2_ObjId(&opaque_oid, ToBeSigned_OID);
			clipboard_copy(	applicationShell,
					CB_EK,
					(void *)strdup((char *)activeListData),
					opaque,
					opaque_oid);
		}
	}
	else if (activeList == pcaList) {

		/* get from PCAList */
		if (! (opaque = (void *)af_pse_get_PCATBS(((PKList_client_data *)activeListData)->subject,
							((PKList_client_data *)activeListData)->issuer,
							((PKList_client_data *)activeListData)->serial))) {
							
			sprintf(dialog_message, "Unable to get ToBeSigned from PCAList.");
			
		} else {
		
			aux_cpy2_ObjId(&opaque_oid, ToBeSigned_OID);
			clipboard_copy(	applicationShell,
					CB_PCA,
					(void *)strdup((char *)activeListData),
					opaque,
					opaque_oid);
		}
	}
		
	if (opaque) {
		af_pse_free(&opaque, &opaque_oid);
		aux_free2_ObjId(&opaque_oid);
	}
	
	IDLE_CURSOR();
}


/***************************************************************
 *
 * Procedure st_paste_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_paste_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_paste_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XtPointer			activeListData;
	ClipboardSource			source;
	void				*data_id;
	void				*opaque;
	ObjId				opaque_oid;
	
	
	if (!activeList) {
	
		ALARM();
		return;
	}

	BUSY_CURSOR();
			
	XtVaGetValues(	activeList,
			XmNuserData, 	&activeListData,
			NULL);
	
	/*
	 * get object from clipboard
	 */
	switch ((source = clipboard_retrieve(applicationShell, &data_id, &opaque, &opaque_oid))) {
	
		/*
		 *	PSE List Objects
		 */
	
		case CB_EMPTY:
		
			ALARM();
			IDLE_CURSOR();
			return;
			
		case CB_ERROR:
		
			ALARM();
			IDLE_CURSOR();
			return;
			
		case CB_X500:
		case CB_AFDB:
		case CB_PSE:
		
			/*
			 *	CB_PSE / CB_X500 / CB_AFDB to PSE object
			 */
			if (activeList == pseList) {
			
				/* X500/AFDB: object selection or object name is required */
				if (!activeListData && !data_id) {
				
					sprintf(dialog_message, "%s\n%s",
						"Select an existing PSE object",
						"or create a new one",
						"as target of the paste operation.");
						
					goto st_paste_error;
				}
				
							
				
				/*
				 *	check for secret objects
				 */
				 
				if (activeListData
					&& (     !strcmp(activeListData, SKnew_name)
					      || !strcmp(activeListData, SKold_name)
					      || !strcmp(activeListData, SignSK_name)
					      || !strcmp(activeListData, DecSKnew_name)
					      || !strcmp(activeListData, DecSKold_name))) {
					      
					sprintf(dialog_message, "%s\n\"%s\"",
						"Secret keys must not be overwritten:",
						activeListData);
					
					goto st_paste_error;
				}
				
				/*
				 *	update
				 */
				if (af_pse_update(	activeListData  ? (char *)activeListData
							     		: (char *)data_id,
							opaque,
							&opaque_oid)) {
							
					sprintf(dialog_message, "%s\n\"%s\"",
						"Unable to paste from clipboard into",
						activeListData  ? (char *)activeListData
								: (char *)data_id);
					
					goto st_paste_error;
				}
			}
			
			/*
			 *	CB_PSE to PK/EK/PCAList
			 */
			else if (    activeList == pkList
				  || activeList == ekList
				  || activeList == pcaList) {
				  
				/*
				 *	Try add or exchange
				 */
				if (paste_pk(	activeList,
						(PKList_client_data *)activeListData,
						opaque,
						opaque_oid)) {
				
					goto st_paste_error;
				}
			}
			
			break;
			
		case CB_PK:
		case CB_EK:
		case CB_PCA:
		
			/*
			 *	Trusted Key list?
			 */
			if (    activeList != pkList
			     && activeList != ekList
			     && activeList != pcaList) {
						
				sprintf(dialog_message, "%s\n%s",
					"Clipboard data of object type ToBeSigned_OID",
					"can be pasted into Trusted Key lists only.");
				
				goto st_paste_error;
			}
			
			/*
			 *	Try add or exchange
			 */
			if (paste_pk(	activeList,
					(PKList_client_data *)activeListData,
					opaque,
					opaque_oid)) {
			
				goto st_paste_error;
			}
			
			break;
		
				
		case CB_UNKNOWN:
		default:
		
			sprintf(dialog_message, "Don't know what to do...");
			
			goto st_paste_error;
	}
	
	st_fill_widgets();
		
	goto st_paste_ok;

st_paste_error:
	ok_dialog_open(applicationShell, dialog_message);
	
st_paste_ok:
	if (opaque) {
		af_pse_free(&opaque, &opaque_oid);
		aux_free2_ObjId(&opaque_oid);
	}
	if (data_id) free(data_id);
	
	IDLE_CURSOR();
}



/***************************************************************
 *
 * Procedure st_cut_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_cut_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_cut_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	static int			clipboard_private_id = 1;
	
	XtPointer			activeListData;
	void				*opaque = (void *)0;
	ObjId				opaque_oid;
	OctetString			*id;
	
	
	if (!activeList) {
	
		ALARM();
		return;
	}
	
	XtVaGetValues(	activeList,
			XmNuserData, 	&activeListData,
			NULL);
	
	if (!activeListData) {
	
		ALARM();
		return;
	}
	
	BUSY_CURSOR();

	/*
	 *	PSE List Objects
	 */
	if (activeList == pseList) {
	
		/*
		 *	check for secret objects
		 */
		if (    !strcmp(activeListData, SKnew_name)
		     || !strcmp(activeListData, SKold_name)
		     || !strcmp(activeListData, SignSK_name)
		     || !strcmp(activeListData, DecSKnew_name)
		     || !strcmp(activeListData, DecSKold_name)) {
			      
			sprintf(dialog_message, "%s\n\"%s\"",
				"Secret keys must not be deleted:",
				activeListData);
			
			goto st_cut_error;
		}
		
		/* cut from PSE */
		if (opaque = af_pse_get((char *)activeListData, &opaque_oid)) {
		
			clipboard_copy(	applicationShell,
					CB_PSE,
					(void *)strdup((char *)activeListData),
					opaque,
					opaque_oid);
					
		}
		
		if (af_pse_delete((char *)activeListData)) {
		
			sprintf(dialog_message, "Can't delete PSE object:\n\"%s\"",
						(char *)activeListData);
			
			goto st_cut_error;
		}
	}
	
	/*
	 *	Pk/Ek/PCAList List Objects
	 */
	else if (activeList == pkList) {

		/* cut from PKList */
		if (opaque = (void *)af_pse_get_TBS(	SIGNATURE,
							((PKList_client_data *)activeListData)->subject,
							((PKList_client_data *)activeListData)->issuer,
							((PKList_client_data *)activeListData)->serial)) {
							
			aux_cpy2_ObjId(&opaque_oid, ToBeSigned_OID);
			clipboard_copy(	applicationShell,
					CB_PK,
					(void *)strdup((char *)activeListData),
					opaque,
					opaque_oid);
		}
		
		if (af_pse_delete_PK(	SIGNATURE,
					((PKList_client_data *)activeListData)->subject,
					((PKList_client_data *)activeListData)->issuer,
					((PKList_client_data *)activeListData)->serial)) {
		
			sprintf(dialog_message, "Can't delete ToBeSigned from PKList.");
			
			goto st_cut_error;
		}
	}
	else if (activeList == ekList) {

		/* cut from EKList */
		if (opaque = (void *)af_pse_get_TBS(	ENCRYPTION,
							((PKList_client_data *)activeListData)->subject,
							((PKList_client_data *)activeListData)->issuer,
							((PKList_client_data *)activeListData)->serial)) {
							
			aux_cpy2_ObjId(&opaque_oid, ToBeSigned_OID);
			clipboard_copy(	applicationShell,
					CB_EK,
					(void *)strdup((char *)activeListData),
					opaque,
					opaque_oid);
		}
		
		if (af_pse_delete_PK(	ENCRYPTION,
					((PKList_client_data *)activeListData)->subject,
					((PKList_client_data *)activeListData)->issuer,
					((PKList_client_data *)activeListData)->serial)) {
		
			sprintf(dialog_message, "Can't delete ToBeSigned from PKList.");
			
			goto st_cut_error;
		}
	}
	else if (activeList == pcaList) {

		/* cut from PCAList */
		if (opaque = (void *)af_pse_get_PCATBS(((PKList_client_data *)activeListData)->subject,
							((PKList_client_data *)activeListData)->issuer,
							((PKList_client_data *)activeListData)->serial)) {
							
			aux_cpy2_ObjId(&opaque_oid, ToBeSigned_OID);
			clipboard_copy(	applicationShell,
					CB_PCA,
					(void *)strdup((char *)activeListData),
					opaque,
					opaque_oid);
		}
		
		if (af_pse_delete_PCA(((PKList_client_data *)activeListData)->subject)) {
		
			sprintf(dialog_message, "Can't delete PCA from list.");
			
			goto st_cut_error;
		}
	}
	
	if (clipboardUndoCount < XMST_MAX_UNDOS) clipboardUndoCount++;
	
	st_fill_widgets();
	
	goto st_cut_ok;
	
st_cut_error:
	ok_dialog_open(applicationShell, dialog_message);
	
st_cut_ok:

	if (opaque) {
		af_pse_free(&opaque, &opaque_oid);
		aux_free2_ObjId(&opaque_oid);
	}
	
	IDLE_CURSOR();
}


/***************************************************************
 *
 * Procedure st_undo_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_undo_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_undo_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	ClipboardSource			source;
	void				*data_id;
	void				*opaque;
	ObjId				opaque_oid;
	
	
	if (clipboardUndoCount <= 0) {
	
		ALARM();
		return;
	}
	
	BUSY_CURSOR();
	
	/*
	 * get object from clipboard
	 */
	switch ((source = clipboard_retrieve(applicationShell, &data_id, &opaque, &opaque_oid))) {
	
		/*
		 *	PSE List Objects
		 */
	
		case CB_EMPTY:
		
			ALARM();
			IDLE_CURSOR();
			return;
			
		case CB_ERROR:
		
			ALARM();
			IDLE_CURSOR();
			return;
			
		case CB_PSE:
		
			if (af_pse_update(	(char *)data_id,
						opaque,
						&opaque_oid)) {
						
				sprintf(dialog_message, "%s\n\"%s\"\n\n%s",
							"Unable to undo clipboard operation for",
							(char *)data_id,
							"Use paste to put object into the PSE.");
				
				goto st_undo_error;
			}
			
			break;
			
		case CB_PK:
		
			if (aux_cmp_ObjId(&opaque_oid, ToBeSigned_OID)) {
						
				sprintf(dialog_message, "%s\n%s\n\n%s",
							"Unable to undo PKList clipboard operation",
							"for other object types than ToBeSigned_OID.",
							"Use paste to put object into the PKlist.");
				
				goto st_undo_error;
			}
			
			if (af_pse_add_PK(	SIGNATURE,
						(ToBeSigned *)opaque)) {
						
				sprintf(dialog_message, "%s\n%s\n\n%s",
					"Unable to undo clipboard operation for",
					(LASTERROR == EPK) ? "PKList entry because ToBeSigned exists."
							   : "PKList entry.",
					"Use paste to put object into the PKList.");
				
				goto st_undo_error;
			}
			
			break;
		
		case CB_EK:
		
			if (aux_cmp_ObjId(&opaque_oid, ToBeSigned_OID)) {
						
				sprintf(dialog_message, "%s\n%s\n\n%s",
							"Unable to undo EKList clipboard operation",
							"for other object types than ToBeSigned_OID.",
							"Use paste to put object into the EKList.");
				
				goto st_undo_error;
			}
			
			if (af_pse_add_PK(	ENCRYPTION,
						(ToBeSigned *)opaque)) {
						
				sprintf(dialog_message, "%s\n%s\n\n%s",
					"Unable to undo clipboard operation for",
					(LASTERROR == EPK) ? "EKList entry because ToBeSigned exists."
							   : "EKList entry.",
					"Use paste to put object into the EKList.");
				
				goto st_undo_error;
			}
			
			break;
		
		case CB_PCA:
		
			if (aux_cmp_ObjId(&opaque_oid, ToBeSigned_OID)) {
						
				sprintf(dialog_message, "%s\n%s\n\n%s",
							"Unable to undo PCAList clipboard operation",
							"for other object types than ToBeSigned_OID.",
							"Use paste to put object into the PCAList.");
				
				goto st_undo_error;
			}
			
			if (af_pse_add_PCA(	(ToBeSigned *)opaque)) {

				sprintf(dialog_message, "%s\n%s\n\n%s",
					"Unable to undo clipboard operation for",
					(LASTERROR == EPK) ? "PCAList entry because ToBeSigned exists."
							   : "PCAList entry.",
					"Use paste to put object into the PCAList.");
				
				goto st_undo_error;
			}
			
			break;
		
		case CB_UNKNOWN:
		default:
		
			sprintf(dialog_message, "Don't know what to do...");
			
			goto st_undo_error;
	}
	
	st_fill_widgets();
	
	clipboard_swap(applicationShell);
	
	if (clipboardUndoCount > 0) clipboardUndoCount--;
	
	goto st_undo_ok;

st_undo_error:
	ok_dialog_open(applicationShell, dialog_message);
	
st_undo_ok:
	if (opaque) {
		af_pse_free(&opaque, &opaque_oid);
		aux_free2_ObjId(&opaque_oid);
	}
	if (data_id) free(data_id);
	
	IDLE_CURSOR();
}







/*
 *	Read/Write PSE objects to/from file
 */
/***************************************************************
 *
 * Procedure st_file_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_file_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_file_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	
	file_dialog_open();
}


/*
 *	Send contents of PSE objects to printer
 */
/***************************************************************
 *
 * Procedure st_print_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_print_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_print_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XtPointer			data;
	
	
	if (!activeList) {
	
		ALARM();
		
		return;
	}
	
	XtVaGetValues(	activeList,
			XmNuserData, 	&data,
			NULL);
	
	if (!data) {
	
		ALARM();
		
		return;
	}
	
	BUSY_CURSOR();

	/*
	 *	PSE List Objects
	 */
	if (activeList == pseList) {
	
		print_pse((char *)data);
	}
	
	/*
	 *	PK/EK/PCA List Objects
	 */
	else if (activeList == pkList || activeList == ekList || activeList == pcaList) {

		print_pk(activeList, (PKList_client_data *)data);
	}
			
	IDLE_CURSOR();

}


/***************************************************************
 *
 * Procedure st_create_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_create_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_create_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	char				*object;
	PSESel				*pse;
	
	
	if (! (object = prompt_dialog_open(applicationShell, "Enter name of PSE object to be created:", CNULL)) ) {
	
		ALARM();
		
		return;
	}
	
	BUSY_CURSOR();
	
	if (pse = af_pse_create(object)) {
	
		st_toc_widgets_update(object);
		
		XmListSelectPos(	pseList,
					count_clientdata(pselist_clientdata),
					TRUE);
		XmListSetBottomPos(	pseList,
					count_clientdata(pselist_clientdata));
					
		aux_free_PSESel(&pse);
		
	} else {
	
		sprintf(dialog_message, "Object already exists or unable to create:\n\"%s\"", object);
		
		ok_dialog_open(applicationShell, dialog_message);
	}
	
	free(object);
	
	IDLE_CURSOR();

}


/***************************************************************
 *
 * Procedure st_rename_drawnbutton_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_rename_drawnbutton_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_rename_drawnbutton_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	char				*data;
	char				*new_name;
	
	
	if (activeList != pseList) {
	
		ALARM();
		
		return;
	}
	
	XtVaGetValues(	activeList,
			XmNuserData,	&data,
			NULL);
	
	if (!data) {
	
		ALARM();
		
		return;
	}
	
	BUSY_CURSOR();
	
	sprintf(dialog_message, "Enter new name of object:\n\"%s\"", data);
	if (! (new_name = prompt_dialog_open(applicationShell, dialog_message, data)) ) {
	
		ALARM();
		IDLE_CURSOR();
		
		return;
	}
	
	if (!af_pse_rename(data, new_name)) {
	
		st_fill_widgets();
		
	} else {
	
		sprintf(dialog_message, "New name already exists:\n\"%s\",\nor unable to rename:\n\"%s\"",
					new_name, data);
					
		ok_dialog_open(applicationShell, dialog_message);
	}
	
	free(new_name);
	
	IDLE_CURSOR();


}



/*
 *	Save the actual properties and configuration settings
 */
/***************************************************************
 *
 * Procedure st_save_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_save_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_save_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	BUSY_CURSOR();
	
	save_configuration();
	
	IDLE_CURSOR();

}


/*
 *	This Callback is used by all non-menu children of the Properties Menu Button
 * 	It provides RadioBox behavior inside a Pulldown Menu
 */
/***************************************************************
 *
 * Procedure st_properties_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_properties_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_properties_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
    	static Widget 			authToggle = NULL;
    	static Widget 			niceToggle = NULL;

 
   	if (!authToggle) authToggle = initialAuthToggle;
   	if (!niceToggle) niceToggle = initialNiceToggle;

	if (widget == STWIDGET("*st_authnone_toggle")
	    || widget == STWIDGET("*st_authsimple_toggle")
	    || widget == STWIDGET("*st_authstrong_toggle")) {

	    if (((XmToggleButtonCallbackStruct *)callback_data)->set) {

		if (authToggle) XmToggleButtonSetState(authToggle, FALSE, FALSE);
		authToggle = widget;

	    } else if (widget == authToggle) XmToggleButtonSetState(widget, TRUE, FALSE);
	}

	if (widget == STWIDGET("*st_nicelow_toggle")
	    || widget == STWIDGET("*st_nicemedium_toggle")
	    || widget == STWIDGET("*st_nicehigh_toggle")) {

	    if (((XmToggleButtonCallbackStruct *)callback_data)->set) {

		if (niceToggle) XmToggleButtonSetState(niceToggle, FALSE, FALSE);
		niceToggle = widget;

	    } else if (widget == niceToggle) XmToggleButtonSetState(widget, TRUE, FALSE);
	}

	/* Get all actual values */
	set_properties(widget);

}



/***************************************************************
 *
 * Procedure st_secude_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_secude_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_secude_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	secude_dialog_open();

}







/*
 *	Start UCL XPEM as separate process
 */

/***************************************************************
 *
 * Procedure st_osisecxpem_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void st_osisecxpem_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void st_osisecxpem_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	char		*proc = "st_osisecxpem_button_cb";
	char		pin[256];
	char		mhconfigfile[256];
	char		command_string[256];
	int		status;
	struct stat	filestat;
	

	/*
	 *	.mh_profile doesn't exist: MH warning
	 */
	strcpy(mhconfigfile, unix_home);
	if (mhconfigfile[strlen(mhconfigfile) - 1] != PATH_SEPARATION_CHAR)
		strcat(mhconfigfile, PATH_SEPARATION_STRING);
	strcat(mhconfigfile, MH_CONFIG_FILE);
	if (stat(mhconfigfile, &filestat) < 0) {
	 
		sprintf(dialog_message, "%s%s%s%s",
					"The XPEM User Agent expects a properly installed\n",
					"MH mailing system. If you have not used MH before\n",
					"or if you don't want MH to incorporate your current\n",
					"unread mail, cancel the spawning of XPEM now.");
		if (!cont_canc_dialog_open(applicationShell, dialog_message)) {
		
			return;
		}
	}
	
	if (ca_dir) {
	
		sprintf(pin, "CAPIN=%s", std_pse.pin);
		putenv(pin);
		sprintf(command_string, "xpem -c %s -p %s &", ca_dir, pse_path);
		
	} else {
	
		sprintf(pin, "USERPIN=%s", std_pse.pin);
		putenv(pin);
		sprintf(command_string, "xpem -p %s &", pse_path);
	}
	
	status = system(command_string);
	if (status) {
		sprintf(dialog_message, "ERROR: Unable to spawn UCL XPEM!\n\n\
						Status of system call is <%d>.", status);
		ok_dialog_open(applicationShell, dialog_message);
	}


}













/***************************************************************
 *
 * Procedure show_pse
 *
 ***************************************************************/
#ifdef __STDC__

static
void show_pse(
	char	 *name
)

#else

static
void show_pse(
	name
)
char	 *name;

#endif

{
	char				*proc = "show_pse";
	
	
	if (open_write_tempfile(applicationShell) >= 0) { 
	
		if (af_pse_fprint(logfile, name, NULL, NULL)) {
	
			sprintf(dialog_message, "Object contains no data or unable to open:\n\"%s\"", name);
			ok_dialog_open(applicationShell, dialog_message);
	
			return;
		}
		
		close_tempfile();
		start_editor();

	} else remove_tempfile();
}





/* 
 * 	Show selected PK/EK/PCAList entry in editor/viewer
 */
/***************************************************************
 *
 * Procedure show_pk
 *
 ***************************************************************/
#ifdef __STDC__

static
void show_pk(
	Widget			  List,
	PKList_client_data	 *list_data
)

#else

static
void show_pk(
	List,
	list_data
)
Widget			  List;
PKList_client_data	 *list_data;

#endif

{
	char				*proc = "show_pk";
	char				*list_name;
	ToBeSigned			*to_be_signed;


	if (List == pkList) {
	
		if (! (to_be_signed = af_pse_get_TBS(	SIGNATURE,
							list_data->subject,
							list_data->issuer,
							list_data->serial)) ) {
							
			ok_dialog_open(applicationShell, "Unable to get ToBeSigned from PKList.");
		
			return;
			
		} else list_name = aux_cpy_String(PKList_name);
		
	
	} else if (List == ekList) {
	
		if (! (to_be_signed = af_pse_get_TBS(	ENCRYPTION,
							list_data->subject,
							list_data->issuer,
							list_data->serial)) ) {
		
			ok_dialog_open(applicationShell, "Unable to get ToBeSigned from EKList.");
		
			return;
			
		} else list_name = aux_cpy_String(EKList_name);
	
	} else if (List == pcaList) {
	
		if (! (to_be_signed = af_pse_get_PCATBS(	list_data->subject,
								list_data->issuer,
								list_data->serial)) ) {
		
			ok_dialog_open(applicationShell, "Unable to get ToBeSigned from PCAList.");
		
			return;
			
		} else list_name = aux_cpy_String(PCAList_name);
		
	} else return;

	if (open_write_tempfile(applicationShell) >= 0) {

		fprintf(logfile, " ________________________________________________\n");
		fprintf(logfile, "|                                                |\n");
		fprintf(logfile, "|    Certificate from %-23.23s    |\n", list_name);
		fprintf(logfile, "|________________________________________________|\n\n");
		
		aux_fprint_ToBeSigned(logfile, to_be_signed);
		
	        aux_free_ToBeSigned(&to_be_signed);
	
		close_tempfile();
		start_editor();

	} else remove_tempfile();
	
	free(list_name);
	
	return;
}


/***************************************************************
 *
 * Procedure print_pse
 *
 ***************************************************************/
#ifdef __STDC__

static
void print_pse(
	char	 *name
)

#else

static
void print_pse(
	name
)
char	 *name;

#endif

{
	char				*proc = "print_pse";
	char				*string;
	
	if (!(string = af_pse_sprint(CNULL, name, NULL, NULL))) {

		sprintf(dialog_message, "Object contains no data or unable to open:\n\"%s\"", name);
		ok_dialog_open(applicationShell, dialog_message);

		return;
	}

	print_string(applicationShell, string);
	
	free(string);
}


/***************************************************************
 *
 * Procedure print_pk
 *
 ***************************************************************/
#ifdef __STDC__

static
void print_pk(
	Widget			  List,
	PKList_client_data	 *list_data
)

#else

static
void print_pk(
	List,
	list_data
)
Widget			  List;
PKList_client_data	 *list_data;

#endif

{
	char				*proc = "print_pk";
	char				*list_name;
	ToBeSigned			*to_be_signed;
	char				*string;


	if (List == pkList) {
	
		if (! (to_be_signed = af_pse_get_TBS(	SIGNATURE,
							list_data->subject,
							list_data->issuer,
							list_data->serial)) ) {
		
			ok_dialog_open(applicationShell, "Unable to get ToBeSigned from PKList.");
		
			return;
			
		} else list_name = aux_cpy_String(PKList_name);
		
	
	} else if (List == ekList) {
	
		if (! (to_be_signed = af_pse_get_TBS(	ENCRYPTION,
							list_data->subject,
							list_data->issuer,
							list_data->serial)) ) {
		
			ok_dialog_open(applicationShell, "Unable to get ToBeSigned from EKList.");
		
			return;
			
		} else list_name = aux_cpy_String(EKList_name);
	
	} else if (List == pcaList) {
	
		if (! (to_be_signed = af_pse_get_PCATBS(	list_data->subject,
								list_data->issuer,
								list_data->serial)) ) {
		
			ok_dialog_open(applicationShell, "Unable to get ToBeSigned from PCAList.");
		
			return;
			
		} else list_name = aux_cpy_String(PCAList_name);
		
	} else return;

	string = CATSPRINTF(CNULL,  " ________________________________________________\n");
	string = CATSPRINTF(string, "|                                                |\n");
	string = CATSPRINTF(string, "|    Certificate from %-23.23s    |\n", list_name);
	string = CATSPRINTF(string, "|________________________________________________|\n\n");
	string = aux_sprint_ToBeSigned(string, to_be_signed);
        aux_free_ToBeSigned(&to_be_signed);

	print_string(applicationShell, string);
	
	free(string);
	free(list_name);
}



/*
 *	Paste Public Key from opaque (Certificate or ToBeSigned)
 *	into PK/EK/PCAList
 */
/***************************************************************
 *
 * Procedure paste_pk
 *
 ***************************************************************/
#ifdef __STDC__

static
int paste_pk(
	Widget			List,
	PKList_client_data	*list_data,
	void			*opaque,
	ObjId			opaque_oid
)

#else

static
int paste_pk(
	List,
	list_data,
	opaque,
	opaque_oid
)
Widget			List;
PKList_client_data	*list_data;
void			*opaque;
ObjId			opaque_oid;

#endif

{
	char				*proc = "paste_pk";
	ToBeSigned			*to_be_signed;
	int				rcode;


	/*
	 * Extract ToBeSigned
	 */
	if (!aux_cmp_ObjId(&opaque_oid, ToBeSigned_OID)) to_be_signed = (ToBeSigned *)opaque;
	else if (!aux_cmp_ObjId(&opaque_oid, Cert_OID)
	 	|| !aux_cmp_ObjId(&opaque_oid, SignCert_OID)
	 	|| !aux_cmp_ObjId(&opaque_oid, EncCert_OID)) to_be_signed = ((Certificate *)opaque)->tbs;


	/*
	 * Cannot extract ToBesigned
	 */
	else {
		sprintf(dialog_message, "%s", "Unable to extract ToBeSigned from data");
		
		return(-1);
	}

	/*
	 * Try to add/update
	 */
	if (List == pkList) rcode = af_pse_add_PK(SIGNATURE, to_be_signed);
	if (List == ekList) rcode = af_pse_add_PK(ENCRYPTION, to_be_signed);
	if (List == pcaList) rcode = af_pse_add_PCA(to_be_signed);
							
	if (rcode) sprintf(dialog_message, "%s", "Unable to paste data to key list");
			
					
	return(rcode);
}





/*
 *	Open PSE with given PIN (e.g. for re-open)
 *	if NULL, force entering of PIN
 */
/***************************************************************
 *
 * Procedure st_open_pse
 *
 ***************************************************************/
#ifdef __STDC__

void st_open_pse(
	char	*pse_pin
)

#else

void st_open_pse(
	pse_pin
)
char	*pse_pin;
#endif

{
	char			*proc = "st_open_pse";
	struct stat		filestat;
	char			*full_pse_path;
	char			command_string[512];
	int			status;
	

	BUSY_CURSOR();
	
	if (!pse_pin) {
	
		/*
		 *	PSE doesn't exist: call psecreate
		 */
		full_pse_path = aux_cat_paths((	pse_path[0] != PATH_SEPARATION_CHAR) ?
						unix_home : "",
						pse_path);
	
		if (aux_file_type(full_pse_path) != F_DIRECTORY) {
		 
		 	sprintf(dialog_message,	"%s\"%s\"\n%s",
		 				"The selected PSE does not exist:\n",
		 				full_pse_path,
		 				"Continue to create new PSE with prototype certificate.");
		 	cont_quit_dialog_open(applicationShell, dialog_message);
		 	
			strcpy(command_string, "popup_xterm");
			strcat(command_string, " psecreate ");
			strcat(command_string, " -v -p ");
			strcat(command_string, full_pse_path);
			
			status = system(command_string);
			
			if (status) {
				sprintf(dialog_message, "XMST ERROR: Unable to spawn psecreate\n\n\
								Status of system call is <%d>.", status);
				abort_dialog_open(applicationShell, dialog_message);
			}
		
			/*
			 *	PSE created successfully
			 */
			sprintf(dialog_message,	"%s%s%s%s",
						"PSE creation was successful.\n\n",
						"     You have to send a\n",
						" Certification Request mail\n",
						"        to your CA!");
			ok_dialog_open(applicationShell, dialog_message);
				
		}
	}
	
	/*
	 *	Open PSE
	 */

	if ( aux_create_AFPSESel(pse_path, pse_pin) < 0 ) {

		fprintf(stderr, "XMST ERROR: Cannot create AFPSESel.\n"); 
		if (verbose) aux_fprint_error(stderr, 0);
		abort_dialog_open(applicationShell, "Unable to create AFPSESel.");
	}

	
	/* check for SCT/SC */
	set_sct_widget();

	switch (sec_psetest(pse_path)) {

		case ERR_in_psetest:		/* failed */
	
			fprintf(stderr, "XMST ERROR: sec_psetest failed.\n");
			if (verbose) aux_fprint_error(stderr, 0);
			abort_dialog_open(applicationShell, "Unable to configure SmartCard environment.");
			break;
	
		case SWpse:			/* Software PSE */
	
			if (!pse_pin) pin_dialog_open(0);
			break;
			
#ifdef SCA
		case SCpse:			/* SmartCard PSE */

			ok_dialog_open(	applicationShell,
					"A SmartCard environment will be used. \n\n	\
					The connected IC Card terminal device  \n	\
					will display further instructions and  \n	\
					processing results.                    ");
			
			if (! (pse_sel = af_pse_open((ObjId *)0, FALSE)) ) {
	
				fprintf(stderr, "XMST ERROR: unable to open SC PSE %s\n", pse_path);
				if (verbose) aux_fprint_error(stderr, 0);
				abort_dialog_open(applicationShell, "Unable to open SmartCard PSE.");
			}
			break;
#endif /* SCA */
			
		default:
			break;
	}

	if (af_check_if_onekeypaironly(&onekeypaironly)) {

		fprintf(stderr, "XMST ERROR: unable to determine whether or not the PSE shall hold one keypair only\n");
		if (verbose) aux_fprint_error(stderr, 0);
		sprintf(dialog_message,	"%s%s",
					"Unable to determine whether or not\n",
					"the PSE shall hold one keypair only.");
		abort_dialog_open(applicationShell, dialog_message);
	}

	aux_free_PSESel(&pse_sel);

	std_pse.app_name = aux_cpy_String(AF_pse.app_name);
	std_pse.object.name = CNULL;
/***	std_pse.object.pin = aux_cpy_String(AF_pse.pin);	***/
	std_pse.pin = aux_cpy_String(AF_pse.pin);
	std_pse.app_id = AF_pse.app_id;

#ifdef AFDBFILE
#ifdef X500

	if ( (x500 = af_x500_check()) ) {
		if (directory_user_dname) aux_free_DName(&directory_user_dname);
		directory_user_dname = af_pse_get_Name();
	}
	
#endif /* X500 */
#endif /* AFDBFILE */


	IDLE_CURSOR();
	
}



/*
 *	Fill Base Widgets
 */
/***************************************************************
 *
 * Procedure st_fill_widgets
 *
 ***************************************************************/
#ifdef __STDC__

int st_fill_widgets(
)

#else

int st_fill_widgets(
)

#endif

{
	char				*proc = "st_fill_widgets";
	PSEToc				*main_toc;
	Name				*owner_name;
	DName				*owner_mail;
	char				*create;
	char				*update;
	struct PSE_Objects 		*obj;
	char				setting_value = 0;
	PKList				*pk_list;
	PKList				*ek_list;
	PKList				*pca_list;
	char				*alias;
	char				*alias_subject;
	char				*alias_issuer;
	char				*alias_serial;
	XmString			cstring;


	THINK_CURSOR();

	init_clientdata(pselist_clientdata);
	XmListDeleteAllItems(pseList);
	XtVaSetValues(	pseList,
			XmNuserData,	(char *)NULL,
			NULL);
			
	init_clientdata(pklist_clientdata);
	XmListDeleteAllItems(pkList);
	XtVaSetValues(	pkList,
			XmNuserData,	(PKList_client_data *)NULL,
			NULL);
			
	if (!onekeypaironly) {
	
		init_clientdata(eklist_clientdata);
		XmListDeleteAllItems(ekList);
		XtVaSetValues(	ekList,
				XmNuserData,	(PKList_client_data *)NULL,
				NULL);
	}

	init_clientdata(pcalist_clientdata);
	XmListDeleteAllItems(pcaList);
	XtVaSetValues(	pcaList,
			XmNuserData,	(PKList_client_data *)NULL,
			NULL);
			
	object_oid = &oid;

	/* toc-header-panels */
	if (ca_dir) XmTextSetString(STWIDGET("*st_ca_textfield"), ca_dir);
	else {
		XtSetSensitive(STWIDGET("*st_ca_button"), FALSE);
		XmTextSetString(STWIDGET("*st_ca_textfield"), "        N/A");
	}
	if (pse_path) XmTextSetString(STWIDGET("*st_pse_textfield"), pse_path);


	/*
	 * One/Two Key Pair Stuff
	 */
	if (onekeypaironly) {

		XtVaSetValues(	STWIDGET("*st_pairs_label"),
				XmNlabelPixmap, 	onepairPixmap,
				NULL					);

	} else {

		XtManageChild(STWIDGET("*st_ek_form"));

		XtVaSetValues(	STWIDGET("*st_pairs_label"),
				XmNlabelPixmap, 	twopairsPixmap,
				NULL					);
	}
	
	/* Do it for Directory Browser */
	d5bwr_onekeypair(onekeypaironly);

	XmUpdateDisplay(applicationShell);

	st_toc_widgets_update(CNULL);		

	/* PSE-List */
	if (sctoc)  {

		obj = sctoc->obj;
		while (obj) {
	
			create = aux_readable_UTCTime(obj->create);
			update = aux_readable_UTCTime(obj->update);

			st_pseList_update(	obj->name,
						create, 
						update, 
						&(obj->noOctets),
						XMST_SC_OBJECT		);

			if (create) free(create);
			if (update) free(update);

			obj = obj->next;
		}
	} 
	if (psetoc)  {

		obj = psetoc->obj;
		while (obj) {
	
			create = aux_readable_UTCTime(obj->create);
			update = aux_readable_UTCTime(obj->update);

			st_pseList_update(	obj->name,
						create,
						update,
						&(obj->noOctets),
						XMST_PSE_OBJECT		);

			if (create) free(create);
			if (update) free(update);

			obj = obj->next;
		}
	} 

	/* PKList */
	if (! (pk_list = (PKList *)af_pse_get(PKList_name, object_oid))
	   || aux_cmp_ObjId(object_oid, PKList_OID) )  {

		if (verbose) fprintf(stderr, "  Warning: Can't read PKList\n");
	
	}  else {
	
		while (pk_list)  {
	
			if (!pk_list->element) cont_quit_dialog_open(applicationShell,
							"Empty ToBeSigned field in PKList");
			else  {
	
				if (! (alias_subject = search_add_alias(pk_list->element->subject,
									LOCALNAME)) )
					alias_subject = aux_DName2Name(pk_list->element->subject);
	
				if (! (alias_issuer = search_add_alias(pk_list->element->issuer,
									LOCALNAME)) )
					alias_issuer = aux_DName2Name(pk_list->element->issuer);
	
				alias_serial = Serialnumber2String(pk_list->element->serialnumber);
	
				st_pkList_append(	pkList,
							alias_subject,
							alias_issuer,
							alias_serial,
							pk_list->element->subject,
							pk_list->element->issuer,
							pk_list->element->serialnumber	);
	
				free(alias_subject);
				free(alias_issuer);
				free(alias_serial);
			}
			pk_list = pk_list->next;
		}
		aux_free2_ObjId(object_oid);
		aux_free_PKList(&pk_list);
	}


	/* EKList */
	if (onekeypaironly)  {

		if (verbose) fprintf(stderr, "  EKList is not supported\n");

	} else  {

		if (! (ek_list = (PKList *)af_pse_get(EKList_name, object_oid))
		   || aux_cmp_ObjId(object_oid, EKList_OID) ) {

			if (verbose) fprintf(stderr, "  Warning: Can't read EKList\n");
	
		} else {
		
			while (ek_list)  {

				if (! (ek_list->element) )
					cont_quit_dialog_open(applicationShell,
						"Empty ToBeSigned field in EKList");
				else  {
	
					if (! (alias_subject = search_add_alias(ek_list->element->subject,
										LOCALNAME)) )
						alias_subject = aux_DName2Name(ek_list->element->subject);
	
					if (! (alias_issuer = search_add_alias(ek_list->element->issuer,
										LOCALNAME)) )
						alias_subject = aux_DName2Name(ek_list->element->issuer);
	
					alias_serial = Serialnumber2String(ek_list->element->serialnumber);
	
					st_pkList_append(	ekList,
								alias_subject,
								alias_issuer,
								alias_serial,
								ek_list->element->subject,
								ek_list->element->issuer,
								ek_list->element->serialnumber	);
	
					free(alias_subject);
					free(alias_issuer);
					free(alias_serial);
				}
				ek_list = ek_list->next;
			}
			aux_free2_ObjId(object_oid);
			aux_free_PKList(&ek_list);
		}
	}

	/* PCAList */
	if (! (pca_list = (PKList *)af_pse_get(PCAList_name, object_oid))
	   || aux_cmp_ObjId(object_oid, PCAList_OID) )  {

		if (verbose) fprintf(stderr, "  Warning: Can't read PCAList\n");
	
	}  else {
	
		while (pca_list)  {
	
			if (!pca_list->element) cont_quit_dialog_open(applicationShell,
							"Empty ToBeSigned field in PCAList");
			else  {
	
				if (! (alias_subject = search_add_alias(pca_list->element->subject,
									LOCALNAME)) )
					alias_subject = aux_DName2Name(pca_list->element->subject);
	
				if (! (alias_issuer = search_add_alias(pca_list->element->issuer,
									LOCALNAME)) )
					alias_issuer = aux_DName2Name(pca_list->element->issuer);
	
				alias_serial = Serialnumber2String(pca_list->element->serialnumber);
	
				st_pkList_append(	pcaList,
							alias_subject,
							alias_issuer,
							alias_serial,
							pca_list->element->subject,
							pca_list->element->issuer,
							pca_list->element->serialnumber	);
	
				free(alias_subject);
				free(alias_issuer);
				free(alias_serial);
			}
			pca_list = pca_list->next;
		}
		aux_free2_ObjId(object_oid);
		aux_free_PKList(&pca_list);
	}


	st_toc_widgets_update(AliasList_name);		/* because of search_add_alias() */
	
	/* refresh contents of related dialogs */
	file_dialog_refresh();
	XmUpdateDisplay(applicationShell);

	READY_CURSOR();


	return(0);
}


/*
 *	update toc-header-fields
 *	if object name is given: 
 *		update entry in PSE-List-Panel if in toc & in list
 *		append entry in list if in toc & not in list
 *		delete entry from list if not in toc
 */

/***************************************************************
 *
 * Procedure st_toc_widgets_update
 *
 ***************************************************************/
#ifdef __STDC__

int st_toc_widgets_update(
	char	 *object_name
)

#else

int st_toc_widgets_update(
	object_name
)
char	 *object_name;

#endif

{
	char				*proc = "st_toc_widgets_update";
	PSEToc				*main_toc;
	Name				*owner_name;
	DName				*owner_dname;
	char				*name;
	char				*create;
	char				*update;
	struct PSE_Objects 		*obj;
	char				*fill = "";
	int				total_rows;
	int				entry;
	int				object_origin;


	if (sectool_verbose)  fprintf(stderr, "--> %s\n", proc);

		
	/* read toc */
	if (sec_read_tocs(&std_pse, &sctoc, &psetoc) < 0 || (!sctoc && !psetoc))  {		

		aux_add_error(EREADPSE, "sec_read_tocs failed", CNULL, 0, proc);
		abort_dialog_open(applicationShell, "Can't read Table Of Contents.");
	}

	if (sctoc) main_toc = sctoc;
	else main_toc = psetoc;

	/* owner, dname, mail, created, changed textfields */
	XmTextSetString(STWIDGET("*st_owner_textfield"), main_toc->owner);

	owner_dname = af_pse_get_Name();
	if (owner_dname) {
	
		owner_name = aux_DName2Name(owner_dname);
		aux_free_DName(&owner_dname);
		if (owner_name) {
		
			XmTextSetString(STWIDGET("*st_dname_text"), text_wrap_RDN(owner_name));
			free(owner_name);
		}
	}

	/* SC/SWPSE/ONE setting */
	if (sctoc && !psetoc)		XtVaSetValues(	STWIDGET("*st_psetype_label"),
							XmNlabelPixmap, 	scPixmap,
							NULL);
	else if (psetoc && !sctoc)	XtVaSetValues(	STWIDGET("*st_psetype_label"),
							XmNlabelPixmap, 	psePixmap,
							NULL);
	else				XtVaSetValues(	STWIDGET("*st_psetype_label"),
							XmNlabelPixmap, 	scpsePixmap,
							NULL);

	/* update for given object_name */
	if (object_name)  {
	
		obj = (struct PSE_Objects *)NULL;

		/* PSE-List */
		if (sctoc)  {

			obj = sctoc->obj;
			while (obj)  {
		
				if (!strcmp(object_name, obj->name))  {			/* SC object */
				
					create = aux_readable_UTCTime(obj->create);
					update = aux_readable_UTCTime(obj->update);

					object_origin = XMST_SC_OBJECT;
	
					break;
				}
				obj = obj->next;
			}
		} 

		if (!obj && psetoc)  {

			obj = psetoc->obj;
			while (obj)  {
		
				if (!strcmp(object_name, obj->name))  {			/* SW-PSE object */

					create = aux_readable_UTCTime(obj->create);
					update = aux_readable_UTCTime(obj->update);
		
					object_origin = XMST_PSE_OBJECT;
	
					break;

				}
				obj = obj->next;
			}
		}

		if (obj)  {

			st_pseList_update(	obj->name, 
						create, 
						update, 
						&(obj->noOctets), 
						object_origin		);
		
			if (create) free(create);
			if (update) free(update);
	
		} else  {			/* not in toc: try to delete from list */

			total_rows = count_clientdata(pselist_clientdata);
			entry = 1;
			while (entry < total_rows)  {

				if (!strcmp(object_name, (char *)get_clientdata(pselist_clientdata, entry)))  {

					delete_clientdata(pselist_clientdata, entry);
					XmListDeletePos(pseList, entry);

					break;
				}
				entry++;
			}
		}
	}	


	return(0);

}



/*
 *	update object in pse-list-panel / append if object not found
 */

/***************************************************************
 *
 * Procedure st_pseList_update
 *
 ***************************************************************/
#ifdef __STDC__

int st_pseList_update(
	char	 *name,
	char	 *created,
	char	 *changed,
	int	 *size,
	int	  object_origin
)

#else

int st_pseList_update(
	name,
	created,
	changed,
	size,
	object_origin
)
char	 *name;
char	 *created;
char	 *changed;
int	 *size;
int	  object_origin;

#endif

{
	char			*proc = "st_pseList_update";
	char			pselist_string[XMST_PSELISTSTR_LENGTH + 1];
	char			*pl_name;
	char			pl_size[7];		/* max. length is 7 digits! */
	char			*fill = "";
	int			total_rows;
	int			entry = 1;		/* first XmList entry is number 1, not 0! */
	XmString		cmpdstring, cmpdname, cmpdrest;


	if (sectool_verbose)  fprintf(stderr, "--> %s\n", proc);


	/* *** be careful when changing sprintf-formats! *** */

	sprintf(pl_size, "%6d", *size);
	sprintf(pselist_string, "%-12.12s%4s", name, fill);
	cmpdname = (object_origin == XMST_SC_OBJECT) 	? CPDSTRINGBOLD(pselist_string)
							: CPDSTRINGFIXED(pselist_string);

	sprintf(pselist_string, "%-6.6s%1s%-4.4s%1s%-5.5s%4s%-6.6s%1s%-4.4s%1s%-5.5s%4s%-6.6s\0",
				created + 4,  fill,			/* Month/Day: 6 digits */
				created + 20, fill,			/* Year:      4        */
				created + 11, fill,			/* Time:      5        */
				changed + 4,  fill,			/* Month/Day: 6 digits */
				changed + 20, fill,			/* Year:      4        */
				changed + 11, fill,			/* Time:      5        */
				pl_size			);      	/* Size:      6        */

	cmpdrest = CPDSTRINGFIXED(pselist_string);
	cmpdstring = XmStringConcat(cmpdname, cmpdrest);

	total_rows = count_clientdata(pselist_clientdata);

	pl_name = aux_cpy_String(name);

	/* update if found */
	while (entry <= total_rows)  {

		if (!strcmp(pl_name, (char *)get_clientdata(pselist_clientdata, entry)))  {

			XmListReplaceItemsPos(pseList, &cmpdstring, 1, entry);
			if (pl_name) free(pl_name);

			break;
		}
		entry++;
	}

	/* append if not found */
	if (entry > total_rows) {

		/* append to list if no client data vector overflow */
		if (append_clientdata(pselist_clientdata, (XtPointer)pl_name))
			XmListAddItem(pseList, cmpdstring, 0);
	}

	XmStringFree(cmpdstring);
	XmStringFree(cmpdname);
	XmStringFree(cmpdrest);

	XmUpdateDisplay(applicationShell);


	return(0);

}


/* 
 *	append entry in PK/EK/PCA-List-Panel
 */
/***************************************************************
 *
 * Procedure st_pkList_append
 *
 ***************************************************************/
#ifdef __STDC__

int st_pkList_append(
	Widget		  List,
	char		 *subject,
	char		 *issuer,
	char		 *serial,
	DName		 *dn_subject,
	DName		 *dn_issuer,
	OctetString	 *os_serial
)

#else

int st_pkList_append(
	List,
	subject,
	issuer,
	serial,
	dn_subject,
	dn_issuer,
	os_serial
)
Widget		  List;
char		 *subject;
char		 *issuer;
char		 *serial;
DName		 *dn_subject;
DName		 *dn_issuer;
OctetString	 *os_serial;

#endif

{
	char				*proc = "st_pkList_append";
	XtPointer			*list_cd_vector;
	PKList_client_data		*list_data;
	char				list_string[XMST_PKLISTSTR_LENGTH + 1];
	char				list_serial[XMST_PKSERIAL_LENGTH + 1];
	char				*fill = "";
	int				total_rows;
	XmString			cmpdstring, cmpdnames, cmpdserial;


	if (sectool_verbose)  fprintf(stderr, "--> %s\n", proc);


	if (List == pkList) list_cd_vector = pklist_clientdata;
	else if (List == ekList) list_cd_vector = eklist_clientdata;
	else if (List == pcaList) list_cd_vector = pcalist_clientdata;
	else return(-1);

	list_data = (PKList_client_data *)malloc(sizeof(PKList_client_data));
	list_data->subject = aux_cpy_DName(dn_subject);
	list_data->issuer = aux_cpy_DName(dn_issuer);
	list_data->serial = os_serial;

	/* *** be careful when changing sprintf-formats! *** */
	sprintf(list_string,	"%-14.14s%3s%-14.14s%3s",
				subject, fill,
				issuer, fill); 
	cmpdnames = CPDSTRINGFIXED(list_string);
	cmpdserial = CPDSTRINGFIXED(serial);
	cmpdstring = XmStringConcat(cmpdnames, cmpdserial);
	
		
	if (append_clientdata(list_cd_vector, (XtPointer)list_data))
		XmListAddItem(List, cmpdstring, 0);
		
	XmStringFree(cmpdstring);


	return(0);

}




/*
 *	get DName's alias of given type, or force entering a new alias for it
 *	return alias, CNULL if canceled
 */

/***************************************************************
 *
 * Procedure search_add_alias
 *
 ***************************************************************/
#ifdef __STDC__

char *search_add_alias(
	DName		 *dname,
	AliasType	  type
)

#else

char *search_add_alias(
	dname,
	type
)
DName		 *dname;
AliasType	  type;

#endif

{
	char				*proc = "search_add_alias";
	char				*alias;
	char				*name;


	if (verbose) fprintf(stderr, "--> %s\n", proc);


	if (! (alias = aux_DName2alias(dname, type)))  {

		name = aux_DName2Name(dname);

		if (verbose) fprintf(stderr, "Warning: No alias found for %s\n", name);

		sprintf(dialog_message,
			"There is no System-/User-Alias for\n\n  \"%s\"  \n\nEnter new %s:",
			name, alias_message[type]);

		alias_to_add = CNULL;

		addalias_dialog_open(dialog_message);

		if (alias_to_add) {
		
			aux_add_alias_name(alias_to_add, name, useralias, TRUE, TRUE);
			
			if (aliasDialog && XtIsManaged(aliasDialog)) alias_dialog_open();
		}

		free(name);

		return(alias_to_add);
	}


	return(alias);

}





/*
 *	Make active list to target for further clipboard operations
 *	Set user data
 *	Affected are the PSE-related lists: pseList, pkList, ekList, pcalist
 */
/***************************************************************
 *
 * Procedure st_activate_list
 *
 ***************************************************************/
#ifdef __STDC__

void st_activate_list(
	Widget		  active_list,
	XtPointer	  data
)

#else

void st_activate_list(
	active_list,
	data
)
Widget		  active_list;
XtPointer	  data;

#endif

{
    	Pixel	 		parent_color;
    	
    	
    	activeList = active_list;

	/*
	 *	PSE List
	 */
	if (activeList == pseList) {
	
		XtVaSetValues(	pseList,
				XmNuserData, (char *)data,
				NULL);
		if (!data) XmListDeselectAllItems(pseList);

		XtVaSetValues(	STWIDGET("*st_pselist_button"),
				XmNbackground, active_list_color,
				NULL);
		
	} else {
	
		XtVaSetValues(	pseList,
				XmNuserData, (char *)NULL,
				NULL);
		XmListDeselectAllItems(pseList);
		
    		XtVaGetValues(	XtParent(pseList),
    				XmNbackground, &parent_color,
    				NULL);
		XtVaSetValues(	STWIDGET("*st_pselist_button"),
				XmNbackground, parent_color,
				NULL);
	}
	
	/*
	 *	PK List
	 */
	if (activeList == pkList) {
	
		XtVaSetValues(	pkList,
				XmNuserData, (PKList_client_data *)data,
				NULL);
		if (!data) XmListDeselectAllItems(pkList);
		
		XtVaSetValues(	STWIDGET("*st_pklist_button"),
				XmNbackground, active_list_color,
				NULL);
		
	} else {
	
		XtVaSetValues(	pkList,
				XmNuserData, (PKList_client_data *)NULL,
				NULL);
		XmListDeselectAllItems(pkList);
		
    		XtVaGetValues(	XtParent(pkList),
    				XmNbackground, &parent_color,
    				NULL);
		XtVaSetValues(	STWIDGET("*st_pklist_button"),
				XmNbackground, parent_color,
				NULL);
	}
	
	/*
	 *	EK List
	 */
	if (activeList == ekList) {
	
		XtVaSetValues(	ekList,
				XmNuserData, (PKList_client_data *)data,
				NULL);
		if (!data) XmListDeselectAllItems(ekList);
		
		XtVaSetValues(	STWIDGET("*st_eklist_button"),
				XmNbackground, active_list_color,
				NULL);
		
	} else {
	
		XtVaSetValues(	ekList,
				XmNuserData, (PKList_client_data *)NULL,
				NULL);
		XmListDeselectAllItems(ekList);
		
    		XtVaGetValues(	XtParent(ekList),
    				XmNbackground, &parent_color,
    				NULL);
		XtVaSetValues(	STWIDGET("*st_eklist_button"),
				XmNbackground, parent_color,
				NULL);
	}
	
	/*
	 *	PCA List
	 */
	if (activeList == pcaList) {
	
		XtVaSetValues(	pcaList,
				XmNuserData, (PKList_client_data *)data,
				NULL);
		if (!data) XmListDeselectAllItems(pcaList);
		
		XtVaSetValues(	STWIDGET("*st_pcalist_button"),
				XmNbackground, active_list_color,
				NULL);
		
	} else {
	
		XtVaSetValues(	pcaList,
				XmNuserData, (PKList_client_data *)NULL,
				NULL);
		XmListDeselectAllItems(pcaList);
		
    		XtVaGetValues(	XtParent(pcaList),
    				XmNbackground, &parent_color,
    				NULL);
		XtVaSetValues(	STWIDGET("*st_pcalist_button"),
				XmNbackground, parent_color,
				NULL);
	}
}













