/* ./src/util/xmsectool/verificate.c */

static char *rcsid = "$Id: verificate.c,v 1.14 1995/03/17 17:05:20 koletzki Exp $";

/*
 * $Id: verificate.c,v 1.14 1995/03/17 17:05:20 koletzki Exp $
 *
 * $Log: verificate.c,v $
 *
 */
 
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/


/*
 ************************
 *	INCLUDES	*
 ************************
 */

#include "xmst.h"


/*** Variables ***/

static struct{
		Boolean		chk_crl;
		Boolean		access_directory;
		Boolean		random_from_pse;
		Boolean		default_from_pse;
		Certificate	*cert;
		PKRoot		*pkroot;
		FCPath		*fcpath;
		UTCTime	*time;
		Certificates	*allcerts;
} verify_status;
	     
static Widget parentShell = NULL;



/*** Functions ***/

#ifdef __STDC__

static void 		verify();
static Boolean 		verify_dialog_open();	     
static void 		verify_status_free();
static FCPath 		*random_fcpath(Boolean);
static PKRoot 		*random_pkroot(Boolean);

#else
	     
static void 		verify();
static Boolean 		verify_dialog_open();
static void 		verify_status_free();
static FCPath 		*random_fcpath();
static PKRoot 		*random_pkroot();

#endif



/***************************************************************
 *
 * Procedure verificate
 *
 * Last modified: 13.01.95
 *
 ***************************************************************/	       	       
#ifdef __STDC__

void verificate(
	Widget		parentSh,
	Certificate	*cert,
	Boolean		random
	)

#else

void verificate(
	parentSh,
	cert,
	random
	)
Widget		parentSh;
Certificate 	*cert;
Boolean		random;

#endif

{
	
	parentShell = parentSh;
		
	if (random && !verify_dialog_open(parentShell)) {
		
		return;
	}
		
	/* Toggle */
	verify_status.chk_crl = random ? XmToggleButtonGetState(
						name2widget(parentShell, "*verify_crl_togglebutton"))
				       : FALSE;
				       
	/* 3 Radios */
	verify_status.access_directory = random ? XmToggleButtonGetState(
						name2widget(parentShell, "*verify_dir_togglebutton"))
					: FALSE;
						
	verify_status.random_from_pse = random ? XmToggleButtonGetState(
						name2widget(parentShell, "*verify_random_togglebutton"))
				       : FALSE;
				       
	verify_status.default_from_pse = random ? XmToggleButtonGetState(
						name2widget(parentShell, "*verify_default_togglebutton"))
				       : TRUE;
				       
						
	if (	random
	     && !verify_status.access_directory 
	     && !verify_status.default_from_pse 
	     && ! (verify_status.fcpath = random_fcpath(random))) {
	
		ok_dialog_open(parentShell, "Trying to complete FCPath...");
	}

	if (	random
	     && !verify_status.access_directory 
	     && !verify_status.default_from_pse 
	     && ! (verify_status.pkroot = random_pkroot(random))) {
	
		ok_dialog_open(parentShell, "Trying to complete PKRoot...");
	}

	verify_status.cert = aux_cpy_Certificate(cert);
	
	verify();

}


/***************************************************************
 *
 * Procedure verify_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

static Boolean verify_dialog_open()

#else

static Boolean verify_dialog_open()

#endif

{
	char		*proc = "verify_dialog_open";
	Widget 		dialog = name2widget(parentShell, "*verify_dialog");

	BUSY_CURSOR();
	MANAGE_DIALOG(dialog);
	dialog_loop();
	IDLE_CURSOR();

	return(dialog_ok);
}


/***************************************************************
 *
 * Procedure verify_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void verify_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void verify_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs;


	XmUpdateDisplay(applicationShell);

	cbs = (XmSelectionBoxCallbackStruct *)callback_data;

	switch (cbs->reason) {

		case XmCR_OK:
		
			dialog_ok = TRUE;
			break;

		case XmCR_CANCEL:
		case XmCR_PROTOCOLS:
		
			dialog_ok = FALSE;
			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}

	dialog_finished = TRUE;
}



/***************************************************************
 *
 * Procedure random_fcpath
 *
 * Last modified: 20.02.95
 *
 ***************************************************************/
#ifdef __STDC__

static FCPath *random_fcpath(
	Boolean		random
)

#else

static FCPath *random_fcpath(
	random
)
Boolean		random;

#endif
{
	FCPath			*fcpath = NULL;
	String			selected_object;
	void			*opaque;
	ObjId			opaque_oid;
	ObjId			*listofobjid[5];
	
	listofobjid[0] = Cert_OID;
	listofobjid[1] = SignCert_OID;
	listofobjid[2] = EncCert_OID;
	listofobjid[3] = FCPath_OID;
	listofobjid[4] = NULL;
	

	if (!random) fcpath = af_pse_get_FCPath(NULLDNAME);
 	else {
 		
 		if (!(selected_object = pseobjselection_open(parentShell,
 				"Select a PSE-Object of the type\n * FCPath or\n * Certificate",
 				listofobjid, FALSE))){
 			return(NULL);
 		}
 						
 		if (opaque = af_pse_get(selected_object, &opaque_oid)) {
 			
 			/* object is fcpath */
 			if (!aux_cmp_ObjId(&opaque_oid, FCPath_OID)){
 			 	fcpath = aux_cpy_FCPath((FCPath *)opaque);
 			}
 				
 			/* object is certificate */
 			else if (!aux_cmp_ObjId(&opaque_oid, SignCert_OID) 
 			    	 || !aux_cmp_ObjId(&opaque_oid, EncCert_OID) 
 			    	 || !aux_cmp_ObjId(&opaque_oid, Cert_OID)){
 				   
 				if (! (fcpath = aux_create_FCPath((Certificate *)opaque)) ) {
 					
 					sprintf(dialog_message,
 						"Cannot transform Certificate into FCPath:\n\"%s\"",
 						selected_object);
 					ok_dialog_open(parentShell, dialog_message);
				}
			}
 				
 			af_pse_free(&opaque, &opaque_oid);
 			aux_free2_ObjId(&opaque_oid);
 		}
 				
 		/* unable to read object from PSE */			
 		else {
 			
 			sprintf(dialog_message,
 				"Can't read object from PSE:\n\"%s\"",
 				selected_object);
 			ok_dialog_open(parentShell, dialog_message);
 		}
 		free(selected_object);

 	}
 	return(fcpath);
}


/***************************************************************
 *
 * Procedure random_pkroot
 *
 * Last modified: 20.02.95
 *
 ***************************************************************/
#ifdef __STDC__

static PKRoot *random_pkroot(
	Boolean		random
)

#else

static PKRoot *random_pkroot(
	random
)
Boolean		random;

#endif
{
	PKRoot			*pkroot = NULL;
	char			*selected_object;
	void			*opaque;
	ObjId			opaque_oid;
	ObjId			*listofobjid[2];
	
	listofobjid[0] = PKRoot_OID;
	listofobjid[1] = NULL;
	

	if (!random) pkroot = af_pse_get_PKRoot();
 	else {
 		
 		if (! (selected_object = pseobjselection_open(parentShell,
 				"Select a PSE-Object of the type\n * PKRoot",
 				listofobjid, FALSE)) ) {
 			return(NULL);
 		}
 						
 		if (opaque = af_pse_get(selected_object, &opaque_oid)) {
 			
 			/* object is pkroot */
 			if (!aux_cmp_ObjId(&opaque_oid, PKRoot_OID)) {
 			 	pkroot = aux_cpy_PKRoot((PKRoot *)opaque);
 			}
 				
 			af_pse_free(&opaque, &opaque_oid);
 			aux_free2_ObjId(&opaque_oid);
 		}
 				
 		/* unable to read object from PSE */			
 		else {
 			
 			sprintf(dialog_message,
 				"Can't read object from PSE:\n\"%s\"",
 				selected_object);
 			ok_dialog_open(parentShell, dialog_message); 				
 		}
 		free(selected_object);	
 	}
 	return(pkroot);
}


/***************************************************************
 *
 * Procedure verify
 *
 * Last modified: 16.01.95
 *
 ***************************************************************/
#ifdef __STDC__

static void verify()

#else

static void verify()

#endif
{
	THINK_CURSOR();
	
	if(open_write_tempfile(applicationShell) >= 0){
                if (!(verify_status.allcerts = aux_create_Certificates(	verify_status.cert,
                							verify_status.fcpath))){
			ok_dialog_open(parentShell, "Can't create Certificates.");
			verify_status_free();
			close_tempfile();
			remove_tempfile();
			READY_CURSOR();
			return;
		}
			
		fprintf(logfile, " ________________________________________________\n");
		fprintf(logfile, "|                                                |\n");
		fprintf(logfile, "|               Verify Certificate               |\n");
		fprintf(logfile, "|________________________________________________|\n\n");

                print_keyinfo_flag = ALGID;
                
		af_chk_crl		= verify_status.chk_crl;
		af_access_directory	= verify_status.access_directory;
		
		if(af_verify_Certificates(	verify_status.allcerts,
					 	verify_status.time,
					  	verify_status.pkroot) < 0){
			if(verifresult)
				aux_fprint_VerificationResult(logfile, verifresult);
			aux_fprint_error(logfile, error_verbose);
			fprintf(logfile, "\n !!! Verification  f a i l e d !!!\n");
		}
		else{
			aux_fprint_VerificationResult(logfile, verifresult);
		}
		
		verify_status_free();									
		close_tempfile();
		start_editor();
		remove_tempfile();
	} 
	
	READY_CURSOR();
}


/***************************************************************
 *
 * Procedure verify_status_free
 *
 * Last modified: 16.01.95
 *
 ***************************************************************/
#ifdef __STDC__

static void verify_status_free()

#else

static void verify_status_free()

#endif
{
	if(verifresult) aux_free_VerificationResult(&verifresult);
	if(verify_status.cert) aux_free_Certificate(&verify_status.cert);
	if(verify_status.pkroot) aux_free_PKRoot(&verify_status.pkroot);
	if(verify_status.fcpath) aux_free_FCPath(&verify_status.fcpath);
	if(verify_status.allcerts) aux_free_Certificates(&verify_status.allcerts);
}
