# ./src/util/xmsectool/xmsectool.make

#
# $Id: xmsectool.make,v 1.25 1995/03/13 14:29:40 nuessler Exp $
#
# $Log: xmsectool.make,v $
#

#*******************************************************************
# Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
#                                                                  *
#                                                                  *
#                         NOTICE                                   *
#                                                                  *
#    Acquisition, use, and distribution of this module             *
#    and related materials are subject to restrictions             *
#    mentioned in each volume of the documentation.                *
#                                                                  *
#*******************************************************************

MODULE = util/xmsectool

.SUFFIXES: .c .o .p .uil .uid


DD         = ../


ST_IFLAGS   = $(IFLAGS) $(DMOTIFINCLUDE)
ST_LDFLAGS  = 
ST_LDLIBS   = $(LIB) $(DMOTIFLIB) 

ST_DFLAGS   = $(DFLAGS) $(DMOTIFRELEASE)
ST_CFLAGS   = $(CFLAGS)


SECTOOL		= xmst
SECTOOLSRC	= xmst.c init.c util.c maintain.c dialogs.c clipboard.c st_init.c st_shell.c \
                  ae_init.c ae_dialog.c d5_init.c d5_dialog.c su_init.c su_dialog.c verificate.c \
                  pse_objsel_box.c
SECTOOLOBJS	= $(SECTOOLSRC:.c=.o)
SECTOOLPUREOBJS	= $(SECTOOLSRC:.c=.p)
SECTOOLINCLUDES = xmst.h prototypes.h version.h dialogs.h clipboard.h \
		  st_shell.h ae_dialog.h d5_dialog.h su_dialog.h st_callb.h ae_callb.h \
		  d5_callb.h su_callb.h st_prototypes.h ae_prototypes.h d5_prototypes.h \
		  su_prototypes.h
SECTOOLUILMAIN	= xmst.uil
SECTOOLUIL	= xmst.uil dialogs.uil values.uil args.uil callb.uil icons.uil help.uil version.uil \
                  st_shell.uil st_values.uil st_args.uil st_callb.uil \
                  ae_dialog.uil ae_values.uil ae_args.uil ae_callb.uil \
                  d5_dialog.uil d5_values.uil d5_args.uil d5_callb.uil \
                  su_dialog.uil su_values.uil su_args.uil su_callb.uil \
                  strings.uil

PGM	= xmst
UID	= xmst.uid
AD	= $(LIBDIR)/X11/XMst
INFO	= $(LIBDIR)/X11/xmst.info
START	= xmst_start
POPUP	= popup_xterm
WRAP	= wrap_xterm


PURIFYOPTIONS = -always-use-cache-dir=yes
PURECOVOPTIONS = -always-use-cache-dir=yes
PURE_CC = purify $(PURIFYOPTIONS) purecov $(PURECOVOPTIONS) $(CC)



.c.o:;		$(CC) -c $*.c $(ST_CFLAGS) $(ST_DFLAGS) $(ST_IFLAGS)


#
# ALL
#

all:            make
make:    	$(PGM) $(UID) $(AD) $(INFO) $(START) $(POPUP) $(WRAP)
		@touch make

version:
		@touch version.h
		@touch version.uil
		@make all

#
# TARGETS
#

xmst.c:		version.h
		@touch xmst.c
		
xmst.uid:	$(SECTOOLUIL)
		touch $@
		$(UIL) -o xmst.uid $(UILFLAGS) $(SECTOOLUILMAIN)
		cp xmst.uid $(LIBDIR)/X11

xmst:		$(SECTOOLOBJS)
		$(CC) -o $@ $(SECTOOLOBJS) $(ST_LDFLAGS) $(ST_LDLIBS)
		@cd ../../../bin; rm -f $@; ln ../src/util/xmsectool/$@ .
		
xmst_start:	xmst_start.sh	
		cp xmst_start.sh xmst_start
		@cd ../../../bin; rm -f $@; ln ../src/util/xmsectool/$@ .

popup_xterm:	popup_xterm.sh	
		cp popup_xterm.sh popup_xterm
		@cd ../../../bin; rm -f $@; ln ../src/util/xmsectool/$@ .

wrap_xterm:	wrap_xterm.sh	
		cp wrap_xterm.sh wrap_xterm
		@cd ../../../bin; rm -f $@; ln ../src/util/xmsectool/$@ .

$(LIBDIR)/X11/xmst.info:	xmst.info	
		cp xmst.info $(LIBDIR)/X11
		
$(LIBDIR)/X11/XMst:	XMst.ad	
		cp XMst.ad $(LIBDIR)/X11/
		mv $@.ad $@
		

#
# NEW
#
		
clean:
		@rm -f *.o *.bak *.uid *% core $(PGM) *.i
		@rm -f xmst_start popup_xterm wrap_xterm
		@touch xmst.info XMst.ad

xmst.pure:	$(SECTOOLOBJS)
		$(PURE_CC) -o $@ $(SECTOOLOBJS) $(ST_LDFLAGS) $(ST_LDLIBS)


