/* ./src/util/xmsectool/xmst.h */

/*
 * $Id: xmst.h,v 1.20 1995/03/14 17:16:50 koletzki Exp $
 *
 * $Log: xmst.h,v $
 * #endif
 *                          inserted
 *
 * Revision 1.17  1995/01/13  13:17:40  koletzki
 * *** empty log message ***
 *
 * Revision 1.16  1994/12/22  13:10:52  koletzki
 * *** Version XMST 1.1b ***
 *
 * Revision 1.15  1994/12/20  18:05:17  koletzki
 * improved & bugfixed:
 *
 * 	configuration
 * 	properties
 * 	clipboard
 *
 * Revision 1.14  1994/12/15  17:26:52  nuessler
 * Included:
 * - struct of xmst-shells with certain options
 * - array of this struct
 * - inititalize the array
 *
 * Revision 1.13  1994/12/09  16:58:42  nuessler
 * There is an nicer and better busy - and think
 * Cursor function called setCursor
 *
 * Revision 1.12  1994/12/09  15:23:25  koletzki
 * *** empty log message ***
 *
 * Revision 1.11  1994/12/02  14:36:49  nuessler
 * *** empty log message ***
 *
 * Revision 1.10  1994/11/24  18:15:56  koletzki
 * *** empty log message ***
 *
 * Revision 1.9  1994/11/22  11:08:25  koletzki
 * *** empty log message ***
 *
 * Revision 1.8  1994/11/11  13:32:52  koletzki
 * using af_x500_check now
 *
 * Revision 1.7  1994/11/09  13:10:20  koletzki
 * *** empty log message ***
 *
 * Revision 1.6  1994/11/08  16:34:38  koletzki
 * clipboard functions in clipboard.c
 *
 * Revision 1.5  1994/11/02  10:44:39  surkau
 * Header replaced by Id
 *
 * Revision 1.4  1994/11/02  09:39:08  surkau
 * SecuDE-4.4.a0
 *
 *
 */
 
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#ifndef XMST_H
#define XMST_H


/*
 *	Defines
 */
#define NL '\012'
#define ALL 6
#define ENC 5
#define TIMELEN 40
#define OPEN_TO_READ	0
#define OPEN_TO_WRITE	1

/* to avoid re-declarations of bcopy & friends */
#ifdef __STDC__
#define X_USEBFUNCS
#endif


/*
 *	System Includes
 */
#include <stdio.h>
#include <sys/param.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>

#include "sec_config.h"

/*
 *	Motif Includes (include them before SecuDE stuff!)
 */
#include <Xm/XmAll.h>		/* Motif Toolkit */
#ifdef MOTIF121			/* Motif Resource Manager */
#include <Mrm/Mrm.h>
#else
#ifdef MOTIF122
#include <Mrm/MrmAppl.h>
#else
#include <___NO_MOTIF_RELEASE_DEFINED___>
#endif
#endif

/* This one is not publicly defined in my Motif 1.2.1 ! */
#ifndef XmCR_PROTOCOLS
#define XmCR_PROTOCOLS 6666
#endif


/*
 *	SecuDE Includes
 */
#include "af.h"
#include "cadb.h"
#ifdef MFCHECK
#include "MF_check.h"
#endif

/*
 *	SecTool Includes
 */
#include "dialogs.h"
#include "clipboard.h"
#include "st_shell.h"
#include "ae_dialog.h"
#include "d5_dialog.h"
#include "su_dialog.h"

/*
 ******************************
 *	Motif Declaration Stuff
 ******************************
 */

/*
 *	Resource data base
 */
extern XrmDatabase	config_database;

/*
 *	Self defined resources
 */
#define XmstNbusycursor		"busycursor"
#define XmstNthinkcursor	"thinkcursor"
#define XmstNfocuscolor		"focuscolor"
#define XmstNactivelistcolor	"activelistcolor"

struct applrestype {
	Cursor		busycursor;
	Cursor		thinkcursor;
	Pixel		focuscolor;
	Pixel		activelistcolor;
};
typedef struct applrestype ApplResType;

/* global variables that contain resource values */
extern ApplResType	applResources;
extern char		*external_editor;
extern char		*print_command;
extern Pixel		focus_color;
extern Pixel		active_list_color;

/* LIST_CLIENT_DATA type for pk/ek-list */
struct pklistclientdata {				
	DName		*subject;
	DName		*issuer;
	OctetString	*serial;
};
typedef struct pklistclientdata PKList_client_data;

/*
 *	LIST CLIENT DATA type
 *	This is my quick & dirty solution for an XmList item client data structure.
 */
extern XtPointer	pselist_clientdata[];
extern XtPointer	pklist_clientdata[];
extern XtPointer	eklist_clientdata[];
extern XtPointer	pcalist_clientdata[];
extern XtPointer	aliaslist_clientdata[];

/*
 *	UIL
 */
extern MrmHierarchy	applicationHierarchy;
extern char		*applicationUidVector[];
extern MrmType		opaqueClass;
extern int		*keysizeScaleMinimum;
extern int		*keysizeScaleMaximum;

/* 
 *	Xmst Shells
 */
 
typedef struct{	
		Widget	widget;
		String	name;
		Boolean	cursor;
		Boolean	resizable;
		Boolean	managed;
		String	geometry;
} XmstShells;

extern XmstShells xmstshells[];

 
/*
 *	Display/Screen/Shells/Widgets
 */
extern Display		*display;
extern Screen		*screen;
extern XtAppContext	applicationContext;
extern Widget		applicationShell;


/*
 *	Args, Flags, Vectors
 */
extern int 		xmst_argc;
extern char 		**xmst_argv;
extern char 		*argPSEName;
extern char 		*argCAName;
extern Boolean		debugmode_on;
extern Boolean		Debug;
extern Boolean		auto_save_configuration;
extern Boolean		auto_detect_sct;
extern Boolean		use_external_editor;
extern Boolean		alias_save_required;
extern Boolean		beep_on_error;
extern Boolean		cryptoClipboard;
extern Boolean 		verbose;
extern Boolean 		sectool_verbose;
extern int		error_verbose;
extern char		*unix_home;
extern char		*editor_tempfile;
extern char		*guide_file;
extern char		*config_rcfile;
extern char		*d5bwr_tempfile;
extern char		dialog_message[];
extern char		*alias_to_add;
extern char		*alias_message[];
extern int		pin_failure_count;
extern char		dialog_pin[];
extern Boolean		dialog_finished;
extern Boolean		dialog_ok;




/*
 *	Macros
 */

#define STWIDGET(s)		name2widget(applicationShell, s)		

#define ADWIDGET(s)		name2widget(aliasDialog, s)

#define CPDSTRING(s)		XmStringCreateLtoR(s, XmSTRING_DEFAULT_CHARSET)
#define CPDSTRINGFIXED(s)	XmStringCreateLtoR(s, "listFixedFont")
#define CPDSTRINGBOLD(s)	XmStringCreateLtoR(s, "listFixedBoldFont")
#define ALARM()			if (beep_on_error) XBell(display, 1);
#define ALARM3()		if (beep_on_error) { XBell(display, 1); XBell(display, 1); XBell(display, 1); }
#define BUSY_CURSOR()		{ setCursor(TRUE, 'b', NULL); }
#define IDLE_CURSOR()		{ setCursor(FALSE, 'b', NULL); }
#define THINK_CURSOR()		{ setCursor(TRUE, 't', NULL); }
#define READY_CURSOR()		{ setCursor(FALSE, 't', NULL); }
#define _BUSY_CURSOR(w)		{ setCursor(TRUE, 'b', w);}
#define _IDLE_CURSOR(w)		{ setCursor(FALSE, 'b', w); }
#define _THINK_CURSOR(w)	{ setCursor(TRUE, 't', w); }
#define _READY_CURSOR(w)	{ setCursor(FALSE, 't', w); }

#define MANAGE_DIALOG(w)	  { XRaiseWindow(display, XtWindow(XtParent(XtParent(XtParent(w)))));	\
				    setManaged(w);						\
				    XtManageChild(w);						}
#define MANAGE_MODELESS_DIALOG(w) { XRaiseWindow(display, XtWindow(XtParent(w)));		\
				    setManaged(w);						\
				    XtManageChild(w);						}

/*
 *	Global defs & decs
 */
#define XMST_PID			(long)getpid()	/* current process id */
#define XMST_ARGS			11		/* Size of global Arg vector for single XSetValues */
#define XMST_PIN_LENGTH			222		/* Size of passwords */
#define XMST_PIN_FAILURES		3		/* you have three trials to enter ... */
#define XMST_SC_OBJECT			1		/* object is from sc */
#define XMST_PSE_OBJECT			2		/* object is from sw-pse */
#define XMST_MAX_LIST_ITEMS		444		/* number of list entries */
#define XMST_MAX_ALIAS_LIST_ITEMS	XMST_MAX_LIST_ITEMS - 1		/* number of alias list entries */
#define XMST_MAX_OTHERALIASES		111		/* number of other aliases in selection box */
#define XMST_PSELISTSTR_LENGTH		111		/* list string properties */
#define XMST_PKLISTSTR_LENGTH		111
#define XMST_PKSERIAL_LENGTH		15 		/* max. characters for Serialnumber in pklist */
#define XMST_PKSERIAL_NOCTETS		10 		/* max. number of octets that can be displayed */

#define XMST_ALIASLISTSTR_LENGTH	222

#define XMST_NONE			0
#define XMST_ALIAS_USER			1
#define XMST_ALIAS_SYSTEM		2
#define XMST_ALIAS_BOTH			3				
#define XMST_ALIAS_LOCALNAME		1		/* alias_type_setting values (index) */
#define XMST_ALIAS_RFCMAIL		2				
#define XMST_ALIAS_NEXTBEST		3				
#define XMST_ALIAS_X400MAIL		4	

#define XMST_TEMP_FILE			".st_txt_tmp"
#define D5BWR_TEMPFILE  		".xmst-tmp-d5"
#define XMST_GUIDE_FILE			"xmst.info"
#define XMST_CONFIG_FILE		".xmstrc"
#define XMST_LOCAL_SECUDE		"/usr/local/secude"
#define XMST_LIB_X11			"lib/X11"

#define XMST_DEFAULT_EDITOR		"xedit"
#define XMST_DEFAULT_PRINTCMD		"lp -sc"



/*
 *******************************
 *	SecuDE Declaration Stuff
 *******************************
 */


typedef enum {
       ADDALIAS, ADDEK, ADDPCA, ADDPK, ALGS, ALIAS2DNAME, ALIASES,
#ifdef X500
       AUTHNONE, AUTHSIMPLE,
#ifdef STRONG
       AUTHSTRONG,
#endif
#endif
       CACRL, CAPRINTLOG, CASERIALNUMBERS, CAUSERS, CERTIFY,
       CERT2KEYINFO, CERT2PKROOT, CHECK, CHPIN, CLOSE, CREATE, DELALIAS, DELEK, DELETE,
       DELKEY, DELPCA, DELCRL, DELPK, DH1, DH2, DHINIT, DNAME2ALIAS,
#ifdef SCA
       EJECT,
#endif
       ENDE, ENTER, ERROR, EXIT, GENKEY, HELPCMD, INITCRL, ISSUEDCERTIFICATE, KEYTOC,
       MFLIST,
       OPEN, OWNER, PROLONG, PROTOTYPE, QM, QUIT, READ, REMOVE,
       RENAME, RESETERROR, RETRIEVE, REVOKE, SETPARM, SETSERIAL, SHOW,
       SPLIT, STRING2KEY, TOC,
#ifdef SCA
       TOGGLE,
#endif
       TRUSTPATH, VERBOSE, VERIFY, WRITE, XDUMP
} Command;


typedef enum {
	GEN_SYM,
	GEN_PUBLIC,
	GEN_SECRET
} KeygenAction;


extern	Command     		cmd;
extern	Boolean 		replace;
extern	char    		inp[256];
extern	char    		* cmdname, * helpname, * filename, * pin, * newpin, * algname, * objtype, * attrname;
extern	CertificateType 	certtype;
extern	KeyRef  		keyref;
extern	Key     		*key, *publickey, *secretkey;
extern	Boolean 		interactive;
extern	char 			*pname, *ppin;
extern	int 			pkeyref;
extern	char			*newstring;
extern	int            		fd1, fd2, fdin;
extern	int             	i, anz, n, k, algtype, found;
extern	time_t          	atime, etime;
extern	char	        	x500;
extern	Boolean         	update, create, replace_afdb_cert;
extern	char            	*enc_file, *plain_file, *tbs_file, *sign_file, *hash_file;
extern	char            	*buf1, *buf2, *ii, *xx;
extern	char            	*par, *dd, *ptr, *cc, *afname, *newname, *objname, *number;
extern	char	        	*pgm_name;
extern	char 	        	*revlistpempath;
extern	char            	*pse_name, *pse_path, *ca_dir, *home;
extern	char            	*last_pse_name, *last_ca_dir;
extern	RC              	rcode_dir, rcode_afdb, rcode;
extern	OctetString     	octetstring, *ostr, *objectvalue, *tmp_ostr;
extern	ObjId    		*object_oid, oid;
extern	AlgId           	*algid;
extern	BitString       	bitstring, *bstr;
extern	HashInput       	hashinput;
extern	KeyInfo         	tmpkey, *keyinfo, *signpk, *encpk, session_key;
extern	FCPath          	*fcpath;
extern  Certificate          	*fcpath_cert;
extern	PKList          	*pklist;
extern	PKRoot          	*pkroot;
extern	Certificate     	*certificate;
extern	Certificates    	*certs;
extern	ToBeSigned 		*tbs;
extern	SET_OF_Certificate 	*certset, *soc, *tmp_soc;
extern	CertificatePair 	*cpair;
extern	SET_OF_CertificatePair 	*cpairset;
extern	SEQUENCE_OF_CRLEntry 	*revcertpemseq;
extern	Crl			* crlpse;
extern	CrlSet      		* crlset;
extern	Name            	*name, *alias, * issuer, * subject;
extern	DName			* dname, * issuer_dn, * subject_dn, * own_dname, * signsubject, * encsubject;
extern	EncryptedKey    	encryptedkey;
extern	rsa_parm_type   	*rsaparm;
extern	KeyType         	ktype;
extern	AlgEnc          	algenc;
extern	PSESel  		std_pse;
extern	PSESel          	*pse_sel;
extern	PSEToc          	*psetoc, *sctoc;
extern	struct PSE_Objects 	*pseobj;
extern	OctetString		* serial;
extern	SET_OF_IssuedCertificate *isscertset;
extern	SET_OF_Name		*nameset;
extern	UTCTime 		*lastUpdate, *nextUpdate;	
extern	FILE            	*logfile;
extern	AlgList         	*a;
extern	Boolean         	onekeypaironly;
extern	AliasFile		aliasfile;
extern	AliasList               * aliaslist;
extern  PSELocation 		pse_location;

#ifdef X500
extern	int 		 	dsap_index;
extern	char			*callflag;
extern DName 			* directory_user_dname; 
extern int     			count;			
extern char 			** vecptr;   	
extern int     			af_dir_authlevel;	
extern char     		*env_af_dir_authlevel;		
#endif

#ifdef SCA
extern int			SCapp_available;		
#endif

extern char 			*passwd; 	/* store user-typed passwd here. */
extern Boolean			start_with_configuration;

extern	Key     		*clipboard_sessionkey;
	
/*
 *	xmst Includes
 */
#include "prototypes.h"
#include "version.h"
 
/*** end xmst.h ***/
#endif
 



